@extends('admin::shared.layout')
@section('layout')
<div class="form-admin">
    <div class="form-bg"></div>
    <form id="form" class="form-wrapper" action="{!! route('admin-partner-save', request('id'))!!}" method="POST"
        enctype="multipart/form-data">
        <div class="form-header">
            <h3>
                Partner
            </h3>
        </div>
        {{ csrf_field() }}
        <div class="form-body">
            <div class="row-2">
                <div class="form-row">
                    <label>Name<span>*</span></label>
                    <input type="text" name="name" placeholder=""
                        value="{!! request('id') ? $data->name : old('name') !!}">
                    @error('name')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
                <div class="form-row">
                    <label>Status<span>*</span></label>
                    <select name="status" id="">
                        <option value="1" {{request('id') && $data->status == 1 ? 'selected' : old('status')}}>Active
                        </option>
                        <option value="1" {{request('id') && $data->status == 2 ? 'selected' : old('status')}}>Disable
                        </option>
                    </select>
                    @error('title')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
            </div>
            <div class="row-2">
                <div class="form-row">
                    <label>Phone<span>*</span></label>
                    <input type="string" placeholder="(+855) 00 00 00 00" name="phone"
                        value="{!! request('id') ? $data->phone : old('phone') !!}">
                    @error('phone')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
            </div>
            <div class="row-2">
                <div class="form-row flex-row">
                    <label for="international">International brand</label>
                    <input style="height: 20px; width: auto" type="checkbox" name="international" id="international"
                        value="1" {{request('id') && $data->international == 1 ? 'checked' : ''}}>
                </div>
            </div>
            <div class="row-2">
                <div class="form-row">
                    <label>Address<span>*</span></label>
                    <textarea style="min-height: 100px;"
                        name="address">{!! request('id') ? $data->address : old('address') !!}</textarea>
                    @error('address')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
            </div>
            <div class="row-2">
                <div class="form-row">
                    <label>Google Map URL Embed</label>
                    <textarea style="min-height: 300px;"
                        name="google_map">{!! request('id') ? $data->google_map : old('google_map') !!}</textarea>
                    @error('google_map')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
                <div class="form-row">
                    <label>Image</label>
                    <div class="form-select-photo image">
                        <div
                            class="select-photo {!! request('id') && isset($data) && $data->image != null ? 'active' : '' !!}">
                            <div class="icon">
                                <i data-feather="image"></i>
                            </div>
                            <div class="title">
                                <span>@lang('user.form.profile.placeholder')</span>
                            </div>
                        </div>
                        <div
                            class="image-view {!! request('id') && isset($data) && $data->image != null ? 'active' : '' !!}">
                            <img src="{!! request('id') && isset($data) && $data->image != null ? asset('file_manager' . $data->image) : null !!}"
                                onerror="(this).src='{{ asset('images/logo/default.png') }}'" alt="">
                        </div>
                        <input type="text" name="image" s-click-fn="selectImage(event)" autocomplete="off"
                            role="presentation">
                        <input type="hidden" name="tmp_file"
                            value="{!! request('id') && isset($data) && $data->image != null ? $data->image : '' !!}">
                    </div>
                </div>
            </div>
            <div class="form-button">
                <button type="submit" color="primary">
                    <i data-feather="save"></i>
                    <span>Submit</span>
                </button>
                <button color="danger" type="button" s-click-link="{!! route('admin-partner-list', 1) !!}">
                    <i data-feather="x"></i>
                    <span>Cancel</span>
                </button>
            </div>
        </div>
        <div class="form-footer"></div>
    </form>
</div>
@include('admin::file-manager.popup')
@stop
@section('script')
<script>
    $(document).ready(function() {
        $validator("#form", {
            name: {
                required: true,
            },
            phone: {
                required: true,
            },
            address: {
                required: true,
            },
        });
    });
    function selectImage(e) {
            fileManager({
                multiple: false,
                afterClose: (data, basePath) => {
                    if (data?.length > 0) {
                        const parent = e.target.closest('.form-select-photo');
                        e.target.value = data[0].path;
                        parent
                            .querySelector('.select-photo')
                            .classList.add('active');
                        parent
                            .querySelector('.image-view')
                            .classList
                            .add('active');
                        parent
                            .querySelector('.image-view')
                            .childNodes[0]
                            .nextElementSibling
                            .setAttribute('src', basePath + data[0].path);
                    }
                }
            })
        }
</script>
@stop