@extends('admin::shared.layout')
@section('layout')
    <div class="form-admin" x-data="storeDialogGallery">
        <div class="form-bg"></div>
        <form id="form" class="form-wrapper" action="{!! route('admin-lesson-save', request('id')) !!}" method="POST" enctype="multipart/form-data">
            <div class="form-header">
                <h3>
                    <i data-feather="arrow-left" s-click-link="{!! route('admin-lesson-list', 1) !!}"></i>
                    {!! request('id') ? 'Update' : 'Create' !!}
                </h3>
            </div>
            {{ csrf_field() }}
            <div class="form-body">
                <div class="row-2">
                    <div class="form-row">
                        <label>Lesson occupation <span>*</span></label>
                        <select name="lesson_occupation_id">
                            <option value="">Please select lesson occupation</option>
                            @foreach ($occupation as $value)
                                <option
                                    {{ (request('id') && $data->lesson_occupation_id == $value->id) ? 'selected' : (old('lesson_occupation_id') == $value->id ? 'selected' : '') }}
                                    value="{!! $value->id !!}" {!! (request('id') && $data->lesson_occupation_id == $value->id) || old('status') == 1 ? 'selected' : '' !!}>{!! $value->name !!}</option>
                            @endforeach
                        </select>
                        @error('lesson_occupation_id')
                            <span class="error">@lang($message)</span>
                        @enderror
                    </div>
                    <div class="form-row">
                        <label>Competency type<span>*</span> </label>
                        <select name="competency_type">
                            <option value="">Please select competency type of lesson</option>
                            <option value="Generic Competency" {!! (request('id') && $data->competency_type == 'Generic Competency') ? 'selected' : (old('competency_type') == 'Generic Competency' ? 'selected' : '') !!}> Generic Competency</option>
                            <option value="Functional Competency" {!! (request('id') && $data->competency_type == 'Functional Competency') ? 'selected' : (old('competency_type') == 'Functional Competency' ? 'selected' : '') !!}> Functional Competency</option>
                        </select>
                        @error('competency_type')
                            <span class="error">@lang($message)</span>
                        @enderror
                    </div>
                </div>
                <div class="row-2">
                    <div class="form-row">
                        <label>Name<span>*</span> </label>
                        <input type="text" name="name" value="{!! request('id') ? $data->name : old('name') !!}" placeholder="Name">
                        @error('name')
                            <span class="error">@lang($message)</span>
                        @enderror
                    </div>
                    <div class="form-row">
                        <label>Short name<span>*</span></label>
                        <input type="text" name="short_name" value="{!! request('id') ? $data->short_name : old('short_name') !!}" placeholder="Short name"
                            autocomplete="off">
                        @error('short_name')
                            <span class="error">@lang($message)</span>
                        @enderror
                    </div>
                </div>
                <div class="row-2">
                    <div class="row-2">
                        <div class="form-row">
                            <label>Practice Duration<span>*</span><span x-text="practice_hour"></span></label>
                            <input @input="calcTimeOfPractice()" type="number" name="practice_hour" id="practice_hour" value="{!! request('id') ? $data->practice_hour : old('practice_hour') !!}"
                                placeholder="Practice hour" autocomplete="off">
                            @error('practice_hour')
                                <span class="error">@lang($message)</span>
                            @enderror
                        </div>
                        <div class="form-row">
                            <label>Practice Duration Type<span>*</span></label>
                            <select @change="calcTimeOfPractice()" name="practice_duration_type" id="practice_duration_type">
                                <option value="h" {{(request('id') && $data->practice_duration_type == 'h') ? 'selected' : (old('practice_duration_type') == 'h' ? 'selected' : '') }}>Hour</option>
                                <option value="mn" {{(request('id') && $data->practice_duration_type == 'mn') ? 'selected' : (old('practice_duration_type') == 'mn' ? 'selected' : '') }}>Minute</option>
                            </select>
                            @error('practice_duration_type')
                                <span class="error">@lang($message)</span>
                            @enderror
                        </div>
                    </div>
                    <div class="row-2">
                        <div class="form-row">
                            <label>Theory Duration<span>*</span><span x-text="theory_hour"></span></label>
                            <input @input="calcTimeOfTheory()" type="number" name="theory_hour" id="theory_hour" value="{!! request('id') ? $data->theory_hour : old('theory_hour') !!}" placeholder="Theory hour"
                                autocomplete="off">
                            @error('theory_hour')
                                <span class="error">@lang($message)</span>
                            @enderror
                        </div>
                        <div class="form-row">
                            <label>Theory Duration Type<span>*</span></label>
                            <select @change="calcTimeOfTheory()" name="theory_duration_type" id="theory_duration_type">
                                <option value="h" {{(request('id') && $data->theory_duration_type == 'h') ? 'selected' : (old('theory_duration_type') == 'h' ? 'selected' : '') }}>Hour</option>
                                <option value="mn" {{(request('id') && $data->theory_duration_type == 'mn') ? 'selected' : (old('theory_duration_type') == 'mn' ? 'selected' : '') }}>Minute</option>
                            </select>
                            @error('theory_duration_type')
                                <span class="error">@lang($message)</span>
                            @enderror
                        </div>
                    </div>
                </div>
                <div class="row-2">
                    <div class="form-row">
                        <label>Status<span>*</span></label>
                        <select name="status">
                            <option value="1" {!! (request('id') && $data->status == 1) || old('status') == 1 ? 'selected' : '' !!}>@lang('user.form.status.active')</option>
                            <option value="2" {!! (request('id') && $data->status == 2) || old('status') == 2 ? 'selected' : '' !!}>@lang('user.form.status.disable')</option>
                        </select>
                    </div>
                </div>
                <div class="row">
                    <div class="form-row">
                        <label>Video </label>
                        <textarea name="video" rows="5" placeholder="Please input or paste the video link">{!! request('id') ? $data->video : old('video') !!}</textarea>
                        @error('video')
                            <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                </div>
                <div class="row" style="width: 100%">
                    <div class="form-row" style="width: 100%">
                        <label class="mb-3">Document</label>
                        <div class="galleryLayoutGp" style="width: 100%;">
                            <div class="galleryGp"
                                style="width: 100%;grid-gap: 20px; display: grid; grid-template-columns: 1fr 1fr 1fr 1fr;">
                                <template x-if="form.gallery.length > 0">
                                    <template x-for="(item,index) in form.gallery">
                                        <section style="height: 250px; width: 100%; position: relative;">
                                            <template x-if="!isImage(item)">
                                                <a class="imageItem" :href="baseImageUrl + item" target="_blank"
                                                    style="display: block; position: relative;height: 200px; width: 100%;">
                                                    <img src="{{ asset('images/logo/extensions/file.png') }}" alt=""
                                                        style="width: 100%; height: 100%;">
                                                    <p style="text-align: center; width: 100%; height: 50px;margin: 0; overflow: hidden; wite-space: nowrap text-overflow: ellipsis"
                                                        x-text="item.slice(0, 22) + ' ' + item.slice(23, 45)">
                                                    </p>
                                                </a>
                                            </template>
                                            <template x-if="isImage(item)">
                                                <div class="imageItem" data-fancybox :data-src="baseImageUrl + item"
                                                    style="position: relative;height: 200px; width: 100%;">
                                                    <img :src="baseImageUrl + item"
                                                        onerror="(this).src='{{ asset('images/logo/default.png') }}'"
                                                        style="width: 100%; height: 100%;">
                                                    <p style="text-align: center; width: 100%; height: 50px;margin: 0; overflow: hidden; wite-space: nowrap text-overflow: ellipsis"
                                                        x-text="item.slice(0, 22) + ' ' + item.slice(23, 45)">
                                                    </p>
                                                </div>
                                            </template>
                                            <div @click="imageDelete(index)"
                                                style="position: absolute; right: 2px; top: 2px; background: white; border-radius: 50%; cursor: pointer;">
                                                <img src="{{ asset('images/logo/delete.svg') }}" alt=""
                                                    style="width: 100%; height: 100%;">
                                            </div>
                                            <input type="hidden" name="documents[]" :value="item"
                                                autocomplete="off" role="presentation">
                                        </section>
                                    </template>
                                </template>
                                <div @click="selectImageGallery"
                                    style="height: 200px; width: 100%;box-shadow: rgba(0, 0, 0, 0.1) 0px 4px 12px; display: flex; justify-content:center; align-items:center;    flex-direction: column;">
                                    <i data-feather="upload-cloud" style="height: 100px; width: 100px;"></i>
                                    <strong>Click To Upload</strong>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-button">
                    <button type="submit" color="primary">
                        <i data-feather="save"></i>
                        <span>Submit</span>
                    </button>
                    <button color="danger" type="button" s-click-link="{!! route('admin-lesson-list', 1) !!}">
                        <i data-feather="x"></i>
                        <span>Cancel</span>
                    </button>
                </div>
            </div>
            <div class="form-footer"></div>
        </form>
    </div>
    @include('admin::file-manager.popup')
@stop

@section('script')
    <script>
        Alpine.data('storeDialogGallery', () => ({
            form: {
                gallery: [],
            },

            dialogData: null,
            baseImageUrl: "{{ asset('file_manager') }}/",
            validate: null,
            loading: false,
            practice_hour: null,
            theory_hour: null,
            init() {
                feather.replace();
                if (@json(request('id'))) {
                    let data = @json($data?->documents);
                    data.forEach(element => {
                        this.form.gallery.push(element.source);
                    });
                }
            },
            calcTimeOfPractice(){
                let duration_type = $('#practice_duration_type').val();
                this.practice_hour = null;
                if(duration_type == 'h'){
                    let hour = $('#practice_hour').val();
                    if(hour.length > 0){
                        let hourAsInteger = Math.floor(hour);
                        let hourAsDecimal = parseFloat(hour) - parseInt(hourAsInteger);
                        let totalMn = 60;
                        if(hourAsDecimal > 0){
                            let mn = hourAsDecimal * totalMn;
                            this.practice_hour = hourAsInteger + 'H ' + mn.toFixed(0) + 'MN';
                        }else{
                            this.practice_hour = hourAsInteger + 'H';
                        }
                    }else{
                        this.practice_hour = null;
                    } 
                }else{
                    let mn = $('#practice_hour').val();
                    let mnAsHour = 60;
                    if(mn.length > 0){
                        let mnAsInteger = Math.floor(mn); 
                        if(mnAsInteger >= 60){
                            let hour = mnAsInteger/mnAsHour;
                            let hourAsInteger = Math.floor(hour);
                            let mn = mnAsInteger % mnAsHour;
                            this.practice_hour = hourAsInteger + 'H ';
                            if(mn > 0){ 
                                this.practice_hour += mn + 'MN';
                            }
                        }else{
                            this.practice_hour = mnAsInteger + 'MN';
                        }
                    }else{
                        this.practice_hour = null;
                    } 
                }
            },
            calcTimeOfTheory(){
                let duration_type = $('#theory_duration_type').val();
                this.theory_hour = null;
                if(duration_type == 'h'){
                    let hour = $('#theory_hour').val();
                    if(hour.length > 0){
                        let hourAsInteger = Math.floor(hour);
                        let hourAsDecimal = parseFloat(hour) - parseInt(hourAsInteger);
                        let totalMn = 60;
                        if(hourAsDecimal > 0){
                            let mn = hourAsDecimal * totalMn;
                            this.theory_hour = hourAsInteger + 'H ' + mn.toFixed(0) + 'MN';
                        }else{
                            this.theory_hour = hourAsInteger + 'H';
                        }
                    }else{
                        this.theory_hour = null;
                    } 
                }else{
                    let mn = $('#theory_hour').val();
                    let mnAsHour = 60;
                    if(mn.length > 0){
                        let mnAsInteger = Math.floor(mn); 
                        if(mnAsInteger >= 60){
                            let hour = mnAsInteger/mnAsHour;
                            let hourAsInteger = Math.floor(hour);
                            let mn = mnAsInteger % mnAsHour;
                            this.theory_hour = hourAsInteger + 'H ';
                            if(mn > 0){ 
                                this.theory_hour += mn + 'MN';
                            }
                        }else{
                            this.theory_hour = mnAsInteger + 'MN';
                        }
                    }else{
                        this.theory_hour = null;
                    } 
                }
            },
            isImage(file) {
                const imageExtensions = ["jpg", "jpeg", "png", "gif", "bmp", 'jfif', 'webp', 'tiff', 'svg',
                    'ico', 'heic'
                ];
                const extension = file.split(".").pop().toLowerCase();
                return imageExtensions.includes(extension);
            },
            selectImageGallery() {
                fileManager({
                    multiple: true,
                    afterClose: (data, basePath) => {
                        if (data?.length > 0) {
                            data.map((item) => {
                                this.form.gallery.push(item.path);
                            });
                            console.log(this.form.gallery);
                        }
                    }
                });
            },
            imageDelete(index) {
                this.form.gallery.splice(index, 1);
                console.log(this.form.gallery, 'gallery');
            },
        }));
    </script>
    <script lang="ts">
        $(document).ready(function() {
            $validator("#form", {
                lesson_occupation_id: {
                    required: true,
                },
                competency_type: {
                    required: true,
                },
                name: {
                    required: true,
                },
                short_name: {
                    required: true,
                },
                practice_hour: {
                    required: true,
                },
                theory_hour: {
                    required: true,
                },
                status: {
                    required: true
                }
            });
        });
    </script>
@stop
