<div class="content-body d-flex flex-column overflow-auto mt-3">
    <div id="student-internship-place" class="bg-white mb-3">
        <div id="student-list" class="form-body p-3 mt-3">
            <h2 class="mt-0">
                {!! strtoupper('Groups in class') !!}
            </h2>
            <div class="row d-flex align-items-center justify-content-between">
                <div>
                    <span>
                        {{strtoupper('selected class id: ').request('class_id')}}
                    </span>
                    <br />
                    <span>
                        {{strtoupper('group in class count: '). count($data)}}
                    </span>
                </div>
                <div>
                    @can('group-create')
                    <button class="btn-create bg-primary mr-2" @click="dialogCreateGroup()">
                        <span>{!! strtoupper('create new group') !!}</span>
                    </button>
                    @endcan
                </div>
            </div>
            <div class="row">
                <div class="table">
                    <div class="table-wrapper">
                        <div class="table-header bg-black text-light">
                            <div class="row table-row-10">
                                <span class="font-sm">{!! strtoupper('Group ID') !!}</span>
                            </div>
                            <div class="row table-row-20">
                                <span class="font-sm">{!! strtoupper('Group name') !!}</span>
                            </div>
                            <div class="row table-row-20">
                                <span class="font-sm">{!! strtoupper('Created on') !!}</span>
                            </div>
                            <div class="row table-row-20">
                                <span class="font-sm">{!! strtoupper('Student in') !!}</span>
                            </div>
                            <div class="row table-row-30">
                                <span class="font-sm">{!! strtoupper('Action') !!}</span>
                            </div>
                        </div>
                        <div class="table-body overflow-auto">
                            @foreach($data as $item)
                            <div class="column">
                                <div class="row table-row-10">
                                    <span>{{$item->id ?? '--'}}</span>
                                </div>
                                <div class="row table-row-20">
                                    <span>{{ $item->name ?? '--' }}</span>
                                </div>
                                <div class="row table-row-20">
                                    <span>{{ $item->created_at->format('Y-m-d') ?? '--'}}</span>
                                </div>
                                <div class="row table-row-20">
                                    <span>
                                        {{ $item->students ? count($item->students) : '--'}}
                                    </span>
                                </div>
                                <div class="row table-row-30 h-100 d-flex justify-content-center align-items-center">
                                    @canany(['group-view-info', 'group-assign', 'group-unassign', 'group-destroy'])
                                    @canany(['group-view-info'])
                                    <span class="font-sm h-50 mr-2">
                                        <button class="btn-create bg-success h-100"
                                            @click="dialogOpenViewInfo({{$item->id}})">
                                            <span>{!!
                                                strtoupper('View') !!}</span>
                                        </button>
                                    </span>
                                    @endcan
                                    @canany(['group-assign', 'group-unassign'])
                                    <span class="font-sm h-50 mr-2">
                                        <button class="btn-create bg-primary h-100"
                                            @click="dialogUnAssignOpen({{request('class_id')}}, {{$item->id}})">
                                            <span>{!!
                                                strtoupper('un/Assign') !!}
                                            </span>
                                        </button>
                                    </span>
                                    @endcan
                                    @can('group-destroy')
                                    <span class="font-sm h-50">
                                        <button class="btn-create bg-danger h-100" onclick="$onConfirmMessage(
                                            '{!! route('admin-group-delete', $item->id) !!}',
                                            'Are you sure to delete {{$item->name}}?',
                                            {
                                                confirm: '@lang('dialog.button.ok')',
                                                cancel: '@lang('dialog.button.cancel')'
                                            },
                                        );">
                                            <span>
                                                {!! strtoupper('Delete') !!}
                                            </span>
                                        </button>
                                    </span>
                                    @endcan
                                    @endcan
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>