@extends('admin::shared.layout')
@section('layout')
<div class="content-wrapper" x-data="xGroup">
    <div class="header">
        @include('admin::shared.header', ['header_name' => 'Student Group'])
        <div class="header-tab">
            <div class="header-tab-wrapper">
                <div class="menu-row">
                    <div class="menu-item">
                        <a href="{{route('admin-class-view-info', request('class_id'))}}">
                            {{strtoupper('Class view info')}}
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @include('admin::pages.group.table')
    @include('admin::pages.group.modal.create')
    @include('admin::pages.group.modal.un-assign')
    @include('admin::pages.group.modal.view-info')
    <template x-if="loading">
        <div class="loading">
            <div class="sub-loading">
                <div class="loadingCus loadingCenter m-0 p-0 h-100 align-items-center flex-column" x-show="loading">
                    <div class="loaderSpinnerVer1"></div>
                    <div>Loading...</div>
                </div>
            </div>
        </div>
    </template>
</div>
@stop

@section('script')
<script lang="ts">
    $(document).ready(function() {
        $validator("#form", {
            name: {
                required: true,
            },
        });
    });
</script>
<script>
    Alpine.data('xGroup', () => ({
        dialogOpen: false,
        dialogAssignOpen: false,
        groupId : null,
        loading: false,
        students: [],
        studentInGroup: [],
        dialogViewInfo: false,
        async dialogOpenViewInfo(group_id){
            if(this.dialogViewInfo == false){
                this.loading = true;
                this.groupId = group_id;
                await this.fetchStudentInGroup(group_id, (res)=>{
                    this.studentInGroup = res;
                });
                this.dialogViewInfo = true;
                this.loading = false;
            }else {
                this.dialogViewInfo = false;
            }
        },
        dialogCreateGroup(){
            this.dialogOpen = !this.dialogOpen;
        },
        async fetchStudentInGroup(group_id, callback) {
            await Axios({
                url: `{{route('admin-group-students')}}`,
                method: 'GET',
                params: {'group_id': group_id},
            }).then((response)=>{
                callback(response.data);
            }).catch((err)=> {
                console.log(err);
            });
        },
        async dialogUnAssignOpen(class_id, group_id) {
            if(this.dialogAssignOpen == false){
                this.loading = true,
                this.groupId = group_id;
                await this.fetchStudentGroup(class_id, (res) => {
                    this.students = res;
                });
                this.dialogAssignOpen = true;
                this.loading = false;
            }else{
                this.dialogAssignOpen = false;
                    window.location.reload();
            }
        },
        async fetchStudentGroup(class_id, callback) {
            await Axios({
                url: `{{route('admin-group-student')}}`,
                method: 'GET',
                params: {'class_id': class_id},
            }).then((response)=>{
                callback(response.data);
            }).catch((err)=> {
                console.log(err);
            });
        },
        async assignStudentToGroup(student_id, class_id){
            this.loading = true;
            await Axios({
                url: `{{route('admin-group-assign')}}`,
                method: 'POST',
                params: {
                    group_id: this.groupId,
                    student_id: student_id,
                }
            }).then((response) => {
                if (response.data.code == 20000) {
                    // window.location.reload();
                    Toast({
                        title: 'Success Message',
                        message: response.data.message,
                        status: 'success',
                        duration: 5000,
                    });
                }else{
                    Toast({
                        title: 'Warning Message',
                        message: response.data.message,
                        status: 'warning',
                        duration: 5000,
                    });
                }
            }).catch((err)=> {
                console.log(err);
            });
            await this.fetchStudentGroup(class_id, (res) => {
            this.students = res;
            });
            this.loading = false;
        },
        async unassignStudentToGroup(student_id, class_id){
            this.loading = true;
            await Axios({
                url: `{{route('admin-group-unassign')}}`,
                method: 'POST',
                params: {
                    group_id: this.groupId,
                    student_id: student_id,
                }
            }).then((response) => {
                if (response.data.code == 20000) {
                    // window.location.reload();
                    Toast({
                        title: 'Success Message',
                        message: response.data.message,
                        status: 'success',
                        duration: 5000,
                    });
                }else{
                    Toast({
                        title: 'Warning Message',
                        message: response.data.message,
                        status: 'warning',
                        duration: 5000,
                    });
                }
            }).catch((err)=> {
                console.log(err);
            });
            await this.fetchStudentGroup(class_id, (res) => {
            this.students = res;
            });
            this.loading = false;
        },
        
    }));
</script>
@stop