<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LICE SYTEM</title>
    {!! HTML::style('admin-public/css/app.css') !!}
    {!! HTML::style('admin-public/css/view-info.css') !!}
    {!! HTML::script('admin-public/js/app.js') !!}
    <script src="{!! asset('admin-public/js/defer.js') !!}" defer></script>
    <link rel="stylesheet" href="{{ asset('plugin/toastr.min.css') }}">
    <script src="{{ asset('plugin/toastr.min.js') }}"></script>
    <script src="{{ asset('admin-public/js/tinymce/tinymce.min.js') }}" referrerpolicy="origin"></script>
    <script src="https://cdn.jsdelivr.net/npm/feather-icons/dist/feather.min.js"></script>
</head>

<body>
    <div style="width:fit-content">
        <div class="header m-5">
            <div class="d-flex justify-content-center align-items-center mt-0">
                <h1>{{strtoupper('study score entry form')}}</h1>
            </div>
            <div>
                <p class="m-0 font-weight-bold">សំគាល់ ៖</p>
                @foreach($lessons as $lesson)
                <p class="m-0">{{strtoupper($lesson->short_name)}} = {{$lesson->name}}</p>
                @endforeach
            </div>
        </div>
        <div class="c-content-body m-5">
            <div class="whole-body">
                <div class="table-header bg-black text-light">
                    <div style="width: 50px">
                        <span class="font-sm">N°</span>
                    </div>
                    <div style="width: 100px">
                        <span class="font-sm">អត្តលេខ</span>
                    </div>
                    <div style="width: 200px">
                        <span class="font-sm">ឈ្មោះ (ខ្មែរ)</span>
                    </div>
                    @foreach($lessons as $index=> $lesson)
                    <div style="width: 200px;">
                        <span class="font-sm">{{strtoupper($lesson->short_name)}}</span>
                    </div>
                    @endforeach
                    <div>
                        <span class="font-sm">{{strtoupper('actions')}}</span>
                    </div>
                </div>
                <div class="c-table-body overflow-auto">
                    @foreach($data->students as $index=> $student)
                    <div class="table-column d-flex flex-row" style="padding: 5px 20px;">
                        <div class="table-data h-50px d-flex align-items-center" style="width: 50px">
                            <span>{{$index+1}}</span>
                        </div>
                        <div class="table-data h-50px d-flex align-items-center" style="width: 100px">
                            <span>{{$student->sid}}</span>
                        </div>
                        <div class="table-data h-50px d-flex align-items-center" style="width: 200px">
                            <span>{{$student->name_khmer}}</span>
                        </div>
                        @foreach($lessons as $lesson)
                        <div class="table-data h-50px d-flex align-items-center" style="width: 200px;">
                            <span class="border-score w-75P">
                                {{$lesson->short_name}}
                            </span>
                        </div>
                        @endforeach
                        <div class="h-50px d-flex align-items-center">
                            <span>
                                Action
                            </span>
                        </div>
                    </div>
                    @endforeach

                </div>
            </div>
        </div>
    </div>
    <script lang="ts">
        $(document).ready(function() {
             @if (Session::has('success'))
                 Toast({
                     title: 'Success Message',
                     message: '{!! Session::get('success') !!}',
                     status: 'success',
                     duration: 5000,
                 });
             @elseif(Session::has('error'))
                 Toast({
                     title: 'Error Message',
                     message: '{!! Session::get('error') !!}',
                     status: 'danger',
                     duration: 5000,
                 });
             @elseif(Session::has('warning'))
                 Toast({
                     title: 'Warning Message',
                     message: '{!! Session::get('warning') !!}',
                     status: 'warning',
                     duration: 5000,
                 });
             @endif
        });
    </script>
    @yield('script')
    {!! HTML::script('admin-public/js/body.js') !!}
</body>

</html>