@extends('admin::shared.layout')
@section('layout')
<div class="content-wrapper" x-data="xExamControl">
    <div class="header">
        @include('admin::shared.header', ['header_name' => 'Exam Control'])
        <div class="header-tab">
            <div class="header-tab-wrapper">
                <div class="menu-row">
                    <div class="menu-item">
                        <a href="#exam-list">
                            {{strtoupper('Exam list')}}
                        </a>
                    </div>
                    <div class="menu-item">
                        <a href="#exam-answer-sheet">
                            {{strtoupper('Exam answer sheet')}}
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="content-body">
        @include('admin::pages.examControl.table')
    </div>
    <template x-if="loading">
        <div class="loading" style="x-index: 999999">
            <div class="sub-loading">
                <div class="loadingCus loadingCenter m-0 p-0 h-100 align-items-center flex-column" x-show="loading">
                    <div class="loaderSpinnerVer1"></div>
                    <div>Loading...</div>
                </div>
            </div>
        </div>
    </template>
    <template x-if="delete_status">
        <div>
            <template x-if="EAS">
                <div class="swal2-container swal2-center swal2-backdrop-show" style="overflow-y: auto;">
                    <div aria-labelledby="swal2-title" aria-describedby="swal2-content"
                        class="swal2-popup swal2-modal confirm-message swal2-icon-warning swal2-show" tabindex="-1"
                        role="dialog" aria-live="assertive" aria-modal="true" style="display: flex;">
                        <div class="swal2-header">
                            <ul class="swal2-progress-steps" style="display: none;"></ul>
                            <div class="swal2-icon swal2-warning swal2-icon-show" style="display: flex;">
                                <div class="swal2-icon-content">!</div>
                            </div><img class="swal2-image" style="display: none;">
                            <h2 class="swal2-title" id="swal2-title" style="display: none;"></h2><button type="button"
                                class="swal2-close" aria-label="Close this dialog" style="display: none;">×</button>
                        </div>
                        <div class="swal2-content">
                            <div id="swal2-content" class="swal2-html-container" style="display: block;">
                                Are you sure to delete <span class="text-danger" x-text="delete_data.c_name"></span>
                                that
                                have ID
                                <span class="text-danger" x-text="delete_data.id"></span>?
                            </div>
                            <input class="swal2-input" style="display: none;">
                            <input type="file" class="swal2-file" style="display: none;">
                            <div class="swal2-range" style="display: none;"><input type="range"><output></output>
                            </div><select class="swal2-select" style="display: none;"></select>
                            <div class="swal2-radio" style="display: none;"></div><label for="swal2-checkbox"
                                class="swal2-checkbox" style="display: none;"><input type="checkbox"><span
                                    class="swal2-label"></span></label><textarea class="swal2-textarea"
                                style="display: none;"></textarea>
                            <div class="swal2-validation-message" id="swal2-validation-message" style="display: none;">
                            </div>
                        </div>
                        <br />
                        <div class="swal2-actions">
                            <div class="swal2-loader"></div>
                            <button type="button" class="swal2-confirm swal2-styled" aria-label=""
                                style="display: inline-block;" @click="deleteExamAnswerSheet()">
                                Delete
                            </button>
                            <button type="button" class="swal2-cancel swal2-styled" aria-label=""
                                style="display: inline-block;" @click="onConfirmMessageEAS()">
                                Cancel
                            </button>
                        </div>
                        <div class="swal2-footer" style="display: none;"></div>
                        <div class="swal2-timer-progress-bar-container">
                            <div class="swal2-timer-progress-bar" style="display: none;"></div>
                        </div>
                    </div>
                </div>
            </template>
            <template x-if="ES">
                <div class="swal2-container swal2-center swal2-backdrop-show" style="overflow-y: auto;">
                    <div aria-labelledby="swal2-title" aria-describedby="swal2-content"
                        class="swal2-popup swal2-modal confirm-message swal2-icon-warning swal2-show" tabindex="-1"
                        role="dialog" aria-live="assertive" aria-modal="true" style="display: flex;">
                        <div class="swal2-header">
                            <ul class="swal2-progress-steps" style="display: none;"></ul>
                            <div class="swal2-icon swal2-warning swal2-icon-show" style="display: flex;">
                                <div class="swal2-icon-content">!</div>
                            </div><img class="swal2-image" style="display: none;">
                            <h2 class="swal2-title" id="swal2-title" style="display: none;"></h2><button type="button"
                                class="swal2-close" aria-label="Close this dialog" style="display: none;">×</button>
                        </div>
                        <div class="swal2-content">
                            <div id="swal2-content" class="swal2-html-container" style="display: block;">
                                Are you sure to delete <span class="text-danger" x-text="delete_data.c_name"></span>
                                that
                                have ID
                                <span class="text-danger" x-text="delete_data.id"></span>?
                            </div>
                            <input class="swal2-input" style="display: none;">
                            <input type="file" class="swal2-file" style="display: none;">
                            <div class="swal2-range" style="display: none;"><input type="range"><output></output>
                            </div><select class="swal2-select" style="display: none;"></select>
                            <div class="swal2-radio" style="display: none;"></div><label for="swal2-checkbox"
                                class="swal2-checkbox" style="display: none;"><input type="checkbox"><span
                                    class="swal2-label"></span></label><textarea class="swal2-textarea"
                                style="display: none;"></textarea>
                            <div class="swal2-validation-message" id="swal2-validation-message" style="display: none;">
                            </div>
                        </div>
                        <br />
                        <div class="swal2-actions">
                            <div class="swal2-loader"></div>
                            <button type="button" class="swal2-confirm swal2-styled" aria-label=""
                                style="display: inline-block;" @click="deleteExamSubject()">
                                Delete
                            </button>
                            <button type="button" class="swal2-cancel swal2-styled" aria-label=""
                                style="display: inline-block;" @click="onConfirmMessageES()">
                                Cancel
                            </button>
                        </div>
                        <div class="swal2-footer" style="display: none;"></div>
                        <div class="swal2-timer-progress-bar-container">
                            <div class="swal2-timer-progress-bar" style="display: none;"></div>
                        </div>
                    </div>
                </div>
            </template>
        </div>
    </template>
</div>
@stop

@section('script')
<script lang="ts">
    $(document).ready(function() {
       $validator("#to_score", {
            to_score_lesson: {
                required: true,
            },
            // to_score_exam_as: {
            //     required: true,
            // },
       });
   });
</script>
<script>
    Alpine.data('xExamControl', () => ({
        // modal
        baseImageUrl: "{{ asset('file_manager') }}",
        dialogOpen: false,
        loading: false,
        dialogExam: false,
        dialogSubject: false,
        dialogCandidate: false,
        toScore: false,
        addAnswerSheet: false,
        status: null,
        subject: null,
        validate: null,
        // create/update exam control
        exam_type_id: null,
        exam_date: null,
        exam_duration: null,
        exam_noted: null,
        exam_id: null,
        // load exam control data
        exam_control: [],
        // create/update exam subject
        id: null,
        sheet_issuer_id: null,
        description: null,
        google_doc_url: null,
        // exam/exam control detail
        exam_detail_id: null, 
        // load exam subject data
        exam_subject: [],
        exam_subject_show: [],
        // load student in class
        students: [],
        // load exam candidate
        exam_candidate: [],
        // load exam answer sheet
        exam_answer_sheet: [],
        // load exam answer sheet on exam subject, 
        exam_answer_sheet_on_exam_subject: [],
        // create exam answer sheet
        answer_sheet: null,
        acquired_score: null,
        exam_subject_id: null,
        exam_candidate_id: null,
        ens_score: false,
        // load exam answer sheet by Id
        studentScore: [],
        exam_as: [],
        // delete exam answer sheet
        delete_status: false,
        delete_data: [],
        EAS: false,
        ES: false,
        // create student lesson score or to score
        to_score_lesson: null,
        to_score_data: [],

        // score table
        scoreTable: false,
        scoreTableData: [],

        examAnswerSheetDetail(data){
            if(this.ens_score == false){ 
                this.ens_score = true;
                this.studentScore = data;
            }else{
                this.ens_score = false;
                this.studentScore = [];
            }
        },
        async init(){
            this.loading=true;
            await this.fetchExamAnswerSheet((res)=>{
                this.exam_answer_sheet = res;
            });
            this.reloadIcon();
            this.loading=false;
        },
        async dialogAddAnswerSheet(exam_id, class_id){
            if(this.addAnswerSheet == false){
                this.status = false;
                this.exam_subject = [];
                this.exam_candidate = [];
                this.validate = null;
                this.loading = true;
                await this.fetchExamSubject(exam_id, class_id, (res) => {
                    this.exam_subject = res;
                });
                await this.fetchExamCandidate(exam_id, class_id, (res) => {
                    this.exam_candidate = res;
                });
                this.dialogExam = true;
                this.loading = false;
                this.addAnswerSheet = true;
            }else{
                this.addAnswerSheet = false;
            }
        },
        async editExamAnswerSheet(exam_answer_sheet_by_id){
            if(this.addAnswerSheet == false){
                this.status = true;
                this.exam_as = [];
                this.loading = true;
                this.exam_as = exam_answer_sheet_by_id;
                this.acquired_score = this.exam_as?.acquired_score;
                this.exam_subject_id = this.exam_as?.exam_subject_id,
                this.exam_candidate_id = this.exam_as?.exam_candidate_id,
                this.answer_sheet = this.exam_as?.answer_sheet,
                this.loading = false;
                this.addAnswerSheet = true;
            }else{
                this.answer_sheet = null;
                this.acquired_score = null;
                this.exam_subject_id = null;
                this.exam_candidate_id = null;
                this.addAnswerSheet = false;
                this.status = false;
            }
        },
        async createExamAnswerSheet(class_id, id){
            this.loading = true;
            await Axios({
                url: `{{route('admin-exam-answer-sheet-save')}}`,
                method: 'POST',
                data: {
                    'id' : id,
                    'class_id' : class_id,
                    'exam_subject_id' : this.exam_subject_id,
                    'exam_candidate_id' : this.exam_candidate_id,
                    'acquired_score' : this.acquired_score,
                    'answer_sheet' : this.answer_sheet,
                } 
            }).then((response)=>{
                if (response.data.code == 20000) {
                    this.addAnswerSheet = false;
                    window.location.reload();
                    Toast({
                        title: 'Success Message',
                        message: response.data.message,
                        status: 'success',
                        duration: 5000,
                    });
                }else{
                    Toast({
                        title: 'Warning Message',
                        message: response.data.message,
                        status: 'warning',
                        duration: 5000,
                    });
                    this.validate = response.data.validation;
                    console.log(response.data);
                    console.log(this.validate);
                }
                this.loading = false;
            }).catch((err)=> {
                this.loading = false;
                Toast({
                    title: 'Warning Message',
                    message: "Invalided value",
                    status: 'danger',
                    duration: 5000,
                });
            });
            answer_sheet = null;
            acquired_score = null;
            exam_subject_id = null;
            exam_candidate_id = null;
        },
        selectImage() {
            fileManager({
                multiple: false,
                afterClose: (data, basePath) => {
                    if (data?.length > 0) {
                        data.map((item) => {
                            this.answer_sheet = item.path;
                        });
                    }
                }
            })
        },
        async fetchExamAnswerSheetOnExamSubject(exam_subject_id, callback){
            await Axios({
                url: `{{route('admin-exam-answer-sheet-on-exam-subject')}}`,
                method: 'GET',
                params: {
                    class_id: `{{request('class_id')}}`,
                    exam_subject_id: exam_subject_id,
                },
            }).then((response)=>{
                callback(response.data);
            }).catch((err)=> {
                console.log(err);
            });
        },
        async fetchExamAnswerSheet(callback){
            await Axios({
                url: `{{route('admin-exam-answer-sheet-list')}}`,
                method: 'GET',
                params: {
                    class_id: `{{request('class_id')}}`,
                },
            }).then((response)=>{
                callback(response.data);
            }).catch((err)=> {
                console.log(err);
            });
        },
        async dialogOpenCandidate(class_id){
            if(this.dialogCandidate == false){
                this.loading = true;
                await this.fetchStudentInClass(class_id, (res) => {
                    this.students = res;
                });
                this.dialogCandidate = true;
                this.loading = false;
            }else{
                this.dialogCandidate =false;
                window.location.reload();
            }
        },
        dialogOpenCreateESubject(){
            if(this.dialogSubject == false){
                this.subject = 1;
                this.dialogSubject = true;
            }else{
                this.dialogSubject = false;
            }
        },
        async dialogOpenUpdateESubject(id){
            if(this.dialogSubject == false){
                this.subject = 2;
                this.loading = true;
                await this.fetchExamSubjectShow(id, (res) => {
                    this.exam_subject_show = res;
                });
                this.loading = false;
                this.dialogSubject = true;
                this.id = id;
            }else{
                this.dialogSubject = false;
                this.id = null;
                this.exam_subject_show = [];
                this.sheet_issuer_id= null;
                this.description= null;
                this.google_doc_url= null;
            }
        },
        dialogOpenCreate(){
            if(this.dialogOpen == false){
                this.dialogOpen = true;
                this.status =1;
            }else{
                this.dialogOpen = false;
            }
        },
        async dialogExamDetail(exam_id, class_id) {
            this.loading = true;
            this.exam_detail_id = exam_id;
            await this.fetchExamSubject(exam_id, class_id, (res) => {
                this.exam_subject = res;
            });
            await this.fetchExamCandidate(exam_id, class_id, (res) => {
                this.exam_candidate = res;
            });
            this.reloadIcon();
            this.dialogExam = true;
            this.loading = false;
        },
        reloadIcon() {
            feather.replace();
            setTimeout(() => {
                feather.replace();
            }, 10);
        },
        async dialogOpenUpdate(exam_id){
            if(this.dialogOpen == false){
                this.dialogOpen = true;
                this.status = 2;
                this.loading = true;
                await this.fetchExamControl(exam_id, (res) => {
                    this.exam_control = res;
                });
                this.loading = false;
                this.exam_id = exam_id;
            }else{
                this.dialogOpen = false;
                this.exam_id = null;
                this.exam_type_id = null;
                this.exam_date = null;
                this.exam_duration = null;
                this.exam_noted = null;

            }
        },
        async createExamControl(class_id) {
            this.loading = true;
            await Axios({
                url: `{{route('admin-exam-control-save')}}`,
                method: 'POST',
                data: {
                    exam_id: this.exam_id,
                    class_id: class_id,
                    exam_type_id: this.exam_type_id,
                    exam_date: this.exam_date,
                    exam_duration: this.exam_duration,
                    exam_noted: this.exam_noted,
                } 
            }).then((response)=>{
                this.loading = false;
                this.dialogOpen = false;
                window.location.reload();
                if (response.data.code == 20000) {
                    Toast({
                        title: 'Success Message',
                        message: response.data.message,
                        status: 'success',
                        duration: 5000,
                    });
                }else{
                    Toast({
                        title: 'Warning Message',
                        message: response.data.message,
                        status: 'warning',
                        duration: 5000,
                    });
                }
            }).catch((err)=> {
                this.loading = false;
                Toast({
                    title: 'Warning Message',
                    message: "Invalided value",
                    status: 'warning',
                    duration: 5000,
                });
            });
        },
        async fetchExamControl(exam_id, callback){
            await Axios({
                url: `{{route('admin-exam-control-show')}}`,
                method: 'GET',
                params: {
                    exam_id:exam_id,
                }
            }).then((res) =>{
                callback(res.data);
            });
        },
        async fetchExamSubject(exam_id,class_id, callback){
            await Axios({
                url: `{{route('admin-exam-subject-list')}}`,
                method: 'GET',
                params: {
                    exam_id: exam_id,
                    class_id: class_id,
                }
            }).then((res) =>{
                callback(res.data);
            });
        },
        async fetchExamSubjectShow(id, callback){
            await Axios({
                url: `{{route('admin-exam-subject-show')}}`,
                method: 'GET',
                params: {
                    id: id,
                }
            }).then((res) =>{
                callback(res.data);
            });
        },
        async createExamSubject(class_id) {
            this.loading = true;
            await Axios({
                url: `{{route('admin-exam-subject-save')}}`,
                method: 'POST',
                data: {
                    id: this.id,
                    class_id: class_id,
                    exam_id: this.exam_detail_id,
                    sheet_issuer_id: this.sheet_issuer_id,
                    description: this.description,
                    google_doc_url: this.google_doc_url,
                } 
            }).then((response)=>{
                this.loading = false;
                // if(this.id){
                //     window.location.reload();
                // }
                if (response.data.code == 20000) {
                    this.dialogSubject = false;
                    Toast({
                        title: 'Success Message',
                        message: response.data.message,
                        status: 'success',
                        duration: 5000,
                    });
                    this.id = null;
                    this.sheet_issuer_id = null;
                    this.description = null;
                    this.google_doc_url = null;
                }else{
                    Toast({
                        title: 'Warning Message',
                        message: response.data.message,
                        status: 'warning',
                        duration: 5000,
                    });
                }
            }).catch((err)=> {
                this.loading = false;
                Toast({
                    title: 'Warning Message',
                    message: "Invalided value",
                    status: 'warning',
                    duration: 5000,
                });
            });
            await this.fetchExamSubject(this.exam_detail_id, class_id, (res) => {
                this.exam_subject = res;
            });
        },
        async fetchStudentInClass(class_id, callback) {
            await Axios({
                url: `{{route('admin-listing-student-in-class')}}`,
                method: 'GET',
                params: {
                    class_id: class_id,
                }
            }).then((res) =>{
                callback(res.data);
            });
        },
        async fetchExamCandidate(exam_id, class_id, callback) {
            await Axios({
                url: `{{route('admin-exam-candidate-list')}}`,
                method: 'GET',
                params: {
                    class_id: class_id,
                    exam_id: exam_id
                }
            }).then((res) =>{
                callback(res.data);
            });
        },
        async assignCandidate(class_id, student_id){
            this.loading = true;
            await Axios({
                url: `{{route('admin-exam-candidate-assign')}}`,
                method: 'POST',
                data: {
                    class_id: class_id,
                    student_id: student_id,
                    exam_id: this.exam_detail_id,
                }
            }).then((response) => {
                if (response.data.code == 20000) {
                    // window.location.reload();
                    Toast({
                        title: 'Success Message',
                        message: response.data.message,
                        status: 'success',
                        duration: 5000,
                    });
                }else{
                    Toast({
                        title: 'Warning Message',
                        message: response.data.message,
                        status: 'warning',
                        duration: 5000,
                    });
                }
            }).catch((err)=> {
                console.log(err);
            });
            await this.fetchExamCandidate(this.exam_detail_id, class_id, (res) => {
                this.exam_candidate = res;
            });
            this.loading = false;
        },
        async unassignCandidate(class_id, student_id){
            this.loading = true;
            await Axios({
                url: `{{route('admin-exam-candidate-unassign')}}`,
                method: 'POST',
                data: {
                    class_id: class_id,
                    student_id: student_id,
                    exam_id: this.exam_detail_id,
                }
            }).then((response) => {
                if (response.data.code == 20000) {
                    // window.location.reload();
                    Toast({
                        title: 'Success Message',
                        message: response.data.message,
                        status: 'success',
                        duration: 5000,
                    });
                }else{
                    Toast({
                        title: 'Warning Message',
                        message: response.data.message,
                        status: 'warning',
                        duration: 5000,
                    });
                }
            }).catch((err)=> {
                console.log(err);
            });
            await this.fetchExamCandidate(this.exam_detail_id, class_id, (res) => {
                this.exam_candidate = res;
            });
            this.loading = false;
        },
        async deleteExamAnswerSheet(){
            this.delete_status = false;
            this.loading = true;
            await Axios({
                url: `{{route('admin-exam-answer-sheet-delete')}}`,
                method: 'POST',
                data: {
                    id: this.delete_data?.id,
                }
            }).then((response) => {
                if (response.data.code == 20000) {
                    window.location.reload();
                    Toast({
                        title: 'Success Message',
                        message: response.data.message,
                        status: 'success',
                        duration: 5000,
                    });
                }else{
                    Toast({
                        title: 'Warning Message',
                        message: response.data.message,
                        status: 'warning',
                        duration: 5000,
                    });
                }
            }).catch((err)=> {
                console.log(err);
            });
            this.loading = false;
            this.delete_data = [];
            this.EAS = false;
        },
        onConfirmMessageEAS(data){
            if(this.delete_status == false){
                this.delete_data = data;
                this.delete_data['c_name'] = "Exam Answer Sheet";
                console.log(this.delete_data);
                this.delete_status = true;
                this.EAS = true;
            }else{
                this.delete_status = false;
                this.delete_data = [];
                console.log(this.delete_data);
                this.EAS = false;
            }
        },
        async deleteExamSubject(){
            this.delete_status = false;
            this.loading = true;
            await Axios({
                url: `{{route('admin-exam-subject-delete')}}`,
                method: 'POST',
                data: {
                    id: this.delete_data?.id,
                }
            }).then((response) => {
                if (response.data.code == 20000) {
                    window.location.reload();
                    Toast({
                        title: 'Success Message',
                        message: response.data.message,
                        status: 'success',
                        duration: 5000,
                    });
                }else{
                    Toast({
                        title: 'Warning Message',
                        message: response.data.message,
                        status: 'warning',
                        duration: 5000,
                    });
                }
            }).catch((err)=> {
                console.log(err);
            });
            this.loading = false;
            this.delete_data = [];
            this.ES = false;
        },
        onConfirmMessageES(data){
            if(this.delete_status == false){
                this.delete_data = data;
                this.delete_data['c_name'] = "Exam Subject";
                console.log(data);
                this.delete_status = true;
                this.ES = true;
            }else{
                this.delete_status = false;
                this.delete_data = [];
                this.ES = false;
            }
        },
        async dialogToScore(exam_subject_id){
            if(this.toScore == false){
                this.loading = true;
                await this.fetchExamAnswerSheetOnExamSubject(exam_subject_id, (res)=>{
                    this.exam_answer_sheet_on_exam_subject = res;
                });
                this.toScore = true;
                this.loading = false;
            }else{
                this.toScore = false;
                this.exam_answer_sheet_on_exam_subject = [];
            }
        },
        async onViewScoreTable(data){
            if(this.scoreTable == false){
                this.loading = true;
                await this.fetchExamControl(data, (res) => {
                    this.scoreTableData = res;
                });
                console.log(this.scoreTableData);
                this.loading = false;
                this.scoreTable = true;
            }else{
                this.scoreTable = false;
                this.scoreTableData = [];
            }
        }
    }));
</script>
@stop