<template x-if="dialogCandidate">
    <div class="classLogDialogLayout">
        <div class="classLogDialog p-4">
            <div class="d-flex justify-content-between">
                <h2 class="m-0">
                    {!! strtoupper('Assign Candidate to exam') !!}
                </h2>
                <span @click="dialogCandidate=false" class="cursor-pointer btn-close">
                </span>
            </div>
            <div class="row h-100">
                <div class="table">
                    <div class="table-wrapper">
                        <div class="table-header bg-black text-light">
                            <div class="row table-row-10">
                                <span class="font-sm">{!! strtoupper('N°') !!}</span>
                            </div>
                            <div class="row table-row-20">
                                <span class="font-sm">{!! strtoupper('Student id') !!}</span>
                            </div>
                            <div class="row table-row-35">
                                <span class="font-sm">{!! strtoupper('Name') !!}</span>
                            </div>
                            <div class="row table-row-35">
                                <span class="font-sm">{!! strtoupper('action') !!}</span>
                            </div>
                        </div>
                        <div class="table-body overflow-auto">
                            <template x-for="(data, index) in students">
                                <div class="column">
                                    <div class="row table-row-10">
                                        <span x-text="index+1"></span>
                                    </div>
                                    <div class="row table-row-20">
                                        <span x-text="data.id"></span>
                                    </div>
                                    <div class="row table-row-35">
                                        <span x-text="data.name_khmer"></span>
                                    </div>
                                    <div class="row table-row-35 h-50 d-flex justify-content-center">
                                        <span class="font-sm h-100 mr-2">
                                            <template x-for="item in exam_candidate">
                                                <template x-if="item.student_id == data.id">
                                                    <button class="btn-create bg-danger h-100"
                                                        @click="unassignCandidate({{request('class_id')}}, data.id)">
                                                        <span>
                                                            {!! strtoupper('Unassign') !!}
                                                        </span>
                                                    </button>
                                                </template>
                                            </template>
                                            <template x-for="item in exam_candidate">
                                                <template x-if="item.student_id != data.id">
                                                    <button class="btn-create bg-primary h-100"
                                                        @click="assignCandidate({{request('class_id')}}, data.id)">
                                                        <span>
                                                            {!! strtoupper('Assign') !!}
                                                        </span>
                                                    </button>
                                                </template>
                                            </template>
                                            <button class="btn-create bg-primary h-100"
                                                @click="assignCandidate({{request('class_id')}}, data.id)">
                                                <span>
                                                    {!! strtoupper('Assign') !!}
                                                </span>
                                            </button>
                                        </span>
                                    </div>
                                </div>
                            </template>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</template>