<div class="table">
    @if ($data->count() > 0)
    <div class="table-wrapper">
        <div class="table-header">
            <div class="row table-row-5">
                <span>Nº</span>
            </div>
            <div class="row table-row-10">
                <span>Image</span>
            </div>
            <div class="row table-row-10">
                <span>Title</span>
            </div>
            <div class="row table-row-10">
                <span>Fee</span>
            </div>
            <div class="row table-row-10">
                <span>Popular</span>
            </div>
            <div class="row table-row-10">
                <span>Date</span>
            </div>
            <div class="row table-row-10">
                <span>Trainer</span>
            </div>
            <div class="row table-row-30">
                <span>Description</span>
            </div>
            <div class="row table-row-5">
                <span></span>
            </div>
        </div>
        <div class="table-body">
            @foreach ($data as $index => $item)
            <div class="column">
                <div class="row table-row-5">
                    <span>{!! $data->currentPage() * $data->perPage() - $data->perPage() + ($index + 1) !!}</span>
                </div>
                <div class="row table-row-10">
                    <div class="thumbnail" data-fancybox data-src="{{ asset('file_manager' . $item->image)  }}">
                        <img src="{!! $item->image != null ? asset('file_manager' . $item->image) : asset('images/logo/default.png') !!}"
                            onerror="(this).src='{{ asset('images/logo/default.png') }}'" alt="">
                    </div>
                </div>
                <div class="row table-row-10">
                    <span>{{$item->name ?? '--'}}</span>
                </div>
                <div class="row table-row-10">
                    <span>{{$item->fee ?? '--'}}</span>
                </div>
                <div class="row table-row-10">
                    <span class="d-flex justify-content-center align-items-center">
                        @if($item->popular && $item->popular == 1)
                        <i class="text-success" data-feather="check-circle"></i>
                        @else
                        <i class="text-danger" data-feather="x-circle"></i>
                        @endif
                    </span>
                </div>
                <div class="row table-row-10">
                    <span>{{date('Y-m-d h:i a',strtotime($item->date)) ?? '--'}}</span>
                </div>
                <div class="row table-row-10">
                    <span>{{$item->trainer?->name ?? '--'}}</span>
                </div>
                <div class="row table-row-30 text left">
                    <span>{{$item->description ?? '--'}}</span>
                </div>
                <div class="row table-row-5">
                    @canany(['course-update'])
                    <div class="dropdown">
                        <i data-feather="more-vertical" class="action-btn" id="dropdownMenuButton"
                            data-mdb-toggle="dropdown" aria-expanded="false">
                        </i>
                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                            @if ($item->status != 'trash')
                            @can('course-update')
                            <li>
                                <a class="dropdown-item" s-click-link="{!! route('admin-course-create', $item->id) !!}">
                                    <i data-feather="edit"></i>
                                    <span>Edit</span>
                                </a>
                            </li>
                            @if ($item->status == 2)
                            <li>
                                <a class="dropdown-item enable-btn" onclick="$onConfirmMessage(
                                    '{!! route('admin-course-status', ['id' => $item->id, 'status' => 1]) !!}',
                                    '@lang('dialog.msg.enable', ['name' => $item->name])',
                                    {
                                        confirm: '@lang('dialog.button.enable')',
                                        cancel: '@lang('dialog.button.cancel')'
                                    },
                                );">
                                    <i data-feather="rotate-ccw"></i>
                                    <span>Enable</span>
                                </a>
                            </li>
                            @else
                            <li>
                                <a class="dropdown-item disable-btn" onclick="$onConfirmMessage(
                                    '{!! route('admin-course-status', ['id' => $item->id, 'status' => 2]) !!}',
                                    '@lang('dialog.msg.disable', ['name' => $item->name])',
                                    {
                                        confirm: '@lang('dialog.button.disable')',
                                        cancel: '@lang('dialog.button.cancel')'
                                    }
                                );">
                                    <i data-feather="x-circle"></i>
                                    <span>Disable</span>
                                </a>
                            </li>
                            @endif
                            @endcan
                            @endif
                        </ul>
                    </div>
                    @endcan
                </div>
            </div>
            @endforeach
        </div>
        <div class="table-footer">
            @include('admin::components.pagination', ['paginate' => $data])
        </div>
    </div>
    @else
    @component('admin::components.empty',
    [
    'name' => 'Course is empty',
    'msg' => 'You can create a new course by clicking the button below.',
    'permission' => 'course-create',
    'url' => route('admin-course-create'),
    'button' => 'Create Course',
    ])
    @endcomponent
    @endif
</div>