@extends('admin::shared.layout')
@section('layout')
<div class="form-admin">
    <div class="form-bg"></div>
    <form id="form" class="form-wrapper"
        action="{!! route('admin-slide-save', ['id' =>request('id'), 'type' => 'course'])!!}" method="POST"
        enctype="multipart/form-data">
        <div class="form-header">
            <h3>
                Course's Slide Image
            </h3>
        </div>
        {{ csrf_field() }}
        <div class="form-body">
            <div class="row-2">
                <div class="form-row">
                    <label>Name<span>*</span></label>
                    <input type="text" name="name" id="" value="{{request('id') ? $data->name : old('name')}}">
                    @error('name')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
                <div class="form-row">
                    <label>Status<span>*</span></label>
                    <select name="status" id="">
                        <option value="1" {{request('id') && $data->status == 1 ? 'selected' : old('status')}}>Active
                        </option>
                        <option value="1" {{request('id') && $data->status == 2 ? 'selected' : old('status')}}>Disable
                        </option>
                    </select>
                    @error('title')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
            </div>
            <div class="row">
                <div class="form-row">
                    <label>Cover<span>*</span></label>
                    <div class="form-select-photo image">
                        <div
                            class="select-photo {!! request('id') && isset($data) && $data->cover != null ? 'active' : '' !!}">
                            <div class="icon">
                                <i data-feather="image"></i>
                            </div>
                            <div class="title">
                                <span>@lang('user.form.profile.placeholder')</span>
                            </div>
                        </div>
                        <div
                            class="image-view {!! request('id') && isset($data) && $data->cover != null ? 'active' : '' !!}">
                            <img src="{!! request('id') && isset($data) && $data->cover != null ? asset('file_manager' . $data->cover) : null !!}"
                                onerror="(this).src='{{ asset('images/logo/default.png') }}'" alt="">
                        </div>
                        <input type="text" name="image" s-click-fn="selectImage(event)" autocomplete="off"
                            role="presentation"
                            value="{!! request('id') && isset($data) && $data->cover != null ? $data->cover : '' !!}">
                        <input type="hidden" name="tmp_file"
                            value="{!! request('id') && isset($data) && $data->cover != null ? $data->cover : '' !!}">
                    </div>
                </div>
            </div>
            <div class="form-button">
                <button type="submit" color="primary">
                    <i data-feather="save"></i>
                    <span>Submit</span>
                </button>
                <button color="danger" type="button" s-click-link="{!! route('admin-slide-list', 1) !!}">
                    <i data-feather="x"></i>
                    <span>Cancel</span>
                </button>
            </div>
        </div>
        <div class="form-footer"></div>
    </form>
</div>
@include('admin::file-manager.popup')
@stop
@section('script')
<script>
    $(document).ready(function() {
        $validator("#form", {
            name: {
                required: true,
            },
            image: {
                required: true,
            },
        });
    });
    function selectImage(e) {
            fileManager({
                multiple: false,
                afterClose: (data, basePath) => {
                    if (data?.length > 0) {
                        const parent = e.target.closest('.form-select-photo');
                        e.target.value = data[0].path;
                        parent
                            .querySelector('.select-photo')
                            .classList.add('active');
                        parent
                            .querySelector('.image-view')
                            .classList
                            .add('active');
                        parent
                            .querySelector('.image-view')
                            .childNodes[0]
                            .nextElementSibling
                            .setAttribute('src', basePath + data[0].path);
                    }
                }
            })
        }
</script>
@stop