@extends('admin::shared.layout')
@section('layout')
<div class="content-wrapper">
    <div class="header">
        @include('admin::shared.header', ['header_name' => 'Course'])
        <div class="header-tab">
            <div class="header-tab-wrapper">
                <div class="menu-row">
                    <div class="menu-item {!! Request::is('admin/course/list/1') ? 'active' : '' !!}"
                        s-click-link="{!! route('admin-course-list', 1) !!}">
                        Active</div>
                    <div class="menu-item {!! Request::is('admin/course/list/2') ? 'active' : '' !!}"
                        s-click-link="{!! route('admin-course-list', 2) !!}">
                        Disable</div>
                </div>
            </div>
            <div class="header-action-button">
                <form class="filter" action="{!! url()->current() !!}" method="GET">
                    <div class="form-row" style="min-width: 175px">
                        <select name="popular" class="bg-transparent" style="width: 100%">
                            <option value="">Popular Type</option>
                            <option value="popular" {{ request('popular') == 'popular' ? 'selected' : '' }}>Popular</option>
                            <option value="normal" {{ request('popular') == 'normal' ? 'selected' : '' }}>Normal</option>
                        </select>
                    </div>
                    <div class="form-row">
                        <input type="text" name="search" placeholder="Search" value="{!! request('search') !!}">
                        <i data-feather="filter"></i>
                    </div>
                    <button mat-flat-button type="submit" class="btn-create bg-success">
                        <i data-feather="search"></i>
                        <span>Search</span>
                    </button>
                </form>
                @can('class-level-create')
                <button class="btn-create" s-click-link="{!! route('admin-course-create') !!}">
                    <i data-feather="plus-circle"></i>
                    <span>Create Course</span>
                </button>
                @endcan
                <button s-click-link="{!! url()->current() !!}">
                    <i data-feather="refresh-ccw"></i>
                    <span>Reload</span>
                </button>
            </div>
        </div>
    </div>
    <div class="content-body">
        @include('admin::pages.course.table')
    </div>
</div>
@stop