<template x-if="sc_modal">
    <div class="classLogDialogLayout">
        <div class="classLogDialog" style="position: relative">
            <form id="sc_form" action="{!! route('admin-exam-score-save', request('id')) !!}" method="POST"
                enctype="multipart/form-data">
                <div class="d-flex flex-row-reverse justify-content-between p-3">
                    <span @click="studentScore()" class="cursor-pointer btn-close">
                    </span>
                    <h2 class="mt-0">
                        {!! strtoupper('Enter Student Score') !!}
                    </h2>
                </div>
                {{ csrf_field() }}
                <div class="row p-3" style="padding-bottom: 0 !important;">
                    <div class="form-row">
                        <input type="number" name="student_id" :value="sc.id" hidden>
                        <label style="height: 23px;">Student Name</label>
                        <label class="border-1-gray w-100 d-flex align-items-center"
                            style="height: 40px; padding: 0 15px;" x-text="sc.name_khmer"></label>
                    </div>
                </div>
                <div class="row-2 overflow-auto p-3" style="max-height: 75%; padding-bottom: 0 !important;">
                    <template x-if="sc.exam_score.length > 0">
                        <template x-for="item in sc.exam_score">
                            <div>
                                @foreach($lessons as $ls)
                                <template x-if="{{$ls->id}} == item.lesson_id">
                                    <div class="form-row">
                                        <label>{{$ls->name}}</label>
                                        <input type="number" name="lesson_id[]" value="{{$ls->id}}" hidden>
                                        <input type="number" name="lesson_score[]" :value="item.score" step="0.5"><span>
                                    </div>
                                </template>
                                @endforeach
                            </div>
                        </template>
                    </template>
                </div>
                <template x-if="sc.exam_score.length < 1">
                    <div class="row-2 p-3" style='padding-top: 0'>
                        @foreach($lessons as $ls)
                        <div class="form-row">
                            <label>{{$ls->name}}</label>
                            <input type="number" name="lesson_id[]" value="{{$ls->id}}" hidden>
                            <input type="number" name="lesson_score[]" value="" step="0.5"><span>
                        </div>
                        @endforeach
                    </div>
                </template>
                {{-- <div class="row p-3" style="height: 15%;">
                    <div class="form-row">
                        <label>Total Score</label>
                        <label x-text="lesson_score/3"></label>
                    </div>
                </div> --}}
                <div class="p-3" style="position: absolute; bottom: 10px;">
                    <button class="bg-primary">Submit</button>
                </div>
            </form>
        </div>
    </div>
</template>