@extends('admin::shared.layout')
@section('layout')
<div class="content-wrapper">
    <div class="header">
        @include('admin::shared.header', ['header_name' => 'Class Progress Image'])
        <div class="header-tab">
            <div class="header-tab-wrapper">
                <div class="menu-row">
                    <div class="menu-item text-primary" s-click-link="{!! route('admin-class-list', 1) !!}">
                        Back</div>
                </div>
            </div>
            <div class="header-action-button">
                @can('class-image-create')
                <button class="btn-create"
                    s-click-link="{!! route('admin-class-image-create', request('class_id')) !!}">
                    <i data-feather="plus-circle"></i>
                    <span>Upload New Class Image</span>
                </button>
                @endcan
                <button s-click-link="{!! url()->current() !!}">
                    <i data-feather="refresh-ccw"></i>
                    <span>Reload</span>
                </button>
            </div>
        </div>
    </div>
    <div class="content-body p-0">
        @include('admin::pages.class.classImage.table')
    </div>
</div>
@stop