@extends('admin::shared.layout')
@section('layout')
<div class="form-admin">
    <div class="form-bg"></div>
    <form id="form" class="form-wrapper" action="{!! route('admin-class-image-save', request('class_id')) !!}"
        method="POST" enctype="multipart/form-data">
        <div class="form-header">
            <h3>
                <i data-feather="arrow-left"
                    s-click-link="{!! route('admin-class-image-list', request('class_id')) !!}"></i>
                Add New Class Image
            </h3>
        </div>
        {{ csrf_field() }}
        <div class="form-body">
            <div class="row-2">
                <div class="form-row">
                    <label>@lang('user.form.profile.label')</label>
                    <div class="form-select-photo image">
                        <div
                            class="select-photo {!! request('id') && isset($data) && $data->profile != null ? 'active' : '' !!}">
                            <div class="icon">
                                <i data-feather="image"></i>
                            </div>
                            <div class="title">
                                <span>@lang('user.form.profile.placeholder')</span>
                            </div>
                        </div>
                        <div
                            class="image-view {!! request('id') && isset($data) && $data->profile != null ? 'active' : '' !!}">
                            <img src="{!! request('id') && isset($data) && $data->profile != null ? asset('file_manager' . $data->profile) : null !!}"
                                onerror="(this).src='{{ asset('images/logo/default.png') }}'" alt="">
                        </div>
                        <input type="text" name="image" s-click-fn="selectImage(event)" autocomplete="off"
                            role="presentation">
                        <input type="hidden" name="tmp_file"
                            value="{!! request('id') && isset($data) && $data->profile != null ? $data->profile : '' !!}">
                    </div>
                </div>
                <div>
                    <div class="form-row">
                        <label>Class ID <span>*</span></label>
                        <div class="w-100 border-1-gray d-flex align-items-center"
                            style="height: 40px; padding: 0 15px; border-radius: 4px; color: #5a5e66;">
                            {{request('class_id')}}
                        </div>
                    </div>
                    <div class="form-row">
                        <label>Image Date <span>*</span></label>
                        <input type="date" name="image_date">
                        @error('image_date')
                        {{$message}}
                        @enderror
                    </div>
                    <div class="form-row">
                        <label>Image Description</label>
                        <textarea name="description" placeholder="Please descript something"></textarea>
                        @error('description')
                        {{$message}}
                        @enderror
                    </div>
                </div>
            </div>
            <div class="form-button">
                <button type="submit" color="primary">
                    <i data-feather="save"></i>
                    <span>@lang('user.form.button.submit')</span>
                </button>
                <button color="danger" type="button" s-click-link="{{route('admin-class-image-list', request('class_id'))}}">
                    <i data-feather="x"></i>
                    <span>@lang('user.form.button.cancel')</span>
                </button>
            </div>
        </div>
        <div class="form-footer"></div>
    </form>
</div>
@include('admin::file-manager.popup')
@stop

@section('script')
<script lang="ts">
    $(document).ready(function() {
        $validator("#form", {
            image: {
                required: true,
            },
            image_date: {
                required: true,
            },
        });
    });
    function selectImage(e) {
        fileManager({
            multiple: false,
            afterClose: (data, basePath) => {
                if (data?.length > 0) {
                    const parent = e.target.closest('.form-select-photo');
                    e.target.value = data[0].path;
                    parent
                        .querySelector('.select-photo')
                        .classList.add('active');
                    parent
                        .querySelector('.image-view')
                        .classList
                        .add('active');
                    parent
                        .querySelector('.image-view')
                        .childNodes[0]
                        .nextElementSibling
                        .setAttribute('src', basePath + data[0].path);
                }
            }
        })
    }  
</script>
@stop