@extends('admin::shared.layout')
@section('layout')
<div class="form-admin">
    <div class="form-bg"></div>
    <form id="form" class="form-wrapper" action="{!! route('admin-class-save-allow-user', request('id')) !!}"
        method="POST" enctype="multipart/form-data">
        <div class="form-header">
            <h3>
                <i data-feather="arrow-left" s-click-link="{!! route('admin-class-list', 1) !!}"></i>
                {!! "Allow User To Manage Class" !!}
            </h3>
        </div>
        {{ csrf_field() }}
        <div class="form-body">
            <div class="row-2">
                @foreach($users as $index => $item)
                <div class="form-row justify-content-between flex-row">
                    <label class="w-50" for="{{$item->username.'-'.$item->id}}"
                        style="text-align: left;">{{$item->username}}</label>
                    <input class="w-50" type="checkbox" name="user_id[]" id="{{$item->username.'-'.$item->id}}"
                        value="{{$item->id}}" style="height: 20px;" {{in_array($item->id, $class_allow_user_id) ?
                    'checked' : ''}}>
                </div>
                @endforeach
            </div>
            <div class="form-button">
                <button type="submit" color="primary">
                    <i data-feather="save"></i>
                    <span>Submit</span>
                </button>
                <button color="danger" type="button" s-click-link="{!! route('admin-class-list', 1) !!}">
                    <i data-feather="x"></i>
                    <span>Cancel</span>
                </button>
            </div>
        </div>
        <div class="form-footer"></div>
    </form>
</div>
@include('admin::file-manager.popup')
@stop

@section('script')
<script lang="ts">
    // $(document).ready(function() {
    //     $validator("#form", {
    //     });
    // })
</script>
@stop