@extends('admin::shared.layout')
@section('layout')
    <div class="content-wrapper">
        <div class="header">
            @include('admin::shared.header', ['header_name' => 'Branch Management'])
            <div class="header-tab">
                <div class="header-tab-wrapper">
                    <div class="menu-row">
                        <div class="menu-item {!! Request::is('admin/branch/list/1*') ? 'active' : '' !!}" s-click-link="{!! route('admin-branch-list', 1) !!}">
                            Active</div>
                        <div class="menu-item {!! Request::is('admin/branch/list/2*') ? 'active' : '' !!}" s-click-link="{!! route('admin-branch-list', 2) !!}">
                            Disable</div>
                    </div>
                </div>
                <div class="header-action-button">
                    <form class="filter" action="{!! url()->current() !!}" method="GET">
                        <div class="form-row">
                            <input type="text" name="keyword" placeholder="@lang('user.filter.search')"
                                value="{!! request('keyword') !!}">
                            <i data-feather="filter"></i>
                        </div>
                        <button mat-flat-button type="submit" class="btn-create bg-success">
                            <i data-feather="search"></i>
                            <span>Search</span>
                        </button>
                    </form>
                    @can('branch-create')
                        <button class="btn-create" s-click-link="{!! route('admin-branch-create') !!}">
                            <i data-feather="plus-circle"></i>
                            <span>Create Branch</span>
                        </button>
                    @endcan
                    <button s-click-link="{!! url()->current() !!}">
                        <i data-feather="refresh-ccw"></i>
                        <span>Reload</span>
                    </button>
                </div>
            </div>
        </div>
        <div class="content-body {!! $referent ? 'has-breadcrumb' : '' !!}">
            @if ($referent)
                <div class="breadcrumb">
                    <span s-click-link="{!! route('admin-branch-list', ['id' => request('id')]) !!}">All</span>/
                    @foreach ($refer_list as $key => $item)
                        <span s-click-link="{!! route('admin-branch-list', [
                            'id' => request('id'),
                            'referent' => implode('/', array_slice($refer, 0, $key + 1)),
                        ]) !!}">{!! $item->name !!}</span>/
                    @endforeach
                </div>
            @endif
            @include('admin::pages.branch.table')
        </div>
    </div>
@stop
