<div class="table">
    @if ($data->count() > 0)
    <div class="table-wrapper">
        <div class="table-header">
            <div class="row table-row-5">
                <span>Nº</span>
            </div>
            <div class="row table-row-10">
                <span>Cover</span>
            </div>
            <div class="row table-row-40">
                <span>Name</span>
            </div>
            <div class="row table-row-40">
                <span>Album Type</span>
            </div>
            <div class="row table-row-5">
                <span></span>
            </div>
        </div>
        <div class="table-body">
            @foreach ($data as $index => $item)
            <div class="column">
                <div class="row table-row-5">
                    <span>{!! $data->currentPage() * $data->perPage() - $data->perPage() + ($index + 1) !!}</span>
                </div>
                <div class="row table-row-10">
                    <div class="thumbnail" data-fancybox data-src="{{ asset('file_manager' . $item->cover)  }}">
                        <img src="{!! $item->cover != null ? asset('file_manager' . $item->cover) : asset('images/logo/default.png') !!}"
                            onerror="(this).src='{{ asset('images/logo/default.png') }}'" alt="">
                    </div>
                </div>
                <div class="row table-row-40">
                    <span>{{$item->name ?? '--'}}</span>
                </div>
                <div class="row table-row-40">
                    <span>{{ucfirst($item->album_type ?? '--')}}</span>
                </div>
                <div class="row table-row-5">
                    @canany(['album-update'])
                    <div class="dropdown">
                        <i data-feather="more-vertical" class="action-btn" id="dropdownMenuButton"
                            data-mdb-toggle="dropdown" aria-expanded="false">
                        </i>
                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                            @if ($item->status != 'trash')
                            @can('album-update')
                            <li>
                                <a class="dropdown-item" s-click-link="{!! route('admin-album-create', $item->id) !!}">
                                    <i data-feather="edit"></i>
                                    <span>Edit</span>
                                </a>
                            </li>
                            @if ($item->status == 2)
                            <li>
                                <a class="dropdown-item enable-btn" onclick="$onConfirmMessage(
                                    '{!! route('admin-album-status', ['id' => $item->id, 'status' => 1]) !!}',
                                    '@lang('dialog.msg.enable', ['name' => $item->day])',
                                    {
                                        confirm: '@lang('dialog.button.enable')',
                                        cancel: '@lang('dialog.button.cancel')'
                                    },
                                );">
                                    <i data-feather="rotate-ccw"></i>
                                    <span>Enable</span>
                                </a>
                            </li>
                            @else
                            <li>
                                <a class="dropdown-item disable-btn" onclick="$onConfirmMessage(
                                    '{!! route('admin-album-status', ['id' => $item->id, 'status' => 2]) !!}',
                                    '@lang('dialog.msg.disable', ['name' => $item->day])',
                                    {
                                        confirm: '@lang('dialog.button.disable')',
                                        cancel: '@lang('dialog.button.cancel')'
                                    }
                                );">
                                    <i data-feather="x-circle"></i>
                                    <span>Disable</span>
                                </a>
                            </li>
                            @endif
                            @endcan
                            @endif
                        </ul>
                    </div>
                    @endcan
                </div>
            </div>
            @endforeach
        </div>
        <div class="table-footer">
            @include('admin::components.pagination', ['paginate' => $data])
        </div>
    </div>
    @else
    @component('admin::components.empty',
    [
    'name' => 'Gallery Album is empty',
    'msg' => 'You can create a new gallery album by clicking the button below.',
    'permission' => 'album-create',
    'url' => route('admin-album-create'),
    'button' => 'Create Gallery Album',
    ])
    @endcomponent
    @endif
</div>