// author : LY SARI
// s-event version: 1.0.0
// release date: 2022-03-07
(function () {
  "use strict";
  const element = document.querySelectorAll("[s-mask]");
  const maskConvert = (value, arg) => {
    if (value && value.length > 0 && isFinite(value)) {
      let mask = value.toString();
      let mask_result = "";
      let mask_index = 0;
      let arg_mask = arg.match(/#/gm);
      let mask_symbol =
        mask.length >= arg_mask.length ? mask.length : arg_mask.length;
      for (let i = 0; i < mask_symbol; i++) {
        if (arg[i].toLowerCase() == "#") {
          if (mask[i - mask_index]) {
            mask_result += mask[i - mask_index];
          }
        } else {
          mask_symbol++;
          mask_index++;
          mask_result += arg[i];
        }
      }
      return mask_result;
    }
    return value;
  };
  element.forEach((el) => {
    const value = el.innerHTML;
    const mask = el.getAttribute("s-mask");
    el.innerHTML = maskConvert(value, mask);
  });
})();
