// author : LY SARI
// s-event version: 1.0.0
// release date: 2022-02-09
(function () {
  const PREFIX = "s";
  const EVENT = [
    "click",
    "mouseover",
    "mouseout",
    "mousedown",
    "mouseup",
    "mousemove",
    "focus",
    "Keydown",
    "Keyup",
  ];
  const TYPE = ["fn", "link", "open"];
  let FULL_EVENT_ATTRIBUTES = [];
  EVENT.map((event) => {
    TYPE.map((type) => {
      FULL_EVENT_ATTRIBUTES.push(`${PREFIX}-${event}-${type}`);
    });
  });
  const elements = document.querySelectorAll("*");
  elements.forEach((item) => {
    item.getAttributeNames().map((attr) => {
      if (FULL_EVENT_ATTRIBUTES.includes(attr)) {
        const [prefix, event, type] = attr.split("-");
        const value = item.getAttribute(attr);
        item.addEventListener(event, () => {
          switch (type) {
            case "fn":
              value ? Function(value)() : false;
              break;
            case "link":
              value ? (window.location.href = value) : false;
              break;
            case "open":
              value ? window.open(value, "_blank") : false;
              break;
          }
        });
        item.removeAttribute(attr);
      }
    });
  });
})();
