# S-EVENT.JS

turn your easy code to secure code

## Authors

- [@tasvet](https://www.npmjs.com/~tasvet)

## License

[MIT](https://choosealicense.com/licenses/mit/)

## Badges

[![MIT License](https://img.shields.io/apm/l/atomic-design-ui.svg?)](https://github.com/tterb/atomic-design-ui/blob/master/LICENSEs)
[![GPLv3 License](https://img.shields.io/badge/License-GPL%20v3-yellow.svg)](https://opensource.org/licenses/)
[![AGPL License](https://img.shields.io/badge/license-AGPL-blue.svg)](http://www.gnu.org/licenses/agpl-3.0)

## Documentation

[Documentation](https://linktodocumentation)

## Installation

Install s-event.js with npm

```bash
  npm install s-event.js --save
```

## Usage/Examples

in file `app.js`

```
    require('s-event.js');
```

in file `index.html`

```
    <body>
        ...
        <script src="path/app.js"></script>
    </body>
```

Usage :

```
    <a s-click-link="http://www.abc.com">
        Open link on current page
    </a>

    ...

    <a s-click-fn="test(10)">
        do on function
    </a>
    <script>
        function test(number){
            console.log(number);
       }
    </script>
```

```
    <tagName s-[event]-[type]></tagName>
```

How it work!

```
    //check resourse code

    <a s-click-link="http://www.abc.com">
        Open link on current page
    </a>

    to

    <a>
        Open link on current page
    </a>
    //when click will open http://www.abc.com
```

## Related

Here are some related projects

[Awesome README](https://github.com/matiassingers/awesome-readme)
