<?php

namespace Database\Seeders;

use App\Models\ModulePermission;
use App\Models\Permission;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Schema::disableForeignKeyConstraints();
        ModulePermission::truncate();
        Permission::truncate();
        Schema::enableForeignKeyConstraints();
        $view = "View";
        $show = "View Info";
        $create = "Create";
        $edit = "Edit";
        $delete = "Delete";
        $trash = "Trash";
        $destroy = "Destroy";
        $assign = "Assign";
        $unassign = "Unassign";
        $study = "Study Material";
        $assignUser = "Assign User";
        $print = "Print";

        $stDashboard = 1;
        $stStudent = 2;
        $stClassProgram = 3;
        $stProgramStructure = 4;
        $stLesson = 5;
        $stEducation = 6;
        $stLessonOccupation = 7;
        $stClassOccupation = 8;
        $stClass = 9;
        $stClassType = 10;
        $stClassStatus = 11;
        $stClassLevel = 12;
        $stShift = 13;
        $stExamType = 14;
        $stInternshipPlace = 15;
        $stStaffType = 16;
        $stStaffPosition = 17;
        $stStaff = 18;
        $stStudyScore = 19;
        $stStudyNote = 20;
        $stExamControl = 21;
        $stExamAnswerSheet = 22;
        $stExamCandidate = 23;
        $stExamSubject = 24;
        $stExamCandidate = 25;
        $stGroup = 26;
        $stStudentInternPlace = 27;
        $stClassImage = 28;
        $stAttendance = 29;
        $stStudentScore = 30;
        $stContact = 31;
        $stAbout = 32;
        $stSubAbout = 33;
        $stTrainer = 34;
        $stCourse = 35;
        $stPartner = 36;
        $stQuestion = 37;
        $stGallery = 38;
        $stVideo = 39;
        $stWorkDay = 40;
        $stExamScore = 41;
        $stAlbum = 42;
        $stSlide = 43;
        $stQoute = 44;
        $stUserFeedback = 45;
        $stTrainingVideo = 46;
        $stTrainingVideoCategory = 47;
        $stBranch = 48;
        
        //dashboard
        $dashboard = ModulePermission::create([
            'name' => 'Dashboard',
            'parent_id' => $stDashboard,
            'sort_no' => $stDashboard,
        ]);
        Permission::create([
            'display_name' => $view,
            'name' => 'dashboard-view',
            'guard_name' => 'web',
            'module_id' => $dashboard->id,
        ]);

        //student
        $student = ModulePermission::create([
            'name' => 'Student',
            'parent_id' => $stStudent,
            'sort_no' => $stStudent,

        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'student-view',
                'guard_name' => 'web',
                'module_id' => $student->id,
            ],
            [
                'display_name' => $show,
                'name' => 'student-view-info',
                'guard_name' => 'web',
                'module_id' => $student->id,
            ],
            [
                'display_name' => $create,
                'name' => 'student-create',
                'guard_name' => 'web',
                'module_id' => $student->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'student-update',
                'guard_name' => 'web',
                'module_id' => $student->id,
            ],
            [
                'display_name' => $assign,
                'name' => 'student-assign',
                'guard_name' => 'web',
                'module_id' => $student->id,
            ],
            [
                'display_name' => $print,
                'name' => 'student-print',
                'guard_name' => 'web',
                'module_id' => $student->id,
            ],
        ]);
        //end student

        //class program
        $classProgram = ModulePermission::create([
            'parent_name' => 'Class Management',
            'name' => 'Class Program',
            'parent_id' => $stClassProgram,
            'sort_no' => $stClassProgram,

        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'class-program-view',
                'guard_name' => 'web',
                'module_id' => $classProgram->id,
            ]
        ]);
        //end class program

        //structure program
        $structureProgram = ModulePermission::create([
            'parent_name' => 'Class Management',
            'name' => 'Structure Program',
            'parent_id' => $stProgramStructure,
            'sort_no' => $stProgramStructure,

        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'structure-program-view',
                'guard_name' => 'web',
                'module_id' => $structureProgram->id,
            ],
            [
                'display_name' => $show,
                'name' => 'structure-program-view-info',
                'guard_name' => 'web',
                'module_id' => $structureProgram->id,
            ],
            [
                'display_name' => $create,
                'name' => 'structure-program-create',
                'guard_name' => 'web',
                'module_id' => $structureProgram->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'structure-program-update',
                'guard_name' => 'web',
                'module_id' => $structureProgram->id,
            ],
            [
                'display_name' => $destroy,
                'name' => 'structure-program-destroy',
                'guard_name' => 'web',
                'module_id' => $structureProgram->id,
            ],
            [
                'display_name' => $assign,
                'name' => 'structure-program-assign',
                'guard_name' => 'web',
                'module_id' => $structureProgram->id,
            ],
            [
                'display_name' => $unassign,
                'name' => 'structure-program-unassign',
                'guard_name' => 'web',
                'module_id' => $structureProgram->id,
            ],
        ]);
        //end structure program

        //lesson
        $lesson = ModulePermission::create([
            'parent_name' => 'Class Management',
            'name' => 'Lesson',
            'parent_id' => $stLesson,
            'sort_no' => $stLesson,

        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'lesson-view',
                'guard_name' => 'web',
                'module_id' => $lesson->id,
            ],
            [
                'display_name' => $create,
                'name' => 'lesson-create',
                'guard_name' => 'web',
                'module_id' => $lesson->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'lesson-update',
                'guard_name' => 'web',
                'module_id' => $lesson->id,
            ],
            [
                'display_name' => $destroy,
                'name' => 'lesson-destroy',
                'guard_name' => 'web',
                'module_id' => $lesson->id,
            ],
            [
                'display_name' => $delete,
                'name' => 'lesson-delete',
                'guard_name' => 'web',
                'module_id' => $lesson->id,
            ],
        ]);
        //end lesson

        // education
        $education = ModulePermission::create([
            'parent_name' => 'Class Management',
            'name' => 'Education',
            'parent_id' => $stEducation,
            'sort_no' => $stEducation,

        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'education-view',
                'guard_name' => 'web',
                'module_id' => $education->id,
            ],
            [
                'display_name' => $create,
                'name' => 'education-create',
                'guard_name' => 'web',
                'module_id' => $education->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'education-update',
                'guard_name' => 'web',
                'module_id' => $education->id,
            ],
        ]);
        //end education

        // lesson occupation
        $lessonOccupation = ModulePermission::create([
            'parent_name' => 'Class Management',
            'name' => 'Lesson Occupation',
            'parent_id' => $stLessonOccupation,
            'sort_no' => $stLessonOccupation,

        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'lesson-occupation-view',
                'guard_name' => 'web',
                'module_id' => $lessonOccupation->id,
            ],
            [
                'display_name' => $create,
                'name' => 'lesson-occupation-create',
                'guard_name' => 'web',
                'module_id' => $lessonOccupation->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'lesson-occupation-update',
                'guard_name' => 'web',
                'module_id' => $lessonOccupation->id,
            ],
        ]);
        //end lesson occupation

        // lesson occupation
        $classOccupation = ModulePermission::create([
            'parent_name' => 'Class Management',
            'name' => 'Class Occupation',
            'parent_id' => $stClassOccupation,
            'sort_no' => $stClassOccupation,

        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'class-occupation-view',
                'guard_name' => 'web',
                'module_id' => $classOccupation->id,
            ],
            [
                'display_name' => $create,
                'name' => 'class-occupation-create',
                'guard_name' => 'web',
                'module_id' => $classOccupation->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'class-occupation-update',
                'guard_name' => 'web',
                'module_id' => $classOccupation->id,
            ],
        ]);
        //end lesson occupation

        // class
        $class = ModulePermission::create([
            'parent_name' => 'Class Management',
            'name' => 'Class',
            'parent_id' => $stClass,
            'sort_no' => $stClass,

        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'class-view',
                'guard_name' => 'web',
                'module_id' => $class->id,
            ],
            [
                'display_name' => $create,
                'name' => 'class-create',
                'guard_name' => 'web',
                'module_id' => $class->id,
            ],
            [
                'display_name' => $show,
                'name' => 'class-view-info',
                'guard_name' => 'web',
                'module_id' => $class->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'class-update',
                'guard_name' => 'web',
                'module_id' => $class->id,
            ],
            [
                'display_name' => $study,
                'name' => 'class-study-material',
                'guard_name' => 'web',
                'module_id' => $class->id,
            ],
            [
                'display_name' => $assign,
                'name' => 'class-assign',
                'guard_name' => 'web',
                'module_id' => $class->id,
            ],
            [
                'display_name' => $assignUser,
                'name' => 'class-assign-user',
                'guard_name' => 'web',
                'module_id' => $class->id,
            ],
        ]);
        //end class 

        // class type
        $classType = ModulePermission::create([
            'parent_name' => 'Class Management',
            'name' => 'Class Type',
            'parent_id' => $stClassType,
            'sort_no' => $stClassType,

        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'class-type-view',
                'guard_name' => 'web',
                'module_id' => $classType->id,
            ],
            [
                'display_name' => $create,
                'name' => 'class-type-create',
                'guard_name' => 'web',
                'module_id' => $classType->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'class-type-update',
                'guard_name' => 'web',
                'module_id' => $classType->id,
            ],
        ]);
        //end class type 

        // class status
        $classStatus = ModulePermission::create([
            'parent_name' => 'Class Management',
            'name' => 'Class Status',
            'parent_id' => $stClassStatus,
            'sort_no' => $stClassStatus,

        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'class-status-view',
                'guard_name' => 'web',
                'module_id' => $classStatus->id,
            ],
            [
                'display_name' => $create,
                'name' => 'class-status-create',
                'guard_name' => 'web',
                'module_id' => $classStatus->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'class-status-update',
                'guard_name' => 'web',
                'module_id' => $classStatus->id,
            ],
        ]);
        //end class status 

        // class level
        $classLevel = ModulePermission::create([
            'parent_name' => 'Class Management',
            'name' => 'Class Level',
            'parent_id' => $stClassLevel,
            'sort_no' => $stClassLevel,

        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'class-level-view',
                'guard_name' => 'web',
                'module_id' => $classLevel->id,
            ],
            [
                'display_name' => $create,
                'name' => 'class-level-create',
                'guard_name' => 'web',
                'module_id' => $classLevel->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'class-level-update',
                'guard_name' => 'web',
                'module_id' => $classLevel->id,
            ],
        ]);
        //end class level 

        // shift
        $shift = ModulePermission::create([
            'parent_name' => 'Class Management',
            'name' => 'Shift',
            'parent_id' => $stShift,
            'sort_no' => $stShift,

        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'shift-view',
                'guard_name' => 'web',
                'module_id' => $shift->id,
            ],
            [
                'display_name' => $create,
                'name' => 'shift-create',
                'guard_name' => 'web',
                'module_id' => $shift->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'shift-update',
                'guard_name' => 'web',
                'module_id' => $shift->id,
            ],
        ]);
        //end shift

        // exam type  
        $examType = ModulePermission::create([
            'parent_name' => 'Class Management',
            'name' => 'Exam Type',
            'parent_id' => $stExamType,
            'sort_no' => $stExamType,

        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'exam-type-view',
                'guard_name' => 'web',
                'module_id' => $examType->id,
            ],
            [
                'display_name' => $create,
                'name' => 'exam-type-create',
                'guard_name' => 'web',
                'module_id' => $examType->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'exam-type-update',
                'guard_name' => 'web',
                'module_id' => $examType->id,
            ],
        ]);
        //end exam type

        // internship place  
        $internshipPlace = ModulePermission::create([
            'parent_name' => 'Class Management',
            'name' => 'Internship Place',
            'parent_id' => $stInternshipPlace,
            'sort_no' => $stInternshipPlace,

        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'internship-place-view',
                'guard_name' => 'web',
                'module_id' => $internshipPlace->id,
            ],
            [
                'display_name' => $create,
                'name' => 'internship-place-create',
                'guard_name' => 'web',
                'module_id' => $internshipPlace->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'internship-place-update',
                'guard_name' => 'web',
                'module_id' => $internshipPlace->id,
            ],
        ]);
        //end internship place

        // staff type  
        $staffType = ModulePermission::create([
            'parent_name' => 'Staff Management',
            'name' => 'Staff Type',
            'parent_id' => $stStaffType,
            'sort_no' => $stStaffType,

        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'staff-type-view',
                'guard_name' => 'web',
                'module_id' => $staffType->id,
            ],
            [
                'display_name' => $create,
                'name' => 'staff-type-create',
                'guard_name' => 'web',
                'module_id' => $staffType->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'staff-type-update',
                'guard_name' => 'web',
                'module_id' => $staffType->id,
            ],
        ]);
        //end staff type

        // staff position  
        $staffPosition = ModulePermission::create([
            'parent_name' => 'Staff Management',
            'name' => 'Staff Position',
            'parent_id' => $stStaffPosition,
            'sort_no' => $stStaffPosition,

        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'staff-position-view',
                'guard_name' => 'web',
                'module_id' => $staffPosition->id,
            ],
            [
                'display_name' => $create,
                'name' => 'staff-position-create',
                'guard_name' => 'web',
                'module_id' => $staffPosition->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'staff-position-update',
                'guard_name' => 'web',
                'module_id' => $staffPosition->id,
            ],
        ]);
        //end staff position

        // staff   
        $staff = ModulePermission::create([
            'parent_name' => 'Staff Management',
            'name' => 'Staff',
            'parent_id' => $stStaff,
            'sort_no' => $stStaff,

        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'staff-view',
                'guard_name' => 'web',
                'module_id' => $staff->id,
            ],
            [
                'display_name' => $create,
                'name' => 'staff-create',
                'guard_name' => 'web',
                'module_id' => $staff->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'staff-update',
                'guard_name' => 'web',
                'module_id' => $staff->id,
            ],
        ]);
        //end staff 

        // study score
        $studyScore = ModulePermission::create([
            'parent_name' => 'Class Management',
            'name' => 'Study Score',
            'parent_id' => $stStudyScore,
            'sort_no' => $stStudyScore,

        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'study-score-view',
                'guard_name' => 'web',
                'module_id' => $studyScore->id,
            ],
            [
                'display_name' => $create,
                'name' => 'study-score-create',
                'guard_name' => 'web',
                'module_id' => $studyScore->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'study-score-update',
                'guard_name' => 'web',
                'module_id' => $studyScore->id,
            ],
        ]);
        //end study score

        // study note
        $studyNote = ModulePermission::create([
            'parent_name' => 'Class Management',
            'name' => 'Study Note',
            'parent_id' => $stStudyNote,
            'sort_no' => $stStudyNote,

        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'study-note-view',
                'guard_name' => 'web',
                'module_id' => $studyNote->id,
            ],
            [
                'display_name' => $show,
                'name' => 'study-note-view-info',
                'guard_name' => 'web',
                'module_id' => $studyNote->id,
            ],
            [
                'display_name' => $create,
                'name' => 'study-note-create',
                'guard_name' => 'web',
                'module_id' => $studyNote->id,
            ],
            [
                'display_name' => $destroy,
                'name' => 'study-note-destroy',
                'guard_name' => 'web',
                'module_id' => $studyNote->id,
            ],
        ]);
        //end study note

        // exam control
        $examControl = ModulePermission::create([
            'parent_name' => 'Class Management',
            'name' => 'Exam Control',
            'parent_id' => $stExamControl,
            'sort_no' => $stExamControl,

        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'exam-control-view',
                'guard_name' => 'web',
                'module_id' => $examControl->id,
            ],
            [
                'display_name' => $create,
                'name' => 'exam-control-create',
                'guard_name' => 'web',
                'module_id' => $examControl->id,
            ],
            [
                'display_name' => $destroy,
                'name' => 'exam-control-destroy',
                'guard_name' => 'web',
                'module_id' => $examControl->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'exam-control-update',
                'guard_name' => 'web',
                'module_id' => $examControl->id,
            ],
            [
                'display_name' => $show,
                'name' => 'exam-control-view-info',
                'guard_name' => 'web',
                'module_id' => $examControl->id,
            ],
            [
                'display_name' => 'Score Table',
                'name' => 'exam-control-score-table',
                'guard_name' => 'web',
                'module_id' => $examControl->id,
            ],
        ]);
        //end exam control

        // study note
        $examAnswerSheet = ModulePermission::create([
            'parent_name' => 'Class Management',
            'name' => 'Exam Answer Sheet',
            'parent_id' => $stExamAnswerSheet,
            'sort_no' => $stExamAnswerSheet,

        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'exam-answer-sheet-view',
                'guard_name' => 'web',
                'module_id' => $examAnswerSheet->id,
            ],
            [
                'display_name' => $create,
                'name' => 'exam-answer-sheet-create',
                'guard_name' => 'web',
                'module_id' => $examAnswerSheet->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'exam-answer-sheet-update',
                'guard_name' => 'web',
                'module_id' => $examAnswerSheet->id,
            ],
            [
                'display_name' => $destroy,
                'name' => 'exam-answer-sheet-destroy',
                'guard_name' => 'web',
                'module_id' => $examAnswerSheet->id,
            ],
        ]);
        //end exam answer sheet

        // exam subject
        $examSubject = ModulePermission::create([
            'parent_name' => 'Class Management',
            'name' => 'Exam Subject',
            'parent_id' => $stExamSubject,
            'sort_no' => $stExamSubject,

        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'exam-subject-view',
                'guard_name' => 'web',
                'module_id' => $examSubject->id,
            ],
            [
                'display_name' => $view,
                'name' => 'exam-subject-view-info',
                'guard_name' => 'web',
                'module_id' => $examSubject->id,
            ],
            [
                'display_name' => $create,
                'name' => 'exam-subject-create',
                'guard_name' => 'web',
                'module_id' => $examSubject->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'exam-subject-update',
                'guard_name' => 'web',
                'module_id' => $examSubject->id,
            ],
            [
                'display_name' => $destroy,
                'name' => 'exam-subject-destroy',
                'guard_name' => 'web',
                'module_id' => $examSubject->id,
            ],
            [
                'display_name' => 'To Score',
                'name' => 'exam-subject-to-score',
                'guard_name' => 'web',
                'module_id' => $examSubject->id,
            ],
        ]);
        //end exam subject

        // exam candidate
        $examCandidate = ModulePermission::create([
            'parent_name' => 'Class Management',
            'name' => 'Exam Candidate',
            'parent_id' => $stExamCandidate,
            'sort_no' => $stExamCandidate,

        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'exam-candidate-view',
                'guard_name' => 'web',
                'module_id' => $examCandidate->id,
            ],
            [
                'display_name' => $assign,
                'name' => 'exam-candidate-assign',
                'guard_name' => 'web',
                'module_id' => $examCandidate->id,
            ],
            [
                'display_name' => $unassign,
                'name' => 'exam-candidate-unassign',
                'guard_name' => 'web',
                'module_id' => $examCandidate->id,
            ],
            [
                'display_name' => $print,
                'name' => 'exam-candidate-print',
                'guard_name' => 'web',
                'module_id' => $examCandidate->id,
            ],
        ]);
        //end exam subject

        //group
        $group = ModulePermission::create([
            'parent_name' => 'Class Management',
            'name' => 'Group',
            'parent_id' => $stGroup,
            'sort_no' => $stGroup,
        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'group-view',
                'guard_name' => 'web',
                'module_id' => $group->id,
            ],
            [
                'display_name' => $create,
                'name' => 'group-create',
                'guard_name' => 'web',
                'module_id' => $group->id,
            ],
            [
                'display_name' => $show,
                'name' => 'group-view-info',
                'guard_name' => 'web',
                'module_id' => $group->id,
            ],
            [
                'display_name' => $destroy,
                'name' => 'group-destroy',
                'guard_name' => 'web',
                'module_id' => $group->id,
            ],
            [
                'display_name' => $assign,
                'name' => 'group-assign',
                'guard_name' => 'web',
                'module_id' => $group->id,
            ],
            [
                'display_name' => $unassign,
                'name' => 'group-unassign',
                'guard_name' => 'web',
                'module_id' => $group->id,
            ],
            [
                'display_name' => $print,
                'name' => 'group-print',
                'guard_name' => 'web',
                'module_id' => $group->id,
            ],
        ]);
        //end group

        //student intern place
        $studentInternPlace = ModulePermission::create([
            'parent_name' => 'Class Management',
            'name' => 'Student Intern Place',
            'parent_id' => $stStudentInternPlace,
            'sort_no' => $stStudentInternPlace,
        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'student-intern-place-view',
                'guard_name' => 'web',
                'module_id' => $studentInternPlace->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'student-intern-place-update',
                'guard_name' => 'web',
                'module_id' => $studentInternPlace->id,
            ],
            [
                'display_name' => $create,
                'name' => 'student-intern-place-create',
                'guard_name' => 'web',
                'module_id' => $studentInternPlace->id,
            ],
            [
                'display_name' => $destroy,
                'name' => 'student-intern-place-destroy',
                'guard_name' => 'web',
                'module_id' => $studentInternPlace->id,
            ]
        ]);
        //end student intern place

        //class image
        $classImage = ModulePermission::create([
            'parent_name' => 'Class Management',
            'name' => 'Class Image',
            'parent_id' => $stClassImage,
            'sort_no' => $stClassImage,
        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'class-image-view',
                'guard_name' => 'web',
                'module_id' => $classImage->id,
            ],
            [
                'display_name' => $create,
                'name' => 'class-image-create',
                'guard_name' => 'web',
                'module_id' => $classImage->id,
            ],
            [
                'display_name' => $destroy,
                'name' => 'class-image-destroy',
                'guard_name' => 'web',
                'module_id' => $classImage->id,
            ]
        ]);
        //end class image

        //attendance
        $attendance = ModulePermission::create([
            'parent_name' => 'Class Management',
            'name' => 'Attendance',
            'parent_id' => $stAttendance,
            'sort_no' => $stAttendance,
        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'attendance-view',
                'guard_name' => 'web',
                'module_id' => $attendance->id,
            ],
            [
                'display_name' => $create,
                'name' => 'attendance-create',
                'guard_name' => 'web',
                'module_id' => $attendance->id,
            ],
            [
                'display_name' => $destroy,
                'name' => 'attendance-destroy',
                'guard_name' => 'web',
                'module_id' => $attendance->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'attendance-update',
                'guard_name' => 'web',
                'module_id' => $attendance->id,
            ],
            [
                'display_name' => $show,
                'name' => 'attendance-view-info',
                'guard_name' => 'web',
                'module_id' => $attendance->id,
            ],
            [
                'display_name' => $print,
                'name' => 'attendance-print',
                'guard_name' => 'web',
                'module_id' => $attendance->id,
            ]
        ]);
        //end attendance

        //student score
        $studentScore = ModulePermission::create([
            'parent_name' => 'Class Management',
            'name' => 'Student Score',
            'parent_id' => $stStudentScore,
            'sort_no' => $stStudentScore,
        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'student-score-view',
                'guard_name' => 'web',
                'module_id' => $studentScore->id,
            ],
            [
                'display_name' => $create,
                'name' => 'student-score-create',
                'guard_name' => 'web',
                'module_id' => $studentScore->id,
            ],
            [
                'display_name' => $destroy,
                'name' => 'student-score-destroy',
                'guard_name' => 'web',
                'module_id' => $studentScore->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'student-score-update',
                'guard_name' => 'web',
                'module_id' => $studentScore->id,
            ],
            [
                'display_name' => $show,
                'name' => 'student-score-view-info',
                'guard_name' => 'web',
                'module_id' => $studentScore->id,
            ],
            [
                'display_name' => $print,
                'name' => 'student-score-print',
                'guard_name' => 'web',
                'module_id' => $studentScore->id,
            ]
        ]);
        //end student score

        // contact
        $contact = ModulePermission::create([
            'parent_name' => 'Setting Management',
            'name' => 'Contact',
            'parent_id' => $stContact,
            'sort_no' => $stContact,
        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'contact-view',
                'guard_name' => 'web',
                'module_id' => $contact->id,
            ],
        ]);
        //end contact

        // about
        $about = ModulePermission::create([
            'parent_name' => 'Setting Management',
            'name' => 'About',
            'parent_id' => $stAbout,
            'sort_no' => $stAbout,
        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'about-view',
                'guard_name' => 'web',
                'module_id' => $about->id,
            ],
        ]);
        //end about

        // sub about
        $subAbout = ModulePermission::create([
            'parent_name' => 'Setting Management',
            'name' => 'About Child',
            'parent_id' => $stSubAbout,
            'sort_no' => $stSubAbout,
        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'about-child-view',
                'guard_name' => 'web',
                'module_id' => $subAbout->id,
            ],
            [
                'display_name' => $create,
                'name' => 'about-child-create',
                'guard_name' => 'web',
                'module_id' => $subAbout->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'about-child-update',
                'guard_name' => 'web',
                'module_id' => $subAbout->id,
            ],
        ]);
        //end sub about

        // trainer
        $trainer = ModulePermission::create([
            'parent_name' => 'Setting Management',
            'name' => 'Trainer',
            'parent_id' => $stTrainer,
            'sort_no' => $stTrainer,
        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'trainer-view',
                'guard_name' => 'web',
                'module_id' => $trainer->id,
            ],
            [
                'display_name' => $create,
                'name' => 'trainer-create',
                'guard_name' => 'web',
                'module_id' => $trainer->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'trainer-update',
                'guard_name' => 'web',
                'module_id' => $trainer->id,
            ],
        ]);
        //end trainer

        // course
        $course = ModulePermission::create([
            'parent_name' => 'Setting Management',
            'name' => 'Course',
            'parent_id' => $stCourse,
            'sort_no' => $stCourse,
        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'course-view',
                'guard_name' => 'web',
                'module_id' => $course->id,
            ],
            [
                'display_name' => $create,
                'name' => 'course-create',
                'guard_name' => 'web',
                'module_id' => $course->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'course-update',
                'guard_name' => 'web',
                'module_id' => $course->id,
            ],
        ]);
        //end course

        // partner
        $partner = ModulePermission::create([
            'parent_name' => 'Setting Management',
            'name' => 'Partner',
            'parent_id' => $stPartner,
            'sort_no' => $stPartner,
        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'partner-view',
                'guard_name' => 'web',
                'module_id' => $partner->id,
            ],
            [
                'display_name' => $create,
                'name' => 'partner-create',
                'guard_name' => 'web',
                'module_id' => $partner->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'partner-update',
                'guard_name' => 'web',
                'module_id' => $partner->id,
            ],
        ]);
        //end partner

        // question
        $question = ModulePermission::create([
            'parent_name' => 'Setting Management',
            'name' => 'Question',
            'parent_id' => $stQuestion,
            'sort_no' => $stQuestion,
        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'question-view',
                'guard_name' => 'web',
                'module_id' => $question->id,
            ],
            [
                'display_name' => $create,
                'name' => 'question-create',
                'guard_name' => 'web',
                'module_id' => $question->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'question-update',
                'guard_name' => 'web',
                'module_id' => $question->id,
            ],
        ]);
        //end question

        // gallery
        $gallery = ModulePermission::create([
            'parent_name' => 'Setting Management',
            'name' => 'Gallery',
            'parent_id' => $stGallery,
            'sort_no' => $stGallery,
        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'gallery-view',
                'guard_name' => 'web',
                'module_id' => $gallery->id,
            ],
            [
                'display_name' => $create,
                'name' => 'gallery-create',
                'guard_name' => 'web',
                'module_id' => $gallery->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'gallery-update',
                'guard_name' => 'web',
                'module_id' => $gallery->id,
            ],
        ]);
        //end gallery

        // video
        $video = ModulePermission::create([
            'parent_name' => 'Setting Management',
            'name' => 'Video',
            'parent_id' => $stVideo,
            'sort_no' => $stVideo,
        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'video-view',
                'guard_name' => 'web',
                'module_id' => $video->id,
            ],
            [
                'display_name' => $create,
                'name' => 'video-create',
                'guard_name' => 'web',
                'module_id' => $video->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'video-update',
                'guard_name' => 'web',
                'module_id' => $video->id,
            ],
        ]);
        //end video

        // work day
        $workDay = ModulePermission::create([
            'parent_name' => 'Setting Management',
            'name' => 'Work Day',
            'parent_id' => $stWorkDay,
            'sort_no' => $stWorkDay,
        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'work-day-view',
                'guard_name' => 'web',
                'module_id' => $workDay->id,
            ],
            [
                'display_name' => $create,
                'name' => 'work-day-create',
                'guard_name' => 'web',
                'module_id' => $workDay->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'work-day-update',
                'guard_name' => 'web',
                'module_id' => $workDay->id,
            ],
        ]);
        //end work day
        
        // exam score
        $examScore = ModulePermission::create([
            'parent_name' => 'Class Management',
            'name' => 'Exam Score',
            'parent_id' => $stExamScore,
            'sort_no' => $stExamScore,
        ]);
        Permission::insert([
            [
                'display_name' => $create,
                'name' => 'exam-score-create',
                'guard_name' => 'web',
                'module_id' => $examScore->id,
            ],
        ]);
        // end exam score
        
        // album
        $album = ModulePermission::create([
            'parent_name' => 'Setting Management',
            'name' => 'Album',
            'parent_id' => $stAlbum,
            'sort_no' => $stAlbum,

        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'album-view',
                'guard_name' => 'web',
                'module_id' => $album->id,
            ],
            [
                'display_name' => $create,
                'name' => 'album-create',
                'guard_name' => 'web',
                'module_id' => $album->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'album-update',
                'guard_name' => 'web',
                'module_id' => $album->id,
            ],
        ]);
        //end album
        
        // slide
        $slide = ModulePermission::create([
            'parent_name' => 'Setting Management',
            'name' => 'Slide',
            'parent_id' => $stSlide,
            'sort_no' => $stSlide,

        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'slide-view',
                'guard_name' => 'web',
                'module_id' => $slide->id,
            ],
            [
                'display_name' => $create,
                'name' => 'slide-create',
                'guard_name' => 'web',
                'module_id' => $slide->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'slide-update',
                'guard_name' => 'web',
                'module_id' => $slide->id,
            ],
        ]);
        //end slide
        
        // qoute
        $qoute = ModulePermission::create([
            'parent_name' => 'Setting Management',
            'name' => 'Qoute',
            'parent_id' => $stQoute,
            'sort_no' => $stQoute,

        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'qoute-view',
                'guard_name' => 'web',
                'module_id' => $qoute->id,
            ],
            [
                'display_name' => $create,
                'name' => 'qoute-create',
                'guard_name' => 'web',
                'module_id' => $qoute->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'qoute-update',
                'guard_name' => 'web',
                'module_id' => $qoute->id,
            ],
        ]);
        //end qoute
        
        // user feedback
        $userFeedback = ModulePermission::create([
            'parent_name' => 'Setting Management',
            'name' => 'User Feedback',
            'parent_id' => $stUserFeedback,
            'sort_no' => $stUserFeedback,

        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'user-feedback-view',
                'guard_name' => 'web',
                'module_id' => $userFeedback->id,
            ],
        ]);
        //end user feedback
        
        // training-video
        $trainingVideo = ModulePermission::create([
            'parent_name' => 'Setting Management',
            'name' => 'Training Video',
            'parent_id' => $stTrainingVideo,
            'sort_no' => $stTrainingVideo,

        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'training-video-view',
                'guard_name' => 'web',
                'module_id' => $trainingVideo->id,
            ],
            [
                'display_name' => $create,
                'name' => 'training-video-create',
                'guard_name' => 'web',
                'module_id' => $trainingVideo->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'training-video-update',
                'guard_name' => 'web',
                'module_id' => $trainingVideo->id,
            ],
        ]);
        //end training-video
        
        // category
        $trainingVideoCategory = ModulePermission::create([
            'parent_name' => 'Setting Management',
            'name' => 'Training Video Category',
            'parent_id' => $stTrainingVideoCategory,
            'sort_no' => $stTrainingVideoCategory,

        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'category-view',
                'guard_name' => 'web',
                'module_id' => $trainingVideoCategory->id,
            ],
            [
                'display_name' => $create,
                'name' => 'category-create',
                'guard_name' => 'web',
                'module_id' => $trainingVideoCategory->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'category-update',
                'guard_name' => 'web',
                'module_id' => $trainingVideoCategory->id,
            ],
        ]);
        //end category
        
        //branch
        $branch = ModulePermission::create([
            'parent_name' => 'Branch Management',
            'name' => 'Branch',
            'parent_id' => $stBranch,
            'sort_no' => $stBranch,

        ]);
        Permission::insert([
            [
                'display_name' => $view,
                'name' => 'branch-view',
                'guard_name' => 'web',
                'module_id' => $branch->id,
            ],
            [
                'display_name' => $create,
                'name' => 'branch-create',
                'guard_name' => 'web',
                'module_id' => $branch->id,
            ],
            [
                'display_name' => $edit,
                'name' => 'branch-update',
                'guard_name' => 'web',
                'module_id' => $branch->id,
            ],
            [
                'display_name' => $destroy,
                'name' => 'branch-destroy',
                'guard_name' => 'web',
                'module_id' => $branch->id,
            ],
            [
                'display_name' => $delete,
                'name' => 'branch-delete',
                'guard_name' => 'web',
                'module_id' => $branch->id,
            ],
        ]);
        //end branch
    }
}
