<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('trainers', function (Blueprint $table) {
            $table->id();
            $table->string('name', 255);
            $table->text('profile')->nullable();
            $table->double('experience', 8, 2);
            $table->string('skill', 255);
            $table->string('work', 255)->nullable();
            $table->string('position', 255)->nullable();
            $table->tinyInteger('status');
            $table->tinyInteger('certified')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('trainers');
    }
};
