<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('classes', function (Blueprint $table) {
            $table->id();
            $table->integer('staff_id');
            $table->integer('class_type_id');
            $table->integer('class_level_id');
            $table->integer('shift_id');
            $table->integer('class_status_id');
            $table->string('class_code');
            $table->integer('generation');
            $table->integer('group');
            $table->integer('period_duration');
            $table->date('start_date');
            $table->date('end_date');
            $table->longText('url_google_sheet_edit')->nullable();
            $table->longText('url_google_sheet_view')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('classes');
    }
};
