<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('students', function (Blueprint $table) {
            $table->id();
            $table->integer('education_level_id');
            $table->json('full_name')->comment('km, en');
            $table->date('dob');
            $table->string('email')->nullable();
            $table->string('id_card')->nullable();
            $table->string('phone');
            $table->string('phone_with_telegram')->nullable();
            $table->string('gender');
            $table->string('profile')->nullable();
            $table->longText('address')->comment('km, en')->nullable();
            $table->text('noted')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('students');
    }
};
