<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('staffs', function (Blueprint $table) {
            $table->id();
            $table->integer('staff_type_id');
            $table->json('full_name')->comment('km, en');
            $table->string('email')->unique()->nullable();
            $table->string('phone')->nullable();
            $table->string('gender');
            $table->string('profile')->nullable();
            $table->tinyInteger('status');
            $table->string('cv')->nullable();
            $table->text('noted')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('staffs');
    }
};
