-- Adminer 4.7.8 MySQL dump

SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';

SET NAMES utf8mb4;

DROP TABLE IF EXISTS `abouts`;
CREATE TABLE `abouts` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `mission` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `vision` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `abouts` (`id`, `title`, `description`, `mission`, `vision`, `image`, `status`, `created_at`, `updated_at`) VALUES
(1,	'Overview',	'Started in 2014 under the name “Serge Comtesse” located near the central market as a salon and retailer of Schwarzkopf Professional. 5 years later, in 2019, we have transformed ourselves by seeing the further vision of hairdressing sector in Cambodia which is in need of skill development. We invested in a building to support this sector including education/training, products, materials, equipment, salon software, salon franchise and salon consultation. We are called “Asian Beauty Hair Club”. To preserve our origin, we decided to name ourselves “Serge Comtesse – Asian beauty Hair Club (SC-ABHC)”.',	'SC-ABHC was created for the mission to serve our partners with highly professional, passion, integrity and discipline in order to make them success in their business through different activities such as Education, Innovation, Connection, and Branding.',	'\"Education is the only way that changes the way hairdresser does salon business today.\"',	'/bktu0h1624588034210Overview Image-01-5a599f3f-a1f9-4a52-a3e4-7b1b4560349b.png',	1,	'2023-04-25 07:29:12',	'2023-04-29 00:15:37');

DROP TABLE IF EXISTS `about_childs`;
CREATE TABLE `about_childs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) NOT NULL,
  `about_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `about_childs` (`id`, `title`, `description`, `image`, `status`, `about_id`, `created_at`, `updated_at`) VALUES
(1,	'2021',	'Schwarzkopf Professional ASK Academy Cambodia is recognized by the Global Team and listed as one of  ASK Academy Locations around world. \r\n\r\nThis program is created to provide hairdresser with Personal Development, Creativity, New Trends around the Globe, and Innovation of Hair Products/Tools.',	'/ctkk4416251996415742021-01-89825b88-48a1-4358-a6ba-7ae570ce301e.jpg',	1,	1,	'2023-04-25 07:30:14',	'2023-04-25 07:30:14'),
(2,	'2020',	'L\'Ecole International de Coiffure et d\'Estétique (L.I.C.E) powered by ABHC is registered under Procas of Ministry of Labor and Vocational Training. L.I.C.E offers training of Hairdressing, Nail Styling and Beauty which is conducted into 3 levels: C1, C2, and C3.',	'/ctkk4416251996415742021-01-ee6aaeae-c5f4-4473-bfca-94a31ba8914d.jpg',	1,	1,	'2023-04-27 01:49:06',	'2023-04-27 01:49:06'),
(3,	'2019',	'We invested in a building to support hairdressing sector by seeing the further vision which is in need of skill development. We are the solution for salon also known as \"Salon One-Stop\" which consists of education/training, products, materials, equipment, salon software, salon franchise, and salon consultation.',	'/okcet516251996415702019-01-5cc40f0a-c608-4d3c-8fac-358410821752.jpg',	1,	1,	'2023-04-27 01:49:34',	'2023-04-27 01:49:34'),
(4,	'2021',	'Schwarzkopf Professional ASK Academy Cambodia is recognized by the Global Team and listed as one of  ASK Academy Locations around world. \r\n\r\nThis program is created to provide hairdresser with Personal Development, Creativity, New Trends around the Globe, and Innovation of Hair Products/Tools.',	'/ctkk4416251996415742021-01-89825b88-48a1-4358-a6ba-7ae570ce301e.jpg',	1,	1,	'2023-04-25 07:30:14',	'2023-04-25 07:30:14'),
(5,	'2020',	'L\'Ecole International de Coiffure et d\'Estétique (L.I.C.E) powered by ABHC is registered under Procas of Ministry of Labor and Vocational Training. L.I.C.E offers training of Hairdressing, Nail Styling and Beauty which is conducted into 3 levels: C1, C2, and C3.',	'/ctkk4416251996415742021-01-ee6aaeae-c5f4-4473-bfca-94a31ba8914d.jpg',	1,	1,	'2023-04-27 01:49:06',	'2023-04-27 01:49:06'),
(6,	'2019',	'We invested in a building to support hairdressing sector by seeing the further vision which is in need of skill development. We are the solution for salon also known as \"Salon One-Stop\" which consists of education/training, products, materials, equipment, salon software, salon franchise, and salon consultation.',	'/okcet516251996415702019-01-5cc40f0a-c608-4d3c-8fac-358410821752.jpg',	1,	1,	'2023-04-27 01:49:34',	'2023-04-27 01:49:34');

DROP TABLE IF EXISTS `attendances`;
CREATE TABLE `attendances` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `class_id` int(11) NOT NULL,
  `lesson_id` int(11) NOT NULL,
  `student_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_attended` tinyint(4) NOT NULL DEFAULT 0,
  `log_date` datetime NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `attendances` (`id`, `class_id`, `lesson_id`, `student_id`, `is_attended`, `log_date`, `created_at`, `updated_at`) VALUES
(1,	3,	5,	'[72,71]',	1,	'2023-03-14 18:21:15',	'2023-03-14 22:21:15',	'2023-03-14 22:22:00'),
(2,	3,	5,	'[72,71]',	1,	'2023-05-04 11:24:03',	'2023-05-04 15:24:03',	'2023-05-04 15:24:03');

DROP TABLE IF EXISTS `attendance_status`;
CREATE TABLE `attendance_status` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `class_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `today_attended` tinyint(4) NOT NULL DEFAULT 0,
  `attend_amount` int(11) NOT NULL,
  `attend_percent` double(8,2) NOT NULL,
  `attend_status` tinyint(4) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `attendance_status` (`id`, `class_id`, `student_id`, `today_attended`, `attend_amount`, `attend_percent`, `attend_status`, `created_at`, `updated_at`) VALUES
(1,	3,	72,	0,	2,	29.00,	0,	'2023-04-05 01:37:09',	'2023-05-04 19:45:35'),
(2,	3,	71,	0,	2,	29.00,	0,	'2023-04-05 01:37:09',	'2023-05-04 19:45:35');

DROP TABLE IF EXISTS `branches`;
CREATE TABLE `branches` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `working_day` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `working_hour` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) NOT NULL,
  `is_default` tinyint(4) NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `branches` (`id`, `name`, `address`, `phone`, `email`, `logo`, `website`, `working_day`, `working_hour`, `status`, `is_default`, `user_id`, `created_at`, `updated_at`) VALUES
(1,	'International',	'Phnom Penh',	'127 7556 1790',	'international.lice@gmail.com',	'/chalo-gallardo-QAhSbzy1XhA-unsplash-0de10ae8-ce34-4938-9b1f-8ae6a478d477.jpg',	NULL,	NULL,	NULL,	1,	0,	0,	'2023-05-11 22:14:01',	'2023-05-12 14:16:41'),
(2,	'Cambodia Branch',	'Phnom Penh',	'+885 97 898 7658',	'kh.lice@gmail.com',	NULL,	NULL,	NULL,	NULL,	1,	0,	0,	'2023-05-11 22:14:40',	'2023-05-11 22:14:40'),
(3,	'Thailand Branch',	'Bangkok',	'+66 66 991 500',	'th.lice@gmail.com',	NULL,	NULL,	NULL,	NULL,	1,	0,	5,	'2023-05-12 12:43:05',	'2023-06-28 20:15:53');

DROP TABLE IF EXISTS `branch_codes`;
CREATE TABLE `branch_codes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `branch_id` bigint(20) unsigned NOT NULL,
  `parent_code` varchar(125) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `branch_codes` (`id`, `code`, `branch_id`, `parent_code`, `parent_id`) VALUES
(1,	'BC001',	1,	NULL,	NULL),
(2,	'BC002',	2,	NULL,	NULL),
(3,	'BC003',	3,	NULL,	NULL);

DROP TABLE IF EXISTS `classes`;
CREATE TABLE `classes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `class_type_id` int(11) NOT NULL,
  `class_level_id` int(11) NOT NULL,
  `shift_id` int(11) NOT NULL,
  `class_status_id` int(11) NOT NULL,
  `class_code` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `generation` int(11) NOT NULL,
  `group` int(11) NOT NULL,
  `period_duration` int(11) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `url_google_sheet_edit` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url_google_sheet_view` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `class_cost` double DEFAULT 0,
  `supplies_cost` double DEFAULT 0,
  `total_cost` double DEFAULT 0,
  `user_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `classes` (`id`, `staff_id`, `class_type_id`, `class_level_id`, `shift_id`, `class_status_id`, `class_code`, `generation`, `group`, `period_duration`, `start_date`, `end_date`, `url_google_sheet_edit`, `url_google_sheet_view`, `class_cost`, `supplies_cost`, `total_cost`, `user_id`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1,	2,	2,	1,	3,	2,	'001',	1,	1,	10,	'2023-01-22',	'2023-01-23',	NULL,	NULL,	0,	0,	0,	0,	'2023-01-22 13:40:48',	'2023-01-22 13:43:10',	NULL),
(2,	2,	1,	1,	3,	1,	'002',	2,	2,	1,	'2023-01-22',	'2023-01-31',	NULL,	NULL,	0,	0,	0,	0,	'2023-01-22 14:05:19',	'2023-01-22 14:05:19',	NULL),
(3,	2,	1,	1,	3,	1,	'003',	3,	3,	12,	'2023-01-23',	'2023-01-31',	NULL,	NULL,	0,	0,	0,	0,	'2023-01-23 13:16:29',	'2023-01-23 13:16:29',	NULL),
(4,	9,	2,	1,	3,	1,	'SC004',	3,	5,	1,	'2023-05-05',	'2023-06-05',	NULL,	NULL,	10,	0,	10,	1,	'2023-05-05 13:44:50',	'2023-12-16 11:59:54',	NULL);

DROP TABLE IF EXISTS `class_allow_users`;
CREATE TABLE `class_allow_users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `class_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `class_allow_users` (`id`, `class_id`, `user_id`, `created_at`, `updated_at`) VALUES
(1,	3,	6,	'2023-05-04 14:50:57',	'2023-05-04 14:50:57'),
(2,	3,	7,	'2023-05-04 15:23:09',	'2023-05-04 15:23:09');

DROP TABLE IF EXISTS `class_images`;
CREATE TABLE `class_images` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `class_id` int(11) NOT NULL,
  `image` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image_date` datetime NOT NULL,
  `image_description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `class_images` (`id`, `class_id`, `image`, `image_date`, `image_description`, `created_at`, `updated_at`) VALUES
(1,	3,	'/bktu0h1624588034210Overview Image-01-5a599f3f-a1f9-4a52-a3e4-7b1b4560349b.png',	'2023-05-04 00:00:00',	'Good',	'2023-05-04 20:42:00',	'2023-05-04 20:42:00');

DROP TABLE IF EXISTS `class_levels`;
CREATE TABLE `class_levels` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `class_levels` (`id`, `name`, `status`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1,	'C1',	1,	'2022-12-28 02:28:42',	'2023-01-23 20:14:33',	NULL),
(2,	'tttts2',	2,	'2023-01-09 14:49:06',	'2023-01-09 14:50:03',	NULL),
(3,	'As',	2,	'2023-01-09 15:15:18',	'2023-01-09 15:16:23',	NULL),
(4,	'C2',	1,	'2023-01-23 20:14:43',	'2023-01-23 20:14:43',	NULL),
(5,	'C3',	1,	'2023-01-23 20:14:52',	'2023-01-23 20:14:52',	NULL),
(6,	'Other',	1,	'2023-01-23 20:15:00',	'2023-05-04 18:19:01',	NULL),
(7,	'Advance 02',	2,	'2023-05-04 18:18:45',	'2023-05-04 18:18:53',	NULL);

DROP TABLE IF EXISTS `class_occupations`;
CREATE TABLE `class_occupations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `class_occupations` (`id`, `name`, `status`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1,	'Man Hair Cut',	1,	'2023-01-22 13:37:01',	'2023-01-23 21:05:37',	NULL),
(2,	'Nail Dressing',	1,	'2023-01-22 14:09:34',	'2023-01-23 21:05:14',	NULL),
(3,	'Hair Dressing',	1,	'2023-01-23 13:17:32',	'2023-05-04 17:19:46',	NULL),
(4,	'Coloring',	1,	'2023-05-04 17:20:04',	'2023-05-04 17:20:04',	NULL),
(5,	'Beauty',	1,	'2023-11-25 09:35:30',	'2023-11-25 09:35:30',	NULL);

DROP TABLE IF EXISTS `class_statuses`;
CREATE TABLE `class_statuses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `class_statuses` (`id`, `name`, `status`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1,	'Initializing',	1,	'2022-12-28 02:28:18',	'2023-01-23 20:16:28',	NULL),
(2,	'Continuing',	1,	'2023-01-09 14:50:47',	'2023-01-23 20:15:53',	NULL),
(3,	'Canceled',	1,	'2023-01-23 20:21:35',	'2023-05-04 18:00:44',	NULL),
(4,	'Finished',	1,	'2023-01-23 20:24:13',	'2023-01-23 20:24:13',	NULL),
(5,	'Certified',	1,	'2023-05-04 18:14:32',	'2023-05-04 18:14:32',	NULL);

DROP TABLE IF EXISTS `class_structure_programs`;
CREATE TABLE `class_structure_programs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `class_id` int(11) NOT NULL,
  `structure_program_id` int(11) NOT NULL,
  `generic_full_score` double(8,2) NOT NULL,
  `functional_full_score` double(8,2) NOT NULL,
  `generic_subject` int(11) NOT NULL DEFAULT 0,
  `functional_subject` int(11) NOT NULL DEFAULT 0,
  `each_generic_score` double(8,2) NOT NULL,
  `each_functional_score` double(8,2) NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `class_structure_programs` (`id`, `class_id`, `structure_program_id`, `generic_full_score`, `functional_full_score`, `generic_subject`, `functional_subject`, `each_generic_score`, `each_functional_score`, `user_id`, `created_at`, `updated_at`) VALUES
(1,	1,	1,	0.00,	0.00,	10,	0,	0.00,	0.00,	0,	'2023-01-22 13:40:59',	'2023-01-22 13:41:22'),
(2,	2,	1,	0.00,	0.00,	0,	0,	0.00,	0.00,	0,	'2023-01-22 14:07:54',	'2023-01-22 14:07:54'),
(3,	3,	4,	0.00,	0.00,	0,	0,	0.00,	0.00,	0,	'2023-01-23 13:18:37',	'2023-01-23 13:18:37');

DROP TABLE IF EXISTS `class_types`;
CREATE TABLE `class_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `class_types` (`id`, `name`, `status`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1,	'Specific Course',	1,	'2022-12-27 10:21:07',	'2023-01-23 20:28:17',	NULL),
(2,	'Short Course',	1,	'2022-12-27 10:23:34',	'2023-01-23 20:27:56',	NULL),
(3,	'General Course',	1,	'2023-01-09 14:52:54',	'2023-01-23 20:26:33',	NULL),
(4,	'Special Course',	1,	'2023-01-23 20:28:42',	'2023-01-23 20:30:16',	NULL),
(5,	'ASK Course',	1,	'2023-01-23 20:31:40',	'2023-01-23 20:31:40',	NULL),
(6,	'Other Course',	1,	'2023-01-23 20:32:25',	'2023-05-04 17:51:03',	NULL);

DROP TABLE IF EXISTS `contacts`;
CREATE TABLE `contacts` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `facebook` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `instagram` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `youtube` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telegram` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google_map` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `contacts` (`id`, `email`, `phone`, `address`, `image`, `name`, `facebook`, `instagram`, `youtube`, `telegram`, `google_map`, `status`, `created_at`, `updated_at`) VALUES
(1,	'kh_askacademy@abhc.asia',	'(+855) 78 66 77 21',	'#C65-C66, Sangkat Sras Chork, Khan Daun Penh, Phnom Penh.',	NULL,	'Contact',	'https://www.facebook.com/LICEHairBeautyAcademy',	'https://www.instagram.com/lice_academy/',	'https://www.youtube.com/channel/UC2TITcgJ87CQGczZ4YQdzuw/videos',	'https://t.me/LICEAcademy',	'<iframe src=\"https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3908.9456126338887!2d104.88510567581373!3d11.555756744334126!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x310951ed9d2cf44d%3A0x241dc4823004ef9f!2sPHSAR%20TECH!5e0!3m2!1sen!2skh!4v1682568805189!5m2!1sen!2skh\" width=\"600\" height=\"450\" style=\"border:0;\" allowfullscreen=\"\" loading=\"lazy\" referrerpolicy=\"no-referrer-when-downgrade\"></iframe>',	1,	'2023-04-25 07:27:38',	'2023-05-04 14:30:53');

DROP TABLE IF EXISTS `courses`;
CREATE TABLE `courses` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fee` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date` datetime NOT NULL,
  `duration` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `trainer_id` int(11) DEFAULT NULL,
  `status` tinyint(4) NOT NULL,
  `popular` tinyint(4) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `courses` (`id`, `name`, `image`, `fee`, `contact_number`, `date`, `duration`, `description`, `trainer_id`, `status`, `popular`, `created_at`, `updated_at`) VALUES
(1,	'OPEN DAY : ការអ៊ុតសក់រួញឌីជីថល បែបព្រីមាម',	'/8cbsca16406602936881. Jan - OpenDay Poster-03-5951c503-ec1a-463b-b851-b50047259afe.jpg',	'Free To Join',	'012345578',	'2023-04-25 14:34:00',	'1',	'Daily training course for classic hairdresser to sharpen their skill.',	1,	1,	0,	'2023-04-25 07:37:52',	'2023-04-25 07:37:52'),
(2,	'MANAGEMENT : របៀបរៀបចំ និង ពង្រីកអាជីវកម្មសាឡនដោយអន្តរភាព',	'/image-2-1f4d9bd2-3e15-4af0-953a-6d2efc370e44.jpg',	'10',	'0123456789',	'2023-04-25 14:34:00',	'1',	'វគ្គ 𝐒𝐚𝐥𝐨𝐧 𝐌𝐚𝐧𝐚𝐠𝐞𝐦𝐞𝐧𝐭 | របៀបរៀបចំ និង ពង្រីកអាជីវកម្មសាឡនដោយនិរន្តភាព ថ្ងៃទី 24-26 មករា 2022 | 9ព្រឹក - 4រសៀល គ្រូបង្គោល៖ Vibol La ទីតាំង៖ អគារ អេ ប៊ី អេច ស៊ី តម្លៃចូលរួម៖ $1,000 /ម្នាក់',	4,	1,	0,	'2023-04-25 07:37:52',	'2023-04-25 07:37:52'),
(3,	'𝐎𝐩𝐞𝐧𝐃𝐚𝐲 | ទប់ទល់នឹងភាពចាស់នៃស្បែក',	'/04-5d4d1929-9e27-4178-8d56-2c031eb3df60.jpg',	'50',	'09876543',	'2023-04-27 09:24:00',	'2',	'✍️ វគ្គ 𝐎𝐩𝐞𝐧𝐃𝐚𝐲 | ទប់ទល់នឹងភាពចាស់នៃស្បែក 📅 ថ្ងៃទី 29 មករា 2022 | 9ព្រឹក - 12ថ្ងៃត្រង់ ចូលរួមដោយឥតគិតថ្លៃ ដោយផ្ទាល់នៅអគារ ABHC',	2,	1,	0,	'2023-04-25 07:37:52',	'2023-04-25 07:37:52'),
(4,	'Open day | បច្ចេកទេសហាយឡាយអោយត្រូវស្តង់ដារ',	'/Open day  បច្ចេកទេសហាយឡាយអោយត្រូវស្តង់ដារ-537bef13-9a7b-4202-9719-138b79161c0d.jpg',	'00',	'078/81667721',	'2023-06-03 09:00:00',	'3',	'✍️ សិក្ខាសាលា|បច្ចេកទេសហាយឡាយអោយត្រូវស្តង់ដារ និងការបង្កើតឡាញ (Lines)\r\n📅 ថ្ងៃទី ០៣ មិថុនា 2023|9:00am-12:00pm\r\n👨‍🏫 ធ្វើបទបង្ហាញដោយលោកគ្រូ៖ Meas Dore\r\n😍 ចូលរួមដោយឥតគិតថ្លៃនៅអគារសាលា លីសេ (LICE)',	8,	1,	0,	'2023-06-06 19:03:54',	'2023-06-06 19:06:16'),
(5,	'ASK |ជាមួយបទពិសោធន៍ជាច្រើនឆ្នាំ និងទេព្យកោសលលើការកាត់សក់ គាត់អាចជួយឲ្យជាងសក់សម្រេចក្តីស្រមៃបាន!',	'/16-មិថុនា-20-95627516-970f-4066-8928-d17cc98bc369.jpg',	'50',	'078/81667721',	'2020-06-12 09:00:00',	'7',	'ជាមួយបទពិសោធន៍ជាច្រើនឆ្នាំ និងទេព្យកោសលលើការកាត់សក់ គាត់អាចជួយឲ្យជាងសក់សម្រេចក្តីស្រមៃបាន!\r\n\r\nវគ្គសិក្សា៖ Layer Cutting\r\nគ្រូបង្គោល៖ Sous Sothearat\r\nរយៈពេល៖ ០១ថ្ងៃ\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី ១៦ មិថុនា ២០២០\r\nតម្លៃសិក្សា៖ ៥០ដុល្លា ឬ ទិញផលិតផលអស់ ៥០០ដុល្លា / ម្នាក់',	NULL,	1,	0,	'2023-06-06 19:34:36',	'2023-06-06 19:34:36'),
(6,	'Open day | តោះបង្កើនចំណេះដឺងលើ របៀបថែរក្សាសក់រួញ និងសក់ទឹករលក!!!',	'/Open day តោះបង្កើនចំណេះដឺងលើ របៀបថែរក្សាសក់រួញ និងសក់ទឹករលក!!!-13295df8-0c59-4366-b0b9-d303248499ae.jpg',	'00',	'078/81667721',	'2020-06-12 09:00:00',	'3',	'តោះបង្កើនចំណេះដឺងលើ របៀបថែរក្សាសក់រួញ និងសក់ទឹករលក!!!\r\n\r\nវគ្គសិក្សា៖ Open Day\r\nគ្រូបង្គោល៖ Kim Nim\r\nកាលបរិច្ឆេទ៖ ៩ ដល់ ១២ព្រឹក | ថ្ងៃទី ១២ មិថុនា ២០២០\r\nតម្លៃសិក្សា៖ ចូលរួមដោយសេរី',	7,	1,	0,	'2023-06-06 19:42:36',	'2023-06-06 19:42:36'),
(7,	'Open day |ជាមួយបទពិសោធន៍ជិត១៥ឆ្នាំ ក្នុងវិស័យសក់នៅតំបន់អឺរ៉ុប គាត់នឺងនាំយកបច្ចេកទេស និងរបៀបធ្វើបែបជាងសក់អឺរ៉ុបមកចែកជូនបងប្អូន!',	'/24-មីថុនា-20-428e6016-e59a-4ba2-8709-0772d50b921c.jpg',	'00',	'078/81667721',	'2020-06-23 09:00:00',	'14',	'ជាមួយបទពិសោធន៍ជិត១៥ឆ្នាំ ក្នុងវិស័យសក់នៅតំបន់អឺរ៉ុប គាត់នឺងនាំយកបច្ចេកទេស និងរបៀបធ្វើបែបជាងសក់អឺរ៉ុបមកចែកជូនបងប្អូន!\r\n\r\nវគ្គសិក្សា៖ មូលដ្ឋានគ្រឹះនៃការលាបពណ៌សក់\r\nគ្រូបង្គោល៖ Gwen\r\nរយៈពេល៖ ០២ថ្ងៃ\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី ២៣-២៤ មិថុនា ២០២០ | ៩ព្រឹក - ៥ល្ងាច\r\nតម្លៃសិក្សា៖ ចូលរួមដោយឥតគិតថ្លៃ',	NULL,	1,	0,	'2023-06-06 19:48:24',	'2023-06-06 19:57:40'),
(8,	'Open day| ជាមួយបទពិសោធន៍ជិត១៥ឆ្នាំ ក្នុងវិស័យសក់នៅតំបន់អឺរ៉ុប គាត់នឺងនាំយកបច្ចេកទេស និងរបៀបធ្វើបែបជាងសក់អឺរ៉ុបមកចែកជូនបងប្អូន!',	'/24-មីថុនា-20-428e6016-e59a-4ba2-8709-0772d50b921c.jpg',	'00',	'078/81667721',	'2020-06-24 09:00:00',	'7',	'ជាមួយបទពិសោធន៍ជិត១៥ឆ្នាំ ក្នុងវិស័យសក់នៅតំបន់អឺរ៉ុប គាត់នឺងនាំយកបច្ចេកទេស និងរបៀបធ្វើបែបជាងសក់អឺរ៉ុបមកចែកជូនបងប្អូន!\r\n\r\nវគ្គសិក្សា៖ មូលដ្ឋានគ្រឹះនៃការលាបពណ៌សក់\r\nគ្រូបង្គោល៖ Gwen\r\nរយៈពេល៖ ០២ថ្ងៃ\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី ២៣-២៤ មិថុនា ២០២០ | ៩ព្រឹក - ៥ល្ងាច\r\nតម្លៃសិក្សា៖ ចូលរួមដោយឥតគិតថ្លៃ',	NULL,	2,	0,	'2023-06-06 19:50:58',	'2023-06-06 19:56:28'),
(9,	'Salon Management  |ការចាប់ផ្តើមនិងរៀបចំអាជីវកម្មសាឡនឲ្យបានល្អប្រសើរនិងនិរន្តភាព',	'/Salon Management  ការចាប់ផ្តើមនិងរៀបចំអាជីវកម្មសាឡនឲ្យបានល្អប្រសើរនិងនិរន្តភាព-ddb57fca-c756-489b-9e9f-8da22c907875.jpg',	'1000',	'078/81667721',	'2020-06-01 09:00:00',	'21',	'#ការចាប់ផ្តើមនិងរៀបចំអាជីវកម្មសាឡនឲ្យបានល្អប្រសើរនិងនិរន្តភាព\r\n- កាលបរិច្ឆេទ៖ ថ្ងៃទី 1-3 ខែ កក្កដា ឆ្នាំ 2020\r\n- ទីតាំង៖ អគារ ABHC\r\n- ចាប់ផ្តើមពីម៉ោង 9:00 ព្រឹក ដល់ 5:00 ល្ងាច\r\n- បង្រៀនដោយលោក ឡា វិបុល សហស្ថានិក និងនាយកគ្រប់គ្រងនៃ SC-ABHC\r\n=> តើលោក លោកស្រី\r\n1.កំពុងស្វែងរកឱកាសអាជីវកម្មក្នុងវិស័យសាឡនមែនឬទេ?\r\n2.ជាជាងសក់ ហើយចង់បង្កើតសាឡន ព្រោះជាក្តីស្រលាញ់របស់ខ្លួនឯង?\r\n3.មានបងប្អូន មិត្តភក្តិបបួលវិនិយោគក្នុងវិស័យសាឡន?\r\n4.ជាម្ចាស់សាឡនស្រាប់ ហើយចង់ពង្រីកអាជីវកម្មរបស់ខ្លួន ប៉ុន្តែខ្វះជំនាញផ្នែកគ្រប់គ្រង និងដឹកនាំ?\r\n\r\nគាត់នឹងនាំយកបទពិសោធន៍ ១៧ឆ្នាំក្នុងការគ្រប់គ្រង និងភាពជាអ្នកដឹកនាំ ជូនដល់បងប្អូនសាឡន!',	4,	1,	0,	'2023-06-06 19:56:20',	'2023-06-06 19:57:53'),
(10,	'ASK | សេរី ម៉ូនីតា (ហៅ ពុយ) ជនជាតិថៃកាត់ខ្មែរ គឺជាជាងសក់ប្រកបដោយទេពកោសល្យ និងភាពច្នៃប្រឌិតម្នាក់ ដែលមានការយកចិត្តទុកដាក់ខ្ពស់លើសក់របស់អតិថិជនគ្រប់ៗរូប។ គាត់នឹងនាំយកបទពិសោធន៍ជាង១០ឆ្នាំក្នុងវិស័យសក់ មកចែកជូនបងប្អូនជាងសក់!',	'/29-30 -06-20-eb2dc80b-f3fb-4f1c-8154-0e248af0a2ea.jpg',	'100',	'078/81667721',	'2020-06-29 09:00:00',	'14',	'សេរី ម៉ូនីតា (ហៅ ពុយ) ជនជាតិថៃកាត់ខ្មែរ គឺជាជាងសក់ប្រកបដោយទេពកោសល្យ និងភាពច្នៃប្រឌិតម្នាក់ ដែលមានការយកចិត្តទុកដាក់ខ្ពស់លើសក់របស់អតិថិជនគ្រប់ៗរូប។ គាត់នឹងនាំយកបទពិសោធន៍ជាង១០ឆ្នាំក្នុងវិស័យសក់ មកចែកជូនបងប្អូនជាងសក់!\r\n\r\nវគ្គសិក្សា៖ Secret Foils (Foilayage)\r\nគ្រូបង្គោល៖ Puy\r\nរយៈពេល៖ 02ថ្ងៃ\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី 29-30 មិថុនា 2020 | 9ព្រឹក - 5ល្ងាច\r\nតម្លៃសិក្សា៖ ទិញផលិតផលអស់ $1000 ឬ បង់ $100\r\n______________________________________________\r\nចុះឈ្មោះ ឬ ព័ត៌មានលម្អិត៖ 078  66 77 21 / 081 66 77 21 ឬ ឆាតមកផេកផ្ទាល់។\r\nអាសយដ្ឋាន៖ ផ្ទះ C65&C66 (កែងតារាវាយកូនហ្គោលបឹងកក់)',	5,	1,	0,	'2023-06-06 20:06:24',	'2023-06-06 20:08:53'),
(11,	'Open day | ស្វែងយល់ពីថ្នាំពណ៌សក់បែបProfessional',	'/10-07-20-b83dd1c6-4f55-4770-b32a-a97fab3cb4c6.jpg',	'00',	'078/81667721',	'2020-07-10 09:00:00',	'3',	'ស្វែងយល់ពីថ្នាំពណ៌សក់បែបProfessional\r\n\r\nវគ្គសិក្សា៖ Open Day - Hair\r\nគ្រូបង្គោល៖ Kim Nim\r\nកាលបរិច្ឆេទ៖ 9 ដល់ 11ព្រឹក | ថ្ងៃទី 10 កក្កដា 2020\r\nតម្លៃសិក្សា៖ ចូលរួមដោយសេរី\r\n\r\nចុះឈ្មោះ ឬ ព័ត៌មានលម្អិត៖ 078  66 77 21 / 081 66 77 21 ឬ ឆាតមកផេកផ្ទាល់។\r\nអាសយដ្ឋាន៖ ផ្ទះ C65&C66 (កែងតារាវាយកូនហ្គោលបឹងកក់)\r\n\r\n#OpenDay_Hair #SC_ABHC #SchwarzkopfPro #SchwarzkopfProKH #ASKEducation',	7,	1,	0,	'2023-06-06 20:30:15',	'2023-06-06 20:30:15'),
(12,	'ASK | #បងកើនភាពរស់រវើកក្នុងការច្នៃពណ៌សក់',	'/29-30 -06-20-eb2dc80b-f3fb-4f1c-8154-0e248af0a2ea.jpg',	'50',	'078/81667721',	'2020-07-13 09:00:00',	'7',	'#បងកើនភាពរស់រវើកក្នុងការច្នៃពណ៌សក់\r\n\r\nសេរី ម៉ូនីតា (ហៅ ពុយ) ជនជាតិថៃកាត់ខ្មែរ គឺជាជាងសក់ប្រកបដោយទេពកោសល្យ និងភាពច្នៃប្រឌិតម្នាក់ ដែលមានការយកចិត្តទុកដាក់ខ្ពស់លើសក់របស់អតិថិជនគ្រប់ៗរូប។ គាត់នឹងនាំយកបទពិសោធន៍ជាង១០ឆ្នាំក្នុងវិស័យសក់ មកចែកជូនបងប្អូនជាងសក់!\r\n\r\nវគ្គសិក្សា៖ More with Vibrance\r\nគ្រូបង្គោល៖ Puy\r\nរយៈពេល៖ 01ថ្ងៃ\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី 13 កក្កដា 2020 | 9ព្រឹក - 5ល្ងាច\r\nតម្លៃសិក្សា៖ ទិញផលិតផលអស់ $500 ឬ បង់ $50\r\n______________________________________________\r\nចុះឈ្មោះ ឬ ព័ត៌មានលម្អិត៖ 078  66 77 21 / 081 66 77 21 ឬ ឆាតមកផេកផ្ទាល់។',	5,	1,	0,	'2023-06-06 20:32:17',	'2023-06-06 20:32:17'),
(13,	'ASK | #មលដ្ឋានគ្រឹះក្នុងការកាត់សក់នារី',	'/16-07-20-3ce2af76-8727-4f73-b5eb-b37372ab2ecd.jpg',	'100',	'078/81667721',	'2020-07-16 09:00:00',	'14',	'#មលដ្ឋានគ្រឹះក្នុងការកាត់សក់នារី\r\n\r\nជាមួយបទពិសោធន៍ជាង 20ឆ្នាំ នាគ (Neak) បច្ចុប្បន្នជាជាងសក់ម្នាក់ដែលមានការទទួលស្គាល់ខ្ពស់។ ដោយក្តីស្រលាញ់លើវិស័យសក់ គាត់បានអភិវឌ្ឈខ្លួនដោយឆ្លងកាត់ការបណ្តុះបណ្តាលជាច្រើនពីសំណាក់គ្រូថ្នាក់ជាតិ និងថ្នាក់អន្តរជាតិ។ គាត់នឹងនាំយកបទពិសោធន៍របស់គាត់មកចែកជូនបងប្អូនជាងសក់!',	NULL,	1,	0,	'2023-06-06 20:35:49',	'2023-06-06 20:35:49'),
(14,	'ASK |#បចចេកទេសអ៊ុតសក់ត្រង់ពិសេសប៉ោងគល់ក្តោបចុងជាមួយGlatt',	'/20-07-20-3676422c-240a-4d1b-b3a9-15afedab1409.jpg',	'50',	'078/81667721',	'2020-07-20 09:00:00',	'7',	'#បចចេកទេសអ៊ុតសក់ត្រង់ពិសេសប៉ោងគល់ក្តោបចុងជាមួយGlatt\r\n\r\nSinky នឹងនាំយកបទពិសោធន៍ និងបច្ចេកទេសរបស់គាត់មកចែកជូនបងប្អូនជាងសក់! ដោយមើលឃើញទេព្យកោសលដ៏បុិនប្រសប់ គាត់ត្រូវបានជ្រើសរើសជាគ្រូបង្គោលនៃ ASK Academy of Schwarzkopf Professional Cambodia, SC-ABHC\r\n\r\nវគ្គសិក្សា៖ Glatt for your Special Straight Curl\r\nគ្រូបង្គោល៖  Sinky\r\nរយៈពេល៖ 01ថ្ងៃ\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី 20 កក្កដា 2020 | 9ព្រឹក - 5ល្ងាច\r\nតម្លៃសិក្សា៖ ទិញផលិតផលអស់ $500 ឬ បង់ $50\r\nចុះឈ្មោះ ឬ ព័ត៌មានលម្អិត៖ 078  66 77 21 / 081 66 77 21 ឬ ឆាតមកផេកផ្ទាល',	6,	1,	0,	'2023-06-06 20:39:34',	'2023-06-06 20:39:34'),
(15,	'ASK | #មលដ្ឋានគ្រឹះក្នុងការកាត់សក់បុរស',	'/photo_2023-06-06_16-42-59-ac840730-34ff-4bcd-8895-9929031e4554.jpg',	'100',	'078/81667721',	'2020-07-22 09:00:00',	'14',	'#មលដ្ឋានគ្រឹះក្នុងការកាត់សក់បុរស\r\n\r\nជាមួយបទពិសោធន៍ប្រមាណ ១៣ឆ្នាំ Bee Bob បច្ចុប្បន្នជាម្ចាស់ហាងកាត់សក់បុរស ក៏ដូចជាជាងសក់បុរសម្នាក់ដែលមានការទទួលស្គាល់ខ្ពស់! ដោយមើលឃើញទេព្យកោសលដ៏បុិនប្រសប់ គាត់ត្រូវបានជ្រើសរើសជាគ្រូបង្គោលនៃ ASK Academy of Schwarzkopf Professional Cambodia, SC-ABHC\r\n\r\nវគ្គសិក្សា៖ Basic Men Cut\r\nគ្រូបង្គោល៖  Bee Bob\r\nរយៈពេល៖ 02ថ្ងៃ\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី 22-23 កក្កដា 2020 | 9ព្រឹក - 5ល្ងាច\r\nតម្លៃសិក្សា៖ ទិញផលិតផលអស់ $1000 ឬ បង់ $100\r\nចុះឈ្មោះ ឬ ព័ត៌មានលម្អិត៖ 078  66 77 21 / 081 66 77 21 ឬ ឆាតមកផេកផ្ទាល់។\r\nអាសយដ្ឋាន៖ ផ្ទះ C65&C66 (កែងតារាវាយកូនហ្គោលបឹងកក់)',	NULL,	1,	0,	'2023-06-06 20:43:28',	'2023-06-06 20:43:28'),
(16,	'ASK | បចចេកទេសលាបពណ៌សក់ធម្មជាតិជាមួយEssensity',	'/photo_2023-06-07_11-13-12-01db8253-2fcf-49b3-8d78-9947305b439c.jpg',	'50',	'078/81667721',	'2020-07-27 09:00:00',	'7',	'#បចចេកទេសលាបពណ៌សក់ធម្មជាតិជាមួយEssensity\r\nនីម បានធ្វើការជាមួយក្ដីស្រលាញ់ពេញចិត្តលើវិស័យសក់អស់រយៈពេលជាងមួយទស្សវត្តមកហើយ។ ក្នុងកុំឡុងពេល 12ឆ្នាំនេះ គាត់បានធ្វើការក្នុងនាមជាជាងសក់ និងបានទទួលការបណ្ដុះបណ្តាលជាច្រើនពីសំណាក់គ្រូបង្ហាត់មកពីអឺរ៉ុប និងអាស៊ី។ ឥឡូវនេះ នីម ក្លាយជាគ្រូបង្ហាត់នៃគ្រូបង្ហាត់ (TOT) នៃសាលា SC-ABHC។\r\nវគ្គសិក្សា៖ Natural Color with Essensity\r\nគ្រូបង្គោល៖ Kim Nim',	7,	1,	0,	'2023-06-07 15:14:51',	'2023-06-07 15:19:18'),
(17,	'Open day | #ចាប់ម៉ូតសក់ជាមួយOSiS',	'/photo_2023-06-07_11-16-01-722b6cd5-bde1-496f-b651-497741d9bb6d.jpg',	'00',	'078/81667721',	'2020-07-29 09:00:00',	'3',	'#ចាប់ម៉ូតសក់ជាមួយOSiS\r\n#MadeToCreateWithOSiS\r\n\r\nវគ្គសិក្សា៖ Open Day - Hair\r\nគ្រូបង្គោល៖ Kim Nim\r\nកាលបរិច្ឆេទ៖ 9 ដល់ 11ព្រឹក | ថ្ងៃទី 29 កក្កដា 2020\r\nតម្លៃសិក្សា៖ ចូលរួមដោយសេរី',	7,	1,	0,	'2023-06-07 15:18:59',	'2023-06-07 15:18:59'),
(18,	'ASK | បច្ចេកទេសលាបពណ៌សក់បែបBumbyBrown',	'/photo_2023-06-07_11-19-30-4d2e29c4-1dce-4dfe-bdca-e14d9efd2f08.jpg',	'50',	'078/81667721',	'2020-08-03 09:00:00',	'7',	'បច្ចេកទេសលាបពណ៌សក់បែបBumbyBrown\r\n\r\nគ្រូបង្គោល៖ Ella (ក៏ជាគ្រូនៅ Socheat Beauty School)\r\nរយៈពេល៖ 01ថ្ងៃ\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី 03 សីហា 2020 | 9ព្រឹក - 5ល្ងាច\r\nតម្លៃសិក្សា៖ ទិញផលិតផលអស់ $500 ឬ បង់ $50\r\nចុះឈ្មោះ ឬ ព័ត៌មានលម្អិត៖ 078  66 77 21 / 081 66 77 21 ឬ ឆាតមកផេកផ្ទាល់។\r\nអាសយដ្ឋាន៖ ផ្ទះ C65&C66 (កែងតារាវាយកូនហ្គោលបឹងកក់)',	NULL,	1,	0,	'2023-06-07 15:21:15',	'2023-06-07 15:21:15'),
(19,	'ASK | Punk Spirit by ChromID & IgoraVibrance',	'/photo_2023-06-07_11-22-17-8cff8489-c7c6-4244-9456-3dace4c05542.jpg',	'50',	'078/81667721',	'2020-08-10 09:00:00',	'7',	'Punk Spirit by ChromID & IgoraVibrance\r\n\r\nនីម បានធ្វើការជាមួយក្ដីស្រលាញ់ពេញចិត្តលើវិស័យសក់អស់រយៈពេលជាងមួយទស្សវត្តមកហើយ។ ក្នុងកុំឡុងពេល 12ឆ្នាំនេះ គាត់បានធ្វើការក្នុងនាមជាជាងសក់ និងបានទទួលការបណ្ដុះបណ្តាលជាច្រើនពីសំណាក់គ្រូបង្ហាត់មកពីអឺរ៉ុប និងអាស៊ី។ ឥឡូវនេះ នីម ក្លាយជាគ្រូបង្ហាត់នៃគ្រូបង្ហាត់ (TOT) នៃសាលា SC-ABHC។\r\n\r\nវគ្គសិក្សា៖ ច្នៃពណ៌សក់បែប Punk Spirit ដោយ ChormaID & IgoraVibrance',	7,	1,	0,	'2023-06-07 15:24:12',	'2023-06-07 15:24:12'),
(20,	'ASK',	'/photo_2023-06-07_11-25-51-1cdb4da7-b9c0-4f68-9935-3d47f2400d44.jpg',	'50',	'078/81667721',	'2020-08-11 09:00:00',	'7',	'ជាមួយបទពិសោធន៍ជាង 17ឆ្នាំ និងទេព្យកោសលលើការកាត់សក់ គាត់អាចជួយឲ្យជាងសក់សម្រេចក្តីស្រមៃបាន!  បច្ចុប្បន្ន Karat គីជាគ្រូបង្គោលម្នាក់នៃ ASK Academy of Schwarzkopf Professional Cambodia, SC-ABHC\r\n\r\nវគ្គសិក្សា៖ បច្ចេកទេសកាត់ម៉ូតការេ 3ប្រភេទ | Bob Texture Cut\r\nគ្រូបង្គោល៖ Karat\r\nរយៈពេល៖ 01ថ្ងៃ\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី 11 សីហា 2020 | 9ព្រឹក - 5ល្ងាច',	NULL,	1,	0,	'2023-06-07 15:26:31',	'2023-06-07 15:26:31'),
(21,	'ASK | វគ្គសិក្សា៖ OpenDay - Hair | Technique Helper',	'/photo_2023-06-07_11-27-08-5db31e4c-ef2f-4c0c-9398-09422cb1ef74.jpg',	'00',	'078/81667721',	'2020-08-07 09:00:00',	'7',	'វគ្គសិក្សា៖ OpenDay - Hair | Technique Helper\r\nគ្រូបង្គោល៖ Kim Nim\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី 07 សីហា 2020 | 9-11 ព្រឹក\r\nតម្លៃសិក្សា៖ ចូលរួមដោយសេរី\r\nចុះឈ្មោះ ឬ ព័ត៌មានលម្អិត៖ 078  66 77 21 / 081 66 77 21 ឬ ឆាតមកផេកផ្ទាល់។\r\nអាសយដ្ឋាន៖ ផ្ទះ C65&C66 (កែងតារាងវាយកូនហ្គោលបឹងកក់)',	7,	1,	0,	'2023-06-07 15:28:49',	'2023-06-07 15:28:49'),
(22,	'#ថនាក់គ្រប់គ្រងសាឡន #SalonManager',	'/photo_2023-06-07_11-30-54-bd29d663-020b-4b30-b3a7-f4b3f7a9f129.jpg',	'1000',	'078/81667721',	'2020-08-31 09:00:00',	'21',	'លោក ឡាវិបុល ជាសហស្ថាបនិក និងជានាយកគ្រប់គ្រង SC-ABHC នឹងនាំយកបទពិសោធន៍17ឆ្នាំនៃការគ្រប់គ្រង និងភាពជាអ្នកដឹកនាំ មកចែកជូនដល់បងប្អូនដែលជាអ្នកគ្រប់គ្រងនៃអាជីវកម្មសាឡន។ គាត់អាចជួយលោកអ្នកឱ្យសម្រេចក្តីស្រមៃបាន!\r\n\r\nទទួលពាក្យចូលរៀនចាប់ពីថ្ងៃនេះតទៅ!\r\nចូលរៀនថ្ងៃទី 31 សីហា 2020\r\nរៀនរយៈពេល 3ថ្ងៃ\r\nចុះឈ្មោះ ឬ ព័ត៌មានលម្អិត៖ 078  66 77 21 / 081 66 77 21 ឬ ឆាតមកផេកផ្ទាល់។\r\nអាសយដ្ឋាន៖ ផ្ទះ C65&C66 (កែងតារាវាយកូនហ្គោលបឹងកក់)',	4,	1,	0,	'2023-06-07 15:40:59',	'2023-06-07 15:40:59'),
(23,	'ASK',	'/photo_2023-06-07_11-44-01-87dadcc8-277e-4c67-a4b6-4be38979561c.jpg',	'50',	NULL,	'2020-09-07 09:00:00',	'7',	'្នកគ្រូ ចម្រើន រ័ត្ន នឹងនាំយកបទពិសោធន៍ជាង ១០ឆ្នាំ ក៏ដូចជាបច្ចេកទេសរបស់គាត់ ជូនដល់សិក្ខាកាម លើការដោះស្រាយបញ្ហាសក់ខូច ស្ងួត បែកចុង សក់ខ្សោយ ជាអ្វីដែលបងប្អូនជាងសក់ជួបប្រទះជាញឹកញាប់ទៅភ្ញៀវដែលអញ្ជើញមកសាឡនបងប្អូន!!!\r\nវគ្គសិក្សា៖ Building Blocks of BC Bonacure\r\nគ្រូបង្គោល៖ Chamreun Rath\r\nរយៈពេល៖ 01ថ្ងៃ\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី 07 កញ្ញា 2020 | 9ព្រឹក - 5ល្ងាច\r\nតម្លៃសិក្សា៖ ទិញផលិតផលអស់ $500 ឬ បង់ $50\r\nចុះឈ្មោះ ឬ ព័ត៌មានលម្អិត៖ 078  66 77 21 / 081 66 77 21 ឬ ឆាតមកផេកផ្ទាល់។\r\nអាសយដ្ឋាន៖ ផ្ទះ C65&C66 (កែងតារាវាយកូនហ្គោលបឹងកក់)',	NULL,	1,	0,	'2023-06-07 15:45:07',	'2023-06-07 15:45:07'),
(24,	'ASK | នីម',	'/photo_2023-06-10_13-42-29-a90d060e-e58f-40dd-b323-4267e7dbe0af.jpg',	'50',	'078/81667721',	'2020-09-21 09:00:00',	'7',	'នីម បានធ្វើការជាមួយក្ដីស្រលាញ់ពេញចិត្តលើវិស័យសក់អស់រយៈពេលជាងមួយទស្សវត្តមកហើយ។ ក្នុងកុំឡុងពេល 12ឆ្នាំនេះ គាត់បានធ្វើការក្នុងនាមជាជាងសក់ និងបានទទួលការបណ្ដុះបណ្តាលជាច្រើនពីសំណាក់គ្រូបង្ហាត់មកពីអឺរ៉ុប និងអាស៊ី។ ឥឡូវនេះ នីម ក្លាយជាគ្រូបង្ហាត់នៃគ្រូបង្ហាត់ (TOT) នៃសាលា SC-ABHC។\r\nវគ្គសិក្សា៖ Brown Syoss\r\nគ្រូបង្គោល៖ Kim Nim\r\nរយៈពេល៖ 01ថ្ងៃ\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី 21 កញ្ញា 2020 | 9ព្រឹក - 5ល្ងាច',	7,	1,	0,	'2023-06-10 17:44:45',	'2023-06-10 17:44:59'),
(25,	'ASK | Sinky នឹងនាំយកបទពិសោធន៍',	'/photo_2023-06-10_13-45-21-6bd6985b-b532-4892-9316-1362fa459cfc.jpg',	'50',	'078/81667721',	'2020-09-28 09:00:00',	'7',	'Sinky នឹងនាំយកបទពិសោធន៍ និងបច្ចេកទេសរបស់គាត់មកចែកជូនបងប្អូនជាងសក់! ដោយមើលឃើញទេព្យកោសលដ៏បុិនប្រសប់ គាត់ត្រូវបានជ្រើសរើសជាគ្រូបង្គោលនៃ ASK Academy of Schwarzkopf Professional Cambodia, SC-ABHC\r\nវគ្គសិក្សា៖ បច្ចេកទេសអ៊ុតសក់ត្រង់គល់ រួញចុង\r\nគ្រូបង្គោល៖  Sinky\r\nរយៈពេល៖ 01ថ្ងៃ\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី 28 កញ្ញា 2020 | 9ព្រឹក - 5ល្ងាច\r\nតម្លៃសិក្សា៖ ទិញផលិតផលអស់ $500 ឬ បង់ $50\r\nចុះឈ្មោះ ឬ ព័ត៌មានលម្អិត៖ 078  66 77 21 / 081 66 77 21 ឬ ឆាតមកផេកផ្ទាល់។\r\nអាសយដ្ឋាន៖ ផ្ទះ C65&C66 (កែងតារាវាយកូនហ្គោលបឹងកក់)',	7,	1,	0,	'2023-06-10 17:48:02',	'2023-06-10 17:48:02'),
(26,	'ASK | #បចចេកទេសកាត់សក់បុរសតាមទម្រង់មុខនិងទម្រង់ក្បាល',	'/photo_2023-06-10_13-50-02-725ae154-de3a-4320-84a0-cbe18a2b4f41.jpg',	'150',	'078/81667721',	'2020-10-01 09:00:00',	'7',	'#បចចេកទេសកាត់សក់បុរសតាមទម្រង់មុខនិងទម្រង់ក្បាល\r\n\r\nគ្រូបង្គោល៖  KIM Chamroeun (Ma)\r\nរយៈពេល៖ 03ថ្ងៃ\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី 29 កញ្ញា ដល់ 01 តុលា 2020 | 9ព្រឹក - 5ល្ងាច\r\nតម្លៃសិក្សា៖ ទិញផលិតផលអស់ $1500 ឬ បង់ $150\r\nចុះឈ្មោះ ឬ ព័ត៌មានលម្អិត៖ 078  66 77 21 / 081 66 77 21 ឬ ឆាតមកផេកផ្ទាល់។\r\nអាសយដ្ឋាន៖ ផ្ទះ C65&C66 (កែងតារាវាយកូនហ្គោលបឹងកក់)\r\n\r\n#ma #scabhc #schwarzkopfpro #schwarzkopfprokh  #askeducation #askacademy',	NULL,	1,	0,	'2023-06-10 17:51:46',	'2023-06-10 17:52:55'),
(27,	'ASK | #បចចេកទេសធ្វើពណ៌សក់បែបBalayage',	'/photo_2023-06-10_13-53-00-2c3c67ff-bed4-4a94-8fba-299265c1f7ba.jpg',	'100',	'078/81667721',	'2020-07-13 09:00:00',	'7',	'#បចចេកទេសធ្វើពណ៌សក់បែបBalayage\r\nសេរី ម៉ូនីតា (ហៅ ពុយ) ជនជាតិថៃកាត់ខ្មែរ គឺជាជាងសក់ប្រកបដោយទេពកោសល្យ និងភាពច្នៃប្រឌិតម្នាក់ ដែលមានការយកចិត្តទុកដាក់ខ្ពស់លើសក់របស់អតិថិជនគ្រប់ៗរូប។ គាត់នឹងនាំយកបទពិសោធន៍ជាង១០ឆ្នាំក្នុងវិស័យសក់ មកចែកជូនបងប្អូនជាងសក់!\r\nវគ្គសិក្សា៖ Balayage\r\nគ្រូបង្គោល៖ Puy\r\nរយៈពេល៖ 02ថ្ងៃ\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី 5-6 តុលា 2020 | 9ព្រឹក - 5ល្ងាច\r\nតម្លៃសិក្សា៖ ទិញផលិតផលអស់ $1000 ឬ បង់ $100\r\nចុះឈ្មោះ ឬ ព័ត៌មានលម្អិត៖ 078  66 77 21 / 081 66 77 21 ឬ ឆាតមកផេកផ្ទាល់។\r\nអាសយដ្ឋាន៖ ផ្ទះ C65&C66 (កែងតារាវាយកូនហ្គោលបឹងកក់)',	5,	1,	0,	'2023-06-10 17:54:39',	'2023-06-10 17:56:48'),
(28,	'Open Day | ស្វែងយល់ពីផលិតផលអ៊ុតរួញក្តៅ',	'/photo_2023-06-10_13-57-05-54e9e663-29f9-4c07-8ea6-415d7ba85f29.jpg',	'00',	'078/81667721',	'2020-10-02 09:00:00',	'3',	'វគ្គសិក្សា៖ OpenDay - Hair | ស្វែងយល់ពីផលិតផលអ៊ុតរួញក្តៅ និងត្រជាក់\r\nគ្រូបង្គោល៖ Kim Nim\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី 02 តុលា 2020 | 9-11 ព្រឹក\r\nតម្លៃសិក្សា៖ ចូលរួមដោយសេរី\r\nចុះឈ្មោះ ឬ ព័ត៌មានលម្អិត៖ 078  66 77 21 / 081 66 77 21 ឬ ឆាតមកផេកផ្ទាល់។\r\nអាសយដ្ឋាន៖ ផ្ទះ C65&C66 (កែងតារាងវាយកូនហ្គោលបឹងកក់)',	NULL,	1,	0,	'2023-06-10 17:58:37',	'2023-06-10 17:58:37'),
(29,	'ASK | #បចចេកទេសធ្វើពណ៌សក់បែបBalayage',	'/photo_2023-06-10_14-00-03-88b89287-58bf-416a-a4a3-f5f69926b7bd.jpg',	'100',	'078/81667721',	'2020-07-13 09:00:00',	'7',	'#បចចេកទេសធ្វើពណ៌សក់បែបBalayage\r\nសេរី ម៉ូនីតា (ហៅ ពុយ) ជនជាតិថៃកាត់ខ្មែរ គឺជាជាងសក់ប្រកបដោយទេពកោសល្យ និងភាពច្នៃប្រឌិតម្នាក់ ដែលមានការយកចិត្តទុកដាក់ខ្ពស់លើសក់របស់អតិថិជនគ្រប់ៗរូប។ គាត់នឹងនាំយកបទពិសោធន៍ជាង១០ឆ្នាំក្នុងវិស័យសក់ មកចែកជូនបងប្អូនជាងសក់!\r\nវគ្គសិក្សា៖ Balayage',	5,	1,	0,	'2023-06-10 18:02:23',	'2023-06-10 18:02:23'),
(30,	'ASK | វគ្គសិក្សា៖ បច្ចេកទេសធ្វើពណ៌សក់ Once Upon A Time',	'/photo_2023-06-10_14-03-29-20820be5-a6a4-4203-ac42-f48eb6ab8584.jpg',	'50',	'078/81667721',	'2020-10-12 09:00:00',	'7',	'វគ្គសិក្សា៖ បច្ចេកទេសធ្វើពណ៌សក់ Once Upon A Time\r\nគ្រូបង្គោល៖ គីម នីម\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី 12 តុលា 2020 | 9ព្រឹក - 5ល្ងាច\r\nតម្លៃសិក្សា៖ ទិញផលិតផលអស់ $500 ឬ បង់ $50\r\nចុះឈ្មោះ ឬ ព័ត៌មានលម្អិត៖ 078  66 77 21 / 081 66 77 21 ឬ ឆាតមកផេកផ្ទាល់។\r\nអាសយដ្ឋាន៖ ផ្ទះ C65&C66 (កែងតារាវាយកូនហ្គោលបឹងកក់)',	7,	1,	0,	'2023-06-10 18:04:35',	'2023-06-10 18:04:35'),
(31,	'OOpenDay - Hair | ស្វែងយល់ពីផលិតផលព្យាបាលស្បែកក្បាល',	'/photo_2023-06-10_14-03-29-20820be5-a6a4-4203-ac42-f48eb6ab8584.jpg',	'00',	'078/81667721',	'2020-10-09 09:00:00',	'7',	'វគ្គសិក្សា៖ OpenDay - Hair | ស្វែងយល់ពីផលិតផលព្យាបាលស្បែកក្បាល និងបញ្ហាសក់ជ្រុះ\r\nគ្រូបង្គោល៖ គិម នីម\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី 09 តុលា 2020 | 9-11 ព្រឹក\r\nតម្លៃសិក្សា៖ ចូលរួមដោយសេរី\r\nចុះឈ្មោះ ឬ ព័ត៌មានលម្អិត៖ 078  66 77 21 / 081 66 77 21 ឬ ឆាតមកផេកផ្ទាល់។\r\nអាសយដ្ឋាន៖ ផ្ទះ C65&C66 (កែងតារាងវាយកូនហ្គោលបឹងកក់)',	7,	1,	0,	'2023-06-10 18:05:57',	'2023-06-10 18:05:57'),
(32,	'ASK | វគ្គសិក្សា៖ បច្ចេកទេសអ៊ុតសក់រាងអក្សរ C',	'/photo_2023-06-12_10-37-45-bfa6b0f4-31a8-4f7f-880a-422507553c84.jpg',	'50',	'078/81667721',	'2020-10-26 09:00:00',	'7',	'វគ្គសិក្សា៖ បច្ចេកទេសអ៊ុតសក់រាងអក្សរ C\r\nគ្រូបង្គោល៖ នាគ\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី 26 តុលា 2020 | 9ព្រឹក - 5ល្ងាច\r\nតម្លៃសិក្សា៖ ទិញផលិតផលអស់ $500 ឬ បង់ $50\r\nចុះឈ្មោះ ឬ ព័ត៌មានលម្អិត៖ 078  66 77 21 / 081 66 77 21 ឬ ឆាតមកផេកផ្ទាល់។',	NULL,	1,	0,	'2023-06-12 14:48:08',	'2023-06-12 14:48:08'),
(33,	'OpenDay - Hair | ស្វែងយល់ពីផលិតផលអ៊ុតសក់ត្រង់',	'/photo_2023-06-12_10-48-40-7bc6d95d-ec76-4d83-90e1-5e517f1d9ed4.jpg',	'00',	'078/81667721',	'2020-10-23 09:00:00',	'3',	'វគ្គសិក្សា៖ OpenDay - Hair | ស្វែងយល់ពីផលិតផលអ៊ុតសក់ត្រង់\r\nគ្រូបង្គោល៖ គិម នីម\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី 23 តុលា 2020 | 9-11 ព្រឹក\r\nតម្លៃសិក្សា៖ ចូលរួមដោយសេរី',	7,	1,	0,	'2023-06-12 14:50:06',	'2023-06-12 14:50:06'),
(34,	'ASK Academy - បច្ចេកទេសធ្វើពណ៌សក់',	'/photo_2023-06-12_10-52-54-7dc6d6e8-9eec-48a2-9527-bada7710f5df.jpg',	'50',	'078/81667721',	'2020-11-05 09:00:00',	'7',	'វគ្គសិក្សា៖ ASK Academy - បច្ចេកទេសធ្វើពណ៌សក់\r\nប្រធានបទ៖ Free from Coloring and More with Vibrance\r\nគ្រូបង្គោល៖ គីម នីម\r\nកាលបរិច្ឆេទ៖ ថ្ងៃព្រហស្បតិ៍ ទី5 វិច្ឆិកា 2020 | 9AM-5PM\r\nតម្លៃសិក្សា៖ $50 ឬ ទិញផលិតផលអស់ $500\r\n\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\n☎️ ទរស័ព្ទ: 078 | 081 66 77 21\r\n📍 អាសយដ្ឋាន: ផ្ទះលេខC65-C66 (កែងតារាងវាយកូនហ្គោលបឹងកក់), សង្កាត់ស្រះចក, ខណ្ឌដូនពេញ,  រាជធានីភ្នំពេញ\r\nhttps://goo.gl/maps/64WVXBFQ7jsZdnB37',	7,	1,	0,	'2023-06-12 14:56:03',	'2023-06-12 14:56:03'),
(35,	'ASK Academy - បច្ចេកទេសធ្វើពណ៌សក់',	'/photo_2023-06-12_10-59-53-8828b057-33e7-490a-9a65-d2501fcaf09b.jpg',	'50',	'078/81667721',	'2020-11-05 09:00:00',	'3',	'វគ្គសិក្សា៖ ASK Academy - បច្ចេកទេសធ្វើពណ៌សក់\r\nប្រធានបទ៖ Free from Coloring and More with Vibrance\r\nគ្រូបង្គោល៖ គីម នីម\r\nកាលបរិច្ឆេទ៖ ថ្ងៃព្រហស្បតិ៍ ទី5 វិច្ឆិកា 2020 | 9AM-5PM\r\nតម្លៃសិក្សា៖ $50 ឬ ទិញផលិតផលអស់ $500',	NULL,	1,	0,	'2023-06-12 15:01:19',	'2023-06-12 15:01:19'),
(36,	'OpenDay - Hair | ស្វែងយល់ពីផលិតផលចាប់ម៉ូតសក់',	'/photo_2023-06-12_11-01-35-5be7cceb-7f39-4cf2-8e6e-06282d692118.jpg',	'00',	'078/81667721',	'2020-11-06 09:00:00',	'3',	'វគ្គសិក្សា៖ OpenDay - Hair | ស្វែងយល់ពីផលិតផលចាប់ម៉ូតសក់ \r\nផលិតផលប្រើប្រាស់៖ OSiS+ និង Silhouette\r\nគ្រូបង្គោល៖ គីម នីម\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី 6 វិច្ឆិកា 2020 | 9-11 ព្រឹក\r\n***ចូលរួមដោយសេរី',	NULL,	1,	0,	'2023-06-12 15:03:25',	'2023-06-12 15:03:25'),
(37,	'ASK Academy - បច្ចេកទេសអ៊ុតសក់',	'/photo_2023-06-12_11-03-47-0d6051cc-749a-4b88-a0d3-806309506033.jpg',	'50',	'078/81667721',	'2020-11-12 09:00:00',	'7',	'វគ្គសិក្សា៖ ASK Academy - បច្ចេកទេសអ៊ុតសក់ \r\nប្រធានបទ៖ បច្ចេកទេសអ៊ុតសក់ត្រង់សម្រាប់សក់ដែលខូចខ្លាំង | Straightening for extremely damaged hair \r\nគ្រូបង្គោល៖ អៀង វណ្ណៈ\r\nកាលបរិច្ឆេទ៖ ថ្ងៃព្រហស្បតិ៍ ទី12 វិច្ឆិកា 2020 | 9AM-5PM \r\nតម្លៃសិក្សា៖ បង់$50 ឬ ទិញផលិតផល$500',	1,	1,	0,	'2023-06-12 15:05:29',	'2023-06-12 15:08:20'),
(38,	'Salon Management  | ការរៀបចំ និងដំណើរការអាជីវកម្មសាឡន',	'/photo_2023-06-12_11-09-00-ced4ef4d-22cd-4a45-90f0-8aad661a172e.jpg',	'1000',	'078/81667721',	'2020-11-27 09:00:00',	'21',	'វគ្គសិក្សា៖ ការរៀបចំ និងដំណើរការអាជីវកម្មសាឡន\r\nSETUP AND RUN SALON BUSINESS\r\n____________________________________________\r\n\r\nចង់ក្លាយជាម្ចាស់អាជីវកម្មសាឡនមួយដ៏ពូកែមែនទេ?\r\nលោកអ្នកនឹងបានស្វែងយល់អំពី៖\r\n1⃣ ធាតុផ្សំផ្សេងៗសម្រាប់បង្កើតនិងដំណើរការហាងសាឡន\r\n2⃣ ហានិភ័យ និងវិធីសាស្ត្រក្នុងការបង្ការនៅក្នុងអាជីវកម្មសាឡន\r\n+តម្លៃសិក្សា $1,000\r\n+ទិញផលិតផលFree វគ្គសិក្សា $3,000\r\n\r\nបង្រៀនផ្ទាល់ដោយ លោក ឡា វិបុល ដែលជាសហស្ថាបនិក និងនាយកគ្រប់គ្រងក្រុមហ៊ុន SC-ABHC ជាមួយនឹងបទពិសោធន៍ ១៧ឆ្នាំនៃការគ្រប់គ្រង និងភាពជាអ្នកដឹកនាំ',	NULL,	1,	0,	'2023-06-12 15:10:58',	'2023-06-12 15:10:58'),
(39,	'OpenDay - Nail | បច្ចេកទេសលាបថ្នាំក្រចកជែលឱ្យបានស្អាត និងជាប់ល្អ',	'/photo_2023-06-12_11-11-43-50e27f6d-bc5c-49d5-9271-4abd0b1db86f.jpg',	'00',	'078/81667721',	'2020-11-20 09:00:00',	'3',	'វគ្គសិក្សា៖ OpenDay - Nail | បច្ចេកទេសលាបថ្នាំក្រចកជែលឱ្យបានស្អាត និងជាប់ល្អ\r\nផលិតផលប្រើប្រាស់៖ O.P.I Gel\r\nគ្រូបង្គោល៖ ពៅ សុវណ្ណារី\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី 20 វិច្ឆិកា 2020 | 9-11 ព្រឹក\r\n***ចូលរួមដោយសេរី',	NULL,	1,	0,	'2023-06-12 15:13:46',	'2023-06-12 15:13:46'),
(40,	'ASK Academy - បច្ចេកទេសកាត់សក់',	'/photo_2023-06-07_11-25-51-0460127d-bfad-4e13-81d0-db20663baa78.jpg',	'50',	'078/81667721',	'2020-11-24 09:00:00',	'7',	'វគ្គសិក្សា៖ ASK Academy - បច្ចេកទេសកាត់សក់\r\nប្រធានបទ៖ បច្ចេកទេសកាត់សក់នារីឱ្យសមតាមទម្រង់មុខ \r\nគ្រូបង្គោល៖ Karat\r\nកាលបរិច្ឆេទ៖ ថ្ងៃអង្គារ ទី24 វិច្ឆិកា 2020 | 9AM-5PM\r\nតម្លៃសិក្សា៖ $50 ឬ ទិញផលិតផលអស់ $500',	NULL,	1,	0,	'2023-06-12 15:17:01',	'2023-06-12 15:17:01'),
(41,	'ASK Academy - បច្ចេកទេសធ្វើពណ៌សក់',	'/photo_2023-06-12_11-17-54-e325a141-edd7-4241-92e9-2d02c5ffa653.jpg',	'50',	'078/81667721',	'2020-11-30 09:00:00',	'7',	'វគ្គសិក្សា៖ ASK Academy - បច្ចេកទេសធ្វើពណ៌សក់\r\nប្រធានបទ៖ បច្ចេកទេសធ្វើពណ៌សក់បែប Fashion\r\nគ្រូបង្គោល៖ Puy\r\nកាលបរិច្ឆេទ៖ ថ្ងៃច័ន្ទ ទី30 វិច្ឆិកា 2020 | 9AM-5PM\r\nតម្លៃសិក្សា៖ បង់$50 ឬ ទិញផលិតផល$500',	5,	1,	0,	'2023-06-12 15:19:38',	'2023-06-12 15:19:38'),
(42,	'ASK Academy - បច្ចេកទេសកាត់សក់',	'/photo_2023-06-12_11-19-53-31e16552-c6f9-4810-bf67-560d92fc01c4.jpg',	'100',	'078/81667721',	'2020-12-01 09:00:00',	'14',	'វគ្គសិក្សា៖ ASK Academy - បច្ចេកទេសកាត់សក់\r\nប្រធានបទ៖ បង្កើនសមត្ថភាពផ្នែកកាត់សក់នារី | Empower the foundation of woman haircut\r\nគ្រូបង្គោល៖ Neak\r\nកាលបរិច្ឆេទ៖ ថ្ងៃច័ន្ទ ទី1ដល់2 ធ្នូ 2020 | 9AM-5PM\r\nតម្លៃសិក្សា៖ បង់$100 ឬ ទិញផលិតផល$1000',	NULL,	1,	0,	'2023-06-12 15:21:22',	'2023-06-12 15:21:22'),
(43,	'OpenDay - Hair | ស្វែងយល់ពីថ្នាំពណ៌សក់បែបProfessional',	'/photo_2023-06-12_11-21-55-6c1c3bfb-397d-4d73-bc97-7ec397a602b5.jpg',	'00',	'078/81667721',	'2020-12-04 09:00:00',	'3',	'វគ្គសិក្សា៖ OpenDay - Hair | ស្វែងយល់ពីថ្នាំពណ៌សក់បែបProfessional\r\nគ្រូបង្គោល៖ គីម នីម\r\nកាលបរិច្ឆេទ៖ ថ្ងៃសុក្រ ទី4 ធ្នូ 2020 | 9-11 ព្រឹក\r\n***ចូលរួមដោយសេរី\r\n***រៀនអនឡាញតាមរយៈ Zoom\r\nhttps://us02web.zoom.us/j/4056161520...\r\nMeeting ID: 405 616 1520\r\nPasscode: abhcbest',	NULL,	1,	0,	'2023-06-12 15:23:23',	'2023-06-12 15:23:23'),
(44,	'Open day | រៀនអនឡាញ តាមរយៈ Zoom ***ចូលរួមដោយសេរី',	'/photo_2023-06-12_11-27-37-82535a77-23e3-48f4-8bb6-0f492ccc1a7d.jpg',	'00',	'078/81667721',	'2020-12-11 09:00:00',	'3',	'**រៀនអនឡាញ តាមរយៈ Zoom\r\n***ចូលរួមដោយសេរី\r\nវគ្គសិក្សា៖ OpenDay - Hair | ស្វែងយល់ពីផលិតផលព្យាបាលសក់ខូចខ្លាំង និងសក់ដាច់ (Joico)\r\nគ្រូបង្គោល៖ គីម នីម\r\nកាលបរិច្ឆេទ៖ ថ្ងៃសុក្រ ទី11 ធ្នូ 2020 | 9-11 ព្រឹក',	7,	1,	0,	'2023-06-12 15:28:55',	'2023-06-12 15:28:55'),
(45,	'ASK Academy - ការថែទាំសុខភាពសក់ដោយខ្លួនឯងដោយប្រើ BC Bonacure',	'/photo_2023-06-12_11-30-29-9a777587-4211-445d-990b-3daa90cfff30.jpg',	'50',	'078/81667721',	'2020-12-23 09:00:00',	'7',	'***រៀនអនឡាញ តាមរយៈ Zoom\r\nhttps://us02web.zoom.us/j/4056161520?pwd=RFZtcmR3a2NKUkVzZkgvdktYMXl4Zz09\r\nMeeting ID: 405 616 1520\r\nPasscode: abhc\r\n***********************\r\nវគ្គសិក្សា៖ ASK Academy - ការថែទាំសុខភាពសក់ដោយខ្លួនឯងដោយប្រើ BC Bonacure\r\nគ្រូបង្គោល៖ គីម  នីម\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី23 ធ្នូ 2020 ចាប់ពីម៉ោង 9:30 ព្រឹកតទៅ\r\nតម្លៃសិក្សា៖ មិនគិតថ្លៃ ចូលរួមដោយសេរី\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\n☎️ ទូរស័ព្ទ: 078 | 081 66 77 21\r\n📍 អាសយដ្ឋាន: ផ្ទះលេខC65-C66 (កែងតារាងវាយកូនហ្គោលបឹងកក់), សង្កាត់ស្រះចក, ខណ្ឌដូនពេញ,  រាជធានីភ្នំពេញ\r\nhttps://goo.gl/maps/64WVXBFQ7jsZdnB37\r\n\r\nZoom Video (https://us02web.zoom.us/j/4056161520?pwd=RFZtcmR3a2NKUkVzZkgvdktYMXl4Zz09)\r\nJoin our Cloud HD Video Meeting\r\nZoom is the leader in modern enterprise video communications, with an easy, reliable cloud platform for video and audio conferencing, chat, and webinars across mobile, desktop, and room systems. Zoom Rooms is the original software-based conference room solution used around the world in board, conference, huddle, and training rooms, as well as executive offices and classrooms. Founded in 2011, Zoom helps businesses and organizations bring their teams together in a frictionless environment to get more done. Zoom is a publicly traded company headquartered in San Jose, CA.',	7,	1,	0,	'2023-06-12 15:31:33',	'2023-06-12 15:31:33'),
(46,	'ASK Academy - បច្ចេកទេសធ្វើពណ៌សក់',	'/photo_2023-06-12_11-31-50-25824701-a6dc-46b2-b939-206974927f33.jpg',	'80',	'078/81667721',	'2021-01-08 09:00:00',	'7',	'ចូលរៀនបង្កើនចំណេះដឹងហើយ ថែមទាំងទទួលបានប្រូម៉ូសិនពិសេសទៀត!!!  រុះរាន់ឡើងចំនួនកៅអីមានកំណត់។\r\n\r\nវគ្គសិក្សា៖ ASK Academy - បច្ចេកទេសធ្វើពណ៌សក់\r\nប្រធានបទ៖ Less is more & quick technique\r\nគ្រូបង្គោល៖ Wiwat\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី08 មករា 2021\r\nតម្លៃសិក្សា៖ បង់$80 ឬ ទិញផលិតផល$800',	3,	1,	0,	'2023-06-12 15:33:04',	'2023-06-12 15:33:04'),
(47,	'ASK Academy - បច្ចេកទេសធ្វើពណ៌សក់',	'/photo_2023-06-12_11-31-50-25824701-a6dc-46b2-b939-206974927f33.jpg',	'80',	'078/81667721',	'2021-01-08 09:00:00',	'7',	'ចូលរៀនបង្កើនចំណេះដឹងហើយ ថែមទាំងទទួលបានប្រូម៉ូសិនពិសេសទៀត!!!  រុះរាន់ឡើងចំនួនកៅអីមានកំណត់។\r\n\r\nវគ្គសិក្សា៖ ASK Academy - បច្ចេកទេសធ្វើពណ៌សក់\r\nប្រធានបទ៖ Less is more & quick technique\r\nគ្រូបង្គោល៖ Wiwat\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី08 មករា 2021\r\nតម្លៃសិក្សា៖ បង់$80 ឬ ទិញផលិតផល$800',	3,	2,	0,	'2023-06-12 15:33:04',	'2023-06-12 17:22:31'),
(48,	'OpenDay - ព្យាបាលស្នែកក្បាល',	'/photo_2023-06-12_13-22-44-0a17e2d5-79c7-4e50-9c5a-44faa586148e.jpg',	'00',	'078/81667721',	'2021-01-15 09:00:00',	'3',	'វគ្គសិក្សា៖ OpenDay - ព្យាបាលស្នែកក្បាល\r\nប្រធានបទ៖ ម៉ាស្សាស្បែកក្បាល និង ព្យាបាលស្បែកក្បាល ស្ងួត រមាស់ អង្គែ ជាមួយ BC Soothing & Oil Ultime\r\nគ្រូបង្គោល៖ Kim Nim\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី15 មករា 2021\r\nតម្លៃសិក្សា៖ មិនគិតថ្លៃ\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\nឆាតចូលផេក ឬ\r\n☎️ ទូរស័ព្ទ: 078 | 081 66 77 21\r\n📍 អាសយដ្ឋាន: ផ្ទះលេខC65-C66 (កែងតារាងវាយកូនហ្គោលបឹងកក់), សង្កាត់ស្រះចក, ខណ្ឌដូនពេញ,  រាជធានីភ្នំពេញ\r\n\r\nLink Zoom:\r\nhttps://us02web.zoom.us/j/4056161520?pwd=RFZtcmR3a2NKUkVzZkgvdktYMXl4Zz09\r\n\r\nMeeting ID: 405 616 1520\r\nPasscode: abhc\r\n\r\nបងប្អូនអាចមករៀនផ្ទាល់ដល់ អគារABHC ឬ រៀនអនឡាញតាមរយៈZoom',	NULL,	1,	0,	'2023-06-12 17:25:34',	'2023-06-12 18:20:23'),
(49,	'OpenDay ប្រធានបទ៖ ម៉ាស្សាដៃជើង និង លាបពណ៌ក្រចកឱ្យបានស្អាតជាមួយ Yves',	'/photo_2023-06-12_13-25-54-309f4fce-5a38-4038-910c-bfe873c04e21.jpg',	'00',	'078/81667721',	'2021-01-22 09:00:00',	'3',	'វគ្គសិក្សា៖ OpenDay\r\nប្រធានបទ៖ ម៉ាស្សាដៃជើង និង លាបពណ៌ក្រចកឱ្យបានស្អាតជាមួយ Yves Rocher & O.P.I\r\nគ្រូបង្គោល៖ Nary\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី 22 មករា 2021\r\nតម្លៃសិក្សា៖ មិនគិតថ្លៃ\r\n\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\nឆាតចូលផេក ឬ\r\n☎️ ទរស័ព្ទ: 078 | 081 66 77 21\r\n📍 អាសយដ្ឋាន: ផ្ទះលេខC65-C66 (កែងតារាងវាយកូនហ្គោលបឹងកក់), សង្កាត់ស្រះចក, ខណ្ឌដូនពេញ,  រាជធានីភ្នំពេញ',	NULL,	1,	0,	'2023-06-12 17:27:09',	'2023-06-12 18:20:39'),
(50,	'OpenDay (2 points) ប្រធានបទ៖ ព្យាបាល និងថែទាំសក់ខូចដោយសារលេងពណ៌ញឹកញាប់',	'/photo_2023-06-12_13-27-42-1a8bb42a-fb26-44ba-9156-7d54e5b7901e.jpg',	'00',	'078/81667721',	'2021-02-05 09:00:00',	'3',	'វគ្គសិក្សា៖ OpenDay (2 points)\r\nប្រធានបទ៖ ព្យាបាល និងថែទាំសក់ខូចដោយសារលេងពណ៌ញឹកញាប់\r\nគ្រូបង្គោល៖ គីម នីម\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី 05 កុម្ភៈ 2021\r\nតម្លៃសិក្សា៖ មិនគិតថ្លៃ\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\nឆាតចូលផេក ឬ\r\n☎️ ទូរស័ព្ទ: 078 | 081 66 77 21\r\n📍 អាសយដ្ឋាន: ផ្ទះលេខC65-C66 (កែងតារាងវាយកូនហ្គោលបឹងកក់), សង្កាត់ស្រះចក, ខណ្ឌដូនពេញ,  រាជធានីភ្នំពេញ',	NULL,	1,	0,	'2023-06-12 17:29:00',	'2023-06-12 18:20:55'),
(51,	'ASK Course (5 points) ប្រធានបទ៖ ម៉ូតសក់ឆ្នៃប្រឌិតថ្មី',	'/photo_2023-06-12_13-29-17-fb24bd26-079e-4863-8206-74ad61f4ad25.jpg',	'100',	'078/81667721',	'2021-02-17 09:00:00',	'14',	'គ្គសិក្សា៖ ASK Course (5 points)\r\nប្រធានបទ៖ ម៉ូតសក់ឆ្នៃប្រឌិតថ្មី The utmost cut & Curl\r\nគ្រូបង្គោល៖ Vannak\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី 17-18 កុម្ភៈ 2021\r\nតម្លៃសិក្សា៖  100$ ឬ ចំណាយលើផលិតផល $1000\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\nឆាតចូលផេក ឬ\r\n☎️ ទូរស័ព្ទ: 078 | 081 66 77 21\r\n📍 អាសយដ្ឋាន: ផ្ទះលេខC65-C66 (កែងតារាងវាយកូនហ្គោលបឹងកក់), សង្កាត់ស្រះចក, ខណ្ឌដូនពេញ,  រាជធានីភ្នំពេញ',	NULL,	1,	0,	'2023-06-12 17:31:14',	'2023-06-12 18:21:08'),
(52,	'OpenDay (2 points) ប្រធានបទ៖ ជ្រើសរើសផលិតផលដែលសាកសមនឹងម៉ូតសក់លោកអ្នកចង់បាន (Osis, Silhoutte)',	'/photo_2023-06-12_13-31-04-8ab728a1-0de5-4964-96cd-d11c558407c3.jpg',	'00',	'078/81667721',	'2021-02-19 09:00:00',	'3',	'វគ្គសិក្សា៖ OpenDay (2 points)\r\nប្រធានបទ៖ ជ្រើសរើសផលិតផលដែលសាកសមនឹងម៉ូតសក់លោកអ្នកចង់បាន (Osis, Silhoutte)\r\nគ្រូបង្គោល៖ គីម នីម\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី 19 កុម្ភៈ 2021\r\nតម្លៃសិក្សា៖ មិនគិតថ្លៃ',	NULL,	1,	0,	'2023-06-12 17:32:21',	'2023-06-12 18:48:53'),
(53,	'Leadership & Management ប្រធានបទ៖ BUSINESS IN DEPTH',	'/photo_2023-06-12_13-41-57-70d06a6f-e074-433f-b32c-37bef2fdf1e7.jpg',	'1500',	'078/81667721',	'2021-03-01 09:00:00',	'21',	'វគ្គសិក្សា៖ Leadership & Management\r\nប្រធានបទ៖ BUSINESS IN DEPTH\r\nបង្រៀនដោយ៖ La Vibol \r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី 1-3 មីនា 2021\r\nតម្លៃសិក្សា៖ $1,500',	NULL,	1,	0,	'2023-06-12 18:13:31',	'2023-06-12 18:49:05'),
(54,	'ASK Course (5 points)',	'/photo_2023-06-12_14-13-46-dd6b9572-3936-430e-8f81-9be6285ed08d.jpg',	'100',	'078/81667721',	'2021-02-24 09:00:00',	'14',	'វគ្គសិក្សា៖ ASK Course (5 points)\r\nប្រធានបទ៖ ការលាងពណ៌សក់ឱ្យមានប្រសិទ្ធភាព និងត្រឹមត្រូវ - Essential Bleaching\r\nគ្រូបង្គោល៖ Kim Nim\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី 24-25 កុម្ភៈ 2021\r\nតម្លៃសិក្សា៖  100$ ឬ ចំណាយលើផលិតផល $1,000',	NULL,	1,	0,	'2023-06-12 18:14:56',	'2023-06-12 18:49:23'),
(55,	'OpenDay (2 points) ប្រធានបទ៖ ម៉ាស្សាដៃ និង ម៉ាស្សាជ់ងឱ្យបានល្អត្រឹមត្រូវ ជាមួយផលិតផល Yves Rocher',	'/photo_2023-06-12_14-18-10-0a67f2c4-33cc-4a36-9fcf-5eeb02c57cdb.jpg',	'00',	'078/81667721',	'2021-02-26 09:30:00',	'7',	'វគ្គសិក្សា៖ OpenDay (2 points)\r\nប្រធានបទ៖ ម៉ាស្សាដៃ និង ម៉ាស្សាជ់ងឱ្យបានល្អត្រឹមត្រូវ ជាមួយផលិតផល Yves Rocher\r\nគ្រូបង្គោល៖ ពៅ សុវណ្ណារី\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី 26 កុម្ភៈ 2021\r\nតម្លៃសិក្សា៖ មិនគិតថ្លៃ',	NULL,	1,	0,	'2023-06-12 18:19:58',	'2023-06-12 18:19:58'),
(56,	'ASK Course (5 points) ប្រធានបទ៖ ការអ៊ុតសក់ម៉ូត C-Curl',	'/photo_2023-06-12_14-46-18-bbf32c85-61c7-41a4-b0b3-451ad1ad96f1.jpg',	'100',	'078/81667721',	'2021-03-08 09:00:00',	'14',	'វគ្គសិក្សា៖ ASK Course (5 points)\r\nប្រធានបទ៖ ការអ៊ុតសក់ម៉ូត C-Curl\r\nគ្រូបង្គោល៖ Sinky\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី 08-09 មិនា 2021',	6,	1,	0,	'2023-06-12 18:48:31',	'2023-06-12 18:48:31'),
(57,	'ASK Course (5 points) ប្រធានបទ៖ ការអ៊ុតសក់ម៉ូត C-Curl',	'/photo_2023-06-12_14-46-18-bbf32c85-61c7-41a4-b0b3-451ad1ad96f1.jpg',	'100',	'078/81667721',	'2021-03-08 09:00:00',	'14',	'វគ្គសិក្សា៖ ASK Course (5 points)\r\nប្រធានបទ៖ ការអ៊ុតសក់ម៉ូត C-Curl\r\nគ្រូបង្គោល៖ Sinky\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី 08-09 មិនា 2021',	6,	1,	0,	'2023-06-12 18:48:31',	'2023-06-12 18:48:31'),
(58,	'OpenDay (2 points) ប្រធានបទ៖ ការថែរក្សាសក់នៅផ្ទះឱ្យបានល្អបំផុតជាមួយនឹង SKP BC Bonacure',	'/photo_2023-06-12_14-51-09-d7083d07-cd49-4192-8d0c-a8558947743b.jpg',	'00',	'078/81667721',	'2021-03-05 09:30:00',	'7',	'វគ្គសិក្សា៖ OpenDay (2 points)\r\nប្រធានបទ៖ ការថែរក្សាសក់នៅផ្ទះឱ្យបានល្អបំផុតជាមួយនឹង SKP BC Bonacure\r\nគ្រូបង្គោល៖ គីម នីម\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី 05 ខែមិនា 2021\r\nតម្លៃសិក្សា៖ មិនគិតថ្លៃ',	NULL,	1,	0,	'2023-06-12 18:52:46',	'2023-06-12 18:52:46'),
(59,	'OpenDay (2 points) ប្រធានបទ៖ ស្វែងយល់ពីភាពខុសគ្នារវាងការអ៊ុតសក់ត្រជាក់ និងអ៊ុតសក់ដោយម៉ាស៊ីន',	'/photo_2023-06-12_14-59-00-5e4d7baa-119f-4847-a48c-f829ed2abc28.jpg',	'00',	'078/81667721',	'2021-03-12 09:30:00',	'3',	'វគ្គសិក្សា៖ OpenDay (2 points)\r\nប្រធានបទ៖ ស្វែងយល់ពីភាពខុសគ្នារវាងការអ៊ុតសក់ត្រជាក់ និងអ៊ុតសក់ដោយម៉ាស៊ីន\r\nគ្រូបង្គោល៖ គីម នីម\r\nកាលបរិច្ឆេទ៖ ថ្ងៃទី 12 ខែមិនា 2021\r\nតម្លៃសិក្សា៖ មិនគិតថ្លៃ\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\nឆាតចូលផេក ឬ\r\n☎️ ទូរស័ព្ទ: 078 | 081 66 77 21',	7,	1,	0,	'2023-06-12 19:00:11',	'2023-06-12 19:00:11'),
(60,	'Open day',	'/photo_2023-06-12_15-12-53-035afdcb-c1c6-4889-aedd-8fec9b1a42b7.jpg',	'00',	'078/81667721',	'2021-05-17 09:00:00',	'3',	'បន្តអភិវឌ្ឍចំណេះដឹងរបស់បងប្អូនជាងសក់ទាំងអស់គ្នាជាមួយនឹងABHC ដើម្បីអាចត្រលប់ទៅកាន់អាជីវកម្មវិញជាមួយនឹង ទំនុកចិត្ត សមត្ថភាព ភាពជឿជាក់ និងគុណភាពសេវាកម្មមួយដ៍ល្អ សម្រាប់អតិថិជនរបស់បងប្អូនទាំងអស់គ្នា។\r\n----------------------------------------------------\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\nឆាតចូលផេក ឬ\r\n☎️ ទរស័ព្ទ: 078 | 081 66 77 21',	NULL,	1,	0,	'2023-06-12 19:14:52',	'2023-06-12 19:14:52'),
(61,	'Open day',	'/photo_2023-06-12_15-15-05-4f8c8e52-89cb-4f7c-bdf2-907b88c0c585.jpg',	'00',	'078/81667721',	'2021-05-13 09:00:00',	'3',	'បន្តអភិវឌ្ឍចំណេះដឹងរបស់បងប្អូនជាងសក់ទាំងអស់គ្នាជាមួយនឹងABHC ដើម្បីអាចត្រលប់ទៅកាន់អាជីវកម្មវិញជាមួយនឹង ទំនុកចិត្ត សមត្ថភាព ភាពជឿជាក់ និងគុណភាពសេវាកម្មមួយដ៍ល្អ សម្រាប់អតិថិជនរបស់បងប្អូនទាំងអស់គ្នា។\r\n----------------------------------------------------\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\nឆាតចូលផេក ឬ\r\n☎️ ទរស័ព្ទ: 078 | 081 66 77 21',	7,	1,	0,	'2023-06-12 19:16:04',	'2023-06-12 19:16:04'),
(62,	'Open day',	'/photo_2023-06-12_15-16-15-bdaefb42-6c24-4c6b-92bc-b8a622552be1.jpg',	'00',	'078/81667721',	'2021-05-18 09:00:00',	'3',	'បន្តអភិវឌ្ឍចំណេះដឹងរបស់បងប្អូនជាងសក់ទាំងអស់គ្នាជាមួយនឹងABHC ដើម្បីអាចត្រលប់ទៅកាន់អាជីវកម្មវិញជាមួយនឹង ទំនុកចិត្ត សមត្ថភាព ភាពជឿជាក់ និងគុណភាពសេវាកម្មមួយដ៍ល្អ សម្រាប់អតិថិជនរបស់បងប្អូនទាំងអស់គ្នា។\r\n----------------------------------------------------\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\nឆាតចូលផេក ឬ\r\n☎️ ទរស័ព្ទ: 078 | 081 66 77 21',	NULL,	1,	0,	'2023-06-12 19:17:17',	'2023-06-12 19:17:17'),
(63,	'Open day',	'/photo_2023-06-12_15-17-35-9b5c1375-cb4c-43d8-bdcd-4a0d5413dfcf.jpg',	'00',	'078/81667721',	'2021-05-19 09:00:00',	'3',	'បន្តអភិវឌ្ឍចំណេះដឹងរបស់បងប្អូនជាងសក់ទាំងអស់គ្នាជាមួយនឹងABHC ដើម្បីអាចត្រលប់ទៅកាន់អាជីវកម្មវិញជាមួយនឹង ទំនុកចិត្ត សមត្ថភាព ភាពជឿជាក់ និងគុណភាពសេវាកម្មមួយដ៍ល្អ សម្រាប់អតិថិជនរបស់បងប្អូនទាំងអស់គ្នា។\r\n----------------------------------------------------\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\nឆាតចូលផេក ឬ\r\n☎️ ទរស័ព្ទ: 078 | 081 66 77 21',	NULL,	1,	0,	'2023-06-12 19:18:24',	'2023-06-12 19:18:24'),
(64,	'Open day',	'/photo_2023-06-12_15-18-48-032101b8-803f-433d-8946-04c87f917015.jpg',	'00',	'078/81667721',	'2021-05-19 09:00:00',	'3',	'បន្តអភិវឌ្ឍចំណេះដឹងរបស់បងប្អូនជាងសក់ទាំងអស់គ្នាជាមួយនឹងABHC ដើម្បីអាចត្រលប់ទៅកាន់អាជីវកម្មវិញជាមួយនឹង ទំនុកចិត្ត សមត្ថភាព ភាពជឿជាក់ និងគុណភាពសេវាកម្មមួយដ៍ល្អ សម្រាប់អតិថិជនរបស់បងប្អូនទាំងអស់គ្នា។',	7,	1,	0,	'2023-06-12 19:19:32',	'2023-06-12 19:19:32'),
(65,	'Open day',	'/photo_2023-06-12_15-23-34-04912570-5ce3-4810-ba8c-501d84e10876.jpg',	'00',	'078/81667721',	'2021-05-25 09:00:00',	'3',	'ការផ្តល់ចំណេះដឹងថ្មីៗជាបន្តបន្ទាប់ទៅដល់បងប្អួនជាជាងអាជីពក្នុងវិស័យរចនាសក់ និង ក្រចកឱ្យកាន់តែប្រសើរជាងមុន ជាបេសកកម្មរបស់ក្រុមហ៊ុន អេប៊ីអេចស៊ី។ កុំភ្លេចចូលរួមជាមួយពួកយើង។\r\n----------------------------------------------------\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\nឆាតចូលផេក ឬ\r\n☎️ ទរស័ព្ទ: 078 | 081 66 77 21',	NULL,	1,	0,	'2023-06-12 19:25:14',	'2023-06-12 19:25:14'),
(66,	'Open day',	'/photo_2023-06-12_16-13-24-728a68e3-c56d-4869-bd0f-c033fabd7e55.jpg',	'00',	'078/81667721',	'2021-05-24 09:00:00',	'3',	'ការផ្តល់ចំណេះដឹងថ្មីៗជាបន្តបន្ទាប់ទៅដល់បងប្អួនជាជាងអាជីពក្នុងវិស័យរចនាសក់ និង ក្រចកឱ្យកាន់តែប្រសើរជាងមុន ជាបេសកកម្មរបស់ក្រុមហ៊ុន អេប៊ីអេចស៊ី។ កុំភ្លេចចូលរួមជាមួយពួកយើង។\r\n----------------------------------------------------\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\nឆាតចូលផេក ឬ\r\n☎️ ទរស័ព្ទ: 078 | 081 66 77 21',	NULL,	1,	0,	'2023-06-12 20:15:44',	'2023-06-12 20:15:44'),
(67,	'Open day',	'/photo_2023-06-12_16-15-48-9d322f83-5c85-4354-b39f-b557f67a6cd4.jpg',	'00',	'078/81667721',	'2021-05-26 09:00:00',	'3',	'ការផ្តល់ចំណេះដឹងថ្មីៗជាបន្តបន្ទាប់ទៅដល់បងប្អួនជាជាងអាជីពក្នុងវិស័យរចនាសក់ និង ក្រចកឱ្យកាន់តែប្រសើរជាងមុន ជាបេសកកម្មរបស់ក្រុមហ៊ុន អេប៊ីអេចស៊ី។ កុំភ្លេចចូលរួមជាមួយពួកយើង។\r\n----------------------------------------------------\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\nឆាតចូលផេក ឬ\r\n☎️ ទរស័ព្ទ: 078 | 081 66 77 21',	NULL,	1,	0,	'2023-06-12 20:18:04',	'2023-06-12 20:18:04'),
(68,	'Open Day',	'/photo_2023-06-12_16-25-12-95130113-e723-4dc8-aa5e-3a1e2cbe6bf8.jpg',	'00',	'078/81667721',	'2021-07-22 09:00:00',	'3',	'វគ្គ៖  Open Day\r\nចូលរួមសិក្សាដោយមិនគិតថ្លៃ តាមរយៈថ្នាក់Online Zoom Meeting\r\nការផ្តល់ចំណេះដឹងថ្មីៗជាបន្តបន្ទាប់ទៅដល់បងប្អួនជាជាងអាជីពក្នុងវិស័យរចនាសក់ និង ក្រចកឱ្យកាន់តែប្រសើរជាងមុន ជាបេសកកម្មរបស់ក្រុមហ៊ុន អេប៊ីអេចស៊ី។ កុំភ្លេចចូលរួមជាមួយពួកយើង។\r\n----------------------------------------------------\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\nឆាតចូលផេក ឬ',	7,	1,	0,	'2023-06-12 20:27:22',	'2023-06-12 20:27:22'),
(69,	'Open Day ចូលរួមសិក្សាដោយមិនគិតថ្លៃ តាមរយៈថ្នាក់Online Zoom Meeting',	'/photo_2023-06-12_16-28-08-1c47689b-19a3-463f-acd9-b26e0f08901c.jpg',	'00',	'078/81667721',	'2021-10-08 09:30:00',	'14',	'វគ្គ៖  Open Day\r\nចូលរួមសិក្សាដោយមិនគិតថ្លៃ តាមរយៈថ្នាក់Online Zoom Meeting\r\nការផ្តល់ចំណេះដឹងថ្មីៗជាបន្តបន្ទាប់ទៅដល់បងប្អួនជាជាងអាជីពក្នុងវិស័យរចនាសក់ និង ក្រចកឱ្យកាន់តែប្រសើរជាងមុន ជាបេសកកម្មរបស់ក្រុមហ៊ុន អេប៊ីអេចស៊ី។ កុំភ្លេចចូលរួមជាមួយពួកយើង។\r\n----------------------------------------------------\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\nឆាតចូលផេក ឬ\r\n☎️ ទូរស័ព្ទ: 078 | 081 66 77 21',	NULL,	1,	0,	'2023-06-12 20:29:58',	'2023-06-12 20:29:58'),
(70,	'Open Day ចូលរួមសិក្សាដោយមិនគិតថ្លៃ តាមរយៈថ្នាក់Online Zoom Meeting',	'/photo_2023-06-12_16-30-48-3ed8d54d-85f1-4e5d-b540-6209aca146ae.jpg',	'00',	'078/81667721',	'2021-08-13 09:00:00',	'7',	'វគ្គ៖  Open Day\r\nចូលរួមសិក្សាដោយមិនគិតថ្លៃ តាមរយៈថ្នាក់Online Zoom Meeting\r\nការផ្តល់ចំណេះដឹងថ្មីៗជាបន្តបន្ទាប់ទៅដល់បងប្អួនជាជាងអាជីពក្នុងវិស័យរចនាសក់ និង ក្រចកឱ្យកាន់តែប្រសើរជាងមុន ជាបេសកកម្មរបស់ក្រុមហ៊ុន អេប៊ីអេចស៊ី។ កុំភ្លេចចូលរួមជាមួយពួកយើង។\r\n----------------------------------------------------\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\nឆាតចូលផេក ឬ\r\n☎️ ទរស័ព្ទ: 078 | 081 66 77 21',	7,	1,	0,	'2023-06-12 20:41:15',	'2023-06-12 20:41:15'),
(71,	'Open day',	'/photo_2023-06-12_16-45-16-55e8d989-2842-4388-8e61-578b2718b4a0.jpg',	'00',	'078/81667721',	'2021-08-17 09:00:00',	'7',	'វគ្គ៖  Open Day\r\nចូលរួមសិក្សាដោយមិនគិតថ្លៃ តាមរយៈថ្នាក់Online Zoom Meeting\r\nការផ្តល់ចំណេះដឹងថ្មីៗជាបន្តបន្ទាប់ទៅដល់បងប្អួនជាជាងអាជីពក្នុងវិស័យរចនាសក់ និង ក្រចកឱ្យកាន់តែប្រសើរជាងមុន ជាបេសកកម្មរបស់ក្រុមហ៊ុន អេប៊ីអេចស៊ី។ កុំភ្លេចចូលរួមជាមួយពួកយើង។\r\n----------------------------------------------------\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\nឆាតចូលផេក ឬ\r\n☎️ ទរស័ព្ទ: 078 | 081 66 77 21',	NULL,	1,	0,	'2023-06-12 20:47:32',	'2023-06-12 20:47:32'),
(72,	'Open Day',	'/photo_2023-06-12_16-50-49-2359647b-e655-4361-bc15-6d6404e1d139.jpg',	'00',	'078/81667721',	'2021-08-19 09:30:00',	'7',	'វគ្គ៖  Open Day\r\nចូលរួមសិក្សាដោយមិនគិតថ្លៃ តាមរយៈថ្នាក់Online Zoom Meeting\r\nការផ្តល់ចំណេះដឹងថ្មីៗជាបន្តបន្ទាប់ទៅដល់បងប្អួនជាជាងអាជីពក្នុងវិស័យរចនាសក់ និង ក្រចកឱ្យកាន់តែប្រសើរជាងមុន ជាបេសកកម្មរបស់ក្រុមហ៊ុន អេប៊ីអេចស៊ី។ កុំភ្លេចចូលរួមជាមួយពួកយើង។\r\n----------------------------------------------------\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\nឆាតចូលផេក ឬ\r\n☎️ ទរស័ព្ទ: 078 | 081 66 77 21',	NULL,	1,	0,	'2023-06-12 20:52:10',	'2023-06-12 20:52:10'),
(73,	'Open day',	'/photo_2023-06-12_16-54-07-2c9f80f9-ca7c-448e-bd9b-b911e73082ce.jpg',	'00',	'078/81667721',	'2021-08-24 09:00:00',	'7',	'វគ្គ៖  Open Day\r\nចូលរួមសិក្សាដោយមិនគិតថ្លៃ តាមរយៈថ្នាក់Online Zoom Meeting\r\nការផ្តល់ចំណេះដឹងថ្មីៗជាបន្តបន្ទាប់ទៅដល់បងប្អួនជាជាងអាជីពក្នុងវិស័យរចនាសក់ និង ក្រចកឱ្យកាន់តែប្រសើរជាងមុន ជាបេសកកម្មរបស់ក្រុមហ៊ុន អេប៊ីអេចស៊ី។ កុំភ្លេចចូលរួមជាមួយពួកយើង។\r\n----------------------------------------------------\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\nឆាតចូលផេក ឬ\r\n☎️ ទរស័ព្ទ: 078 | 081 66 77 21',	NULL,	1,	0,	'2023-06-12 20:55:06',	'2023-06-12 20:55:06'),
(74,	'Open Day ចូលរួមសិក្សាដោយមិនគិតថ្លៃ តាមរយៈថ្នាក់Online Zoom Meeting',	'/photo_2023-06-13_09-31-29-10b4e1e8-3a3f-4a8b-9ad1-091e0ef219a0.jpg',	'00',	'078/81667721',	'2021-08-26 09:30:00',	'7',	'វគ្គ៖  Open Day\r\nចូលរួមសិក្សាដោយមិនគិតថ្លៃ តាមរយៈថ្នាក់Online Zoom Meeting\r\nការផ្តល់ចំណេះដឹងថ្មីៗជាបន្តបន្ទាប់ទៅដល់បងប្អួនជាជាងអាជីពក្នុងវិស័យរចនាសក់ និង ក្រចកឱ្យកាន់តែប្រសើរជាងមុន ជាបេសកកម្មរបស់ក្រុមហ៊ុន អេប៊ីអេចស៊ី។ កុំភ្លេចចូលរួមជាមួយពួកយើង។\r\n----------------------------------------------------\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\nឆាតចូលផេក ឬ\r\n☎️ ទរស័ព្ទ: 078 | 081 66 77 21',	7,	1,	0,	'2023-06-13 13:32:57',	'2023-06-13 13:32:57'),
(75,	'Open Day ចូលរួមសិក្សាដោយមិនគិតថ្លៃ តាមរយៈថ្នាក់Online Zoom Meeting',	'/photo_2023-06-13_09-31-29-169a160a-c5dc-4705-8900-ae8be4687700.jpg',	'00',	'078/81667721',	'2021-09-11 14:00:00',	'3',	'វគ្គ៖  Open Day\r\nចូលរួមសិក្សាដោយមិនគិតថ្លៃ តាមរយៈថ្នាក់Online Zoom Meeting\r\nការផ្តល់ចំណេះដឹងថ្មីៗជាបន្តបន្ទាប់ទៅដល់បងប្អួនជាជាងអាជីពក្នុងវិស័យរចនាសក់ ឱ្យកាន់តែប្រសើរជាងមុន ជាបេសកកម្មរបស់ក្រុមហ៊ុន អេប៊ីអេចស៊ី។ កុំភ្លេចចូលរួមជាមួយពួកយើង។\r\n----------------------------------------------------\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\nឆាតចូលផេក ឬ\r\n☎️ ទរស័ព្ទ: 078 | 081 66 77 21',	7,	1,	0,	'2023-06-13 13:34:41',	'2023-06-13 13:34:41'),
(76,	'Open Day ចូលរួមសិក្សាដោយមិនគិតថ្លៃ តាមរយៈថ្នាក់Online Zoom Meeting',	'/photo_2023-06-13_09-35-47-cfb439c2-e25a-41ea-9a64-1e84c8919b67.jpg',	'00',	'078/81667721',	'2021-09-12 14:00:00',	'3',	'វគ្គ៖  Open Day\r\nចូលរួមសិក្សាដោយមិនគិតថ្លៃ តាមរយៈថ្នាក់Online Zoom Meeting\r\nការផ្តល់ចំណេះដឹងថ្មីៗជាបន្តបន្ទាប់ទៅដល់បងប្អួនជាជាងអាជីពក្នុងវិស័យរចនាសក់ ឱ្យកាន់តែប្រសើរជាងមុន ជាបេសកកម្មរបស់ក្រុមហ៊ុន អេប៊ីអេចស៊ី។ កុំភ្លេចចូលរួមជាមួយពួកយើង។\r\n----------------------------------------------------\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\nឆាតចូលផេក ឬ\r\n☎️ ទរស័ព្ទ: 078 | 081 66 77 21',	7,	1,	0,	'2023-06-13 13:36:53',	'2023-06-13 13:36:53'),
(77,	'Open Day ចូលរួមសិក្សាដោយមិនគិតថ្លៃ តាមរយៈថ្នាក់Online Zoom Meeting',	'/photo_2023-06-13_09-38-05-2b6c5b45-1638-4c7b-ad01-9b05e348db4f.jpg',	'00',	'078/81667721',	'2021-09-21 09:00:00',	'3',	'វគ្គ៖  Open Day\r\nចូលរួមសិក្សាដោយមិនគិតថ្លៃ តាមរយៈថ្នាក់Online Zoom Meeting\r\nការផ្តល់ចំណេះដឹងថ្មីៗជាបន្តបន្ទាប់ទៅដល់បងប្អួនជាជាងអាជីពក្នុងវិស័យរចនាសក់ ឱ្យកាន់តែប្រសើរជាងមុន ជាបេសកកម្មរបស់ក្រុមហ៊ុន អេប៊ីអេចស៊ី។ កុំភ្លេចចូលរួមជាមួយពួកយើង។\r\n----------------------------------------------------\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\nឆាតចូលផេក ឬ\r\n☎️ ទរស័ព្ទ: 078 | 081 66 77 21',	7,	1,	0,	'2023-06-13 13:39:01',	'2023-06-13 13:39:01'),
(78,	'Open Day ចូលរួមសិក្សាដោយមិនគិតថ្លៃ តាមរយៈថ្នាក់Online Zoom Meeting',	'/photo_2023-06-13_09-48-44-e65b6e1b-9669-480b-8198-f62765a496b8.jpg',	'00',	'078/81667721',	'2021-09-30 14:00:00',	'3',	'វគ្គ៖  Open Day\r\nចូលរួមសិក្សាដោយមិនគិតថ្លៃ តាមរយៈថ្នាក់Online Zoom Meeting\r\nការផ្តល់ចំណេះដឹងថ្មីៗជាបន្តបន្ទាប់ទៅដល់បងប្អួនជាជាងអាជីពក្នុងវិស័យរចនាសក់ ឱ្យកាន់តែប្រសើរជាងមុន ជាបេសកកម្មរបស់ក្រុមហ៊ុន អេប៊ីអេចស៊ី។ កុំភ្លេចចូលរួមជាមួយពួកយើង។\r\n----------------------------------------------------\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\nឆាតចូលផេក ឬ\r\n🌐 www.abhc.asia\r\n☎️ 078 | 081 66 77 21',	7,	1,	0,	'2023-06-13 13:50:10',	'2023-06-13 13:50:10'),
(79,	'Open Day ចូលរួមសិក្សាដោយមិនគិតថ្លៃ តាមរយៈថ្នាក់Online Zoom Meeting',	'/photo_2023-06-13_09-48-44-0324e45f-fac8-4076-8550-6d93d0bff805.jpg',	'00',	'078/81667721',	'2021-09-30 14:00:00',	'3',	'វគ្គ៖  Open Day\r\nចូលរួមសិក្សាដោយមិនគិតថ្លៃ តាមរយៈថ្នាក់Online Zoom Meeting\r\nការផ្តល់ចំណេះដឹងថ្មីៗជាបន្តបន្ទាប់ទៅដល់បងប្អួនជាជាងអាជីពក្នុងវិស័យរចនាសក់ ឱ្យកាន់តែប្រសើរជាងមុន ជាបេសកកម្មរបស់ក្រុមហ៊ុន អេប៊ីអេចស៊ី។ កុំភ្លេចចូលរួមជាមួយពួកយើង។\r\n----------------------------------------------------\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\nឆាតចូលផេក ឬ\r\n🌐 www.abhc.asia\r\n☎️ 078 | 081 66 77 21',	7,	2,	0,	'2023-06-13 14:06:10',	'2023-06-13 14:06:22'),
(80,	'Open Day ចូលរួមសិក្សាដោយមិនគិតថ្លៃ តាមរយៈថ្នាក់Online Zoom Meeting',	'/photo_2023-06-13_10-12-01-148da8bb-7b74-402b-a575-fa5cdf19beff.jpg',	'00',	'078/81667721',	'2021-11-22 09:30:00',	'3',	'វគ្គ៖  Open Day\r\nចូលរួមសិក្សាដោយមិនគិតថ្លៃ តាមរយៈថ្នាក់Online Zoom Meeting\r\nការផ្តល់ចំណេះដឹងថ្មីៗជាបន្តបន្ទាប់ទៅដល់បងប្អួនជាជាងអាជីពក្នុងវិស័យរចនាសក់ ឱ្យកាន់តែប្រសើរជាងមុន ជាបេសកកម្មរបស់ក្រុមហ៊ុន អេប៊ីអេចស៊ី។ កុំភ្លេចចូលរួមជាមួយពួកយើង។\r\n----------------------------------------------------\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\nឆាតចូលផេក ឬ\r\n🌐 www.abhc.asia\r\n☎️ 078 | 081 66 77 21',	7,	1,	0,	'2023-06-13 14:13:45',	'2023-06-13 14:13:45'),
(81,	'Open Day ចូលរួមសិក្សាដោយមិនគិតថ្លៃ ដោយបង្រៀននៅសាលាផ្ទាល់ ដែលសហការជាមួយនឹង BODIA.',	'/photo_2023-06-13_10-16-24-aff8cd78-19a6-400d-afe6-4b3b76cc95a3.jpg',	'00',	'078/81667721',	'2021-12-03 09:00:00',	'0.5',	'វគ្គ៖  Open Day\r\nចូលរួមសិក្សាដោយមិនគិតថ្លៃ ដោយបង្រៀននៅសាលាផ្ទាល់ ដែលសហការជាមួយនឹង BODIA.\r\nការផ្តល់ចំណេះដឹងថ្មីៗជាបន្តបន្ទាប់ទៅដល់បងប្អួនជាជាងអាជីពក្នុងវិស័យសាឡន ឱ្យកាន់តែប្រសើរជាងមុន ជាបេសកកម្មរបស់ក្រុមហ៊ុន អេប៊ីអេចស៊ី។ កុំភ្លេចចូលរួមជាមួយពួកយើង។\r\n----------------------------------------------------\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\nឆាតចូលផេក ឬ\r\n🌐 www.abhc.asia\r\n☎️ 078 | 081 66 77 21',	NULL,	1,	0,	'2023-06-13 14:18:51',	'2023-06-13 14:18:51'),
(82,	'Open Day ចូលរួមសិក្សាដោយមិនគិតថ្លៃ ដោយបង្រៀននៅសាលាផ្ទាល់ ដែលសហការជាមួយនឹង BODIA.',	'/photo_2023-06-13_10-16-24-aff8cd78-19a6-400d-afe6-4b3b76cc95a3.jpg',	'00',	'078/81667721',	'2021-12-03 09:00:00',	'0.5',	'វគ្គ៖  Open Day\r\nចូលរួមសិក្សាដោយមិនគិតថ្លៃ ដោយបង្រៀននៅសាលាផ្ទាល់ ដែលសហការជាមួយនឹង BODIA.\r\nការផ្តល់ចំណេះដឹងថ្មីៗជាបន្តបន្ទាប់ទៅដល់បងប្អួនជាជាងអាជីពក្នុងវិស័យសាឡន ឱ្យកាន់តែប្រសើរជាងមុន ជាបេសកកម្មរបស់ក្រុមហ៊ុន អេប៊ីអេចស៊ី។ កុំភ្លេចចូលរួមជាមួយពួកយើង។\r\n----------------------------------------------------\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\nឆាតចូលផេក ឬ\r\n🌐 www.abhc.asia\r\n☎️ 078 | 081 66 77 21',	NULL,	1,	0,	'2023-06-13 14:18:52',	'2023-06-13 14:18:52'),
(83,	'Open Day ចូលរួមសិក្សាដោយមិនគិតថ្លៃ ដោយបង្រៀននៅសាលាផ្ទាល់ ដែលសហការជាមួយនឹង BODIA.',	'/photo_2023-06-13_10-16-24-aff8cd78-19a6-400d-afe6-4b3b76cc95a3.jpg',	'00',	'078/81667721',	'2021-12-03 09:00:00',	'0.5',	'វគ្គ៖  Open Day\r\nចូលរួមសិក្សាដោយមិនគិតថ្លៃ ដោយបង្រៀននៅសាលាផ្ទាល់ ដែលសហការជាមួយនឹង BODIA.\r\nការផ្តល់ចំណេះដឹងថ្មីៗជាបន្តបន្ទាប់ទៅដល់បងប្អួនជាជាងអាជីពក្នុងវិស័យសាឡន ឱ្យកាន់តែប្រសើរជាងមុន ជាបេសកកម្មរបស់ក្រុមហ៊ុន អេប៊ីអេចស៊ី។ កុំភ្លេចចូលរួមជាមួយពួកយើង។\r\n----------------------------------------------------\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\nឆាតចូលផេក ឬ\r\n🌐 www.abhc.asia\r\n☎️ 078 | 081 66 77 21',	NULL,	1,	0,	'2023-06-13 14:18:52',	'2023-06-13 14:18:52'),
(84,	'Open Day ចូលរួមសិក្សាដោយមិនគិតថ្លៃ ដោយបង្រៀននៅសាលាផ្ទាល់ ដែលសហការជាមួយនឹង BODIA.',	'/photo_2023-06-13_10-16-24-aff8cd78-19a6-400d-afe6-4b3b76cc95a3.jpg',	'00',	'078/81667721',	'2021-12-03 09:00:00',	'0.5',	'វគ្គ៖  Open Day\r\nចូលរួមសិក្សាដោយមិនគិតថ្លៃ ដោយបង្រៀននៅសាលាផ្ទាល់ ដែលសហការជាមួយនឹង BODIA.\r\nការផ្តល់ចំណេះដឹងថ្មីៗជាបន្តបន្ទាប់ទៅដល់បងប្អួនជាជាងអាជីពក្នុងវិស័យសាឡន ឱ្យកាន់តែប្រសើរជាងមុន ជាបេសកកម្មរបស់ក្រុមហ៊ុន អេប៊ីអេចស៊ី។ កុំភ្លេចចូលរួមជាមួយពួកយើង។\r\n----------------------------------------------------\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\nឆាតចូលផេក ឬ\r\n🌐 www.abhc.asia\r\n☎️ 078 | 081 66 77 21',	NULL,	1,	0,	'2023-06-13 14:18:53',	'2023-06-13 14:18:53'),
(85,	'Open Day ចូលរួមសិក្សាដោយមិនគិតថ្លៃ តាមរយៈថ្នាក់Online Zoom Meeting',	'/photo_2023-06-13_10-21-00-d11c15ee-755b-43b6-8511-b88313071f32.jpg',	'00',	'078/81667721',	'2021-12-17 09:30:00',	'3',	'វគ្គ៖  Open Day\r\nចូលរួមសិក្សាដោយមិនគិតថ្លៃ តាមរយៈថ្នាក់Online Zoom Meeting\r\nការផ្តល់ចំណេះដឹងថ្មីៗជាបន្តបន្ទាប់ទៅដល់បងប្អួនជាជាងអាជីពក្នុងវិស័យរចនាសក់ ឱ្យកាន់តែប្រសើរជាងមុន ជាបេសកកម្មរបស់ក្រុមហ៊ុន អេប៊ីអេចស៊ី។ កុំភ្លេចចូលរួមជាមួយពួកយើង។\r\n----------------------------------------------------\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\nឆាតចូលផេក ឬ\r\n🌐 www.abhc.asia\r\n☎️ 078 | 081 66 77 21',	NULL,	1,	0,	'2023-06-13 14:23:24',	'2023-06-13 14:23:24'),
(86,	'Open Day ចូលរួមសិក្សាដោយមិនគិតថ្លៃ តាមរយៈថ្នាក់Online Zoom Meeting',	'/photo_2023-06-13_10-24-17-55156ba2-36e5-4a2b-9911-efdde85c07e9.jpg',	'00',	'078/81667721',	'2021-12-23 09:30:00',	'3',	'វគ្គ៖  Open Day\r\nចូលរួមសិក្សាដោយមិនគិតថ្លៃ តាមរយៈថ្នាក់Online Zoom Meeting\r\nការផ្តល់ចំណេះដឹងថ្មីៗជាបន្តបន្ទាប់ទៅដល់បងប្អួនជាជាងអាជីពក្នុងវិស័យរចនាសក់ ឱ្យកាន់តែប្រសើរជាងមុន ជាបេសកកម្មរបស់ក្រុមហ៊ុន អេប៊ីអេចស៊ី។ កុំភ្លេចចូលរួមជាមួយពួកយើង។\r\n----------------------------------------------------\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\nឆាតចូលផេក ឬ\r\n🌐 www.abhc.asia\r\n☎️ 078 | 081 66 77 21',	7,	1,	0,	'2023-06-13 14:26:09',	'2023-06-13 14:26:09'),
(87,	'Open Day ចូលរួមសិក្សាដោយមិនគិតថ្លៃ តាមរយៈថ្នាក់Online Zoom Meeting',	'/photo_2023-06-13_10-26-53-db7657da-db0b-45ff-8dc9-3ef41cc515f1.jpg',	'00',	'078/81667721',	'2021-12-31 21:30:00',	'3',	'វគ្គ៖  Open Day\r\nចូលរួមសិក្សាដោយមិនគិតថ្លៃ តាមរយៈថ្នាក់Online Zoom Meeting\r\nការផ្តល់ចំណេះដឹងថ្មីៗជាបន្តបន្ទាប់ទៅដល់បងប្អួនជាជាងអាជីពក្នុងវិស័យរចនាសក់ ឱ្យកាន់តែប្រសើរជាងមុន ជាបេសកកម្មរបស់ក្រុមហ៊ុន អេប៊ីអេចស៊ី។ កុំភ្លេចចូលរួមជាមួយពួកយើង។\r\n----------------------------------------------------\r\nចុះឈ្មោះ និងព័ត៌មានបន្ថែម៖\r\nឆាតចូលផេក ឬ\r\n🌐 www.abhc.asia\r\n☎️ 078 | 081 66 77 21',	7,	1,	0,	'2023-06-13 14:27:51',	'2023-06-13 14:28:01'),
(88,	'𝐒𝐚𝐥𝐨𝐧 𝐌𝐚𝐧𝐚𝐠𝐞𝐦𝐞𝐧𝐭 | របៀបរៀបចំ និង ពង្រីកអាជីវកម្មសាឡនដោយនិរន្តភាព',	'/photo_2023-06-13_10-29-46-65e2aaad-7230-4b04-b8fc-a9200f33461f.jpg',	'1000',	'078/81667721',	'2022-01-24 09:00:00',	'6',	'✍️ វគ្គ 𝐒𝐚𝐥𝐨𝐧 𝐌𝐚𝐧𝐚𝐠𝐞𝐦𝐞𝐧𝐭 | របៀបរៀបចំ និង ពង្រីកអាជីវកម្មសាឡនដោយនិរន្តភាព\r\n📅 ថងៃទី 24-26 មករា 2022 | 9ព្រឹក - 4រសៀល\r\n🧑‍🏫 គរូបង្គោល៖ ឡា វិបុល\r\n📍 ទតាំង៖ អគារ អេ ប៊ី អេច ស៊ី\r\nតម្លៃចូលរួម៖ $1,000 /ម្នាក់',	4,	1,	0,	'2023-06-13 14:31:12',	'2023-06-13 14:39:25'),
(89,	'𝐀𝐒𝐊 | ក្លាយជាទីប្រឹក្សាអាជីព លើការថែទាំសក់',	'/photo_2023-06-13_10-31-34-275cb188-f27a-468a-9da4-e0156c9d5002.jpg',	'50',	'078/81667721',	'2022-01-18 21:00:00',	'6',	'✍️ វគ្គ 𝐀𝐒𝐊 | ក្លាយជាទីប្រឹក្សាអាជីព លើការថែទាំសក់\r\n📅 ថងៃទី 18 មករា 2022 | 9ព្រឹក - 4រសៀល\r\n👩‍🏫 គរូបង្គោល៖ ពុយ\r\n📍 ទតាំង៖ អគារ អេ ប៊ី អេច ស៊ី\r\nតម្លៃចូលរួម៖ $50 /ម្នាក់',	NULL,	1,	0,	'2023-06-13 14:33:13',	'2023-06-13 14:33:13'),
(90,	'𝐎𝐩𝐞𝐧𝐃𝐚𝐲 | ការពារសក់ពីកម្តៅថ្ងៃ និង ការបំពុលនៃបរិយាកាស',	'/photo_2023-06-13_10-31-27-cff65eab-b96a-426a-8901-22269c8cc6fc.jpg',	'00',	'078/81667721',	'2022-01-15 09:00:00',	'3',	'✍️ វគ្គ 𝐎𝐩𝐞𝐧𝐃𝐚𝐲 | ការពារសក់ពីកម្តៅថ្ងៃ និង ការបំពុលនៃបរិយាកាស\r\n📅 ថងៃទី 15 មករា 2022 | 9-11ព្រឹក\r\nចូលរួមដោយឥតគិតថ្លៃ ដោយផ្ទាល់នៅអគារ ABHC ឬ អនឡាញតាម Zoom Meeting',	7,	1,	0,	'2023-06-13 14:34:56',	'2023-06-13 14:34:56'),
(91,	'𝐀𝐒𝐊 | ក្លាយជាទីប្រឹក្សាអាជីព លើការថែទាំសក់',	'/photo_2023-06-13_10-35-27-b3741815-5bcf-48df-a83f-25a846e857b4.jpg',	'50',	'078/81667721',	'2022-01-18 09:00:00',	'6',	'✍️ វគ្គ 𝐀𝐒𝐊 | ក្លាយជាទីប្រឹក្សាអាជីព លើការថែទាំសក់\r\n📅 ថងៃទី 18 មករា 2022 | 9ព្រឹក - 4រសៀល\r\n👩‍🏫 គរូបង្គោល៖ ពុយ\r\n📍 ទតាំង៖ អគារ អេ ប៊ី អេច ស៊ី\r\nតម្លៃចូលរួម៖ $50 /ម្នាក់',	5,	1,	0,	'2023-06-13 14:36:35',	'2023-06-13 14:36:35'),
(92,	'𝐒𝐚𝐥𝐨𝐧 𝐌𝐚𝐧𝐚𝐠𝐞𝐦𝐞𝐧𝐭 | របៀបរៀបចំ និង ពង្រីកអាជីវកម្មសាឡនដោយនិរន្តភាព',	'/photo_2023-06-13_10-36-40-b7070e3a-788d-4ce9-93cc-c0fb4d561d28.jpg',	'1000',	'078/81667721',	'2022-01-24 09:00:00',	'12',	'✍️ វគ្គ 𝐒𝐚𝐥𝐨𝐧 𝐌𝐚𝐧𝐚𝐠𝐞𝐦𝐞𝐧𝐭 | របៀបរៀបចំ និង ពង្រីកអាជីវកម្មសាឡនដោយនិរន្តភាព\r\n📅 ថងៃទី 24-26 មករា 2022 | 9ព្រឹក - 4រសៀល\r\n🧑‍🏫 គរូបង្គោល៖ ឡា វិបុល\r\n📍 ទតាំង៖ អគារ អេ ប៊ី អេច ស៊ី\r\nតម្លៃចូលរួម៖ $1,000 /ម្នាក់ ឬ ទិញផលិតផល $3,000 /ម្នាក់',	4,	1,	0,	'2023-06-13 14:39:12',	'2023-06-13 14:39:12'),
(93,	'𝐎𝐩𝐞𝐧𝐃𝐚𝐲 | ការអ៊ុតរួញឌីជីថល បែបព្រីមាម',	'/photo_2023-06-13_10-39-47-8655724d-8c59-41be-beb8-4f965434301e.jpg',	'00',	'078/81667721',	'2022-01-22 09:00:00',	'4',	'ពួកយើងលើកទឺកឲ្យបងប្អូនចូលរួមវគ្គនេះដោយផ្ទាល់ ព្រោះមានការបង្ហាញបច្ចេកទេស និងមានការផ្តល់ប្រូម៉ូសិនជូន!\r\n\r\n✍️ វគ្គ 𝐎𝐩𝐞𝐧𝐃𝐚𝐲 | ការអ៊ុតរួញឌីជីថល បែបព្រីមាម\r\n📅 ថងៃទី 22 មករា 2022 | 9ព្រឹក - 12ថ្ងៃត្រង់\r\nចូលរួមដោយឥតគិតថ្លៃ ដោយផ្ទាល់នៅអគារ ABHC ឬ អនឡាញតាម Zoom Meeting',	7,	1,	0,	'2023-06-13 14:42:36',	'2023-06-13 14:42:36'),
(94,	'𝐎𝐩𝐞𝐧𝐃𝐚𝐲 | ទប់ទល់នឹងភាពចាស់នៃស្បែក',	'/photo_2023-06-13_10-48-55-c4490a85-1503-4255-a98c-c81f3a37f054.jpg',	'00',	'078/81667721',	'2021-01-29 09:00:00',	'4',	'✍️ វគ្គ 𝐎𝐩𝐞𝐧𝐃𝐚𝐲 | ទប់ទល់នឹងភាពចាស់នៃស្បែក\r\n📅 ថងៃទី 29 មករា 2022 | 9ព្រឹក - 12ថ្ងៃត្រង់\r\nចូលរួមដោយឥតគិតថ្លៃ ដោយផ្ទាល់នៅអគារ ABHC',	NULL,	1,	0,	'2023-06-13 14:50:59',	'2023-06-13 14:51:10'),
(95,	'ASK | គ្គបណ្តុះបណ្តាល ក្លាយជាអ្នកឯកទេសច្នៃពណ៌សក់ - 𝗖𝗼𝗹𝗼𝗿𝗶𝘀𝘁 𝗘𝘅𝗽𝗲𝗿𝘁',	'/photo_2023-06-13_11-09-11-32c906cf-151e-4bc5-ba90-0c90151d64ce.jpg',	'100',	'078/81667721',	'2022-02-09 09:00:00',	'6',	'ជួបគ្នាថ្ងៃស្អែក\r\n✍️ វគ្គបណ្តុះបណ្តាល ក្លាយជាអ្នកឯកទេសច្នៃពណ៌សក់ - 𝗖𝗼𝗹𝗼𝗿𝗶𝘀𝘁 𝗘𝘅𝗽𝗲𝗿𝘁\r\n📅 ថងៃទី 9 កុម្ភៈ 2022 | 9ព្រឹក - 4រសៀល\r\n🧑‍🏫 គរូបង្គោល៖ 𝗢𝗨𝗧𝗛 𝗕𝘂𝗻𝘁𝗵𝗼𝗲𝘂𝗻 𝗦𝘁𝗲𝘃𝗲𝗻𝘀 កំពូលអ្នកច្នៃម៉ូត និងពណ៌សក់ មកពីប្រទេសបារាំង និងជាម្ចាស់ពានរង្វាន់ Hairdressing Award France 2លើក\r\n📍 ទតាំង៖ អគារ អេ ប៊ី អេច ស៊ី\r\nតម្លៃចូលរួម៖ $100 /ម្នាក់ ឬ ទិញផលិតផល $1,000 /ម្នាក់',	2,	1,	0,	'2023-06-13 15:11:04',	'2023-06-13 15:11:04'),
(96,	'ASK | វគ្គបណ្តុះបណ្តាល ការច្នៃម៉ូតសក់លំដាប់អន្តរជាតិ - 𝗔𝘃𝗮𝗻𝘁 𝗚𝗮𝗿𝗱𝗲 𝗘𝘀𝘀𝗲𝗻𝘁𝗶𝗮𝗹',	'/photo_2023-06-13_11-13-45-bc95855f-4bc2-4586-aa86-c5885422a158.jpg',	'100',	'078/81667721',	'2022-02-14 09:00:00',	'6',	'ជួបគ្នានាថ្ងៃច័ន្ទសប្តាហ៍ក្រោយ\r\n✍️ វគ្គបណ្តុះបណ្តាល ការច្នៃម៉ូតសក់លំដាប់អន្តរជាតិ - 𝗔𝘃𝗮𝗻𝘁 𝗚𝗮𝗿𝗱𝗲 𝗘𝘀𝘀𝗲𝗻𝘁𝗶𝗮𝗹 𝗟𝗼𝗼𝗸𝘀\r\n📅 ថងៃទី 14 កុម្ភៈ 2022 | 9ព្រឹក - 4រសៀល\r\n🧑‍🏫 គរូបង្គោល៖ 𝗢𝗨𝗧𝗛 𝗕𝘂𝗻𝘁𝗵𝗼𝗲𝘂𝗻 𝗦𝘁𝗲𝘃𝗲𝗻𝘀 កំពូលអ្នកច្នៃម៉ូត និងពណ៌សក់ មកពីប្រទេសបារាំង និងជាម្ចាស់ពានរង្វាន់ Hairdressing Award France 2លើក\r\n📍 ទតាំង៖ អគារ អេ ប៊ី អេច ស៊ី\r\nតម្លៃចូលរួម៖ $100 /ម្នាក់ ឬ ទិញផលិតផល $1,000 /ម្នាក់',	2,	1,	0,	'2023-06-13 15:15:52',	'2023-06-13 15:15:52'),
(97,	'ASK | វគ្គបណ្តុះបណ្តាល ឧត្តមភាពនៃការកាត់សក់នារី - 𝗧𝗵𝗲 𝗘𝘅𝗰𝗲𝗹𝗹𝗲𝗻𝗰𝗲 𝗪𝗼𝗺𝗲𝗻 𝗖𝘂𝘁',	'/photo_2023-06-13_15-42-50-31416867-8138-4cbb-a4e5-6eb40ac43b66.jpg',	'200',	'078/81667721',	'2022-02-17 09:00:00',	'7',	'ជួបគ្នានាថ្ងៃព្រហស្បតិ៍ និងសុក្រសប្តាហ៍នេះ\r\n✍️ វគ្គបណ្តុះបណ្តាល ឧត្តមភាពនៃការកាត់សក់នារី - 𝗧𝗵𝗲 𝗘𝘅𝗰𝗲𝗹𝗹𝗲𝗻𝗰𝗲 𝗪𝗼𝗺𝗲𝗻 𝗖𝘂𝘁\r\n📅 ថងៃទី 17-18 កុម្ភៈ 2022 | 9ព្រឹក - 4រសៀល\r\n🧑‍🏫 គរូបង្គោល៖ 𝗢𝗨𝗧𝗛 𝗕𝘂𝗻𝘁𝗵𝗼𝗲𝘂𝗻 𝗦𝘁𝗲𝘃𝗲𝗻𝘀 កំពូលអ្នកច្នៃម៉ូត និងពណ៌សក់ មកពីប្រទេសបារាំង និងជាម្ចាស់ពានរង្វាន់ Hairdressing Award France 2លើក\r\n📍 ទតាំង៖ អគារ អេ ប៊ី អេច ស៊ី\r\nតម្លៃចូលរួម៖ $200 /ម្នាក់ ឬ ទិញផលិតផល $2,000 /ម្នាក់',	2,	1,	0,	'2023-06-13 19:44:54',	'2023-06-13 19:44:54'),
(98,	'ASK | វគ្គបណ្តុះបណ្តាល ឧត្តមភាពនៃការកាត់សក់នារី - 𝗧𝗵𝗲 𝗘𝘅𝗰𝗲𝗹𝗹𝗲𝗻𝗰𝗲 𝗪𝗼𝗺𝗲𝗻 𝗖𝘂𝘁',	'/photo_2023-06-17_09-36-30-67b24ff7-b73a-49a1-88cb-b7cb0dd592c4.jpg',	'200',	'078/81667721',	'2022-02-17 09:00:00',	'6',	'ជួបគ្នានាថ្ងៃព្រហស្បតិ៍ និងសុក្រសប្តាហ៍នេះ\r\n✍️ វគ្គបណ្តុះបណ្តាល ឧត្តមភាពនៃការកាត់សក់នារី - 𝗧𝗵𝗲 𝗘𝘅𝗰𝗲𝗹𝗹𝗲𝗻𝗰𝗲 𝗪𝗼𝗺𝗲𝗻 𝗖𝘂𝘁\r\n📅 ថងៃទី 17-18 កុម្ភៈ 2022 | 9ព្រឹក - 4រសៀល\r\n🧑‍🏫 គរូបង្គោល៖ 𝗢𝗨𝗧𝗛 𝗕𝘂𝗻𝘁𝗵𝗼𝗲𝘂𝗻 𝗦𝘁𝗲𝘃𝗲𝗻𝘀 កំពូលអ្នកច្នៃម៉ូត និងពណ៌សក់ មកពីប្រទេសបារាំង និងជាម្ចាស់ពានរង្វាន់ Hairdressing Award France 2លើក\r\n📍 ទតាំង៖ អគារ អេ ប៊ី អេច ស៊ី\r\nតម្លៃចូលរួម៖ $200 /ម្នាក់ ឬ ទិញផលិតផល $2,000 /ម្នាក់',	2,	1,	0,	'2023-06-17 13:38:58',	'2023-06-17 13:38:58'),
(99,	'ASK | វគ្គបណ្តុះបណ្តាល ឧត្តមភាពនៃការកាត់សក់នារី - 𝗧𝗵𝗲 𝗘𝘅𝗰𝗲𝗹𝗹𝗲𝗻𝗰𝗲 𝗪𝗼𝗺𝗲𝗻 𝗖𝘂𝘁',	'/photo_2023-06-17_09-36-30-67b24ff7-b73a-49a1-88cb-b7cb0dd592c4.jpg',	'200',	'078/81667721',	'2022-02-17 09:00:00',	'6',	'ជួបគ្នានាថ្ងៃព្រហស្បតិ៍ និងសុក្រសប្តាហ៍នេះ\r\n✍️ វគ្គបណ្តុះបណ្តាល ឧត្តមភាពនៃការកាត់សក់នារី - 𝗧𝗵𝗲 𝗘𝘅𝗰𝗲𝗹𝗹𝗲𝗻𝗰𝗲 𝗪𝗼𝗺𝗲𝗻 𝗖𝘂𝘁\r\n📅 ថងៃទី 17-18 កុម្ភៈ 2022 | 9ព្រឹក - 4រសៀល\r\n🧑‍🏫 គរូបង្គោល៖ 𝗢𝗨𝗧𝗛 𝗕𝘂𝗻𝘁𝗵𝗼𝗲𝘂𝗻 𝗦𝘁𝗲𝘃𝗲𝗻𝘀 កំពូលអ្នកច្នៃម៉ូត និងពណ៌សក់ មកពីប្រទេសបារាំង និងជាម្ចាស់ពានរង្វាន់ Hairdressing Award France 2លើក\r\n📍 ទតាំង៖ អគារ អេ ប៊ី អេច ស៊ី\r\nតម្លៃចូលរួម៖ $200 /ម្នាក់ ឬ ទិញផលិតផល $2,000 /ម្នាក់',	2,	1,	0,	'2023-06-17 13:38:58',	'2023-06-17 13:38:58'),
(100,	'𝐎𝐩𝐞𝐧𝐃𝐚𝐲 | វិធីព្យាបាលស្បែកបែបបុរាណ',	'/photo_2023-06-17_09-39-16-4d23fa4f-6042-48b9-9dd4-85ed7e5c0f26.jpg',	'00',	'078/81667721',	'2022-02-26 09:00:00',	'3',	'✍️ វគ្គបណ្តុះបណ្តាល 𝐎𝐩𝐞𝐧𝐃𝐚𝐲 | វិធីព្យាបាលស្បែកបែបបុរាណ\r\n📅 ថងៃទី 26 កុម្ភៈ 2022 | 9 - 11ព្រឹក\r\nឥតគិតថ្លៃ\r\nចូលរួមអនឡាញតាម Zoom Meeting',	NULL,	1,	0,	'2023-06-17 13:40:39',	'2023-06-17 13:40:39'),
(101,	'𝐀𝐒𝐊 | ការលាងពណ៏សក់គ្មានដែនកំណត់ - 𝐉𝐔𝐒𝐓 𝐁𝐋𝐄𝐀𝐂𝐇 𝐈𝐓! #𝐒𝐭𝐫𝐨𝐧𝐠𝐁𝐨𝐧𝐝𝐬',	'/photo_2023-06-17_09-41-12-a1e6d963-2a4f-4bfb-98e9-e20870476a9c.jpg',	'100',	'078/81667721',	'2022-03-01 09:00:00',	'12',	'ជួបគ្នាថ្ងៃស្អែកជាមួយអ្នកគ្រូ នីម\r\n\r\n✍️ វគ្គបណ្តុះបណ្តាល 𝐀𝐒𝐊 | ការលាងពណ៏សក់គ្មានដែនកំណត់ - 𝐉𝐔𝐒𝐓 𝐁𝐋𝐄𝐀𝐂𝐇 𝐈𝐓! #𝐒𝐭𝐫𝐨𝐧𝐠𝐁𝐨𝐧𝐝𝐬\r\n📅 ថងៃទី 1-2 មីនា 2022 | 9ព្រឹក - 4រសៀល\r\n👩‍🏫 គរូបង្គោល៖ គីន នីម\r\n📍 ទតាំង៖ អគារ អេ ប៊ី អេច ស៊ី\r\nតម្លៃចូលរួម៖ $100 /ម្នាក់',	NULL,	1,	1,	'2023-06-17 13:42:22',	'2024-01-15 10:30:12'),
(102,	'𝐀𝐒𝐊 | បច្ចេកទេសអ៊ុតសក់រួញសម្រាប់សក់ខូច - 𝐄𝐏𝐈𝐂! 𝐂𝐮𝐫𝐥𝐬 𝐂𝐥𝐢𝐧𝐢𝐱',	'/photo_2023-06-17_09-49-32-02c1521b-d740-43be-a8a0-92d284c82311.jpg',	'100',	'078/81667721',	'2022-03-07 09:00:00',	'12',	'✍️ វគ្គបណ្តុះបណ្តាល 𝐀𝐒𝐊 | បច្ចេកទេសអ៊ុតសក់រួញសម្រាប់សក់ខូច - 𝐄𝐏𝐈𝐂! 𝐂𝐮𝐫𝐥𝐬 𝐂𝐥𝐢𝐧𝐢𝐱\r\n📅 ថងៃទី 7-8 មីនា 2022 | 9ព្រឹក - 4រសៀល\r\n🧑‍🏫 គរូបង្គោល៖ អៀង វណ្ណៈ\r\n📍 ទតាំង៖ អគារ អេ ប៊ី អេច ស៊ី\r\nតម្លៃចូលរួម៖ $100 /ម្នាក់',	1,	1,	0,	'2023-06-17 13:54:15',	'2023-06-17 13:54:15'),
(103,	'𝐎𝐩𝐞𝐧𝐃𝐚𝐲 | តំហែរទំសក់ ជាមួយបច្ចេកវិទ្យាចុងក្រោយ',	'/photo_2023-06-17_09-54-26-4d81f295-10d9-4692-9444-a7ae227e9243.jpg',	'00',	'078/81667721',	'2022-03-05 09:00:00',	'3',	'✍️ វគ្គ 𝐎𝐩𝐞𝐧𝐃𝐚𝐲 | តំហែរទំសក់ ជាមួយបច្ចេកវិទ្យាចុងក្រោយ\r\n📅 ថងៃទី 5 មីនា 2022 | 9 - 11ព្រឹក\r\nចូលរួមដោយឥតគិតថ្លៃ',	7,	1,	0,	'2023-06-17 14:00:44',	'2023-06-17 14:00:44'),
(104,	'𝐀𝐒𝐊 | បច្ចេកទេសកាត់សក់បុរសបែបអូប៉ា (កូរ៉េ) - 𝐆𝐞𝐧𝐭𝐬',	'/photo_2023-06-17_10-05-49-554c4cde-0270-40a9-a5b9-126c0078b7b3.jpg',	'50',	'078/81667721',	'2022-03-14 09:00:00',	'6',	'✍️ វគ្គបណ្តុះបណ្តាល 𝐀𝐒𝐊 | បច្ចេកទេសកាត់សក់បុរសបែបអូប៉ា (កូរ៉េ) - 𝐆𝐞𝐧𝐭𝐬 𝐄𝐱𝐩𝐞𝐫𝐭\r\n📅 ថងៃទី 14 មីនា 2022 | 9ព្រឹក - 4រសៀល\r\n🧑‍🏫 គរូបង្គោល៖ រឿន ភារ៉ា (Bee Bob)\r\n📍 ទតាំង៖ អគារ អេ ប៊ី អេច ស៊ី\r\nតម្លៃចូលរួម៖ $50 /ម្នាក់',	NULL,	1,	0,	'2023-06-17 14:07:52',	'2023-06-17 14:07:52'),
(105,	'𝐎𝐩𝐞𝐧𝐃𝐚𝐲 | វិធីសាស្រ្តការពារស្បែកក្បាល និងសក់ជ្រុះ',	'/photo_2023-06-17_10-15-03-e87d4bfa-79b3-4205-b613-168954ab1576.jpg',	'00',	'078/81667721',	'2022-03-12 09:00:00',	'3',	'✍️ វគ្គ 𝐎𝐩𝐞𝐧𝐃𝐚𝐲 | វិធីសាស្រ្តការពារស្បែកក្បាល និងសក់ជ្រុះ\r\n📅 ថងៃទី 12 មីនា 2022 | 9 - 11ព្រឹក\r\nចូលរួមដោយឥតគិតថ្លៃ',	NULL,	1,	0,	'2023-06-17 14:18:16',	'2023-06-17 14:18:16'),
(106,	'𝐎𝐩𝐞𝐧𝐃𝐚𝐲 | បច្ចេកទេសថែទាំស្បែក តាមបែបធម្មជាតិ',	'/photo_2023-06-17_10-19-13-473bf31a-9e10-4553-9f83-6903ab40b968.jpg',	'00',	'078/81667721',	'2022-03-19 09:00:00',	'3',	'✍️ វគ្គបណ្តុះបណ្តាល 𝐎𝐩𝐞𝐧𝐃𝐚𝐲 | បច្ចេកទេសថែទាំស្បែក តាមបែបធម្មជាតិ\r\n📅 ថងៃទី 19 មីនា 2022 | 9 - 11ព្រឹក\r\nចូលរួមដោយឥតគិតថ្លៃនៅសាលា លីសេ (LICE)',	NULL,	1,	0,	'2023-06-17 14:22:34',	'2023-06-17 14:22:34'),
(107,	'ASK | 𝐖𝐢𝐰𝐚𝐭 𝐊𝐚𝐬𝐞𝐦𝐚𝐦𝐨𝐫𝐧 ដែលជា Artistic Director នៃ Schwarzkopf Professional',	'/photo_2023-06-17_10-26-13-757ce25a-404d-4975-89c2-cd9fdc546aa9.jpg',	'100',	'078/81667721',	'2022-03-23 09:00:00',	'6',	'ថ្ងៃស្អែក ជួបជាមួយលោកគ្រូ 𝐖𝐢𝐰𝐚𝐭 𝐊𝐚𝐬𝐞𝐦𝐚𝐦𝐨𝐫𝐧 ដែលជា Artistic Director នៃ Schwarzkopf Professional\r\n\r\n✍️ វគ្គបណ្តុះបណ្តាល 𝐀𝐒𝐊 | បច្ចេកទេសធ្វើពណ៌សក់បែបហ្វាសិន - 𝐁𝐥𝐞𝐚𝐜𝐡 & 𝐁𝐨𝐥𝐝\r\n📅 ថងៃទី 23-24 មីនា 2022 | 9ព្រឹក - 4រសៀល\r\n📍 ទតាំង៖ អគារ អេ ប៊ី អេច ស៊ី\r\nតម្លៃចូលរួម៖ $100 /ម្នាក់ ឬ ទិញផលិតផល $1,000 /ម្នាក់',	NULL,	1,	0,	'2023-06-17 14:29:36',	'2023-06-17 14:29:36'),
(108,	'ASK | 𝐖𝐢𝐰𝐚𝐭 𝐊𝐚𝐬𝐞𝐦𝐚𝐦𝐨𝐫𝐧 ដែលជា Artistic Director នៃ Schwarzkopf Professional',	'/photo_2023-06-17_10-29-56-e7cc70b5-5b98-4b56-b075-cf222c49aa42.jpg',	'50',	'078/81667721',	'2022-03-25 09:00:00',	'6',	'ថ្ងៃស្អែក ជួបជាមួយលោកគ្រូ 𝐖𝐢𝐰𝐚𝐭 𝐊𝐚𝐬𝐞𝐦𝐚𝐦𝐨𝐫𝐧 ដែលជា Artistic Director នៃ Schwarzkopf Professional\r\n\r\n✍️ វគ្គបណ្តុះបណ្តាល 𝐀𝐒𝐊 | បច្ចេកទេសអ៊ុតសក់ឌីជីថល និងត្រជាក់ - 𝐂𝐨𝐥𝐝 & 𝐇𝐨𝐭 𝐏𝐞𝐫𝐦\r\n📅 ថងៃទី 25 មីនា 2022 | 9ព្រឹក - 4រសៀល\r\n📍 ទតាំង៖ អគារ អេ ប៊ី អេច ស៊ី\r\nតម្លៃចូលរួម៖ $50 /ម្នាក់ ឬ ទិញផលិតផល $500 /ម្នាក់',	NULL,	1,	0,	'2023-06-17 14:31:42',	'2023-06-17 14:31:42'),
(109,	'𝐀𝐒𝐊 | ជំហ៊ានឆ្ពោះទៅកាន់ការធ្វើពណ៍សក់បែបអាជីព - 𝐖𝐨𝐫𝐥𝐝 𝐨𝐟 𝐈𝐆𝐎𝐑𝐀',	'/photo_2023-06-17_10-33-53-1388f976-910c-4123-9bd9-54bd723dc44c.jpg',	'100',	'078/81667721',	'2022-04-04 09:00:00',	'12',	'✍️ វគ្គបណ្តុះបណ្តាល 𝐀𝐒𝐊 | ជំហ៊ានឆ្ពោះទៅកាន់ការធ្វើពណ៍សក់បែបអាជីព - 𝐖𝐨𝐫𝐥𝐝 𝐨𝐟 𝐈𝐆𝐎𝐑𝐀\r\n📅 ថងៃទី 4-5 មេសា 2022 | 9ព្រឹក - 4រសៀល\r\n👩‍🏫 គរូបង្គោល៖ គីន នីម\r\n📍 ទតាំង៖ សាលា លីសេ (LICE)\r\nតម្លៃចូលរួម៖ $100 /ម្នាក់',	7,	1,	0,	'2023-06-17 14:48:46',	'2023-06-17 14:48:46'),
(110,	'𝐎𝐩𝐞𝐧𝐃𝐚𝐲 | កម្ចាត់គ្រាប់ពណ៍នៅសល់',	'/photo_2023-06-17_10-50-57-0ae28438-1bda-4f02-bd92-32226de21021.jpg',	'00',	'078/81667721',	'0000-00-00 00:00:00',	'3',	'✍️ វគ្គបណ្តុះបណ្តាល 𝐎𝐩𝐞𝐧𝐃𝐚𝐲 | កម្ចាត់គ្រាប់ពណ៍នៅសល់  ក្រោយលាងពណ៍សក់\r\n📅 ថ្ងៃទី 2 មេសា 2022 | 9 - 11ព្រឹក\r\nចូលរួមដោយឥតគិតថ្លៃនៅសាលា លីសេ (LICE)',	7,	1,	0,	'2023-06-17 14:53:04',	'2023-06-17 14:53:04'),
(111,	'𝐎𝐩𝐞𝐧𝐃𝐚𝐲 | វិធីថែទាំសក់ដែលមានបញ្ហាបង្កឡើងដោយអ័រមូ៉ន',	'/photo_2023-06-17_10-53-13-d83d6c66-39a2-4a37-9f45-9556e4482118.jpg',	'00',	'078/81667721',	'2022-04-09 09:00:00',	'3',	'✍️ វគ្គបណ្តុះបណ្តាល 𝐎𝐩𝐞𝐧𝐃𝐚𝐲 | វិធីថែទាំសក់ដែលមានបញ្ហាបង្កឡើងដោយអ័រមូ៉ន\r\n📅 ថងៃទី 9 មេសា 2022 | 9 - 11ព្រឹក\r\nចូលរួមដោយឥតគិតថ្លៃនៅសាលា លីសេ (LICE)',	NULL,	1,	0,	'2023-06-17 14:54:28',	'2023-06-17 14:54:28'),
(112,	'𝐒𝐚𝐥𝐨𝐧 𝐌𝐚𝐧𝐚𝐠𝐞𝐦𝐞𝐧𝐭 | ការគ្រប់គ្រង និង អភិវឌ្ឍន៍ធនធានមនុស្ស - 𝐇𝐔𝐌𝐀𝐍 𝐑𝐄𝐒𝐎𝐔𝐑𝐂𝐄𝐒 𝐕𝐬 𝐍𝐄𝐖 𝐃𝐄𝐕𝐄𝐋𝐎𝐏𝐌𝐄𝐍𝐓',	'/photo_2023-06-17_10-54-40-988de025-7c31-46ae-a734-758833455458.jpg',	'1000',	'078/81667721',	'2022-02-05 09:00:00',	'12',	'វគ្គ 𝐒𝐚𝐥𝐨𝐧 𝐌𝐚𝐧𝐚𝐠𝐞𝐦𝐞𝐧𝐭 | ការគ្រប់គ្រង និង អភិវឌ្ឍន៍ធនធានមនុស្ស - 𝐇𝐔𝐌𝐀𝐍 𝐑𝐄𝐒𝐎𝐔𝐑𝐂𝐄𝐒 𝐕𝐬 𝐍𝐄𝐖 𝐃𝐄𝐕𝐄𝐋𝐎𝐏𝐌𝐄𝐍𝐓\r\n📅 ថ្ងៃទី 25-27 មេសា 2022 | 9ព្រឹក - 4រសៀល\r\n🧑‍🏫 គ្រូបង្គោល៖ ឡា វិបុល - នាយកសាលាលីសេ (LICE) បណ្តុះបណ្តាលវិជ្ជាជីវៈផ្នែកសក់ និងសម្ភស្ស\r\n📍 ទីតាំង៖ សាលា លីសេ (LICE)\r\nតម្លៃចូលរួម៖ $1,000 /ម្នាក់ ឬ ទិញផលិតផល $3,000 /ម្នាក់',	4,	1,	0,	'2023-06-17 14:59:45',	'2023-06-17 14:59:45'),
(113,	'𝐎𝐩𝐞𝐧𝐃𝐚𝐲 | ការណែនាំវិធីអ៊ុតសក់ឌីជីថល',	'/photo_2023-06-17_11-02-48-5333d743-10c4-45a9-bd55-63088642d69c.jpg',	'00',	'078/81667721',	'2022-04-23 09:00:00',	'3',	'✍️ វគ្គបណ្តុះបណ្តាល 𝐎𝐩𝐞𝐧𝐃𝐚𝐲 | ការណែនាំវិធីអ៊ុតសក់ឌីជីថល\r\n📅 ថ្ងៃទី 23 មេសា 2022 | 9 - 11ព្រឹក\r\nចូលរួមដោយឥតគិតថ្លៃនៅសាលា លីសេ (LICE)',	NULL,	1,	0,	'2023-06-17 15:05:34',	'2023-06-17 15:05:34'),
(114,	'𝐀𝐒𝐊 | បច្ចេកទេសហាយឡាយសក់បែបហ្វាសិន - 𝐃𝐞𝐟𝐢𝐧𝐢𝐭𝐢𝐯𝐞 𝐁𝐚𝐥𝐚𝐲𝐚𝐠𝐞',	'/photo_2023-06-17_11-05-48-9bdb6741-2836-4e95-b916-5f60ce67ed20.jpg',	'100',	'078/81667721',	'2022-01-02 09:00:00',	'6',	'𝗖ʟᴀ𝘀𝘀 𝗢ᴘᴇɴɴɪɴɢ! ទទួលជំនាញបច្ចេកទេសថ្មី!\r\n\r\n✍️ វគ្គ 𝐀𝐒𝐊 | បច្ចេកទេសហាយឡាយសក់បែបហ្វាសិន - 𝐃𝐞𝐟𝐢𝐧𝐢𝐭𝐢𝐯𝐞 𝐁𝐚𝐥𝐚𝐲𝐚𝐠𝐞\r\n📅 ថ្ងៃទី 2-3 មករា 2022 | 9ព្រឹក - 4រសៀល\r\n👩‍🏫 គ្រូបង្គោល៖ ពុយ\r\n📍 ទីតាំង៖ សាលា លីសេ (LICE)\r\nតម្លៃចូលរួម៖ $100/ម្នាក់ឬ ទិញផលិតផល $1000 /ម្នាក់',	5,	1,	0,	'2023-06-17 15:16:14',	'2023-06-17 15:16:14'),
(115,	'𝐀𝐒𝐊 | បច្ចេកទេសអុ៊តសក់ត្រង់   កម្រិតខ្ពស់ - 𝗘𝗣𝗜𝗖❗️ 𝗦𝘁𝗿𝗮𝗶𝗴𝗵𝘁 𝗖𝗵𝗶𝗻𝗶𝗰',	'/photo_2023-06-17_11-51-28-18969616-b976-4a24-96cf-d9d84306d91f.jpg',	'50',	'078/81667721',	'2022-05-09 09:00:00',	'6',	'𝗖ʟᴀ𝘀𝘀 𝗢ᴘᴇɴɴɪɴɢ! ទទួលជំនាញបច្ចេកទេសថ្មី!\r\n✍️ វគ្គ 𝐀𝐒𝐊 | បច្ចេកទេសអុ៊តសក់ត្រង់   កម្រិតខ្ពស់ - 𝗘𝗣𝗜𝗖❗️ 𝗦𝘁𝗿𝗮𝗶𝗴𝗵𝘁 𝗖𝗵𝗶𝗻𝗶𝗰\r\n📅 ថងៃទី 9 ឧសភា 2022 | 9ព្រឹក - 4រសៀល\r\n👩‍🏫 គរូបង្គោល៖ 𝗦𝗜𝗡𝗞𝗬\r\n📍 ទតាំង៖ សាលា លីសេ (LICE)\r\nតម្លៃចូលរួម៖ $50/ម្នាក់ឬ ទិញផលិតផល $500/ម្នាក់',	6,	1,	0,	'2023-06-17 15:53:59',	'2023-06-17 15:53:59'),
(116,	'𝐎𝐩𝐞𝐧𝐃𝐚𝐲 | ការថែរក្សាសក់ពណ៍ឲ្យជាប់បានយូរ  និងការសន្សំសំចៃ',	'/photo_2023-06-17_11-54-27-42445a0a-74e5-4949-82e4-ea9570a28f3d.jpg',	'00',	'078/81667721',	'2022-05-07 09:00:00',	'3',	'✍️ វគ្គបណ្តុះបណ្តាល 𝐎𝐩𝐞𝐧𝐃𝐚𝐲 | ការថែរក្សាសក់ពណ៍ឲ្យជាប់បានយូរ  និងការសន្សំសំចៃ\r\n📅 ថ្ងៃទី 7 ឧសភា 2022 | 9 - 11ព្រឹក\r\n👩‍🏫 គ្រូបង្គោល៖ គីន នីម\r\nចូលរួមដោយឥតគិតថ្លៃនៅសាលា លីសេ (LICE)',	7,	1,	0,	'2023-06-17 16:05:08',	'2023-06-17 16:05:08'),
(117,	'𝐀𝐒𝐊 | បច្ចេកទេសច្នៃពណ៍សក់បែបច្នៃប្រឌិត - 𝐂𝐫𝐞𝐚𝐭𝐢𝐯𝐞 𝐂𝐨𝐥𝐨𝐫',	'/photo_2023-06-17_13-22-33-835bdbb3-b560-4acf-9eab-be01ca3bc0c8.jpg',	'100',	'078/81667721',	'2022-05-16 09:00:00',	'6',	'𝗖ʟᴀ𝘀𝘀 𝗢ᴘᴇɴɴɪɴɢ! ទទួលជំនាញបច្ចេកទេសថ្មី!\r\n\r\n✍️ វគ្គ 𝐀𝐒𝐊 | បច្ចេកទេសច្នៃពណ៍សក់បែបច្នៃប្រឌិត - 𝐂𝐫𝐞𝐚𝐭𝐢𝐯𝐞 𝐂𝐨𝐥𝐨𝐫\r\n📅 ថងៃទី 16-17 ឧសភា 2022 | 9ព្រឹក - 4រសៀល\r\n👩‍🏫 គ្រូបង្គោល៖ 𝐄𝐚𝐧𝐠 𝐕𝐚𝐧𝐧𝐚𝐤\r\n📍 ទីតាំង៖ សាលា លីសេ (LICE)\r\nតម្លៃចូលរួម៖ $100/ម្នាក់ឬ ទិញផលិតផល $1000/ម្នាក់',	1,	1,	0,	'2023-06-17 17:24:36',	'2023-06-17 17:24:36'),
(118,	'𝐀𝐒𝐊 | បច្ចេកទេសអុ៊តសក់រួញ  បែបកូរ៉េ-ជបុ៉ន - 𝐄𝐏𝐈𝐂❗️ 𝐂𝐮𝐫𝐥𝐬 𝐂𝐥𝐢𝐧𝐢𝐜',	'/photo_2023-06-17_13-36-58-96bda12a-35f0-490f-a980-bf4ddad25e3e.jpg',	'100',	'078/81667721',	'2022-05-23 09:00:00',	'12',	'𝗖ʟᴀ𝘀𝘀 𝗢ᴘᴇɴɴɪɴɢ! ទទួលជំនាញបច្ចេកទេសថ្មី!\r\n✍️ វគ្គ 𝐀𝐒𝐊 | បច្ចេកទេសអុ៊តសក់រួញ  បែបកូរ៉េ-ជបុ៉ន - 𝐄𝐏𝐈𝐂❗️ 𝐂𝐮𝐫𝐥𝐬 𝐂𝐥𝐢𝐧𝐢𝐜\r\n📅 ថ្ងៃទី 23-24 ឧសភា 2022 | 9ព្រឹក - 4រសៀល\r\n👩‍🏫 គ្រូបង្គោល៖ គីន នីម\r\n📍 ទីតាំង៖ សាលា លីសេ (LICE)\r\nតម្លៃចូលរួម៖ $100/ម្នាក់ឬ ទិញផលិតផល $1000/ម្នាក់',	NULL,	2,	0,	'2023-06-17 17:50:23',	'2023-06-17 17:56:22'),
(119,	'𝐀𝐒𝐊 | មូលដ្ឋានគ្រឹះនៃឯកទេសកាត់សក់នារី - 𝑬𝒔𝒔𝒆𝒏𝒕𝒊𝒂𝒍 𝑺𝒌𝒊𝒍𝒍𝒔 𝑪𝒖𝒕𝒕𝒊𝒏𝒈',	'/photo_2023-06-17_13-56-25-25e92a82-5458-4957-917b-795d69e63bf9.jpg',	'100',	'078/81667721',	'2022-05-30 09:00:00',	'12',	'𝗖ʟᴀ𝘀𝘀 𝗢ᴘᴇɴɴɪɴɢ! ទទួលជំនាញបច្ចេកទេសថ្មី!\r\n✍️ វគ្គ 𝐀𝐒𝐊 | មូលដ្ឋានគ្រឹះនៃឯកទេសកាត់សក់នារី - 𝑬𝒔𝒔𝒆𝒏𝒕𝒊𝒂𝒍 𝑺𝒌𝒊𝒍𝒍𝒔 𝑪𝒖𝒕𝒕𝒊𝒏𝒈\r\n📅 ថងៃទី 30-31 ឧសភា 2022 | 9ព្រឹក - 4រសៀល\r\n🧑‍🏫 គ្រូបង្គោល៖ ចាន់ទិព្ធ នាគ\r\n📍 ទីតាំង៖ សាលា លីសេ (LICE)\r\nតម្លៃចូលរួម៖ $100/ម្នាក់ឬ ទិញផលិតផល $1000/ម្នាក់',	NULL,	1,	0,	'2023-06-17 17:58:53',	'2023-06-17 17:58:53'),
(120,	'𝐎𝐩𝐞𝐧𝐃𝐚𝐲 | របៀបធ្វើឲ្យសក់ភ្លឺរលោង   និងជាប់ភ្លឺលើស   8 ម៉ោង',	'/photo_2023-06-17_14-14-22-549ac2ae-d336-4425-98e8-416a9ae3260f.jpg',	'00',	'078/81667721',	'2022-05-28 09:00:00',	'3',	'✍️ វគ្គបណ្តុះបណ្តាល 𝐎𝐩𝐞𝐧𝐃𝐚𝐲 | របៀបធ្វើឲ្យសក់ភ្លឺរលោង   និងជាប់ភ្លឺលើស   8 ម៉ោង\r\n📅 ថ្ងៃទី 28 ឧសភា 2022 | 9 - 11ព្រឹក\r\nចូលរួមដោយឥតគិតថ្លៃនៅសាលា លីសេ (LICE)',	7,	1,	0,	'2023-06-17 18:18:12',	'2023-06-17 18:18:12'),
(121,	'Gʟᴏʙᴀʟ Cᴏᴜʀsᴇ | បច្ចេកទេសហាយឡាយ  និង ចាប់មូ៉តសក់ - 𝐇𝐈𝐋𝐈𝐆𝐇𝐓 𝐂𝐎𝐌𝐁𝐈𝐍𝐀𝐓𝐈𝐎𝐍 & 𝐋𝐎𝐍𝐆 𝐇𝐀𝐈𝐑  𝐂𝐇𝐀𝐋𝐋𝐄𝐍𝐆𝐄 𝐁𝐘 𝐎𝐒𝐢𝐒',	'/photo_2023-06-17_14-20-59-96fa7838-8a12-4e6b-8f4b-2f6380d3c91f.jpg',	'100',	'078/81667721',	'2022-06-09 09:00:00',	'6',	'វគ្គ Gʟᴏʙᴀʟ Cᴏᴜʀsᴇ បានមកដល់ហើយ ទទួលបានចំណេះដឹងថ្មី ជាមួយការសិក្សាដែលទទួលស្គាល់កម្រិតអន្តរជាតិ\r\n✍️ វគ្គ Gʟᴏʙᴀʟ Cᴏᴜʀsᴇ | បច្ចេកទេសហាយឡាយ  និង ចាប់មូ៉តសក់ - 𝐇𝐈𝐋𝐈𝐆𝐇𝐓 𝐂𝐎𝐌𝐁𝐈𝐍𝐀𝐓𝐈𝐎𝐍 & 𝐋𝐎𝐍𝐆 𝐇𝐀𝐈𝐑  𝐂𝐇𝐀𝐋𝐋𝐄𝐍𝐆𝐄 𝐁𝐘 𝐎𝐒𝐢𝐒\r\n📅 ថ្ងៃទី 9-10 មិថុនា 2022 | 9ព្រឹក - 4រសៀល\r\n🧑‍🏫 គ្រូបង្គោល៖ 𝐖𝐈𝐖𝐀𝐓 𝐊𝐀𝐒𝐄𝐌𝐀𝐌𝐎𝐑𝐍\r\n📍 ទីតាំង៖ សាលា លីសេ (LICE)\r\n\r\nតម្លៃចូលរួម៖ $100/ម្នាក់ឬ ទិញផលិតផល $1000/ម្នាក់',	3,	1,	0,	'2023-06-17 18:23:59',	'2023-06-17 18:23:59'),
(122,	'𝐀𝐒𝐊 | ការលាងពណ៌សក់ដល់កម្រិតអតិបរមា - 𝐉𝐔𝐒𝐓 𝐁𝐋𝐄𝐀𝐂𝐇 𝐈𝐓! #𝐒𝐭𝐫𝐨𝐧𝐠𝐁𝐨𝐧𝐝𝐬',	'/photo_2023-06-17_14-32-31-7e6b4441-b221-4a74-a9ec-80e2cec6d85a.jpg',	'100',	'078/81667721',	'2022-06-20 09:00:00',	'12',	'ចាប់បើកវគ្គសិក្សាថ្មី! 🤩\r\nទទួលជំនាញបច្ចេកទេសថ្មី!💥\r\n✍️ វគ្គ 𝐀𝐒𝐊 | ការលាងពណ៌សក់ដល់កម្រិតអតិបរមា - 𝐉𝐔𝐒𝐓 𝐁𝐋𝐄𝐀𝐂𝐇 𝐈𝐓! #𝐒𝐭𝐫𝐨𝐧𝐠𝐁𝐨𝐧𝐝𝐬\r\n📅 ថ្ងៃទី 20-21 មិថុនា 2022 | 9ព្រឹក - 4រសៀល\r\n👩‍🏫គ្រូបង្គោល៖ គីន នីម\r\n📍 ទីតាំង៖ សាលា លីសេ (LICE)\r\nតម្លៃចូលរួម៖ $100/ម្នាក់ឬ ទិញផលិតផល $1,000/ម្នាក់',	7,	1,	0,	'2023-06-17 18:34:35',	'2023-06-17 18:34:35'),
(123,	'𝐌𝐚𝐧𝐚𝐠𝐞𝐦𝐞𝐧𝐭 | ទំនាក់ទំនង និង ការគ្រប់គ្រងពេលវេលាប្រកបដោយប្រសិទ្ធភាពខ្ពស់ - 𝐄𝐅𝐅𝐄𝐂𝐓𝐈𝐕𝐄 𝐂𝐎𝐌𝐌𝐔𝐍𝐈𝐂𝐀𝐓𝐈𝐎𝐍 & 𝐓𝐈𝐌𝐄   𝐌𝐀𝐍𝐀𝐆𝐄𝐌𝐄𝐍𝐓',	'/photo_2023-06-17_14-35-52-8913e2f0-935f-4a48-87da-3b3be6667fc2.jpg',	'1000',	'078/81667721',	'2022-07-04 09:00:00',	'12',	'💥ឱកាសសិក្សាពិសេសនៅដើមខែបានមកដល់ហើយសម្រាប់បងប្អូនទាំងអស់គ្នា⚡️\r\n✍️ វគ្គ 𝐒𝐚𝐥𝐨𝐧 𝐌𝐚𝐧𝐚𝐠𝐞𝐦𝐞𝐧𝐭 | ទំនាក់ទំនង និង ការគ្រប់គ្រងពេលវេលាប្រកបដោយប្រសិទ្ធភាពខ្ពស់ - 𝐄𝐅𝐅𝐄𝐂𝐓𝐈𝐕𝐄 𝐂𝐎𝐌𝐌𝐔𝐍𝐈𝐂𝐀𝐓𝐈𝐎𝐍 & 𝐓𝐈𝐌𝐄   𝐌𝐀𝐍𝐀𝐆𝐄𝐌𝐄𝐍𝐓\r\n📅ថ្ងៃទី 4-6 កក្កដា 2022 | 9ព្រឹក - 4រសៀល\r\n🧑‍🏫 គ្រូបង្គោល៖ ឡា វិបុល - នាយកសាលាលីសេ (LICE) បណ្តុះបណ្តាលវិជ្ជាជីវៈផ្នែកសក់ និងសម្ភស្ស\r\n📍 ទីតាំង៖ សាលា លីសេ (LICE)\r\nតម្លៃចូលរួម៖ $1,000 /ម្នាក់ ឬ ទិញផលិតផល $3,000 /ម្នាក់',	4,	1,	0,	'2023-06-17 18:42:18',	'2023-06-17 18:42:18'),
(124,	'𝐀𝐒𝐊 | បច្ចេកទេសហាយឡាយសក់បែបហ្វាសិន - 𝘿𝙚𝙛𝙞𝙣𝙞𝙩𝙞𝙫𝙚 𝘽𝙖𝙡𝙖𝙮𝙖𝙜𝙚',	'/photo_2023-06-17_14-44-00-6c31f3ce-4e27-4dcc-b5dd-496e2e2f5545.jpg',	'100',	'078/81667721',	'2022-07-18 09:00:00',	'12',	'⚡️ឳកាសពិសេស \r\nសម្រាប់បងប្អូនដែលមានបំណងចង់ រៀនបន្ថែមនិងអ្នកមិនទាន់ចេះសោះ ចាប់បើកវគ្គសិក្សាថ្មី! ទទួលជំនាញបច្ចេកទេសថ្មី!💥\r\n\r\n✍️ វគ្គ 𝐀𝐒𝐊 | បច្ចេកទេសហាយឡាយសក់បែបហ្វាសិន - 𝘿𝙚𝙛𝙞𝙣𝙞𝙩𝙞𝙫𝙚 𝘽𝙖𝙡𝙖𝙮𝙖𝙜𝙚\r\n📅 ថ្ងៃទី  18-19 កក្កដា 2022 | 9ព្រឹក - 4រសៀល\r\n👩‍🏫គ្រូបង្គោល៖ គីន នីម\r\n📍 ទីតាំង៖ សាលា លីសេ (LICE)\r\nតម្លៃចូលរួម៖ $100/ម្នាក់ឬ ទិញផលិតផល$1,000/ម្នាក់\r\n\r\nចុះឈ្មោះឥឡូវនេះ៖\r\n📞 078 | 081 66 77 21 (វគ្គបណ្តុះបណ្តាល)\r\n📞 078 | 098 30 11 19 (ផលិតផល)\r\n🌐 គេហទំព័រ www.abhc.asia\r\nℹ️ តេឡេក្រាម https://t.me/LICEAcademy\r\n📍 ទីតាំង៖ សាលា លីសេ (LICE)\r\nhttps://goo.gl/maps/64WVXBFQ7jsZdnB37\r\n\r\n\"ភាពជោគជ័យរបស់សាឡនលោកអ្នក គឺជាភាពជោគជ័យរបស់ពួកយើង\"\r\n------------',	7,	1,	0,	'2023-06-17 18:46:10',	'2023-06-17 18:46:10'),
(125,	'𝐎𝐩𝐞𝐧𝐃𝐚𝐲 | តំហែទាំសក់នៅផ្ទះ ដល់កម្រិតអតិប្បរមា',	'/photo_2023-06-19_08-47-24-46cbc359-60b6-42c0-b20c-07e974bddc12.jpg',	'00',	'078/81667721',	'2022-07-30 09:00:00',	'3',	'ុងសប្ដាហ៍ទំនេរ អាចអញ្ញើញមកក្រេបយក ចំណេះដឹង💡បន្ថែមពីសាលាលីសេ ដោយឥតគិតថ្លៃ😍\r\n✍️ វគ្គបណ្តុះបណ្តាល 𝐎𝐩𝐞𝐧𝐃𝐚𝐲 | តំហែទាំសក់នៅផ្ទះ ដល់កម្រិតអតិប្បរមា\r\n📅 ថងៃទី ៣០  កក្កដា 2022 | 9 - 11ព្រឹក\r\nចូលរួមដោយឥតគិតថ្លៃនៅសាលា លីសេ (LICE)\r\n\r\nចុះឈ្មោះឥឡូវនេះ៖\r\n📞 078 | 081 66 77 21 (វគ្គបណ្តុះបណ្តាល)\r\n📞 078 | 098 30 11 19 (ផលិតផល)\r\n🌐 គេហទំព័រ www.abhc.asia\r\nℹ️ តេឡេក្រាម https://t.me/LICEAcademy\r\n📍 ផទះលេខC65-C66 (កែងតារាងវាយកូនហ្គោលបឹងកក់ចាស់)\r\n https://goo.gl/maps/64WVXBFQ7jsZdnB37\r\n\r\n\"ភាពជោគជ័យរបស់សាឡនលោកអ្នក គឺជាភាពជោគជ័យរបស់ពួកយើង\"\r\n------------',	NULL,	1,	0,	'2023-06-19 12:48:29',	'2023-06-19 12:48:29'),
(126,	'Gʟᴏʙᴀʟ Cᴏᴜʀsᴇ   ជាមួយនឹងការទទួលបានចំណេះដឹង និងជំនាញថ្មីៗដែលទទួលស្គាល់ដោយកម្រិតអន្តរជាតិ បង្រៀនដោយគ្រូបង្គោល៖ 𝐖𝐈𝐖𝐀𝐓 𝐊𝐀𝐒𝐄𝐌𝐀𝐌𝐎𝐑𝐍✨',	'/photo_2023-06-19_08-49-04-b42adb89-d7b6-49cb-a525-0f9c8adb4464.jpg',	'100',	'078/81667721',	'2022-08-16 09:00:00',	'12',	'💥វគ្គបណ្តុះបណ្តាលថ្មី ដែលបងប្អូនទន្ទឹងរង់ចាំ បានមកដល់ហើយ Gʟᴏʙᴀʟ Cᴏᴜʀsᴇ  \r\nជាមួយនឹងការទទួលបានចំណេះដឹង និងជំនាញថ្មីៗដែលទទួលស្គាល់ដោយកម្រិតអន្តរជាតិ បង្រៀនដោយគ្រូបង្គោល៖ 𝐖𝐈𝐖𝐀𝐓 𝐊𝐀𝐒𝐄𝐌𝐀𝐌𝐎𝐑𝐍✨\r\n\r\nជាមួយនឹងវគ្គ Gʟᴏʙᴀʟ Cᴏᴜʀsᴇ | ការបង្កើតទស្សនៈវិស័យអំពីការច្នៃពណ៌នេះ បងប្អូននឹងទទួលបាន៖\r\n-ទទួលវិញ្ញាបនបត្រ  ក្រោយបញ្ជប់វគ្គបណ្ដុះបណ្ដាល\r\n-ការលាយថ្នាំប្រភេទផ្សេងគ្នា\r\n-ការលាយថ្នាំពណ៌សក់ដោយការច្នៃប្រឌិតរបស់ជាង\r\n-ការប្រើប្រាស់ថ្នាំពណ៌ដែលមានក្នុងស្ដុកឲ្យត្រូវតាម\r\nតម្រូវការ   របស់អតិថិជន\r\n-យល់ដឹងអំពីអតិថិជន\r\n-យល់អំពីពណ៌ច្បាស់លាស់\r\n-បង្កើតពណ៌សក់តាមចរិតលក្ខណៈរបស់អតិថិជន។\r\n\r\n🎁កាន់តែពិសេសបងប្អូននឹងទទួលបានការបញ្ចុះតម្លៃមិនគួរអោយជឿ តម្លៃសិក្សា$̶2̶5̶0̶/̶ម្នាក់ មកសល់ត្រឹមតែ $100/ម្នាក់ ឬ ទិញផលិតផល $1,000/ម្នាក់🤩\r\n\r\nចាប់ផ្តើមពង្រឹងជំនាញសាឡនរបស់លោកអ្នកតាមរយៈ៖\r\n📞 078 | 081 66 77 21 (វគ្គបណ្តុះបណ្តាល)\r\n📞 078 | 098 30 11 19 (ផលិតផល)',	3,	1,	0,	'2023-06-19 12:50:28',	'2023-06-19 12:50:28'),
(127,	'Gʟᴏʙᴀʟ Cᴏᴜʀsᴇ  នៅថ្ងៃទី 18-19 ខែ សីហា ឆ្នាំ 2022។',	'/photo_2023-06-19_08-50-52-9396eca1-0f98-4049-aa1b-24afb49c8716.jpg',	'100',	'078/81667721',	'2022-08-18 09:00:00',	'12',	'💥កាន់តែពិសេស បន្ថែមពីលើវគ្គបណ្តុះបណ្តាល  \"ការបង្កើតទស្សនៈវិស័យអំពីការច្នៃពណ៌សក់\"\r\nសាលាលីសេ ក៏បានបន្ថែមវគ្គថ្មីមួយទៀត \"លើបច្ចេកទេសអុ៊តសក់រួញរបស់កូរ៉េ និងឯកទេសព្យាបាលសរសៃសក់\"។\r\n\r\n👉ជួបជាមួយគ្រូបង្គោល៖ 𝐖𝐈𝐖𝐀𝐓 𝐊𝐀𝐒𝐄𝐌𝐀𝐌𝐎𝐑𝐍✨  ទទួលបានចំណេះដឹង និងជំនាញថ្មីៗកាន់តែច្រើន ក្នុងវគ្គGʟᴏʙᴀʟ Cᴏᴜʀsᴇ  នៅថ្ងៃទី 18-19 ខែ សីហា ឆ្នាំ 2022។\r\n\r\n🎁កាន់តែពិសេសបងប្អូននឹងទទួលបានការបញ្ចុះតម្លៃមិនគួរអោយជឿ តម្លៃសិក្សា $̶2̶5̶0̶ម្នាក់ មកសល់ត្រឹមតែ $100/ម្នាក់ ឬ ទិញផលិតផល $1,000/ម្នាក់🤩',	NULL,	1,	0,	'2023-06-19 12:52:36',	'2023-06-19 12:52:36'),
(128,	'𝐎𝐩𝐞𝐧𝐃𝐚𝐲 | ការថែទាំសារធាតុ KERATIN បន្ទាប់ពីអ៊ុតសក់រួច',	'/photo_2023-06-19_08-54-45-60d08db3-b4e7-406e-aa0e-78da05c28f8c.jpg',	'00',	NULL,	'2022-09-10 09:00:00',	'3',	'ជាងសក់ទាំងអស់គ្នាអាចក្លាយជា \"អ្នកប្រឹក្សាផ្នែកសក់ដ៏អស្ចារ្យ\" លើការថែទាំសក់សម្រាប់អតិថិជនដែលបានអ៊ុតសក់រួញ។ ចូលរួម\r\n✍️ វគ្គបណ្តុះបណ្តាល 𝐎𝐩𝐞𝐧𝐃𝐚𝐲 | ការថែទាំសារធាតុ KERATIN បន្ទាប់ពីអ៊ុតសក់រួច\r\n📅 ថ្ងៃទី 10 កញ្ញា 2022 | 9 - 11ព្រឹក\r\n\r\n💡អត្ថប្រយោជន៍ក្រោយបញ្ចាប់វគ្គ៖\r\n-បងប្អូនអាចស្គាល់ពីផលិតផលថែរក្សាសក់\r\n-ចេះប្រើប្រាស់ប្រភេទ Styling បន្ទាប់ពីអ៊ុតសក់រួច\r\n-ស្គាល់ពីបច្ចេកទេសចាប់ម៉ូតូសក់\r\n\r\n📝បញ្ជាក់៖ បើកឱកាសសម្រាប់សិស្សទូទៅអាចចូលរៀនបាន  ចូលរួមដោយឥតគិតថ្លៃនៅសាលាលីសេ',	NULL,	1,	0,	'2023-06-19 12:55:58',	'2023-06-19 12:55:58'),
(129,	'𝐀𝐒𝐊 Academy | 𝗗𝗲𝗳𝗶𝗻𝗶𝘁𝗶𝘃𝗲 𝗕𝗮𝗹𝗮𝘆𝗮𝗴𝗲',	'/photo_2023-06-19_08-59-48-a984f02e-1593-48d1-8e94-c76b2e5fd04c.jpg',	'100',	'078/81667721',	'2022-11-01 09:00:00',	'3',	'រៀន   រៀន រៀន !!! បងប្អូនធ្លាប់តែលឺពាក្យថា 𝗕𝗮𝗹𝗮𝘆𝗮𝗴𝗲 មែនរឺទេ? ប៉ុន្ដែមិនដែរបានសិក្សាស្វែងយល់  និងអនុវត្ដទាល់តែសោះ🙇‍♂️\r\nតោះ❗️អញ្ច្ចឹងនៅចាំអីទៀត មកសិក្សានៅសាលាលីសេ (LICE) ទាំងអស់គ្នា\r\n👉ពេលនេះសាលាបានបេីកវគ្គសិក្សារយៈពេលខ្ចីគឺ 𝐀𝐒𝐊 Academy | 𝗗𝗲𝗳𝗶𝗻𝗶𝘁𝗶𝘃𝗲 𝗕𝗮𝗹𝗮𝘆𝗮𝗴𝗲 \r\n\r\n💡អត្ថប្រយោជន៍ក្រោយបញ្ចប់វគ្គ៖\r\n- ទទួលវិញ្ញាបនបត្រ ក្រោយបញ្ចប់វគ្គបណ្ដុះបណ្ដាល\r\n- ចេះលាបបែបស្រមោលប្រដេញបែបធម្មជាតិ\r\n- យល់អំពីតិចនិចការលាប Balayage \r\n- ការប្រើផលិតផលក្នុងការលាប Balayage \r\n\r\n📝បញ្ជាក់វគ្គសិក្សានេះសម្រាប់បងប្អូនដែល៖\r\n- ធ្លាប់ជា ជាងពីមុនមក ចេះលាបសក់ហើយ\r\n\r\n 📅 ពេលវេលាសិក្សានៅថ្ងៃទី 1-2 វិច្ឆិកា 2022 | 9 - 4រសៀល\r\nតម្លៃចូលរួមៈ $100 /ម្នាក់ ឫ ទិញផលិតផល $1,000 /ម្នាក់\r\n📩សម្រាប់បងប្អូនដែលមានចំណាប់អារម្មណ៍ ចង់ចុះឈ្មោះចូលរៀនជាមួយយើងឥឡូវនេះ អាចទំនាក់ទំនងមកកាន់៖\r\n📞 078 | 081 66 77 21 (វគ្គបណ្តុះបណ្តាល)\r\n📞 078 | 098 30 11 19 (ផលិតផល)\r\n\r\n\"ភាពជោគជ័យរបស់សាឡនលោកអ្នក គឺជាភាពជោគជ័យរបស់ពួកយើង\"\r\n------------',	NULL,	1,	0,	'2023-06-19 13:01:39',	'2023-06-19 13:01:39'),
(130,	'𝐒𝐚𝐥𝐨𝐧 𝐌𝐚𝐧𝐚𝐠𝐞𝐦𝐞𝐧𝐭  | ការពង្រីកអាជីវកម្ម និងឥទ្ធិពលក្នុងសង្គម - BUSINESS EXPANSION & SOCIAL IMPACT',	'/photo_2023-06-19_09-01-50-a1845c3b-5ca5-44d1-b2ac-14217bd356ef.jpg',	'1000',	'078/81667721',	'2022-11-14 09:00:00',	'6',	'្នុងនាមជាម្ចាស់អាជីវកម្មសាឡនមួយរូប👩🏻‍💼🧑🏻‍💼\r\nពិតជាចង់ឲ្យអាជីវកម្មរបស់លោកអ្នកមានការលូតលាស់ជានិច្ច មិនថាបុគ្គលិក ឬការដំណើរការរបស់អាជីវកម្ម តែឥទ្ធិពលក្នុងសង្គមមួយចំនួនបានធ្វើអោយអាជីវកម្មរបស់លោកអ្នក ប្រឈមមុខបញ្ហា 😨😨\r\n\r\n💡ដើម្បីជាស្មារតី និងជាជំនួយដល់បងប្អូនម្ចាស់អាជីវកម្មយើងក្នុងការរកដំណោះស្រាយបែបណា ឲ្យស្របតាមបរិបទសង្គម ក៏ដូចជាពង្រីកអាជីវកម្មរបស់លោកអ្នក។\r\n\r\nពេលនេះ សាលាលីសេបានបើកវគ្គពិសេសគឺ 𝐒𝐚𝐥𝐨𝐧 𝐌𝐚𝐧𝐚𝐠𝐞𝐦𝐞𝐧𝐭 \r\n| ការពង្រីកអាជីវកម្ម និងឥទ្ធិពលក្នុងសង្គម - BUSINESS EXPANSION & SOCIAL IMPACT\r\n\r\n📅 ថងៃទី 14-16 វិច្ឆិកា 2022 | 9ព្រឹក - 4រសៀល\r\n🧑‍🏫 គរូបង្គោល៖ ឡា វិបុល - នាកយកសាលាលីសេ (LICE) បណ្តុះបណ្តាលវិជ្ជាជីវៈផ្នែកសក់ និងសម្ភស្ស\r\n📍 ទតាំង៖ សាលា លីសេ (LICE)\r\n\r\n📩សម្រាប់បងប្អូនដែលមានចំណាប់អារម្មណ៍ ចង់ចុះឈ្មោះចូលរៀនជាមួយយើងឥឡូវនេះ អាចទំនាក់ទំនងមកកាន់៖\r\n📞 078 | 081 66 77 21 (វគ្គបណ្តុះបណ្តាល)\r\n📞 078 | 098 30 11 19 (ផលិតផល)\r\n\r\n\"ភាពជោគជ័យរបស់សាឡនលោកអ្នក គឺជាភាពជោគជ័យរបស់ពួកយើង\"\r\n------------',	4,	1,	0,	'2023-06-19 13:11:07',	'2023-06-19 13:11:07'),
(131,	'𝐀𝐒𝐊 Academy | ពិភពនែការកាត់សក់រះវែងបែបលឿន - World of Quick Long Layer Cut',	'/photo_2023-06-19_09-12-01-52d3f61d-ce14-4a25-b217-9bc93c1de4fa.jpg',	'50',	'078/81667721',	'2022-11-21 09:00:00',	'6',	'កាន់តែរៀន  កាន់តែរីកចម្រើន!!!  បងប្អូនមានដឹងការកាត់សក់លឿនរហ័ស ត្រូវតាមស្ដង់ដាបច្ចេកទេស គេត្រូវធ្វើបែបណា?  \r\n🙇‍♂️🙇‍♂️\r\nចង់ដឹងណាស់មែនទេ💡\r\nតោះ❗️អច្ចឹងនៅចាំអីទៀត មកសិក្សានៅសាលាលីសេ (LICE) ទាំងអស់គ្នា\r\n👉ពេលនេះសាលាបានបេីកវគ្គសិក្សារយៈពេលខ្ចីគឺ 𝐀𝐒𝐊 Academy | ពិភពនែការកាត់សក់រះវែងបែបលឿន - World of Quick Long Layer Cut\r\n\r\n📝បញ្ជាក់វគ្គសិក្សានេះសម្រាប់បងប្អូនដែល៖\r\n- ចេះប្រើកន្រ្តៃកាត់សក់\r\n- មានបទពិសោធន៍ជាជាង',	7,	1,	0,	'2023-06-19 13:12:57',	'2023-06-19 13:12:57'),
(132,	'𝐀𝐒𝐊 | កម្រិតពិសេស នៃការកាត់សក់បុរស និងចាប់ម៉ូតបែបទំនើប- 𝗘𝗽𝗶𝗰! 𝗘𝘀𝘀𝗲𝗻𝘁𝗶𝗮𝗹 𝗖𝘂𝘁𝘁𝗶𝗻𝗴 𝗮𝗻𝗱 𝗦𝘁𝘆𝗹𝗶𝗻𝗴',	'/photo_2023-06-19_09-15-30-c6feb437-f619-4ce9-9d09-4035cdc7d949.jpg',	'100',	'078/81667721',	'2023-01-25 09:00:00',	'6',	'វគ្គបណ្ដុះបណ្ដាលថ្មី នៃគន្លឹះក្នុងការកាត់សក់បុរស និងបច្ចេកទេសចាប់ម៉ូតសក់បែបឆ្នាំ2023💇💇\r\n✍️វគ្គ 𝐀𝐒𝐊 | កម្រិតពិសេស នៃការកាត់សក់បុរស និងចាប់ម៉ូតបែបទំនើប- 𝗘𝗽𝗶𝗰! 𝗘𝘀𝘀𝗲𝗻𝘁𝗶𝗮𝗹 𝗖𝘂𝘁𝘁𝗶𝗻𝗴 𝗮𝗻𝗱 𝗦𝘁𝘆𝗹𝗶𝗻𝗴\r\n📅 ថ្ងៃទី 25-26 មករា 2023 | 9ព្រឹក - 4រសៀល\r\n👩‍🏫អ្នកគ្រូបង្គោល៖ ថេត ស្រីពៅ\r\n📍 ទីតាំង៖ អគារសាលា លីសេ (LICE)\r\n📈 វិនិយោគសិក្សា៖ $100/ម្នាក់\r\n\r\n\"វឌ្ឍនភាពនៃការងារគឺ  ការអប់រំ\"',	10,	1,	0,	'2023-06-19 13:17:14',	'2023-06-19 13:17:14'),
(133,	'𝐀𝐒𝐊 | កម្រិតពិសេស នៃការលាបពណ៌ និងចាប់ម៉ូតបែបទំនើប- 𝗘𝗽𝗶𝗰❗️ 𝗘𝘀𝘀𝗲𝗻𝘁𝗶𝗮𝗹 𝗖𝗼𝗹𝗼𝗿 𝗮𝗻𝗱 𝗦𝘁𝘆𝗹𝗶𝗻𝗴',	'/photo_2023-06-19_09-18-43-c185624e-0da1-46d2-be5e-2824c042ec07.jpg',	'100',	'078/81667721',	'2023-12-08 09:00:00',	'12',	'ត្រឡប់មកវិញជាមួយ វគ្គបណ្ដុះបណ្ដាលថ្មីទៀតហើយ សម្រាប់បងប្អូនមានបំណងចង់សិក្សាអំពីបច្ចេកទេសនៃការលាបពណ៌ត្រូវតាមស្ដង់ដាអន្ដរជាតិ🎨🎨🎨\r\n✍️វគ្គ 𝐀𝐒𝐊 | កម្រិតពិសេស នៃការលាបពណ៌ និងចាប់ម៉ូតបែបទំនើប- 𝗘𝗽𝗶𝗰❗️ 𝗘𝘀𝘀𝗲𝗻𝘁𝗶𝗮𝗹 𝗖𝗼𝗹𝗼𝗿 𝗮𝗻𝗱 𝗦𝘁𝘆𝗹𝗶𝗻𝗴\r\n📅 ថ្ងៃទី 8-9 កុម្ភៈ 2023 | 9ព្រឹក - 4រសៀល\r\n👩‍🏫អ្នកគ្រូបង្គោល៖ KIN NIM\r\n📍 ទីតាំង៖ អគារសាលា លីសេ (LICE)\r\n📈 វិនិយោគសិក្សា៖ $100/ម្នាក់',	NULL,	1,	0,	'2023-06-19 13:19:51',	'2023-06-19 13:19:51'),
(134,	'ឯកទេសកាត់ & លាបពណ៌សក់-EXPERT CUT & COLOR',	'/photo_2023-06-19_09-20-45-20a87832-2c4d-4f19-91eb-1630a258f4dc.jpg',	'250',	'078/81667721',	'2023-02-16 09:00:00',	'6',	'💥 🥰អភិវឌ្ឍជំនាញសក់ជាមួយគ្រូកម្រិតអន្ដរជាតិមកពីប្រទេសបារាំង  លោកគ្រូ 𝗢𝗨𝗧𝗛 𝗦𝗧𝗘𝗩𝗘𝗡𝗦✨\r\nក្នុងខែកុម្ភៈនេះ ដោយផ្ទាល់នៅសាលា LICE ជាមួយវគ្គដូចខាងក្រោម៖\r\n\r\n👉 16-17 កុម្ភៈ 2023 | 9:00am - 4:00pm \r\nវគ្គ ឯកទេសកាត់ & លាបពណ៌សក់-EXPERT CUT & COLOR\r\nវិនិយោគ៖ $250 /ម្នាក់\r\n👉21-22កុម្ភៈ 2023 | 9:00am - 4:00pm \r\nវគ្គ កាត់ & លាបពណ៌សក់កម្រិតខ្ពស់-ADVANCE CUT & COLOR\r\nវិនិយោគ៖ $250 /ម្នាក់\r\n👉 23-24 កុម្ភៈ 2023 | 9:00am - 4:00pm \r\nវគ្គ ជំនាញកាត់សក់បុរសកម្រិតខ្ពស់ -ADVANCE BARBER SKILL\r\nវិនិយោគ៖ $250 /ម្នាក់\r\n\r\n\"វឌ្ឍនភាពនៃការងារគឺ  ការអប់រំ\"',	2,	1,	0,	'2023-06-19 13:25:23',	'2023-06-19 13:25:23'),
(135,	'𝐀𝐒𝐊 | វីធីសាស្ដ្រកាត់សក់ និងអ៊ុតរួញបែបឌីជីថល- Advanced Cut & Digital Keratin Perm',	'/photo_2023-06-19_09-26-15-c816da14-65b7-4045-9890-e75185f149e5.jpg',	'100',	'078/81667721',	'2023-03-08 09:00:00',	'6',	'😍ជួបជាមួយ វគ្គបណ្ដុះបណ្ដាលថ្មី សម្រាប់បងប្អូនមានបំណងចង់សិក្សាអំពីបច្ចេកទេសនៃការកាត់សក់ និងអ៊ុតរួញត្រូវតាមអន្ដរជាតិ\r\n✍️វគ្គ 𝐀𝐒𝐊 | វីធីសាស្ដ្រកាត់សក់ និងអ៊ុតរួញបែបឌីជីថល- Advanced Cut & Digital Keratin Perm\r\n📅 ថ្ងៃទី 8-9 មីនា 2023 | 9ព្រឹក - 4រសៀល\r\n🧑‍🏫 លោកគ្រូបង្គោល៖ CHANTIP NEAK\r\n📍 ទីតាំង៖ អគារសាលា លីសេ (LICE)\r\n📈 វិនិយោគសិក្សា៖ $100/ម្នាក់',	NULL,	1,	0,	'2023-06-19 13:27:43',	'2023-06-19 13:27:43'),
(136,	'𝐎𝐩𝐞𝐧𝐃𝐚𝐲 | សម្រស់ពណ៍សក់របស់អ្នកកាន់តែទាក់ទាញជាងមុនជាមួយនឹងការអ៊ុតរួញ-Empower Your Hair Color By Perm',	'/photo_2023-06-19_09-27-51-b77d53fd-6f86-40b4-9fd8-706e9a8b934e.jpg',	'00',	'078/81667721',	'2023-03-04 09:00:00',	'3',	'💥តើនឹងមានអ្វីពិសេសនៅវគ្គ 𝐎𝐩𝐞𝐧𝐃𝐚𝐲?\r\n 💡ទទួលបានចំណេះដឹង និងអត្ថប្រយោជន៍ដូចជា៖\r\n- យល់ដឹងពីបច្ចេកទេសព្យាបាលសក់\r\n- ស្គាល់ពីផលិតផលប្រើប្រាស់គ្រប់ប្រភេទ\r\n-  ស្គាល់បច្ចេកទេសធ្វើពណ៌និងអ៊ុតរួញត្រជាក់\r\n- យល់ដឹងអំពីការប្រើប្រាស់ផលិតផលអ៊ុតរួញត្រជាក់\r\n- យល់ដឹងពីបច្ចេកទេសធ្វើ -  យល់ដឹងពីការប្រើប្រាស់ហ្គែន\r\n\r\n✍️ វគ្គបណ្តុះបណ្តាល 𝐎𝐩𝐞𝐧𝐃𝐚𝐲 | សម្រស់ពណ៍សក់របស់អ្នកកាន់តែទាក់ទាញជាងមុនជាមួយនឹងការអ៊ុតរួញ-Empower Your Hair Color By Perm\r\n📅 ថ្ងៃទី 04 មីនា 2023 | 9 - 11ព្រឹក\r\n😍ចូលរួមដោយឥតគិតថ្លៃនៅអគារសាលា លីសេ (LICE)',	NULL,	1,	0,	'2023-06-19 13:29:17',	'2023-06-19 13:29:17'),
(137,	'ASK Academy លោក 𝐖𝐈𝐖𝐀𝐓 𝐊𝐀𝐒𝐄𝐌𝐀𝐌𝐎𝐑𝐍✨ ជាមួយវគ្គដូចខាងក្រោម៖',	'/photo_2023-06-19_09-34-05-f325b0c4-7325-438d-a02a-29229b277a14.jpg',	'50',	'078/81667721',	'2023-03-17 09:00:00',	'6',	'💥 ជួបជាមួយ 𝗔𝗿𝘁𝗶𝘀𝘁𝗶𝗰 𝗗𝗶𝗿𝗲𝗰𝘁𝗼𝗿 ប្រចាំតំបន់អាស៊ីនៃ Schwarzkopf Professional ASK Academy លោក 𝐖𝐈𝐖𝐀𝐓 𝐊𝐀𝐒𝐄𝐌𝐀𝐌𝐎𝐑𝐍✨ ជាមួយវគ្គដូចខាងក្រោម៖\r\n\r\n👉 15 មីនា  | 9:00am - 4:00pm \r\n𝗖𝘂𝘁 & 𝗖𝗼𝗹𝗼𝗿 𝗘𝘀𝘀𝗲𝗻𝘁𝗶𝗮𝗹 𝗟𝗼𝗼𝗸𝘀 𝗟𝗲𝘃𝗲𝗹 (កាត់ & ពណ៌ កម្រិត Essential Looks)\r\n\r\n👉 16 មីនា  | 9:00am - 4:00pm \r\n𝗡𝗮𝗺𝗶𝗺𝗮𝗸𝗶 𝗣𝗲𝗿𝗺 - 𝗖𝗼𝗹𝗱 𝗣𝗲𝗿𝗺 𝗖𝗿𝗲𝗮𝘁𝗶𝗼𝗻 𝗡𝗲𝘄 𝗧𝗲𝗰𝗵𝗻𝗶𝗾𝘂𝗲 (បច្ចេកទេសអ៊ុតរួញត្រជាក់ថ្មី Namimaki)\r\n\r\n👉 17 មីនា  | 9:00am - 4:00pm \r\n𝗟𝗼𝗻𝗴 𝗛𝗮𝗶𝗿 𝗦𝘁𝘆𝗹𝗶𝗻𝗴 (លើកសម្រស់សក់វែងជាមួយការចាប់ម៉ូត)\r\n\r\n✍️   ចុះឈ្មោះមុនថ្ងៃ សល់ត្រឹមតែ៖ $50 /វគ្គនិមួយៗ\r\nតម្លៃពេញ៖ $80 /វគ្គនិមួយៗ',	NULL,	1,	0,	'2023-06-19 13:40:07',	'2023-06-19 13:40:07'),
(138,	'𝐀𝐒𝐊 | Color Collection 🎨🎨 📅 ថ្ងៃទី 22-23 មីនា 2023 | 9am - 4pm',	'/photo_2023-06-19_09-40-41-12716b96-eb83-41e1-b213-8a5ddf4f09a0.jpg',	'100',	'078/81667721',	'2023-03-23 09:00:00',	'12',	'💥ជួបជាមួយ វគ្គបណ្ដុះបណ្ដាលថ្មី សម្រាប់បងប្អូនមានបំណងចង់សិក្សាអំពីបច្ចេកទេសផ្សំពណ៌សក់ បែបអន្ដរជាតិ\r\n✍️វគ្គ 𝐀𝐒𝐊 | Color Collection 🎨🎨\r\n📅 ថ្ងៃទី 22-23 មីនា 2023 | 9am - 4pm\r\n🧑‍🏫 អ្នកគ្រូបង្គោល៖ Puy\r\n📍 ទីតាំង៖ អគារសាលា លីសេ (LICE)\r\n📈 វិនិយោគសិក្សា៖ $100/ម្នាក់',	5,	1,	0,	'2023-06-19 13:55:17',	'2023-06-19 13:55:17'),
(139,	'𝐒𝐚𝐥𝐨𝐧 𝐌𝐚𝐧𝐚𝐠𝐞𝐦𝐞𝐧𝐭|ការបែងចែកទំនួលខុសត្រូវការងារ - DELEGATION FOR WORK EFFECTIVENESS',	'/photo_2023-06-19_09-59-23-ac7aaa73-2685-4e0d-a67c-1e8e5572cba0.jpg',	'1000',	'078/81667721',	'2023-04-24 09:00:00',	'6',	'💥ជួបគ្នាជាថ្មី ជាមួយនឹងវគ្គ 𝐒𝐚𝐥𝐨𝐧 𝐌𝐚𝐧𝐚𝐠𝐞𝐦𝐞𝐧𝐭|ការបែងចែកទំនួលខុសត្រូវការងារ - DELEGATION FOR WORK EFFECTIVENESS\r\n\r\n📅 ថ្ងៃទី 24-26 មេសា 2023 | 9ព្រឹក - 4រសៀល\r\n🧑‍🏫 គ្រូឧទ្ទេស៖លោក ឡា វិបុល - នាកយកសាលាលីសេ (LICE) បណ្តុះបណ្តាលវិជ្ជាជីវៈផ្នែកសក់ និងសម្ភស្ស\r\n📍 ទីតាំង៖ សាលា លីសេ (LICE)\r\n\r\n📩សម្រាប់បងប្អូនដែលមានចំណាប់អារម្មណ៍ ចង់ចុះឈ្មោះចូលរៀនជាមួយយើងឥឡូវនេះ អាចទំនាក់ទំនងមកកាន់៖\r\n📞 078 | 081 66 77 21 (វគ្គបណ្តុះបណ្តាល)',	NULL,	1,	0,	'2023-06-19 14:01:09',	'2023-06-19 14:01:09'),
(140,	'𝐀𝐒𝐊 | បចេ្ចកទេសកាត់សក់បុរសឲ្យតាមទម្រង់មុខជាមួយ និងការចាប់ម៉ូតសក់-Men\'s haircut technique to fit face shape and new hairstyle',	'/photo_2023-06-19_10-02-02-60b6ddac-a779-4348-aca6-73aa18bff5c4.jpg',	'100',	'078/81667721',	'2023-05-10 09:00:00',	'6',	'💥វគ្គបណ្ដុះបណ្ដាលថ្មី សម្រាប់បងប្អូន កំពុងតែរងចាំបានមកដល់ហើយ!!!\r\n✍️វគ្គ 𝐀𝐒𝐊 | បចេ្ចកទេសកាត់សក់បុរសឲ្យតាមទម្រង់មុខជាមួយ និងការចាប់ម៉ូតសក់-Men\'s haircut technique to fit face shape and new hairstyle\r\n📅 ថ្ងៃទី 10-11 ឧសភា 2023 | 9:00am - 4:00pm\r\n🧑‍🏫 អ្នកគ្រូបង្គោល៖ THET SREY POV\r\n📍 ទីតាំង៖ អគារសាលា លីសេ (LICE)\r\n📈 វិនិយោគសិក្សា៖ $100/ម្នាក់',	NULL,	1,	0,	'2023-06-19 14:03:54',	'2023-06-19 14:03:54'),
(141,	'សិក្ខាសាលា|ការបង្កើនចំនួនអតិថិជនតាមរយៈ ការប្រាស្រ័យទាក់ទងដ៏មានប្រសិទ្ធភាព',	'/photo_2023-06-19_10-03-59-a1fa77c6-c224-4576-9c9b-bae7ea2316f2.jpg',	'00',	'078/81667721',	'2023-05-05 09:00:00',	'4',	'✍️ សិក្ខាសាលា|ការបង្កើនចំនួនអតិថិជនតាមរយៈ ការប្រាស្រ័យទាក់ទងដ៏មានប្រសិទ្ធភាព\r\n📅 ថ្ងៃទី ៥ ឧសភា ២០២៣|៩ព្រឹក - ១២ថ្ងៃត្រង់\r\n🧑‍🏫 ធ្វើបទបង្ហាញដោយគ្រូឧទ្ទេស៖ លោក ឡា វិបុល\r\n😍 ចូលរួមដោយឥតគិតថ្លៃនៅអគារសាលា លីសេ (LICE)',	4,	1,	0,	'2023-06-19 14:05:09',	'2023-06-19 14:05:09'),
(142,	'សិក្ខាសាលា| របៀបអ៊ុតសក់ត្រង់ទៅលើ សក់ពណ៌តាមកម្រិត',	'/photo_2023-06-19_10-05-29-f86b1e4a-9791-457d-bd39-fea294b58fa1.jpg',	'00',	'078/81667721',	'2023-05-13 09:00:00',	'4',	'✍️ សិក្ខាសាលា| របៀបអ៊ុតសក់ត្រង់ទៅលើ សក់ពណ៌តាមកម្រិត\r\n📅 ថ្ងៃទី 13 ឧសភា 2023| 9:00am-12:00pm\r\n🧑‍🏫 ធ្វើបទបង្ហាញដោយអ្នកគ្រូ៖ 𝐊𝐈𝐍 𝐍𝐈𝐌\r\n😍 ចូលរួមដោយឥតគិតថ្លៃនៅអគារសាលា លីសេ (LICE)',	NULL,	1,	0,	'2023-06-19 14:06:47',	'2023-06-19 14:06:47'),
(143,	'សិក្ខាសាលា|ការផ្ដោតលើទំនាក់ទំនងជាមួយអតិថិជន និងក្រុមការងារ',	'/photo_2023-06-19_10-07-24-ee1713d3-798d-43ef-8cd6-7ec60f609f37.jpg',	'00',	'078/81667721',	'2023-05-19 09:00:00',	'4',	'✍️ សិក្ខាសាលា|ការផ្ដោតលើទំនាក់ទំនងជាមួយអតិថិជន និងក្រុមការងារ\r\n📅 ថ្ងៃទី 19 ឧសភា 2023|9:00am-12:00pm\r\n🧑‍🏫 ធ្វើបទបង្ហាញដោយគ្រូឧទ្ទេស៖ លោក ឡា វិបុល\r\n😍 ចូលរួមដោយឥតគិតថ្លៃនៅអគារសាលា លីសេ (LICE)',	NULL,	1,	0,	'2023-06-19 14:08:23',	'2023-06-19 14:08:23'),
(144,	'សិក្ខាសាលា|ការកាត់សក់បែបបារាំង',	'/photo_2023-06-19_10-09-03-1826ff5e-83d1-42e1-8924-c2cd44a2b88d.jpg',	'00',	'078/81667721',	'2023-05-27 09:00:00',	'4',	'✍️ សិក្ខាសាលា|ការកាត់សក់បែបបារាំង\r\n📅 ថ្ងៃទី 27 ឧសភា 2023|9:00am-12:00pm\r\n🧑‍🏫 ធ្វើបទបង្ហាញដោយអ្នកគ្រូ៖ 𝐆𝐰𝐞𝐧\r\n😍 ចូលរួមដោយឥតគិតថ្លៃនៅអគារសាលា លីសេ (LICE)',	NULL,	1,	0,	'2023-06-19 14:10:03',	'2023-06-19 14:10:03'),
(145,	'𝐀𝐒𝐊 |  បច្ចេកទេស WAVY PERM',	'/photo_2023-06-19_10-10-33-cd779147-6ae7-4732-b1d9-535e3742cd47.jpg',	'100',	'078/81667721',	'2023-06-07 09:00:00',	'7',	'💥វគ្គបណ្ដុះបណ្ដាលថ្មី ខែថ្មីសម្រាប់បងប្អូន ចង់សិក្សាបន្ថែមពង្រឹងលើការអ៊ុតសក់រួញ!!!\r\n✍️វគ្គ 𝐀𝐒𝐊 |  បច្ចេកទេស WAVY PERM\r\n📅 ថ្ងៃទី 07-08 មិថុនា 2023 | 9:00am - 4:00pm\r\n🧑‍🏫 អ្នកគ្រូបង្គោល៖ SKINKY \r\n📍 ទីតាំង៖ អគារសាលា លីសេ (LICE)\r\n📈 វិនិយោគសិក្សា៖ $100/ម្នាក់',	NULL,	1,	0,	'2023-06-19 14:11:41',	'2023-06-19 14:11:41'),
(146,	'សិក្ខាសាលា|បច្ចេកទេសហាយឡាយអោយត្រូវស្តង់ដារ និងការបង្កើតឡាញ (Lines)',	'/photo_2023-06-19_10-12-01-e7ded92f-585e-41a2-bbf6-2f3f59913b2d.jpg',	'00',	'078/81667721',	'2023-06-03 09:00:00',	'4',	'✍️ សិក្ខាសាលា|បច្ចេកទេសហាយឡាយអោយត្រូវស្តង់ដារ និងការបង្កើតឡាញ (Lines)\r\n📅 ថ្ងៃទី ០៣ មិថុនា 2023|9:00am-12:00pm\r\n👨‍🏫 ធ្វើបទបង្ហាញដោយលោកគ្រូ៖ Meas Dore\r\n😍 ចូលរួមដោយឥតគិតថ្លៃនៅអគារសាលា លីសេ (LICE)',	8,	1,	1,	'2023-06-19 14:13:00',	'2024-01-06 16:06:52'),
(147,	'𝐀𝐒𝐊 | បចេ្ចកទេស Wet Balayage',	'/photo_2023-06-19_11-26-34-5659e920-89dd-4a99-b6c1-2b7a4bdfaf47.jpg',	'100',	'078/81667721',	'2023-06-28 09:00:00',	'12',	'❓អ្វីទៅជាបច្ចេកទេស Balayage ?\r\n💥តោះវគ្គបណ្ដុះបណ្ដាលថ្មី បើកហើយសម្រាប់បងប្អូន ចង់សិក្សាបន្ថែមលើបច្ចេកទេស Balayage\r\n✍️វគ្គ 𝐀𝐒𝐊 | បចេ្ចកទេស Wet Balayage \r\n📅 ថ្ងៃទី 28-29 មិថុនា 2023 | 9:00am - 4:00pm\r\n👩‍🏫 លោកអ្នកគ្រូបង្គោល៖ KIN NIM\r\n📍 ទីតាំង៖ អគារសាលា លីសេ (LICE)\r\n📈 វិនិយោគសិក្សា៖ $100/ម្នាក់\r\n\r\n\"វឌ្ឍនភាពនៃការងារគឺ ការអប់រំ\"',	NULL,	1,	1,	'2023-06-19 15:30:12',	'2024-01-06 15:45:26'),
(148,	'បច្ចេកទេសអ៊ុតសក់រួញ 𝐍𝐚𝐦𝐢𝐦𝐚𝐤𝐢',	'/បច្ចេកទេសអ៊ុតសក់រួញ 𝐍𝐚𝐦𝐢𝐦𝐚𝐤𝐢-42936b3b-41c5-446e-b6ad-9f1175bd2e07.jpg',	'00',	'078/081 667722',	'2023-07-07 09:00:00',	'4',	'សិក្ខាសាលាស្ដីអំពី| បច្ចេកទេសអ៊ុតសក់រួញ 𝐍𝐚𝐦𝐢𝐦𝐚𝐤𝐢\r\n📅 ថ្ងៃទី 07  កក្កដា 2023|9:00am-12:00pm\r\n👨‍🏫 ធ្វើបទបង្ហាញដោយលោកគ្រូ៖ Meas Dore\r\n😍 ចូលរួមដោយឥតគិតថ្លៃនៅអគារសាលា លីសេ (LICE)',	8,	1,	1,	'2023-07-20 13:37:44',	'2023-12-16 11:59:13'),
(149,	'ការច្នៃប្រឌិតកម្រិតខ្ពស់-ADVANCED CREATIVE',	'/Gobal-steven-01-f1d17aca-f500-4969-b415-028b8d0d6c35.jpg',	'250',	'078 | 081 66 77 21',	'2024-01-10 09:00:00',	'16',	'🥰អភិវឌ្ឍជំនាញសក់ ជាមួយគ្រូកម្រិតអន្ដរជាតិ​​ មកពីប្រទេសបារាំង🇫🇷🇫🇷🤝​🇰🇭🇰🇭 👉ជួបជាមួយលោកគ្រូ៖ 𝗢𝗨𝗧𝗛 𝗦𝗧𝗘𝗩𝗘𝗡𝗦✨ក្នុងឆ្នាំ2024ខាងមុខនេះ ដោយផ្ទាល់នៅសាលា LICE ជាមួយវគ្គដូចខាងក្រោម៖ 📅 10-11 កមរា 2024 | 9:00am - 4:00pm វគ្គ',	2,	1,	1,	'2024-01-06 15:24:17',	'2024-01-06 15:40:34'),
(150,	'វគ្គ ជំនាញកាត់សក់បុរសកម្រិតខ្ពស់​-ADVANCE BARBER SIGNATURE',	'/Gobal-steven-02-5151180d-eda2-48cd-8201-daa2ab9248da.jpg',	'125',	'078 | 081 66 77 21',	'2024-01-12 09:00:00',	'8',	'🥰អភិវឌ្ឍជំនាញសក់ ជាមួយគ្រូកម្រិតអន្ដរជាតិ​​ មកពីប្រទេសបារាំង🇫🇷🇫🇷🤝​🇰🇭🇰🇭\r\n👉ជួបជាមួយលោកគ្រូ៖ 𝗢𝗨𝗧𝗛 𝗦𝗧𝗘𝗩𝗘𝗡𝗦✨ក្នុងឆ្នាំ2024ខាងមុខនេះ ដោយផ្ទាល់នៅសាលា LICE',	2,	1,	1,	'2024-01-06 15:40:24',	'2024-01-06 15:40:24'),
(151,	'វគ្គ អត្តសញ្ញាណនៃ Balayage​ កម្រិតខ្ពស់-ADVANCE MEN',	'/Gobal-steven-03-2d687f04-f394-4001-aefb-b5e413234463.jpg',	'250',	'078 | 081 66 77 21',	'2024-01-16 09:00:00',	'16',	'🥰អភិវឌ្ឍជំនាញសក់ ជាមួយគ្រូកម្រិតអន្ដរជាតិ​​ មកពីប្រទេសបារាំង🇫🇷🇫🇷🤝​🇰🇭🇰🇭\r\n👉ជួបជាមួយលោកគ្រូ៖ 𝗢𝗨𝗧𝗛 𝗦𝗧𝗘𝗩𝗘𝗡𝗦✨ក្នុងឆ្នាំ2024ខាងមុខនេះ',	2,	1,	1,	'2024-01-06 15:43:49',	'2024-01-06 15:43:49'),
(152,	'វគ្គ ក្លាយជាអ្នកជំនាញផ្នែកសក់កម្រិត1​-EXPERT LEVEL 1',	'/Gobal-steven-04-adbc74c7-c058-436f-a9af-6bd8d370241d.jpg',	'250',	'078 | 081 66 77 21',	'2024-01-18 09:00:00',	'16',	'🥰អភិវឌ្ឍជំនាញសក់ ជាមួយគ្រូកម្រិតអន្ដរជាតិ​​ មកពីប្រទេសបារាំង🇫🇷🇫🇷🤝​🇰🇭🇰🇭\r\n👉ជួបជាមួយលោកគ្រូ៖ 𝗢𝗨𝗧𝗛 𝗦𝗧𝗘𝗩𝗘𝗡𝗦✨ក្នុងឆ្នាំ2024ខាងមុខនេះ',	2,	1,	1,	'2024-01-06 15:45:13',	'2024-01-06 15:45:13'),
(153,	'✍️ វគ្គ 𝐀𝐒𝐊 | បច្ចេកទេសបង្កើត Balayage កម្រិតស្ដង់ដាអន្ដរជាតិ-Advance Balayage',	'/Cover-55130c96-e615-46bd-aee4-2b61ec86fe63.jpg',	'200',	'078 | 081 66 77 21',	'2024-02-19 09:00:00',	'16',	'✍️ វគ្គ 𝐀𝐒𝐊 | បច្ចេកទេសបង្កើត Balayage កម្រិតស្ដង់ដាអន្ដរជាតិ-Advance Balayage\r\n📅 ថ្ងៃទី 19-20 កុម្ភៈ​ 2024 | 9:00am - 4:00pm\r\n👩‍🏫 អ្នកគ្រូ៖ ចាន់ ធី\r\n📍ទីតាំង៖ អគារសាលា លីសេ (LICE)\r\nព័ត៌មានបន្ថែមសូមទំនាក់ទំនងចុះឈ្មោះ តាមរយៈ\r\n📞លេខទូរស័ព្ទ៖ 078 | 081 667 721\r\n📍 ផ្ទះលេខC65-C66 (កែងតារាងវាយកូនហ្គោលបឹងកក់ចាស់)\r\nhttps://goo.gl/maps/64WVXBFQ7jsZdnB37\r\n====== វឌ្ឍនភាពនៃការងារគឺ ការអប់រំ ========\r\n#lice #schwarzkopfprocambodia #joicocambodia #licestore #licesergecomtesse #ingcambodia #askacademykh',	12,	1,	1,	'2024-02-15 11:20:33',	'2024-02-15 11:20:33');

DROP TABLE IF EXISTS `covers`;
CREATE TABLE `covers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `image` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `covers` (`id`, `image`, `type`, `created_at`, `updated_at`) VALUES
(1,	'/7rpgbm16316820469931-011-ad045290-a976-4865-b4f0-5abb9943ad69.jpg',	'home',	'2023-04-27 22:47:55',	'2023-04-27 22:47:55'),
(2,	'/slide-4-be877a17-8277-434e-8494-aaf96b388bf7-e88eafcb-9b97-4a86-96d1-33be2097241a.jpg',	'about',	'2023-04-29 00:15:47',	'2023-04-29 00:15:47');

DROP TABLE IF EXISTS `education_levels`;
CREATE TABLE `education_levels` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `education_levels` (`id`, `name`, `status`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1,	'Under grade 9th',	1,	'2022-12-28 07:12:24',	'2023-01-23 20:36:55',	NULL),
(2,	'Finished grade 9th',	1,	'2022-12-28 07:14:02',	'2023-01-23 20:35:43',	NULL),
(3,	'Finished grade 12th',	1,	'2023-01-09 14:57:26',	'2023-01-23 20:36:01',	NULL),
(4,	'Finished C1',	1,	'2023-01-22 13:45:17',	'2023-01-23 20:36:34',	NULL),
(5,	'Finished C2',	1,	'2023-01-23 20:37:12',	'2023-01-23 20:37:12',	NULL),
(6,	'Finished C3',	1,	'2023-01-23 20:37:23',	'2023-01-23 20:37:23',	NULL),
(7,	'Other',	1,	'2023-01-23 20:37:32',	'2023-01-23 20:37:32',	NULL),
(8,	'SDF',	1,	'2023-02-02 16:46:01',	'2023-02-02 16:46:01',	NULL);

DROP TABLE IF EXISTS `exam_answer_sheets`;
CREATE TABLE `exam_answer_sheets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `class_id` int(11) NOT NULL,
  `exam_subject_id` int(11) NOT NULL,
  `exam_candidate_id` int(11) NOT NULL,
  `acquired_score` double(8,2) NOT NULL,
  `answer_sheet` varchar(125) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `exam_answer_sheets` (`id`, `class_id`, `exam_subject_id`, `exam_candidate_id`, `acquired_score`, `answer_sheet`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1,	3,	1,	1,	95.00,	'/Screen Shot 2022-12-28 at 1.33.38 PM-1284e0b8-1e1f-4637-bff6-b47af85b344c.png',	'2023-05-04 21:15:33',	'2023-05-04 21:59:02',	'2023-05-04 21:59:02'),
(2,	3,	1,	1,	85.00,	NULL,	'2023-05-04 21:59:42',	'2023-05-04 23:12:39',	'2023-05-04 23:12:39'),
(3,	3,	1,	2,	52.00,	NULL,	'2023-05-04 23:12:55',	'2023-05-04 23:12:55',	NULL);

DROP TABLE IF EXISTS `exam_candidates`;
CREATE TABLE `exam_candidates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `class_id` int(11) NOT NULL,
  `exam_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `exam_candidates` (`id`, `class_id`, `exam_id`, `student_id`, `created_at`, `updated_at`) VALUES
(2,	3,	1,	71,	'2023-05-04 23:09:38',	'2023-05-04 23:09:38'),
(3,	3,	1,	72,	'2023-05-04 23:09:42',	'2023-05-04 23:09:42');

DROP TABLE IF EXISTS `exam_controls`;
CREATE TABLE `exam_controls` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `class_id` int(11) NOT NULL,
  `exam_type_id` int(11) NOT NULL,
  `exam_date` datetime NOT NULL,
  `duration` int(11) NOT NULL,
  `noted` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `exam_controls` (`id`, `class_id`, `exam_type_id`, `exam_date`, `duration`, `noted`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1,	3,	3,	'2023-05-10 00:00:00',	1,	'Subject',	'2023-05-04 20:57:44',	'2023-05-04 20:57:44',	NULL);

DROP TABLE IF EXISTS `exam_scores`;
CREATE TABLE `exam_scores` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `class_id` int(11) NOT NULL,
  `lesson_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `score` double(8,2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `exam_scores` (`id`, `class_id`, `lesson_id`, `student_id`, `score`, `created_at`, `updated_at`) VALUES
(1,	3,	5,	72,	50.00,	'2023-05-05 12:23:42',	'2023-05-05 12:23:42'),
(2,	3,	6,	72,	70.00,	'2023-05-05 12:23:42',	'2023-05-05 12:23:42'),
(3,	3,	7,	72,	95.00,	'2023-05-05 12:23:42',	'2023-05-05 12:23:42'),
(4,	3,	5,	71,	75.00,	'2023-05-05 12:24:24',	'2023-05-05 12:24:24'),
(5,	3,	6,	71,	70.00,	'2023-05-05 12:24:24',	'2023-05-05 12:24:24'),
(6,	3,	7,	71,	63.00,	'2023-05-05 12:24:24',	'2023-05-05 12:24:24');

DROP TABLE IF EXISTS `exam_subjects`;
CREATE TABLE `exam_subjects` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `class_id` int(11) NOT NULL,
  `exam_id` int(11) NOT NULL,
  `sheet_issuer_id` int(11) NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google_doc_url` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `exam_subjects` (`id`, `class_id`, `exam_id`, `sheet_issuer_id`, `description`, `google_doc_url`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1,	3,	1,	1,	'Hair Health',	NULL,	'2023-05-04 20:58:04',	'2023-05-04 21:04:17',	NULL),
(2,	3,	1,	3,	'Good Nail',	NULL,	'2023-05-04 23:00:04',	'2023-05-04 23:00:04',	NULL),
(3,	3,	1,	4,	'Mix Coloring',	NULL,	'2023-05-04 23:10:09',	'2023-05-04 23:10:09',	NULL);

DROP TABLE IF EXISTS `exam_types`;
CREATE TABLE `exam_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `exam_types` (`id`, `name`, `status`, `created_at`, `updated_at`) VALUES
(1,	'Practice',	1,	'2022-12-28 07:28:39',	'2023-01-23 20:09:56'),
(2,	'Edit Exams',	2,	'2023-01-09 14:45:56',	'2023-01-09 14:47:34'),
(3,	'Theory',	1,	'2023-01-23 20:10:42',	'2023-01-23 20:10:42'),
(4,	'Mid - Term Exam Edit',	1,	'2023-05-04 18:29:06',	'2023-05-04 18:29:47');

DROP TABLE IF EXISTS `fcm_tokens`;
CREATE TABLE `fcm_tokens` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `token` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `file_managers`;
CREATE TABLE `file_managers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `folder_id` int(11) DEFAULT NULL,
  `name` varchar(125) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `path` varchar(125) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` varchar(125) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'File size, in bytes',
  `width` double DEFAULT NULL COMMENT 'width of image,in pixels',
  `height` double DEFAULT NULL COMMENT 'height of image,in pixels',
  `extension` varchar(125) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'extension of file, not including dot',
  `is_hidden` tinyint(1) NOT NULL DEFAULT 0 COMMENT '1 if file is hidden, 0 if not',
  `is_image` tinyint(1) NOT NULL DEFAULT 0 COMMENT '1 if file is image, 0 if not',
  `is_audio` tinyint(1) NOT NULL DEFAULT 0 COMMENT '1 if file is audio, 0 if not',
  `is_video` tinyint(1) NOT NULL DEFAULT 0 COMMENT '1 if file is video, 0 if not',
  `is_document` tinyint(1) NOT NULL DEFAULT 0 COMMENT '1 if file is document, 0 if not',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `file_managers_id_unique` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `file_managers` (`id`, `user_id`, `folder_id`, `name`, `path`, `size`, `width`, `height`, `extension`, `is_hidden`, `is_image`, `is_audio`, `is_video`, `is_document`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1,	1,	NULL,	'Screen Shot 2022-12-28 at 1.33.38 PM-1284e0b8-1e1f-4637-bff6-b47af85b344c',	'/Screen Shot 2022-12-28 at 1.33.38 PM-1284e0b8-1e1f-4637-bff6-b47af85b344c.png',	'415708',	3584,	2240,	'png',	0,	1,	0,	0,	0,	'2022-12-29 11:31:07',	'2022-12-29 11:31:07',	NULL),
(2,	1,	NULL,	'photo_2022-09-27_14-03-05-fdfdc157-1fd4-4b0e-a546-618f889c9397',	'/photo_2022-09-27_14-03-05-fdfdc157-1fd4-4b0e-a546-618f889c9397.jpg',	'118602',	960,	1280,	'jpg',	0,	1,	0,	0,	0,	'2023-01-09 14:20:42',	'2023-10-21 16:12:16',	'2023-10-21 16:12:16'),
(3,	1,	1,	'2022-03-30 13.04.05-8a7e1b68-d4bb-4851-8a7c-a6a824cf976f',	'/2022-03-30 13.04.05-8a7e1b68-d4bb-4851-8a7c-a6a824cf976f.jpg',	'74457',	640,	640,	'jpg',	0,	1,	0,	0,	0,	'2023-01-22 13:52:19',	'2023-01-22 13:52:19',	NULL),
(4,	1,	2,	'2023-01-23 14.24.01-1da98681-d1b9-43a4-9322-e743ce294ca9',	'/2023-01-23 14.24.01-1da98681-d1b9-43a4-9322-e743ce294ca9.jpg',	'50900',	640,	640,	'jpg',	0,	1,	0,	0,	0,	'2023-01-23 19:26:01',	'2023-01-23 19:26:01',	NULL),
(5,	1,	2,	'2023-01-23 14.37.15-645d5215-fb39-4720-8435-3873b5707bce',	'/2023-01-23 14.37.15-645d5215-fb39-4720-8435-3873b5707bce.jpg',	'83815',	640,	640,	'jpg',	0,	1,	0,	0,	0,	'2023-01-23 19:37:49',	'2023-01-23 19:37:49',	NULL),
(6,	1,	1,	'chhunLinna-786fff4e-b968-488e-887a-17f3f628021f',	'/chhunLinna-786fff4e-b968-488e-887a-17f3f628021f.png',	'15108',	68,	88,	'png',	0,	1,	0,	0,	0,	'2023-01-24 15:08:49',	'2023-01-24 15:08:49',	NULL),
(7,	1,	1,	'KheavLina-cd35c433-5992-4298-9464-415fd72d9cd1',	'/KheavLina-cd35c433-5992-4298-9464-415fd72d9cd1.png',	'17341',	66,	98,	'png',	0,	1,	0,	0,	0,	'2023-01-24 15:11:30',	'2023-01-24 15:11:30',	NULL),
(8,	1,	1,	'ChhongChiva-4d1306b4-e8fc-451c-9998-3f77e1ff9278',	'/ChhongChiva-4d1306b4-e8fc-451c-9998-3f77e1ff9278.png',	'15596',	74,	90,	'png',	0,	1,	0,	0,	0,	'2023-01-24 15:14:21',	'2023-01-24 15:14:21',	NULL),
(9,	1,	1,	'MeyYuthy-a8dcd388-53ab-429d-b535-06370db12b82',	'/MeyYuthy-a8dcd388-53ab-429d-b535-06370db12b82.png',	'17372',	74,	98,	'png',	0,	1,	0,	0,	0,	'2023-01-24 15:14:21',	'2023-01-24 15:14:21',	NULL),
(10,	1,	1,	'PorkDane-e7f58425-aa83-4dde-84ba-cb42aac96d06',	'/PorkDane-e7f58425-aa83-4dde-84ba-cb42aac96d06.png',	'19666',	76,	98,	'png',	0,	1,	0,	0,	0,	'2023-01-24 15:14:22',	'2023-01-24 15:14:22',	NULL),
(11,	1,	NULL,	'IMG_3918-62e0c55c-b697-4ce3-91bc-1b8f557dec2a',	'/IMG_3918-62e0c55c-b697-4ce3-91bc-1b8f557dec2a.PNG',	'353976',	587,	586,	'PNG',	0,	0,	0,	0,	0,	'2023-02-01 18:51:34',	'2023-02-02 14:07:33',	'2023-02-02 14:07:33'),
(12,	1,	NULL,	'IMG_9375-0b5f88a3-7140-4db8-acd6-bab75bd61970',	'/IMG_9375-0b5f88a3-7140-4db8-acd6-bab75bd61970.JPG',	'10795859',	4000,	6000,	'JPG',	0,	0,	0,	0,	0,	'2023-02-01 18:53:00',	'2023-02-02 14:07:37',	'2023-02-02 14:07:37'),
(13,	1,	NULL,	'photo_2023-02-02_09-03-23-491c46f2-a9bb-4485-b387-3bcbe609addb',	'/photo_2023-02-02_09-03-23-491c46f2-a9bb-4485-b387-3bcbe609addb.jpg',	'80108',	855,	1280,	'jpg',	0,	1,	0,	0,	0,	'2023-02-02 14:04:09',	'2023-02-02 14:07:41',	'2023-02-02 14:07:41'),
(14,	1,	4,	'IMG_3918-c7302d1f-e1de-4986-b933-8a3ceafca1b7',	'/IMG_3918-c7302d1f-e1de-4986-b933-8a3ceafca1b7.PNG',	'353976',	587,	586,	'PNG',	0,	0,	0,	0,	0,	'2023-02-02 14:05:32',	'2023-02-02 14:05:32',	NULL),
(15,	1,	4,	'IMG_9375-44731665-6ffe-439b-b455-8e7f530267d7',	'/IMG_9375-44731665-6ffe-439b-b455-8e7f530267d7.JPG',	'10795859',	4000,	6000,	'JPG',	0,	0,	0,	0,	0,	'2023-02-02 14:06:30',	'2023-02-02 14:06:30',	NULL),
(16,	1,	4,	'photo_2023-02-02_09-03-23-52401c9b-17eb-4ff9-927b-6eb0b11e9af1',	'/photo_2023-02-02_09-03-23-52401c9b-17eb-4ff9-927b-6eb0b11e9af1.jpg',	'80108',	855,	1280,	'jpg',	0,	1,	0,	0,	0,	'2023-02-02 14:07:16',	'2023-02-02 14:07:16',	NULL),
(17,	1,	4,	'photo_2022-09-08_09-31-19-52ed8b76-ee09-4bd6-ad6d-b75ae0656307',	'/photo_2022-09-08_09-31-19-52ed8b76-ee09-4bd6-ad6d-b75ae0656307.jpg',	'92585',	640,	640,	'jpg',	0,	1,	0,	0,	0,	'2023-02-02 14:56:25',	'2023-02-02 14:56:25',	NULL),
(18,	1,	NULL,	'តារ៉ា-68627ac9-7e17-4f56-9585-7640e893f1ba',	'/តារ៉ា-68627ac9-7e17-4f56-9585-7640e893f1ba.jpg',	'94699',	954,	1280,	'jpg',	0,	1,	0,	0,	0,	'2023-04-04 14:26:16',	'2023-04-04 14:26:16',	NULL),
(19,	1,	NULL,	'សេង តូច-513ede6a-ea2d-4fe0-a583-3b6dacf0254d',	'/សេង តូច-513ede6a-ea2d-4fe0-a583-3b6dacf0254d.jpg',	'109514',	997,	1280,	'jpg',	0,	1,	0,	0,	0,	'2023-04-04 14:27:22',	'2023-04-04 14:27:22',	NULL),
(20,	1,	NULL,	'ឡេង កែវ-36ec4992-0def-4de5-9390-728c3b05ee56',	'/ឡេង កែវ-36ec4992-0def-4de5-9390-728c3b05ee56.jpg',	'118286',	1018,	1280,	'jpg',	0,	1,	0,	0,	0,	'2023-04-04 14:30:05',	'2023-04-04 14:30:05',	NULL),
(21,	1,	NULL,	'ហេងឡាយ-979943ad-4396-4583-8838-b9615386702e',	'/ហេងឡាយ-979943ad-4396-4583-8838-b9615386702e.jpg',	'114554',	991,	1280,	'jpg',	0,	1,	0,	0,	0,	'2023-04-04 14:30:51',	'2023-04-04 14:30:51',	NULL),
(22,	1,	NULL,	'Teb-fbae2ef5-836b-4be5-b596-849650814e02',	'/Teb-fbae2ef5-836b-4be5-b596-849650814e02.jpg',	'89574',	944,	1280,	'jpg',	0,	1,	0,	0,	0,	'2023-04-04 14:31:13',	'2023-04-04 14:31:13',	NULL),
(23,	1,	NULL,	'ហេងឡាយ-2f3d44f2-548a-4919-a935-ac678ec80090',	'/ហេងឡាយ-2f3d44f2-548a-4919-a935-ac678ec80090.jpg',	'114554',	991,	1280,	'jpg',	0,	1,	0,	0,	0,	'2023-04-04 14:32:01',	'2023-04-04 14:32:01',	NULL),
(24,	1,	NULL,	'សុធា-bcc81118-9cba-4868-906f-0410597cfcaf',	'/សុធា-bcc81118-9cba-4868-906f-0410597cfcaf.jpg',	'110556',	961,	1280,	'jpg',	0,	1,	0,	0,	0,	'2023-04-04 14:32:37',	'2023-04-04 14:32:37',	NULL),
(25,	1,	NULL,	'ព្រហ្ម យ៉េន-24f49cce-bfb5-4720-80c2-1d412dff4a0c',	'/ព្រហ្ម យ៉េន-24f49cce-bfb5-4720-80c2-1d412dff4a0c.jpg',	'115192',	992,	1280,	'jpg',	0,	1,	0,	0,	0,	'2023-04-04 14:34:05',	'2023-04-04 14:34:05',	NULL),
(26,	1,	NULL,	'chanrothnak-036e76ba-e30d-4a5b-b459-5da1ee516390',	'/chanrothnak-036e76ba-e30d-4a5b-b459-5da1ee516390.jpg',	'108208',	1001,	1280,	'jpg',	0,	1,	0,	0,	0,	'2023-04-04 15:02:20',	'2023-04-04 15:02:20',	NULL),
(27,	1,	NULL,	'រដ្ថា-185de661-d4db-47b7-86f4-c639670b6f0b',	'/រដ្ថា-185de661-d4db-47b7-86f4-c639670b6f0b.jpg',	'124827',	988,	1280,	'jpg',	0,	1,	0,	0,	0,	'2023-04-04 15:02:58',	'2023-04-04 15:02:58',	NULL),
(28,	1,	NULL,	'សំណាង-765ede22-22f2-4d9e-bd49-32a20b5a341f',	'/សំណាង-765ede22-22f2-4d9e-bd49-32a20b5a341f.jpg',	'124203',	995,	1280,	'jpg',	0,	1,	0,	0,	0,	'2023-04-04 19:45:49',	'2023-04-04 19:45:49',	NULL),
(29,	1,	NULL,	'អៀង​ រឹទ្ធី-d9779aea-e583-426c-9bb9-3261d12ecf36',	'/អៀង​ រឹទ្ធី-d9779aea-e583-426c-9bb9-3261d12ecf36.jpg',	'116992',	967,	1280,	'jpg',	0,	1,	0,	0,	0,	'2023-04-04 20:20:38',	'2023-04-04 20:20:38',	NULL),
(30,	1,	NULL,	'សែម ដាវី-bb61b1cc-01ea-4070-8651-3d1c653a6149',	'/សែម ដាវី-bb61b1cc-01ea-4070-8651-3d1c653a6149.jpg',	'102118',	924,	1280,	'jpg',	0,	1,	0,	0,	0,	'2023-04-04 20:22:18',	'2023-04-04 20:22:18',	NULL),
(31,	1,	NULL,	'សុពណ៌-ed6f378f-7026-4d8e-9050-3ae169e97f7e',	'/សុពណ៌-ed6f378f-7026-4d8e-9050-3ae169e97f7e.jpg',	'108631',	960,	1280,	'jpg',	0,	1,	0,	0,	0,	'2023-04-04 20:22:52',	'2023-04-04 20:22:52',	NULL),
(32,	1,	NULL,	'សុភ័ណ្ឌ-f536b10c-2bd3-4ed5-aad5-0a9fce56d71b',	'/សុភ័ណ្ឌ-f536b10c-2bd3-4ed5-aad5-0a9fce56d71b.jpg',	'109035',	937,	1280,	'jpg',	0,	1,	0,	0,	0,	'2023-04-04 20:24:10',	'2023-04-04 20:24:10',	NULL),
(33,	1,	NULL,	'ឈុំ ប៊ុនណារី-b62cb1ea-911f-47b1-b7ec-d625616ece2c',	'/ឈុំ ប៊ុនណារី-b62cb1ea-911f-47b1-b7ec-d625616ece2c.jpg',	'128218',	1003,	1280,	'jpg',	0,	1,	0,	0,	0,	'2023-04-04 20:24:49',	'2023-04-04 20:24:49',	NULL),
(34,	1,	6,	'7rpgbm16316820469931-011-ad045290-a976-4865-b4f0-5abb9943ad69',	'/7rpgbm16316820469931-011-ad045290-a976-4865-b4f0-5abb9943ad69.jpg',	'112955',	1180,	346,	'jpg',	0,	1,	0,	0,	0,	'2023-04-27 22:47:38',	'2023-04-27 22:47:38',	NULL),
(35,	1,	7,	'4isqg51639389449522Product - All P&S at ABHC_Website-0bd9e252-3e5f-4e5c-82a5-e6ee28ce1ec3',	'/4isqg51639389449522Product - All P&S at ABHC_Website-0bd9e252-3e5f-4e5c-82a5-e6ee28ce1ec3.jpg',	'1384695',	5681,	2085,	'jpg',	0,	1,	0,	0,	0,	'2023-04-27 22:50:53',	'2023-04-27 22:50:53',	NULL),
(36,	1,	7,	'v48bs81630914665632School Prgoram at ABHC-02-0bf50f76-2cf6-4ccb-8d5b-65a4919d3b6a',	'/v48bs81630914665632School Prgoram at ABHC-02-0bf50f76-2cf6-4ccb-8d5b-65a4919d3b6a.jpg',	'2734957',	5681,	2085,	'jpg',	0,	1,	0,	0,	0,	'2023-04-27 22:51:17',	'2023-04-27 22:51:17',	NULL),
(37,	1,	7,	'c642j1631875223987Why partnership with ABHC-09-23e16c1f-bc70-4881-89fb-fc22c92b466b',	'/c642j1631875223987Why partnership with ABHC-09-23e16c1f-bc70-4881-89fb-fc22c92b466b.jpg',	'2744790',	5680,	2084,	'jpg',	0,	1,	0,	0,	0,	'2023-04-27 22:51:17',	'2023-04-27 22:51:17',	NULL),
(38,	1,	7,	'aljdu91624531375115Untitled-1-01-01-010c9db3-056c-4996-9310-0c5a95e4c4b6',	'/aljdu91624531375115Untitled-1-01-01-010c9db3-056c-4996-9310-0c5a95e4c4b6.png',	'351590',	500,	500,	'png',	0,	1,	0,	0,	0,	'2023-04-27 22:56:16',	'2023-04-27 22:56:16',	NULL),
(39,	1,	6,	'bktu0h1624588034210Overview Image-01-5a599f3f-a1f9-4a52-a3e4-7b1b4560349b',	'/bktu0h1624588034210Overview Image-01-5a599f3f-a1f9-4a52-a3e4-7b1b4560349b.png',	'190287',	360,	260,	'png',	0,	1,	0,	0,	0,	'2023-04-29 00:15:25',	'2023-04-29 00:15:25',	NULL),
(40,	1,	6,	'slide-4-be877a17-8277-434e-8494-aaf96b388bf7-e88eafcb-9b97-4a86-96d1-33be2097241a',	'/slide-4-be877a17-8277-434e-8494-aaf96b388bf7-e88eafcb-9b97-4a86-96d1-33be2097241a.jpg',	'180879',	1680,	1120,	'jpg',	0,	1,	0,	0,	0,	'2023-04-29 00:15:26',	'2023-04-29 00:15:26',	NULL),
(41,	1,	8,	'2022-03-25 08.53.45-297520eb-aa3c-498f-b9ad-9eb357e6e002',	'/2022-03-25 08.53.45-297520eb-aa3c-498f-b9ad-9eb357e6e002.jpg',	'162738',	960,	1280,	'jpg',	0,	1,	0,	0,	0,	'2023-05-04 14:34:22',	'2023-05-04 14:34:22',	NULL),
(42,	1,	8,	'2022-03-30 13.04.05-76d5745e-4e6c-47f0-8c47-b82ef29e3df6',	'/2022-03-30 13.04.05-76d5745e-4e6c-47f0-8c47-b82ef29e3df6.jpg',	'74457',	640,	640,	'jpg',	0,	1,	0,	0,	0,	'2023-05-04 14:50:14',	'2023-05-04 14:50:14',	NULL),
(43,	1,	1,	'2022-03-30 13.04.05-ebc53ef9-d3c6-4946-b5f8-7451c8a09314',	'/2022-03-30 13.04.05-ebc53ef9-d3c6-4946-b5f8-7451c8a09314.jpg',	'74457',	640,	640,	'jpg',	0,	1,	0,	0,	0,	'2023-05-05 11:19:32',	'2023-05-05 11:19:32',	NULL),
(52,	1,	NULL,	'chalo-gallardo-QAhSbzy1XhA-unsplash-66346ecb-c679-496e-a6d4-0ed9444a3c7b',	'/chalo-gallardo-QAhSbzy1XhA-unsplash-66346ecb-c679-496e-a6d4-0ed9444a3c7b.jpg',	'7366840',	4940,	6459,	'jpg',	0,	1,	0,	0,	0,	'2023-05-12 14:26:26',	'2023-05-12 14:26:26',	NULL),
(53,	8,	NULL,	'photo_2022-09-08_09-31-19-8cb8675c-5795-45aa-99e8-8cf041d7c2b7',	'/photo_2022-09-08_09-31-19-8cb8675c-5795-45aa-99e8-8cf041d7c2b7.jpg',	'84834',	640,	640,	'jpg',	0,	1,	0,	0,	0,	'2023-05-19 15:27:25',	'2023-05-19 15:35:16',	'2023-05-19 15:35:16'),
(54,	8,	NULL,	'photo_2023-05-19_11-25-53-c74efd54-9afa-4b67-bc08-d9c5b0af01a0',	'/photo_2023-05-19_11-25-53-c74efd54-9afa-4b67-bc08-d9c5b0af01a0.jpg',	'67164',	853,	1280,	'jpg',	0,	1,	0,	0,	0,	'2023-05-19 15:28:49',	'2023-05-19 15:30:15',	'2023-05-19 15:30:15'),
(55,	8,	NULL,	'b Pov-28207187-9f01-4c64-9fd5-566f9d0d0483',	'/b Pov-28207187-9f01-4c64-9fd5-566f9d0d0483.png',	'492709',	693,	948,	'png',	0,	1,	0,	0,	0,	'2023-05-19 15:32:08',	'2023-05-19 15:32:49',	'2023-05-19 15:32:49'),
(56,	8,	NULL,	'b Pvo-4599ee61-d2fd-41dd-b96b-3db3dcd78308',	'/b Pvo-4599ee61-d2fd-41dd-b96b-3db3dcd78308.jpg',	'52919',	1226,	1280,	'jpg',	0,	1,	0,	0,	0,	'2023-05-19 15:33:35',	'2023-05-19 15:35:08',	'2023-05-19 15:35:08'),
(57,	8,	NULL,	'b Pvo-fbc1cf53-3959-474b-9c94-95c9978fd107',	'/b Pvo-fbc1cf53-3959-474b-9c94-95c9978fd107.jpg',	'61729',	1280,	986,	'jpg',	0,	1,	0,	0,	0,	'2023-05-19 15:34:11',	'2023-05-19 15:34:11',	NULL),
(58,	8,	NULL,	'Meas Dore-b6dbc8b7-8f90-4910-9472-ddcb2ea86f35',	'/Meas Dore-b6dbc8b7-8f90-4910-9472-ddcb2ea86f35.JPG',	'354756',	1215,	1824,	'JPG',	0,	0,	0,	0,	0,	'2023-05-19 15:34:42',	'2023-05-19 15:35:01',	'2023-05-19 15:35:01'),
(59,	8,	NULL,	'Meas Dore-902a1dee-b7ea-45a2-a25c-669c074dea32',	'/Meas Dore-902a1dee-b7ea-45a2-a25c-669c074dea32.JPG',	'471317',	1586,	1824,	'JPG',	0,	0,	0,	0,	0,	'2023-05-19 15:37:15',	'2023-05-19 15:37:15',	NULL),
(60,	8,	NULL,	'16-មិថុនា-20-95627516-970f-4066-8928-d17cc98bc369',	'/16-មិថុនា-20-95627516-970f-4066-8928-d17cc98bc369.jpg',	'198350',	1155,	866,	'jpg',	0,	1,	0,	0,	0,	'2023-05-19 19:42:28',	'2023-05-19 19:42:28',	NULL),
(61,	8,	NULL,	'12-មិថុនា-20-ccc0592e-b6ce-462a-b60b-e4057e24638c',	'/12-មិថុនា-20-ccc0592e-b6ce-462a-b60b-e4057e24638c.jpg',	'198509',	1155,	866,	'jpg',	0,	1,	0,	0,	0,	'2023-05-19 20:28:24',	'2023-05-19 20:28:24',	NULL),
(62,	8,	NULL,	'24-មីថុនា-20-428e6016-e59a-4ba2-8709-0772d50b921c',	'/24-មីថុនា-20-428e6016-e59a-4ba2-8709-0772d50b921c.jpg',	'100040',	1080,	810,	'jpg',	0,	1,	0,	0,	0,	'2023-05-19 20:50:59',	'2023-05-19 20:50:59',	NULL),
(63,	8,	NULL,	'01-02-07-20-3a30b042-cd1d-4af4-bb7a-5473164153da',	'/01-02-07-20-3a30b042-cd1d-4af4-bb7a-5473164153da.jpg',	'198531',	1155,	1155,	'jpg',	0,	1,	0,	0,	0,	'2023-05-19 20:56:49',	'2023-05-19 20:56:49',	NULL),
(64,	8,	NULL,	'29-30 -06-20-04b736b0-b3aa-46c7-8ed9-40046d58117d',	'/29-30 -06-20-04b736b0-b3aa-46c7-8ed9-40046d58117d.jpg',	'129068',	1080,	810,	'jpg',	0,	1,	0,	0,	0,	'2023-05-20 13:57:32',	'2023-05-20 13:57:32',	NULL),
(65,	8,	NULL,	'10-07-20-b83dd1c6-4f55-4770-b32a-a97fab3cb4c6',	'/10-07-20-b83dd1c6-4f55-4770-b32a-a97fab3cb4c6.jpg',	'123393',	1080,	810,	'jpg',	0,	1,	0,	0,	0,	'2023-05-20 17:46:16',	'2023-05-20 17:46:16',	NULL),
(66,	8,	NULL,	'29-30 -06-20-7bfc3a1b-5113-4cdc-aa6f-51e9868b3e7f',	'/29-30 -06-20-7bfc3a1b-5113-4cdc-aa6f-51e9868b3e7f.jpg',	'129068',	1080,	810,	'jpg',	0,	1,	0,	0,	0,	'2023-05-20 17:49:12',	'2023-05-20 17:49:12',	NULL),
(67,	8,	NULL,	'29-30 -06-20-eb2dc80b-f3fb-4f1c-8154-0e248af0a2ea',	'/29-30 -06-20-eb2dc80b-f3fb-4f1c-8154-0e248af0a2ea.jpg',	'129068',	1080,	810,	'jpg',	0,	1,	0,	0,	0,	'2023-05-22 20:31:32',	'2023-05-22 20:31:32',	NULL),
(68,	8,	NULL,	'16-07-20-3ce2af76-8727-4f73-b5eb-b37372ab2ecd',	'/16-07-20-3ce2af76-8727-4f73-b5eb-b37372ab2ecd.jpg',	'113933',	1080,	810,	'jpg',	0,	1,	0,	0,	0,	'2023-05-24 15:08:46',	'2023-05-24 15:08:46',	NULL),
(69,	8,	NULL,	'20-07-20-3676422c-240a-4d1b-b3a9-15afedab1409',	'/20-07-20-3676422c-240a-4d1b-b3a9-15afedab1409.jpg',	'117128',	1080,	810,	'jpg',	0,	1,	0,	0,	0,	'2023-05-24 15:14:04',	'2023-05-24 15:14:04',	NULL),
(71,	8,	NULL,	'Pen Dara-be4043a5-5936-4d64-b692-2a4ccc18ebfb',	'/Pen Dara-be4043a5-5936-4d64-b692-2a4ccc18ebfb.jpg',	'143785',	843,	925,	'jpg',	0,	1,	0,	0,	0,	'2023-05-30 13:19:53',	'2023-05-30 13:19:53',	NULL),
(72,	8,	NULL,	'Open day  បច្ចេកទេសហាយឡាយអោយត្រូវស្តង់ដារ-537bef13-9a7b-4202-9719-138b79161c0d',	'/Open day  បច្ចេកទេសហាយឡាយអោយត្រូវស្តង់ដារ-537bef13-9a7b-4202-9719-138b79161c0d.jpg',	'205461',	1155,	1155,	'jpg',	0,	1,	0,	0,	0,	'2023-06-06 19:05:43',	'2023-06-06 19:05:43',	NULL),
(73,	8,	NULL,	'Por (Hight Light)-d16e8d74-dcad-4407-894f-e8370137d615',	'/Por (Hight Light)-d16e8d74-dcad-4407-894f-e8370137d615.jpg',	'53560',	960,	540,	'jpg',	0,	1,	0,	0,	0,	'2023-06-06 19:32:29',	'2023-06-06 19:32:29',	NULL),
(74,	8,	NULL,	'Open day តោះបង្កើនចំណេះដឺងលើ របៀបថែរក្សាសក់រួញ និងសក់ទឹករលក!!!-13295df8-0c59-4366-b0b9-d303248499ae',	'/Open day តោះបង្កើនចំណេះដឺងលើ របៀបថែរក្សាសក់រួញ និងសក់ទឹករលក!!!-13295df8-0c59-4366-b0b9-d303248499ae.jpg',	'198530',	1155,	866,	'jpg',	0,	1,	0,	0,	0,	'2023-06-06 19:42:03',	'2023-06-06 19:42:03',	NULL),
(75,	8,	NULL,	'Leekaja-3077e031-e0ad-40b5-bb18-fd073ab9a873',	'/Leekaja-3077e031-e0ad-40b5-bb18-fd073ab9a873.jpg',	'117130',	1172,	876,	'jpg',	0,	1,	0,	0,	0,	'2023-06-06 19:44:40',	'2023-06-06 19:44:40',	NULL),
(76,	8,	NULL,	'Neak Beauty Salon-5edeccc1-8a84-4ea5-8c0e-98130c9bccc5',	'/Neak Beauty Salon-5edeccc1-8a84-4ea5-8c0e-98130c9bccc5.jpg',	'7011',	200,	200,	'jpg',	0,	1,	0,	0,	0,	'2023-06-06 19:53:44',	'2023-06-06 19:53:44',	NULL),
(77,	8,	NULL,	'Salon Management  ការចាប់ផ្តើមនិងរៀបចំអាជីវកម្មសាឡនឲ្យបានល្អប្រសើរនិងនិរន្តភាព-ddb57fca-c756-489b-9e9f-8da22c907875',	'/Salon Management  ការចាប់ផ្តើមនិងរៀបចំអាជីវកម្មសាឡនឲ្យបានល្អប្រសើរនិងនិរន្តភាព-ddb57fca-c756-489b-9e9f-8da22c907875.jpg',	'198527',	1155,	1155,	'jpg',	0,	1,	0,	0,	0,	'2023-06-06 19:56:08',	'2023-06-06 19:56:08',	NULL),
(78,	8,	NULL,	'Pro Store-6cf0fda4-9527-469d-a426-24c00aacf520',	'/Pro Store-6cf0fda4-9527-469d-a426-24c00aacf520.jpg',	'87920',	1920,	1920,	'jpg',	0,	1,	0,	0,	0,	'2023-06-06 19:59:06',	'2023-06-06 19:59:06',	NULL),
(79,	8,	NULL,	'Seven Boutique-eb46699e-bd77-4446-98f7-de6e78665050',	'/Seven Boutique-eb46699e-bd77-4446-98f7-de6e78665050.jpg',	'39998',	476,	697,	'jpg',	0,	1,	0,	0,	0,	'2023-06-06 20:42:01',	'2023-06-06 20:42:01',	NULL),
(80,	8,	NULL,	'ASK  #មលដ្ឋានគ្រឹះក្នុងការកាត់សក់បុរស-7b0361bd-abb6-4ee5-97f8-609edcc0ce05',	'/ASK  #មលដ្ឋានគ្រឹះក្នុងការកាត់សក់បុរស-7b0361bd-abb6-4ee5-97f8-609edcc0ce05.jpg',	'143872',	925,	693,	'jpg',	0,	1,	0,	0,	0,	'2023-06-06 20:42:35',	'2023-06-06 20:43:05',	'2023-06-06 20:43:05'),
(81,	8,	NULL,	'photo_2023-06-06_16-42-59-ac840730-34ff-4bcd-8895-9929031e4554',	'/photo_2023-06-06_16-42-59-ac840730-34ff-4bcd-8895-9929031e4554.jpg',	'143872',	925,	693,	'jpg',	0,	1,	0,	0,	0,	'2023-06-06 20:43:13',	'2023-06-06 20:43:13',	NULL),
(82,	8,	NULL,	'Rose\'s Style Design Salon-a3dbf353-a168-43bc-b0fe-0cc26c35d2d9',	'/Rose\'s Style Design Salon-a3dbf353-a168-43bc-b0fe-0cc26c35d2d9.jpg',	'108340',	1920,	1920,	'jpg',	0,	1,	0,	0,	0,	'2023-06-06 20:50:18',	'2023-06-06 20:50:18',	NULL),
(83,	8,	NULL,	'Rady salon-1e30a094-d4a8-44ee-a840-ee86a856a8da',	'/Rady salon-1e30a094-d4a8-44ee-a840-ee86a856a8da.jpg',	'325500',	1234,	1645,	'jpg',	0,	1,	0,	0,	0,	'2023-06-06 20:56:25',	'2023-06-06 20:56:25',	NULL),
(84,	8,	NULL,	'Por Por Salon-b46d5965-1743-4bde-b603-0fdb4c9bff66',	'/Por Por Salon-b46d5965-1743-4bde-b603-0fdb4c9bff66.jpg',	'115065',	1350,	513,	'jpg',	0,	1,	0,	0,	0,	'2023-06-06 20:58:27',	'2023-06-06 20:58:27',	NULL),
(85,	8,	NULL,	'Best Beauty Salon-5ffd8ab1-f141-41ff-baf5-6961aaf02584',	'/Best Beauty Salon-5ffd8ab1-f141-41ff-baf5-6961aaf02584.jpg',	'56031',	960,	954,	'jpg',	0,	1,	0,	0,	0,	'2023-06-06 21:00:11',	'2023-06-06 21:00:11',	NULL),
(86,	8,	NULL,	'Hong New York Hair Salon-052c4efd-7ab3-4aaf-8211-a37529e40553',	'/Hong New York Hair Salon-052c4efd-7ab3-4aaf-8211-a37529e40553.jpg',	'13738',	338,	338,	'jpg',	0,	1,	0,	0,	0,	'2023-06-07 13:22:36',	'2023-06-07 13:22:36',	NULL),
(87,	8,	NULL,	'photo_2023-06-07_11-13-12-01db8253-2fcf-49b3-8d78-9947305b439c',	'/photo_2023-06-07_11-13-12-01db8253-2fcf-49b3-8d78-9947305b439c.jpg',	'202881',	1155,	866,	'jpg',	0,	1,	0,	0,	0,	'2023-06-07 15:14:45',	'2023-06-07 15:14:45',	NULL),
(88,	8,	NULL,	'photo_2023-06-07_11-16-01-722b6cd5-bde1-496f-b651-497741d9bb6d',	'/photo_2023-06-07_11-16-01-722b6cd5-bde1-496f-b651-497741d9bb6d.jpg',	'211805',	1155,	866,	'jpg',	0,	1,	0,	0,	0,	'2023-06-07 15:16:13',	'2023-06-07 15:16:13',	NULL),
(89,	8,	NULL,	'photo_2023-06-07_11-19-30-4d2e29c4-1dce-4dfe-bdca-e14d9efd2f08',	'/photo_2023-06-07_11-19-30-4d2e29c4-1dce-4dfe-bdca-e14d9efd2f08.jpg',	'221091',	1155,	866,	'jpg',	0,	1,	0,	0,	0,	'2023-06-07 15:20:41',	'2023-06-07 15:20:41',	NULL),
(90,	8,	NULL,	'photo_2023-06-07_11-22-17-8cff8489-c7c6-4244-9456-3dace4c05542',	'/photo_2023-06-07_11-22-17-8cff8489-c7c6-4244-9456-3dace4c05542.jpg',	'222929',	1155,	866,	'jpg',	0,	1,	0,	0,	0,	'2023-06-07 15:23:41',	'2023-06-07 15:23:41',	NULL),
(91,	8,	NULL,	'photo_2023-06-07_11-25-51-1cdb4da7-b9c0-4f68-9935-3d47f2400d44',	'/photo_2023-06-07_11-25-51-1cdb4da7-b9c0-4f68-9935-3d47f2400d44.jpg',	'129293',	1080,	810,	'jpg',	0,	1,	0,	0,	0,	'2023-06-07 15:26:05',	'2023-06-07 15:26:05',	NULL),
(92,	8,	NULL,	'photo_2023-06-07_11-27-08-5db31e4c-ef2f-4c0c-9398-09422cb1ef74',	'/photo_2023-06-07_11-27-08-5db31e4c-ef2f-4c0c-9398-09422cb1ef74.jpg',	'200699',	1280,	960,	'jpg',	0,	1,	0,	0,	0,	'2023-06-07 15:27:36',	'2023-06-07 15:27:36',	NULL),
(93,	8,	NULL,	'photo_2023-06-07_11-30-54-bd29d663-020b-4b30-b3a7-f4b3f7a9f129',	'/photo_2023-06-07_11-30-54-bd29d663-020b-4b30-b3a7-f4b3f7a9f129.jpg',	'97751',	878,	875,	'jpg',	0,	1,	0,	0,	0,	'2023-06-07 15:31:02',	'2023-06-07 15:31:02',	NULL),
(94,	8,	NULL,	'photo_2023-06-07_11-44-01-87dadcc8-277e-4c67-a4b6-4be38979561c',	'/photo_2023-06-07_11-44-01-87dadcc8-277e-4c67-a4b6-4be38979561c.jpg',	'223790',	1155,	866,	'jpg',	0,	1,	0,	0,	0,	'2023-06-07 15:44:13',	'2023-06-07 15:44:13',	NULL),
(95,	8,	NULL,	'Singapore Salon-04dee550-51bc-44c8-bb92-6ffbacc07d4b',	'/Singapore Salon-04dee550-51bc-44c8-bb92-6ffbacc07d4b.jpg',	'307318',	1234,	1645,	'jpg',	0,	1,	0,	0,	0,	'2023-06-07 17:27:44',	'2023-06-07 17:27:44',	NULL),
(96,	8,	NULL,	'Polin Salon Eyelash and Nail-c2c20c1e-00f9-48d5-8166-a8e9928a1682',	'/Polin Salon Eyelash and Nail-c2c20c1e-00f9-48d5-8166-a8e9928a1682.jpg',	'102112',	960,	539,	'jpg',	0,	1,	0,	0,	0,	'2023-06-08 15:06:24',	'2023-06-08 15:06:24',	NULL),
(97,	8,	NULL,	'A Plus Salon-2f4c3a53-95da-46e8-8f32-fc20d996dc17',	'/A Plus Salon-2f4c3a53-95da-46e8-8f32-fc20d996dc17.jpg',	'411498',	1515,	1645,	'jpg',	0,	1,	0,	0,	0,	'2023-06-08 15:08:52',	'2023-06-08 15:08:52',	NULL),
(98,	8,	NULL,	'De1 Salon By Vid &PK-ef2020bf-09f0-41f9-96cf-5c1c233d8dd9',	'/De1 Salon By Vid &PK-ef2020bf-09f0-41f9-96cf-5c1c233d8dd9.jpg',	'67013',	1920,	1920,	'jpg',	0,	1,	0,	0,	0,	'2023-06-08 15:11:40',	'2023-06-08 15:11:40',	NULL),
(99,	8,	NULL,	'La Boutique Salon-2f3fb873-3e24-4bdd-a512-2d1bcdf476fc',	'/La Boutique Salon-2f3fb873-3e24-4bdd-a512-2d1bcdf476fc.jpg',	'102786',	1458,	640,	'jpg',	0,	1,	0,	0,	0,	'2023-06-08 15:13:37',	'2023-06-08 15:13:37',	NULL),
(100,	8,	NULL,	'Moon Light-dc2ebb2d-503b-47bf-80ec-fbdc54bdc034',	'/Moon Light-dc2ebb2d-503b-47bf-80ec-fbdc54bdc034.jpg',	'7324',	320,	320,	'jpg',	0,	1,	0,	0,	0,	'2023-06-08 15:15:47',	'2023-06-08 15:15:47',	NULL),
(101,	8,	NULL,	'Kanatya Beauty Center-a09c646d-a6d6-4157-a88b-b088431beed3',	'/Kanatya Beauty Center-a09c646d-a6d6-4157-a88b-b088431beed3.jpg',	'68675',	1440,	960,	'jpg',	0,	1,	0,	0,	0,	'2023-06-08 15:27:03',	'2023-06-08 15:27:03',	NULL),
(102,	8,	NULL,	'Belyna Spa & Salon-0f7d83cd-6ac3-40e6-a377-9ecd54fc6ef5',	'/Belyna Spa & Salon-0f7d83cd-6ac3-40e6-a377-9ecd54fc6ef5.jpg',	'131324',	1458,	640,	'jpg',	0,	1,	0,	0,	0,	'2023-06-08 15:37:41',	'2023-06-08 15:37:41',	NULL),
(103,	8,	NULL,	'KBS Beauty Salon-d754df71-c649-4334-a042-275caab9011a',	'/KBS Beauty Salon-d754df71-c649-4334-a042-275caab9011a.jpg',	'131788',	850,	314,	'jpg',	0,	1,	0,	0,	0,	'2023-06-08 15:38:49',	'2023-06-08 15:38:49',	NULL),
(104,	8,	NULL,	'Nuon House Of Beauty-62fa8c26-8ca3-4021-9d10-afcc8753bd90',	'/Nuon House Of Beauty-62fa8c26-8ca3-4021-9d10-afcc8753bd90.jpg',	'177874',	692,	866,	'jpg',	0,	1,	0,	0,	0,	'2023-06-08 15:43:26',	'2023-06-08 15:43:26',	NULL),
(105,	8,	NULL,	'M Salon & Spa  SP-fd7d9b4e-2868-44b5-9b89-66f2b80d11e9',	'/M Salon & Spa  SP-fd7d9b4e-2868-44b5-9b89-66f2b80d11e9.jpg',	'114076',	1440,	960,	'jpg',	0,	1,	0,	0,	0,	'2023-06-08 15:45:26',	'2023-06-08 15:45:26',	NULL),
(106,	8,	NULL,	'Nuy Nuy Salon-8a23ba3e-9836-4329-a4e9-949fac25b04e',	'/Nuy Nuy Salon-8a23ba3e-9836-4329-a4e9-949fac25b04e.jpg',	'224762',	754,	1645,	'jpg',	0,	1,	0,	0,	0,	'2023-06-08 15:47:17',	'2023-06-08 15:47:17',	NULL),
(107,	8,	NULL,	'Heja Salon-1acb1363-dba8-4e1b-8e7e-254f6dc4ab88',	'/Heja Salon-1acb1363-dba8-4e1b-8e7e-254f6dc4ab88.jpg',	'35416',	1087,	1087,	'jpg',	0,	1,	0,	0,	0,	'2023-06-08 15:49:56',	'2023-06-08 15:49:56',	NULL),
(108,	8,	NULL,	'Lovish Salon-f2e9d899-1141-4f01-aca9-be041d93254a',	'/Lovish Salon-f2e9d899-1141-4f01-aca9-be041d93254a.jpg',	'109024',	1645,	1644,	'jpg',	0,	1,	0,	0,	0,	'2023-06-08 17:45:28',	'2023-06-08 17:45:28',	NULL),
(109,	8,	NULL,	'Vin Phea Hair & Nail Salon-6a7bfc71-665f-476b-b341-f8e4e17d036f',	'/Vin Phea Hair & Nail Salon-6a7bfc71-665f-476b-b341-f8e4e17d036f.jpg',	'392155',	1645,	1234,	'jpg',	0,	1,	0,	0,	0,	'2023-06-08 17:49:38',	'2023-06-08 17:49:38',	NULL),
(110,	8,	NULL,	'Judy Salon-7aa83a77-350a-4957-8b46-6f6e45c4d278',	'/Judy Salon-7aa83a77-350a-4957-8b46-6f6e45c4d278.jpg',	'27004',	732,	732,	'jpg',	0,	1,	0,	0,	0,	'2023-06-08 17:52:32',	'2023-06-08 17:52:32',	NULL),
(111,	8,	NULL,	'Samatha Salon-a354356b-36e9-48c1-bab3-d0611e6c716f',	'/Samatha Salon-a354356b-36e9-48c1-bab3-d0611e6c716f.jpg',	'500586',	1824,	1215,	'jpg',	0,	1,	0,	0,	0,	'2023-06-08 19:10:08',	'2023-06-08 19:10:08',	NULL),
(112,	8,	NULL,	'Vivorn New-17c51094-2c2c-4279-89c6-2fa64fee40a9',	'/Vivorn New-17c51094-2c2c-4279-89c6-2fa64fee40a9.jpg',	'50066',	828,	828,	'jpg',	0,	1,	0,	0,	0,	'2023-06-08 19:15:57',	'2023-06-08 19:15:57',	NULL),
(113,	8,	NULL,	'P1 salon-cec1c0e6-4df5-4928-9b56-f86da55d10cb',	'/P1 salon-cec1c0e6-4df5-4928-9b56-f86da55d10cb.jpg',	'157227',	821,	821,	'jpg',	0,	1,	0,	0,	0,	'2023-06-08 19:25:20',	'2023-06-08 19:25:20',	NULL),
(114,	8,	NULL,	'Meet Salon-663d28e3-c529-44cd-b8e7-ed7d76448fdd',	'/Meet Salon-663d28e3-c529-44cd-b8e7-ed7d76448fdd.png',	'220891',	545,	341,	'png',	0,	1,	0,	0,	0,	'2023-06-08 19:33:33',	'2023-06-08 19:33:33',	NULL),
(115,	8,	NULL,	'Sonita Salon-433c1a42-9b64-47a9-9254-5150f9233eb8',	'/Sonita Salon-433c1a42-9b64-47a9-9254-5150f9233eb8.jpg',	'134981',	1275,	547,	'jpg',	0,	1,	0,	0,	0,	'2023-06-08 19:36:59',	'2023-06-08 19:36:59',	NULL),
(116,	8,	NULL,	'Oh Oh 57 Salon-0ee5faf9-bead-4a2c-ad21-f4f228cf4b0c',	'/Oh Oh 57 Salon-0ee5faf9-bead-4a2c-ad21-f4f228cf4b0c.jpg',	'357402',	1645,	1096,	'jpg',	0,	1,	0,	0,	0,	'2023-06-08 19:42:08',	'2023-06-08 19:42:08',	NULL),
(117,	8,	NULL,	'Vichea Beauty & Salon-be886c8b-0637-482d-882c-4097a47c3ee5',	'/Vichea Beauty & Salon-be886c8b-0637-482d-882c-4097a47c3ee5.jpg',	'50043',	959,	960,	'jpg',	0,	1,	0,	0,	0,	'2023-06-08 19:59:49',	'2023-06-08 19:59:49',	NULL),
(118,	8,	NULL,	'Hair Maison-299e6f99-5e9b-4671-8347-c9f4fa939628',	'/Hair Maison-299e6f99-5e9b-4671-8347-c9f4fa939628.jpg',	'243757',	1645,	925,	'jpg',	0,	1,	0,	0,	0,	'2023-06-09 13:27:21',	'2023-06-09 13:27:21',	NULL),
(119,	8,	NULL,	'P5 Salon & Barber-1df2ac25-8afa-4497-b531-16a8501a7880',	'/P5 Salon & Barber-1df2ac25-8afa-4497-b531-16a8501a7880.jpg',	'163803',	1042,	1042,	'jpg',	0,	1,	0,	0,	0,	'2023-06-09 13:34:14',	'2023-06-09 13:34:14',	NULL),
(120,	8,	NULL,	'Hang Beauty & Collection-c6e7f94b-140f-4bbc-8557-86378ef528f3',	'/Hang Beauty & Collection-c6e7f94b-140f-4bbc-8557-86378ef528f3.jpg',	'278063',	1732,	974,	'jpg',	0,	1,	0,	0,	0,	'2023-06-09 13:36:50',	'2023-06-09 13:36:50',	NULL),
(121,	8,	NULL,	'photo_2023-06-10_13-42-29-a90d060e-e58f-40dd-b323-4267e7dbe0af',	'/photo_2023-06-10_13-42-29-a90d060e-e58f-40dd-b323-4267e7dbe0af.jpg',	'223497',	1155,	866,	'jpg',	0,	1,	0,	0,	0,	'2023-06-10 17:43:29',	'2023-06-10 17:43:29',	NULL),
(122,	8,	NULL,	'photo_2023-06-10_13-45-21-6bd6985b-b532-4892-9316-1362fa459cfc',	'/photo_2023-06-10_13-45-21-6bd6985b-b532-4892-9316-1362fa459cfc.jpg',	'184887',	1155,	866,	'jpg',	0,	1,	0,	0,	0,	'2023-06-10 17:46:23',	'2023-06-10 17:46:23',	NULL),
(123,	8,	NULL,	'photo_2023-06-10_13-50-02-725ae154-de3a-4320-84a0-cbe18a2b4f41',	'/photo_2023-06-10_13-50-02-725ae154-de3a-4320-84a0-cbe18a2b4f41.jpg',	'122234',	1080,	810,	'jpg',	0,	1,	0,	0,	0,	'2023-06-10 17:51:16',	'2023-06-10 17:51:16',	NULL),
(124,	8,	NULL,	'photo_2023-06-10_13-53-00-2c3c67ff-bed4-4a94-8fba-299265c1f7ba',	'/photo_2023-06-10_13-53-00-2c3c67ff-bed4-4a94-8fba-299265c1f7ba.jpg',	'213805',	1155,	866,	'jpg',	0,	1,	0,	0,	0,	'2023-06-10 17:53:38',	'2023-06-10 17:53:38',	NULL),
(125,	8,	NULL,	'photo_2023-06-10_13-57-05-54e9e663-29f9-4c07-8ea6-415d7ba85f29',	'/photo_2023-06-10_13-57-05-54e9e663-29f9-4c07-8ea6-415d7ba85f29.jpg',	'217483',	1155,	866,	'jpg',	0,	1,	0,	0,	0,	'2023-06-10 17:57:30',	'2023-06-10 17:57:30',	NULL),
(126,	8,	NULL,	'photo_2023-06-10_14-00-03-88b89287-58bf-416a-a4a3-f5f69926b7bd',	'/photo_2023-06-10_14-00-03-88b89287-58bf-416a-a4a3-f5f69926b7bd.jpg',	'213805',	1155,	866,	'jpg',	0,	1,	0,	0,	0,	'2023-06-10 18:00:23',	'2023-06-10 18:00:23',	NULL),
(127,	8,	NULL,	'photo_2023-06-10_14-03-29-20820be5-a6a4-4203-ac42-f48eb6ab8584',	'/photo_2023-06-10_14-03-29-20820be5-a6a4-4203-ac42-f48eb6ab8584.jpg',	'123872',	1080,	810,	'jpg',	0,	1,	0,	0,	0,	'2023-06-10 18:03:48',	'2023-06-10 18:03:48',	NULL),
(128,	8,	NULL,	'photo_2023-06-12_10-37-45-bfa6b0f4-31a8-4f7f-880a-422507553c84',	'/photo_2023-06-12_10-37-45-bfa6b0f4-31a8-4f7f-880a-422507553c84.jpg',	'106703',	1080,	810,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 14:38:11',	'2023-06-12 14:38:11',	NULL),
(129,	8,	NULL,	'photo_2023-06-12_10-48-40-7bc6d95d-ec76-4d83-90e1-5e517f1d9ed4',	'/photo_2023-06-12_10-48-40-7bc6d95d-ec76-4d83-90e1-5e517f1d9ed4.jpg',	'120812',	1080,	810,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 14:49:08',	'2023-06-12 14:49:08',	NULL),
(130,	8,	NULL,	'photo_2023-06-12_10-52-54-7dc6d6e8-9eec-48a2-9527-bada7710f5df',	'/photo_2023-06-12_10-52-54-7dc6d6e8-9eec-48a2-9527-bada7710f5df.jpg',	'205488',	1155,	866,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 14:53:10',	'2023-06-12 14:53:10',	NULL),
(131,	8,	NULL,	'photo_2023-06-12_10-59-53-8828b057-33e7-490a-9a65-d2501fcaf09b',	'/photo_2023-06-12_10-59-53-8828b057-33e7-490a-9a65-d2501fcaf09b.jpg',	'161528',	1097,	822,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 15:00:10',	'2023-06-12 15:00:10',	NULL),
(132,	8,	NULL,	'photo_2023-06-12_11-01-35-5be7cceb-7f39-4cf2-8e6e-06282d692118',	'/photo_2023-06-12_11-01-35-5be7cceb-7f39-4cf2-8e6e-06282d692118.jpg',	'161738',	1097,	822,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 15:01:53',	'2023-06-12 15:01:53',	NULL),
(133,	8,	NULL,	'photo_2023-06-12_11-03-47-0d6051cc-749a-4b88-a0d3-806309506033',	'/photo_2023-06-12_11-03-47-0d6051cc-749a-4b88-a0d3-806309506033.jpg',	'116133',	1080,	810,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 15:04:01',	'2023-06-12 15:04:01',	NULL),
(134,	8,	NULL,	'photo_2023-06-12_11-09-00-ced4ef4d-22cd-4a45-90f0-8aad661a172e',	'/photo_2023-06-12_11-09-00-ced4ef4d-22cd-4a45-90f0-8aad661a172e.jpg',	'109565',	878,	875,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 15:09:14',	'2023-06-12 15:09:14',	NULL),
(135,	8,	NULL,	'photo_2023-06-12_11-11-43-50e27f6d-bc5c-49d5-9271-4abd0b1db86f',	'/photo_2023-06-12_11-11-43-50e27f6d-bc5c-49d5-9271-4abd0b1db86f.jpg',	'94817',	1080,	810,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 15:12:07',	'2023-06-12 15:12:07',	NULL),
(136,	8,	NULL,	'photo_2023-06-07_11-25-51-0460127d-bfad-4e13-81d0-db20663baa78',	'/photo_2023-06-07_11-25-51-0460127d-bfad-4e13-81d0-db20663baa78.jpg',	'129293',	1080,	810,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 15:15:04',	'2023-06-12 15:15:04',	NULL),
(137,	8,	NULL,	'photo_2023-06-12_11-17-54-e325a141-edd7-4241-92e9-2d02c5ffa653',	'/photo_2023-06-12_11-17-54-e325a141-edd7-4241-92e9-2d02c5ffa653.jpg',	'118212',	1080,	810,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 15:18:12',	'2023-06-12 15:18:12',	NULL),
(138,	8,	NULL,	'photo_2023-06-12_11-19-53-31e16552-c6f9-4810-bf67-560d92fc01c4',	'/photo_2023-06-12_11-19-53-31e16552-c6f9-4810-bf67-560d92fc01c4.jpg',	'165262',	1280,	960,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 15:20:13',	'2023-06-12 15:20:13',	NULL),
(139,	8,	NULL,	'photo_2023-06-12_11-21-55-6c1c3bfb-397d-4d73-bc97-7ec397a602b5',	'/photo_2023-06-12_11-21-55-6c1c3bfb-397d-4d73-bc97-7ec397a602b5.jpg',	'166627',	1280,	960,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 15:22:23',	'2023-06-12 15:22:23',	NULL),
(140,	8,	NULL,	'photo_2023-06-12_11-27-37-82535a77-23e3-48f4-8bb6-0f492ccc1a7d',	'/photo_2023-06-12_11-27-37-82535a77-23e3-48f4-8bb6-0f492ccc1a7d.jpg',	'172431',	1280,	960,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 15:27:59',	'2023-06-12 15:27:59',	NULL),
(141,	8,	NULL,	'photo_2023-06-12_11-30-29-9a777587-4211-445d-990b-3daa90cfff30',	'/photo_2023-06-12_11-30-29-9a777587-4211-445d-990b-3daa90cfff30.jpg',	'89710',	940,	788,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 15:30:38',	'2023-06-12 15:30:38',	NULL),
(142,	8,	NULL,	'photo_2023-06-12_11-31-50-25824701-a6dc-46b2-b939-206974927f33',	'/photo_2023-06-12_11-31-50-25824701-a6dc-46b2-b939-206974927f33.jpg',	'125823',	1139,	931,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 15:32:01',	'2023-06-12 15:32:01',	NULL),
(143,	8,	NULL,	'photo_2023-06-12_13-22-44-0a17e2d5-79c7-4e50-9c5a-44faa586148e',	'/photo_2023-06-12_13-22-44-0a17e2d5-79c7-4e50-9c5a-44faa586148e.jpg',	'96174',	940,	788,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 17:23:09',	'2023-06-12 17:23:09',	NULL),
(144,	8,	NULL,	'photo_2023-06-12_13-25-54-309f4fce-5a38-4038-910c-bfe873c04e21',	'/photo_2023-06-12_13-25-54-309f4fce-5a38-4038-910c-bfe873c04e21.jpg',	'117514',	940,	788,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 17:26:11',	'2023-06-12 17:26:11',	NULL),
(145,	8,	NULL,	'photo_2023-06-12_13-27-42-1a8bb42a-fb26-44ba-9156-7d54e5b7901e',	'/photo_2023-06-12_13-27-42-1a8bb42a-fb26-44ba-9156-7d54e5b7901e.jpg',	'127922',	940,	788,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 17:27:59',	'2023-06-12 17:27:59',	NULL),
(146,	8,	NULL,	'photo_2023-06-12_13-29-17-fb24bd26-079e-4863-8206-74ad61f4ad25',	'/photo_2023-06-12_13-29-17-fb24bd26-079e-4863-8206-74ad61f4ad25.jpg',	'87080',	1080,	607,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 17:30:32',	'2023-06-12 17:30:32',	NULL),
(147,	8,	NULL,	'photo_2023-06-12_13-31-04-8ab728a1-0de5-4964-96cd-d11c558407c3',	'/photo_2023-06-12_13-31-04-8ab728a1-0de5-4964-96cd-d11c558407c3.jpg',	'117596',	940,	788,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 17:31:43',	'2023-06-12 17:31:43',	NULL),
(148,	8,	NULL,	'photo_2023-06-12_13-41-57-70d06a6f-e074-433f-b32c-37bef2fdf1e7',	'/photo_2023-06-12_13-41-57-70d06a6f-e074-433f-b32c-37bef2fdf1e7.jpg',	'138719',	1097,	1097,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 17:42:16',	'2023-06-12 17:42:16',	NULL),
(149,	8,	NULL,	'photo_2023-06-12_14-13-46-dd6b9572-3936-430e-8f81-9be6285ed08d',	'/photo_2023-06-12_14-13-46-dd6b9572-3936-430e-8f81-9be6285ed08d.jpg',	'91793',	1080,	607,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 18:13:57',	'2023-06-12 18:13:57',	NULL),
(150,	8,	NULL,	'photo_2023-06-12_14-18-10-0a67f2c4-33cc-4a36-9fcf-5eeb02c57cdb',	'/photo_2023-06-12_14-18-10-0a67f2c4-33cc-4a36-9fcf-5eeb02c57cdb.jpg',	'119742',	940,	788,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 18:19:43',	'2023-06-12 18:19:43',	NULL),
(151,	8,	NULL,	'photo_2023-06-12_14-46-18-bbf32c85-61c7-41a4-b0b3-451ad1ad96f1',	'/photo_2023-06-12_14-46-18-bbf32c85-61c7-41a4-b0b3-451ad1ad96f1.jpg',	'67258',	960,	540,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 18:46:44',	'2023-06-12 18:46:44',	NULL),
(152,	8,	NULL,	'photo_2023-06-12_14-51-09-d7083d07-cd49-4192-8d0c-a8558947743b',	'/photo_2023-06-12_14-51-09-d7083d07-cd49-4192-8d0c-a8558947743b.jpg',	'112765',	940,	788,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 18:51:59',	'2023-06-12 18:51:59',	NULL),
(153,	8,	NULL,	'photo_2023-06-12_14-59-00-5e4d7baa-119f-4847-a48c-f829ed2abc28',	'/photo_2023-06-12_14-59-00-5e4d7baa-119f-4847-a48c-f829ed2abc28.jpg',	'114040',	940,	788,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 18:59:55',	'2023-06-12 18:59:55',	NULL),
(154,	8,	NULL,	'photo_2023-06-12_15-12-53-035afdcb-c1c6-4889-aedd-8fec9b1a42b7',	'/photo_2023-06-12_15-12-53-035afdcb-c1c6-4889-aedd-8fec9b1a42b7.jpg',	'68615',	600,	503,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 19:14:03',	'2023-06-12 19:14:03',	NULL),
(155,	8,	NULL,	'photo_2023-06-12_15-15-05-4f8c8e52-89cb-4f7c-bdf2-907b88c0c585',	'/photo_2023-06-12_15-15-05-4f8c8e52-89cb-4f7c-bdf2-907b88c0c585.jpg',	'70741',	600,	503,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 19:15:18',	'2023-06-12 19:15:18',	NULL),
(156,	8,	NULL,	'photo_2023-06-12_15-16-15-bdaefb42-6c24-4c6b-92bc-b8a622552be1',	'/photo_2023-06-12_15-16-15-bdaefb42-6c24-4c6b-92bc-b8a622552be1.jpg',	'63590',	600,	503,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 19:16:36',	'2023-06-12 19:16:36',	NULL),
(157,	8,	NULL,	'photo_2023-06-12_15-17-35-9b5c1375-cb4c-43d8-bdcd-4a0d5413dfcf',	'/photo_2023-06-12_15-17-35-9b5c1375-cb4c-43d8-bdcd-4a0d5413dfcf.jpg',	'62636',	600,	503,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 19:17:45',	'2023-06-12 19:17:45',	NULL),
(158,	8,	NULL,	'photo_2023-06-12_15-18-48-032101b8-803f-433d-8946-04c87f917015',	'/photo_2023-06-12_15-18-48-032101b8-803f-433d-8946-04c87f917015.jpg',	'138765',	940,	788,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 19:19:05',	'2023-06-12 19:19:05',	NULL),
(159,	8,	NULL,	'photo_2023-06-12_15-23-34-04912570-5ce3-4810-ba8c-501d84e10876',	'/photo_2023-06-12_15-23-34-04912570-5ce3-4810-ba8c-501d84e10876.jpg',	'65924',	600,	503,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 19:24:19',	'2023-06-12 19:24:19',	NULL),
(160,	8,	NULL,	'photo_2023-06-12_16-13-24-728a68e3-c56d-4869-bd0f-c033fabd7e55',	'/photo_2023-06-12_16-13-24-728a68e3-c56d-4869-bd0f-c033fabd7e55.jpg',	'70676',	600,	503,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 20:13:38',	'2023-06-12 20:13:38',	NULL),
(161,	8,	NULL,	'photo_2023-06-12_16-13-24-025cb56f-cd11-44c6-9f0c-f0405c05eeb6',	'/photo_2023-06-12_16-13-24-025cb56f-cd11-44c6-9f0c-f0405c05eeb6.jpg',	'70676',	600,	503,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 20:16:00',	'2023-06-12 20:16:00',	NULL),
(162,	8,	NULL,	'photo_2023-06-12_16-15-48-9d322f83-5c85-4354-b39f-b557f67a6cd4',	'/photo_2023-06-12_16-15-48-9d322f83-5c85-4354-b39f-b557f67a6cd4.jpg',	'67802',	600,	503,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 20:16:18',	'2023-06-12 20:16:18',	NULL),
(163,	8,	NULL,	'photo_2023-06-12_16-25-12-95130113-e723-4dc8-aa5e-3a1e2cbe6bf8',	'/photo_2023-06-12_16-25-12-95130113-e723-4dc8-aa5e-3a1e2cbe6bf8.jpg',	'55841',	600,	503,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 20:25:40',	'2023-06-12 20:25:40',	NULL),
(164,	8,	NULL,	'photo_2023-06-12_16-28-08-1c47689b-19a3-463f-acd9-b26e0f08901c',	'/photo_2023-06-12_16-28-08-1c47689b-19a3-463f-acd9-b26e0f08901c.jpg',	'62928',	600,	503,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 20:29:41',	'2023-06-12 20:29:41',	NULL),
(165,	8,	NULL,	'photo_2023-06-12_16-30-48-3ed8d54d-85f1-4e5d-b540-6209aca146ae',	'/photo_2023-06-12_16-30-48-3ed8d54d-85f1-4e5d-b540-6209aca146ae.jpg',	'68983',	600,	503,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 20:30:57',	'2023-06-12 20:30:57',	NULL),
(166,	8,	NULL,	'photo_2023-06-12_16-45-16-55e8d989-2842-4388-8e61-578b2718b4a0',	'/photo_2023-06-12_16-45-16-55e8d989-2842-4388-8e61-578b2718b4a0.jpg',	'127076',	940,	788,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 20:45:47',	'2023-06-12 20:45:47',	NULL),
(167,	8,	NULL,	'photo_2023-06-12_16-50-49-2359647b-e655-4361-bc15-6d6404e1d139',	'/photo_2023-06-12_16-50-49-2359647b-e655-4361-bc15-6d6404e1d139.jpg',	'60882',	600,	503,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 20:51:21',	'2023-06-12 20:51:21',	NULL),
(168,	8,	NULL,	'photo_2023-06-12_16-54-07-2c9f80f9-ca7c-448e-bd9b-b911e73082ce',	'/photo_2023-06-12_16-54-07-2c9f80f9-ca7c-448e-bd9b-b911e73082ce.jpg',	'65639',	600,	503,	'jpg',	0,	1,	0,	0,	0,	'2023-06-12 20:54:27',	'2023-06-12 20:54:27',	NULL),
(169,	8,	NULL,	'photo_2023-06-13_09-31-29-10b4e1e8-3a3f-4a8b-9ad1-091e0ef219a0',	'/photo_2023-06-13_09-31-29-10b4e1e8-3a3f-4a8b-9ad1-091e0ef219a0.jpg',	'59509',	600,	503,	'jpg',	0,	1,	0,	0,	0,	'2023-06-13 13:32:39',	'2023-06-13 13:32:39',	NULL),
(170,	8,	NULL,	'photo_2023-06-13_09-31-29-169a160a-c5dc-4705-8900-ae8be4687700',	'/photo_2023-06-13_09-31-29-169a160a-c5dc-4705-8900-ae8be4687700.jpg',	'59509',	600,	503,	'jpg',	0,	1,	0,	0,	0,	'2023-06-13 13:34:34',	'2023-06-13 13:34:34',	NULL),
(171,	8,	NULL,	'photo_2023-06-13_09-35-47-cfb439c2-e25a-41ea-9a64-1e84c8919b67',	'/photo_2023-06-13_09-35-47-cfb439c2-e25a-41ea-9a64-1e84c8919b67.jpg',	'113792',	940,	788,	'jpg',	0,	1,	0,	0,	0,	'2023-06-13 13:36:42',	'2023-06-13 13:36:42',	NULL),
(172,	8,	NULL,	'photo_2023-06-13_09-38-05-2b6c5b45-1638-4c7b-ad01-9b05e348db4f',	'/photo_2023-06-13_09-38-05-2b6c5b45-1638-4c7b-ad01-9b05e348db4f.jpg',	'108975',	940,	788,	'jpg',	0,	1,	0,	0,	0,	'2023-06-13 13:38:54',	'2023-06-13 13:38:54',	NULL),
(173,	8,	NULL,	'photo_2023-06-13_09-48-44-e65b6e1b-9669-480b-8198-f62765a496b8',	'/photo_2023-06-13_09-48-44-e65b6e1b-9669-480b-8198-f62765a496b8.jpg',	'118703',	940,	788,	'jpg',	0,	1,	0,	0,	0,	'2023-06-13 13:49:11',	'2023-06-13 13:49:11',	NULL),
(174,	8,	NULL,	'photo_2023-06-13_09-48-44-0324e45f-fac8-4076-8550-6d93d0bff805',	'/photo_2023-06-13_09-48-44-0324e45f-fac8-4076-8550-6d93d0bff805.jpg',	'118703',	940,	788,	'jpg',	0,	1,	0,	0,	0,	'2023-06-13 14:04:11',	'2023-06-13 14:04:11',	NULL),
(175,	8,	NULL,	'photo_2023-06-13_10-12-01-148da8bb-7b74-402b-a575-fa5cdf19beff',	'/photo_2023-06-13_10-12-01-148da8bb-7b74-402b-a575-fa5cdf19beff.jpg',	'115224',	940,	788,	'jpg',	0,	1,	0,	0,	0,	'2023-06-13 14:12:29',	'2023-06-13 14:12:29',	NULL),
(176,	8,	NULL,	'photo_2023-06-13_10-16-24-aff8cd78-19a6-400d-afe6-4b3b76cc95a3',	'/photo_2023-06-13_10-16-24-aff8cd78-19a6-400d-afe6-4b3b76cc95a3.jpg',	'111806',	940,	788,	'jpg',	0,	1,	0,	0,	0,	'2023-06-13 14:16:51',	'2023-06-13 14:16:51',	NULL),
(177,	8,	NULL,	'photo_2023-06-13_10-21-00-d11c15ee-755b-43b6-8511-b88313071f32',	'/photo_2023-06-13_10-21-00-d11c15ee-755b-43b6-8511-b88313071f32.jpg',	'109698',	940,	788,	'jpg',	0,	1,	0,	0,	0,	'2023-06-13 14:21:27',	'2023-06-13 14:21:27',	NULL),
(178,	8,	NULL,	'photo_2023-06-13_10-24-17-55156ba2-36e5-4a2b-9911-efdde85c07e9',	'/photo_2023-06-13_10-24-17-55156ba2-36e5-4a2b-9911-efdde85c07e9.jpg',	'107198',	940,	788,	'jpg',	0,	1,	0,	0,	0,	'2023-06-13 14:24:51',	'2023-06-13 14:24:51',	NULL),
(179,	8,	NULL,	'photo_2023-06-13_10-26-53-db7657da-db0b-45ff-8dc9-3ef41cc515f1',	'/photo_2023-06-13_10-26-53-db7657da-db0b-45ff-8dc9-3ef41cc515f1.jpg',	'109103',	940,	788,	'jpg',	0,	1,	0,	0,	0,	'2023-06-13 14:27:03',	'2023-06-13 14:27:03',	NULL),
(180,	8,	NULL,	'photo_2023-06-13_10-29-46-65e2aaad-7230-4b04-b8fc-a9200f33461f',	'/photo_2023-06-13_10-29-46-65e2aaad-7230-4b04-b8fc-a9200f33461f.jpg',	'202446',	1155,	1155,	'jpg',	0,	1,	0,	0,	0,	'2023-06-13 14:30:13',	'2023-06-13 14:30:13',	NULL),
(181,	8,	NULL,	'photo_2023-06-13_10-31-34-275cb188-f27a-468a-9da4-e0156c9d5002',	'/photo_2023-06-13_10-31-34-275cb188-f27a-468a-9da4-e0156c9d5002.jpg',	'152622',	1097,	1097,	'jpg',	0,	1,	0,	0,	0,	'2023-06-13 14:32:04',	'2023-06-13 14:32:04',	NULL),
(182,	8,	NULL,	'photo_2023-06-13_10-31-27-cff65eab-b96a-426a-8901-22269c8cc6fc',	'/photo_2023-06-13_10-31-27-cff65eab-b96a-426a-8901-22269c8cc6fc.jpg',	'196467',	1155,	1155,	'jpg',	0,	1,	0,	0,	0,	'2023-06-13 14:33:35',	'2023-06-13 14:33:35',	NULL),
(183,	8,	NULL,	'photo_2023-06-13_10-35-27-b3741815-5bcf-48df-a83f-25a846e857b4',	'/photo_2023-06-13_10-35-27-b3741815-5bcf-48df-a83f-25a846e857b4.jpg',	'152622',	1097,	1097,	'jpg',	0,	1,	0,	0,	0,	'2023-06-13 14:35:51',	'2023-06-13 14:35:51',	NULL),
(184,	8,	NULL,	'photo_2023-06-13_10-36-40-b7070e3a-788d-4ce9-93cc-c0fb4d561d28',	'/photo_2023-06-13_10-36-40-b7070e3a-788d-4ce9-93cc-c0fb4d561d28.jpg',	'206536',	1155,	1155,	'jpg',	0,	1,	0,	0,	0,	'2023-06-13 14:37:01',	'2023-06-13 14:37:01',	NULL),
(185,	8,	NULL,	'photo_2023-06-13_10-39-47-8655724d-8c59-41be-beb8-4f965434301e',	'/photo_2023-06-13_10-39-47-8655724d-8c59-41be-beb8-4f965434301e.jpg',	'141859',	1097,	1097,	'jpg',	0,	1,	0,	0,	0,	'2023-06-13 14:40:26',	'2023-06-13 14:40:26',	NULL),
(186,	8,	NULL,	'photo_2023-06-13_10-48-55-c4490a85-1503-4255-a98c-c81f3a37f054',	'/photo_2023-06-13_10-48-55-c4490a85-1503-4255-a98c-c81f3a37f054.jpg',	'153611',	1280,	1280,	'jpg',	0,	1,	0,	0,	0,	'2023-06-13 14:50:16',	'2023-06-13 14:50:16',	NULL),
(187,	8,	NULL,	'photo_2023-06-13_11-09-11-32c906cf-151e-4bc5-ba90-0c90151d64ce',	'/photo_2023-06-13_11-09-11-32c906cf-151e-4bc5-ba90-0c90151d64ce.jpg',	'180322',	1155,	1155,	'jpg',	0,	1,	0,	0,	0,	'2023-06-13 15:09:28',	'2023-06-13 15:09:28',	NULL),
(188,	8,	NULL,	'photo_2023-06-13_11-13-45-bc95855f-4bc2-4586-aa86-c5885422a158',	'/photo_2023-06-13_11-13-45-bc95855f-4bc2-4586-aa86-c5885422a158.jpg',	'131357',	1097,	1097,	'jpg',	0,	1,	0,	0,	0,	'2023-06-13 15:14:13',	'2023-06-13 15:14:13',	NULL),
(189,	8,	NULL,	'photo_2023-06-13_15-42-50-31416867-8138-4cbb-a4e5-6eb40ac43b66',	'/photo_2023-06-13_15-42-50-31416867-8138-4cbb-a4e5-6eb40ac43b66.jpg',	'128328',	1096,	1097,	'jpg',	0,	1,	0,	0,	0,	'2023-06-13 19:43:12',	'2023-06-13 19:43:12',	NULL),
(190,	8,	NULL,	'photo_2023-06-17_09-36-30-67b24ff7-b73a-49a1-88cb-b7cb0dd592c4',	'/photo_2023-06-17_09-36-30-67b24ff7-b73a-49a1-88cb-b7cb0dd592c4.jpg',	'128328',	1096,	1097,	'jpg',	0,	1,	0,	0,	0,	'2023-06-17 13:37:21',	'2023-06-17 13:37:21',	NULL),
(191,	8,	NULL,	'photo_2023-06-17_09-39-16-4d23fa4f-6042-48b9-9dd4-85ed7e5c0f26',	'/photo_2023-06-17_09-39-16-4d23fa4f-6042-48b9-9dd4-85ed7e5c0f26.jpg',	'141691',	1280,	1280,	'jpg',	0,	1,	0,	0,	0,	'2023-06-17 13:39:48',	'2023-06-17 13:39:48',	NULL),
(192,	8,	NULL,	'photo_2023-06-17_09-41-12-a1e6d963-2a4f-4bfb-98e9-e20870476a9c',	'/photo_2023-06-17_09-41-12-a1e6d963-2a4f-4bfb-98e9-e20870476a9c.jpg',	'132335',	1096,	1097,	'jpg',	0,	1,	0,	0,	0,	'2023-06-17 13:41:23',	'2023-06-17 13:41:23',	NULL),
(193,	8,	NULL,	'photo_2023-06-17_09-49-32-02c1521b-d740-43be-a8a0-92d284c82311',	'/photo_2023-06-17_09-49-32-02c1521b-d740-43be-a8a0-92d284c82311.jpg',	'136215',	1097,	1097,	'jpg',	0,	1,	0,	0,	0,	'2023-06-17 13:50:03',	'2023-06-17 13:50:03',	NULL),
(194,	8,	NULL,	'photo_2023-06-17_09-54-26-4d81f295-10d9-4692-9444-a7ae227e9243',	'/photo_2023-06-17_09-54-26-4d81f295-10d9-4692-9444-a7ae227e9243.jpg',	'151378',	1280,	1280,	'jpg',	0,	1,	0,	0,	0,	'2023-06-17 13:54:55',	'2023-06-17 13:54:55',	NULL),
(195,	8,	NULL,	'photo_2023-06-17_10-05-49-554c4cde-0270-40a9-a5b9-126c0078b7b3',	'/photo_2023-06-17_10-05-49-554c4cde-0270-40a9-a5b9-126c0078b7b3.jpg',	'132821',	1279,	1280,	'jpg',	0,	1,	0,	0,	0,	'2023-06-17 14:06:25',	'2023-06-17 14:06:25',	NULL),
(196,	8,	NULL,	'photo_2023-06-17_10-15-03-e87d4bfa-79b3-4205-b613-168954ab1576',	'/photo_2023-06-17_10-15-03-e87d4bfa-79b3-4205-b613-168954ab1576.jpg',	'192848',	1155,	1155,	'jpg',	0,	1,	0,	0,	0,	'2023-06-17 14:15:54',	'2023-06-17 14:15:54',	NULL),
(197,	8,	NULL,	'photo_2023-06-17_10-18-33-4665a3a4-45a9-4206-a89d-01cf34da8c97',	'/photo_2023-06-17_10-18-33-4665a3a4-45a9-4206-a89d-01cf34da8c97.jpg',	'124404',	1096,	1097,	'jpg',	0,	1,	0,	0,	0,	'2023-06-17 14:18:52',	'2023-06-17 14:18:52',	NULL),
(198,	8,	NULL,	'photo_2023-06-17_10-19-13-473bf31a-9e10-4553-9f83-6903ab40b968',	'/photo_2023-06-17_10-19-13-473bf31a-9e10-4553-9f83-6903ab40b968.jpg',	'129066',	1096,	1097,	'jpg',	0,	1,	0,	0,	0,	'2023-06-17 14:21:53',	'2023-06-17 14:21:53',	NULL),
(199,	8,	NULL,	'photo_2023-06-17_10-26-13-757ce25a-404d-4975-89c2-cd9fdc546aa9',	'/photo_2023-06-17_10-26-13-757ce25a-404d-4975-89c2-cd9fdc546aa9.jpg',	'124404',	1096,	1097,	'jpg',	0,	1,	0,	0,	0,	'2023-06-17 14:26:36',	'2023-06-17 14:26:36',	NULL),
(200,	8,	NULL,	'photo_2023-06-17_10-29-56-e7cc70b5-5b98-4b56-b075-cf222c49aa42',	'/photo_2023-06-17_10-29-56-e7cc70b5-5b98-4b56-b075-cf222c49aa42.jpg',	'128391',	1097,	1097,	'jpg',	0,	1,	0,	0,	0,	'2023-06-17 14:30:12',	'2023-06-17 14:30:12',	NULL),
(201,	8,	NULL,	'photo_2023-06-17_10-33-53-1388f976-910c-4123-9bd9-54bd723dc44c',	'/photo_2023-06-17_10-33-53-1388f976-910c-4123-9bd9-54bd723dc44c.jpg',	'188367',	1154,	1155,	'jpg',	0,	1,	0,	0,	0,	'2023-06-17 14:48:01',	'2023-06-17 14:48:01',	NULL),
(202,	8,	NULL,	'photo_2023-06-17_10-50-57-0ae28438-1bda-4f02-bd92-32226de21021',	'/photo_2023-06-17_10-50-57-0ae28438-1bda-4f02-bd92-32226de21021.jpg',	'130246',	1097,	1097,	'jpg',	0,	1,	0,	0,	0,	'2023-06-17 14:52:03',	'2023-06-17 14:52:03',	NULL),
(203,	8,	NULL,	'photo_2023-06-17_10-53-13-d83d6c66-39a2-4a37-9f45-9556e4482118',	'/photo_2023-06-17_10-53-13-d83d6c66-39a2-4a37-9f45-9556e4482118.jpg',	'135746',	1097,	1097,	'jpg',	0,	1,	0,	0,	0,	'2023-06-17 14:54:18',	'2023-06-17 14:54:18',	NULL),
(204,	8,	NULL,	'photo_2023-06-17_10-54-40-988de025-7c31-46ae-a734-758833455458',	'/photo_2023-06-17_10-54-40-988de025-7c31-46ae-a734-758833455458.jpg',	'176119',	1155,	1155,	'jpg',	0,	1,	0,	0,	0,	'2023-06-17 14:55:12',	'2023-06-17 14:55:12',	NULL),
(205,	8,	NULL,	'photo_2023-06-17_11-02-48-5333d743-10c4-45a9-bd55-63088642d69c',	'/photo_2023-06-17_11-02-48-5333d743-10c4-45a9-bd55-63088642d69c.jpg',	'131375',	1097,	1097,	'jpg',	0,	1,	0,	0,	0,	'2023-06-17 15:03:08',	'2023-06-17 15:03:08',	NULL),
(206,	8,	NULL,	'photo_2023-06-17_11-05-48-9bdb6741-2836-4e95-b916-5f60ce67ed20',	'/photo_2023-06-17_11-05-48-9bdb6741-2836-4e95-b916-5f60ce67ed20.jpg',	'183961',	1154,	1155,	'jpg',	0,	1,	0,	0,	0,	'2023-06-17 15:06:03',	'2023-06-17 15:06:03',	NULL),
(207,	8,	NULL,	'photo_2023-06-17_11-51-28-18969616-b976-4a24-96cf-d9d84306d91f',	'/photo_2023-06-17_11-51-28-18969616-b976-4a24-96cf-d9d84306d91f.jpg',	'130764',	1097,	1097,	'jpg',	0,	1,	0,	0,	0,	'2023-06-17 15:51:59',	'2023-06-17 15:51:59',	NULL),
(208,	8,	NULL,	'photo_2023-06-17_11-54-27-42445a0a-74e5-4949-82e4-ea9570a28f3d',	'/photo_2023-06-17_11-54-27-42445a0a-74e5-4949-82e4-ea9570a28f3d.jpg',	'134455',	1097,	1097,	'jpg',	0,	1,	0,	0,	0,	'2023-06-17 15:54:50',	'2023-06-17 15:54:50',	NULL),
(209,	8,	NULL,	'photo_2023-06-17_13-22-33-835bdbb3-b560-4acf-9eab-be01ca3bc0c8',	'/photo_2023-06-17_13-22-33-835bdbb3-b560-4acf-9eab-be01ca3bc0c8.jpg',	'130275',	1097,	1097,	'jpg',	0,	1,	0,	0,	0,	'2023-06-17 17:22:51',	'2023-06-17 17:22:51',	NULL),
(210,	8,	NULL,	'photo_2023-06-17_13-36-58-96bda12a-35f0-490f-a980-bf4ddad25e3e',	'/photo_2023-06-17_13-36-58-96bda12a-35f0-490f-a980-bf4ddad25e3e.jpg',	'135428',	1096,	1097,	'jpg',	0,	1,	0,	0,	0,	'2023-06-17 17:37:23',	'2023-06-17 17:37:23',	NULL),
(211,	8,	NULL,	'photo_2023-06-17_13-53-35-aa476926-4317-41ae-9bc1-f015f599d583',	'/photo_2023-06-17_13-53-35-aa476926-4317-41ae-9bc1-f015f599d583.jpg',	'135428',	1096,	1097,	'jpg',	0,	1,	0,	0,	0,	'2023-06-17 17:53:58',	'2023-06-17 17:53:58',	NULL),
(212,	8,	NULL,	'photo_2023-06-17_13-56-25-25e92a82-5458-4957-917b-795d69e63bf9',	'/photo_2023-06-17_13-56-25-25e92a82-5458-4957-917b-795d69e63bf9.jpg',	'156378',	1096,	1097,	'jpg',	0,	1,	0,	0,	0,	'2023-06-17 17:57:28',	'2023-06-17 17:57:28',	NULL),
(213,	8,	NULL,	'photo_2023-06-17_14-14-22-549ac2ae-d336-4425-98e8-416a9ae3260f',	'/photo_2023-06-17_14-14-22-549ac2ae-d336-4425-98e8-416a9ae3260f.jpg',	'135285',	1097,	1097,	'jpg',	0,	1,	0,	0,	0,	'2023-06-17 18:14:51',	'2023-06-17 18:14:51',	NULL),
(214,	8,	NULL,	'photo_2023-06-17_14-20-59-96fa7838-8a12-4e6b-8f4b-2f6380d3c91f',	'/photo_2023-06-17_14-20-59-96fa7838-8a12-4e6b-8f4b-2f6380d3c91f.jpg',	'218079',	1155,	1155,	'jpg',	0,	1,	0,	0,	0,	'2023-06-17 18:21:12',	'2023-06-17 18:21:12',	NULL),
(215,	8,	NULL,	'photo_2023-06-17_14-32-31-7e6b4441-b221-4a74-a9ec-80e2cec6d85a',	'/photo_2023-06-17_14-32-31-7e6b4441-b221-4a74-a9ec-80e2cec6d85a.jpg',	'129195',	1097,	1097,	'jpg',	0,	1,	0,	0,	0,	'2023-06-17 18:34:11',	'2023-06-17 18:34:11',	NULL),
(216,	8,	NULL,	'photo_2023-06-17_14-35-52-8913e2f0-935f-4a48-87da-3b3be6667fc2',	'/photo_2023-06-17_14-35-52-8913e2f0-935f-4a48-87da-3b3be6667fc2.jpg',	'200041',	1155,	1155,	'jpg',	0,	1,	0,	0,	0,	'2023-06-17 18:40:32',	'2023-06-17 18:40:32',	NULL),
(217,	8,	NULL,	'photo_2023-06-17_14-44-00-6c31f3ce-4e27-4dcc-b5dd-496e2e2f5545',	'/photo_2023-06-17_14-44-00-6c31f3ce-4e27-4dcc-b5dd-496e2e2f5545.jpg',	'183569',	1155,	1155,	'jpg',	0,	1,	0,	0,	0,	'2023-06-17 18:44:28',	'2023-06-17 18:44:28',	NULL),
(218,	8,	NULL,	'photo_2023-06-19_08-47-24-46cbc359-60b6-42c0-b20c-07e974bddc12',	'/photo_2023-06-19_08-47-24-46cbc359-60b6-42c0-b20c-07e974bddc12.jpg',	'140890',	1097,	1097,	'jpg',	0,	1,	0,	0,	0,	'2023-06-19 12:47:59',	'2023-06-19 12:47:59',	NULL),
(219,	8,	NULL,	'photo_2023-06-19_08-49-04-b42adb89-d7b6-49cb-a525-0f9c8adb4464',	'/photo_2023-06-19_08-49-04-b42adb89-d7b6-49cb-a525-0f9c8adb4464.jpg',	'150081',	876,	1097,	'jpg',	0,	1,	0,	0,	0,	'2023-06-19 12:49:49',	'2023-06-19 12:49:49',	NULL),
(220,	8,	NULL,	'photo_2023-06-19_08-50-52-9396eca1-0f98-4049-aa1b-24afb49c8716',	'/photo_2023-06-19_08-50-52-9396eca1-0f98-4049-aa1b-24afb49c8716.jpg',	'158531',	875,	1097,	'jpg',	0,	1,	0,	0,	0,	'2023-06-19 12:51:30',	'2023-06-19 12:51:30',	NULL),
(221,	8,	NULL,	'photo_2023-06-19_08-54-45-60d08db3-b4e7-406e-aa0e-78da05c28f8c',	'/photo_2023-06-19_08-54-45-60d08db3-b4e7-406e-aa0e-78da05c28f8c.jpg',	'140037',	1097,	1097,	'jpg',	0,	1,	0,	0,	0,	'2023-06-19 12:55:03',	'2023-06-19 12:55:03',	NULL),
(222,	8,	NULL,	'photo_2023-06-19_08-59-48-a984f02e-1593-48d1-8e94-c76b2e5fd04c',	'/photo_2023-06-19_08-59-48-a984f02e-1593-48d1-8e94-c76b2e5fd04c.jpg',	'210661',	1155,	1155,	'jpg',	0,	1,	0,	0,	0,	'2023-06-19 13:00:28',	'2023-06-19 13:00:28',	NULL),
(223,	8,	NULL,	'photo_2023-06-19_09-01-50-a1845c3b-5ca5-44d1-b2ac-14217bd356ef',	'/photo_2023-06-19_09-01-50-a1845c3b-5ca5-44d1-b2ac-14217bd356ef.jpg',	'232292',	1155,	1155,	'jpg',	0,	1,	0,	0,	0,	'2023-06-19 13:09:32',	'2023-06-19 13:09:32',	NULL),
(224,	8,	NULL,	'photo_2023-06-19_09-12-01-52d3f61d-ce14-4a25-b217-9bc93c1de4fa',	'/photo_2023-06-19_09-12-01-52d3f61d-ce14-4a25-b217-9bc93c1de4fa.jpg',	'225663',	1155,	1155,	'jpg',	0,	1,	0,	0,	0,	'2023-06-19 13:12:11',	'2023-06-19 13:12:11',	NULL),
(225,	8,	NULL,	'photo_2023-06-19_09-15-30-c6feb437-f619-4ce9-9d09-4035cdc7d949',	'/photo_2023-06-19_09-15-30-c6feb437-f619-4ce9-9d09-4035cdc7d949.jpg',	'178608',	1280,	1280,	'jpg',	0,	1,	0,	0,	0,	'2023-06-19 13:15:52',	'2023-06-19 13:15:52',	NULL),
(226,	8,	NULL,	'photo_2023-06-19_09-18-43-c185624e-0da1-46d2-be5e-2824c042ec07',	'/photo_2023-06-19_09-18-43-c185624e-0da1-46d2-be5e-2824c042ec07.jpg',	'206023',	1017,	1155,	'jpg',	0,	1,	0,	0,	0,	'2023-06-19 13:19:05',	'2023-06-19 13:19:05',	NULL),
(227,	8,	NULL,	'photo_2023-06-19_09-20-45-20a87832-2c4d-4f19-91eb-1630a258f4dc',	'/photo_2023-06-19_09-20-45-20a87832-2c4d-4f19-91eb-1630a258f4dc.jpg',	'160837',	1097,	1097,	'jpg',	0,	1,	0,	0,	0,	'2023-06-19 13:22:46',	'2023-06-19 13:22:46',	NULL),
(228,	8,	NULL,	'photo_2023-06-19_09-26-15-c816da14-65b7-4045-9890-e75185f149e5',	'/photo_2023-06-19_09-26-15-c816da14-65b7-4045-9890-e75185f149e5.jpg',	'135642',	1280,	1280,	'jpg',	0,	1,	0,	0,	0,	'2023-06-19 13:26:37',	'2023-06-19 13:26:37',	NULL),
(229,	8,	NULL,	'photo_2023-06-19_09-27-51-b77d53fd-6f86-40b4-9fd8-706e9a8b934e',	'/photo_2023-06-19_09-27-51-b77d53fd-6f86-40b4-9fd8-706e9a8b934e.jpg',	'194160',	1155,	1155,	'jpg',	0,	1,	0,	0,	0,	'2023-06-19 13:28:12',	'2023-06-19 13:28:12',	NULL),
(230,	8,	NULL,	'photo_2023-06-19_09-34-05-f325b0c4-7325-438d-a02a-29229b277a14',	'/photo_2023-06-19_09-34-05-f325b0c4-7325-438d-a02a-29229b277a14.jpg',	'154237',	1024,	1280,	'jpg',	0,	1,	0,	0,	0,	'2023-06-19 13:34:50',	'2023-06-19 13:34:50',	NULL),
(231,	8,	NULL,	'photo_2023-06-19_09-40-41-12716b96-eb83-41e1-b213-8a5ddf4f09a0',	'/photo_2023-06-19_09-40-41-12716b96-eb83-41e1-b213-8a5ddf4f09a0.jpg',	'205728',	1155,	1155,	'jpg',	0,	1,	0,	0,	0,	'2023-06-19 13:41:03',	'2023-06-19 13:41:03',	NULL),
(232,	8,	NULL,	'photo_2023-06-19_09-59-23-ac7aaa73-2685-4e0d-a67c-1e8e5572cba0',	'/photo_2023-06-19_09-59-23-ac7aaa73-2685-4e0d-a67c-1e8e5572cba0.jpg',	'156573',	1097,	1097,	'jpg',	0,	1,	0,	0,	0,	'2023-06-19 14:00:03',	'2023-06-19 14:00:03',	NULL),
(233,	8,	NULL,	'photo_2023-06-19_10-02-02-60b6ddac-a779-4348-aca6-73aa18bff5c4',	'/photo_2023-06-19_10-02-02-60b6ddac-a779-4348-aca6-73aa18bff5c4.jpg',	'214386',	1155,	1155,	'jpg',	0,	1,	0,	0,	0,	'2023-06-19 14:02:27',	'2023-06-19 14:02:27',	NULL),
(234,	8,	NULL,	'photo_2023-06-19_10-03-59-a1fa77c6-c224-4576-9c9b-bae7ea2316f2',	'/photo_2023-06-19_10-03-59-a1fa77c6-c224-4576-9c9b-bae7ea2316f2.jpg',	'154066',	1280,	1280,	'jpg',	0,	1,	0,	0,	0,	'2023-06-19 14:04:35',	'2023-06-19 14:04:35',	NULL),
(235,	8,	NULL,	'photo_2023-06-19_10-05-29-f86b1e4a-9791-457d-bd39-fea294b58fa1',	'/photo_2023-06-19_10-05-29-f86b1e4a-9791-457d-bd39-fea294b58fa1.jpg',	'225144',	1155,	1155,	'jpg',	0,	1,	0,	0,	0,	'2023-06-19 14:06:34',	'2023-06-19 14:06:34',	NULL),
(236,	8,	NULL,	'photo_2023-06-19_10-07-24-ee1713d3-798d-43ef-8cd6-7ec60f609f37',	'/photo_2023-06-19_10-07-24-ee1713d3-798d-43ef-8cd6-7ec60f609f37.jpg',	'185001',	1155,	1155,	'jpg',	0,	1,	0,	0,	0,	'2023-06-19 14:08:01',	'2023-06-19 14:08:01',	NULL),
(237,	8,	NULL,	'photo_2023-06-19_10-09-03-1826ff5e-83d1-42e1-8924-c2cd44a2b88d',	'/photo_2023-06-19_10-09-03-1826ff5e-83d1-42e1-8924-c2cd44a2b88d.jpg',	'173618',	1155,	1155,	'jpg',	0,	1,	0,	0,	0,	'2023-06-19 14:09:32',	'2023-06-19 14:09:32',	NULL),
(238,	8,	NULL,	'photo_2023-06-19_10-10-33-cd779147-6ae7-4732-b1d9-535e3742cd47',	'/photo_2023-06-19_10-10-33-cd779147-6ae7-4732-b1d9-535e3742cd47.jpg',	'233118',	1155,	1155,	'jpg',	0,	1,	0,	0,	0,	'2023-06-19 14:11:34',	'2023-06-19 14:11:34',	NULL),
(239,	8,	NULL,	'photo_2023-06-19_10-12-01-e7ded92f-585e-41a2-bbf6-2f3f59913b2d',	'/photo_2023-06-19_10-12-01-e7ded92f-585e-41a2-bbf6-2f3f59913b2d.jpg',	'205461',	1155,	1155,	'jpg',	0,	1,	0,	0,	0,	'2023-06-19 14:12:26',	'2023-06-19 14:12:26',	NULL),
(240,	8,	NULL,	'photo_2023-06-19_11-26-34-5659e920-89dd-4a99-b6c1-2b7a4bdfaf47',	'/photo_2023-06-19_11-26-34-5659e920-89dd-4a99-b6c1-2b7a4bdfaf47.jpg',	'216126',	1155,	1155,	'jpg',	0,	1,	0,	0,	0,	'2023-06-19 15:27:06',	'2023-06-19 15:27:06',	NULL),
(241,	8,	NULL,	'7am Salon-dba3c8ad-fdce-4ed7-96d2-0ab927db192c',	'/7am Salon-dba3c8ad-fdce-4ed7-96d2-0ab927db192c.jpg',	'158590',	986,	1645,	'jpg',	0,	1,	0,	0,	0,	'2023-06-21 14:03:47',	'2023-06-21 14:03:47',	NULL),
(242,	8,	NULL,	'98 Studio Salon-d009abef-4106-49ec-ae40-83039c11e1e5',	'/98 Studio Salon-d009abef-4106-49ec-ae40-83039c11e1e5.jpg',	'7713',	206,	206,	'jpg',	0,	1,	0,	0,	0,	'2023-06-21 14:45:46',	'2023-06-21 14:45:46',	NULL),
(243,	8,	NULL,	'Kaknika Salon I-63b9c87f-130a-4378-90e0-81aeaa324ab0',	'/Kaknika Salon I-63b9c87f-130a-4378-90e0-81aeaa324ab0.jpg',	'202504',	1172,	1172,	'jpg',	0,	1,	0,	0,	0,	'2023-06-30 19:32:46',	'2023-06-30 19:32:46',	NULL),
(244,	8,	NULL,	'Sasa Salon-a75d4902-bbc0-48f7-8aa1-764aa100f2f5',	'/Sasa Salon-a75d4902-bbc0-48f7-8aa1-764aa100f2f5.jpg',	'62063',	1280,	445,	'jpg',	0,	1,	0,	0,	0,	'2023-06-30 20:07:44',	'2023-06-30 20:07:44',	NULL),
(245,	8,	NULL,	'Beautify Salon-de3e50f8-eff6-45fe-a180-a98b419f5d23',	'/Beautify Salon-de3e50f8-eff6-45fe-a180-a98b419f5d23.jpg',	'39038',	960,	420,	'jpg',	0,	1,	0,	0,	0,	'2023-06-30 20:13:43',	'2023-06-30 20:13:43',	NULL),
(246,	8,	NULL,	'Srey orm Salon-1e263575-3caf-4f7d-a93e-5d7124b1f4c9',	'/Srey orm Salon-1e263575-3caf-4f7d-a93e-5d7124b1f4c9.jpg',	'149641',	1172,	878,	'jpg',	0,	1,	0,	0,	0,	'2023-06-30 21:01:27',	'2023-06-30 21:01:27',	NULL),
(247,	8,	NULL,	'NaNa Yon Hair Salon-309c873e-5b1e-4e84-b6a7-ebd4ac30d32f',	'/NaNa Yon Hair Salon-309c873e-5b1e-4e84-b6a7-ebd4ac30d32f.jpg',	'26604',	960,	960,	'jpg',	0,	1,	0,	0,	0,	'2023-06-30 21:11:28',	'2023-06-30 21:11:28',	NULL),
(248,	8,	NULL,	'Mickey Salon-c30f21bd-5fa8-407f-905d-af4afe465fa8',	'/Mickey Salon-c30f21bd-5fa8-407f-905d-af4afe465fa8.jpg',	'430706',	1732,	1299,	'jpg',	0,	1,	0,	0,	0,	'2023-07-01 19:12:12',	'2023-07-01 19:12:12',	NULL),
(249,	8,	NULL,	'Wow Salon-5a361a30-1cda-466d-a5f0-6feef8b27316',	'/Wow Salon-5a361a30-1cda-466d-a5f0-6feef8b27316.jpg',	'57149',	960,	960,	'jpg',	0,	1,	0,	0,	0,	'2023-07-01 19:35:17',	'2023-07-01 19:35:17',	NULL),
(250,	8,	NULL,	'Mo Salon-4432116f-2daa-4b74-ba4d-95f50fd5848f',	'/Mo Salon-4432116f-2daa-4b74-ba4d-95f50fd5848f.jpg',	'107918',	1048,	787,	'jpg',	0,	1,	0,	0,	0,	'2023-07-01 20:12:13',	'2023-07-01 20:12:13',	NULL),
(251,	8,	NULL,	'Gallery House Salon-e3ae3705-6adc-46b7-abd5-be777fe4ff7f',	'/Gallery House Salon-e3ae3705-6adc-46b7-abd5-be777fe4ff7f.png',	'83046',	800,	800,	'png',	0,	1,	0,	0,	0,	'2023-07-01 20:20:17',	'2023-07-01 20:20:17',	NULL),
(252,	8,	NULL,	'Ah Mouy Salon-297805c3-bcaa-4eb4-8a74-e8dc892bcd0d',	'/Ah Mouy Salon-297805c3-bcaa-4eb4-8a74-e8dc892bcd0d.jpg',	'182784',	1234,	822,	'jpg',	0,	1,	0,	0,	0,	'2023-07-03 14:04:41',	'2023-07-03 14:04:41',	NULL),
(253,	8,	NULL,	'The Y Home-161cf438-466b-4929-bf82-c83bde04b7a1',	'/The Y Home-161cf438-466b-4929-bf82-c83bde04b7a1.jpg',	'68055',	720,	960,	'jpg',	0,	1,	0,	0,	0,	'2023-07-03 14:14:37',	'2023-07-03 14:14:37',	NULL),
(254,	8,	NULL,	'Lakshmi Beauty & Spa-832066a6-6703-4b9e-a681-7378116443d6',	'/Lakshmi Beauty & Spa-832066a6-6703-4b9e-a681-7378116443d6.jpg',	'9551',	206,	206,	'jpg',	0,	1,	0,	0,	0,	'2023-07-03 14:19:52',	'2023-07-03 14:19:52',	NULL),
(255,	8,	NULL,	'Salon 71-34ec6fd2-0cb0-40c1-a7ab-c29129b36b7d',	'/Salon 71-34ec6fd2-0cb0-40c1-a7ab-c29129b36b7d.jpg',	'15400',	600,	600,	'jpg',	0,	1,	0,	0,	0,	'2023-07-03 14:31:35',	'2023-07-03 14:31:35',	NULL),
(256,	8,	NULL,	'The Den Salon-eab5386c-c5aa-43fc-9c1d-2067365b3db1',	'/The Den Salon-eab5386c-c5aa-43fc-9c1d-2067365b3db1.jpg',	'44748',	960,	960,	'jpg',	0,	1,	0,	0,	0,	'2023-07-03 14:36:50',	'2023-07-03 14:36:50',	NULL),
(257,	8,	NULL,	'O 57 Salon-87e3bf74-0b2e-4ffa-82a9-df3a6ba54009',	'/O 57 Salon-87e3bf74-0b2e-4ffa-82a9-df3a6ba54009.jpg',	'141544',	960,	640,	'jpg',	0,	1,	0,	0,	0,	'2023-07-03 14:39:49',	'2023-07-03 14:39:49',	NULL),
(258,	8,	NULL,	'Beauty Room-cb9ca601-2751-4c0e-be2c-c6e131fd7fa9',	'/Beauty Room-cb9ca601-2751-4c0e-be2c-c6e131fd7fa9.jpg',	'46628',	960,	960,	'jpg',	0,	1,	0,	0,	0,	'2023-07-03 14:44:20',	'2023-07-03 14:44:20',	NULL),
(259,	8,	NULL,	'Salon 27-1f75a411-4190-4df5-a3aa-f8c233c825e3',	'/Salon 27-1f75a411-4190-4df5-a3aa-f8c233c825e3.png',	'62918',	960,	468,	'png',	0,	1,	0,	0,	0,	'2023-07-03 14:49:39',	'2023-07-03 14:49:39',	NULL),
(260,	8,	NULL,	'Savada Salon-042b471e-a960-4e91-b128-ea08b0cf670e',	'/Savada Salon-042b471e-a960-4e91-b128-ea08b0cf670e.jpg',	'5840',	200,	200,	'jpg',	0,	1,	0,	0,	0,	'2023-07-03 15:33:44',	'2023-07-03 15:33:44',	NULL),
(261,	8,	NULL,	'N5 Salon-bcde9b58-d638-4437-8ac2-e6f8494487d2',	'/N5 Salon-bcde9b58-d638-4437-8ac2-e6f8494487d2.jpg',	'36790',	1125,	632,	'jpg',	0,	1,	0,	0,	0,	'2023-07-03 15:38:59',	'2023-07-03 15:47:07',	'2023-07-03 15:47:07'),
(262,	8,	NULL,	'N5 Salon-4fe47ae4-bf44-4828-9dc9-7f7d6b02876a',	'/N5 Salon-4fe47ae4-bf44-4828-9dc9-7f7d6b02876a.jpg',	'36790',	1125,	632,	'jpg',	0,	1,	0,	0,	0,	'2023-07-03 15:46:59',	'2023-07-03 15:46:59',	NULL),
(263,	8,	NULL,	'Manolia Salon-520262c3-699b-488a-b046-9137920567ca',	'/Manolia Salon-520262c3-699b-488a-b046-9137920567ca.jpg',	'79067',	960,	541,	'jpg',	0,	1,	0,	0,	0,	'2023-07-03 18:03:04',	'2023-07-03 18:03:04',	NULL),
(264,	8,	NULL,	'BM Salon-6a00f8c6-184b-45f6-84ac-ae7a14358b90',	'/BM Salon-6a00f8c6-184b-45f6-84ac-ae7a14358b90.jpg',	'21709',	960,	540,	'jpg',	0,	1,	0,	0,	0,	'2023-07-03 19:58:34',	'2023-07-03 19:58:34',	NULL),
(265,	8,	NULL,	'M&A Beauty Center - Salon-46ea061f-19b2-4731-8d0d-8476c5b410bf',	'/M&A Beauty Center - Salon-46ea061f-19b2-4731-8d0d-8476c5b410bf.jpg',	'14084',	960,	540,	'jpg',	0,	1,	0,	0,	0,	'2023-07-03 20:06:09',	'2023-07-03 20:06:09',	NULL),
(266,	8,	NULL,	'Jol Mlob Salon-073df4c7-d2bd-4ed8-9fa5-f370e8293801',	'/Jol Mlob Salon-073df4c7-d2bd-4ed8-9fa5-f370e8293801.jpg',	'223245',	1732,	1732,	'jpg',	0,	1,	0,	0,	0,	'2023-07-03 20:21:21',	'2023-07-03 20:21:21',	NULL),
(267,	8,	NULL,	'Nail Palace-cbacd75e-fed6-4748-8603-213bd9c8ea10',	'/Nail Palace-cbacd75e-fed6-4748-8603-213bd9c8ea10.jpg',	'31207',	959,	960,	'jpg',	0,	1,	0,	0,	0,	'2023-07-04 13:01:59',	'2023-07-04 13:01:59',	NULL),
(268,	8,	NULL,	'Green Barber7-53ebef4d-b7e3-4a9c-92b5-39dad6ef7b80',	'/Green Barber7-53ebef4d-b7e3-4a9c-92b5-39dad6ef7b80.jpg',	'7789',	206,	206,	'jpg',	0,	1,	0,	0,	0,	'2023-07-04 13:05:45',	'2023-07-04 13:05:45',	NULL),
(269,	8,	NULL,	'Dee\'s Studio Hair Salon-137c6d05-5716-4dd9-a9cc-57ddd4dd3ef3',	'/Dee\'s Studio Hair Salon-137c6d05-5716-4dd9-a9cc-57ddd4dd3ef3.jpg',	'23849',	960,	960,	'jpg',	0,	1,	0,	0,	0,	'2023-07-04 13:09:21',	'2023-07-04 13:09:21',	NULL),
(270,	8,	NULL,	'Agas Stro Beauty-25158c34-877a-4268-a32a-982fc16ae199',	'/Agas Stro Beauty-25158c34-877a-4268-a32a-982fc16ae199.jpg',	'78434',	960,	720,	'jpg',	0,	1,	0,	0,	0,	'2023-07-04 13:14:13',	'2023-07-04 13:14:13',	NULL),
(271,	8,	NULL,	'PUY Salon 598-950bb4d3-ba9d-45c6-9bc6-3e1b14345ccd',	'/PUY Salon 598-950bb4d3-ba9d-45c6-9bc6-3e1b14345ccd.jpg',	'77466',	960,	365,	'jpg',	0,	1,	0,	0,	0,	'2023-07-04 13:15:39',	'2023-07-04 13:15:39',	NULL),
(272,	8,	NULL,	'Madam C Spa & Salon-00d83c82-0536-4492-8069-75bd6019433f',	'/Madam C Spa & Salon-00d83c82-0536-4492-8069-75bd6019433f.jpg',	'70816',	1445,	1445,	'jpg',	0,	1,	0,	0,	0,	'2023-07-04 13:31:12',	'2023-07-04 13:31:12',	NULL),
(273,	8,	NULL,	'Narak Inside Beauty-c13e01c8-f9c3-4c94-99dd-9c5058243b9f',	'/Narak Inside Beauty-c13e01c8-f9c3-4c94-99dd-9c5058243b9f.jpg',	'30122',	958,	960,	'jpg',	0,	1,	0,	0,	0,	'2023-07-04 14:28:44',	'2023-07-04 14:28:44',	NULL),
(274,	8,	NULL,	'Q Winnie Nail Salon-de1f1786-13ed-4918-ad9d-7e084bc56770',	'/Q Winnie Nail Salon-de1f1786-13ed-4918-ad9d-7e084bc56770.jpg',	'118405',	960,	960,	'jpg',	0,	1,	0,	0,	0,	'2023-07-04 14:39:08',	'2023-07-04 14:39:08',	NULL),
(275,	8,	NULL,	'King Barber-58811c46-1101-4cbc-b86f-e7eb3fb03ac3',	'/King Barber-58811c46-1101-4cbc-b86f-e7eb3fb03ac3.jpg',	'116518',	780,	780,	'jpg',	0,	1,	0,	0,	0,	'2023-07-04 17:40:29',	'2023-07-04 17:40:29',	NULL),
(276,	8,	NULL,	'Reach Salon-2ce28ff1-c5dc-4143-8487-90158f6f93d2',	'/Reach Salon-2ce28ff1-c5dc-4143-8487-90158f6f93d2.jpg',	'79940',	540,	960,	'jpg',	0,	1,	0,	0,	0,	'2023-07-05 20:11:10',	'2023-07-05 20:11:10',	NULL),
(277,	8,	NULL,	'The Black Salon-1f6d0f46-7868-4c89-bd3c-81a9ecf4042c',	'/The Black Salon-1f6d0f46-7868-4c89-bd3c-81a9ecf4042c.jpg',	'23554',	958,	960,	'jpg',	0,	1,	0,	0,	0,	'2023-07-05 20:26:28',	'2023-07-05 20:26:28',	NULL),
(278,	8,	NULL,	'NT Salon-47125b87-0835-41f5-a36b-025a2b4ede9b',	'/NT Salon-47125b87-0835-41f5-a36b-025a2b4ede9b.jpg',	'3667',	200,	200,	'jpg',	0,	1,	0,	0,	0,	'2023-07-05 20:34:31',	'2023-07-05 20:34:31',	NULL),
(279,	8,	NULL,	'The Doll House  Hair Salon-dede2973-97fa-4403-a0b1-d0ad21309ed7',	'/The Doll House  Hair Salon-dede2973-97fa-4403-a0b1-d0ad21309ed7.png',	'135064',	960,	366,	'png',	0,	1,	0,	0,	0,	'2023-07-06 13:48:16',	'2023-07-06 13:48:16',	NULL),
(280,	8,	NULL,	'Socheat Salon-14b7ca7b-71dd-45f9-92ff-0ff9f98de0b3',	'/Socheat Salon-14b7ca7b-71dd-45f9-92ff-0ff9f98de0b3.jpg',	'200655',	1533,	1250,	'jpg',	0,	1,	0,	0,	0,	'2023-07-06 14:43:26',	'2023-07-06 14:43:26',	NULL),
(281,	8,	NULL,	'Cindy ll & NK salon-23e734cc-770e-4923-b9b9-ad7f37f1ecaa',	'/Cindy ll & NK salon-23e734cc-770e-4923-b9b9-ad7f37f1ecaa.jpg',	'24379',	720,	720,	'jpg',	0,	1,	0,	0,	0,	'2023-07-06 14:55:25',	'2023-07-06 14:55:25',	NULL),
(282,	8,	NULL,	'King & Queen Salon and Barber-cbc39cc5-933c-4585-8d74-27d5d55cdb49',	'/King & Queen Salon and Barber-cbc39cc5-933c-4585-8d74-27d5d55cdb49.jpg',	'108835',	960,	960,	'jpg',	0,	1,	0,	0,	0,	'2023-07-06 15:01:27',	'2023-07-06 15:01:27',	NULL),
(283,	8,	NULL,	'La Reine Salon-4ebd48ef-01ac-47e4-be96-e21f14cb8428',	'/La Reine Salon-4ebd48ef-01ac-47e4-be96-e21f14cb8428.jpg',	'55485',	1773,	1773,	'jpg',	0,	1,	0,	0,	0,	'2023-07-06 15:09:49',	'2023-07-06 15:09:49',	NULL),
(284,	8,	NULL,	'PUY Salon 63-5e946ee2-7daf-4f1f-bf1f-9804859e302b',	'/PUY Salon 63-5e946ee2-7daf-4f1f-bf1f-9804859e302b.jpg',	'149922',	693,	867,	'jpg',	0,	1,	0,	0,	0,	'2023-07-06 15:18:00',	'2023-07-06 15:18:00',	NULL),
(285,	8,	NULL,	'Ah Mouy Salon-99006159-1049-4b34-9d74-e6ed88dce9a1',	'/Ah Mouy Salon-99006159-1049-4b34-9d74-e6ed88dce9a1.jpg',	'182784',	1234,	822,	'jpg',	0,	1,	0,	0,	0,	'2023-07-06 15:23:17',	'2023-07-06 15:23:17',	NULL),
(286,	8,	NULL,	'Balyna Spa & Salon-6cda06c2-5453-4d56-ac6a-5d12a34ea606',	'/Balyna Spa & Salon-6cda06c2-5453-4d56-ac6a-5d12a34ea606.jpg',	'223618',	1727,	758,	'jpg',	0,	1,	0,	0,	0,	'2023-07-06 15:23:17',	'2023-07-06 15:23:17',	NULL),
(287,	8,	NULL,	'Lin Hair Style Salon-a3c95564-3abb-4545-962d-e78b889f01b6',	'/Lin Hair Style Salon-a3c95564-3abb-4545-962d-e78b889f01b6.jpg',	'8906',	200,	199,	'jpg',	0,	1,	0,	0,	0,	'2023-07-06 15:23:28',	'2023-07-06 15:23:28',	NULL),
(288,	8,	NULL,	'90’s Salon-865802bb-db46-401d-8a96-4a303bfeaaa0',	'/90’s Salon-865802bb-db46-401d-8a96-4a303bfeaaa0.jpg',	'124238',	1440,	811,	'jpg',	0,	1,	0,	0,	0,	'2023-07-06 15:33:49',	'2023-07-06 15:33:49',	NULL),
(289,	8,	NULL,	'V Color Barber&Mss-3b76992b-ae6a-40e0-af24-9cfe62ab4b15',	'/V Color Barber&Mss-3b76992b-ae6a-40e0-af24-9cfe62ab4b15.jpg',	'43257',	960,	960,	'jpg',	0,	1,	0,	0,	0,	'2023-07-06 15:38:03',	'2023-07-06 15:38:03',	NULL),
(290,	8,	NULL,	'Number15 Salon-2b716f82-7983-4f18-b176-febbb6a5277d',	'/Number15 Salon-2b716f82-7983-4f18-b176-febbb6a5277d.jpg',	'12493',	959,	959,	'jpg',	0,	1,	0,	0,	0,	'2023-07-06 19:55:25',	'2023-07-06 19:55:25',	NULL),
(291,	8,	NULL,	'Daneth Salon-16fabc2e-cc03-49da-a19e-b3705de9208a',	'/Daneth Salon-16fabc2e-cc03-49da-a19e-b3705de9208a.jpg',	'150284',	1168,	1152,	'jpg',	0,	1,	0,	0,	0,	'2023-07-06 20:04:04',	'2023-07-06 20:04:04',	NULL),
(292,	8,	NULL,	'Dalin Beauty Salon-4c77c5af-01ab-4713-a5fc-2f88a511bee1',	'/Dalin Beauty Salon-4c77c5af-01ab-4713-a5fc-2f88a511bee1.jpg',	'25824',	480,	480,	'jpg',	0,	1,	0,	0,	0,	'2023-07-06 20:24:21',	'2023-07-06 20:24:21',	NULL),
(293,	8,	NULL,	'East West Hair Salon-39fe3a3d-613e-4a22-b30f-ab723bc22d28',	'/East West Hair Salon-39fe3a3d-613e-4a22-b30f-ab723bc22d28.jpg',	'319364',	1299,	1732,	'jpg',	0,	1,	0,	0,	0,	'2023-07-06 20:38:19',	'2023-07-06 20:38:19',	NULL),
(294,	8,	NULL,	'The Hair Lab-df1c3e13-e6c3-4a32-96e3-d2d43cb89c6d',	'/The Hair Lab-df1c3e13-e6c3-4a32-96e3-d2d43cb89c6d.jpg',	'65728',	960,	720,	'jpg',	0,	1,	0,	0,	0,	'2023-07-07 18:08:28',	'2023-07-07 18:08:28',	NULL),
(295,	8,	NULL,	'PSE (Pour un Sourir d\'Enfant)-e99fb7b8-e84e-4e9c-b215-8b580f455e64',	'/PSE (Pour un Sourir d\'Enfant)-e99fb7b8-e84e-4e9c-b215-8b580f455e64.png',	'263520',	754,	754,	'png',	0,	1,	0,	0,	0,	'2023-07-07 18:57:41',	'2023-07-07 18:57:41',	NULL),
(296,	8,	NULL,	'Silvia Dalvann Image Studios-eece2a8c-32ad-4eb5-8623-a269645f798a',	'/Silvia Dalvann Image Studios-eece2a8c-32ad-4eb5-8623-a269645f798a.jpg',	'234959',	1097,	1097,	'jpg',	0,	1,	0,	0,	0,	'2023-07-07 19:22:39',	'2023-07-07 19:22:39',	NULL),
(297,	8,	NULL,	'Everline Salon-a4ec0318-49ce-4016-9710-7515faa5d62e',	'/Everline Salon-a4ec0318-49ce-4016-9710-7515faa5d62e.jpg',	'29414',	960,	960,	'jpg',	0,	1,	0,	0,	0,	'2023-07-10 10:53:25',	'2023-07-10 10:53:25',	NULL),
(298,	8,	NULL,	'Syna Styling Salon-dab7cc76-01c7-4e6a-bc2c-8138901b27d0',	'/Syna Styling Salon-dab7cc76-01c7-4e6a-bc2c-8138901b27d0.jpg',	'44011',	1920,	1080,	'jpg',	0,	1,	0,	0,	0,	'2023-07-10 11:06:24',	'2023-07-10 11:06:24',	NULL),
(299,	8,	NULL,	'Cool Hair Salon-7ffb85d9-187a-4502-bebb-a4aa19c0f521',	'/Cool Hair Salon-7ffb85d9-187a-4502-bebb-a4aa19c0f521.jpg',	'10486',	206,	206,	'jpg',	0,	1,	0,	0,	0,	'2023-07-10 11:44:04',	'2023-07-10 11:44:04',	NULL),
(300,	8,	NULL,	'18 home salon-c52e42a1-c9c4-4497-918a-833d2883def5',	'/18 home salon-c52e42a1-c9c4-4497-918a-833d2883def5.jpg',	'339194',	1645,	1234,	'jpg',	0,	1,	0,	0,	0,	'2023-07-10 14:54:43',	'2023-07-10 14:54:43',	NULL),
(301,	8,	NULL,	'Orchide Salon-665d9fef-711a-4cd5-bfad-246b816387cf',	'/Orchide Salon-665d9fef-711a-4cd5-bfad-246b816387cf.jpg',	'65942',	959,	960,	'jpg',	0,	1,	0,	0,	0,	'2023-07-12 14:39:37',	'2023-07-12 14:39:37',	NULL),
(302,	8,	NULL,	'Cindy ll & NK Salon - PH-aa8cf7ae-d7e1-4c69-b834-a78d84022aa8',	'/Cindy ll & NK Salon - PH-aa8cf7ae-d7e1-4c69-b834-a78d84022aa8.jpg',	'24379',	720,	720,	'jpg',	0,	1,	0,	0,	0,	'2023-07-12 14:44:44',	'2023-07-12 14:44:44',	NULL),
(303,	8,	NULL,	'Ego Salon-1865cd00-c86d-49dc-bdde-1c91dbbfb079',	'/Ego Salon-1865cd00-c86d-49dc-bdde-1c91dbbfb079.jpg',	'31166',	554,	540,	'jpg',	0,	1,	0,	0,	0,	'2023-07-12 14:55:30',	'2023-07-12 14:55:30',	NULL),
(304,	8,	NULL,	'VIP Salon-8a030121-4ca1-4e80-82bb-c78173c144da',	'/VIP Salon-8a030121-4ca1-4e80-82bb-c78173c144da.jpg',	'64732',	960,	341,	'jpg',	0,	1,	0,	0,	0,	'2023-07-12 15:01:55',	'2023-07-12 15:01:55',	NULL),
(305,	8,	NULL,	'Tutu Salon-431b4f6b-3413-4f21-9cdd-e08654c3147f',	'/Tutu Salon-431b4f6b-3413-4f21-9cdd-e08654c3147f.jpg',	'66568',	960,	538,	'jpg',	0,	1,	0,	0,	0,	'2023-07-12 16:20:11',	'2023-07-12 16:20:11',	NULL),
(306,	8,	NULL,	'RT Barber Shop-0f5071de-be53-4d48-9e86-45f702c90576',	'/RT Barber Shop-0f5071de-be53-4d48-9e86-45f702c90576.jpg',	'112505',	1045,	782,	'jpg',	0,	1,	0,	0,	0,	'2023-07-12 16:29:26',	'2023-07-12 16:29:26',	NULL),
(307,	8,	NULL,	'Fae Hair & Beauty Salon-90a90b7b-30f4-417e-b0d9-925fa5754f5d',	'/Fae Hair & Beauty Salon-90a90b7b-30f4-417e-b0d9-925fa5754f5d.jpg',	'205610',	1234,	1645,	'jpg',	0,	1,	0,	0,	0,	'2023-07-12 16:35:55',	'2023-07-12 16:35:55',	NULL),
(308,	8,	NULL,	'N&R Theany Salon-a891c5a6-8ca1-44ba-bb5f-80ad6f29a998',	'/N&R Theany Salon-a891c5a6-8ca1-44ba-bb5f-80ad6f29a998.jpg',	'139217',	822,	822,	'jpg',	0,	1,	0,	0,	0,	'2023-07-12 16:38:26',	'2023-07-12 16:38:26',	NULL),
(309,	8,	NULL,	'Oun Sam Salon-3e976b96-720a-498c-a4c2-c9bc9e976098',	'/Oun Sam Salon-3e976b96-720a-498c-a4c2-c9bc9e976098.jpg',	'110643',	1280,	930,	'jpg',	0,	1,	0,	0,	0,	'2023-07-12 16:53:01',	'2023-07-12 16:53:01',	NULL),
(310,	8,	NULL,	'Le Boudoir Salon - TTP-1a0af167-d103-4dd4-861b-b98c8558c5d6',	'/Le Boudoir Salon - TTP-1a0af167-d103-4dd4-861b-b98c8558c5d6.png',	'11445',	500,	500,	'png',	0,	1,	0,	0,	0,	'2023-07-12 17:06:42',	'2023-07-12 17:06:42',	NULL),
(311,	8,	NULL,	'7Barber & Mss-ffb8b2cc-82f2-469a-aa5f-424ac92446ab',	'/7Barber & Mss-ffb8b2cc-82f2-469a-aa5f-424ac92446ab.jpg',	'183113',	872,	1234,	'jpg',	0,	1,	0,	0,	0,	'2023-07-12 17:13:51',	'2023-07-12 17:13:51',	NULL),
(312,	8,	NULL,	'Mini Salon-b2f5b4dd-167c-4b7e-8619-1d91f8f57aeb',	'/Mini Salon-b2f5b4dd-167c-4b7e-8619-1d91f8f57aeb.jpg',	'135789',	1280,	1280,	'jpg',	0,	1,	0,	0,	0,	'2023-07-12 17:24:56',	'2023-07-12 17:24:56',	NULL),
(313,	8,	NULL,	'CamiYui beauty Japan-c38df227-f270-413d-8ca9-205ac4599a76',	'/CamiYui beauty Japan-c38df227-f270-413d-8ca9-205ac4599a76.jpg',	'34604',	491,	490,	'jpg',	0,	1,	0,	0,	0,	'2023-07-13 09:55:41',	'2023-07-13 09:55:41',	NULL),
(314,	8,	NULL,	'Naden salon-3a058ae2-96ee-480a-9ad9-89ab1e7523d0',	'/Naden salon-3a058ae2-96ee-480a-9ad9-89ab1e7523d0.jpg',	'73346',	382,	510,	'jpg',	0,	1,	0,	0,	0,	'2023-07-13 10:07:22',	'2023-07-13 10:07:22',	NULL),
(315,	8,	NULL,	'Leekaja Salon - Sovanna-403f43cf-5bb1-4e2a-858a-d47def98bcaa',	'/Leekaja Salon - Sovanna-403f43cf-5bb1-4e2a-858a-d47def98bcaa.jpg',	'88758',	960,	960,	'jpg',	0,	1,	0,	0,	0,	'2023-07-13 10:20:09',	'2023-07-13 10:20:09',	NULL),
(316,	8,	NULL,	'Nature salon-2e9a9e6f-cdee-4147-8e74-78e886e9a737',	'/Nature salon-2e9a9e6f-cdee-4147-8e74-78e886e9a737.jpg',	'73312',	959,	960,	'jpg',	0,	1,	0,	0,	0,	'2023-07-13 10:30:30',	'2023-07-13 10:30:30',	NULL),
(317,	8,	NULL,	'Beauty Lounge-9aa9d8a4-941f-41bb-944a-f5b34bcd5828',	'/Beauty Lounge-9aa9d8a4-941f-41bb-944a-f5b34bcd5828.jpg',	'71510',	1633,	905,	'jpg',	0,	1,	0,	0,	0,	'2023-07-14 14:57:46',	'2023-07-14 14:57:46',	NULL),
(318,	8,	NULL,	'Tulip Salon-3a5aa446-6bb4-423b-a7a8-15a3e5fdb447',	'/Tulip Salon-3a5aa446-6bb4-423b-a7a8-15a3e5fdb447.jpg',	'5566',	200,	200,	'jpg',	0,	1,	0,	0,	0,	'2023-07-14 15:03:50',	'2023-07-14 15:03:50',	NULL),
(319,	8,	NULL,	'High Lady Salon-81ab4306-735f-433e-b0fe-bdfee32bb91c',	'/High Lady Salon-81ab4306-735f-433e-b0fe-bdfee32bb91c.jpg',	'100557',	960,	595,	'jpg',	0,	1,	0,	0,	0,	'2023-07-14 15:07:01',	'2023-07-14 15:07:01',	NULL),
(320,	8,	NULL,	'M Salon & Spa PH-4e87249d-b81c-4d41-b450-1975b6c4de4e',	'/M Salon & Spa PH-4e87249d-b81c-4d41-b450-1975b6c4de4e.jpg',	'62214',	960,	640,	'jpg',	0,	1,	0,	0,	0,	'2023-07-14 15:21:13',	'2023-07-14 15:21:13',	NULL),
(321,	8,	NULL,	'Chanda Salon-eef8fabd-ba97-4030-9416-92f7fdc7fb94',	'/Chanda Salon-eef8fabd-ba97-4030-9416-92f7fdc7fb94.jpg',	'115420',	1920,	1177,	'jpg',	0,	1,	0,	0,	0,	'2023-07-14 16:00:13',	'2023-07-14 16:00:13',	NULL),
(322,	8,	NULL,	'Nature Salon and Brows-2138a046-8c3f-46c1-ba13-3b72521b05f7',	'/Nature Salon and Brows-2138a046-8c3f-46c1-ba13-3b72521b05f7.jpg',	'73312',	959,	960,	'jpg',	0,	1,	0,	0,	0,	'2023-07-14 16:09:28',	'2023-07-14 16:09:28',	NULL),
(323,	8,	NULL,	'CamiYui By Prosol Japan Salon-f884f5d8-61bc-439d-b8b5-381d8bb4588d',	'/CamiYui By Prosol Japan Salon-f884f5d8-61bc-439d-b8b5-381d8bb4588d.jpg',	'34604',	491,	490,	'jpg',	0,	1,	0,	0,	0,	'2023-07-14 16:38:02',	'2023-07-14 16:38:02',	NULL),
(324,	8,	NULL,	'18 Home Salon-7031a7c0-75d4-4efa-8925-c714e6543f24',	'/18 Home Salon-7031a7c0-75d4-4efa-8925-c714e6543f24.jpg',	'24705',	400,	400,	'jpg',	0,	1,	0,	0,	0,	'2023-07-14 16:50:47',	'2023-07-14 16:50:47',	NULL),
(325,	8,	NULL,	'B2 Hair Salon-7182d7c6-270c-4642-9b4b-f885c2ad7b37',	'/B2 Hair Salon-7182d7c6-270c-4642-9b4b-f885c2ad7b37.jpg',	'81828',	960,	720,	'jpg',	0,	1,	0,	0,	0,	'2023-07-14 16:54:12',	'2023-07-14 16:54:12',	NULL),
(326,	8,	NULL,	'បច្ចេកទេសអ៊ុតសក់រួញ 𝐍𝐚𝐦𝐢𝐦𝐚𝐤𝐢-42936b3b-41c5-446e-b6ad-9f1175bd2e07',	'/បច្ចេកទេសអ៊ុតសក់រួញ 𝐍𝐚𝐦𝐢𝐦𝐚𝐤𝐢-42936b3b-41c5-446e-b6ad-9f1175bd2e07.jpg',	'198864',	1155,	1155,	'jpg',	0,	1,	0,	0,	0,	'2023-07-20 13:37:38',	'2023-07-20 13:37:38',	NULL),
(327,	1,	NULL,	'4isqg51639389449522Product - All P&S at ABHC_Website-0bd9e252-3e5f-4e5c-82a5-e6ee28ce1ec3-77de19cd-78cf-4a5b-8bd9-a0fe1b61c0e',	'/4isqg51639389449522Product - All P&S at ABHC_Website-0bd9e252-3e5f-4e5c-82a5-e6ee28ce1ec3-77de19cd-78cf-4a5b-8bd9-a0fe1b61c0',	'434304',	1920,	704,	'jpg',	0,	1,	0,	0,	0,	'2023-10-18 19:38:48',	'2023-10-21 16:12:08',	'2023-10-21 16:12:08'),
(328,	1,	7,	'Facebook Cover-183f1276-e3bc-409c-a963-02dd900c6e52',	'/Facebook Cover-183f1276-e3bc-409c-a963-02dd900c6e52.png',	'488453',	1206,	678,	'png',	0,	1,	0,	0,	0,	'2023-10-19 10:48:57',	'2023-10-19 10:48:57',	NULL),
(329,	1,	7,	'Facebook Cover-653d63fc-6c8e-4372-ad32-3cdbaeb29c6f',	'/Facebook Cover-653d63fc-6c8e-4372-ad32-3cdbaeb29c6f.png',	'488456',	1206,	678,	'png',	0,	1,	0,	0,	0,	'2023-10-19 10:49:10',	'2023-10-19 10:49:20',	'2023-10-19 10:49:20'),
(339,	1,	10,	'Project Managemant - week3 Oct-d9cbacec-a269-45cf-b4dd-3d3acf7f44ae',	'/Project Managemant - week3 Oct-d9cbacec-a269-45cf-b4dd-3d3acf7f44ae.pdf',	'88878',	NULL,	NULL,	'pdf',	0,	0,	0,	0,	1,	'2023-10-25 16:22:52',	'2023-10-25 16:22:52',	NULL),
(340,	1,	10,	'Agenda meeting for 24October 2023-ed765201-d7f1-472d-bed6-8dcb1ed0695b',	'/Agenda meeting for 24October 2023-ed765201-d7f1-472d-bed6-8dcb1ed0695b.pdf',	'165534',	NULL,	NULL,	'pdf',	0,	0,	0,	0,	1,	'2023-10-25 16:22:52',	'2023-10-25 16:22:52',	NULL),
(341,	1,	10,	'hd-681aef62-4847-4256-81a6-d0b321c35f33',	'/hd-681aef62-4847-4256-81a6-d0b321c35f33.docx',	'1421605',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-25 16:22:52',	'2023-10-25 16:22:52',	NULL),
(342,	8,	NULL,	'1-Information Sheet 1.1.1-8b1c41de-321b-4c31-96ba-ac35596a98d4',	'/1-Information Sheet 1.1.1-8b1c41de-321b-4c31-96ba-ac35596a98d4.docx',	'3737140',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 08:45:58',	'2023-10-27 08:47:08',	'2023-10-27 08:47:08'),
(343,	8,	11,	'1-Information Sheet 1.1.1-54498d30-1ee6-4575-932e-bf61b76c65cb',	'/1-Information Sheet 1.1.1-54498d30-1ee6-4575-932e-bf61b76c65cb.docx',	'3737140',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 08:47:23',	'2023-10-27 08:47:23',	NULL),
(344,	8,	11,	'1-Information Sheet 1.1.2-28152fa9-3f06-4fd3-8115-4aa3f1dad072',	'/1-Information Sheet 1.1.2-28152fa9-3f06-4fd3-8115-4aa3f1dad072.docx',	'2304255',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 08:47:31',	'2023-10-27 08:47:31',	NULL),
(345,	8,	11,	'1-Information Sheet 1.1.3-d63c72e5-1a84-436f-9b9b-58e2304329d5',	'/1-Information Sheet 1.1.3-d63c72e5-1a84-436f-9b9b-58e2304329d5.docx',	'5253598',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 08:51:15',	'2023-10-27 08:51:15',	NULL),
(346,	8,	11,	'1-Information Sheet 1.1.4-3802730e-24f9-403f-99cd-4e1ae3bc2451',	'/1-Information Sheet 1.1.4-3802730e-24f9-403f-99cd-4e1ae3bc2451.docx',	'3953986',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 08:54:02',	'2023-10-27 08:54:02',	NULL),
(347,	8,	11,	'1-Information sheet 1.1.5-6284b84e-e554-4fa1-947c-f16c4ef36fa7',	'/1-Information sheet 1.1.5-6284b84e-e554-4fa1-947c-f16c4ef36fa7.docx',	'33871',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 08:54:10',	'2023-10-27 08:54:10',	NULL),
(348,	8,	11,	'1-Work Sheet 1.2.1-8851763a-447f-46f8-b910-537d236711de',	'/1-Work Sheet 1.2.1-8851763a-447f-46f8-b910-537d236711de.docx',	'2825526',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 08:54:27',	'2023-10-27 08:54:27',	NULL),
(349,	8,	11,	'1-Work Sheet 1.2.2-f5db4c1e-d437-47df-b534-346fc57a659f',	'/1-Work Sheet 1.2.2-f5db4c1e-d437-47df-b534-346fc57a659f.docx',	'1071356',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 08:54:34',	'2023-10-27 08:54:34',	NULL),
(350,	8,	11,	'1-Work Sheet 1.2.3-f4797fdc-9b28-4493-b3a0-98df848d79f5',	'/1-Work Sheet 1.2.3-f4797fdc-9b28-4493-b3a0-98df848d79f5.docx',	'4888219',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 08:54:49',	'2023-10-27 08:54:49',	NULL),
(351,	8,	11,	'1-Work Sheet 1.2.4-8aec49a3-56dc-41dd-9807-497e5e55436d',	'/1-Work Sheet 1.2.4-8aec49a3-56dc-41dd-9807-497e5e55436d.docx',	'3023965',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 08:55:01',	'2023-10-27 08:55:01',	NULL),
(352,	8,	11,	'1-Work sheet 1.2.5-fd275bdd-6d06-491f-a046-df9e9c40176b',	'/1-Work sheet 1.2.5-fd275bdd-6d06-491f-a046-df9e9c40176b.docx',	'866975',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 08:55:10',	'2023-10-27 08:55:10',	NULL),
(353,	8,	12,	'1-Information Sheet 2.1.1-7c9220e9-dc85-4b65-bac2-549c2690aec0',	'/1-Information Sheet 2.1.1-7c9220e9-dc85-4b65-bac2-549c2690aec0.docx',	'556630',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 09:15:16',	'2023-10-27 09:15:16',	NULL),
(354,	8,	12,	'1-Information Sheet 2.1.2-992eb412-6dd9-48a0-9101-9812c2a504c0',	'/1-Information Sheet 2.1.2-992eb412-6dd9-48a0-9101-9812c2a504c0.docx',	'600939',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 09:15:25',	'2023-10-27 09:15:25',	NULL),
(355,	8,	12,	'1-Information Sheet 2.1.3-ec7e59c1-1574-412a-968a-a994d27eb511',	'/1-Information Sheet 2.1.3-ec7e59c1-1574-412a-968a-a994d27eb511.docx',	'2636759',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 09:15:34',	'2023-10-27 09:15:34',	NULL),
(356,	8,	12,	'1-Worksheet 2.2.1-895788b4-3885-49e0-a2a8-e7834a5a92c3',	'/1-Worksheet 2.2.1-895788b4-3885-49e0-a2a8-e7834a5a92c3.docx',	'469089',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 09:15:41',	'2023-10-27 09:15:41',	NULL),
(357,	8,	12,	'1-Worksheet 2.2.2-c1280465-d840-4591-9a6d-f57410c322d8',	'/1-Worksheet 2.2.2-c1280465-d840-4591-9a6d-f57410c322d8.docx',	'2465232',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 09:15:51',	'2023-10-27 09:15:51',	NULL),
(358,	8,	12,	'1-Worksheet 2.2.2-5446e69b-802b-4084-8afe-afe11a404f91',	'/1-Worksheet 2.2.2-5446e69b-802b-4084-8afe-afe11a404f91.docx',	'2465232',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 09:15:59',	'2023-10-27 09:16:08',	'2023-10-27 09:16:08'),
(359,	8,	12,	'1-Worksheet 2.2.3-5b8b9bb1-3f65-47ed-978d-9be6ac0cc338',	'/1-Worksheet 2.2.3-5b8b9bb1-3f65-47ed-978d-9be6ac0cc338.docx',	'3180396',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 09:16:19',	'2023-10-27 09:16:19',	NULL),
(360,	8,	13,	'1-Information Sheet 3.1.1-ec379fa5-e39a-445b-a66e-e668392a8a15',	'/1-Information Sheet 3.1.1-ec379fa5-e39a-445b-a66e-e668392a8a15.docx',	'1440244',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:45:37',	'2023-10-27 16:45:37',	NULL),
(361,	8,	13,	'1-Information Sheet 3.1.2-0ee78294-1d51-4fa2-b337-ab5632bde7f1',	'/1-Information Sheet 3.1.2-0ee78294-1d51-4fa2-b337-ab5632bde7f1.docx',	'1065674',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:45:45',	'2023-10-27 16:45:45',	NULL),
(362,	8,	13,	'1-Information Sheet 3.1.3-73d724cc-e323-4881-a604-2e4694a80c50',	'/1-Information Sheet 3.1.3-73d724cc-e323-4881-a604-2e4694a80c50.docx',	'1314686',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:46:04',	'2023-10-27 16:46:04',	NULL),
(363,	8,	13,	'1-Worksheet 3.2.1-f1643433-26c9-4fb3-9848-3abeeded1faf',	'/1-Worksheet 3.2.1-f1643433-26c9-4fb3-9848-3abeeded1faf.docx',	'1467477',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:46:11',	'2023-10-27 16:46:11',	NULL),
(364,	8,	13,	'1-Worksheet 3.2.2-0809f49d-d751-4155-8a06-17d8313fc38d',	'/1-Worksheet 3.2.2-0809f49d-d751-4155-8a06-17d8313fc38d.docx',	'2196180',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:46:17',	'2023-10-27 16:46:17',	NULL),
(365,	8,	13,	'1-Worksheet 3.2.3-6b729acf-439a-43d8-8da1-b07a19ce9cbf',	'/1-Worksheet 3.2.3-6b729acf-439a-43d8-8da1-b07a19ce9cbf.docx',	'3107788',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:46:31',	'2023-10-27 16:46:31',	NULL),
(366,	8,	15,	'1.Information Sheet 1.1.1-19b699e4-0d16-4ea5-b881-211ea0e7f19d',	'/1.Information Sheet 1.1.1-19b699e4-0d16-4ea5-b881-211ea0e7f19d.docx',	'1355480',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:48:08',	'2023-10-27 16:48:08',	NULL),
(367,	8,	15,	'1.Information Sheet 1.1.2-6c73f27b-34ad-40fc-b34d-fc31b267d072',	'/1.Information Sheet 1.1.2-6c73f27b-34ad-40fc-b34d-fc31b267d072.docx',	'1077156',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:48:15',	'2023-10-27 16:48:15',	NULL),
(368,	8,	15,	'1.Information Sheet 1.1.3-5a07c6a1-911a-450f-9c3d-864adc3649db',	'/1.Information Sheet 1.1.3-5a07c6a1-911a-450f-9c3d-864adc3649db.docx',	'1338588',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:48:22',	'2023-10-27 16:48:22',	NULL),
(369,	8,	15,	'1.Information Sheet 1.1.4-71222930-54ac-4b69-838f-1f9c00bbe010',	'/1.Information Sheet 1.1.4-71222930-54ac-4b69-838f-1f9c00bbe010.docx',	'1130577',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:48:30',	'2023-10-27 16:48:30',	NULL),
(370,	8,	15,	'1.Worksheet 1.2.1-c544e7ae-e392-4a30-9743-a51bf4d8d363',	'/1.Worksheet 1.2.1-c544e7ae-e392-4a30-9743-a51bf4d8d363.docx',	'1360614',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:48:37',	'2023-10-27 16:48:37',	NULL),
(371,	8,	15,	'1.Worksheet 1.2.2-2a052baa-eb12-43a3-b985-8323f2a9d243',	'/1.Worksheet 1.2.2-2a052baa-eb12-43a3-b985-8323f2a9d243.docx',	'1980078',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:48:43',	'2023-10-27 16:48:43',	NULL),
(372,	8,	15,	'1.WorkSheet 1.2.3-3c6fa2a2-6f50-4545-aac3-9a7ea57f94d4',	'/1.WorkSheet 1.2.3-3c6fa2a2-6f50-4545-aac3-9a7ea57f94d4.docx',	'4281843',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:48:52',	'2023-10-27 16:48:52',	NULL),
(373,	8,	15,	'1.Worksheet 1.2.4-fbed2a50-18f7-4d7d-b90d-845e44ef6ce1',	'/1.Worksheet 1.2.4-fbed2a50-18f7-4d7d-b90d-845e44ef6ce1.docx',	'1575034',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:49:11',	'2023-10-27 16:49:11',	NULL),
(374,	8,	16,	'2. Information Sheet 2.1.1-da0780b8-01da-4f2a-b5d7-461ad080e48f',	'/2. Information Sheet 2.1.1-da0780b8-01da-4f2a-b5d7-461ad080e48f.docx',	'584759',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:50:17',	'2023-10-27 16:50:17',	NULL),
(375,	8,	16,	'2. Information Sheet 2.1.2-638a1109-45f7-4827-a00c-abc8c4372766',	'/2. Information Sheet 2.1.2-638a1109-45f7-4827-a00c-abc8c4372766.docx',	'502341',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:50:24',	'2023-10-27 16:50:24',	NULL),
(376,	8,	16,	'2. Information Sheet 2.1.3-fffe6b81-70cd-41de-8d33-a8f46f081096',	'/2. Information Sheet 2.1.3-fffe6b81-70cd-41de-8d33-a8f46f081096.docx',	'631856',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:50:31',	'2023-10-27 16:50:31',	NULL),
(377,	8,	16,	'2. Inoformation Sheet 2.1.4-bebec371-8364-4ae4-a563-0b0758c9a90d',	'/2. Inoformation Sheet 2.1.4-bebec371-8364-4ae4-a563-0b0758c9a90d.docx',	'1280997',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:50:37',	'2023-10-27 16:50:37',	NULL),
(378,	8,	16,	'2.Worksheet 2.2.1-21f1a2ac-e50e-4c0e-80b8-4aeed240fc75',	'/2.Worksheet 2.2.1-21f1a2ac-e50e-4c0e-80b8-4aeed240fc75.docx',	'565645',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:50:45',	'2023-10-27 16:50:45',	NULL),
(379,	8,	16,	'2.Worksheet 2.2.2-0ac7730a-41f4-46b9-beee-0e173250c6d0',	'/2.Worksheet 2.2.2-0ac7730a-41f4-46b9-beee-0e173250c6d0.docx',	'1518995',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:50:52',	'2023-10-27 16:50:52',	NULL),
(380,	8,	16,	'2.Worksheet 2.2.3-a74d4e45-0f9e-49a3-b690-0f19350a0789',	'/2.Worksheet 2.2.3-a74d4e45-0f9e-49a3-b690-0f19350a0789.docx',	'3429008',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:51:03',	'2023-10-27 16:51:03',	NULL),
(381,	8,	16,	'2.Worksheet 2.2.4-c86dd4cf-5c4c-4f65-b457-1a5a81533438',	'/2.Worksheet 2.2.4-c86dd4cf-5c4c-4f65-b457-1a5a81533438.docx',	'993219',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:51:10',	'2023-10-27 16:51:10',	NULL),
(382,	8,	17,	'3. Information Sheet 3.1.1-783ec8ef-5395-4379-b2cb-8c2d14bb6af9',	'/3. Information Sheet 3.1.1-783ec8ef-5395-4379-b2cb-8c2d14bb6af9.docx',	'1001102',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:52:02',	'2023-10-27 16:52:02',	NULL),
(383,	8,	17,	'3. Information Sheet 3.1.2-7e15dd8d-2e37-4be2-aebc-63f5059e1574',	'/3. Information Sheet 3.1.2-7e15dd8d-2e37-4be2-aebc-63f5059e1574.docx',	'2991815',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:52:09',	'2023-10-27 16:53:12',	'2023-10-27 16:53:12'),
(384,	8,	17,	'3. Information Sheet 3.1.3-a5fb45c3-5b9c-4adc-b9dc-a0596d1a7d10',	'/3. Information Sheet 3.1.3-a5fb45c3-5b9c-4adc-b9dc-a0596d1a7d10.docx',	'1095098',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:52:16',	'2023-10-27 16:53:09',	'2023-10-27 16:53:09'),
(385,	8,	17,	'3.Worksheet 3.2.1-74a36d03-b96c-41e7-8cfd-f2268d6d730e',	'/3.Worksheet 3.2.1-74a36d03-b96c-41e7-8cfd-f2268d6d730e.docx',	'1269840',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:52:24',	'2023-10-27 16:52:24',	NULL),
(386,	8,	17,	'3. Information Sheet 3.1.2-ddf57bc4-50fd-44b8-87f0-6e346f410f05',	'/3. Information Sheet 3.1.2-ddf57bc4-50fd-44b8-87f0-6e346f410f05.docx',	'2991815',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:53:22',	'2023-10-27 16:53:22',	NULL),
(387,	8,	17,	'3.Worksheet 3.2.2-8b878f93-a802-41d2-9622-324072f7d832',	'/3.Worksheet 3.2.2-8b878f93-a802-41d2-9622-324072f7d832.docx',	'740449',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:53:29',	'2023-10-27 16:53:29',	NULL),
(388,	8,	17,	'3. Information Sheet 3.1.3-e79ebaf1-eea2-4d28-bff2-45cb648e3d84',	'/3. Information Sheet 3.1.3-e79ebaf1-eea2-4d28-bff2-45cb648e3d84.docx',	'1095098',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:53:37',	'2023-10-27 16:53:37',	NULL),
(389,	8,	17,	'3.Worksheet 3.2.3-60057993-b975-44fe-a0a8-abe0476e77cc',	'/3.Worksheet 3.2.3-60057993-b975-44fe-a0a8-abe0476e77cc.docx',	'888075',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:53:44',	'2023-10-27 16:53:44',	NULL),
(390,	8,	19,	'3. Information Sheet 1.1.1-744a222b-cfa9-4b95-8f27-34370b5e3d00',	'/3. Information Sheet 1.1.1-744a222b-cfa9-4b95-8f27-34370b5e3d00.docx',	'2661818',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:54:38',	'2023-10-27 16:54:38',	NULL),
(391,	8,	19,	'3. Work Sheet 1.2.1-eb2c843d-496c-4580-bff2-6767d1fc17a4',	'/3. Work Sheet 1.2.1-eb2c843d-496c-4580-bff2-6767d1fc17a4.docx',	'4548737',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:54:48',	'2023-10-27 16:54:48',	NULL),
(392,	8,	19,	'3. Information Sheet 1.1.2-0d97d01f-2dda-4ce6-87fa-9054e30aea6d',	'/3. Information Sheet 1.1.2-0d97d01f-2dda-4ce6-87fa-9054e30aea6d.docx',	'723290',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:54:54',	'2023-10-27 16:54:54',	NULL),
(393,	8,	19,	'3. Work Sheet 1.2.2-3de45c88-b51d-43bd-abab-9d774a2eada6',	'/3. Work Sheet 1.2.2-3de45c88-b51d-43bd-abab-9d774a2eada6.docx',	'1779652',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:55:02',	'2023-10-27 16:55:02',	NULL),
(394,	8,	19,	'3. Information Sheet 1.1.3-5fbde362-219d-4457-87cf-3fd26928b624',	'/3. Information Sheet 1.1.3-5fbde362-219d-4457-87cf-3fd26928b624.docx',	'970985',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:55:09',	'2023-10-27 16:55:09',	NULL),
(395,	8,	19,	'3. Work Sheet 1.2.3-b47405a3-6753-457c-bc1a-05940115f077',	'/3. Work Sheet 1.2.3-b47405a3-6753-457c-bc1a-05940115f077.docx',	'2733238',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:55:15',	'2023-10-27 16:55:15',	NULL),
(396,	8,	20,	'3. Information Sheet 2.1.1-b395ba00-51a7-4286-9fe0-7af7d2b8a6eb',	'/3. Information Sheet 2.1.1-b395ba00-51a7-4286-9fe0-7af7d2b8a6eb.docx',	'1557214',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:55:53',	'2023-10-27 16:55:53',	NULL),
(397,	8,	20,	'3. Worksheet 2.2.1-341df34c-9af4-4936-a43e-3b6b480174e6',	'/3. Worksheet 2.2.1-341df34c-9af4-4936-a43e-3b6b480174e6.docx',	'2295006',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:56:02',	'2023-10-27 16:56:02',	NULL),
(398,	8,	20,	'3. Information Sheet 2.1.2-c982d977-09b4-4159-8b95-bc27cda48643',	'/3. Information Sheet 2.1.2-c982d977-09b4-4159-8b95-bc27cda48643.docx',	'1330133',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:56:09',	'2023-10-27 16:56:09',	NULL),
(399,	8,	20,	'3. Worksheet 2.2.2-7f65ea75-7184-4a4b-8ca8-4cc7fba4cd00',	'/3. Worksheet 2.2.2-7f65ea75-7184-4a4b-8ca8-4cc7fba4cd00.docx',	'1857092',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:56:17',	'2023-10-27 16:56:17',	NULL),
(400,	8,	20,	'3. Information Sheet 2.1.3-0f531b84-af36-499e-ae76-68d4997ab16e',	'/3. Information Sheet 2.1.3-0f531b84-af36-499e-ae76-68d4997ab16e.docx',	'1562315',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:56:24',	'2023-10-27 16:56:24',	NULL),
(401,	8,	20,	'3. Worksheet 2.2.3-e57219bc-e5f9-4a27-9782-e8fc4f6b1554',	'/3. Worksheet 2.2.3-e57219bc-e5f9-4a27-9782-e8fc4f6b1554.docx',	'1886239',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:56:30',	'2023-10-27 16:56:30',	NULL),
(402,	8,	20,	'3. Information Sheet 2.1.4-31584909-d59b-48c9-971d-3f39b7f9de60',	'/3. Information Sheet 2.1.4-31584909-d59b-48c9-971d-3f39b7f9de60.docx',	'2211222',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:56:40',	'2023-10-27 16:56:40',	NULL),
(403,	8,	20,	'3. Worksheet 2.2.4-b33bf0c6-d3fb-485c-bdb1-68abfe917b8b',	'/3. Worksheet 2.2.4-b33bf0c6-d3fb-485c-bdb1-68abfe917b8b.docx',	'2283076',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-27 16:56:48',	'2023-10-27 16:56:48',	NULL),
(404,	8,	21,	'3. Information Sheet 3.1.1-1f742854-7149-4cd0-9785-9f2c1aa7d2ce',	'/3. Information Sheet 3.1.1-1f742854-7149-4cd0-9785-9f2c1aa7d2ce.docx',	'1001102',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-28 14:17:48',	'2023-10-28 14:17:48',	NULL),
(405,	8,	21,	'3.Worksheet 3.2.1-2a13a368-80b2-4577-9b18-4a2d512364df',	'/3.Worksheet 3.2.1-2a13a368-80b2-4577-9b18-4a2d512364df.docx',	'1269840',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-28 14:17:57',	'2023-10-28 14:17:57',	NULL),
(406,	8,	21,	'3. Information Sheet 3.1.2-c6c86e47-010a-41ca-a1db-72a8d1c01ef5',	'/3. Information Sheet 3.1.2-c6c86e47-010a-41ca-a1db-72a8d1c01ef5.docx',	'2991815',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-28 14:22:34',	'2023-10-28 14:22:34',	NULL),
(407,	8,	21,	'3.Worksheet 3.2.2-277602b7-e4b2-4c5c-bb1a-92137f582169',	'/3.Worksheet 3.2.2-277602b7-e4b2-4c5c-bb1a-92137f582169.docx',	'740449',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-28 14:22:40',	'2023-10-28 14:22:40',	NULL),
(408,	8,	21,	'3. Information Sheet 3.1.3-97740704-32b2-46b6-a87e-2ef2fdb941ff',	'/3. Information Sheet 3.1.3-97740704-32b2-46b6-a87e-2ef2fdb941ff.docx',	'1095098',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-28 14:22:50',	'2023-10-28 14:22:50',	NULL),
(409,	8,	21,	'3.Worksheet 3.2.3-58ec96d6-5a8d-4ea6-a047-48b8e9e54b09',	'/3.Worksheet 3.2.3-58ec96d6-5a8d-4ea6-a047-48b8e9e54b09.docx',	'888075',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-28 14:22:57',	'2023-10-28 14:22:57',	NULL),
(410,	8,	24,	'3. Information Sheet 1.1.1-fcb54a43-155a-445f-b5a0-cb95321712db',	'/3. Information Sheet 1.1.1-fcb54a43-155a-445f-b5a0-cb95321712db.docx',	'2661818',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-28 14:24:55',	'2023-10-28 14:24:55',	NULL),
(411,	8,	24,	'3. Work Sheet 1.2.1-d283e58c-6b36-47c1-9818-1ad92a45bdad',	'/3. Work Sheet 1.2.1-d283e58c-6b36-47c1-9818-1ad92a45bdad.docx',	'4548737',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-28 14:25:05',	'2023-10-28 14:25:05',	NULL),
(412,	8,	24,	'3. Information Sheet 1.1.2-96990424-ab91-4dd4-8b03-2020129d4166',	'/3. Information Sheet 1.1.2-96990424-ab91-4dd4-8b03-2020129d4166.docx',	'723290',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-28 14:25:12',	'2023-10-28 14:25:12',	NULL),
(413,	8,	24,	'3. Work Sheet 1.2.2-c4bd7657-2d5f-4aa5-8cdf-0d6e334fb325',	'/3. Work Sheet 1.2.2-c4bd7657-2d5f-4aa5-8cdf-0d6e334fb325.docx',	'1779652',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-28 14:25:20',	'2023-10-28 14:25:20',	NULL),
(414,	8,	24,	'3. Information Sheet 1.1.3-f4b01ccd-f098-4fef-8a6b-0fa086501ed2',	'/3. Information Sheet 1.1.3-f4b01ccd-f098-4fef-8a6b-0fa086501ed2.docx',	'970985',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-28 14:25:27',	'2023-10-28 14:25:27',	NULL),
(415,	8,	24,	'3. Work Sheet 1.2.3-3dbca036-fa2b-4033-884d-45c7c48fe074',	'/3. Work Sheet 1.2.3-3dbca036-fa2b-4033-884d-45c7c48fe074.docx',	'2733238',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-28 14:25:36',	'2023-10-28 14:25:36',	NULL),
(416,	8,	23,	'3. Information Sheet 2.1.1-ce3836b9-a016-4504-b978-d484bc49f241',	'/3. Information Sheet 2.1.1-ce3836b9-a016-4504-b978-d484bc49f241.docx',	'1557214',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-28 14:27:34',	'2023-10-28 14:27:34',	NULL),
(417,	8,	23,	'3. Worksheet 2.2.1-906feea1-6f3b-4140-a3ec-65b699bd7dda',	'/3. Worksheet 2.2.1-906feea1-6f3b-4140-a3ec-65b699bd7dda.docx',	'2295006',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-28 14:27:43',	'2023-10-28 14:27:43',	NULL),
(418,	8,	23,	'3. Information Sheet 2.1.2-dfac9c00-8128-4735-a7e6-5fd81fc95783',	'/3. Information Sheet 2.1.2-dfac9c00-8128-4735-a7e6-5fd81fc95783.docx',	'1330133',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-28 14:27:50',	'2023-10-28 14:27:50',	NULL),
(419,	8,	23,	'3. Worksheet 2.2.2-6cad3ec4-6ab2-438d-b7a6-78945fb11cf8',	'/3. Worksheet 2.2.2-6cad3ec4-6ab2-438d-b7a6-78945fb11cf8.docx',	'1857092',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-28 14:27:58',	'2023-10-28 14:27:58',	NULL),
(420,	8,	23,	'3. Information Sheet 2.1.3-ed51fadf-45c1-4aae-85c1-6efcb65bb074',	'/3. Information Sheet 2.1.3-ed51fadf-45c1-4aae-85c1-6efcb65bb074.docx',	'1562315',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-28 14:28:07',	'2023-10-28 14:28:07',	NULL),
(421,	8,	23,	'3. Worksheet 2.2.3-396f8119-6894-4327-a772-97f5927a01a2',	'/3. Worksheet 2.2.3-396f8119-6894-4327-a772-97f5927a01a2.docx',	'1886239',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-28 14:28:21',	'2023-10-28 14:28:21',	NULL),
(422,	8,	23,	'3. Information Sheet 2.1.4-41071d06-8c1d-45a6-b8e3-c8a4ba8bac28',	'/3. Information Sheet 2.1.4-41071d06-8c1d-45a6-b8e3-c8a4ba8bac28.docx',	'2211222',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-28 14:28:32',	'2023-10-28 14:28:32',	NULL),
(423,	8,	23,	'3. Worksheet 2.2.4-107f9936-69c6-425d-8d15-07cfea5fabd3',	'/3. Worksheet 2.2.4-107f9936-69c6-425d-8d15-07cfea5fabd3.docx',	'2283076',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-28 14:28:43',	'2023-10-28 14:28:43',	NULL),
(424,	8,	25,	'4- Information Sheet 3.1.1-e2dc26fc-22ef-413a-ab35-f1a37c2731c1',	'/4- Information Sheet 3.1.1-e2dc26fc-22ef-413a-ab35-f1a37c2731c1.docx',	'853682',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-28 14:41:30',	'2023-10-28 14:41:30',	NULL),
(425,	8,	25,	'4- Worksheet 3.2.1-90b11dbf-28bf-48bc-96ee-a616e33f6811',	'/4- Worksheet 3.2.1-90b11dbf-28bf-48bc-96ee-a616e33f6811.docx',	'2905177',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-28 14:41:50',	'2023-10-28 14:41:50',	NULL),
(426,	8,	25,	'4- Information Sheet 3.1.2-94c6b1b7-3e23-45f9-a6bb-93eb6fdd5964',	'/4- Information Sheet 3.1.2-94c6b1b7-3e23-45f9-a6bb-93eb6fdd5964.docx',	'1025711',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-28 14:41:58',	'2023-10-28 14:41:58',	NULL),
(427,	8,	25,	'4- Worksheet 3.2.2-8bad6c79-5558-406a-b73c-a96fdda1defa',	'/4- Worksheet 3.2.2-8bad6c79-5558-406a-b73c-a96fdda1defa.docx',	'816309',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-28 14:42:05',	'2023-10-28 14:42:05',	NULL),
(428,	8,	27,	'5-Information Sheet 1.1.1-58b54f2b-2d36-466f-938b-aadab6015b29',	'/5-Information Sheet 1.1.1-58b54f2b-2d36-466f-938b-aadab6015b29.docx',	'1319688',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 09:51:43',	'2023-10-30 09:51:43',	NULL),
(429,	8,	27,	'5-Work Sheet From 1.2.1-3453a15a-3714-437a-8745-3d1e72b33050',	'/5-Work Sheet From 1.2.1-3453a15a-3714-437a-8745-3d1e72b33050.docx',	'1322600',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 09:52:00',	'2023-10-30 09:52:00',	NULL),
(430,	8,	27,	'5-Information Sheet 1.1.2-6226c5cf-e242-4891-ab44-f7336d4e59a5',	'/5-Information Sheet 1.1.2-6226c5cf-e242-4891-ab44-f7336d4e59a5.docx',	'1309381',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 09:52:07',	'2023-10-30 09:52:07',	NULL),
(431,	8,	27,	'5-Work Sheet From 1.2.2-6fa95421-0a78-4be5-860d-09bb18b5559a',	'/5-Work Sheet From 1.2.2-6fa95421-0a78-4be5-860d-09bb18b5559a.docx',	'1315206',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 09:52:17',	'2023-10-30 09:52:17',	NULL),
(432,	8,	27,	'5-Information Sheet 1.1.3-63f87619-1439-4cf0-9f89-d52e4ad16c1c',	'/5-Information Sheet 1.1.3-63f87619-1439-4cf0-9f89-d52e4ad16c1c.docx',	'456560',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 09:52:34',	'2023-10-30 09:52:34',	NULL),
(433,	8,	27,	'5-Work Sheet From 1.2.3-284e42db-643d-4ba1-96df-2d8a29b41200',	'/5-Work Sheet From 1.2.3-284e42db-643d-4ba1-96df-2d8a29b41200.docx',	'229858',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 09:52:43',	'2023-10-30 09:52:43',	NULL),
(434,	8,	28,	'5-Information Sheet 2.1.1-dbf82e89-a7d7-4ce2-8e7e-1d566ccd7d1d',	'/5-Information Sheet 2.1.1-dbf82e89-a7d7-4ce2-8e7e-1d566ccd7d1d.docx',	'1336194',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 09:57:09',	'2023-10-30 09:57:09',	NULL),
(435,	8,	28,	'5-Work Sheet From 2.2.1-e43674f1-7ffa-423c-a712-b19f50ea5b95',	'/5-Work Sheet From 2.2.1-e43674f1-7ffa-423c-a712-b19f50ea5b95.docx',	'44716',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 09:57:18',	'2023-10-30 09:57:18',	NULL),
(436,	8,	28,	'5-Information Sheet 2.1.2-9a8700ea-79d3-47eb-8ec3-350f68bbd5a0',	'/5-Information Sheet 2.1.2-9a8700ea-79d3-47eb-8ec3-350f68bbd5a0.docx',	'1433153',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:07:44',	'2023-10-30 10:07:44',	NULL),
(437,	8,	28,	'5-Work Sheet From 2.2.2-0cbae0f7-8b92-4bc7-ae41-d2fa67bce215',	'/5-Work Sheet From 2.2.2-0cbae0f7-8b92-4bc7-ae41-d2fa67bce215.docx',	'220642',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:07:51',	'2023-10-30 10:07:51',	NULL),
(438,	8,	28,	'5-Information Sheet 2.1.3-59b5ecbc-9d69-4e49-af44-0340e082bc2b',	'/5-Information Sheet 2.1.3-59b5ecbc-9d69-4e49-af44-0340e082bc2b.docx',	'29537',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:07:59',	'2023-10-30 10:07:59',	NULL),
(439,	8,	28,	'5-Work Sheet From 2.2.3-881bf954-8169-4ba4-a6d9-5ca4014dc1c7',	'/5-Work Sheet From 2.2.3-881bf954-8169-4ba4-a6d9-5ca4014dc1c7.docx',	'335951',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:08:06',	'2023-10-30 10:08:06',	NULL),
(440,	8,	29,	'3-Information Sheet 3.1.1-797b8393-134d-47ea-a8d9-8422c5319363',	'/3-Information Sheet 3.1.1-797b8393-134d-47ea-a8d9-8422c5319363.docx',	'597494',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:08:32',	'2023-10-30 10:08:32',	NULL),
(441,	8,	29,	'4-Work Sheet From 3.2.1-9cfbc404-ea3a-4940-ac5a-35b5921a2906',	'/4-Work Sheet From 3.2.1-9cfbc404-ea3a-4940-ac5a-35b5921a2906.docx',	'402345',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:08:40',	'2023-10-30 10:08:40',	NULL),
(442,	8,	29,	'3-Information Sheet 3.1.2-4afaf731-ba64-4f90-b365-880d229d08ae',	'/3-Information Sheet 3.1.2-4afaf731-ba64-4f90-b365-880d229d08ae.docx',	'307995',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:08:48',	'2023-10-30 10:08:48',	NULL),
(443,	8,	29,	'4-Work Sheet From 3.2.2-94b9496e-3110-4695-b863-f2ae24cf43fd',	'/4-Work Sheet From 3.2.2-94b9496e-3110-4695-b863-f2ae24cf43fd.docx',	'44817',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:08:57',	'2023-10-30 10:08:57',	NULL),
(444,	8,	29,	'3-Information Sheet 3.1.3-a49c5ac4-05a2-4f68-b338-5b91d606e1f0',	'/3-Information Sheet 3.1.3-a49c5ac4-05a2-4f68-b338-5b91d606e1f0.docx',	'7226513',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:09:10',	'2023-10-30 10:09:10',	NULL),
(445,	8,	29,	'4-Work Sheet From 3.2.3-cef49b0e-a84c-4d6c-885e-d32037c94f3c',	'/4-Work Sheet From 3.2.3-cef49b0e-a84c-4d6c-885e-d32037c94f3c.docx',	'1320620',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:09:21',	'2023-10-30 10:09:21',	NULL),
(446,	8,	29,	'3-Information Sheet 3.1.4-cb6370aa-c0ca-440a-9149-a2b5f729d7f5',	'/3-Information Sheet 3.1.4-cb6370aa-c0ca-440a-9149-a2b5f729d7f5.docx',	'30605',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:09:38',	'2023-10-30 10:09:38',	NULL),
(447,	8,	29,	'4-Work Sheet From 3.2.4-2e1511dd-b353-491e-b889-6f2015b03520',	'/4-Work Sheet From 3.2.4-2e1511dd-b353-491e-b889-6f2015b03520.docx',	'310817',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:09:52',	'2023-10-30 10:09:52',	NULL),
(448,	8,	29,	'4-Work Sheet From 3.2.5-185a5b02-3d7f-4ea8-ae79-7462d23f9516',	'/4-Work Sheet From 3.2.5-185a5b02-3d7f-4ea8-ae79-7462d23f9516.docx',	'214858',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:10:02',	'2023-10-30 10:10:02',	NULL),
(449,	8,	30,	'3-Information Sheet 4.1.1-755789eb-82df-456a-9a2f-2303f916606b',	'/3-Information Sheet 4.1.1-755789eb-82df-456a-9a2f-2303f916606b.docx',	'28769',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:20:22',	'2023-10-30 10:20:22',	NULL),
(450,	8,	30,	'4-Work Sheet From 4.2.1-dde7f086-b44e-4c3c-974c-d6111e879a31',	'/4-Work Sheet From 4.2.1-dde7f086-b44e-4c3c-974c-d6111e879a31.docx',	'252898',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:26:56',	'2023-10-30 10:26:56',	NULL),
(451,	8,	30,	'3-Information Sheet 4.1.2-820bc66b-94e5-4518-927a-f51128ee14f9',	'/3-Information Sheet 4.1.2-820bc66b-94e5-4518-927a-f51128ee14f9.docx',	'27245',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:27:08',	'2023-10-30 10:27:08',	NULL),
(452,	8,	30,	'4-Work Sheet From 4.2.2-38b105a5-4e7a-4f88-aca1-1b481ad571d7',	'/4-Work Sheet From 4.2.2-38b105a5-4e7a-4f88-aca1-1b481ad571d7.docx',	'38469',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:29:18',	'2023-10-30 10:29:18',	NULL),
(453,	8,	30,	'3-Information Sheet 4.1.3-78aaadf1-af6a-4d7a-9427-361c11246381',	'/3-Information Sheet 4.1.3-78aaadf1-af6a-4d7a-9427-361c11246381.docx',	'593574',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:32:59',	'2023-10-30 10:32:59',	NULL),
(454,	8,	30,	'4-Work Sheet From 4.2.3-06c56aaf-e542-4ef2-a330-ce18f937a10a',	'/4-Work Sheet From 4.2.3-06c56aaf-e542-4ef2-a330-ce18f937a10a.docx',	'198258',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:33:10',	'2023-10-30 10:33:10',	NULL),
(455,	8,	32,	'6-Information Sheet 1.1.1-1bf90305-3941-4e4c-b7aa-24d47e53eef4',	'/6-Information Sheet 1.1.1-1bf90305-3941-4e4c-b7aa-24d47e53eef4.docx',	'215191',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:36:37',	'2023-10-30 10:36:37',	NULL),
(456,	8,	32,	'6-Work Sheet 1.2.1-365ff9e8-c195-4158-b624-9008fa460d77',	'/6-Work Sheet 1.2.1-365ff9e8-c195-4158-b624-9008fa460d77.docx',	'357160',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:36:45',	'2023-10-30 10:36:45',	NULL),
(457,	8,	32,	'6-Information Sheet 1.1.2-aac1be79-9e0a-47f0-ace3-21b1a3ac8500',	'/6-Information Sheet 1.1.2-aac1be79-9e0a-47f0-ace3-21b1a3ac8500.docx',	'518738',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:36:53',	'2023-10-30 10:36:53',	NULL),
(458,	8,	32,	'6-Work Sheet 1.2.2-c935ada4-8df2-47e5-8199-998c238a4558',	'/6-Work Sheet 1.2.2-c935ada4-8df2-47e5-8199-998c238a4558.docx',	'191311',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:37:01',	'2023-10-30 10:37:01',	NULL),
(459,	8,	32,	'6-Information Sheet 1.1.3-1803d82a-4fec-43a6-9a43-db973e4aadc0',	'/6-Information Sheet 1.1.3-1803d82a-4fec-43a6-9a43-db973e4aadc0.docx',	'541796',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:37:09',	'2023-10-30 10:37:09',	NULL),
(460,	8,	32,	'6-Work Sheet 1.2.3-76be809f-0e36-451b-b05f-4ede531f2cd9',	'/6-Work Sheet 1.2.3-76be809f-0e36-451b-b05f-4ede531f2cd9.docx',	'411860',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:37:19',	'2023-10-30 10:37:19',	NULL),
(461,	8,	32,	'6-Information Sheet​ 1.1.4-dd35c6c6-721a-4ae7-ba07-2907d663647c',	'/6-Information Sheet​ 1.1.4-dd35c6c6-721a-4ae7-ba07-2907d663647c.docx',	'234435',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:37:28',	'2023-10-30 10:37:28',	NULL),
(462,	8,	32,	'6-Work Sheet 1.2.4-aa6616cb-5325-4ec7-bd23-2110df126e81',	'/6-Work Sheet 1.2.4-aa6616cb-5325-4ec7-bd23-2110df126e81.docx',	'1345472',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:37:35',	'2023-10-30 10:37:35',	NULL),
(463,	8,	33,	'6-Information Sheet 1.1.1-e280a395-3c45-4171-a550-f287bf32c4ea',	'/6-Information Sheet 1.1.1-e280a395-3c45-4171-a550-f287bf32c4ea.docx',	'215191',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:42:54',	'2023-10-30 10:42:54',	NULL),
(464,	8,	33,	'6-Work Sheet 1.2.1-5d579aa2-2cd2-4978-bc0c-c39ec77f7af7',	'/6-Work Sheet 1.2.1-5d579aa2-2cd2-4978-bc0c-c39ec77f7af7.docx',	'357160',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:50:45',	'2023-10-30 10:50:45',	NULL),
(465,	8,	33,	'6-Information Sheet 1.1.2-134774d3-ef44-477e-8e26-b60b176c74b3',	'/6-Information Sheet 1.1.2-134774d3-ef44-477e-8e26-b60b176c74b3.docx',	'518738',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:50:52',	'2023-10-30 10:50:52',	NULL),
(466,	8,	33,	'6-Work Sheet 1.2.2-94444901-e57f-4da0-8024-1cb0ebf67c89',	'/6-Work Sheet 1.2.2-94444901-e57f-4da0-8024-1cb0ebf67c89.docx',	'191311',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:51:02',	'2023-10-30 10:51:02',	NULL),
(467,	8,	33,	'6-Information Sheet 1.1.3-715db170-4c8c-407d-ae83-20498aec810f',	'/6-Information Sheet 1.1.3-715db170-4c8c-407d-ae83-20498aec810f.docx',	'541796',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:51:13',	'2023-10-30 10:51:13',	NULL),
(468,	8,	33,	'6-Work Sheet 1.2.3-1a2f4309-d59b-4ae6-9c3f-6f17a8f1f56d',	'/6-Work Sheet 1.2.3-1a2f4309-d59b-4ae6-9c3f-6f17a8f1f56d.docx',	'411860',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 10:51:20',	'2023-10-30 10:51:20',	NULL),
(469,	8,	33,	'6-Information Sheet​ 1.1.4-9d50ec58-8af2-4369-a025-3722097ec5ad',	'/6-Information Sheet​ 1.1.4-9d50ec58-8af2-4369-a025-3722097ec5ad.docx',	'234435',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 11:56:08',	'2023-10-30 11:56:08',	NULL),
(470,	8,	33,	'6-Work Sheet 1.2.4-c98bab6d-e25a-4260-97f4-a23714c722f1',	'/6-Work Sheet 1.2.4-c98bab6d-e25a-4260-97f4-a23714c722f1.docx',	'1345472',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-10-30 11:56:15',	'2023-10-30 11:56:15',	NULL),
(471,	1,	7,	'Lice-partner-12760207-d375-442b-8fae-181ec15e6df1',	'/Lice-partner-12760207-d375-442b-8fae-181ec15e6df1.jpg',	'275666',	1363,	500,	'jpg',	0,	1,	0,	0,	0,	'2023-11-14 05:56:52',	'2023-11-14 06:03:38',	'2023-11-14 06:03:38'),
(472,	1,	7,	'Lice-partner-94532f62-45fe-4968-a995-d599abdbc2ca',	'/Lice-partner-94532f62-45fe-4968-a995-d599abdbc2ca.jpg',	'213590',	1363,	500,	'jpg',	0,	1,	0,	0,	0,	'2023-11-14 06:03:44',	'2023-11-14 06:03:44',	NULL),
(473,	8,	42,	'2- Information 1.1.1-c82cec5d-19b9-46ce-8915-a5c50b8e5ad2',	'/2- Information 1.1.1-c82cec5d-19b9-46ce-8915-a5c50b8e5ad2.docx',	'1741738',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-14 16:01:16',	'2023-11-14 16:01:16',	NULL),
(474,	8,	42,	'2- Work Sheet 1.2.1-f41d06d7-596c-4e07-8624-e5c0f9b6597f',	'/2- Work Sheet 1.2.1-f41d06d7-596c-4e07-8624-e5c0f9b6597f.docx',	'744797',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-14 16:01:25',	'2023-11-14 16:01:25',	NULL),
(475,	8,	42,	'2- Information 1.1.2-2aff781b-2267-44aa-93ab-9441f6e7d77e',	'/2- Information 1.1.2-2aff781b-2267-44aa-93ab-9441f6e7d77e.docx',	'209945',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-14 16:01:33',	'2023-11-14 16:01:33',	NULL),
(476,	8,	42,	'2-​​ Work Sheet 1.2.2-d50de2ac-18e7-422a-8e9d-4748b3f831cb',	'/2-​​ Work Sheet 1.2.2-d50de2ac-18e7-422a-8e9d-4748b3f831cb.docx',	'630294',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-14 16:01:41',	'2023-11-14 16:01:41',	NULL),
(477,	8,	42,	'2- Information 1.1.3-99202a11-bfea-46df-b225-630f82f6554d',	'/2- Information 1.1.3-99202a11-bfea-46df-b225-630f82f6554d.docx',	'873659',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-14 16:01:56',	'2023-11-14 16:01:56',	NULL),
(478,	8,	42,	'2-​​ Work Sheet 1.2.3-1fb6b8ab-03da-4529-a0ff-70951d7339e7',	'/2-​​ Work Sheet 1.2.3-1fb6b8ab-03da-4529-a0ff-70951d7339e7.docx',	'360475',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-14 16:02:12',	'2023-11-14 16:02:12',	NULL),
(479,	8,	42,	'2- Information 1.1.4-59d1f159-213e-4f97-9044-92c635d646e1',	'/2- Information 1.1.4-59d1f159-213e-4f97-9044-92c635d646e1.docx',	'745916',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-14 16:02:23',	'2023-11-14 16:02:23',	NULL),
(480,	8,	42,	'2- Information 1.1.5-c880e9b9-773c-45c5-a16e-5f4ddfef5a62',	'/2- Information 1.1.5-c880e9b9-773c-45c5-a16e-5f4ddfef5a62.docx',	'203572',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-14 16:02:30',	'2023-11-14 16:02:30',	NULL),
(481,	8,	43,	'2- Information 1.1.1-f7d72246-27b0-4795-912c-abc6cb3ea1b4',	'/2- Information 1.1.1-f7d72246-27b0-4795-912c-abc6cb3ea1b4.docx',	'1741738',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-14 16:06:23',	'2023-11-14 16:06:23',	NULL),
(482,	8,	43,	'2- Work Sheet 1.2.1-f2226671-d511-47df-bff7-e78e0ac89e1b',	'/2- Work Sheet 1.2.1-f2226671-d511-47df-bff7-e78e0ac89e1b.docx',	'744797',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-14 16:06:32',	'2023-11-14 16:06:32',	NULL),
(483,	8,	43,	'2- Information 1.1.2-33c3b30c-2358-4bb7-93b2-660022638c15',	'/2- Information 1.1.2-33c3b30c-2358-4bb7-93b2-660022638c15.docx',	'209945',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-14 16:06:39',	'2023-11-14 16:06:39',	NULL),
(484,	8,	43,	'2-​​ Work Sheet 1.2.2-8f944e04-d6e0-43bd-8982-aa9aedf7fe4b',	'/2-​​ Work Sheet 1.2.2-8f944e04-d6e0-43bd-8982-aa9aedf7fe4b.docx',	'630294',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-14 16:06:48',	'2023-11-14 16:06:48',	NULL),
(485,	8,	43,	'2- Information 1.1.3-8eeacd43-5f14-4993-bfb0-a285c2eeaf0a',	'/2- Information 1.1.3-8eeacd43-5f14-4993-bfb0-a285c2eeaf0a.docx',	'873659',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-14 16:06:55',	'2023-11-14 16:06:55',	NULL),
(486,	8,	43,	'2-​​ Work Sheet 1.2.3-c6d2e083-0e46-47e0-be46-389f09e98b02',	'/2-​​ Work Sheet 1.2.3-c6d2e083-0e46-47e0-be46-389f09e98b02.docx',	'360475',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-14 16:07:03',	'2023-11-14 16:07:03',	NULL),
(487,	8,	43,	'2- Information 1.1.4-27061430-3fd9-4c4e-9ced-90a7c29bcc2a',	'/2- Information 1.1.4-27061430-3fd9-4c4e-9ced-90a7c29bcc2a.docx',	'745916',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-14 16:07:19',	'2023-11-14 16:07:19',	NULL),
(488,	8,	43,	'2- Information 1.1.5-008a0251-f1d2-48c5-8c5e-e9feeac3437b',	'/2- Information 1.1.5-008a0251-f1d2-48c5-8c5e-e9feeac3437b.docx',	'203572',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-14 16:07:31',	'2023-11-14 16:07:31',	NULL),
(489,	8,	44,	'2- Information 2.1.1-cfb65ba1-fd08-4384-9b9b-468062a9df76',	'/2- Information 2.1.1-cfb65ba1-fd08-4384-9b9b-468062a9df76.docx',	'840027',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:26:17',	'2023-11-15 09:26:17',	NULL),
(490,	8,	44,	'2- Work Sheet 2.2.1-52a88017-6010-4247-bf76-4662e52d747a',	'/2- Work Sheet 2.2.1-52a88017-6010-4247-bf76-4662e52d747a.docx',	'37651',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:26:25',	'2023-11-15 09:26:25',	NULL),
(491,	8,	44,	'2- Information 2.1.2-2efd4ba7-753e-470c-b80a-cf946dd5509e',	'/2- Information 2.1.2-2efd4ba7-753e-470c-b80a-cf946dd5509e.docx',	'677930',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:26:32',	'2023-11-15 09:26:32',	NULL),
(492,	8,	44,	'2-​​ Work Sheet 2.2.2-61a7ce0c-e3cb-48a0-add3-ea6899f6a727',	'/2-​​ Work Sheet 2.2.2-61a7ce0c-e3cb-48a0-add3-ea6899f6a727.docx',	'138160',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:26:40',	'2023-11-15 09:26:40',	NULL),
(493,	8,	44,	'2- Information 2.1.3-26860806-1cfe-484b-a188-a71a9e65cc34',	'/2- Information 2.1.3-26860806-1cfe-484b-a188-a71a9e65cc34.docx',	'329331',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:26:52',	'2023-11-15 09:26:52',	NULL),
(494,	8,	44,	'2-​​ Work Sheet 2.2.3-04a37898-3d59-4b79-b03f-89ff611bd716',	'/2-​​ Work Sheet 2.2.3-04a37898-3d59-4b79-b03f-89ff611bd716.docx',	'41979',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:26:59',	'2023-11-15 09:26:59',	NULL),
(495,	8,	45,	'2- Information 3.1.1 -705ca7fe-a50a-44d2-a8fe-bc64c12ed2b6',	'/2- Information 3.1.1 -705ca7fe-a50a-44d2-a8fe-bc64c12ed2b6.docx',	'231000',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:27:23',	'2023-11-15 09:27:23',	NULL),
(496,	8,	45,	'2- Work Sheet  3.2.1-51d12a0d-217e-45e0-8ff6-ec003c597774',	'/2- Work Sheet  3.2.1-51d12a0d-217e-45e0-8ff6-ec003c597774.docx',	'156644',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:27:30',	'2023-11-15 09:27:30',	NULL),
(497,	8,	45,	'2- Information 3.1.2-d7f620e7-9ac9-445e-93c8-389de42419ec',	'/2- Information 3.1.2-d7f620e7-9ac9-445e-93c8-389de42419ec.docx',	'207701',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:28:09',	'2023-11-15 09:28:09',	NULL),
(498,	8,	45,	'2- Work Sheet  3.2.2-91144cab-69bc-49ae-bac9-b4ce19e7f336',	'/2- Work Sheet  3.2.2-91144cab-69bc-49ae-bac9-b4ce19e7f336.docx',	'617835',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:28:16',	'2023-11-15 09:28:16',	NULL),
(499,	8,	45,	'2- Information 3.1.3-b094116d-cbc3-4b6f-b44e-3fdb42178a49',	'/2- Information 3.1.3-b094116d-cbc3-4b6f-b44e-3fdb42178a49.docx',	'416487',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:28:24',	'2023-11-15 09:28:24',	NULL),
(500,	8,	45,	'2- Work Sheet  3.2.3-95bbf81c-45f2-4a3d-962d-1085a090992e',	'/2- Work Sheet  3.2.3-95bbf81c-45f2-4a3d-962d-1085a090992e.docx',	'787352',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:28:37',	'2023-11-15 09:28:37',	NULL),
(501,	8,	45,	'2- Work Sheet  3.2.4-dda16dfa-fc2e-4d0e-befa-e4fd00c9d828',	'/2- Work Sheet  3.2.4-dda16dfa-fc2e-4d0e-befa-e4fd00c9d828.docx',	'331488',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:31:48',	'2023-11-15 09:31:48',	NULL),
(502,	8,	45,	'2- Information 3.1.4-f0b86b70-4079-497e-be3a-021d2c170ebf',	'/2- Information 3.1.4-f0b86b70-4079-497e-be3a-021d2c170ebf.docx',	'401241',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:31:48',	'2023-11-15 09:32:23',	'2023-11-15 09:32:23'),
(503,	8,	45,	'2- Information 3.1.4-e5d20c8e-37a3-433e-91ee-3b00263c5f3e',	'/2- Information 3.1.4-e5d20c8e-37a3-433e-91ee-3b00263c5f3e.docx',	'401241',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:31:48',	'2023-11-15 09:31:48',	NULL),
(504,	8,	45,	'2- Work Sheet  3.2.4-749b31b8-c832-4964-b62d-5ffddbc5537c',	'/2- Work Sheet  3.2.4-749b31b8-c832-4964-b62d-5ffddbc5537c.docx',	'331488',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:32:00',	'2023-11-15 09:32:10',	'2023-11-15 09:32:10'),
(505,	8,	50,	'2- Information 1.1.1-4855dbdb-f011-4b58-b586-c0492137e766',	'/2- Information 1.1.1-4855dbdb-f011-4b58-b586-c0492137e766.docx',	'1741738',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:36:03',	'2023-11-15 09:36:03',	NULL),
(506,	8,	50,	'2- Work Sheet 1.2.1-ecf82a3b-ee8c-4611-9ccb-c90c9fd7d5b8',	'/2- Work Sheet 1.2.1-ecf82a3b-ee8c-4611-9ccb-c90c9fd7d5b8.docx',	'744797',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:36:16',	'2023-11-15 09:36:16',	NULL),
(507,	8,	50,	'2- Information 1.1.2-29b5edb7-9425-4e04-9649-e3ec1cdba7eb',	'/2- Information 1.1.2-29b5edb7-9425-4e04-9649-e3ec1cdba7eb.docx',	'209945',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:36:22',	'2023-11-15 09:36:22',	NULL),
(508,	8,	50,	'2-​​ Work Sheet 1.2.2-0d493e31-48ba-41b8-af98-74d615133451',	'/2-​​ Work Sheet 1.2.2-0d493e31-48ba-41b8-af98-74d615133451.docx',	'630294',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:36:34',	'2023-11-15 09:36:34',	NULL),
(509,	8,	50,	'2- Information 1.1.3-950ffebc-041a-4ab9-94b5-6944189644c9',	'/2- Information 1.1.3-950ffebc-041a-4ab9-94b5-6944189644c9.docx',	'873659',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:38:03',	'2023-11-15 09:38:03',	NULL),
(510,	8,	50,	'2-​​ Work Sheet 1.2.3-22245a48-9ffd-4c52-819d-bbce6a17c1a7',	'/2-​​ Work Sheet 1.2.3-22245a48-9ffd-4c52-819d-bbce6a17c1a7.docx',	'360475',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:38:09',	'2023-11-15 09:38:09',	NULL),
(511,	8,	50,	'2- Information 1.1.4-7d4026d7-8e0c-4689-9657-157c89fb0613',	'/2- Information 1.1.4-7d4026d7-8e0c-4689-9657-157c89fb0613.docx',	'745916',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:38:36',	'2023-11-15 09:38:36',	NULL),
(512,	8,	50,	'2-​​ Work Sheet 1.2.3-b5e8059f-a79f-403f-98e8-5e3ed849ab90',	'/2-​​ Work Sheet 1.2.3-b5e8059f-a79f-403f-98e8-5e3ed849ab90.docx',	'360475',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:38:46',	'2023-11-15 09:38:46',	NULL),
(513,	8,	50,	'2- Information 1.1.4-b119e2bc-e6de-40b2-bcfc-2d444f1f1591',	'/2- Information 1.1.4-b119e2bc-e6de-40b2-bcfc-2d444f1f1591.docx',	'745916',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:39:00',	'2023-11-15 09:39:00',	NULL),
(514,	8,	50,	'2- Information 1.1.5-b5c88faa-0aeb-4861-81ab-ccb2c90c2155',	'/2- Information 1.1.5-b5c88faa-0aeb-4861-81ab-ccb2c90c2155.docx',	'203572',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:39:08',	'2023-11-15 09:39:08',	NULL),
(515,	8,	51,	'2- Information 1.1.1-5491f101-3032-47a9-a36c-b3d9d79ff75c',	'/2- Information 1.1.1-5491f101-3032-47a9-a36c-b3d9d79ff75c.docx',	'1741738',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:40:02',	'2023-11-15 09:40:02',	NULL),
(516,	8,	51,	'2- Information 1.1.2-4ad33584-6a6e-48d7-804e-03d9c45c8ba0',	'/2- Information 1.1.2-4ad33584-6a6e-48d7-804e-03d9c45c8ba0.docx',	'209945',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:40:02',	'2023-11-15 09:41:38',	'2023-11-15 09:41:38'),
(517,	8,	51,	'2- Work Sheet 1.2.1-575f9faa-0a7c-4c89-b74e-58cb539af4b6',	'/2- Work Sheet 1.2.1-575f9faa-0a7c-4c89-b74e-58cb539af4b6.docx',	'744797',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:40:02',	'2023-11-15 09:41:33',	'2023-11-15 09:41:33'),
(518,	8,	51,	'2-​​ Work Sheet 1.2.2-68a4f1e3-791d-4ec9-a54b-9b43481e884b',	'/2-​​ Work Sheet 1.2.2-68a4f1e3-791d-4ec9-a54b-9b43481e884b.docx',	'630294',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:40:08',	'2023-11-15 09:41:43',	'2023-11-15 09:41:43'),
(519,	8,	51,	'2- Work Sheet 1.2.1-20c883ae-73d9-4d68-9462-4036d385f9da',	'/2- Work Sheet 1.2.1-20c883ae-73d9-4d68-9462-4036d385f9da.docx',	'744797',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:41:54',	'2023-11-15 09:41:54',	NULL),
(520,	8,	51,	'2- Information 1.1.2-15ab3212-7588-48fb-aab2-f2685d6894dd',	'/2- Information 1.1.2-15ab3212-7588-48fb-aab2-f2685d6894dd.docx',	'209945',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:42:06',	'2023-11-15 09:42:06',	NULL),
(521,	8,	51,	'2-​​ Work Sheet 1.2.2-995c9c10-a1de-4b4b-9e8e-092854318f0c',	'/2-​​ Work Sheet 1.2.2-995c9c10-a1de-4b4b-9e8e-092854318f0c.docx',	'630294',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:42:14',	'2023-11-15 09:42:14',	NULL),
(522,	8,	51,	'2- Information 1.1.3-e435ed27-0dca-4129-ba5f-32814503e7da',	'/2- Information 1.1.3-e435ed27-0dca-4129-ba5f-32814503e7da.docx',	'873659',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:42:38',	'2023-11-15 09:42:38',	NULL),
(523,	8,	51,	'2-​​ Work Sheet 1.2.3-08fdb58c-67b9-418c-9a36-1469d57cd7c8',	'/2-​​ Work Sheet 1.2.3-08fdb58c-67b9-418c-9a36-1469d57cd7c8.docx',	'360475',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:42:57',	'2023-11-15 09:42:57',	NULL),
(524,	8,	51,	'2- Information 1.1.4-e63360fa-8d1d-4fce-a459-a5ec5f917377',	'/2- Information 1.1.4-e63360fa-8d1d-4fce-a459-a5ec5f917377.docx',	'745916',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:43:09',	'2023-11-15 09:43:09',	NULL),
(525,	8,	51,	'2- Information 1.1.5-ec5b2e80-08fe-4ba4-a5d6-8d56382b9de8',	'/2- Information 1.1.5-ec5b2e80-08fe-4ba4-a5d6-8d56382b9de8.docx',	'203572',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:43:26',	'2023-11-15 09:43:26',	NULL),
(526,	8,	52,	'2- Information 3.1.1 -2283d4f9-fe87-4913-807e-52e06471256f',	'/2- Information 3.1.1 -2283d4f9-fe87-4913-807e-52e06471256f.docx',	'231000',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:44:04',	'2023-11-15 09:44:04',	NULL),
(527,	8,	52,	'2- Work Sheet  3.2.1-70fed870-12a3-456e-83e9-574b56fd2f97',	'/2- Work Sheet  3.2.1-70fed870-12a3-456e-83e9-574b56fd2f97.docx',	'156644',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:44:12',	'2023-11-15 09:44:12',	NULL),
(528,	8,	52,	'2- Information 3.1.2-d19bb04e-3f9b-429d-8f72-2b3bf016d0d1',	'/2- Information 3.1.2-d19bb04e-3f9b-429d-8f72-2b3bf016d0d1.docx',	'207701',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:44:32',	'2023-11-15 09:44:32',	NULL),
(529,	8,	52,	'2- Work Sheet  3.2.2-267888cd-4fc5-4821-9c94-f3b5456806a1',	'/2- Work Sheet  3.2.2-267888cd-4fc5-4821-9c94-f3b5456806a1.docx',	'617835',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:44:40',	'2023-11-15 09:44:40',	NULL),
(530,	8,	52,	'2- Information 3.1.3-6ebfcd99-95ae-4006-8bcd-5557a0953bbc',	'/2- Information 3.1.3-6ebfcd99-95ae-4006-8bcd-5557a0953bbc.docx',	'416487',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:45:01',	'2023-11-15 09:45:01',	NULL),
(531,	8,	52,	'2- Work Sheet  3.2.3-41307793-6447-4c5a-b322-da3ac1b69bac',	'/2- Work Sheet  3.2.3-41307793-6447-4c5a-b322-da3ac1b69bac.docx',	'787352',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:45:42',	'2023-11-15 09:45:42',	NULL),
(532,	8,	52,	'2- Information 3.1.4-48c3ebc8-c7f0-4c03-b6e4-4a45aee48085',	'/2- Information 3.1.4-48c3ebc8-c7f0-4c03-b6e4-4a45aee48085.docx',	'401241',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:45:52',	'2023-11-15 09:45:52',	NULL),
(533,	8,	52,	'2- Work Sheet  3.2.4-3ae3e4f4-9810-4509-a152-a23e32116ced',	'/2- Work Sheet  3.2.4-3ae3e4f4-9810-4509-a152-a23e32116ced.docx',	'331488',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:46:00',	'2023-11-15 09:46:00',	NULL),
(534,	8,	53,	'3- Information 1.1.1-cc5743e6-4473-4bd5-9981-3b440c224c71',	'/3- Information 1.1.1-cc5743e6-4473-4bd5-9981-3b440c224c71.docx',	'1876732',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:51:46',	'2023-11-15 09:51:46',	NULL),
(535,	8,	53,	'3- Work Sheet  1.2.1-14ccbe8d-a5e0-4a67-8fa7-ffcf995e9bde',	'/3- Work Sheet  1.2.1-14ccbe8d-a5e0-4a67-8fa7-ffcf995e9bde.docx',	'42764',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:51:53',	'2023-11-15 09:51:53',	NULL),
(536,	8,	53,	'3- Information 1.1.2-c7564cb0-1881-445c-bd36-07b13e6e1de0',	'/3- Information 1.1.2-c7564cb0-1881-445c-bd36-07b13e6e1de0.docx',	'158360',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:52:00',	'2023-11-15 09:52:00',	NULL),
(537,	8,	53,	'3- Work Sheet  1.2.2-b478a973-29c1-455e-aa51-4c37f4423c4e',	'/3- Work Sheet  1.2.2-b478a973-29c1-455e-aa51-4c37f4423c4e.docx',	'145685',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:52:07',	'2023-11-15 09:52:07',	NULL),
(538,	8,	53,	'3- Information 1.1.3-7cf5309a-fcb0-4ea1-b7bd-9ad83906a12c',	'/3- Information 1.1.3-7cf5309a-fcb0-4ea1-b7bd-9ad83906a12c.docx',	'149122',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:52:13',	'2023-11-15 09:52:13',	NULL),
(539,	8,	53,	'3- Work Sheet  1.2.3-b998e7c1-77c3-4a67-b962-c02dc2db9c28',	'/3- Work Sheet  1.2.3-b998e7c1-77c3-4a67-b962-c02dc2db9c28.docx',	'40557',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:52:29',	'2023-11-15 09:52:29',	NULL),
(540,	8,	53,	'3- Information 1.1.4-5e53ddb1-99d1-4b7d-a2ea-8a7d25ca6832',	'/3- Information 1.1.4-5e53ddb1-99d1-4b7d-a2ea-8a7d25ca6832.docx',	'137250',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 09:52:44',	'2023-11-15 09:52:44',	NULL),
(541,	8,	53,	'3- Work Sheet  1.2.4-f9e345ec-1b48-49e4-8e0f-876e421c7bf1',	'/3- Work Sheet  1.2.4-f9e345ec-1b48-49e4-8e0f-876e421c7bf1.docx',	'165850',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 10:14:11',	'2023-11-15 10:14:11',	NULL),
(542,	8,	53,	'3- Information 1.1.5-5e71e9e3-dde2-41e3-8eba-a2a27bbe4c7e',	'/3- Information 1.1.5-5e71e9e3-dde2-41e3-8eba-a2a27bbe4c7e.docx',	'91201',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 10:14:20',	'2023-11-15 10:14:20',	NULL),
(543,	8,	53,	'3- Work Sheet  1.2.5-555601e8-22d2-4575-87fc-e1cb0a72b663',	'/3- Work Sheet  1.2.5-555601e8-22d2-4575-87fc-e1cb0a72b663.docx',	'102011',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 10:14:30',	'2023-11-15 10:14:30',	NULL),
(544,	8,	56,	'3- Information 1.1.1-d1b869d8-ca46-4f37-bad6-f0ad2457acbf',	'/3- Information 1.1.1-d1b869d8-ca46-4f37-bad6-f0ad2457acbf.docx',	'1876732',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 10:17:08',	'2023-11-15 10:17:08',	NULL),
(545,	8,	56,	'3- Work Sheet  1.2.1-be357f75-d060-443d-932e-779110e31224',	'/3- Work Sheet  1.2.1-be357f75-d060-443d-932e-779110e31224.docx',	'42764',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 10:17:15',	'2023-11-15 10:17:15',	NULL),
(546,	8,	56,	'3- Information 1.1.2-ea235820-1e88-4bf9-8097-08c9597b5fa2',	'/3- Information 1.1.2-ea235820-1e88-4bf9-8097-08c9597b5fa2.docx',	'158360',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 10:17:22',	'2023-11-15 10:17:22',	NULL),
(547,	8,	56,	'3- Work Sheet  1.2.2-8843f59a-3ab1-4164-9d64-bef8de77fdc4',	'/3- Work Sheet  1.2.2-8843f59a-3ab1-4164-9d64-bef8de77fdc4.docx',	'145685',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 10:17:29',	'2023-11-15 10:17:29',	NULL),
(548,	8,	56,	'3- Information 1.1.3-f4ec89d4-451e-48f7-85f1-86217a56989e',	'/3- Information 1.1.3-f4ec89d4-451e-48f7-85f1-86217a56989e.docx',	'149122',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 10:18:02',	'2023-11-15 10:18:02',	NULL),
(549,	8,	56,	'3- Work Sheet  1.2.3-05c9f99a-64b5-4600-859c-1d903e56384c',	'/3- Work Sheet  1.2.3-05c9f99a-64b5-4600-859c-1d903e56384c.docx',	'40557',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 10:18:11',	'2023-11-15 10:18:11',	NULL),
(550,	8,	56,	'3- Information 1.1.4-effd4807-c4f7-4a04-a329-317c54684c78',	'/3- Information 1.1.4-effd4807-c4f7-4a04-a329-317c54684c78.docx',	'137250',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 10:18:21',	'2023-11-15 10:18:21',	NULL),
(551,	8,	56,	'3- Work Sheet  1.2.4-74fed4d7-f7fe-4d85-b578-4eb4e9dea601',	'/3- Work Sheet  1.2.4-74fed4d7-f7fe-4d85-b578-4eb4e9dea601.docx',	'165850',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 10:18:30',	'2023-11-15 10:18:30',	NULL),
(552,	8,	56,	'3- Information 1.1.5-9503165e-f034-4a80-858b-db3a4cce88b1',	'/3- Information 1.1.5-9503165e-f034-4a80-858b-db3a4cce88b1.docx',	'91201',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 10:18:38',	'2023-11-15 10:18:38',	NULL),
(553,	8,	56,	'3- Work Sheet  1.2.5-d079806f-316e-4b4c-a5d0-c4ef45d2cbdf',	'/3- Work Sheet  1.2.5-d079806f-316e-4b4c-a5d0-c4ef45d2cbdf.docx',	'102011',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 10:18:46',	'2023-11-15 10:18:46',	NULL),
(554,	8,	54,	'2- Information 2.1.1-56b9ed3a-bba3-4449-83b1-71761aa39d99',	'/2- Information 2.1.1-56b9ed3a-bba3-4449-83b1-71761aa39d99.docx',	'840027',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 10:20:51',	'2023-11-15 10:20:51',	NULL),
(555,	8,	54,	'2- Work Sheet 2.2.1-ccb49f83-4a08-4972-82d7-0ca840c682da',	'/2- Work Sheet 2.2.1-ccb49f83-4a08-4972-82d7-0ca840c682da.docx',	'37651',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 10:20:57',	'2023-11-15 10:20:57',	NULL),
(556,	8,	54,	'2- Information 2.1.2-636f4d46-319d-406a-a24a-27582cba6c8b',	'/2- Information 2.1.2-636f4d46-319d-406a-a24a-27582cba6c8b.docx',	'677930',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 10:21:04',	'2023-11-15 10:21:04',	NULL),
(557,	8,	54,	'2-​​ Work Sheet 2.2.2-6e641786-ea25-4146-83a2-d7a5c5c7b30b',	'/2-​​ Work Sheet 2.2.2-6e641786-ea25-4146-83a2-d7a5c5c7b30b.docx',	'138160',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 10:21:11',	'2023-11-15 10:21:11',	NULL),
(558,	8,	54,	'2- Information 2.1.3-2d625d82-44cf-4d4a-9989-1fedca816b2b',	'/2- Information 2.1.3-2d625d82-44cf-4d4a-9989-1fedca816b2b.docx',	'329331',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 10:21:18',	'2023-11-15 10:21:18',	NULL),
(559,	8,	54,	'2-​​ Work Sheet 2.2.3-3e8d0e2e-4432-45c3-af10-69d0bdb02d56',	'/2-​​ Work Sheet 2.2.3-3e8d0e2e-4432-45c3-af10-69d0bdb02d56.docx',	'41979',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 10:21:25',	'2023-11-15 10:21:25',	NULL),
(560,	8,	55,	'2- Information 3.1.1 -f5be449e-ebc0-4a8e-b01a-401633094509',	'/2- Information 3.1.1 -f5be449e-ebc0-4a8e-b01a-401633094509.docx',	'231000',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 10:21:55',	'2023-11-15 10:21:55',	NULL),
(561,	8,	55,	'2- Work Sheet  3.2.1-720db908-59fb-41cc-88cb-0879cab680bd',	'/2- Work Sheet  3.2.1-720db908-59fb-41cc-88cb-0879cab680bd.docx',	'156644',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 10:22:03',	'2023-11-15 10:22:03',	NULL),
(562,	8,	55,	'2- Information 3.1.2-30a11877-4966-4600-9d8d-522e40a5db16',	'/2- Information 3.1.2-30a11877-4966-4600-9d8d-522e40a5db16.docx',	'207701',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 10:22:19',	'2023-11-15 10:22:19',	NULL),
(563,	8,	55,	'2- Work Sheet  3.2.2-57b3e7b8-7c1b-431b-9c0b-5bce3458980a',	'/2- Work Sheet  3.2.2-57b3e7b8-7c1b-431b-9c0b-5bce3458980a.docx',	'617835',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 10:22:26',	'2023-11-15 10:22:26',	NULL),
(564,	8,	55,	'2- Information 3.1.3-9526647c-7385-4766-b4e7-b3c1d133b20f',	'/2- Information 3.1.3-9526647c-7385-4766-b4e7-b3c1d133b20f.docx',	'416487',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 10:22:32',	'2023-11-15 10:22:32',	NULL),
(565,	8,	55,	'2- Work Sheet  3.2.3-79382095-b68a-4db2-8c14-5ed346dcff12',	'/2- Work Sheet  3.2.3-79382095-b68a-4db2-8c14-5ed346dcff12.docx',	'787352',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 10:23:33',	'2023-11-15 10:23:33',	NULL),
(566,	8,	55,	'2- Information 3.1.4-2ba6fdc9-fc67-4cee-a989-f2a12c188cec',	'/2- Information 3.1.4-2ba6fdc9-fc67-4cee-a989-f2a12c188cec.docx',	'401241',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 10:23:45',	'2023-11-15 10:23:45',	NULL),
(567,	8,	55,	'2- Work Sheet  3.2.4-5a388b06-9df4-4eec-8877-8a1426ec1eec',	'/2- Work Sheet  3.2.4-5a388b06-9df4-4eec-8877-8a1426ec1eec.docx',	'331488',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-15 10:23:54',	'2023-11-15 10:23:54',	NULL),
(568,	8,	59,	'3-Information Sheet 1.1.1-9673b126-04a6-4488-b468-a8004fac2659',	'/3-Information Sheet 1.1.1-9673b126-04a6-4488-b468-a8004fac2659.docx',	'382360',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:15:01',	'2023-11-16 09:17:24',	'2023-11-16 09:17:24'),
(569,	8,	59,	'4-Work Sheet From 1.2.1-5cb35b1f-cd48-4bf2-861f-8aa32476a43a',	'/4-Work Sheet From 1.2.1-5cb35b1f-cd48-4bf2-861f-8aa32476a43a.docx',	'374488',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:15:53',	'2023-11-16 09:17:27',	'2023-11-16 09:17:27'),
(570,	8,	59,	'3-Information Sheet 1.1.2-1cc62afd-24aa-40e8-b043-086a573e8596',	'/3-Information Sheet 1.1.2-1cc62afd-24aa-40e8-b043-086a573e8596.docx',	'156418',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:16:03',	'2023-11-16 09:17:30',	'2023-11-16 09:17:30'),
(571,	8,	59,	'4-Work Sheet From 1.2.2-8f50553d-22cb-4d87-ac12-d8f7bc789ed1',	'/4-Work Sheet From 1.2.2-8f50553d-22cb-4d87-ac12-d8f7bc789ed1.docx',	'170661',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:16:08',	'2023-11-16 09:17:34',	'2023-11-16 09:17:34'),
(572,	8,	59,	'3-Information Sheet 1.1.1-e4d44ddd-d75f-4ad8-85f6-e881a34e85e3',	'/3-Information Sheet 1.1.1-e4d44ddd-d75f-4ad8-85f6-e881a34e85e3.docx',	'382360',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:20:21',	'2023-11-16 09:20:35',	'2023-11-16 09:20:35'),
(573,	8,	59,	'3- Information 1.1.1-c2870115-540a-4cab-a557-3526162257b7',	'/3- Information 1.1.1-c2870115-540a-4cab-a557-3526162257b7.docx',	'1876732',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:20:55',	'2023-11-16 09:20:55',	NULL),
(574,	8,	59,	'3- Work Sheet  1.2.1-362a1572-48c4-469a-8dfe-d4eaac52f396',	'/3- Work Sheet  1.2.1-362a1572-48c4-469a-8dfe-d4eaac52f396.docx',	'42764',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:21:03',	'2023-11-16 09:21:03',	NULL),
(575,	8,	59,	'3- Information 1.1.2-7984add2-4c09-462c-a2f8-acf6e672baa8',	'/3- Information 1.1.2-7984add2-4c09-462c-a2f8-acf6e672baa8.docx',	'158360',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:21:07',	'2023-11-16 09:21:07',	NULL),
(576,	8,	59,	'3- Work Sheet  1.2.2-2e15c9c5-faf4-4ebd-a7f6-b2d742bdab86',	'/3- Work Sheet  1.2.2-2e15c9c5-faf4-4ebd-a7f6-b2d742bdab86.docx',	'145685',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:21:18',	'2023-11-16 09:21:18',	NULL),
(577,	8,	59,	'3- Information 1.1.3-ead7bf3c-13f7-413a-a14f-fbe88fe47806',	'/3- Information 1.1.3-ead7bf3c-13f7-413a-a14f-fbe88fe47806.docx',	'149122',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:21:25',	'2023-11-16 09:21:25',	NULL),
(578,	8,	59,	'3- Work Sheet  1.2.3-c92a5623-88a8-40ef-9bbd-26ee70a2401e',	'/3- Work Sheet  1.2.3-c92a5623-88a8-40ef-9bbd-26ee70a2401e.docx',	'40557',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:21:34',	'2023-11-16 09:21:34',	NULL),
(579,	8,	59,	'3- Information 1.1.4-12708b12-752f-4910-83db-dbf17112b36e',	'/3- Information 1.1.4-12708b12-752f-4910-83db-dbf17112b36e.docx',	'137250',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:21:46',	'2023-11-16 09:21:46',	NULL),
(580,	8,	59,	'3- Work Sheet  1.2.4-a5661266-df82-40bc-8b5f-832c629b7abd',	'/3- Work Sheet  1.2.4-a5661266-df82-40bc-8b5f-832c629b7abd.docx',	'165850',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:21:54',	'2023-11-16 09:21:54',	NULL),
(581,	8,	59,	'3- Information 1.1.5-d46b5415-f5d3-4b8c-be09-599c9d0c2e4d',	'/3- Information 1.1.5-d46b5415-f5d3-4b8c-be09-599c9d0c2e4d.docx',	'91201',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:22:09',	'2023-11-16 09:22:09',	NULL),
(582,	8,	59,	'3- Work Sheet  1.2.5-e7d93807-3d79-4e47-a26e-9b9902556dd0',	'/3- Work Sheet  1.2.5-e7d93807-3d79-4e47-a26e-9b9902556dd0.docx',	'102011',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:22:18',	'2023-11-16 09:22:18',	NULL),
(583,	8,	60,	'3- Information 2.1.1-e660af5b-09df-41c7-90c0-59429214d92f',	'/3- Information 2.1.1-e660af5b-09df-41c7-90c0-59429214d92f.docx',	'158101',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:23:30',	'2023-11-16 09:23:30',	NULL),
(584,	8,	60,	'3-Work Sheet 2.2.1-38f2dc40-35e9-4482-af1d-dfca88f12b5f',	'/3-Work Sheet 2.2.1-38f2dc40-35e9-4482-af1d-dfca88f12b5f.docx',	'125588',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:23:39',	'2023-11-16 09:23:39',	NULL),
(585,	8,	60,	'3- Information 2.1.2-7346bd19-3791-45b4-864b-b65b62e1e32f',	'/3- Information 2.1.2-7346bd19-3791-45b4-864b-b65b62e1e32f.docx',	'300737',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:23:47',	'2023-11-16 09:23:47',	NULL),
(586,	8,	60,	'3-Work Sheet 2.2.2-c48a5de9-802e-4fb1-84cb-717208accc27',	'/3-Work Sheet 2.2.2-c48a5de9-802e-4fb1-84cb-717208accc27.docx',	'188469',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:29:53',	'2023-11-16 09:29:53',	NULL),
(587,	8,	60,	'3- Information 2.1.3-0c9908da-fc14-4c04-84c3-decf2537399f',	'/3- Information 2.1.3-0c9908da-fc14-4c04-84c3-decf2537399f.docx',	'144921',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:30:30',	'2023-11-16 09:30:30',	NULL),
(588,	8,	60,	'3-Work Sheet 2.2.3-0e2f308e-3f95-407b-8fa4-4890c50b95a2',	'/3-Work Sheet 2.2.3-0e2f308e-3f95-407b-8fa4-4890c50b95a2.docx',	'295204',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:31:17',	'2023-11-16 09:31:17',	NULL),
(589,	8,	60,	'3- Information 2.1.4-734a863b-2483-4d59-b86f-e22671a35a5f',	'/3- Information 2.1.4-734a863b-2483-4d59-b86f-e22671a35a5f.docx',	'2550049',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:33:11',	'2023-11-16 09:33:11',	NULL),
(590,	8,	60,	'3-Work Sheet 2.2.4-5a9ea39d-3098-405a-8fc4-1c2aefa84301',	'/3-Work Sheet 2.2.4-5a9ea39d-3098-405a-8fc4-1c2aefa84301.docx',	'42900',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:33:26',	'2023-11-16 09:33:26',	NULL),
(591,	8,	61,	'3- Information 3.1.1-ad16f515-2006-44c7-8b02-0d7ea961dace',	'/3- Information 3.1.1-ad16f515-2006-44c7-8b02-0d7ea961dace.docx',	'295314',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:34:02',	'2023-11-16 09:34:02',	NULL),
(592,	8,	61,	'3- Work Sheet  3.2.1-9cd88b04-9679-4192-8763-b2f33c12fc65',	'/3- Work Sheet  3.2.1-9cd88b04-9679-4192-8763-b2f33c12fc65.docx',	'1222771',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:34:15',	'2023-11-16 09:34:15',	NULL),
(593,	8,	61,	'3- Information 3.1.2-49e02b9b-2182-49c2-ab16-9bd2771e6527',	'/3- Information 3.1.2-49e02b9b-2182-49c2-ab16-9bd2771e6527.docx',	'336822',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:35:46',	'2023-11-16 09:35:46',	NULL),
(594,	8,	61,	'3- Work Sheet 3.2.2-bd1d6174-9cdc-4207-abc2-637e6bb43ace',	'/3- Work Sheet 3.2.2-bd1d6174-9cdc-4207-abc2-637e6bb43ace.docx',	'314094',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:35:54',	'2023-11-16 09:35:54',	NULL),
(595,	8,	61,	'3- Information 3.1.3-8a840d11-df69-45a6-b880-19c58128244a',	'/3- Information 3.1.3-8a840d11-df69-45a6-b880-19c58128244a.docx',	'2172448',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:36:35',	'2023-11-16 09:36:35',	NULL),
(596,	8,	61,	'3- Work Sheet 3.2.3-ecd35baa-a212-424c-b75a-feda3d0ec3c5',	'/3- Work Sheet 3.2.3-ecd35baa-a212-424c-b75a-feda3d0ec3c5.docx',	'2174012',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:36:44',	'2023-11-16 09:36:44',	NULL),
(597,	8,	61,	'3- Information 3.1.4-5bb00152-5b57-4d8c-9a91-836dac3baee1',	'/3- Information 3.1.4-5bb00152-5b57-4d8c-9a91-836dac3baee1.docx',	'152440',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:36:52',	'2023-11-16 09:36:52',	NULL),
(598,	8,	61,	'3- Work Sheet 3.2.4-3cd1b6d1-f9cc-4dbf-ba7a-ca9f34f45785',	'/3- Work Sheet 3.2.4-3cd1b6d1-f9cc-4dbf-ba7a-ca9f34f45785.docx',	'36674',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:37:01',	'2023-11-16 09:37:01',	NULL),
(599,	8,	61,	'3- Information 3.1.5-788ca50d-d087-49cc-94fe-f223f1c5fbee',	'/3- Information 3.1.5-788ca50d-d087-49cc-94fe-f223f1c5fbee.docx',	'155546',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:37:11',	'2023-11-16 09:37:11',	NULL),
(600,	8,	61,	'3- Work Sheet 3.2.5-28de39d4-6e86-4763-bddc-7beca9a1e8b7',	'/3- Work Sheet 3.2.5-28de39d4-6e86-4763-bddc-7beca9a1e8b7.docx',	'37686',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:37:18',	'2023-11-16 09:37:18',	NULL),
(601,	8,	66,	'3-Information Sheet 1.1.1-51ff4360-3cb2-4292-855b-30977b8eabfe',	'/3-Information Sheet 1.1.1-51ff4360-3cb2-4292-855b-30977b8eabfe.docx',	'382360',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:44:43',	'2023-11-16 09:44:43',	NULL),
(602,	8,	66,	'4-Work Sheet From 1.2.1-4a17c216-8013-4cd9-bf39-83331837f559',	'/4-Work Sheet From 1.2.1-4a17c216-8013-4cd9-bf39-83331837f559.docx',	'374488',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:44:52',	'2023-11-16 09:44:52',	NULL),
(603,	8,	66,	'3-Information Sheet 1.1.2-de6b31f6-29b4-4654-b95a-84c3a6bc8000',	'/3-Information Sheet 1.1.2-de6b31f6-29b4-4654-b95a-84c3a6bc8000.docx',	'156418',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:44:59',	'2023-11-16 09:44:59',	NULL),
(604,	8,	66,	'4-Work Sheet From 1.2.2-344e3c6c-a11a-4ae3-a293-35176a84b4a3',	'/4-Work Sheet From 1.2.2-344e3c6c-a11a-4ae3-a293-35176a84b4a3.docx',	'170661',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:45:06',	'2023-11-16 09:45:06',	NULL),
(605,	8,	67,	'4- Information 2.1.1-07103396-a337-4bf3-98b8-2f0825c5fb03',	'/4- Information 2.1.1-07103396-a337-4bf3-98b8-2f0825c5fb03.docx',	'319384',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:45:41',	'2023-11-16 09:45:41',	NULL),
(606,	8,	67,	'4- Work Sheet  2.2.1-2592d5ed-c675-4fd5-be4d-98a9ca14ff9b',	'/4- Work Sheet  2.2.1-2592d5ed-c675-4fd5-be4d-98a9ca14ff9b.docx',	'462577',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:49:03',	'2023-11-16 09:49:03',	NULL),
(607,	8,	67,	'4- Information 2.1.2-61669403-11b5-4d5c-8a2d-738ca3cc9777',	'/4- Information 2.1.2-61669403-11b5-4d5c-8a2d-738ca3cc9777.docx',	'232169',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:49:11',	'2023-11-16 09:49:11',	NULL),
(608,	8,	67,	'4- Work Sheet  2.2.2-4610deec-634c-4298-a75d-4e6a608bbf7a',	'/4- Work Sheet  2.2.2-4610deec-634c-4298-a75d-4e6a608bbf7a.docx',	'245667',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:49:19',	'2023-11-16 09:49:19',	NULL),
(609,	8,	67,	'4- Information 2.1.3-b5c029b6-1f60-4bd0-9803-a934ab5c6c63',	'/4- Information 2.1.3-b5c029b6-1f60-4bd0-9803-a934ab5c6c63.docx',	'332695',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:49:33',	'2023-11-16 09:49:33',	NULL),
(610,	8,	67,	'4-Work Sheet 2.2.3-f7cfdcf1-2847-4381-a63a-ff1f05a311ab',	'/4-Work Sheet 2.2.3-f7cfdcf1-2847-4381-a63a-ff1f05a311ab.docx',	'307041',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:49:40',	'2023-11-16 09:49:40',	NULL),
(611,	8,	68,	'3-Information Sheet 3.1.1-6f01241f-88bb-4dfd-9846-d187ae0e8942',	'/3-Information Sheet 3.1.1-6f01241f-88bb-4dfd-9846-d187ae0e8942.docx',	'444712',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 09:57:03',	'2023-11-16 09:57:03',	NULL),
(612,	8,	68,	'3-Work Sheet 3.2.1-ac8495f2-2c09-494e-a66a-a7761b77c7b9',	'/3-Work Sheet 3.2.1-ac8495f2-2c09-494e-a66a-a7761b77c7b9.docx',	'370171',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 10:01:59',	'2023-11-16 10:01:59',	NULL),
(613,	8,	68,	'3-Information Sheet 3.1.2-8eb4f42b-11bb-433a-acc2-67770c1bc932',	'/3-Information Sheet 3.1.2-8eb4f42b-11bb-433a-acc2-67770c1bc932.docx',	'333105',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 10:02:05',	'2023-11-16 10:02:05',	NULL),
(614,	8,	68,	'3-Work Sheet 3.2.2-31192edc-359f-4a2d-abc6-b4d6b835f86c',	'/3-Work Sheet 3.2.2-31192edc-359f-4a2d-abc6-b4d6b835f86c.docx',	'308463',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 10:02:12',	'2023-11-16 10:02:12',	NULL),
(615,	8,	68,	'3-Information Sheet 3.1.4-86227d63-6ed7-4b73-abbc-4b6cef726b03',	'/3-Information Sheet 3.1.4-86227d63-6ed7-4b73-abbc-4b6cef726b03.docx',	'647423',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 10:02:20',	'2023-11-16 10:02:30',	'2023-11-16 10:02:30'),
(616,	8,	68,	'3-Information Sheet 3.1.3-2dc69ddd-2c3b-4104-b9a2-5578257d058d',	'/3-Information Sheet 3.1.3-2dc69ddd-2c3b-4104-b9a2-5578257d058d.docx',	'226400',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 10:02:35',	'2023-11-16 10:02:35',	NULL),
(617,	8,	68,	'4-Work Sheet 3.2.3-edf6b805-95bb-41d3-af22-e4cde0e79e93',	'/4-Work Sheet 3.2.3-edf6b805-95bb-41d3-af22-e4cde0e79e93.docx',	'1533153',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 10:02:47',	'2023-11-16 10:02:47',	NULL),
(618,	8,	68,	'3-Information Sheet 3.1.4-76eeb75d-e28a-4208-b421-6746059a0ff6',	'/3-Information Sheet 3.1.4-76eeb75d-e28a-4208-b421-6746059a0ff6.docx',	'647423',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 10:02:52',	'2023-11-16 10:02:52',	NULL),
(619,	8,	68,	'4-Work Sheet 3.2.4-c979b3e5-7090-459e-b378-16fe64b8968c',	'/4-Work Sheet 3.2.4-c979b3e5-7090-459e-b378-16fe64b8968c.docx',	'773097',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 10:03:01',	'2023-11-16 10:03:01',	NULL),
(620,	8,	69,	'5-Information Sheet 1.1.1-aa56ad4e-185f-4d48-b8ad-5f5b3668f09f',	'/5-Information Sheet 1.1.1-aa56ad4e-185f-4d48-b8ad-5f5b3668f09f.docx',	'188364',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 10:34:39',	'2023-11-16 10:34:39',	NULL),
(621,	8,	69,	'5-Work Sheet 1.2.1-18fadb0b-27f5-4e86-8882-b070c094ee17',	'/5-Work Sheet 1.2.1-18fadb0b-27f5-4e86-8882-b070c094ee17.docx',	'376619',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 10:34:49',	'2023-11-16 10:34:49',	NULL),
(622,	8,	69,	'5-Information Sheet 1.1.2-4e9e503a-8191-4a05-8ab6-cefa5156fc63',	'/5-Information Sheet 1.1.2-4e9e503a-8191-4a05-8ab6-cefa5156fc63.docx',	'129388',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 10:34:57',	'2023-11-16 10:34:57',	NULL),
(623,	8,	69,	'5-Work Sheet 1.2.2-7a180625-3b86-405e-904a-2983d90c80b9',	'/5-Work Sheet 1.2.2-7a180625-3b86-405e-904a-2983d90c80b9.docx',	'138603',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 10:35:07',	'2023-11-16 10:35:07',	NULL),
(624,	8,	69,	'5-Information Sheet 1.1.3-3052a6b6-f725-494a-9da6-cb9fe289557c',	'/5-Information Sheet 1.1.3-3052a6b6-f725-494a-9da6-cb9fe289557c.docx',	'341412',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 10:35:20',	'2023-11-16 10:35:20',	NULL),
(625,	8,	69,	'5-Work Sheet 1.2.3-f3bb91fa-91a7-4db3-afa5-9333f61e6adc',	'/5-Work Sheet 1.2.3-f3bb91fa-91a7-4db3-afa5-9333f61e6adc.docx',	'240041',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 10:39:16',	'2023-11-16 10:39:16',	NULL),
(626,	8,	70,	'3-Information Sheet 2.1.1-7770b960-14f4-4006-9eb6-cfe0b072261f',	'/3-Information Sheet 2.1.1-7770b960-14f4-4006-9eb6-cfe0b072261f.docx',	'168366',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 10:39:45',	'2023-11-16 10:39:45',	NULL),
(627,	8,	70,	'4-Work Sheet From 2.2.1-421f6c32-97c8-4e22-9e47-d44aecd63658',	'/4-Work Sheet From 2.2.1-421f6c32-97c8-4e22-9e47-d44aecd63658.docx',	'341033',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 10:39:53',	'2023-11-16 10:39:53',	NULL),
(628,	8,	70,	'3-Information Sheet 2.1.2-8df54882-d456-42f8-8fe5-975df2260334',	'/3-Information Sheet 2.1.2-8df54882-d456-42f8-8fe5-975df2260334.docx',	'31272',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 10:40:05',	'2023-11-16 10:40:05',	NULL),
(629,	8,	70,	'4-Work Sheet From 2.2.2-2c0efcf9-3510-401e-b3a0-fdb8ed7c465b',	'/4-Work Sheet From 2.2.2-2c0efcf9-3510-401e-b3a0-fdb8ed7c465b.docx',	'789367',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 10:40:15',	'2023-11-16 10:40:15',	NULL),
(630,	8,	70,	'3-Information Sheet 2.1.3-58de2bd9-610a-4007-a116-2e3a7b76c899',	'/3-Information Sheet 2.1.3-58de2bd9-610a-4007-a116-2e3a7b76c899.docx',	'128886',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 10:40:26',	'2023-11-16 10:40:26',	NULL),
(631,	8,	70,	'4-Work Sheet From 2.2.3-caaf2d9f-d718-45e8-af09-e7cb799abc30',	'/4-Work Sheet From 2.2.3-caaf2d9f-d718-45e8-af09-e7cb799abc30.docx',	'137344',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 10:40:36',	'2023-11-16 10:40:36',	NULL),
(632,	8,	70,	'3-Information Sheet 2.1.4-a813f4c8-e541-42b4-a0dd-7388aaf7072d',	'/3-Information Sheet 2.1.4-a813f4c8-e541-42b4-a0dd-7388aaf7072d.docx',	'3991619',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 10:41:14',	'2023-11-16 10:41:14',	NULL),
(633,	8,	70,	'4-Work Sheet From 2.2.4-3f530bae-31b5-4698-9937-d3bc068b92ce',	'/4-Work Sheet From 2.2.4-3f530bae-31b5-4698-9937-d3bc068b92ce.docx',	'9080308',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 10:42:47',	'2023-11-16 10:42:47',	NULL),
(634,	8,	71,	'3-Information Sheet 3.1.1-4fbe8a68-e94e-4706-8844-372c9d236b70',	'/3-Information Sheet 3.1.1-4fbe8a68-e94e-4706-8844-372c9d236b70.docx',	'1660389',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 10:43:27',	'2023-11-16 10:43:27',	NULL),
(635,	8,	71,	'4-Work Sheet From 3.2.1-c427313e-91e1-43c2-9fb5-5bd2d628eaa8',	'/4-Work Sheet From 3.2.1-c427313e-91e1-43c2-9fb5-5bd2d628eaa8.docx',	'10104743',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 10:43:53',	'2023-11-16 10:43:53',	NULL),
(636,	8,	71,	'3-Information Sheet 3.1.2-f8885662-825f-4c81-a946-52a44d0a8214',	'/3-Information Sheet 3.1.2-f8885662-825f-4c81-a946-52a44d0a8214.docx',	'327450',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 10:44:05',	'2023-11-16 10:44:05',	NULL),
(637,	8,	71,	'4-Work Sheet From 3.2.2-52449ae2-d5c1-480c-a12b-cac4c51db275',	'/4-Work Sheet From 3.2.2-52449ae2-d5c1-480c-a12b-cac4c51db275.docx',	'393347',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 10:44:13',	'2023-11-16 10:44:13',	NULL),
(638,	8,	72,	'6- Information 1.1.1-e51b1d9f-ee72-4431-a820-dc070f5e0d8e',	'/6- Information 1.1.1-e51b1d9f-ee72-4431-a820-dc070f5e0d8e.docx',	'836747',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 15:20:34',	'2023-11-16 15:20:34',	NULL),
(639,	8,	72,	'6- Work Sheet 1.2.1-d77c781c-1410-4f2c-b585-92275983c292',	'/6- Work Sheet 1.2.1-d77c781c-1410-4f2c-b585-92275983c292.docx',	'855495',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 15:20:42',	'2023-11-16 15:20:42',	NULL),
(640,	8,	72,	'6- Information 1.1.2-b03f1410-0938-4b67-b7ef-9cdd4b81cac3',	'/6- Information 1.1.2-b03f1410-0938-4b67-b7ef-9cdd4b81cac3.docx',	'1079273',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 15:20:49',	'2023-11-16 15:20:49',	NULL),
(641,	8,	72,	'6- Work Sheet 1.2.2-1c5ef63e-204e-41c3-8794-bb617af03997',	'/6- Work Sheet 1.2.2-1c5ef63e-204e-41c3-8794-bb617af03997.docx',	'1133067',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 15:20:56',	'2023-11-16 15:20:56',	NULL),
(642,	8,	72,	'6- Information 1.1.3-04a49406-09ef-41f7-ba7c-5720a6482e85',	'/6- Information 1.1.3-04a49406-09ef-41f7-ba7c-5720a6482e85.docx',	'533874',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 15:21:04',	'2023-11-16 15:21:04',	NULL),
(643,	8,	72,	'6- Work Sheet 1.2.3-53ea987d-43e2-4bb9-8c9a-04df66f4bcb4',	'/6- Work Sheet 1.2.3-53ea987d-43e2-4bb9-8c9a-04df66f4bcb4.docx',	'906062',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 15:21:13',	'2023-11-16 15:21:13',	NULL),
(644,	8,	73,	'6- Information 2.1.1-45275c9f-1a47-45e0-920c-d495076c246f',	'/6- Information 2.1.1-45275c9f-1a47-45e0-920c-d495076c246f.docx',	'1572124',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 15:22:34',	'2023-11-16 15:22:34',	NULL),
(645,	8,	73,	'6- Work Sheet 2.2.1-ba150bd2-dc8d-400b-997c-bfc996f75654',	'/6- Work Sheet 2.2.1-ba150bd2-dc8d-400b-997c-bfc996f75654.docx',	'37111',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 15:22:48',	'2023-11-16 15:22:48',	NULL),
(646,	8,	73,	'6- Information 2.1.2-fc584142-3a8c-49c4-9da7-51c582dc2f5a',	'/6- Information 2.1.2-fc584142-3a8c-49c4-9da7-51c582dc2f5a.docx',	'1206062',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 15:22:55',	'2023-11-16 15:22:55',	NULL),
(647,	8,	73,	'6- Work Sheet 2.2.2​-4a17e574-2b62-4fe3-85d1-d2fdbd648e18',	'/6- Work Sheet 2.2.2​-4a17e574-2b62-4fe3-85d1-d2fdbd648e18.docx',	'1273640',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 15:23:03',	'2023-11-16 15:23:03',	NULL),
(648,	8,	73,	'6- Information 2.1.3-43e89148-1002-44fa-8f60-38c8702b24e0',	'/6- Information 2.1.3-43e89148-1002-44fa-8f60-38c8702b24e0.docx',	'462984',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 15:23:13',	'2023-11-16 15:23:13',	NULL),
(649,	8,	73,	'6- Work Sheet 2.2.3-f89412bb-fda8-4574-b567-dcd54d49db53',	'/6- Work Sheet 2.2.3-f89412bb-fda8-4574-b567-dcd54d49db53.docx',	'2444947',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 15:23:25',	'2023-11-16 15:23:25',	NULL),
(650,	8,	74,	'6- Information 3.1.1-7222983f-978b-4f40-a348-72e0c5f67085',	'/6- Information 3.1.1-7222983f-978b-4f40-a348-72e0c5f67085.docx',	'148488',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 15:23:55',	'2023-11-16 15:23:55',	NULL),
(651,	8,	74,	'6- Work Sheet 3.2.1-9de22e94-2eee-4df9-8c22-ac2c80d57746',	'/6- Work Sheet 3.2.1-9de22e94-2eee-4df9-8c22-ac2c80d57746.docx',	'278972',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 15:24:01',	'2023-11-16 15:24:01',	NULL),
(652,	8,	74,	'6- Information 3.1.2-c1d4d21e-b252-4849-a2f1-334599628727',	'/6- Information 3.1.2-c1d4d21e-b252-4849-a2f1-334599628727.docx',	'141095',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 15:24:08',	'2023-11-16 15:24:08',	NULL),
(653,	8,	74,	'6- Work Sheet 3.2.2-3e165912-bad9-4e8d-8059-cb7639c46aad',	'/6- Work Sheet 3.2.2-3e165912-bad9-4e8d-8059-cb7639c46aad.docx',	'126978',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 15:24:14',	'2023-11-16 15:24:14',	NULL),
(654,	8,	75,	'1-Information Sheet 1.1.1-ebcb9acb-7706-490f-a5d6-fd1d9e0ee8d1',	'/1-Information Sheet 1.1.1-ebcb9acb-7706-490f-a5d6-fd1d9e0ee8d1.docx',	'3737140',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 15:47:07',	'2023-11-16 15:47:07',	NULL),
(655,	8,	75,	'1-Work Sheet 1.2.1-4259918d-19e0-491c-bead-1c6737784ced',	'/1-Work Sheet 1.2.1-4259918d-19e0-491c-bead-1c6737784ced.docx',	'2825526',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 15:47:21',	'2023-11-16 15:47:21',	NULL),
(656,	8,	75,	'1-Information Sheet 1.1.2-4eee6980-987b-4f80-b64d-226bdaf62fce',	'/1-Information Sheet 1.1.2-4eee6980-987b-4f80-b64d-226bdaf62fce.docx',	'2304255',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 15:47:30',	'2023-11-16 15:47:30',	NULL),
(657,	8,	75,	'1-Work Sheet 1.2.2-6e8ecd15-0caa-4c69-b80f-24c5a66f1011',	'/1-Work Sheet 1.2.2-6e8ecd15-0caa-4c69-b80f-24c5a66f1011.docx',	'1071356',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 15:47:41',	'2023-11-16 15:47:41',	NULL),
(658,	8,	75,	'1-Information Sheet 1.1.3-27664a4e-fb09-4382-8d76-5f0846def60f',	'/1-Information Sheet 1.1.3-27664a4e-fb09-4382-8d76-5f0846def60f.docx',	'5253598',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:00:09',	'2023-11-16 16:00:09',	NULL),
(659,	8,	75,	'1-Work Sheet 1.2.3-a3d0b90c-4f77-4ab9-8f8e-f0bfd2ffcc5e',	'/1-Work Sheet 1.2.3-a3d0b90c-4f77-4ab9-8f8e-f0bfd2ffcc5e.docx',	'4888219',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:00:27',	'2023-11-16 16:00:27',	NULL),
(660,	8,	75,	'1-Information Sheet 1.1.4-decb851b-ba16-48f8-97d2-2ed198a8c2e8',	'/1-Information Sheet 1.1.4-decb851b-ba16-48f8-97d2-2ed198a8c2e8.docx',	'3953986',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:00:37',	'2023-11-16 16:00:37',	NULL),
(661,	8,	75,	'1-Work Sheet 1.2.4-a561a62b-2756-47c5-bd38-b0a1226c4616',	'/1-Work Sheet 1.2.4-a561a62b-2756-47c5-bd38-b0a1226c4616.docx',	'3023965',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:00:50',	'2023-11-16 16:00:50',	NULL),
(662,	8,	75,	'1-Information sheet 1.1.5-69a29256-401b-4e3e-9bc8-4c3197f39954',	'/1-Information sheet 1.1.5-69a29256-401b-4e3e-9bc8-4c3197f39954.docx',	'33871',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:00:57',	'2023-11-16 16:00:57',	NULL),
(663,	8,	75,	'1-Work sheet 1.2.5-e6dffd40-95f7-4144-b738-5c29e940d1db',	'/1-Work sheet 1.2.5-e6dffd40-95f7-4144-b738-5c29e940d1db.docx',	'866975',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:01:06',	'2023-11-16 16:01:06',	NULL),
(664,	8,	76,	'1-Information Sheet 2.1.1-daf03253-5b87-487a-8b9c-89725ad1ac2b',	'/1-Information Sheet 2.1.1-daf03253-5b87-487a-8b9c-89725ad1ac2b.docx',	'556630',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:01:26',	'2023-11-16 16:01:26',	NULL),
(665,	8,	76,	'1-Worksheet 2.2.1-f544f4fc-eada-48db-9631-731ad8bd2989',	'/1-Worksheet 2.2.1-f544f4fc-eada-48db-9631-731ad8bd2989.docx',	'469089',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:01:32',	'2023-11-16 16:01:32',	NULL),
(666,	8,	76,	'1-Information Sheet 2.1.2-f60b191d-f988-43d7-b65f-891daa7cf2c6',	'/1-Information Sheet 2.1.2-f60b191d-f988-43d7-b65f-891daa7cf2c6.docx',	'600939',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:01:39',	'2023-11-16 16:01:39',	NULL),
(667,	8,	76,	'1-Worksheet 2.2.2-685ad968-3512-424b-9f1b-4b9145b05d0d',	'/1-Worksheet 2.2.2-685ad968-3512-424b-9f1b-4b9145b05d0d.docx',	'2465232',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:01:46',	'2023-11-16 16:01:46',	NULL),
(668,	8,	76,	'1-Information Sheet 2.1.3-e53255ba-5e6a-4b69-b31a-e57aa60848b1',	'/1-Information Sheet 2.1.3-e53255ba-5e6a-4b69-b31a-e57aa60848b1.docx',	'2636759',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:01:54',	'2023-11-16 16:01:54',	NULL),
(669,	8,	76,	'1-Worksheet 2.2.3-5c671ec7-9430-42f4-abbd-325165147e0f',	'/1-Worksheet 2.2.3-5c671ec7-9430-42f4-abbd-325165147e0f.docx',	'3180396',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:02:03',	'2023-11-16 16:02:03',	NULL),
(670,	8,	77,	'1-Information Sheet 3.1.1-46f01732-4698-482e-b813-0eae3e90abfe',	'/1-Information Sheet 3.1.1-46f01732-4698-482e-b813-0eae3e90abfe.docx',	'1440244',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:02:27',	'2023-11-16 16:02:27',	NULL),
(671,	8,	77,	'1-Worksheet 3.2.1-93578cec-e762-4bb3-9126-7c8cfd1bfa49',	'/1-Worksheet 3.2.1-93578cec-e762-4bb3-9126-7c8cfd1bfa49.docx',	'1467477',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:02:34',	'2023-11-16 16:02:34',	NULL),
(672,	8,	77,	'1-Information Sheet 3.1.2-084eafba-8957-489b-b9d2-c7f15210f61d',	'/1-Information Sheet 3.1.2-084eafba-8957-489b-b9d2-c7f15210f61d.docx',	'1065674',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:02:40',	'2023-11-16 16:02:40',	NULL),
(673,	8,	77,	'1-Worksheet 3.2.2-e5dcbf46-328a-4d2c-a5f9-62e7b8d6adcb',	'/1-Worksheet 3.2.2-e5dcbf46-328a-4d2c-a5f9-62e7b8d6adcb.docx',	'2196180',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:02:48',	'2023-11-16 16:02:48',	NULL),
(674,	8,	77,	'1-Information Sheet 3.1.3-7ccc393a-210f-480d-87b1-5d499c346116',	'/1-Information Sheet 3.1.3-7ccc393a-210f-480d-87b1-5d499c346116.docx',	'1314686',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:02:52',	'2023-11-16 16:02:52',	NULL),
(675,	8,	77,	'1-Worksheet 3.2.3-18aefe8a-a81a-4d40-bf25-6fdfa12fcbef',	'/1-Worksheet 3.2.3-18aefe8a-a81a-4d40-bf25-6fdfa12fcbef.docx',	'3107788',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:03:03',	'2023-11-16 16:03:03',	NULL),
(676,	8,	78,	'1.Information Sheet 1.1.1-fbbb128c-c454-4cb2-b433-c1c8e17c2ca4',	'/1.Information Sheet 1.1.1-fbbb128c-c454-4cb2-b433-c1c8e17c2ca4.docx',	'1355480',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:07:43',	'2023-11-16 16:07:43',	NULL),
(677,	8,	78,	'1.Worksheet 1.2.1-119954c0-3b76-4654-ae28-59b158081b9f',	'/1.Worksheet 1.2.1-119954c0-3b76-4654-ae28-59b158081b9f.docx',	'1360614',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:07:50',	'2023-11-16 16:07:50',	NULL),
(678,	8,	78,	'1.Information Sheet 1.1.2-2f2dbd87-fe80-4f8f-8de7-130aadfa3ec0',	'/1.Information Sheet 1.1.2-2f2dbd87-fe80-4f8f-8de7-130aadfa3ec0.docx',	'1077156',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:07:57',	'2023-11-16 16:07:57',	NULL),
(679,	8,	78,	'1.Worksheet 1.2.2-3f75a013-c435-4e81-a18d-04f51a2cc900',	'/1.Worksheet 1.2.2-3f75a013-c435-4e81-a18d-04f51a2cc900.docx',	'1980078',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:08:03',	'2023-11-16 16:08:03',	NULL),
(680,	8,	78,	'1.Information Sheet 1.1.3-32a8062a-4250-45dd-ad6b-f42b717435e2',	'/1.Information Sheet 1.1.3-32a8062a-4250-45dd-ad6b-f42b717435e2.docx',	'1338588',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:08:12',	'2023-11-16 16:08:12',	NULL),
(681,	8,	78,	'1.WorkSheet 1.2.3-481faafe-f9aa-43a6-9ec9-81670f17fb9a',	'/1.WorkSheet 1.2.3-481faafe-f9aa-43a6-9ec9-81670f17fb9a.docx',	'4281843',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:08:22',	'2023-11-16 16:08:22',	NULL),
(682,	8,	78,	'1.Information Sheet 1.1.4-c744cd16-f33a-4633-9271-eb71f891aac3',	'/1.Information Sheet 1.1.4-c744cd16-f33a-4633-9271-eb71f891aac3.docx',	'1130577',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:08:29',	'2023-11-16 16:08:29',	NULL),
(683,	8,	78,	'1.Worksheet 1.2.4-c7490d51-9ed3-4b7d-bfec-869dddbba9d0',	'/1.Worksheet 1.2.4-c7490d51-9ed3-4b7d-bfec-869dddbba9d0.docx',	'1575034',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:08:36',	'2023-11-16 16:08:36',	NULL),
(684,	8,	79,	'2. Information Sheet 2.1.1-1baff585-fd17-4ad4-a928-0f909c2ede7e',	'/2. Information Sheet 2.1.1-1baff585-fd17-4ad4-a928-0f909c2ede7e.docx',	'584759',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:09:07',	'2023-11-16 16:09:07',	NULL),
(685,	8,	79,	'2.Worksheet 2.2.1-ad05b6b8-756e-45c1-8894-193c79bda046',	'/2.Worksheet 2.2.1-ad05b6b8-756e-45c1-8894-193c79bda046.docx',	'565645',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:09:13',	'2023-11-16 16:09:13',	NULL),
(686,	8,	79,	'2. Information Sheet 2.1.2-3aaf9f3c-d448-4b38-b323-9272f30f8f46',	'/2. Information Sheet 2.1.2-3aaf9f3c-d448-4b38-b323-9272f30f8f46.docx',	'502341',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:09:20',	'2023-11-16 16:09:20',	NULL),
(687,	8,	79,	'2.Worksheet 2.2.2-b170eda3-5c32-49ca-8cbc-eaeed07661fb',	'/2.Worksheet 2.2.2-b170eda3-5c32-49ca-8cbc-eaeed07661fb.docx',	'1518995',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:09:26',	'2023-11-16 16:09:26',	NULL),
(688,	8,	79,	'2. Information Sheet 2.1.3-5e8c346a-f347-4f12-9289-79b0bf8296e4',	'/2. Information Sheet 2.1.3-5e8c346a-f347-4f12-9289-79b0bf8296e4.docx',	'631856',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:09:32',	'2023-11-16 16:09:32',	NULL),
(689,	8,	79,	'2.Worksheet 2.2.3-8a06cd68-4031-48c7-aed9-febec8904081',	'/2.Worksheet 2.2.3-8a06cd68-4031-48c7-aed9-febec8904081.docx',	'3429008',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:09:42',	'2023-11-16 16:09:42',	NULL),
(690,	8,	79,	'2. Inoformation Sheet 2.1.4-808f752d-5f99-409e-9905-128b66b33c73',	'/2. Inoformation Sheet 2.1.4-808f752d-5f99-409e-9905-128b66b33c73.docx',	'1280997',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:09:48',	'2023-11-16 16:09:48',	NULL),
(691,	8,	79,	'2.Worksheet 2.2.4-09261681-1114-4c62-932c-47d0db57819b',	'/2.Worksheet 2.2.4-09261681-1114-4c62-932c-47d0db57819b.docx',	'993219',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:09:55',	'2023-11-16 16:09:55',	NULL),
(692,	8,	80,	'3. Information Sheet 3.1.1-6d0d980f-a4d1-4c1b-9b7d-128f56ae5304',	'/3. Information Sheet 3.1.1-6d0d980f-a4d1-4c1b-9b7d-128f56ae5304.docx',	'1001102',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:10:37',	'2023-11-16 16:10:37',	NULL),
(693,	8,	80,	'3.Worksheet 3.2.1-7fb5c7c3-b38c-4d23-8923-f3f9be4307f2',	'/3.Worksheet 3.2.1-7fb5c7c3-b38c-4d23-8923-f3f9be4307f2.docx',	'1269840',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:10:44',	'2023-11-16 16:10:44',	NULL),
(694,	8,	80,	'3. Information Sheet 3.1.2-45905929-6e20-4bb9-a7c7-70b8d8ab6adf',	'/3. Information Sheet 3.1.2-45905929-6e20-4bb9-a7c7-70b8d8ab6adf.docx',	'2991815',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:10:51',	'2023-11-16 16:10:51',	NULL),
(695,	8,	80,	'3.Worksheet 3.2.2-e6bec11f-4cb0-414a-8f2b-e67e3ef4482b',	'/3.Worksheet 3.2.2-e6bec11f-4cb0-414a-8f2b-e67e3ef4482b.docx',	'740449',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:10:58',	'2023-11-16 16:10:58',	NULL),
(696,	8,	80,	'3. Information Sheet 3.1.3-8c6bcc64-a5d0-4000-b1c9-3cc9ca2d58e4',	'/3. Information Sheet 3.1.3-8c6bcc64-a5d0-4000-b1c9-3cc9ca2d58e4.docx',	'1095098',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:11:06',	'2023-11-16 16:11:06',	NULL),
(697,	8,	80,	'3.Worksheet 3.2.3-d4ef51ef-4b41-4720-ba4c-787e1b87c934',	'/3.Worksheet 3.2.3-d4ef51ef-4b41-4720-ba4c-787e1b87c934.docx',	'888075',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:11:12',	'2023-11-16 16:11:12',	NULL),
(698,	8,	81,	'3. Information Sheet 1.1.1-5e2b8e19-8fad-4ce8-8764-975d9be4a16b',	'/3. Information Sheet 1.1.1-5e2b8e19-8fad-4ce8-8764-975d9be4a16b.docx',	'2661818',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:12:25',	'2023-11-16 16:12:25',	NULL),
(699,	8,	81,	'3. Work Sheet 1.2.1-6fb3210a-82fd-47c6-aeb9-d277d5fa2130',	'/3. Work Sheet 1.2.1-6fb3210a-82fd-47c6-aeb9-d277d5fa2130.docx',	'4548737',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:12:36',	'2023-11-16 16:12:36',	NULL),
(700,	8,	81,	'3. Information Sheet 1.1.2-d6fa13be-ad0e-4b73-9b78-80c80761fb35',	'/3. Information Sheet 1.1.2-d6fa13be-ad0e-4b73-9b78-80c80761fb35.docx',	'723290',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:12:45',	'2023-11-16 16:12:45',	NULL),
(701,	8,	81,	'3. Work Sheet 1.2.2-70a99baa-cad7-48bd-a603-a83fd4c90114',	'/3. Work Sheet 1.2.2-70a99baa-cad7-48bd-a603-a83fd4c90114.docx',	'1779652',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:12:52',	'2023-11-16 16:12:52',	NULL),
(702,	8,	81,	'3. Information Sheet 1.1.3-cb3c010c-f0c9-496c-a795-b7316242c86e',	'/3. Information Sheet 1.1.3-cb3c010c-f0c9-496c-a795-b7316242c86e.docx',	'970985',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:13:02',	'2023-11-16 16:13:02',	NULL),
(703,	8,	81,	'3. Work Sheet 1.2.3-d544c3d9-0d84-43d7-afe0-941939b84b8e',	'/3. Work Sheet 1.2.3-d544c3d9-0d84-43d7-afe0-941939b84b8e.docx',	'2733238',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:13:10',	'2023-11-16 16:13:10',	NULL),
(704,	8,	82,	'2. Information Sheet 2.1.1-2a346adb-f5db-4522-809b-fa6095485010',	'/2. Information Sheet 2.1.1-2a346adb-f5db-4522-809b-fa6095485010.docx',	'584759',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:13:29',	'2023-11-16 16:13:29',	NULL),
(705,	8,	82,	'2.Worksheet 2.2.1-b06e46be-793d-4e38-87b3-1e623e97a136',	'/2.Worksheet 2.2.1-b06e46be-793d-4e38-87b3-1e623e97a136.docx',	'565645',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:13:35',	'2023-11-16 16:13:35',	NULL),
(706,	8,	82,	'2. Information Sheet 2.1.2-d910d85e-797b-4d0a-a5b4-2d03f4bb1300',	'/2. Information Sheet 2.1.2-d910d85e-797b-4d0a-a5b4-2d03f4bb1300.docx',	'502341',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:13:42',	'2023-11-16 16:13:42',	NULL),
(707,	8,	82,	'2.Worksheet 2.2.2-54da5b01-4b57-4f90-9c2a-dedfdaef25ca',	'/2.Worksheet 2.2.2-54da5b01-4b57-4f90-9c2a-dedfdaef25ca.docx',	'1518995',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:13:49',	'2023-11-16 16:13:49',	NULL),
(708,	8,	82,	'2. Information Sheet 2.1.3-bec22866-fa92-4892-abd4-f207935244b7',	'/2. Information Sheet 2.1.3-bec22866-fa92-4892-abd4-f207935244b7.docx',	'631856',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:13:59',	'2023-11-16 16:13:59',	NULL),
(709,	8,	82,	'2.Worksheet 2.2.3-485d3950-c332-43b2-8cc5-7de6017c85d8',	'/2.Worksheet 2.2.3-485d3950-c332-43b2-8cc5-7de6017c85d8.docx',	'3429008',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:14:09',	'2023-11-16 16:14:09',	NULL),
(710,	8,	82,	'2. Inoformation Sheet 2.1.4-1718673e-1684-4c32-a8c2-6a9cf64ab031',	'/2. Inoformation Sheet 2.1.4-1718673e-1684-4c32-a8c2-6a9cf64ab031.docx',	'1280997',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:14:30',	'2023-11-16 16:14:30',	NULL),
(711,	8,	82,	'2.Worksheet 2.2.3-d9e3a25d-80b8-4361-8f8a-c46d25764bb7',	'/2.Worksheet 2.2.3-d9e3a25d-80b8-4361-8f8a-c46d25764bb7.docx',	'3429008',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:14:38',	'2023-11-16 16:15:08',	'2023-11-16 16:15:08'),
(712,	8,	82,	'2.Worksheet 2.2.4-9a5f6ca6-a3eb-442a-aa47-19600d2915be',	'/2.Worksheet 2.2.4-9a5f6ca6-a3eb-442a-aa47-19600d2915be.docx',	'993219',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:15:14',	'2023-11-16 16:15:14',	NULL),
(713,	8,	83,	'3. Information Sheet 3.1.1-5c3a3ab7-e924-424e-a54e-51a6a7a9fc5e',	'/3. Information Sheet 3.1.1-5c3a3ab7-e924-424e-a54e-51a6a7a9fc5e.docx',	'1001102',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:22:06',	'2023-11-16 16:22:06',	NULL),
(714,	8,	83,	'3.Worksheet 3.2.1-5610424b-338f-4f70-b44d-fcb0bdce15db',	'/3.Worksheet 3.2.1-5610424b-338f-4f70-b44d-fcb0bdce15db.docx',	'1269840',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:22:21',	'2023-11-16 16:22:21',	NULL),
(715,	8,	83,	'3. Information Sheet 3.1.2-57768830-299c-40f7-9dd3-218afce28458',	'/3. Information Sheet 3.1.2-57768830-299c-40f7-9dd3-218afce28458.docx',	'2991815',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:22:28',	'2023-11-16 16:22:28',	NULL),
(716,	8,	83,	'3.Worksheet 3.2.2-ea0903c3-b784-4b13-8bcd-26504e17b873',	'/3.Worksheet 3.2.2-ea0903c3-b784-4b13-8bcd-26504e17b873.docx',	'740449',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:22:36',	'2023-11-16 16:22:36',	NULL),
(717,	8,	83,	'3. Information Sheet 3.1.3-24190f01-a3ad-45a5-acfd-25bceed9cb31',	'/3. Information Sheet 3.1.3-24190f01-a3ad-45a5-acfd-25bceed9cb31.docx',	'1095098',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:22:44',	'2023-11-16 16:22:44',	NULL),
(718,	8,	83,	'3.Worksheet 3.2.3-4735189b-5e69-4055-afcc-e3e12f7dfbaf',	'/3.Worksheet 3.2.3-4735189b-5e69-4055-afcc-e3e12f7dfbaf.docx',	'888075',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:22:50',	'2023-11-16 16:22:50',	NULL),
(719,	8,	84,	'3. Information Sheet 1.1.1-37eed358-71bb-4124-8273-54a1f0a94cfd',	'/3. Information Sheet 1.1.1-37eed358-71bb-4124-8273-54a1f0a94cfd.docx',	'2661818',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:24:05',	'2023-11-16 16:25:23',	'2023-11-16 16:25:23'),
(720,	8,	84,	'3. Work Sheet 1.2.1-10ad1b51-20b9-4a3d-8a5d-cf4770822b0f',	'/3. Work Sheet 1.2.1-10ad1b51-20b9-4a3d-8a5d-cf4770822b0f.docx',	'4548737',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:24:14',	'2023-11-16 16:25:16',	'2023-11-16 16:25:16'),
(721,	8,	84,	'3. Information Sheet 1.1.2-c25e250f-ced3-4518-aafd-5c2fc7c2ec88',	'/3. Information Sheet 1.1.2-c25e250f-ced3-4518-aafd-5c2fc7c2ec88.docx',	'723290',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:24:21',	'2023-11-16 16:25:19',	'2023-11-16 16:25:19'),
(722,	8,	84,	'3. Work Sheet 1.2.2-9f3c81fe-c5e7-4720-b5ef-56305cf7370d',	'/3. Work Sheet 1.2.2-9f3c81fe-c5e7-4720-b5ef-56305cf7370d.docx',	'1779652',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:24:27',	'2023-11-16 16:25:26',	'2023-11-16 16:25:26'),
(723,	8,	84,	'3. Information Sheet 1.1.3-2152a147-2f77-4e25-8c7c-aef2e83e7f68',	'/3. Information Sheet 1.1.3-2152a147-2f77-4e25-8c7c-aef2e83e7f68.docx',	'970985',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:24:39',	'2023-11-16 16:25:29',	'2023-11-16 16:25:29'),
(724,	8,	84,	'3. Work Sheet 1.2.3-a09df677-7ef3-4b03-b324-5e1bb1d76fc2',	'/3. Work Sheet 1.2.3-a09df677-7ef3-4b03-b324-5e1bb1d76fc2.docx',	'2733238',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:24:46',	'2023-11-16 16:25:32',	'2023-11-16 16:25:32'),
(725,	8,	84,	'4-Information Sheet 1.1.1-1b35931e-3877-4f30-9758-6f5b11af0561',	'/4-Information Sheet 1.1.1-1b35931e-3877-4f30-9758-6f5b11af0561.docx',	'700611',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-16 16:26:38',	'2023-11-16 16:26:38',	NULL),
(726,	8,	84,	'4-Work Sheet 1.2.1-be356891-6370-4389-a394-61a9eb3f9d75',	'/4-Work Sheet 1.2.1-be356891-6370-4389-a394-61a9eb3f9d75.docx',	'515329',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 08:52:08',	'2023-11-17 08:52:08',	NULL),
(727,	8,	84,	'4-Information Sheet 1.1.2-74fd27ec-587b-43d0-b866-aa4914f56bbb',	'/4-Information Sheet 1.1.2-74fd27ec-587b-43d0-b866-aa4914f56bbb.docx',	'30121',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 08:56:22',	'2023-11-17 08:56:22',	NULL),
(728,	8,	84,	'4-Work Sheet 1.2.2-729ad266-dfbd-4a3a-a252-6a7cfbaa9ce6',	'/4-Work Sheet 1.2.2-729ad266-dfbd-4a3a-a252-6a7cfbaa9ce6.docx',	'115691',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 08:56:29',	'2023-11-17 08:56:29',	NULL),
(729,	8,	84,	'4-Information Sheet 1.1.3-fc602639-ade2-4bbf-986c-12ac7b6b32fa',	'/4-Information Sheet 1.1.3-fc602639-ade2-4bbf-986c-12ac7b6b32fa.docx',	'133259',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 08:56:36',	'2023-11-17 08:56:36',	NULL),
(730,	8,	84,	'4-Work Sheet 1.2.3-7608ce32-d62a-4d58-a716-628f781f7fc5',	'/4-Work Sheet 1.2.3-7608ce32-d62a-4d58-a716-628f781f7fc5.docx',	'202057',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 08:56:49',	'2023-11-17 08:56:49',	NULL),
(731,	8,	84,	'4-Information Sheet 1.1.4-ef05d21b-35af-4e3d-a1bd-cb139e98f88a',	'/4-Information Sheet 1.1.4-ef05d21b-35af-4e3d-a1bd-cb139e98f88a.docx',	'208816',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 08:56:59',	'2023-11-17 08:56:59',	NULL),
(732,	8,	84,	'4-Work Sheet 1.2.4-1bb1823f-79ad-4e33-ba8f-a7f474bdc568',	'/4-Work Sheet 1.2.4-1bb1823f-79ad-4e33-ba8f-a7f474bdc568.docx',	'309298',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 08:57:10',	'2023-11-17 08:57:10',	NULL),
(733,	8,	85,	'4- Information Sheet 2.1.1-ec32ecb6-ef16-441b-842a-1dbea41e9842',	'/4- Information Sheet 2.1.1-ec32ecb6-ef16-441b-842a-1dbea41e9842.docx',	'1387473',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 08:59:55',	'2023-11-17 08:59:55',	NULL),
(734,	8,	85,	'4- Worksheet 2.2.1-547ba216-011f-4aff-ad74-1828fef8cea4',	'/4- Worksheet 2.2.1-547ba216-011f-4aff-ad74-1828fef8cea4.docx',	'6875880',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 09:00:12',	'2023-11-17 09:00:12',	NULL),
(735,	8,	85,	'4- Information Sheet 2.1.2-46e697f9-82cb-46dc-9687-b51b7716af66',	'/4- Information Sheet 2.1.2-46e697f9-82cb-46dc-9687-b51b7716af66.docx',	'1635770',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 09:00:20',	'2023-11-17 09:00:20',	NULL),
(736,	8,	85,	'4- Worksheet 2.2.2-7c250664-d033-4fc2-a9d0-4f0483929a1d',	'/4- Worksheet 2.2.2-7c250664-d033-4fc2-a9d0-4f0483929a1d.docx',	'12382732',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 09:00:41',	'2023-11-17 09:00:41',	NULL),
(737,	8,	85,	'4- Information Sheet 2.1.3-d0966ea8-07d0-4fa4-9c9e-03d92855aa1f',	'/4- Information Sheet 2.1.3-d0966ea8-07d0-4fa4-9c9e-03d92855aa1f.docx',	'1249766',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 09:01:14',	'2023-11-17 09:01:14',	NULL),
(738,	8,	85,	'4- Worksheet 2.2.3-a30764a6-f675-4a9e-ab33-228ba9a1eebb',	'/4- Worksheet 2.2.3-a30764a6-f675-4a9e-ab33-228ba9a1eebb.docx',	'1233633',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 09:01:25',	'2023-11-17 09:01:25',	NULL),
(739,	8,	85,	'4- Information Sheet 2.1.4-ad6c580d-7748-438b-86b6-5aaadf7030c5',	'/4- Information Sheet 2.1.4-ad6c580d-7748-438b-86b6-5aaadf7030c5.docx',	'950918',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 09:01:46',	'2023-11-17 09:01:46',	NULL),
(740,	8,	85,	'4- Worksheet 2.2.4-b2286447-1d92-4794-a3a5-5fcc394c5fe1',	'/4- Worksheet 2.2.4-b2286447-1d92-4794-a3a5-5fcc394c5fe1.docx',	'7419944',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 09:02:00',	'2023-11-17 09:02:00',	NULL),
(741,	8,	85,	'4- Information Sheet 2.1.5-8e4653b6-29e1-4dc6-828d-c92c125db0b2',	'/4- Information Sheet 2.1.5-8e4653b6-29e1-4dc6-828d-c92c125db0b2.docx',	'932747',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 09:02:25',	'2023-11-17 09:02:25',	NULL),
(742,	8,	85,	'4- Worksheet 2.2.5-8c4d74bd-f748-48dc-9e25-d74e03837c05',	'/4- Worksheet 2.2.5-8c4d74bd-f748-48dc-9e25-d74e03837c05.docx',	'3153691',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 09:02:34',	'2023-11-17 09:02:34',	NULL),
(743,	8,	86,	'4- Information Sheet 3.1.1-2567964c-8e2b-4ec3-95db-a2d92cfa9a28',	'/4- Information Sheet 3.1.1-2567964c-8e2b-4ec3-95db-a2d92cfa9a28.docx',	'853682',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 09:03:25',	'2023-11-17 09:03:25',	NULL),
(744,	8,	86,	'4- Worksheet 3.2.1-0680855a-fd68-4881-83b5-40a356ee8bfd',	'/4- Worksheet 3.2.1-0680855a-fd68-4881-83b5-40a356ee8bfd.docx',	'2905177',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 09:03:35',	'2023-11-17 09:03:35',	NULL),
(745,	8,	86,	'4- Information Sheet 3.1.2-6c47768b-a267-4195-ba2d-4ee094b92c90',	'/4- Information Sheet 3.1.2-6c47768b-a267-4195-ba2d-4ee094b92c90.docx',	'1025711',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 09:03:43',	'2023-11-17 09:03:43',	NULL),
(746,	8,	86,	'4- Worksheet 3.2.2-9a6b7ae1-30f7-478a-a5f7-fd5f9e3276cd',	'/4- Worksheet 3.2.2-9a6b7ae1-30f7-478a-a5f7-fd5f9e3276cd.docx',	'816309',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 09:03:53',	'2023-11-17 09:03:53',	NULL),
(747,	8,	86,	'4- Information Sheet 3.1.3-8b878eed-63ba-4d87-8feb-792a17c01ca8',	'/4- Information Sheet 3.1.3-8b878eed-63ba-4d87-8feb-792a17c01ca8.docx',	'2409261',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 09:04:06',	'2023-11-17 09:04:06',	NULL),
(748,	8,	86,	'4- Worksheet 3.2.3-abc0d0a6-4904-4f79-b97b-73cd2edd52c9',	'/4- Worksheet 3.2.3-abc0d0a6-4904-4f79-b97b-73cd2edd52c9.docx',	'2021037',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 09:04:15',	'2023-11-17 09:04:15',	NULL),
(749,	8,	88,	'5-Information Sheet 1.1.1-08a688c2-605e-4aa1-b885-7e3d9eb2cf87',	'/5-Information Sheet 1.1.1-08a688c2-605e-4aa1-b885-7e3d9eb2cf87.docx',	'1319688',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 09:30:38',	'2023-11-17 09:30:38',	NULL),
(750,	8,	88,	'5-Work Sheet From 1.2.1-7ab1a385-f197-40dc-b78b-5f0027ed9647',	'/5-Work Sheet From 1.2.1-7ab1a385-f197-40dc-b78b-5f0027ed9647.docx',	'1322600',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 09:30:47',	'2023-11-17 09:30:47',	NULL),
(751,	8,	88,	'5-Information Sheet 1.1.2-8700a6af-e74c-43c8-b540-998ec7039132',	'/5-Information Sheet 1.1.2-8700a6af-e74c-43c8-b540-998ec7039132.docx',	'1309381',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 09:30:58',	'2023-11-17 09:30:58',	NULL),
(752,	8,	88,	'5-Work Sheet From 1.2.2-55a41c11-9550-44a4-bb4d-730d2e51aea5',	'/5-Work Sheet From 1.2.2-55a41c11-9550-44a4-bb4d-730d2e51aea5.docx',	'1315206',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 09:31:05',	'2023-11-17 09:31:05',	NULL),
(753,	8,	88,	'5-Information Sheet 1.1.3-070a8e46-802c-49b9-ae9f-97df015a9860',	'/5-Information Sheet 1.1.3-070a8e46-802c-49b9-ae9f-97df015a9860.docx',	'456560',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 09:31:11',	'2023-11-17 09:31:11',	NULL),
(754,	8,	88,	'5-Work Sheet From 1.2.3-07ff4f08-cd8d-45d8-8303-9ef9d322e1e3',	'/5-Work Sheet From 1.2.3-07ff4f08-cd8d-45d8-8303-9ef9d322e1e3.docx',	'229858',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 09:31:18',	'2023-11-17 09:31:18',	NULL),
(755,	8,	89,	'5-Information Sheet 2.1.1-2707110e-9329-4738-bc75-c8fce6055a16',	'/5-Information Sheet 2.1.1-2707110e-9329-4738-bc75-c8fce6055a16.docx',	'1336194',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 10:44:45',	'2023-11-17 10:44:45',	NULL),
(756,	8,	89,	'5-Work Sheet From 2.2.1-16cbdb7c-a397-4485-8a30-81f9e1237c81',	'/5-Work Sheet From 2.2.1-16cbdb7c-a397-4485-8a30-81f9e1237c81.docx',	'44716',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 10:44:51',	'2023-11-17 10:44:51',	NULL),
(757,	8,	89,	'5-Information Sheet 2.1.2-975121b3-58fa-4e4e-a5a4-1de16183e5a7',	'/5-Information Sheet 2.1.2-975121b3-58fa-4e4e-a5a4-1de16183e5a7.docx',	'1433153',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 10:44:58',	'2023-11-17 10:44:58',	NULL),
(758,	8,	89,	'5-Work Sheet From 2.2.2-d7688dd3-6ef6-46c3-99fc-608cf82c2cea',	'/5-Work Sheet From 2.2.2-d7688dd3-6ef6-46c3-99fc-608cf82c2cea.docx',	'220642',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 10:45:05',	'2023-11-17 10:45:05',	NULL),
(759,	8,	89,	'5-Information Sheet 2.1.3-db46e049-6880-490a-9015-98e42a7e149a',	'/5-Information Sheet 2.1.3-db46e049-6880-490a-9015-98e42a7e149a.docx',	'29537',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 10:45:11',	'2023-11-17 10:45:11',	NULL),
(760,	8,	89,	'5-Work Sheet From 2.2.3-04261040-ed36-4cc5-a1e8-56aa0250a299',	'/5-Work Sheet From 2.2.3-04261040-ed36-4cc5-a1e8-56aa0250a299.docx',	'335951',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 10:45:19',	'2023-11-17 10:45:19',	NULL),
(761,	8,	90,	'3-Information Sheet 3.1.1-d10da102-e74a-4759-a2cd-d672fc4d751e',	'/3-Information Sheet 3.1.1-d10da102-e74a-4759-a2cd-d672fc4d751e.docx',	'597494',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 10:45:40',	'2023-11-17 10:45:40',	NULL),
(762,	8,	90,	'4-Work Sheet From 3.2.1-ecc33265-10bb-4294-8ade-781483665351',	'/4-Work Sheet From 3.2.1-ecc33265-10bb-4294-8ade-781483665351.docx',	'402345',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 10:45:46',	'2023-11-17 10:45:46',	NULL),
(763,	8,	90,	'3-Information Sheet 3.1.2-608aafd8-e5b5-4aee-96b8-83f1d25c72f2',	'/3-Information Sheet 3.1.2-608aafd8-e5b5-4aee-96b8-83f1d25c72f2.docx',	'307995',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 10:45:54',	'2023-11-17 10:45:54',	NULL),
(764,	8,	90,	'4-Work Sheet From 3.2.2-e7424a02-0d46-4fe3-beee-18d3f778e694',	'/4-Work Sheet From 3.2.2-e7424a02-0d46-4fe3-beee-18d3f778e694.docx',	'44817',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 10:46:01',	'2023-11-17 10:46:01',	NULL),
(765,	8,	90,	'3-Information Sheet 3.1.3-90cb06da-00b2-4dc6-bc8a-c244fb44804d',	'/3-Information Sheet 3.1.3-90cb06da-00b2-4dc6-bc8a-c244fb44804d.docx',	'7226513',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 10:46:14',	'2023-11-17 10:46:14',	NULL),
(766,	8,	90,	'4-Work Sheet From 3.2.3-a0a9dd4e-6457-4511-9fab-2b285567e8a8',	'/4-Work Sheet From 3.2.3-a0a9dd4e-6457-4511-9fab-2b285567e8a8.docx',	'1320620',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 10:46:23',	'2023-11-17 10:46:23',	NULL),
(767,	8,	90,	'3-Information Sheet 3.1.4-c00614e2-0adf-4efa-afab-fd4017ae7ea0',	'/3-Information Sheet 3.1.4-c00614e2-0adf-4efa-afab-fd4017ae7ea0.docx',	'30605',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 10:46:46',	'2023-11-17 10:46:46',	NULL),
(768,	8,	90,	'4-Work Sheet From 3.2.4-66795c6e-e00e-4eab-b952-2eaeb8fbbe64',	'/4-Work Sheet From 3.2.4-66795c6e-e00e-4eab-b952-2eaeb8fbbe64.docx',	'310817',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 10:46:55',	'2023-11-17 10:46:55',	NULL),
(769,	8,	90,	'4-Work Sheet From 3.2.5-daf9073a-6c00-4245-b19b-71b0be4f1cec',	'/4-Work Sheet From 3.2.5-daf9073a-6c00-4245-b19b-71b0be4f1cec.docx',	'214858',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 10:47:08',	'2023-11-17 10:47:08',	NULL),
(770,	8,	91,	'3-Information Sheet 4.1.1-b50ff1f4-0df5-449c-927b-8a19759ba158',	'/3-Information Sheet 4.1.1-b50ff1f4-0df5-449c-927b-8a19759ba158.docx',	'28769',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 10:48:00',	'2023-11-17 10:48:00',	NULL),
(771,	8,	91,	'4-Work Sheet From 4.2.1-ea32eac3-07ba-4828-ab98-c55904c31212',	'/4-Work Sheet From 4.2.1-ea32eac3-07ba-4828-ab98-c55904c31212.docx',	'252898',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 10:48:06',	'2023-11-17 10:48:06',	NULL),
(772,	8,	91,	'3-Information Sheet 4.1.2-0ed6dd92-e576-4f91-a3a5-2e8c871957fb',	'/3-Information Sheet 4.1.2-0ed6dd92-e576-4f91-a3a5-2e8c871957fb.docx',	'27245',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 10:48:15',	'2023-11-17 10:48:15',	NULL),
(773,	8,	91,	'4-Work Sheet From 4.2.2-0234a477-b94e-4164-a460-0649237a09e1',	'/4-Work Sheet From 4.2.2-0234a477-b94e-4164-a460-0649237a09e1.docx',	'38469',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 10:48:23',	'2023-11-17 10:48:23',	NULL),
(774,	8,	91,	'3-Information Sheet 4.1.3-f3fe637d-d58e-4000-84dd-c091076941e2',	'/3-Information Sheet 4.1.3-f3fe637d-d58e-4000-84dd-c091076941e2.docx',	'593574',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 10:58:05',	'2023-11-17 10:58:05',	NULL),
(775,	8,	91,	'4-Work Sheet From 4.2.3-fa26325a-4d4c-42e7-b54c-502031bb252c',	'/4-Work Sheet From 4.2.3-fa26325a-4d4c-42e7-b54c-502031bb252c.docx',	'198258',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 10:58:18',	'2023-11-17 10:58:18',	NULL),
(776,	8,	95,	'6-Information Sheet 1.1.1-01b3cb25-c926-4e50-bd39-e86608180aab',	'/6-Information Sheet 1.1.1-01b3cb25-c926-4e50-bd39-e86608180aab.docx',	'215191',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 11:13:28',	'2023-11-17 11:13:28',	NULL),
(777,	8,	95,	'6-Work Sheet 1.2.1-90c21653-98b1-4747-99db-cc6d53d1f589',	'/6-Work Sheet 1.2.1-90c21653-98b1-4747-99db-cc6d53d1f589.docx',	'357160',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 11:13:36',	'2023-11-17 11:13:36',	NULL),
(778,	8,	95,	'6-Information Sheet 1.1.2-96c66809-b61b-4bb2-8bd7-0861bb359ad9',	'/6-Information Sheet 1.1.2-96c66809-b61b-4bb2-8bd7-0861bb359ad9.docx',	'518738',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 11:13:42',	'2023-11-17 11:13:42',	NULL),
(779,	8,	95,	'6-Work Sheet 1.2.2-032192ec-091d-45a7-b19f-d75708d61476',	'/6-Work Sheet 1.2.2-032192ec-091d-45a7-b19f-d75708d61476.docx',	'191311',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 11:13:49',	'2023-11-17 11:13:49',	NULL),
(780,	8,	95,	'6-Information Sheet 1.1.3-f166d679-ae61-4290-806f-108ec4fabfbe',	'/6-Information Sheet 1.1.3-f166d679-ae61-4290-806f-108ec4fabfbe.docx',	'541796',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 11:14:01',	'2023-11-17 11:14:01',	NULL),
(781,	8,	95,	'6-Work Sheet 1.2.3-6dafd25f-0c6d-4dd7-b9f9-5d4dfa49eb1f',	'/6-Work Sheet 1.2.3-6dafd25f-0c6d-4dd7-b9f9-5d4dfa49eb1f.docx',	'411860',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 11:14:08',	'2023-11-17 11:14:08',	NULL),
(782,	8,	95,	'6-Information Sheet​ 1.1.4-82ef39b7-0d14-48df-b970-78c552d77f58',	'/6-Information Sheet​ 1.1.4-82ef39b7-0d14-48df-b970-78c552d77f58.docx',	'234435',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 11:14:25',	'2023-11-17 11:14:25',	NULL),
(783,	8,	95,	'6-Work Sheet 1.2.4-d1499d00-b28a-4e49-af33-2286a56f6bc9',	'/6-Work Sheet 1.2.4-d1499d00-b28a-4e49-af33-2286a56f6bc9.docx',	'1345472',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 11:14:32',	'2023-11-17 11:14:32',	NULL),
(784,	8,	96,	'6-Information Sheet 2.1.1-f94d8bee-51d5-434f-b198-f72ce80b2937',	'/6-Information Sheet 2.1.1-f94d8bee-51d5-434f-b198-f72ce80b2937.docx',	'1170665',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 11:14:50',	'2023-11-17 11:14:50',	NULL),
(785,	8,	96,	'6-Work Sheet 2.2.1-3425d3ec-344e-4375-9d19-92f8d7a274f8',	'/6-Work Sheet 2.2.1-3425d3ec-344e-4375-9d19-92f8d7a274f8.docx',	'892730',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 11:14:58',	'2023-11-17 11:14:58',	NULL),
(786,	8,	96,	'6-Information Sheet 2.1.2-c821803b-7ac4-4e91-b2a3-256592bde22e',	'/6-Information Sheet 2.1.2-c821803b-7ac4-4e91-b2a3-256592bde22e.docx',	'539976',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 11:15:04',	'2023-11-17 11:15:04',	NULL),
(787,	8,	96,	'6-Work Sheet 2.2.2-e825b5c7-ce84-40a0-91c1-639aac9e860c',	'/6-Work Sheet 2.2.2-e825b5c7-ce84-40a0-91c1-639aac9e860c.docx',	'411616',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 11:15:10',	'2023-11-17 11:15:10',	NULL),
(788,	8,	96,	'6-Information Sheet 2.1.3-09d39102-6482-4da3-b0eb-b330113148f6',	'/6-Information Sheet 2.1.3-09d39102-6482-4da3-b0eb-b330113148f6.docx',	'543333',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 11:15:16',	'2023-11-17 11:15:16',	NULL),
(789,	8,	96,	'6-Work Sheet 2.2.3-27348858-39e5-4e50-8480-a45806d80c23',	'/6-Work Sheet 2.2.3-27348858-39e5-4e50-8480-a45806d80c23.docx',	'411393',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 11:15:26',	'2023-11-17 11:15:26',	NULL),
(790,	8,	96,	'6-Information Sheet 2.1.4-8bac4764-96df-4a88-b8df-8d3f0b33834e',	'/6-Information Sheet 2.1.4-8bac4764-96df-4a88-b8df-8d3f0b33834e.docx',	'125107',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 11:15:34',	'2023-11-17 11:15:34',	NULL),
(791,	8,	96,	'6-Work Sheet 2.2.4-bad00347-bc17-4fb4-9631-575388c51f7f',	'/6-Work Sheet 2.2.4-bad00347-bc17-4fb4-9631-575388c51f7f.docx',	'134060',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 11:15:49',	'2023-11-17 11:15:49',	NULL),
(792,	8,	96,	'6-Information Sheet 2.1.5-b3b932f8-db7f-4c6a-881c-29502b2a6c0f',	'/6-Information Sheet 2.1.5-b3b932f8-db7f-4c6a-881c-29502b2a6c0f.docx',	'504668',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 11:15:56',	'2023-11-17 11:15:56',	NULL),
(793,	8,	96,	'6-Work Sheet 2.2.5-44f2f6fe-50d4-4dee-82c6-77d87bdd1186',	'/6-Work Sheet 2.2.5-44f2f6fe-50d4-4dee-82c6-77d87bdd1186.docx',	'674651',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 11:16:02',	'2023-11-17 11:16:02',	NULL),
(794,	8,	97,	'6-Information Sheet 3.1.1-d006572f-585b-4163-b051-20cd09123bb6',	'/6-Information Sheet 3.1.1-d006572f-585b-4163-b051-20cd09123bb6.docx',	'607965',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 11:16:28',	'2023-11-17 11:16:28',	NULL),
(795,	8,	97,	'6-Work Sheet 3.2.1-bede54f2-f33a-47f1-9c13-ba306d147bc6',	'/6-Work Sheet 3.2.1-bede54f2-f33a-47f1-9c13-ba306d147bc6.docx',	'411996',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 11:16:34',	'2023-11-17 11:16:34',	NULL),
(796,	8,	97,	'6-Information Sheet 3.1.2-8c6c2099-bc3b-4603-9fbd-c0e67021c494',	'/6-Information Sheet 3.1.2-8c6c2099-bc3b-4603-9fbd-c0e67021c494.docx',	'168526',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 11:16:40',	'2023-11-17 11:16:40',	NULL),
(797,	8,	97,	'6-Work Sheet 3.2.2-1cb64049-1730-4586-bcdc-87fb3c78d965',	'/6-Work Sheet 3.2.2-1cb64049-1730-4586-bcdc-87fb3c78d965.docx',	'740832',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 11:16:46',	'2023-11-17 11:16:46',	NULL),
(798,	8,	98,	'6. Information Sheet 4.1.1-eb644772-c440-4378-bb84-f3f03661d914',	'/6. Information Sheet 4.1.1-eb644772-c440-4378-bb84-f3f03661d914.docx',	'338938',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 11:17:17',	'2023-11-17 11:17:17',	NULL),
(799,	8,	98,	'6. WorkSheet 4.2.1-6c1f6f80-b79e-4685-99ce-0624c4585e22',	'/6. WorkSheet 4.2.1-6c1f6f80-b79e-4685-99ce-0624c4585e22.docx',	'311369',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 11:17:24',	'2023-11-17 11:17:24',	NULL),
(800,	8,	98,	'6. Information Sheet 4.1.2-3a80dbb5-2ec7-4f56-aa61-7ea789c44d40',	'/6. Information Sheet 4.1.2-3a80dbb5-2ec7-4f56-aa61-7ea789c44d40.docx',	'1179046',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 15:31:58',	'2023-11-17 15:31:58',	NULL),
(801,	8,	98,	'6. Worksheet 4.2.2-98a1e45e-cc21-4a29-a704-cf02c7b7157d',	'/6. Worksheet 4.2.2-98a1e45e-cc21-4a29-a704-cf02c7b7157d.docx',	'1045756',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 15:32:21',	'2023-11-17 15:32:21',	NULL),
(802,	8,	98,	'6. Information Sheet 4.1.3-3790bb88-4cf5-4589-b445-ca8923235f7a',	'/6. Information Sheet 4.1.3-3790bb88-4cf5-4589-b445-ca8923235f7a.docx',	'163172',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 15:32:33',	'2023-11-17 15:32:33',	NULL),
(803,	8,	98,	'6. Information Sheet 4.1.3-62f02935-22a7-4d5b-877b-0834f2bd3a78',	'/6. Information Sheet 4.1.3-62f02935-22a7-4d5b-877b-0834f2bd3a78.docx',	'163172',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 15:33:43',	'2023-11-17 15:34:51',	'2023-11-17 15:34:51'),
(804,	8,	98,	'6. Worksheet 4.2.4-a8910b41-9f0a-4ce2-8624-0a4e0fb43b90',	'/6. Worksheet 4.2.4-a8910b41-9f0a-4ce2-8624-0a4e0fb43b90.docx',	'21603',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 15:35:26',	'2023-11-17 15:36:17',	'2023-11-17 15:36:17'),
(805,	8,	98,	'6. Worksheet 4.2.3-b0bf74b6-c5b6-4c0b-9b87-10c9bf6d0f69',	'/6. Worksheet 4.2.3-b0bf74b6-c5b6-4c0b-9b87-10c9bf6d0f69.docx',	'163140',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-17 15:36:25',	'2023-11-17 15:36:25',	NULL),
(806,	8,	99,	'7-Information Sheet 1.1.1-b3c4c4d0-270e-483f-9abf-3fa807529e62',	'/7-Information Sheet 1.1.1-b3c4c4d0-270e-483f-9abf-3fa807529e62.docx',	'298609',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-20 15:42:51',	'2023-11-20 15:42:51',	NULL),
(807,	8,	99,	'7-Work Sheet From 1.2.1-f8a0bedd-5981-4c87-8840-1bcb3f867294',	'/7-Work Sheet From 1.2.1-f8a0bedd-5981-4c87-8840-1bcb3f867294.docx',	'302268',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-20 15:42:59',	'2023-11-20 15:42:59',	NULL),
(808,	8,	99,	'7-Information Sheet 1.1.2-02ba6689-758d-4a85-8430-7524c39e0680',	'/7-Information Sheet 1.1.2-02ba6689-758d-4a85-8430-7524c39e0680.docx',	'629736',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-20 15:43:08',	'2023-11-20 15:43:08',	NULL),
(809,	8,	99,	'7-Work Sheet From 1.2.2-da338c83-6c6a-49a4-94d8-2772024a8601',	'/7-Work Sheet From 1.2.2-da338c83-6c6a-49a4-94d8-2772024a8601.docx',	'243319',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-20 15:43:15',	'2023-11-20 15:43:15',	NULL),
(810,	8,	99,	'7-Information Sheet 1.1.3-b1381e7e-4c24-47c5-b94c-60dcfaf97de8',	'/7-Information Sheet 1.1.3-b1381e7e-4c24-47c5-b94c-60dcfaf97de8.docx',	'219509',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-20 15:43:34',	'2023-11-20 15:43:34',	NULL),
(811,	8,	99,	'7-Work Sheet From 1.2.3-512abda0-653f-408b-be26-8a951b49ef29',	'/7-Work Sheet From 1.2.3-512abda0-653f-408b-be26-8a951b49ef29.docx',	'170909',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-20 15:44:01',	'2023-11-20 15:44:01',	NULL),
(812,	8,	100,	'7- Information Sheet 2.1.1-e431a3f6-a2bc-4ea2-adc8-801823987d2f',	'/7- Information Sheet 2.1.1-e431a3f6-a2bc-4ea2-adc8-801823987d2f.docx',	'1728258',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-20 15:44:45',	'2023-11-20 15:44:45',	NULL),
(813,	8,	100,	'7- Worksheet 2.2.1-33c94a1c-cee4-4469-8bb0-3f19ba499a03',	'/7- Worksheet 2.2.1-33c94a1c-cee4-4469-8bb0-3f19ba499a03.docx',	'2265569',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-20 15:44:53',	'2023-11-20 15:44:53',	NULL),
(814,	8,	100,	'7- Information Sheet 2.1.2-bd1dd318-f2c4-4154-8cbf-fe3426019945',	'/7- Information Sheet 2.1.2-bd1dd318-f2c4-4154-8cbf-fe3426019945.docx',	'3268328',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-20 15:45:01',	'2023-11-20 15:45:01',	NULL),
(815,	8,	100,	'7- Worksheet 2.2.2-7eca889a-037e-4e40-ba22-3125f7fcbaf3',	'/7- Worksheet 2.2.2-7eca889a-037e-4e40-ba22-3125f7fcbaf3.docx',	'5416001',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-20 15:45:11',	'2023-11-20 15:45:11',	NULL),
(816,	8,	100,	'7- Information Sheet 2.1.3-f83c1598-1d77-4076-9961-d2fe3e33ad84',	'/7- Information Sheet 2.1.3-f83c1598-1d77-4076-9961-d2fe3e33ad84.docx',	'5140663',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-20 15:45:22',	'2023-11-20 15:45:22',	NULL),
(817,	8,	100,	'7- Worksheet 2.2.3-e1ca9aee-081a-4721-a8f8-4fcd0b59da3a',	'/7- Worksheet 2.2.3-e1ca9aee-081a-4721-a8f8-4fcd0b59da3a.docx',	'4894399',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-20 15:45:31',	'2023-11-20 15:45:31',	NULL),
(818,	8,	101,	'7-Information Sheet 3.1.1-5cf981a8-a214-41a8-8edb-f1c926c3a6aa',	'/7-Information Sheet 3.1.1-5cf981a8-a214-41a8-8edb-f1c926c3a6aa.docx',	'933922',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-20 15:45:54',	'2023-11-20 15:45:54',	NULL),
(819,	8,	101,	'7-Work Sheet From 3.2.1-09fcbd3b-9aba-4b16-ae5f-d8e1743d25b0',	'/7-Work Sheet From 3.2.1-09fcbd3b-9aba-4b16-ae5f-d8e1743d25b0.docx',	'1235307',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-20 15:46:08',	'2023-11-20 15:46:08',	NULL),
(820,	8,	101,	'7-Information Sheet 3.1.2-f8452daa-d9b3-453f-8e24-f3a0239a6cf2',	'/7-Information Sheet 3.1.2-f8452daa-d9b3-453f-8e24-f3a0239a6cf2.docx',	'2560573',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-20 15:46:18',	'2023-11-20 15:46:18',	NULL),
(821,	8,	101,	'7-Work Sheet From 3.2.2-0b85a913-812b-45e0-b88e-2234ce3b071c',	'/7-Work Sheet From 3.2.2-0b85a913-812b-45e0-b88e-2234ce3b071c.docx',	'4159824',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-20 15:46:32',	'2023-11-20 15:46:32',	NULL),
(822,	8,	101,	'7-Information Sheet 3.1.3-ee68c01d-fc44-4127-a9d2-7f58621ef20b',	'/7-Information Sheet 3.1.3-ee68c01d-fc44-4127-a9d2-7f58621ef20b.docx',	'8930385',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-20 15:47:05',	'2023-11-20 15:47:05',	NULL),
(823,	8,	101,	'7-Work Sheet From 3.2.3-77fe674e-acd2-49ba-ad0e-6043ff5fbeba',	'/7-Work Sheet From 3.2.3-77fe674e-acd2-49ba-ad0e-6043ff5fbeba.docx',	'5411266',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-20 15:47:18',	'2023-11-20 15:47:18',	NULL),
(824,	8,	101,	'7-Information Sheet 3.1.4-7bb336d1-cea7-40fb-8c92-ac6990743ef5',	'/7-Information Sheet 3.1.4-7bb336d1-cea7-40fb-8c92-ac6990743ef5.docx',	'5547133',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-20 15:47:53',	'2023-11-20 15:47:53',	NULL),
(825,	8,	101,	'7-Work Sheet From 3.2.4-eb574337-2df3-47be-9943-a77a4c3bfa9f',	'/7-Work Sheet From 3.2.4-eb574337-2df3-47be-9943-a77a4c3bfa9f.docx',	'5425171',	NULL,	NULL,	'docx',	0,	0,	0,	0,	1,	'2023-11-20 15:48:11',	'2023-11-20 15:48:11',	NULL),
(826,	1,	NULL,	'B Puty (4x6)-cc9d17b9-240a-443a-a660-d26fa1515871',	'/B Puty (4x6)-cc9d17b9-240a-443a-a660-d26fa1515871.jpg',	'298311',	1100,	1408,	'jpg',	0,	1,	0,	0,	0,	'2023-11-25 09:06:11',	'2023-11-25 09:06:11',	NULL),
(827,	1,	2,	'B Puty (4x6)-b0483493-675f-4263-8486-eedf5191882a',	'/B Puty (4x6)-b0483493-675f-4263-8486-eedf5191882a.jpg',	'298311',	1100,	1408,	'jpg',	0,	1,	0,	0,	0,	'2023-11-25 09:08:03',	'2023-11-25 09:08:03',	NULL),
(828,	1,	2,	'4x6-0a1bc69d-8fce-4791-87a4-9f64a2640f6e',	'/4x6-0a1bc69d-8fce-4791-87a4-9f64a2640f6e.jpg',	'133610',	413,	531,	'jpg',	0,	1,	0,	0,	0,	'2023-11-25 09:08:12',	'2023-11-25 09:08:12',	NULL),
(829,	1,	2,	'183216190_131500742306060_6462817013635166118_n-75783f20-049c-4eb8-9769-5fcdefe9131f',	'/183216190_131500742306060_6462817013635166118_n-75783f20-049c-4eb8-9769-5fcdefe9131f.png',	'2112692',	2048,	2430,	'png',	0,	1,	0,	0,	0,	'2024-01-06 15:22:18',	'2024-01-06 15:22:18',	NULL),
(830,	1,	NULL,	'Gobal-steven-01-f1d17aca-f500-4969-b415-028b8d0d6c35',	'/Gobal-steven-01-f1d17aca-f500-4969-b415-028b8d0d6c35.jpg',	'869810',	4000,	2250,	'jpg',	0,	1,	0,	0,	0,	'2024-01-06 15:23:30',	'2024-01-06 15:23:30',	NULL),
(831,	1,	NULL,	'Gobal-steven-02-5151180d-eda2-48cd-8201-daa2ab9248da',	'/Gobal-steven-02-5151180d-eda2-48cd-8201-daa2ab9248da.jpg',	'861093',	4000,	2250,	'jpg',	0,	1,	0,	0,	0,	'2024-01-06 15:40:16',	'2024-01-06 15:40:16',	NULL),
(832,	1,	NULL,	'Gobal-steven-03-2d687f04-f394-4001-aefb-b5e413234463',	'/Gobal-steven-03-2d687f04-f394-4001-aefb-b5e413234463.jpg',	'996748',	4000,	2250,	'jpg',	0,	1,	0,	0,	0,	'2024-01-06 15:43:37',	'2024-01-06 15:43:37',	NULL),
(833,	1,	NULL,	'Gobal-steven-04-adbc74c7-c058-436f-a9af-6bd8d370241d',	'/Gobal-steven-04-adbc74c7-c058-436f-a9af-6bd8d370241d.jpg',	'972933',	4000,	2250,	'jpg',	0,	1,	0,	0,	0,	'2024-01-06 15:45:07',	'2024-01-06 15:45:07',	NULL),
(834,	1,	NULL,	'DSC07202-db8e4453-bda4-4db8-b520-b0eca792f9a9',	'/DSC07202-db8e4453-bda4-4db8-b520-b0eca792f9a9.jpg',	'1024155',	6000,	4000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:13:59',	'2024-02-13 09:13:59',	NULL),
(835,	1,	NULL,	'DSC07203-2fefd0fa-5be3-4ea1-a63b-80ac6bf0f786',	'/DSC07203-2fefd0fa-5be3-4ea1-a63b-80ac6bf0f786.jpg',	'1138883',	6000,	4000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:13:59',	'2024-02-13 09:13:59',	NULL),
(836,	1,	NULL,	'DSC07032-4648ffd4-efcb-474b-a2dc-fb2aa5c93566',	'/DSC07032-4648ffd4-efcb-474b-a2dc-fb2aa5c93566.jpg',	'1465989',	4000,	6000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:14:01',	'2024-02-13 09:14:01',	NULL),
(837,	1,	NULL,	'DSC07042-45d96033-e9d3-43c8-a273-35c3d3d49b05',	'/DSC07042-45d96033-e9d3-43c8-a273-35c3d3d49b05.jpg',	'1580887',	4000,	6000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:14:02',	'2024-02-13 09:14:02',	NULL),
(838,	1,	NULL,	'DSC07277-77b981a5-fc4f-4cd0-8875-c93be6c48d63',	'/DSC07277-77b981a5-fc4f-4cd0-8875-c93be6c48d63.jpg',	'1630987',	4000,	6000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:14:02',	'2024-02-13 09:14:02',	NULL),
(839,	1,	NULL,	'DSC07287-c130b981-2b6e-49f6-bb27-d122f180d080',	'/DSC07287-c130b981-2b6e-49f6-bb27-d122f180d080.jpg',	'1682778',	4000,	6000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:14:02',	'2024-02-13 09:14:02',	NULL),
(840,	1,	NULL,	'DSC07158-ba3d645e-d1f4-4bc4-9cfe-a84c6de999ed',	'/DSC07158-ba3d645e-d1f4-4bc4-9cfe-a84c6de999ed.jpg',	'1755947',	4000,	6000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:14:02',	'2024-02-13 09:14:02',	NULL),
(841,	1,	NULL,	'DSC07173-b9fa7a7a-0ba7-4675-a261-40a08a568a06',	'/DSC07173-b9fa7a7a-0ba7-4675-a261-40a08a568a06.jpg',	'1755114',	4000,	6000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:14:03',	'2024-02-13 09:14:03',	NULL),
(842,	1,	NULL,	'DSC06979-f3314e63-804e-4036-9065-b903321aed37',	'/DSC06979-f3314e63-804e-4036-9065-b903321aed37.jpg',	'1948405',	4000,	6000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:14:03',	'2024-02-13 09:14:03',	NULL),
(843,	1,	NULL,	'DSC07104-47f46db9-4909-40d7-b667-f5bf38944430',	'/DSC07104-47f46db9-4909-40d7-b667-f5bf38944430.jpg',	'1976207',	4000,	6000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:14:03',	'2024-02-13 09:14:03',	NULL),
(844,	1,	NULL,	'DSC07289-ae614984-70e9-4a8d-a22d-b4637512cbed',	'/DSC07289-ae614984-70e9-4a8d-a22d-b4637512cbed.jpg',	'2059121',	4000,	6000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:14:03',	'2024-02-13 09:14:03',	NULL),
(845,	1,	NULL,	'DSC07103-d6140274-8192-4f20-9edc-256a05b681e6',	'/DSC07103-d6140274-8192-4f20-9edc-256a05b681e6.jpg',	'2239070',	4000,	6000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:14:04',	'2024-02-13 09:14:04',	NULL),
(846,	1,	NULL,	'DSC07035-ab72f4d3-faa3-4cf0-b73a-06984c921bb2',	'/DSC07035-ab72f4d3-faa3-4cf0-b73a-06984c921bb2.jpg',	'2414673',	4000,	6000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:14:04',	'2024-02-13 09:14:04',	NULL),
(847,	1,	102,	'DSC06966-4390e8a5-e9f1-4242-b4d8-fa613902f458',	'/DSC06966-4390e8a5-e9f1-4242-b4d8-fa613902f458.jpg',	'845710',	5521,	3681,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:16:59',	'2024-02-13 09:16:59',	NULL),
(848,	1,	102,	'DSC06970-056e9a13-bd77-428e-a276-335822785de2',	'/DSC06970-056e9a13-bd77-428e-a276-335822785de2.jpg',	'845227',	5203,	3469,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:16:59',	'2024-02-13 09:16:59',	NULL),
(849,	1,	102,	'DSC06965-02f73120-d685-47ac-a23b-48c5118e3678',	'/DSC06965-02f73120-d685-47ac-a23b-48c5118e3678.jpg',	'885101',	4915,	3277,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:16:59',	'2024-02-13 09:16:59',	NULL),
(850,	1,	102,	'DSC06937-55ecdcd4-761b-4f8a-89ea-3597ab57b001',	'/DSC06937-55ecdcd4-761b-4f8a-89ea-3597ab57b001.jpg',	'903147',	4246,	2831,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:16:59',	'2024-02-13 09:16:59',	NULL),
(851,	1,	102,	'DSC06902-696a1896-9949-4d52-b93b-9ecb416de812',	'/DSC06902-696a1896-9949-4d52-b93b-9ecb416de812.jpg',	'1098547',	6000,	4000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:17:02',	'2024-02-13 09:17:02',	NULL),
(852,	1,	102,	'DSC06918-567ce170-c258-414e-a6c4-a8e831789363',	'/DSC06918-567ce170-c258-414e-a6c4-a8e831789363.jpg',	'1262934',	6000,	4000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:17:03',	'2024-02-13 09:17:03',	NULL),
(853,	1,	102,	'DSC06959-302f3c5c-3918-443a-9c39-8ed0578aa5db',	'/DSC06959-302f3c5c-3918-443a-9c39-8ed0578aa5db.jpg',	'1272571',	6000,	4000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:17:03',	'2024-02-13 09:17:03',	NULL),
(854,	1,	102,	'DSC06969-3fc2a6b4-3973-40db-a021-db3118d75cb6',	'/DSC06969-3fc2a6b4-3973-40db-a021-db3118d75cb6.jpg',	'1358204',	6000,	4000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:17:04',	'2024-02-13 09:17:04',	NULL),
(855,	1,	102,	'DSC06945-953754d9-30c0-44c7-906f-9dec2579b845',	'/DSC06945-953754d9-30c0-44c7-906f-9dec2579b845.jpg',	'1426816',	6000,	4000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:17:04',	'2024-02-13 09:17:04',	NULL),
(856,	1,	102,	'DSC06895-bfd9343d-6ece-48bb-af39-c64b3d5f2561',	'/DSC06895-bfd9343d-6ece-48bb-af39-c64b3d5f2561.jpg',	'1613082',	6000,	4000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:17:06',	'2024-02-13 09:17:06',	NULL),
(857,	1,	102,	'DSC06907-4fcefb51-13af-4148-ae08-360c65569671',	'/DSC06907-4fcefb51-13af-4148-ae08-360c65569671.jpg',	'1699733',	6000,	4000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:17:06',	'2024-02-13 09:17:06',	NULL),
(858,	1,	102,	'DSC06947-80eebf0e-a394-4cb3-9ce3-97e909b9f7d3',	'/DSC06947-80eebf0e-a394-4cb3-9ce3-97e909b9f7d3.jpg',	'1801941',	6000,	4000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:17:07',	'2024-02-13 09:17:07',	NULL),
(859,	1,	102,	'DSC06863-cf0392fa-1009-40e8-8d15-1a207406c93f',	'/DSC06863-cf0392fa-1009-40e8-8d15-1a207406c93f.jpg',	'1845696',	6000,	4000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:17:07',	'2024-02-13 09:17:07',	NULL),
(860,	1,	102,	'DSC06933-db210e26-eea2-49db-bd66-a95a4b30b481',	'/DSC06933-db210e26-eea2-49db-bd66-a95a4b30b481.jpg',	'1979582',	6000,	4000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:17:07',	'2024-02-13 09:17:07',	NULL),
(861,	1,	102,	'DSC06913-23cfc6c2-476e-4078-86fd-8e51e0836627',	'/DSC06913-23cfc6c2-476e-4078-86fd-8e51e0836627.jpg',	'2242290',	6000,	4000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:17:08',	'2024-02-13 09:17:08',	NULL),
(862,	1,	102,	'DSC06926-8eece1e4-4eee-4b01-916f-ef6e744142bc',	'/DSC06926-8eece1e4-4eee-4b01-916f-ef6e744142bc.jpg',	'2334639',	6000,	4000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:17:09',	'2024-02-13 09:17:09',	NULL),
(863,	1,	102,	'DSC06898-2b3c3dff-d9be-4d55-84d9-0f7e5474fa22',	'/DSC06898-2b3c3dff-d9be-4d55-84d9-0f7e5474fa22.jpg',	'2552318',	6000,	4000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:17:09',	'2024-02-13 09:17:09',	NULL),
(864,	1,	102,	'DSC06931-899d5cd2-177f-4655-a01c-3fe059585ea0',	'/DSC06931-899d5cd2-177f-4655-a01c-3fe059585ea0.jpg',	'3636026',	6000,	4000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:17:12',	'2024-02-13 09:17:12',	NULL),
(865,	1,	102,	'Untitled-1-01-8a0b89d3-ecb2-412e-a3c0-14316f78e119',	'/Untitled-1-01-8a0b89d3-ecb2-412e-a3c0-14316f78e119.jpg',	'16725645',	7501,	5001,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:17:27',	'2024-02-13 09:17:27',	NULL),
(866,	1,	102,	'Untitled-1-02-02141fc5-7cdb-409b-9cb2-5153d4751545',	'/Untitled-1-02-02141fc5-7cdb-409b-9cb2-5153d4751545.jpg',	'16725645',	7501,	5001,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:17:28',	'2024-02-13 09:17:28',	NULL),
(867,	1,	102,	'Untitled-1-01-49e751b8-5907-413b-8c06-6170fa5e557e',	'/Untitled-1-01-49e751b8-5907-413b-8c06-6170fa5e557e.jpg',	'4810878',	4175,	2783,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:21:16',	'2024-02-13 09:21:16',	NULL),
(868,	1,	102,	'Untitled-1-04-92e64bcc-212f-4699-870f-078e5ea6bdc2',	'/Untitled-1-04-92e64bcc-212f-4699-870f-078e5ea6bdc2.jpg',	'6272480',	4175,	2784,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:21:24',	'2024-02-13 09:21:24',	NULL),
(869,	1,	102,	'Untitled-1-08-50d2766b-fdb5-41c2-83d8-5c102a83350d',	'/Untitled-1-08-50d2766b-fdb5-41c2-83d8-5c102a83350d.jpg',	'6351334',	4175,	2784,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:21:24',	'2024-02-13 09:21:24',	NULL),
(870,	1,	102,	'Untitled-1-02-b4350a15-8cb0-4eff-bbe9-4e473dbd18ce',	'/Untitled-1-02-b4350a15-8cb0-4eff-bbe9-4e473dbd18ce.jpg',	'6373554',	4175,	2783,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:21:25',	'2024-02-13 09:21:25',	NULL),
(871,	1,	102,	'Untitled-1-06-292d32e4-36d3-4932-a59f-42486f2df542',	'/Untitled-1-06-292d32e4-36d3-4932-a59f-42486f2df542.jpg',	'6451632',	4175,	2784,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:21:25',	'2024-02-13 09:21:25',	NULL),
(872,	1,	102,	'Untitled-1-07-f9013c48-6334-4780-997f-87cab194f9d6',	'/Untitled-1-07-f9013c48-6334-4780-997f-87cab194f9d6.jpg',	'6504624',	4175,	2784,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:21:25',	'2024-02-13 09:21:25',	NULL),
(873,	1,	102,	'Untitled-1-03-386f3eeb-9848-4ac8-b184-cab80a16100e',	'/Untitled-1-03-386f3eeb-9848-4ac8-b184-cab80a16100e.jpg',	'6598425',	4175,	2783,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:21:25',	'2024-02-13 09:21:25',	NULL),
(874,	1,	102,	'Untitled-1-05-d62d6f0d-666e-4b60-af50-b978c704b2cd',	'/Untitled-1-05-d62d6f0d-666e-4b60-af50-b978c704b2cd.jpg',	'6683715',	4175,	2784,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:21:25',	'2024-02-13 09:21:25',	NULL),
(875,	1,	6,	'DSC04311-bd75e58c-d43e-401e-b7bb-0f70a9a3260d',	'/DSC04311-bd75e58c-d43e-401e-b7bb-0f70a9a3260d.jpg',	'13215373',	6000,	4000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:28:44',	'2024-02-13 09:28:44',	NULL),
(876,	1,	6,	'Untitled-1-02-f93ba186-2cef-4ce2-8bca-acfec42745eb',	'/Untitled-1-02-f93ba186-2cef-4ce2-8bca-acfec42745eb.jpg',	'11732566',	4500,	4500,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:35:07',	'2024-02-13 09:35:07',	NULL),
(877,	1,	6,	'Untitled-1-04-10af5430-2aff-47cb-99bd-4473b2b1a176',	'/Untitled-1-04-10af5430-2aff-47cb-99bd-4473b2b1a176.jpg',	'5438519',	3646,	4136,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:41:05',	'2024-02-13 09:41:05',	NULL),
(878,	1,	6,	'IMG_9770-0e79efbd-257d-4616-ab32-c27c5e3ce936',	'/IMG_9770-0e79efbd-257d-4616-ab32-c27c5e3ce936.jpg',	'223258',	1242,	1239,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:41:49',	'2024-02-13 09:41:49',	NULL),
(879,	1,	6,	'Untitled-1-02-a61bc188-1eb9-4c67-8607-fc4962be37fb',	'/Untitled-1-02-a61bc188-1eb9-4c67-8607-fc4962be37fb.jpg',	'176769',	2208,	525,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:42:04',	'2024-02-13 09:42:04',	NULL),
(880,	1,	105,	'Cover-55130c96-e615-46bd-aee4-2b61ec86fe63',	'/Cover-55130c96-e615-46bd-aee4-2b61ec86fe63.jpg',	'267488',	1280,	1280,	'jpg',	0,	1,	0,	0,	0,	'2024-02-13 09:48:16',	'2024-02-13 09:48:16',	NULL),
(881,	1,	NULL,	'DSC06114-78d6119f-a88c-4f0d-9c4f-5a94c0f5669f',	'/DSC06114-78d6119f-a88c-4f0d-9c4f-5a94c0f5669f.jpg',	'15082273',	6000,	4000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-14 09:50:33',	'2024-02-14 09:50:33',	NULL),
(882,	1,	NULL,	'DSC06114-623f227c-1492-4912-a424-61704c85a856',	'/DSC06114-623f227c-1492-4912-a424-61704c85a856.jpg',	'15082273',	6000,	4000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-14 09:51:38',	'2024-02-14 09:51:38',	NULL),
(883,	1,	103,	'DSC06175-4f528e94-9c1a-421e-a1c2-7f431e737a06',	'/DSC06175-4f528e94-9c1a-421e-a1c2-7f431e737a06.jpg',	'15780101',	6000,	4000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-14 09:53:22',	'2024-02-14 09:53:22',	NULL),
(884,	1,	NULL,	'Final-01-06f98ccc-98bc-4b53-b323-2fc305132ee3',	'/Final-01-06f98ccc-98bc-4b53-b323-2fc305132ee3.jpg',	'4890552',	4500,	4500,	'jpg',	0,	1,	0,	0,	0,	'2024-02-14 09:54:03',	'2024-02-14 09:54:03',	NULL),
(885,	1,	103,	'DSC06102-c174e6a9-1384-4d8f-8187-e678e40aba04',	'/DSC06102-c174e6a9-1384-4d8f-8187-e678e40aba04.jpg',	'14121847',	6000,	4000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-14 09:55:05',	'2024-02-14 09:55:05',	NULL),
(886,	1,	10,	'DSC05021-48a01729-590b-42d3-afa0-f46eb8e203df',	'/DSC05021-48a01729-590b-42d3-afa0-f46eb8e203df.jpg',	'15418729',	6000,	4000,	'jpg',	0,	1,	0,	0,	0,	'2024-02-14 09:57:18',	'2024-02-14 09:57:18',	NULL),
(887,	1,	6,	'King & Queen Salon-84af1cbb-5591-42a9-b7f7-be51c2f12cf6',	'/King & Queen Salon-84af1cbb-5591-42a9-b7f7-be51c2f12cf6.jpg',	'45430',	408,	306,	'jpg',	0,	1,	0,	0,	0,	'2024-02-14 13:35:40',	'2024-02-14 13:35:40',	NULL),
(888,	1,	6,	'Puy Salon 63-b4b2dfc5-6579-4ab4-be99-242d06a4934f',	'/Puy Salon 63-b4b2dfc5-6579-4ab4-be99-242d06a4934f.jpg',	'47637',	408,	306,	'jpg',	0,	1,	0,	0,	0,	'2024-02-14 13:44:13',	'2024-02-14 13:44:13',	NULL),
(889,	1,	6,	'Hair lounge-305dba5c-d665-4623-8dc6-10a73ac32603',	'/Hair lounge-305dba5c-d665-4623-8dc6-10a73ac32603.png',	'176415',	394,	286,	'png',	0,	1,	0,	0,	0,	'2024-02-14 13:58:55',	'2024-02-14 13:58:55',	NULL),
(890,	1,	6,	'The nail room-82a65c47-8757-4542-a3d0-bcddc7a1e09c',	'/The nail room-82a65c47-8757-4542-a3d0-bcddc7a1e09c.png',	'201238',	391,	271,	'png',	0,	1,	0,	0,	0,	'2024-02-14 14:03:27',	'2024-02-14 14:03:27',	NULL),
(891,	1,	6,	'ADORE-3c9bdbb9-a1d8-433b-9365-47886e84134b',	'/ADORE-3c9bdbb9-a1d8-433b-9365-47886e84134b.jpg',	'40946',	1616,	1061,	'jpg',	0,	1,	0,	0,	0,	'2024-02-14 14:13:28',	'2024-02-14 14:13:28',	NULL),
(892,	1,	6,	'B1 salon-8dbc2356-2bc8-44b8-b05c-36d6281263ce',	'/B1 salon-8dbc2356-2bc8-44b8-b05c-36d6281263ce.png',	'57088',	802,	541,	'png',	0,	1,	0,	0,	0,	'2024-02-14 14:16:45',	'2024-02-14 14:16:45',	NULL),
(893,	1,	6,	'Cindy ll-78f214cc-bec8-481a-b2e2-4b8356e0f59f',	'/Cindy ll-78f214cc-bec8-481a-b2e2-4b8356e0f59f.png',	'199007',	386,	257,	'png',	0,	1,	0,	0,	0,	'2024-02-14 14:18:01',	'2024-02-14 14:18:01',	NULL),
(894,	1,	6,	'Leekaja-76e21717-42d6-47ab-82f4-1ce563096782',	'/Leekaja-76e21717-42d6-47ab-82f4-1ce563096782.jpg',	'45310',	408,	306,	'jpg',	0,	1,	0,	0,	0,	'2024-02-14 14:22:10',	'2024-02-14 14:22:10',	NULL),
(895,	1,	6,	'P salon-08b7126d-1674-4de7-85ca-5f89d006fe57',	'/P salon-08b7126d-1674-4de7-85ca-5f89d006fe57.png',	'205579',	341,	281,	'png',	0,	1,	0,	0,	0,	'2024-02-14 14:25:02',	'2024-02-14 14:25:02',	NULL),
(896,	1,	6,	'NEAK Salon-bb739a8d-5a45-4536-b38c-fd5086cdc3c7',	'/NEAK Salon-bb739a8d-5a45-4536-b38c-fd5086cdc3c7.jpg',	'75954',	408,	544,	'jpg',	0,	1,	0,	0,	0,	'2024-02-14 14:27:55',	'2024-02-14 14:27:55',	NULL),
(897,	1,	6,	'Little Brow & Salons-99765d3a-7690-4a5c-9ce9-f9c014184a9d',	'/Little Brow & Salons-99765d3a-7690-4a5c-9ce9-f9c014184a9d.jfif',	'30048',	408,	240,	'jfif',	0,	0,	0,	0,	0,	'2024-02-14 14:33:14',	'2024-02-14 14:33:14',	NULL),
(898,	1,	6,	'IMG_9774-99077ba8-5c39-44b7-bf50-b8259db69466',	'/IMG_9774-99077ba8-5c39-44b7-bf50-b8259db69466.jpg',	'297984',	969,	1313,	'jpg',	0,	1,	0,	0,	0,	'2024-02-15 08:16:51',	'2024-02-15 08:16:51',	NULL),
(899,	1,	6,	'Untitled-1-04-acfd661e-43ac-4e3b-83b7-bc9351b221c3',	'/Untitled-1-04-acfd661e-43ac-4e3b-83b7-bc9351b221c3.jpg',	'5438519',	3646,	4136,	'jpg',	0,	1,	0,	0,	0,	'2024-02-15 08:17:06',	'2024-02-15 08:17:06',	NULL),
(900,	1,	6,	'ASK-Neak -01-7cd3a121-cb64-429c-b53d-0466cb703055',	'/ASK-Neak -01-7cd3a121-cb64-429c-b53d-0466cb703055.jpg',	'4268342',	4500,	4500,	'jpg',	0,	1,	0,	0,	0,	'2024-02-15 08:27:22',	'2024-02-15 08:27:22',	NULL),
(901,	1,	105,	'IMG_1916-b2f5ddd9-6c42-4bb5-9610-f4f33034010a',	'/IMG_1916-b2f5ddd9-6c42-4bb5-9610-f4f33034010a.png',	'15612310',	4000,	6000,	'png',	0,	1,	0,	0,	0,	'2024-02-15 11:14:00',	'2024-02-15 11:14:00',	NULL),
(902,	1,	105,	'IMG_1916-23005709-5f80-4d3e-8a82-41ed404b4686',	'/IMG_1916-23005709-5f80-4d3e-8a82-41ed404b4686.png',	'8535401',	3645,	3645,	'png',	0,	1,	0,	0,	0,	'2024-02-15 11:16:31',	'2024-02-15 11:16:31',	NULL),
(903,	1,	6,	'Lavender Salon-f3241bcd-1ab1-431d-9d20-4f49ec99494e',	'/Lavender Salon-f3241bcd-1ab1-431d-9d20-4f49ec99494e.jpg',	'62506',	408,	544,	'jpg',	0,	1,	0,	0,	0,	'2024-02-16 09:21:05',	'2024-02-16 09:21:05',	NULL),
(904,	1,	6,	'M-C Salon By MICKEY-fc6eb68e-92a7-491a-b3e7-b57acc21c179',	'/M-C Salon By MICKEY-fc6eb68e-92a7-491a-b3e7-b57acc21c179.JPG',	'26042',	410,	202,	'JPG',	0,	0,	0,	0,	0,	'2024-02-16 09:26:37',	'2024-02-16 09:26:37',	NULL),
(905,	1,	6,	'B2 Salon-2859bde9-9770-404c-aea5-3faa6ea60580',	'/B2 Salon-2859bde9-9770-404c-aea5-3faa6ea60580.JPG',	'73483',	706,	511,	'JPG',	0,	0,	0,	0,	0,	'2024-02-16 09:30:52',	'2024-02-16 09:30:52',	NULL),
(906,	1,	6,	'T Massage & Beauty Salon-a947bfaf-075c-41f1-b242-fbd95efd020b',	'/T Massage & Beauty Salon-a947bfaf-075c-41f1-b242-fbd95efd020b.jpg',	'79157',	408,	544,	'jpg',	0,	1,	0,	0,	0,	'2024-02-16 09:34:03',	'2024-02-16 09:34:03',	NULL),
(907,	1,	106,	'Home Salon-bb711e91-9160-49f4-a117-050c676a2c08',	'/Home Salon-bb711e91-9160-49f4-a117-050c676a2c08.JPG',	'21899',	493,	323,	'JPG',	0,	0,	0,	0,	0,	'2024-02-16 09:38:13',	'2024-02-16 09:38:13',	NULL),
(908,	1,	106,	'Naden salon-dc29b4ff-bb7e-411c-89ea-ce6ad23df217',	'/Naden salon-dc29b4ff-bb7e-411c-89ea-ce6ad23df217.JPG',	'71164',	485,	587,	'JPG',	0,	0,	0,	0,	0,	'2024-02-16 09:42:45',	'2024-02-16 09:42:45',	NULL),
(909,	1,	106,	'V Famous-d7056f48-2072-4361-8cf6-ba091b97b641',	'/V Famous-d7056f48-2072-4361-8cf6-ba091b97b641.png',	'141113',	408,	408,	'png',	0,	1,	0,	0,	0,	'2024-02-16 09:50:13',	'2024-02-16 09:50:13',	NULL),
(910,	1,	106,	'Leekaja Savana-3e01246c-2e08-43ba-8dce-1fe957002d9f',	'/Leekaja Savana-3e01246c-2e08-43ba-8dce-1fe957002d9f.jpg',	'36274',	408,	240,	'jpg',	0,	1,	0,	0,	0,	'2024-02-16 09:52:43',	'2024-02-16 09:52:43',	NULL),
(911,	1,	106,	'Nature Salon and Brows-c3bb225b-f11d-4ae1-a2ac-f2a5093a376f',	'/Nature Salon and Brows-c3bb225b-f11d-4ae1-a2ac-f2a5093a376f.png',	'209882',	391,	252,	'png',	0,	1,	0,	0,	0,	'2024-02-16 09:55:51',	'2024-02-16 09:55:51',	NULL),
(912,	1,	106,	'M salon and spa-70eb8a77-2b62-413c-a567-ca95b09652d2',	'/M salon and spa-70eb8a77-2b62-413c-a567-ca95b09652d2.png',	'710326',	773,	563,	'png',	0,	1,	0,	0,	0,	'2024-02-16 10:02:52',	'2024-02-16 10:02:52',	NULL);

DROP TABLE IF EXISTS `folders`;
CREATE TABLE `folders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `name` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `is_hidden` int(11) NOT NULL DEFAULT 0,
  `color_code` varchar(125) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Example: #ffffff',
  `shortcut` int(11) DEFAULT NULL COMMENT 'id of redirect folder',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `folders_id_unique` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `folders` (`id`, `user_id`, `name`, `parent_id`, `is_hidden`, `color_code`, `shortcut`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1,	1,	'Student',	NULL,	0,	NULL,	NULL,	'2023-01-22 13:51:54',	'2023-01-22 13:51:54',	NULL),
(2,	1,	'Staff',	NULL,	0,	NULL,	NULL,	'2023-01-23 19:24:40',	'2023-01-23 19:24:40',	NULL),
(3,	1,	'Lessons',	NULL,	0,	NULL,	NULL,	'2023-01-24 19:49:11',	'2023-01-24 19:49:11',	NULL),
(4,	1,	'Teacher Photo',	NULL,	0,	NULL,	NULL,	'2023-02-02 14:05:05',	'2023-02-02 14:05:05',	NULL),
(5,	1,	'Cut',	NULL,	0,	NULL,	NULL,	'2023-04-04 14:33:19',	'2023-04-04 14:33:46',	'2023-04-04 14:33:46'),
(6,	1,	'Cover',	NULL,	0,	NULL,	NULL,	'2023-04-27 22:44:31',	'2023-04-27 22:44:31',	NULL),
(7,	1,	'SlideShow',	NULL,	0,	NULL,	NULL,	'2023-04-27 22:50:11',	'2023-04-27 22:50:11',	NULL),
(8,	1,	'User',	NULL,	0,	NULL,	NULL,	'2023-05-04 14:34:10',	'2023-05-04 14:34:10',	NULL),
(10,	1,	'test',	NULL,	0,	NULL,	NULL,	'2023-10-25 16:19:10',	'2023-10-25 16:19:10',	NULL),
(11,	8,	'Module',	NULL,	0,	NULL,	NULL,	'2023-10-27 08:46:58',	'2023-11-13 16:48:53',	'2023-11-13 16:48:53'),
(12,	8,	'ល.ស២',	11,	0,	NULL,	NULL,	'2023-10-27 09:14:38',	'2023-10-27 09:14:38',	NULL),
(13,	8,	'ល.ស៣',	11,	0,	NULL,	NULL,	'2023-10-27 16:45:00',	'2023-10-27 16:45:00',	NULL),
(14,	8,	'Module2',	NULL,	0,	NULL,	NULL,	'2023-10-27 16:47:36',	'2023-11-13 16:48:49',	'2023-11-13 16:48:49'),
(15,	8,	'ល.ស១',	14,	0,	NULL,	NULL,	'2023-10-27 16:47:51',	'2023-10-27 16:47:51',	NULL),
(16,	8,	'ល.ស២',	14,	0,	NULL,	NULL,	'2023-10-27 16:49:58',	'2023-10-27 16:49:58',	NULL),
(17,	8,	'ល.ស៣',	14,	0,	NULL,	NULL,	'2023-10-27 16:51:44',	'2023-10-27 16:51:44',	NULL),
(18,	8,	'Module3',	NULL,	0,	NULL,	NULL,	'2023-10-27 16:54:07',	'2023-11-13 16:48:46',	'2023-11-13 16:48:46'),
(19,	8,	'ល.ស១',	18,	0,	NULL,	NULL,	'2023-10-27 16:54:18',	'2023-10-27 16:54:18',	NULL),
(20,	8,	'ល.ស២',	18,	0,	NULL,	NULL,	'2023-10-27 16:55:37',	'2023-10-27 16:55:37',	NULL),
(21,	8,	'ល.ស៣',	18,	0,	NULL,	NULL,	'2023-10-28 14:05:04',	'2023-10-28 14:05:04',	NULL),
(22,	8,	'Module4',	NULL,	0,	NULL,	NULL,	'2023-10-28 14:23:38',	'2023-11-13 16:48:43',	'2023-11-13 16:48:43'),
(23,	8,	'ល.ស២',	22,	0,	NULL,	NULL,	'2023-10-28 14:23:52',	'2023-10-28 14:27:10',	NULL),
(24,	8,	'ល,ស១',	22,	0,	NULL,	NULL,	'2023-10-28 14:24:09',	'2023-10-28 14:26:35',	NULL),
(25,	8,	'ល.ស៣',	22,	0,	NULL,	NULL,	'2023-10-28 14:41:09',	'2023-10-28 14:41:09',	NULL),
(26,	8,	'Module5',	NULL,	0,	NULL,	NULL,	'2023-10-30 09:49:07',	'2023-11-13 16:48:40',	'2023-11-13 16:48:40'),
(27,	8,	'ល.ស១',	26,	0,	NULL,	NULL,	'2023-10-30 09:49:27',	'2023-10-30 09:49:27',	NULL),
(28,	8,	'ល.ស២',	26,	0,	NULL,	NULL,	'2023-10-30 09:49:41',	'2023-10-30 09:49:41',	NULL),
(29,	8,	'ល.ស៣',	26,	0,	NULL,	NULL,	'2023-10-30 09:50:55',	'2023-10-30 09:50:55',	NULL),
(30,	8,	'ល.ស៤',	26,	0,	NULL,	NULL,	'2023-10-30 10:10:21',	'2023-10-30 10:10:21',	NULL),
(31,	8,	'Module6',	NULL,	0,	NULL,	NULL,	'2023-10-30 10:35:42',	'2023-11-13 16:48:36',	'2023-11-13 16:48:36'),
(32,	8,	'ល.ស១',	31,	0,	NULL,	NULL,	'2023-10-30 10:36:00',	'2023-10-30 10:36:00',	NULL),
(33,	8,	'ល.ស២',	31,	0,	NULL,	NULL,	'2023-10-30 10:36:07',	'2023-10-30 10:36:07',	NULL),
(34,	8,	'ល.ស៣',	31,	0,	NULL,	NULL,	'2023-10-30 10:36:16',	'2023-10-30 10:36:16',	NULL),
(35,	8,	'Module Beauty',	NULL,	0,	NULL,	NULL,	'2023-11-14 14:11:50',	'2023-11-14 14:11:50',	NULL),
(36,	8,	'Module Hair Cut',	NULL,	0,	NULL,	NULL,	'2023-11-14 14:17:33',	'2023-11-14 14:17:33',	NULL),
(37,	8,	'Module 1',	36,	0,	NULL,	NULL,	'2023-11-14 14:17:48',	'2023-11-14 14:17:48',	NULL),
(38,	8,	'Module 2',	36,	0,	NULL,	NULL,	'2023-11-14 14:18:00',	'2023-11-14 14:18:00',	NULL),
(39,	8,	'Module 3',	36,	0,	NULL,	NULL,	'2023-11-14 14:18:14',	'2023-11-14 14:18:14',	NULL),
(40,	8,	'Module 4',	36,	0,	NULL,	NULL,	'2023-11-14 14:18:31',	'2023-11-14 14:18:31',	NULL),
(41,	8,	'Module 5',	36,	0,	NULL,	NULL,	'2023-11-14 15:57:32',	'2023-11-14 15:57:32',	NULL),
(42,	8,	'ល.ស1',	37,	0,	NULL,	NULL,	'2023-11-14 16:00:47',	'2023-11-14 16:05:15',	'2023-11-14 16:05:15'),
(43,	8,	'ល.ស១',	35,	0,	NULL,	NULL,	'2023-11-14 16:05:33',	'2023-11-15 09:33:42',	'2023-11-15 09:33:42'),
(44,	8,	'ល.ស២',	35,	0,	NULL,	NULL,	'2023-11-14 16:05:52',	'2023-11-15 09:33:39',	'2023-11-15 09:33:39'),
(45,	8,	'ល.ស៣',	35,	0,	NULL,	NULL,	'2023-11-14 16:06:06',	'2023-11-15 09:33:36',	'2023-11-15 09:33:36'),
(46,	8,	'Module2',	35,	0,	NULL,	NULL,	'2023-11-15 09:33:10',	'2023-11-16 09:17:11',	NULL),
(47,	8,	'Module 2',	35,	0,	NULL,	NULL,	'2023-11-15 09:33:57',	'2023-11-16 09:16:58',	'2023-11-16 09:16:58'),
(48,	8,	'Module 3',	35,	0,	NULL,	NULL,	'2023-11-15 09:34:17',	'2023-11-15 09:34:17',	NULL),
(49,	8,	'Module 4',	35,	0,	NULL,	NULL,	'2023-11-15 09:34:28',	'2023-11-15 09:34:28',	NULL),
(50,	8,	'ល.ស១',	46,	0,	NULL,	NULL,	'2023-11-15 09:34:41',	'2023-11-15 09:39:24',	NULL),
(51,	8,	'ល.ស២',	46,	0,	NULL,	NULL,	'2023-11-15 09:34:53',	'2023-11-15 09:39:35',	NULL),
(52,	8,	'ល.ស៣',	46,	0,	NULL,	NULL,	'2023-11-15 09:35:33',	'2023-11-15 09:43:45',	NULL),
(53,	8,	'ល.ស១',	47,	0,	NULL,	NULL,	'2023-11-15 09:48:18',	'2023-11-15 09:48:18',	NULL),
(54,	8,	'ល.ស២',	47,	0,	NULL,	NULL,	'2023-11-15 09:48:28',	'2023-11-15 09:48:28',	NULL),
(55,	8,	'ល.ស៣',	47,	0,	NULL,	NULL,	'2023-11-15 09:48:39',	'2023-11-15 09:48:39',	NULL),
(56,	8,	'ល.ស១',	54,	0,	NULL,	NULL,	'2023-11-15 10:16:16',	'2023-11-15 10:20:01',	'2023-11-15 10:20:01'),
(57,	8,	'ល.ស២',	54,	0,	NULL,	NULL,	'2023-11-15 10:16:27',	'2023-11-15 10:19:38',	'2023-11-15 10:19:38'),
(58,	8,	'ល.ស៣',	54,	0,	NULL,	NULL,	'2023-11-15 10:16:48',	'2023-11-15 10:19:41',	'2023-11-15 10:19:41'),
(59,	8,	'ល.ស១',	48,	0,	NULL,	NULL,	'2023-11-16 09:14:05',	'2023-11-16 09:14:05',	NULL),
(60,	8,	'ល.ស២',	48,	0,	NULL,	NULL,	'2023-11-16 09:14:19',	'2023-11-16 09:14:19',	NULL),
(61,	8,	'ល.ស៣',	48,	0,	NULL,	NULL,	'2023-11-16 09:14:30',	'2023-11-16 09:14:30',	NULL),
(62,	8,	'Module5',	59,	0,	NULL,	NULL,	'2023-11-16 09:18:05',	'2023-11-16 09:18:23',	'2023-11-16 09:18:23'),
(63,	8,	'Module 5',	59,	0,	NULL,	NULL,	'2023-11-16 09:18:37',	'2023-11-16 09:18:41',	'2023-11-16 09:18:41'),
(64,	8,	'Module 5',	35,	0,	NULL,	NULL,	'2023-11-16 09:18:58',	'2023-11-16 09:18:58',	NULL),
(65,	8,	'Module 6',	35,	0,	NULL,	NULL,	'2023-11-16 09:19:09',	'2023-11-16 09:19:09',	NULL),
(66,	8,	'ល.ស​ ១',	49,	0,	NULL,	NULL,	'2023-11-16 09:37:54',	'2023-11-16 09:37:54',	NULL),
(67,	8,	'ល.ស ២',	49,	0,	NULL,	NULL,	'2023-11-16 09:38:05',	'2023-11-16 09:38:05',	NULL),
(68,	8,	'ល.ស ៣',	49,	0,	NULL,	NULL,	'2023-11-16 09:44:17',	'2023-11-16 09:44:17',	NULL),
(69,	8,	'ល.ស ១',	64,	0,	NULL,	NULL,	'2023-11-16 10:33:24',	'2023-11-16 10:33:24',	NULL),
(70,	8,	'ល.ស ២',	64,	0,	NULL,	NULL,	'2023-11-16 10:33:41',	'2023-11-16 10:33:41',	NULL),
(71,	8,	'ល.ស ៣',	64,	0,	NULL,	NULL,	'2023-11-16 10:33:54',	'2023-11-16 10:33:54',	NULL),
(72,	8,	'ល.ស ១',	65,	0,	NULL,	NULL,	'2023-11-16 15:19:29',	'2023-11-16 15:19:29',	NULL),
(73,	8,	'ល.ស ២',	65,	0,	NULL,	NULL,	'2023-11-16 15:19:44',	'2023-11-16 15:19:44',	NULL),
(74,	8,	'ល.ស ៣',	65,	0,	NULL,	NULL,	'2023-11-16 15:20:11',	'2023-11-16 15:20:11',	NULL),
(75,	8,	'ល.ស​ ១',	37,	0,	NULL,	NULL,	'2023-11-16 15:45:57',	'2023-11-16 15:45:57',	NULL),
(76,	8,	'ល.ស ២',	37,	0,	NULL,	NULL,	'2023-11-16 15:46:25',	'2023-11-16 15:46:25',	NULL),
(77,	8,	'ល.ស ៣',	37,	0,	NULL,	NULL,	'2023-11-16 15:46:38',	'2023-11-16 15:46:38',	NULL),
(78,	8,	'ល.ស ១',	38,	0,	NULL,	NULL,	'2023-11-16 16:07:08',	'2023-11-16 16:07:08',	NULL),
(79,	8,	'ល.ស ២',	38,	0,	NULL,	NULL,	'2023-11-16 16:07:17',	'2023-11-16 16:07:17',	NULL),
(80,	8,	'ល.ស ៣',	38,	0,	NULL,	NULL,	'2023-11-16 16:07:27',	'2023-11-16 16:07:27',	NULL),
(81,	8,	'ល.ស ១',	39,	0,	NULL,	NULL,	'2023-11-16 16:11:46',	'2023-11-16 16:11:46',	NULL),
(82,	8,	'ល.ស ២',	39,	0,	NULL,	NULL,	'2023-11-16 16:11:56',	'2023-11-16 16:11:56',	NULL),
(83,	8,	'ល.ស ៣',	39,	0,	NULL,	NULL,	'2023-11-16 16:12:05',	'2023-11-16 16:12:05',	NULL),
(84,	8,	'ល.ស ១',	40,	0,	NULL,	NULL,	'2023-11-16 16:23:18',	'2023-11-16 16:23:18',	NULL),
(85,	8,	'ល.ស ២',	40,	0,	NULL,	NULL,	'2023-11-16 16:23:27',	'2023-11-16 16:23:27',	NULL),
(86,	8,	'ល.ស ៣',	40,	0,	NULL,	NULL,	'2023-11-16 16:23:49',	'2023-11-16 16:23:49',	NULL),
(87,	8,	'Photo',	NULL,	0,	NULL,	NULL,	'2023-11-16 16:27:34',	'2023-11-16 16:28:27',	'2023-11-16 16:28:27'),
(88,	8,	'ល.ស ១',	41,	0,	NULL,	NULL,	'2023-11-17 09:30:01',	'2023-11-17 09:30:01',	NULL),
(89,	8,	'ល.ស ២',	41,	0,	NULL,	NULL,	'2023-11-17 09:30:09',	'2023-11-17 09:30:09',	NULL),
(90,	8,	'ល.ស ៣',	41,	0,	NULL,	NULL,	'2023-11-17 09:30:15',	'2023-11-17 09:30:15',	NULL),
(91,	8,	'ល.ស​ ៤',	41,	0,	NULL,	NULL,	'2023-11-17 10:47:30',	'2023-11-17 10:47:30',	NULL),
(92,	8,	'Module 6',	91,	0,	NULL,	NULL,	'2023-11-17 11:00:39',	'2023-11-17 11:00:52',	'2023-11-17 11:00:52'),
(93,	8,	'Module 6',	36,	0,	NULL,	NULL,	'2023-11-17 11:01:11',	'2023-11-17 11:01:11',	NULL),
(94,	8,	'Module 7',	36,	0,	NULL,	NULL,	'2023-11-17 11:01:19',	'2023-11-17 11:01:19',	NULL),
(95,	8,	'ល.ស ១',	93,	0,	NULL,	NULL,	'2023-11-17 11:01:47',	'2023-11-17 11:01:47',	NULL),
(96,	8,	'ល.ស ២',	93,	0,	NULL,	NULL,	'2023-11-17 11:01:54',	'2023-11-17 11:01:54',	NULL),
(97,	8,	'ល.ស ៣',	93,	0,	NULL,	NULL,	'2023-11-17 11:02:05',	'2023-11-17 11:16:57',	NULL),
(98,	8,	'ល.ស ៤',	93,	0,	NULL,	NULL,	'2023-11-17 11:17:03',	'2023-11-17 11:17:03',	NULL),
(99,	8,	'ល.ស ១',	94,	0,	NULL,	NULL,	'2023-11-20 10:42:32',	'2023-11-20 10:42:32',	NULL),
(100,	8,	'ល.ស ២',	94,	0,	NULL,	NULL,	'2023-11-20 10:42:39',	'2023-11-20 10:42:39',	NULL),
(101,	8,	'ល.ស ៣',	94,	0,	NULL,	NULL,	'2023-11-20 10:42:52',	'2023-11-20 10:42:52',	NULL),
(102,	1,	'HairStyle',	NULL,	0,	NULL,	NULL,	'2024-02-13 09:16:35',	'2024-02-13 09:16:35',	NULL),
(103,	1,	'Ask 2023',	NULL,	0,	NULL,	NULL,	'2024-02-13 09:30:05',	'2024-02-13 09:30:05',	NULL),
(104,	1,	'Final Vdo',	103,	0,	NULL,	NULL,	'2024-02-13 09:30:19',	'2024-02-13 09:30:19',	NULL),
(105,	1,	'Course',	NULL,	0,	NULL,	NULL,	'2024-02-13 09:44:45',	'2024-02-13 09:44:45',	NULL),
(106,	1,	'Salon Partner',	6,	0,	NULL,	NULL,	'2024-02-16 09:34:33',	'2024-02-16 09:34:33',	NULL);

DROP TABLE IF EXISTS `galleries`;
CREATE TABLE `galleries` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) NOT NULL,
  `album_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `galleries` (`id`, `name`, `image`, `description`, `status`, `album_id`, `created_at`, `updated_at`) VALUES
(1,	'Result of scholarship course (Hair color)',	'/57yk51632194817787Result-183df3d7-fcbe-403d-a957-320d3ac1d99f.png',	NULL,	1,	1,	'2023-04-25 07:50:30',	'2023-04-25 07:50:30'),
(2,	'Result of scholarship course (Hair color)',	'/jeyw61632191396568Result-395983b6-adce-4d10-84af-72f9f28c8a51.png',	NULL,	1,	1,	'2023-04-25 07:50:48',	'2023-04-25 07:50:56'),
(3,	'Result of scholarship course ( Barber)',	'/s46zup163714055036518-6c9ac31e-f16b-4781-9d0c-0f7c291ffd70.png',	NULL,	1,	1,	'2023-04-27 03:00:36',	'2023-04-27 03:00:36'),
(4,	'Result of scholarship course ( Barber)',	'/d1bsfe163703180519811-5f6788e7-4903-4b9f-9825-fe7c05480368.png',	NULL,	1,	1,	'2023-04-27 03:00:57',	'2023-04-27 03:00:57'),
(5,	'Result of scholarship course ( Barber)',	'/oz934916370320082939-f99e13b4-9642-4d51-bb03-31cf68a2082d.png',	NULL,	1,	1,	'2023-04-27 03:01:10',	'2023-04-27 03:01:10'),
(6,	'Schwarzkopf Professional IGORA ROYAL',	'/p3-94086f71-3fde-49e3-8cc1-a26e3d568fec.jpg',	NULL,	1,	10,	'2023-04-27 03:03:18',	'2023-04-27 03:03:18'),
(7,	'Schwarzkopf Professional IGORA ROYAL',	'/p2-16b74081-5ef4-4f64-b83e-ae44de1429b7.jpg',	NULL,	1,	10,	'2023-04-27 03:03:31',	'2023-04-27 03:03:31'),
(8,	'Schwarzkopf Professional IGORA ROYAL',	'/p4-2bed1e02-0202-4bc2-8cf9-f40aeac6338c.jpg',	NULL,	1,	10,	'2023-04-27 03:03:47',	'2023-04-27 03:03:47'),
(9,	'Schwarzkopf Professional IGORA ROYAL',	'/p1-bf171996-dcb9-4e01-8686-fd997533f74f.jpg',	NULL,	1,	10,	'2023-04-27 03:04:08',	'2023-04-27 03:04:08'),
(10,	'Excellence Women Cut - Stevens | Feb 2020',	'/h2-96386b69-c987-47a9-99c0-fb3edbeb04ab.jpg',	NULL,	1,	7,	'2023-04-27 03:05:29',	'2023-04-27 03:05:29'),
(11,	'Excellence Women Cut - Stevens | Feb 2020',	'/h1-45c8b28e-0cb2-4b6d-875c-888dda1b4e1c.jpg',	NULL,	1,	7,	'2023-04-27 03:05:43',	'2023-04-27 03:05:43'),
(12,	'Excellence Women Cut - Stevens | Feb 2020',	'/h3-862f1872-a196-41dd-8fe8-5eebe7f50f4c.jpg',	NULL,	1,	7,	'2023-04-27 03:06:00',	'2023-04-27 03:06:00'),
(13,	'Single Brush Painting',	'/tmcfxp1626492199715photo_2021-05-26_15-50-07-21968711-aa70-4b45-af6d-997c38ce95a5.jpg',	NULL,	1,	2,	'2023-04-27 03:11:47',	'2023-04-27 03:12:11'),
(14,	'Result of scholarship course (Hair color)',	'/57yk51632194817787Result-183df3d7-fcbe-403d-a957-320d3ac1d99f.png',	NULL,	1,	1,	'2023-04-25 07:50:30',	'2023-04-25 07:50:30'),
(15,	'Result of scholarship course (Hair color)',	'/jeyw61632191396568Result-395983b6-adce-4d10-84af-72f9f28c8a51.png',	NULL,	1,	1,	'2023-04-25 07:50:48',	'2023-04-25 07:50:56'),
(16,	'Result of scholarship course ( Barber)',	'/s46zup163714055036518-6c9ac31e-f16b-4781-9d0c-0f7c291ffd70.png',	NULL,	1,	1,	'2023-04-27 03:00:36',	'2023-04-27 03:00:36'),
(17,	'Result of scholarship course ( Barber)',	'/d1bsfe163703180519811-5f6788e7-4903-4b9f-9825-fe7c05480368.png',	NULL,	1,	1,	'2023-04-27 03:00:57',	'2023-04-27 03:00:57'),
(18,	'Result of scholarship course ( Barber)',	'/oz934916370320082939-f99e13b4-9642-4d51-bb03-31cf68a2082d.png',	NULL,	1,	1,	'2023-04-27 03:01:10',	'2023-04-27 03:01:10'),
(19,	'Schwarzkopf Professional IGORA ROYAL',	'/p3-94086f71-3fde-49e3-8cc1-a26e3d568fec.jpg',	NULL,	1,	10,	'2023-04-27 03:03:18',	'2023-04-27 03:03:18'),
(20,	'Schwarzkopf Professional IGORA ROYAL',	'/p2-16b74081-5ef4-4f64-b83e-ae44de1429b7.jpg',	NULL,	1,	10,	'2023-04-27 03:03:31',	'2023-04-27 03:03:31'),
(21,	'Schwarzkopf Professional IGORA ROYAL',	'/p4-2bed1e02-0202-4bc2-8cf9-f40aeac6338c.jpg',	NULL,	1,	10,	'2023-04-27 03:03:47',	'2023-04-27 03:03:47'),
(22,	'Schwarzkopf Professional IGORA ROYAL',	'/p1-bf171996-dcb9-4e01-8686-fd997533f74f.jpg',	NULL,	1,	10,	'2023-04-27 03:04:08',	'2023-04-27 03:04:08'),
(23,	'Excellence Women Cut - Stevens | Feb 2020',	'/h2-96386b69-c987-47a9-99c0-fb3edbeb04ab.jpg',	NULL,	1,	7,	'2023-04-27 03:05:29',	'2023-04-27 03:05:29'),
(24,	'Excellence Women Cut - Stevens | Feb 2020',	'/h1-45c8b28e-0cb2-4b6d-875c-888dda1b4e1c.jpg',	NULL,	1,	7,	'2023-04-27 03:05:43',	'2023-04-27 03:05:43'),
(25,	'Excellence Women Cut - Stevens | Feb 2020',	'/h3-862f1872-a196-41dd-8fe8-5eebe7f50f4c.jpg',	NULL,	1,	7,	'2023-04-27 03:06:00',	'2023-04-27 03:06:00'),
(26,	'Single Brush Painting',	'/tmcfxp1626492199715photo_2021-05-26_15-50-07-21968711-aa70-4b45-af6d-997c38ce95a5.jpg',	NULL,	1,	2,	'2023-04-27 03:11:47',	'2023-04-27 03:12:11'),
(27,	'Hair Style Action',	'/Untitled-1-01-8a0b89d3-ecb2-412e-a3c0-14316f78e119.jpg',	NULL,	1,	7,	'2024-02-13 09:17:45',	'2024-02-13 09:17:45'),
(28,	'Processing Of Our trainer showed',	'/DSC06937-55ecdcd4-761b-4f8a-89ea-3597ab57b001.jpg',	'He shows about women hair step by step.',	1,	8,	'2024-02-13 09:20:08',	'2024-02-13 09:20:08'),
(29,	'The Final Result',	'/Untitled-1-03-386f3eeb-9848-4ac8-b184-cab80a16100e.jpg',	NULL,	1,	8,	'2024-02-13 09:22:12',	'2024-02-13 09:22:12'),
(30,	'Result of hair Colored',	'/Untitled-1-08-50d2766b-fdb5-41c2-83d8-5c102a83350d.jpg',	NULL,	1,	8,	'2024-02-13 09:22:58',	'2024-02-13 09:22:58'),
(31,	'Result of hair Colored.',	'/Untitled-1-07-f9013c48-6334-4780-997f-87cab194f9d6.jpg',	NULL,	1,	8,	'2024-02-13 09:23:29',	'2024-02-13 09:23:29');

DROP TABLE IF EXISTS `gallery_albums`;
CREATE TABLE `gallery_albums` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cover` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `album_type` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `gallery_albums` (`id`, `name`, `cover`, `album_type`, `status`, `created_at`, `updated_at`) VALUES
(1,	'Scholarship students practice on Model',	'/jeyw61632191396568Result-67a45838-5330-4757-9fd0-4119546776a2.png',	'Image',	1,	'2023-04-25 07:47:00',	'2023-04-25 07:47:50'),
(2,	'Nail Styling Result',	'/tmcfxp1626492199715photo_2021-05-26_15-50-07-21968711-aa70-4b45-af6d-997c38ce95a5.jpg',	'Image',	1,	'2023-04-25 07:48:50',	'2023-04-25 07:48:50'),
(3,	'INTERVIEW WITH TRAINER',	'/997fqn1626840746727Thunmbnail Video 7-934bf34f-8b1a-474e-9f90-6c2ba6f5d56e.png',	'Video',	1,	'2023-04-25 07:49:31',	'2023-04-25 07:49:31'),
(4,	'OPEN DAY VIDEO',	'/open-bd3d5d8a-b620-4059-a030-1c659d4f25c6.png',	'Video',	1,	'2023-04-27 02:50:42',	'2023-04-27 02:50:42'),
(5,	'FOR NAILDRESSER',	'/nail2-86ab0240-e2f8-4884-b00b-002b9f3881a9.png',	'Video',	1,	'2023-04-27 02:51:07',	'2023-04-27 02:51:12'),
(6,	'FOR HAIRDRESSER',	'/hair1-7e162f25-584c-46c0-b305-40d8342a72b4.png',	'Video',	1,	'2023-04-27 02:52:33',	'2023-04-27 02:52:33'),
(7,	'Hairdressing Training Action',	'/01-b8e64273-f7b7-4780-89ca-c3a2642710a4.jpeg',	'Image',	1,	'2023-04-27 02:54:47',	'2023-04-27 02:54:47'),
(8,	'Hairdressing Result',	'/d9ig571626490656946IMG_0102-0028cc1b-c91d-4ca1-93a9-43b1d1857b55-5f75ec50-c6a5-492a-b057-9f02e86abe94.jpg',	'Image',	1,	'2023-04-27 02:56:28',	'2023-04-27 02:56:28'),
(9,	'Nail Styling Training Action',	'/02-589a8c5f-b8f1-4b9b-9751-d142d0218148.jpg',	'Image',	1,	'2023-04-27 02:57:17',	'2023-04-27 02:57:17'),
(10,	'Products',	'/k7ymrj1635386588929Before (1)-d1e6a63f-5734-4190-96ab-8a4600d2b51f.png',	'Image',	1,	'2023-04-27 02:58:40',	'2023-05-05 13:31:32');

DROP TABLE IF EXISTS `groups`;
CREATE TABLE `groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `class_id` int(11) NOT NULL,
  `name` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `groups` (`id`, `class_id`, `name`, `created_at`, `updated_at`) VALUES
(4,	3,	'Group 2',	'2023-05-04 20:14:55',	'2023-05-04 20:14:55');

DROP TABLE IF EXISTS `internship_places`;
CREATE TABLE `internship_places` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `place_name` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `location` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_number` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `internship_places` (`id`, `place_name`, `location`, `contact_number`, `user_id`, `created_at`, `updated_at`) VALUES
(1,	'Puy saloan',	'Phnom Penh Cambodia',	'NA',	0,	'2023-01-22 13:46:55',	'2023-01-23 20:01:34'),
(2,	'B1',	NULL,	'None',	0,	'2023-01-23 21:01:30',	'2023-01-24 15:01:17'),
(3,	'B2',	NULL,	'0123445667',	0,	'2023-01-24 15:02:11',	'2023-01-24 15:02:11'),
(4,	'Serge Comtesse Sensory Prestige',	'Phnom Penh, Daun Penh | #21, St.49 corner St.136, Phsar Thmey 3, Daun Penh, Phnom Penh',	'023 966 263',	0,	'2023-04-07 15:15:10',	'2023-04-07 15:15:10'),
(5,	'Neak Beauty Salon edit',	'Sisophon, Bunteay Mean Chey',	'093666696 N?A',	0,	'2023-05-04 18:37:02',	'2023-05-04 18:37:30'),
(6,	'Agasto Salon',	'Phnom Penh, Meanchey , Bong tompun sonsom kusol Pagoda',	'089286478',	0,	'2023-05-31 13:52:52',	'2023-05-31 13:52:52'),
(7,	'Gallery House Salon',	'Phnom Penh, sen sok #45B, St.18E',	'093282001',	0,	'2023-05-31 13:55:17',	'2023-05-31 13:55:17'),
(8,	'Srey Pich Salon',	'Phnom Penh, Toul Kork | No 28E, St 586, Beoung Kok II',	'015672019',	0,	'2023-05-31 13:56:59',	'2023-05-31 13:56:59'),
(9,	'The Face Salon',	'Phom Penh',	'010353195/089 666 769',	0,	'2023-05-31 14:16:16',	'2023-05-31 14:16:16'),
(10,	'Narak Inside Beauty',	'Phnom Penh, Daun Penh | St.19 krouy vang',	'069500544',	0,	'2023-05-31 14:17:30',	'2023-05-31 14:17:30'),
(11,	'Kanha Spa & Salon',	'Phnom Penh, Chbar Ampov | #1, St.M14, Kamrong 4, Peng Houth Boeng Snor',	'099 24 0003',	0,	'2023-05-31 17:19:51',	'2023-05-31 17:19:51'),
(12,	'Mini Salon',	'Phnom Penh, Chamkar mon l #246A ,St.488 , Phsar Derm Tkov',	'096 342 016',	0,	'2023-05-31 17:20:59',	'2023-05-31 17:20:59'),
(13,	'N&R Theany Salon',	'Phnom Penh, Mean Chey | Chak Angre Kraom',	'07737551/070735551',	0,	'2023-05-31 17:23:12',	'2023-05-31 17:23:12'),
(14,	'Lyly Salon',	'Kandal Province, takaov Market',	'012831424',	0,	'2023-05-31 17:24:31',	'2023-05-31 17:24:31'),
(15,	'Jasmine Salon',	'Phnom Penh, Chbar Ampov | $163-164, St.Polaris, Peng Houth Boeng Snor',	'0968111619',	0,	'2023-05-31 17:27:09',	'2023-05-31 17:27:09'),
(16,	'NaNa Yon Hair Salon',	'Phnom Penh, Boeng Kork , neak one Pagoda',	'0888378787',	0,	'2023-05-31 17:33:04',	'2023-05-31 17:33:04'),
(17,	'0.ABHC Leakena',	'1,​ LEEKAJA (CAMBODIA) TRADING CO.,LTD\r\n#S១-២៣ E២ អគារ ដឺ អូឡាំព្យា ស៊ីធី តូបលេខ F២-០១ ជាន់ ទី២ ផ្លូវព្រះមុនីរ៉េត (២១៧) សង្កាត់ វាលវង់ ខណ្ឌ ៧មករា វាជធានីភ្នំពេញ 099 443 944\r\n2, LEEKAJA PHSAR CHIPMONG SENSOK MALL\r\nផ្សារជីបម៉ុង សែនសុខម៉ល លេខជី១៤ ជាន់ផ្ទាល់ដី ផ្លូវគ្មាន  ភូមិបាយ៉ាប សង្កាត់ភ្នំពេញថ្មី ខណ្ឌសែនសុខ រាជធានីភ្នំពេញ\r\n088 801 1888\r\n3,​ LEEKAJA PHSAR CHIPMONG 271 MEGAMALL\r\nផ្សារជីបម៉ុង 271 មេហ្គាម៉ល លេខ ១០២បេ ជាន់ទី១ ផ្លូវ ២៧១ ភូមិ ព្រែកតានូ សង្កាត់ ចាក់អង្រែលើ ខណ្ឌ មានជ័យ រាជធានីភ្នំពេញ\r\n077 704 444\r\n4,LEEKAJA BEAUTY SALON TOULKORK\r\n #១៥០ BD+BE ផ្លូវ៥១៦ ភូមិ១៣ សង្កាត់បឹងកក់ទី ១ ខណ្ឌទទួលគោក រាជធានីភ្នំពេញ\r\n078 919 778\r\n5,​ Leekaja Salon - Sovanna\r\nPhnom Penh, Beoung Keng Kang | Near Sovanna Mall,Tumnob Teuk\r\n069 666 908',	'015229908',	0,	'2023-05-31 17:53:35',	'2023-05-31 18:44:10'),
(18,	'Sopois Salon',	'Kandal Province',	'092210706',	0,	'2023-05-31 18:46:41',	'2023-05-31 18:46:41'),
(19,	'Mystory Nail Spa',	'146 st 118 Sangkat Psar Chas Phnom Penh',	'099 227 727',	8,	'2023-07-20 11:24:00',	'2023-07-20 11:24:00'),
(20,	'Agastro Beauty',	'នៅជិតវត្តសន្សំកុសល\r\nhttps://www.google.com/maps/dir/11.5774458,104.9038456/11.5280747,104.9103889/@11.5527963,104.8910638,14z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	'089​ 286 478',	8,	'2023-07-20 11:25:00',	'2023-07-20 11:25:24'),
(21,	'Leekajaa Cambodia',	'Leekaja Beauty Salon Sovanna Branch, Phnom Penh\r\nhttps://maps.app.goo.gl/fL1vtM5eYCor38Db8',	'077 704 444',	8,	'2023-07-20 11:26:31',	'2023-07-20 11:26:31'),
(22,	'Vicci Beauty Bar',	'https://maps.app.goo.gl/xChvRtRAmT4wMGG26',	'012 208 529',	8,	'2023-07-20 11:34:19',	'2023-07-20 11:34:19'),
(23,	'Serge Comtesse',	'#21E0, St 136 corner St 49, Phsar Thmey III, Doun Penh, Phnom Penh, Cambodia',	'00',	8,	'2023-07-20 11:38:31',	'2023-07-20 11:38:31'),
(24,	'Mini Salon',	'https://maps.app.goo.gl/rSdeTGeowvfmzzHy5',	'017 307 374',	8,	'2023-07-20 11:39:13',	'2023-07-20 11:39:13'),
(25,	'B1',	'https://maps.app.goo.gl/itavkn6ZGYpeyAf39',	'015 599 559',	8,	'2023-07-20 11:45:41',	'2023-07-20 11:45:41'),
(26,	'PUY Salon',	'PP,Chamkar Mon, # 94F, St63, TonleBassac  &PP, Russey Keo, Borey Chip Mong 598',	'098 658 422 & 085 597 598',	8,	'2023-10-18 11:42:46',	'2023-10-18 11:42:46'),
(27,	'SREY PICH Salon',	'ខាងត្បូងផ្សារទូលគោក',	'+855 69 384 000',	8,	'2023-10-18 11:45:15',	'2023-10-18 11:45:15'),
(28,	'KANHA Spa and salon',	'ច្បាអំពៅ',	'+855 99 240 003',	8,	'2023-10-18 14:12:28',	'2023-10-18 14:12:28'),
(29,	'Seger Comtesse Salon',	'21E0, St 136 corner St 49, Phsar Thmey III, Doun Penh, Phnom Penh, Cambodia',	'023 966 263/855 12 772 775',	8,	'2023-10-18 14:19:39',	'2023-10-18 14:19:39'),
(30,	'Spider man Barber',	'ទូលគោគ',	'+855 92 810 016',	8,	'2023-10-18 14:20:43',	'2023-10-18 14:20:43'),
(31,	'NANA Yun',	'ផ្សារទូលគោគ',	'+855 88 837 8787',	8,	'2023-10-18 14:22:16',	'2023-10-18 14:22:16'),
(32,	'អេ ផ្លើស អេ ផ្លើស អេ ផ្លើស អេ ផ្លើស អេ ផ្លើស អេ ផ្លើស អេ ផ្លើស HAIR&BERBAR',	'ផ្ទះ 13A ផ្លូវ 253 សង្កាត់ទឹកល្អក់3 ខណ្ឌទួលគោក ភ្នំពេញ (ខាងក្រោយផ្សារឃ្លាំងរំសែវថ្មី) 098 68 08 68',	'855 93 680 868',	8,	'2023-10-18 14:23:31',	'2023-10-18 14:23:31'),
(33,	'The space of beauty',	'No 30F, street 187, Tumnob Tek community , Beung Keng Kang district, Phnom Penh, Cambodia',	'012 955 772',	8,	'2023-10-18 14:37:34',	'2023-10-18 14:37:34');

DROP TABLE IF EXISTS `lessons`;
CREATE TABLE `lessons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `lesson_occupation_id` int(11) NOT NULL,
  `competency_type` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'generic, functional',
  `name` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `short_name` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `practice_hour` double(8,2) NOT NULL,
  `practice_duration_type` varchar(125) COLLATE utf8mb4_unicode_ci DEFAULT 'h' COMMENT 'h: hour, mn:minute',
  `theory_hour` double(8,2) NOT NULL,
  `theory_duration_type` varchar(125) COLLATE utf8mb4_unicode_ci DEFAULT 'h' COMMENT 'h: hour, mn:minute',
  `video` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `document` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `lessons` (`id`, `lesson_occupation_id`, `competency_type`, `name`, `short_name`, `practice_hour`, `practice_duration_type`, `theory_hour`, `theory_duration_type`, `video`, `document`, `status`, `user_id`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1,	2,	'Generic Competency',	'អ៊ុតសក់រូញ',	'Straight Hair',	25.00,	'h',	2.00,	'h',	NULL,	NULL,	1,	0,	'2022-12-31 01:52:47',	'2023-01-09 13:38:00',	NULL),
(2,	2,	'Generic Competency',	'អ៊ុតសក់ត្រង់',	'Curly Hair',	20.00,	'h',	2.00,	'h',	NULL,	NULL,	1,	0,	'2022-12-31 02:28:35',	'2023-01-09 13:35:28',	NULL),
(3,	2,	'Generic Competency',	'Hair Color',	'HC',	12.00,	'h',	5.00,	'h',	NULL,	'Chapter_8_លាបពណ៌សក់(I).docx',	1,	0,	'2023-01-09 14:34:48',	'2023-06-27 13:45:27',	NULL),
(4,	5,	'Generic Competency',	'កាត់ក្រចកដៃ ក្រចកជើង',	'កាត់ក្រចកដៃ ក្រចកជើង',	10.00,	'h',	3.00,	'h',	NULL,	NULL,	1,	0,	'2023-01-22 14:01:49',	'2023-01-22 14:01:49',	NULL),
(5,	5,	'Generic Competency',	'អ៊ុតសក់សេរ៉ូម',	'អ៊ុតសក់សេរ៉ូម',	5.00,	'h',	2.00,	'h',	NULL,	NULL,	1,	0,	'2023-01-22 14:02:16',	'2023-01-22 14:02:16',	NULL),
(6,	5,	'Generic Competency',	'លាបពណ៌ប្រាក់៣ដង',	'លាបពណ៌ប្រាក់៣ដង',	10.00,	'h',	4.00,	'h',	NULL,	NULL,	1,	0,	'2023-01-22 14:02:42',	'2023-01-22 14:02:42',	NULL),
(7,	5,	'Generic Competency',	'ម៉ាស្សាមុខ',	'ម៉ាស្សាមុខ',	5.00,	'h',	3.00,	'h',	NULL,	NULL,	1,	0,	'2023-01-22 14:03:21',	'2023-01-22 14:03:21',	NULL),
(8,	5,	'Functional Competency',	'សំអាតត្រជៀក',	'សំអាតត្រជៀក',	2.00,	'h',	3.00,	'h',	NULL,	NULL,	1,	0,	'2023-01-22 14:03:35',	'2023-01-22 14:03:35',	NULL),
(9,	7,	'Functional Competency',	'ទទូលនិងឆ្លើយតបការប្រាស្រ័យទាក់ទងក្នុងកន្លែងការងារ',	'ទទូលនិងឆ្លើយតបការប្រាស្រ័យទាក់ទងក្នុងកន្លែងការងារ',	0.00,	'h',	15.00,	'h',	NULL,	NULL,	1,	0,	'2023-06-27 17:46:17',	'2023-06-27 17:46:42',	NULL),
(10,	3,	'Functional Competency',	'ការអនុវត្តនីតិវិធីសុវត្ថិភាព និងសុខភាពសេវាកម្មកាត់សក់បុរស',	'Man Hiar cut',	3.00,	'h',	3.00,	'h',	NULL,	NULL,	1,	8,	'2023-10-18 16:12:18',	'2023-10-27 08:55:57',	NULL),
(11,	1,	'Generic Competency',	'Test Upload Multi File',	'T-U-M-F',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	2,	1,	'2023-10-25 16:23:11',	'2023-10-25 16:23:48',	NULL),
(12,	8,	'Functional Competency',	'ការអនុវត្តការរៀបចំទីតាំងមុនពេលផ្ដល់សេវាកម្មសម្អាងកាយ',	'កំណត់សម្ភារៈ ឧបករណ៍និងបរិក្ខារប្រើប្រាស់ក្នុងការអនុវត្តការងារ',	50.00,	'h',	50.00,	'h',	NULL,	NULL,	1,	1,	'2023-11-25 09:39:42',	'2023-11-25 09:39:42',	NULL),
(13,	8,	'Functional Competency',	'កំណត់សម្ភារៈ ឧបករណ៍និងបរិក្ខារប្រើប្រាស់ក្នុងការអនុវត្តការងារ',	'Beauty',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 11:01:19',	'2023-12-04 11:01:19',	NULL),
(14,	8,	'Functional Competency',	'កំណត់សម្ភារៈ ឧបករណ៍និងបរិក្ខារប្រើប្រាស់',	'Beauty',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 11:08:58',	'2023-12-04 11:08:58',	NULL),
(15,	8,	'Functional Competency',	'ការរៀបចំសម្ភារៈ ឧបករណ៍និងបរិក្ខារ',	'Beauty',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 11:09:47',	'2023-12-04 11:09:47',	NULL),
(16,	8,	'Functional Competency',	'ការប្រើប្រាស់សម្ភារៈ ឧបករណ៍និងបរិក្ខារ',	'Beauty',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 11:11:45',	'2023-12-04 11:11:45',	NULL),
(17,	8,	'Functional Competency',	'វិធីសាស្រ្តថែទាំ',	'Beauty',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 11:12:36',	'2023-12-04 11:12:36',	NULL),
(18,	8,	'Functional Competency',	'ការស្គាល់សម្ភារ ឧបករណ៍ និងបរិក្ខារ',	'Beauty',	2.00,	'h',	2.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 11:18:40',	'2023-12-04 11:18:40',	NULL),
(19,	8,	'Functional Competency',	'ការអនុវត្តអនាម័យនៅកន្លែងការងារ',	'Beauty',	2.00,	'h',	2.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 11:19:54',	'2023-12-04 11:19:54',	NULL),
(20,	8,	'Functional Competency',	'វិធីសាស្រ្តថែទាំឧបករណ៍និងសម្ភារៈម៉ាស្សា',	'Beauty',	2.00,	'h',	2.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 11:22:46',	'2023-12-04 11:22:46',	NULL),
(21,	8,	'Functional Competency',	'ការធ្វើបញ្ជីងនិងកត់ត្រា',	'Beauty',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 11:27:13',	'2023-12-04 11:27:13',	NULL),
(22,	8,	'Functional Competency',	'ការកំណត់សម្ភារ ឧបករណ៍និងបរិក្ខារប្រើប្រាស់',	'Beauty',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 11:28:11',	'2023-12-04 11:28:11',	NULL),
(23,	8,	'Functional Competency',	'ពិនិត្យស្ថានភាពសម្ភារឧបកណ័និងបរិក្ខារ',	'Beauty',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 11:30:28',	'2023-12-04 11:30:28',	NULL),
(24,	8,	'Functional Competency',	'ជ្រើរើសសម្ភារៈឧបករណ៍និងបរិក្ខារ',	'Beauty',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 11:31:21',	'2023-12-04 11:31:21',	NULL),
(25,	8,	'Functional Competency',	'នីតិវិធីសុខភាព និងសុវត្តភាពការងារ',	'Beauty',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 11:32:25',	'2023-12-04 11:32:25',	NULL),
(26,	8,	'Functional Competency',	'ការកំណត់សម្ភារឧបករណ៍និងបរិក្ខារប្រើប្រាស់',	'Beauty',	2.00,	'h',	2.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 11:40:18',	'2023-12-04 11:40:18',	NULL),
(27,	8,	'Functional Competency',	'ជ្រើសរើសសម្ភារឧបករណ៍និងបរិក្ខារ',	'Beauy',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 11:41:29',	'2023-12-04 11:41:29',	NULL),
(28,	8,	'Functional Competency',	'ការប្រើប្រាស់សម្ភារ និងបរិក្ខារ',	'Beauty',	2.00,	'h',	2.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 11:42:21',	'2023-12-04 11:42:21',	NULL),
(29,	8,	'Functional Competency',	'និតិវិធីសុខភាព និងសុវត្តិភាពការងារ',	'Beauty',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 11:43:16',	'2023-12-04 11:43:16',	NULL),
(30,	8,	'Functional Competency',	'អនុវត្តសុខភាពនិងសុវត្តភាពការងារ',	'Beauty',	2.00,	'h',	2.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 11:46:48',	'2023-12-04 11:47:59',	NULL),
(31,	8,	'Functional Competency',	'អនុវត្តអនាម័យកន្លែងការងារ',	'Beauty',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 11:50:25',	'2023-12-04 11:50:25',	NULL),
(32,	8,	'Functional Competency',	'ការធ្វើបញ្ជី និងកត់ត្រា',	'Beauty',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 11:51:19',	'2023-12-04 11:51:19',	NULL),
(33,	8,	'Functional Competency',	'ពិនិត្យស្ថានភាពសម្ភារ ឧបករណ៍និងបរិក្ខារ',	'Beauty',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 11:52:25',	'2023-12-04 11:52:25',	NULL),
(34,	8,	'Functional Competency',	'អនុវត្តគោលការណ៍នៃការថែទាំជាប្រចាំ',	'Beauty',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 11:53:41',	'2023-12-04 11:53:41',	NULL),
(35,	8,	'Functional Competency',	'ការសម្អាតនិងថែទាំជាប្រចាំ',	'Beauty',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 11:56:32',	'2023-12-04 11:56:32',	NULL),
(36,	8,	'Functional Competency',	'កំណត់របៀបម៉ាស្សាលើរាងកាយ',	'beauty',	2.00,	'h',	2.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 13:28:47',	'2023-12-04 13:28:47',	NULL),
(37,	8,	'Functional Competency',	'កំណត់ពេលវេលាម៉ាស្សាលើរាងកាយនិងស្បែកក្បាល',	'Beauty',	2.00,	'h',	2.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 13:32:58',	'2023-12-04 13:32:58',	NULL),
(38,	8,	'Functional Competency',	'ការប្រាស្រ័យទាក់ទង',	'Beauty',	2.00,	'h',	2.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 13:33:35',	'2023-12-04 13:33:35',	NULL),
(39,	8,	'Functional Competency',	'អនុវត្តអនាម័យកន្លែងការងារម៉ាស្សា',	'Beauty',	2.00,	'h',	2.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 13:35:03',	'2023-12-04 13:35:03',	NULL),
(40,	8,	'Functional Competency',	'២ ការប្រាស្រ័យទាក់ទងម៉ាស្សា',	'Beauty',	2.00,	'h',	2.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 13:43:13',	'2023-12-04 13:43:13',	NULL),
(41,	8,	'Functional Competency',	'អនុវត្តកំណត់របៀបម៉ាស្សារាងកាយ',	'Beauty',	2.00,	'h',	2.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 13:44:25',	'2023-12-04 13:44:25',	NULL),
(42,	8,	'Functional Competency',	'របៀបម៉ាស្សាលើរាងកាយ',	'Beauty',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 13:44:58',	'2023-12-04 13:44:58',	NULL),
(43,	8,	'Functional Competency',	'សង្កេត និងពិនិត្យស្បែកមុខ',	'Beauty',	3.00,	'h',	3.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 13:46:02',	'2023-12-04 13:46:02',	NULL),
(44,	8,	'Functional Competency',	'ការជ្រើសរើសសម្ភារ ឧបករណ៍ និងបរិក្ខារសម្អាតផ្ទៃមុខ',	'Beauty',	3.00,	'h',	3.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 13:46:54',	'2023-12-04 13:46:54',	NULL),
(45,	8,	'Functional Competency',	'ការប្រាស្រ័យទាក់ទងកំឡុងពេលម៉ាស្សា',	'Beauty',	2.00,	'h',	2.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 13:48:13',	'2023-12-04 13:48:13',	NULL),
(46,	8,	'Functional Competency',	'សង្កេតនិងពិនិត្យស្បែកមុខ',	'Beauty',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 16:41:15',	'2023-12-04 16:41:15',	NULL),
(47,	8,	'Functional Competency',	'កំណត់សម្ភារ ឧបករណ៍ និងបរិក្ខារសម្អាតផ្ទៃមុខ',	'Beauty',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 16:41:59',	'2023-12-04 16:41:59',	NULL),
(48,	8,	'Functional Competency',	'កំណត់សម្ភារ ឧបករណ៍និងបរិក្ខារសម្អាតផ្ទៃមុខ',	'Beauty',	2.00,	'h',	2.00,	'h',	NULL,	NULL,	2,	8,	'2023-12-04 16:48:23',	'2023-12-04 16:48:35',	NULL),
(49,	8,	'Functional Competency',	'ជ្រើសរើសសម្ភារ ឧបករណ៍ និងបរិក្ខារសម្អាតផ្ទៃមុខ',	'Beauty',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 16:49:18',	'2023-12-04 16:49:18',	NULL),
(50,	8,	'Functional Competency',	'បច្ចេកទេសសម្អាតផ្ទៃមុខ',	'Beauty',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-04 16:50:07',	'2023-12-04 16:50:07',	NULL),
(51,	8,	'Functional Competency',	'បច្ចេកទេសលាងជំរះដោយទឹកស្អាតលើផ្ទៃមុខ',	'Beauty',	4.00,	'h',	4.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 10:59:18',	'2023-12-05 10:59:18',	NULL),
(52,	8,	'Functional Competency',	'ការប្រាស្រ័យទាក់ទងអតិថិជននៅកន្លែងអនុវត្តការងារ',	'Beauty',	2.00,	'h',	2.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 11:00:29',	'2023-12-05 11:00:29',	NULL),
(53,	8,	'Functional Competency',	'ជ្រើសរើសនិងប្រើប្រាស់សម្ភារៈនិងឧបករណ៍ម៉ាស្សាបន្តឹងស្បែកមុខ',	'Beauty',	3.00,	'h',	3.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 11:03:54',	'2023-12-05 11:03:54',	NULL),
(54,	8,	'Functional Competency',	'កំណត់សម្ភារៈឧបករណ៍និងបរិក្ខារម៉ាស្សាបន្តឹងស្បែកមុខឲ្យបានត្រឹមត្រូវ',	'Beauty',	4.00,	'h',	4.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 11:04:45',	'2023-12-05 11:04:45',	NULL),
(55,	8,	'Functional Competency',	'សង្គេតនិងពិនិត្យស្បែកមុខ',	'Beauty',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 11:05:35',	'2023-12-05 11:05:35',	NULL),
(56,	8,	'Functional Competency',	'ធ្វើបញ្ជីសម្ភារៈឧបករណ៍និងបរិក្ខារសម្រាប់ការម៉ាស្សាបន្តឹងស្បែកមុខ',	'Beauty',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 11:07:28',	'2023-12-05 11:07:28',	NULL),
(57,	8,	'Functional Competency',	'កំណត់និងជ្រើសរើសសម្ភារៈឧបករណ៍និងបរិក្ខារម៉ាស្សាបន្តឹងស្បែកមុខ',	'Beauty',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 11:09:06',	'2023-12-05 11:09:06',	NULL),
(58,	8,	'Functional Competency',	'អនុវត្តន៍ការម៉ាស្សាបន្តឹងស្បែកមុខ',	'Beauty',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 11:12:01',	'2023-12-05 11:12:01',	NULL),
(59,	8,	'Functional Competency',	'បច្ចេកទេសលាងជំរះដោយទឹកស្អាតលើផ្ទៃមុខជាមួយទឹកក្តៅអ៊ុនៗ',	'Beauty',	2.00,	'h',	2.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 11:14:26',	'2023-12-05 11:14:26',	NULL),
(60,	8,	'Functional Competency',	'ការប្រស្រ័យទាក់ទង មុនពេលធ្វើសេវាកម្ម',	'Beauty',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 11:16:22',	'2023-12-05 11:16:22',	NULL),
(61,	3,	'Functional Competency',	'ពិនិត្យសម្ភារ ឧបករណ៍ និងបរិក្ខារមុនពេលផ្ដល់សេវាកម្ម',	'MHC',	60.00,	'h',	60.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 11:36:10',	'2023-12-05 11:36:10',	NULL),
(62,	3,	'Functional Competency',	'ការត្រួតពិនិត្យ ឧបករណ៍និងសម្ភារ',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 14:34:32',	'2023-12-05 14:34:32',	NULL),
(63,	3,	'Functional Competency',	'ការរៀបចំឧបករណ៍ សម្ភារ និងបរិក្ខារសម្រាប់កាត់សក់',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 14:36:13',	'2023-12-05 14:36:13',	NULL),
(64,	3,	'Functional Competency',	'ការប្រាស្រ័យទាក់ទងកំឡុងពេលធ្វើសេវាកម្មកាត់សក់បុរស',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 14:37:59',	'2023-12-05 14:37:59',	NULL),
(65,	3,	'Functional Competency',	'ការអនុវត្តអនាម័យនៅកន្លែងការងារកាត់សក់បុរស',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 14:39:26',	'2023-12-05 14:39:26',	NULL),
(66,	3,	'Functional Competency',	'និតិវិធីសុខភាពនិងសុវត្ថិភាពការងារ',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 14:40:44',	'2023-12-05 14:40:44',	NULL),
(67,	3,	'Functional Competency',	'និតិវិធីសុខភាពនិងសុវត្ថិភាពការងារកាត់សក់បុរស',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 14:49:14',	'2023-12-05 14:49:14',	NULL),
(68,	3,	'Functional Competency',	'ការរៀបចំសម្ភារៈឧបករណ៍ និងបរិក្ខារសម្រាប់កាត់សក់',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 14:50:53',	'2023-12-05 14:50:53',	NULL),
(69,	3,	'Functional Competency',	'និតិវិធីសុខភាពនិងសុវត្ថិភាពការងារបុរស',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 14:52:29',	'2023-12-05 14:52:29',	NULL),
(70,	3,	'Functional Competency',	'ត្រួតពិនិត្យកាលវិភាគការងារមុនផ្ដល់សេវាកម្មស្របតាមតម្រូវការងារ',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 14:58:47',	'2023-12-05 14:58:47',	NULL),
(71,	3,	'Functional Competency',	'កំណត់ការណាត់ជួបដើម្បីផ្ដល់សេវាកម្មស្របតាមតម្រូវការងារ',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 15:00:27',	'2023-12-05 15:00:27',	NULL),
(72,	3,	'Functional Competency',	'ការប្រាស្រ័យទាក់ទងសួរនាំភ្ញៀវអំពីសេវាកម្មដែលភ្ញៀវចង់ធ្វើ',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 15:01:37',	'2023-12-05 15:01:37',	NULL),
(73,	3,	'Functional Competency',	'កំណត់សម្ភារ ឧបករណ៌ និងបរិក្ខារ ប្រើប្រាស់សម្រាប់ការកាត់សក់',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 15:10:47',	'2023-12-05 15:10:47',	NULL),
(74,	3,	'Functional Competency',	'ជំនាញក្នុងការធ្វើបញ្ជី និងធ្វើបញ្ជី និងកត់ត្រា',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 15:12:40',	'2023-12-05 15:12:40',	NULL),
(75,	3,	'Functional Competency',	'ការស្គាល់សម្ភារ ឧបករណ៍ និងបរិក្ខារកាត់សក់',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 15:13:13',	'2023-12-05 15:13:13',	NULL),
(76,	3,	'Functional Competency',	'វិធីសាស្ដ្រថែទាំ',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 15:14:17',	'2023-12-05 15:14:17',	NULL),
(77,	3,	'Functional Competency',	'ត្រួតពិនិត្យអនាម័យកៅអីកាត់សក់ស្របតាមគោលការណ៍ស៥',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 15:18:28',	'2023-12-05 15:18:28',	NULL),
(78,	3,	'Functional Competency',	'ការស្គាល់សម្ភារ ឧបករណ៍ និងបរិក្ខារកាត់សក់បុរស',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 15:19:41',	'2023-12-06 08:46:20',	NULL),
(79,	3,	'Functional Competency',	'ការរៀបចំសម្ភារ ឧបករណ៍និងបរិក្ខារកាត់សក់',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 15:26:32',	'2023-12-05 15:26:32',	NULL),
(80,	3,	'Functional Competency',	'អនុវត្តតាមគោលការណ៍នៃការថែទាំជាប្រចាំ',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 15:37:02',	'2023-12-05 15:37:02',	NULL),
(81,	3,	'Functional Competency',	'ការស្គាល់សម្ភារ ឧបករណ៍ និងបរិក្ខារកាត់សក់សម្រាប់កាត់សក់',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 15:40:36',	'2023-12-05 15:40:36',	NULL),
(82,	3,	'Functional Competency',	'ការរៀបចំសម្ភារ ឧបករណ៍និងបរិក្ខារកាត់សក់សម្រាប់កាត់សក់',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 15:43:33',	'2023-12-06 08:46:04',	NULL),
(83,	3,	'Functional Competency',	'កំណត់ និងរៀបចំទីតាំងឧបករណ៌ និងបរិក្ខារកាត់សក់',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 15:44:13',	'2023-12-05 15:44:13',	NULL),
(84,	3,	'Functional Competency',	'ធ្វើបញ្ជីសម្ភារ ឧបករណ៍ និងបរិក្ខារដោយស្របតាមតម្រូវការការងារ',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 16:16:34',	'2023-12-05 16:16:34',	NULL),
(85,	3,	'Functional Competency',	'ពិនិត្យស្ថានភាពសម្ភារឧបករណ៍និងបរិក្ខារ',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 16:17:15',	'2023-12-05 16:23:24',	NULL),
(86,	3,	'Functional Competency',	'និតិវិធីសុខភាពនិងសុវត្ថិភាពការងារមុននិងក្រោយធ្វើសេវាកម្ម',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 16:18:52',	'2023-12-05 16:23:13',	NULL),
(87,	3,	'Functional Competency',	'ការកំណត់សម្ភារ ឧបករណ៍ និងបរិក្ខារប្រើប្រាស់',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 16:19:55',	'2023-12-05 16:19:55',	NULL),
(88,	3,	'Functional Competency',	'និត្យស្ថានភាពសម្ភារ ឧបករណ៍និងបរិក្ខារចំណាំស្ថានភាពបរិក្ខារ',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 16:20:57',	'2023-12-05 16:20:57',	NULL),
(89,	3,	'Functional Competency',	'បច្ចេកទេសប្រើប្រាស់ឧបករណ៍',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 16:21:36',	'2023-12-05 16:21:36',	NULL),
(90,	3,	'Functional Competency',	'និតិវិធីសុខភាពនិងសុវត្ថិភាពការងារគំឡងពេលកាត់សក់',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 16:23:05',	'2023-12-05 16:23:05',	NULL),
(91,	3,	'Functional Competency',	'ធ្វើបញ្ជីលើសម្ភារ ឧបករណ៍ និងបរិក្ខារដែលប្រើរួច',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 16:24:19',	'2023-12-05 16:24:19',	NULL),
(92,	3,	'Functional Competency',	'ពិនិត្យស្ថានភាពសម្ភារ ឧបករណ៍និងបរិក្ខារមុនប្រើនិងពេលប្រើរួច',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 16:25:59',	'2023-12-05 16:25:59',	NULL),
(93,	3,	'Functional Competency',	'និតិវិធីសុខភាពនិងសុវត្ថិភាពការងារក្នុងសាឡន',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-05 16:26:54',	'2023-12-05 16:26:54',	NULL),
(94,	3,	'Functional Competency',	'សង្កេត និងពិនិត្យស្បែកក្បាល និង សរសៃសក់',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-06 13:17:12',	'2023-12-06 13:17:12',	NULL),
(95,	3,	'Functional Competency',	'ជ្រើសរើសផលិតផលកក់សក់',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-06 13:17:57',	'2023-12-06 13:17:57',	NULL),
(96,	3,	'Functional Competency',	'និងប្រើប្រាស់ផលិតផលកក់សក់ឲ្យត្រូវនឹងស្បែកក្បាល និង សរសៃសក់',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-06 13:18:45',	'2023-12-06 13:18:45',	NULL),
(97,	3,	'Functional Competency',	'ការប្រាស្រ័យទាក់ទងអំពីតម្រូវរបស់អតិថិជន',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-06 13:20:16',	'2023-12-06 13:20:16',	NULL),
(98,	3,	'Functional Competency',	'ការសង្កេត និងពិនិត្យស្បែកក្បាល និង សរសៃសក់',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-06 13:22:14',	'2023-12-06 13:22:14',	NULL),
(99,	3,	'Functional Competency',	'រៀបចំផលិតផលសម្រាប់កក់សក់',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-06 13:23:03',	'2023-12-06 13:23:03',	NULL),
(100,	3,	'Functional Competency',	'កំណត់សម្ភារៈ ឧបករណ៍ និងបរិក្ខារ',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-06 13:23:50',	'2023-12-06 13:23:50',	NULL),
(101,	3,	'Functional Competency',	'បច្ចេកទេសកក់សក់',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-06 13:24:34',	'2023-12-06 13:24:34',	NULL),
(102,	3,	'Functional Competency',	'ការប្រាស្រ័យទាក់ទងដើម្បីទទួលបដិសណ្ឋារកិច្ចជាមួយអតិថិជន',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-06 13:46:45',	'2023-12-06 13:46:45',	NULL),
(103,	3,	'Functional Competency',	'ការលាងសម្អាតសក់',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-06 13:54:45',	'2023-12-06 13:54:45',	NULL),
(104,	3,	'Functional Competency',	'ការប្រាស្រ័យទាក់ទងកន្លែងការងារ',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-06 13:56:03',	'2023-12-06 13:56:03',	NULL),
(105,	3,	'Functional Competency',	'ការជូតសម្ងួតសក់',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-06 13:57:07',	'2023-12-06 13:57:07',	NULL),
(106,	3,	'Functional Competency',	'ការវិភាគទម្រង់មុខនិងសរសៃសក់',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-06 14:01:58',	'2023-12-06 14:01:58',	NULL),
(107,	3,	'Functional Competency',	'ការកំណត់ទម្រង់មុខ និងសរសៃសក់',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-06 14:06:40',	'2023-12-06 14:06:40',	NULL),
(108,	3,	'Functional Competency',	'ការប្រាស្រ័យទាក់ទង ជាមួយតិថិជន',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-06 14:13:05',	'2023-12-06 14:13:05',	NULL),
(109,	3,	'Functional Competency',	'ព្រឹក្សារការកំណត់ទម្រង់មុខ និងសរសៃសក់',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-06 14:15:06',	'2023-12-06 16:20:21',	NULL),
(110,	3,	'Functional Competency',	'ការជ្រើសរើសម៉ូតសក់',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-06 14:17:41',	'2023-12-06 14:17:41',	NULL),
(111,	3,	'Functional Competency',	'ការប្រាស្រ័យទាក់ទងដើម្បីយល់ដឹងពីតម្រូវការអតិថិជន',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-06 14:20:03',	'2023-12-06 14:20:03',	NULL),
(112,	3,	'Functional Competency',	'ការស្គាល់សម្ភារ ឧបករណ៍ និងបរិក្ខារដែលមានមានក្នុងកន្លែងការងារ',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-07 09:05:47',	'2023-12-07 09:05:47',	NULL),
(113,	3,	'Functional Competency',	'២ បច្ចេកទេសកាន់សម្ភារ ឧបករណ៍កាត់សក់',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-07 09:07:28',	'2023-12-07 09:07:28',	NULL),
(114,	3,	'Functional Competency',	'បច្ចេកទេសកាត់សក់',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-07 09:08:17',	'2023-12-07 09:08:17',	NULL),
(115,	3,	'Functional Competency',	'ការប្រាស្រ័យទាក់ទងមុននិងក្រោយផ្តល់សេវាកម្ម',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-07 09:09:56',	'2023-12-07 09:09:56',	NULL),
(116,	3,	'Functional Competency',	'អនុវត្តការប្រាស្រ័យទាក់ទង',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-07 09:11:21',	'2023-12-07 09:11:21',	NULL),
(117,	3,	'Functional Competency',	'ការត្រួតពិនិត្យ ម៉ូតសក់តាមប្រភេទសក់ឡើងវិញ',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-07 09:12:10',	'2023-12-07 09:12:10',	NULL),
(118,	3,	'Functional Competency',	'ការផ្ទៀងផ្ទាត់ និងប្រៀបធៀប',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-07 09:13:00',	'2023-12-07 09:13:00',	NULL),
(119,	3,	'Functional Competency',	'ការអនុវត្តអនាម័យលើភ្ញៀវ',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-07 09:13:39',	'2023-12-07 09:13:39',	NULL),
(120,	3,	'Functional Competency',	'ការកំណត់សម្ភារ ឧបករណ៍ផ្លុំសក់',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-07 09:15:06',	'2023-12-07 09:15:06',	NULL),
(121,	3,	'Functional Competency',	'ការប្រើប្រាស់សម្ភារ ឧបករណ៍ផ្លុំសក់',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-07 09:15:46',	'2023-12-07 09:15:46',	NULL),
(122,	3,	'Functional Competency',	'ការប្រាស្រ័យទាក់ទងអំពីម៉ូដសក់ដែលអតិថិជនពេញចិត្ត',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-07 09:17:04',	'2023-12-07 09:17:04',	NULL),
(123,	3,	'Functional Competency',	'ការកំណត់សម្ភារ ឧបករណ៍ចាប់ម៉ូតសក់',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-07 09:17:56',	'2023-12-07 09:17:56',	NULL),
(124,	3,	'Functional Competency',	'ការប្រាស្រ័យទាក់ទងមុនពេលចាប់ផ្តើមធ្វើម៉ូដជូនអតិថិជន',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-07 09:19:26',	'2023-12-07 09:19:26',	NULL),
(125,	3,	'Functional Competency',	'ការកំណត់ទម្រង់ម៉ូតសក់',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-07 09:20:09',	'2023-12-07 09:20:09',	NULL),
(126,	3,	'Functional Competency',	'ការប្រើប្រាស់សម្ភារ ឧបករណ៍ចាប់ម៉ូតសក់',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-07 09:20:42',	'2023-12-07 09:20:42',	NULL),
(127,	3,	'Functional Competency',	'បច្ចេកទេសចាប់ម៉ូតសក់',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-07 09:33:01',	'2023-12-07 09:33:01',	NULL),
(128,	3,	'Functional Competency',	'ការប្រាស្រ័យទាក់ទង ជាមួយអតិថិជនអំពីទម្រង់ម៉ូតសក់',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-07 09:34:28',	'2023-12-07 09:34:28',	NULL),
(129,	3,	'Functional Competency',	'ការកំណត់ទម្រង់ម៉ូតសក់ជូនអតិថិជន',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-07 09:35:13',	'2023-12-07 09:35:13',	NULL),
(130,	3,	'Functional Competency',	'ការកំណត់សម្ភារ ឧបករណ៍ផ្លុំសក់ ម៉ូដសក់',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-07 09:36:32',	'2023-12-07 09:36:32',	NULL),
(131,	3,	'Functional Competency',	'ការកំណត់សម្ភារ ឧបករណ៍ចាប់ម៉ូតសក់ជូនអតិថិជន',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-07 09:37:29',	'2023-12-07 09:37:29',	NULL),
(132,	3,	'Functional Competency',	'ការប្រើប្រាស់សម្ភារ ឧបករណ៍ផ្លុំសក់ជូនអតិថិជន',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-07 09:38:32',	'2023-12-07 10:38:09',	NULL),
(133,	3,	'Functional Competency',	'ការអានលើសេចក្តីណែនាំផ្សេងៗ',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-07 09:39:35',	'2023-12-07 09:39:35',	NULL),
(134,	3,	'Functional Competency',	'អនុវត្តអនាម័យកន្លែងការងារជាប្រចាំ',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-07 09:40:26',	'2023-12-07 09:40:26',	NULL),
(135,	3,	'Functional Competency',	'អនុវត្តការថែទាំជាប្រចាំ',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-07 09:41:01',	'2023-12-07 09:41:01',	NULL),
(136,	3,	'Functional Competency',	'ការកត់ត្រានិងធ្វើបញ្ជី',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-07 09:41:52',	'2023-12-07 09:41:52',	NULL),
(137,	3,	'Functional Competency',	'ការអានលើសេចក្ដីណែនាំផ្សេងៗ ពិនិត្យស្ថានភាពសម្ភារៈ ឧបករណ៍ និងបរិក្ខារ តាមការណែនាំ',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-07 09:44:46',	'2023-12-07 09:44:46',	NULL),
(138,	3,	'Functional Competency',	'អនុវត្តការថែទាំនិងជូតសម្អាតជាប្រចាំ',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-07 09:45:47',	'2023-12-07 10:37:53',	NULL),
(139,	3,	'Functional Competency',	'ការកត់ត្រានិងធ្វើបញ្ជីលើសម្ភារ ឧបករណ៍ និង បរិក្ខារ',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-07 09:47:13',	'2023-12-07 10:37:36',	NULL),
(140,	3,	'Functional Competency',	'ការអានលើសេចក្ដីណែនាំផ្សេងៗ',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-07 09:49:59',	'2023-12-07 09:49:59',	NULL),
(141,	3,	'Functional Competency',	'អនុវត្តការកំណត់ទីតាំង អនាម័យកន្លែងការងារ',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	8,	'2023-12-07 09:51:12',	'2023-12-07 09:51:12',	NULL),
(142,	3,	'Functional Competency',	'អនុវត្តការថែទាំនិងទុកដាក់ ឧបករណ៍ សម្ភារ និង បរិក្ខាជាប្រចាំ',	'MHC',	1.00,	'h',	1.00,	'h',	NULL,	NULL,	1,	1,	'2023-12-07 09:52:23',	'2023-12-27 10:01:37',	NULL);

DROP TABLE IF EXISTS `lesson_documents`;
CREATE TABLE `lesson_documents` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `lesson_id` bigint(20) NOT NULL,
  `source` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `lesson_documents` (`id`, `lesson_id`, `source`, `created_at`, `updated_at`) VALUES
(4,	11,	'/Project Managemant - week3 Oct-d9cbacec-a269-45cf-b4dd-3d3acf7f44ae.pdf',	'2023-10-25 16:23:48',	'2023-10-25 16:23:48'),
(5,	11,	'/Agenda meeting for 24October 2023-ed765201-d7f1-472d-bed6-8dcb1ed0695b.pdf',	'2023-10-25 16:23:48',	'2023-10-25 16:23:48'),
(6,	11,	'/hd-681aef62-4847-4256-81a6-d0b321c35f33.docx',	'2023-10-25 16:23:48',	'2023-10-25 16:23:48'),
(7,	10,	'/1-Work Sheet 1.2.1-8851763a-447f-46f8-b910-537d236711de.docx',	'2023-10-27 08:55:57',	'2023-10-27 08:55:57'),
(8,	10,	'/1-Information Sheet 1.1.1-54498d30-1ee6-4575-932e-bf61b76c65cb.docx',	'2023-10-27 08:55:57',	'2023-10-27 08:55:57'),
(9,	13,	'/2- Information 1.1.1-4855dbdb-f011-4b58-b586-c0492137e766.docx',	'2023-12-04 11:01:19',	'2023-12-04 11:01:19'),
(10,	13,	'/2- Work Sheet 1.2.1-ecf82a3b-ee8c-4611-9ccb-c90c9fd7d5b8.docx',	'2023-12-04 11:01:19',	'2023-12-04 11:01:19'),
(11,	15,	'/2-​​ Work Sheet 1.2.3-b5e8059f-a79f-403f-98e8-5e3ed849ab90.docx',	'2023-12-04 11:10:43',	'2023-12-04 11:10:43'),
(12,	15,	'/2- Information 1.1.3-950ffebc-041a-4ab9-94b5-6944189644c9.docx',	'2023-12-04 11:10:43',	'2023-12-04 11:10:43'),
(13,	16,	'/2- Information 1.1.4-7d4026d7-8e0c-4689-9657-157c89fb0613.docx',	'2023-12-04 11:11:45',	'2023-12-04 11:11:45'),
(14,	17,	'/2- Information 1.1.5-b5c88faa-0aeb-4861-81ab-ccb2c90c2155.docx',	'2023-12-04 11:12:36',	'2023-12-04 11:12:36'),
(15,	18,	'/2- Information 1.1.1-5491f101-3032-47a9-a36c-b3d9d79ff75c.docx',	'2023-12-04 11:18:40',	'2023-12-04 11:18:40'),
(16,	18,	'/2- Work Sheet 1.2.1-20c883ae-73d9-4d68-9462-4036d385f9da.docx',	'2023-12-04 11:18:40',	'2023-12-04 11:18:40'),
(17,	19,	'/2- Information 1.1.2-15ab3212-7588-48fb-aab2-f2685d6894dd.docx',	'2023-12-04 11:19:54',	'2023-12-04 11:19:54'),
(18,	19,	'/2-​​ Work Sheet 1.2.2-995c9c10-a1de-4b4b-9e8e-092854318f0c.docx',	'2023-12-04 11:19:54',	'2023-12-04 11:19:54'),
(19,	21,	'/3- Information 1.1.1-c2870115-540a-4cab-a557-3526162257b7.docx',	'2023-12-04 11:27:13',	'2023-12-04 11:27:13'),
(20,	21,	'/3- Work Sheet  1.2.1-362a1572-48c4-469a-8dfe-d4eaac52f396.docx',	'2023-12-04 11:27:13',	'2023-12-04 11:27:13'),
(21,	22,	'/3- Information 1.1.2-7984add2-4c09-462c-a2f8-acf6e672baa8.docx',	'2023-12-04 11:28:11',	'2023-12-04 11:28:11'),
(22,	22,	'/3- Work Sheet  1.2.2-2e15c9c5-faf4-4ebd-a7f6-b2d742bdab86.docx',	'2023-12-04 11:28:11',	'2023-12-04 11:28:11'),
(23,	23,	'/2- Information 1.1.3-950ffebc-041a-4ab9-94b5-6944189644c9.docx',	'2023-12-04 11:30:28',	'2023-12-04 11:30:28'),
(24,	23,	'/2-​​ Work Sheet 1.2.3-22245a48-9ffd-4c52-819d-bbce6a17c1a7.docx',	'2023-12-04 11:30:28',	'2023-12-04 11:30:28'),
(25,	24,	'/3- Information 1.1.4-12708b12-752f-4910-83db-dbf17112b36e.docx',	'2023-12-04 11:31:21',	'2023-12-04 11:31:21'),
(26,	24,	'/3- Work Sheet  1.2.4-a5661266-df82-40bc-8b5f-832c629b7abd.docx',	'2023-12-04 11:31:21',	'2023-12-04 11:31:21'),
(27,	25,	'/3- Information 1.1.5-d46b5415-f5d3-4b8c-be09-599c9d0c2e4d.docx',	'2023-12-04 11:32:25',	'2023-12-04 11:32:25'),
(28,	25,	'/3- Work Sheet  1.2.5-e7d93807-3d79-4e47-a26e-9b9902556dd0.docx',	'2023-12-04 11:32:25',	'2023-12-04 11:32:25'),
(29,	26,	'/3- Information 2.1.1-e660af5b-09df-41c7-90c0-59429214d92f.docx',	'2023-12-04 11:40:18',	'2023-12-04 11:40:18'),
(30,	26,	'/3-Work Sheet 2.2.1-38f2dc40-35e9-4482-af1d-dfca88f12b5f.docx',	'2023-12-04 11:40:18',	'2023-12-04 11:40:18'),
(31,	27,	'/3- Information 2.1.2-7346bd19-3791-45b4-864b-b65b62e1e32f.docx',	'2023-12-04 11:41:29',	'2023-12-04 11:41:29'),
(32,	27,	'/3-Work Sheet 2.2.2-c48a5de9-802e-4fb1-84cb-717208accc27.docx',	'2023-12-04 11:41:29',	'2023-12-04 11:41:29'),
(33,	28,	'/3- Information 2.1.3-0c9908da-fc14-4c04-84c3-decf2537399f.docx',	'2023-12-04 11:42:21',	'2023-12-04 11:42:21'),
(34,	28,	'/3-Work Sheet 2.2.3-0e2f308e-3f95-407b-8fa4-4890c50b95a2.docx',	'2023-12-04 11:42:21',	'2023-12-04 11:42:21'),
(35,	29,	'/3- Information 2.1.4-734a863b-2483-4d59-b86f-e22671a35a5f.docx',	'2023-12-04 11:43:16',	'2023-12-04 11:43:16'),
(36,	29,	'/3-Work Sheet 2.2.4-5a9ea39d-3098-405a-8fc4-1c2aefa84301.docx',	'2023-12-04 11:43:16',	'2023-12-04 11:43:16'),
(39,	30,	'/3- Information 3.1.1-ad16f515-2006-44c7-8b02-0d7ea961dace.docx',	'2023-12-04 11:47:59',	'2023-12-04 11:47:59'),
(40,	30,	'/3- Work Sheet  3.2.1-9cd88b04-9679-4192-8763-b2f33c12fc65.docx',	'2023-12-04 11:47:59',	'2023-12-04 11:47:59'),
(41,	31,	'/3- Information 3.1.2-49e02b9b-2182-49c2-ab16-9bd2771e6527.docx',	'2023-12-04 11:50:25',	'2023-12-04 11:50:25'),
(42,	31,	'/3- Work Sheet 3.2.2-bd1d6174-9cdc-4207-abc2-637e6bb43ace.docx',	'2023-12-04 11:50:25',	'2023-12-04 11:50:25'),
(43,	32,	'/3- Information 3.1.3-8a840d11-df69-45a6-b880-19c58128244a.docx',	'2023-12-04 11:51:19',	'2023-12-04 11:51:19'),
(44,	32,	'/3- Work Sheet 3.2.3-ecd35baa-a212-424c-b75a-feda3d0ec3c5.docx',	'2023-12-04 11:51:19',	'2023-12-04 11:51:19'),
(45,	33,	'/3- Information 3.1.4-5bb00152-5b57-4d8c-9a91-836dac3baee1.docx',	'2023-12-04 11:52:25',	'2023-12-04 11:52:25'),
(46,	33,	'/3- Work Sheet 3.2.4-3cd1b6d1-f9cc-4dbf-ba7a-ca9f34f45785.docx',	'2023-12-04 11:52:25',	'2023-12-04 11:52:25'),
(47,	34,	'/3- Information 3.1.5-788ca50d-d087-49cc-94fe-f223f1c5fbee.docx',	'2023-12-04 11:53:41',	'2023-12-04 11:53:41'),
(48,	34,	'/3- Work Sheet 3.2.5-28de39d4-6e86-4763-bddc-7beca9a1e8b7.docx',	'2023-12-04 11:53:41',	'2023-12-04 11:53:41'),
(49,	35,	'/3-Information Sheet 1.1.2-de6b31f6-29b4-4654-b95a-84c3a6bc8000.docx',	'2023-12-04 11:56:32',	'2023-12-04 11:56:32'),
(50,	35,	'/4-Work Sheet From 1.2.2-344e3c6c-a11a-4ae3-a293-35176a84b4a3.docx',	'2023-12-04 11:56:32',	'2023-12-04 11:56:32'),
(51,	36,	'/4- Information 2.1.1-07103396-a337-4bf3-98b8-2f0825c5fb03.docx',	'2023-12-04 13:28:47',	'2023-12-04 13:28:47'),
(52,	36,	'/4- Work Sheet  2.2.1-2592d5ed-c675-4fd5-be4d-98a9ca14ff9b.docx',	'2023-12-04 13:28:47',	'2023-12-04 13:28:47'),
(53,	37,	'/4- Information 2.1.2-61669403-11b5-4d5c-8a2d-738ca3cc9777.docx',	'2023-12-04 13:32:58',	'2023-12-04 13:32:58'),
(54,	37,	'/4- Work Sheet  2.2.2-4610deec-634c-4298-a75d-4e6a608bbf7a.docx',	'2023-12-04 13:32:58',	'2023-12-04 13:32:58'),
(55,	38,	'/4- Information 2.1.3-b5c029b6-1f60-4bd0-9803-a934ab5c6c63.docx',	'2023-12-04 13:33:35',	'2023-12-04 13:33:35'),
(56,	38,	'/4-Work Sheet 2.2.3-f7cfdcf1-2847-4381-a63a-ff1f05a311ab.docx',	'2023-12-04 13:33:35',	'2023-12-04 13:33:35'),
(57,	39,	'/3-Information Sheet 3.1.1-6f01241f-88bb-4dfd-9846-d187ae0e8942.docx',	'2023-12-04 13:35:03',	'2023-12-04 13:35:03'),
(58,	39,	'/3-Work Sheet 3.2.1-ac8495f2-2c09-494e-a66a-a7761b77c7b9.docx',	'2023-12-04 13:35:03',	'2023-12-04 13:35:03'),
(59,	40,	'/3-Work Sheet 3.2.2-31192edc-359f-4a2d-abc6-b4d6b835f86c.docx',	'2023-12-04 13:43:13',	'2023-12-04 13:43:13'),
(60,	40,	'/3-Information Sheet 3.1.2-8eb4f42b-11bb-433a-acc2-67770c1bc932.docx',	'2023-12-04 13:43:13',	'2023-12-04 13:43:13'),
(61,	41,	'/4-Work Sheet 3.2.3-edf6b805-95bb-41d3-af22-e4cde0e79e93.docx',	'2023-12-04 13:44:25',	'2023-12-04 13:44:25'),
(62,	41,	'/3-Information Sheet 3.1.3-2dc69ddd-2c3b-4104-b9a2-5578257d058d.docx',	'2023-12-04 13:44:25',	'2023-12-04 13:44:25'),
(63,	42,	'/3-Information Sheet 3.1.4-76eeb75d-e28a-4208-b421-6746059a0ff6.docx',	'2023-12-04 13:44:58',	'2023-12-04 13:44:58'),
(64,	42,	'/4-Work Sheet 3.2.4-c979b3e5-7090-459e-b378-16fe64b8968c.docx',	'2023-12-04 13:44:58',	'2023-12-04 13:44:58'),
(65,	43,	'/5-Information Sheet 1.1.1-aa56ad4e-185f-4d48-b8ad-5f5b3668f09f.docx',	'2023-12-04 13:46:02',	'2023-12-04 13:46:02'),
(66,	43,	'/5-Work Sheet 1.2.1-18fadb0b-27f5-4e86-8882-b070c094ee17.docx',	'2023-12-04 13:46:02',	'2023-12-04 13:46:02'),
(67,	44,	'/5-Information Sheet 1.1.2-4e9e503a-8191-4a05-8ab6-cefa5156fc63.docx',	'2023-12-04 13:46:54',	'2023-12-04 13:46:54'),
(68,	44,	'/5-Work Sheet 1.2.2-7a180625-3b86-405e-904a-2983d90c80b9.docx',	'2023-12-04 13:46:54',	'2023-12-04 13:46:54'),
(69,	46,	'/3-Information Sheet 2.1.1-7770b960-14f4-4006-9eb6-cfe0b072261f.docx',	'2023-12-04 16:41:15',	'2023-12-04 16:41:15'),
(70,	46,	'/4-Work Sheet From 2.2.1-421f6c32-97c8-4e22-9e47-d44aecd63658.docx',	'2023-12-04 16:41:15',	'2023-12-04 16:41:15'),
(71,	47,	'/3-Information Sheet 2.1.2-8df54882-d456-42f8-8fe5-975df2260334.docx',	'2023-12-04 16:41:59',	'2023-12-04 16:41:59'),
(72,	47,	'/4-Work Sheet From 2.2.2-2c0efcf9-3510-401e-b3a0-fdb8ed7c465b.docx',	'2023-12-04 16:41:59',	'2023-12-04 16:41:59'),
(73,	48,	'/3-Information Sheet 2.1.2-8df54882-d456-42f8-8fe5-975df2260334.docx',	'2023-12-04 16:48:23',	'2023-12-04 16:48:23'),
(74,	48,	'/4-Work Sheet From 2.2.2-2c0efcf9-3510-401e-b3a0-fdb8ed7c465b.docx',	'2023-12-04 16:48:23',	'2023-12-04 16:48:23'),
(75,	49,	'/3-Information Sheet 2.1.3-58de2bd9-610a-4007-a116-2e3a7b76c899.docx',	'2023-12-04 16:49:18',	'2023-12-04 16:49:18'),
(76,	49,	'/4-Work Sheet From 2.2.3-caaf2d9f-d718-45e8-af09-e7cb799abc30.docx',	'2023-12-04 16:49:18',	'2023-12-04 16:49:18'),
(77,	50,	'/3-Information Sheet 2.1.4-a813f4c8-e541-42b4-a0dd-7388aaf7072d.docx',	'2023-12-04 16:50:07',	'2023-12-04 16:50:07'),
(78,	50,	'/4-Work Sheet From 2.2.4-3f530bae-31b5-4698-9937-d3bc068b92ce.docx',	'2023-12-04 16:50:07',	'2023-12-04 16:50:07'),
(79,	51,	'/3-Information Sheet 3.1.1-4fbe8a68-e94e-4706-8844-372c9d236b70.docx',	'2023-12-05 10:59:18',	'2023-12-05 10:59:18'),
(80,	51,	'/4-Work Sheet From 3.2.1-c427313e-91e1-43c2-9fb5-5bd2d628eaa8.docx',	'2023-12-05 10:59:18',	'2023-12-05 10:59:18'),
(81,	52,	'/3-Information Sheet 3.1.2-f8885662-825f-4c81-a946-52a44d0a8214.docx',	'2023-12-05 11:00:29',	'2023-12-05 11:00:29'),
(82,	52,	'/4-Work Sheet From 3.2.2-52449ae2-d5c1-480c-a12b-cac4c51db275.docx',	'2023-12-05 11:00:29',	'2023-12-05 11:00:29'),
(83,	53,	'/6- Information 1.1.1-e51b1d9f-ee72-4431-a820-dc070f5e0d8e.docx',	'2023-12-05 11:03:54',	'2023-12-05 11:03:54'),
(84,	53,	'/6- Work Sheet 1.2.1-d77c781c-1410-4f2c-b585-92275983c292.docx',	'2023-12-05 11:03:54',	'2023-12-05 11:03:54'),
(85,	54,	'/6- Information 1.1.2-b03f1410-0938-4b67-b7ef-9cdd4b81cac3.docx',	'2023-12-05 11:04:45',	'2023-12-05 11:04:45'),
(86,	54,	'/6- Work Sheet 1.2.2-1c5ef63e-204e-41c3-8794-bb617af03997.docx',	'2023-12-05 11:04:45',	'2023-12-05 11:04:45'),
(87,	55,	'/6- Information 1.1.3-04a49406-09ef-41f7-ba7c-5720a6482e85.docx',	'2023-12-05 11:05:35',	'2023-12-05 11:05:35'),
(88,	55,	'/6- Work Sheet 1.2.3-53ea987d-43e2-4bb9-8c9a-04df66f4bcb4.docx',	'2023-12-05 11:05:35',	'2023-12-05 11:05:35'),
(89,	56,	'/6- Information 2.1.1-45275c9f-1a47-45e0-920c-d495076c246f.docx',	'2023-12-05 11:07:28',	'2023-12-05 11:07:28'),
(90,	56,	'/6- Work Sheet 2.2.1-ba150bd2-dc8d-400b-997c-bfc996f75654.docx',	'2023-12-05 11:07:28',	'2023-12-05 11:07:28'),
(91,	57,	'/6- Information 2.1.2-fc584142-3a8c-49c4-9da7-51c582dc2f5a.docx',	'2023-12-05 11:09:06',	'2023-12-05 11:09:06'),
(92,	57,	'/6- Work Sheet 2.2.2​-4a17e574-2b62-4fe3-85d1-d2fdbd648e18.docx',	'2023-12-05 11:09:06',	'2023-12-05 11:09:06'),
(93,	58,	'/6- Information 2.1.3-43e89148-1002-44fa-8f60-38c8702b24e0.docx',	'2023-12-05 11:12:01',	'2023-12-05 11:12:01'),
(94,	58,	'/6- Work Sheet 2.2.3-f89412bb-fda8-4574-b567-dcd54d49db53.docx',	'2023-12-05 11:12:01',	'2023-12-05 11:12:01'),
(95,	59,	'/6- Information 3.1.1-7222983f-978b-4f40-a348-72e0c5f67085.docx',	'2023-12-05 11:14:26',	'2023-12-05 11:14:26'),
(96,	59,	'/6- Work Sheet 3.2.1-9de22e94-2eee-4df9-8c22-ac2c80d57746.docx',	'2023-12-05 11:14:26',	'2023-12-05 11:14:26'),
(97,	60,	'/6- Information 3.1.2-c1d4d21e-b252-4849-a2f1-334599628727.docx',	'2023-12-05 11:16:22',	'2023-12-05 11:16:22'),
(98,	60,	'/6- Work Sheet 3.2.2-3e165912-bad9-4e8d-8059-cb7639c46aad.docx',	'2023-12-05 11:16:22',	'2023-12-05 11:16:22'),
(99,	61,	'/1-Work sheet 1.2.5-e6dffd40-95f7-4144-b738-5c29e940d1db.docx',	'2023-12-05 11:36:10',	'2023-12-05 11:36:10'),
(100,	61,	'/1-Work Sheet 1.2.3-a3d0b90c-4f77-4ab9-8f8e-f0bfd2ffcc5e.docx',	'2023-12-05 11:36:10',	'2023-12-05 11:36:10'),
(101,	62,	'/1-Information Sheet 1.1.1-ebcb9acb-7706-490f-a5d6-fd1d9e0ee8d1.docx',	'2023-12-05 14:34:32',	'2023-12-05 14:34:32'),
(102,	62,	'/1-Work Sheet 1.2.1-4259918d-19e0-491c-bead-1c6737784ced.docx',	'2023-12-05 14:34:32',	'2023-12-05 14:34:32'),
(103,	63,	'/1-Information Sheet 1.1.2-4eee6980-987b-4f80-b64d-226bdaf62fce.docx',	'2023-12-05 14:36:13',	'2023-12-05 14:36:13'),
(104,	63,	'/1-Work Sheet 1.2.2-6e8ecd15-0caa-4c69-b80f-24c5a66f1011.docx',	'2023-12-05 14:36:13',	'2023-12-05 14:36:13'),
(105,	64,	'/1-Information Sheet 1.1.3-27664a4e-fb09-4382-8d76-5f0846def60f.docx',	'2023-12-05 14:37:59',	'2023-12-05 14:37:59'),
(106,	64,	'/1-Work Sheet 1.2.3-a3d0b90c-4f77-4ab9-8f8e-f0bfd2ffcc5e.docx',	'2023-12-05 14:37:59',	'2023-12-05 14:37:59'),
(107,	66,	'/1-Information sheet 1.1.5-69a29256-401b-4e3e-9bc8-4c3197f39954.docx',	'2023-12-05 14:40:44',	'2023-12-05 14:40:44'),
(108,	66,	'/1-Work sheet 1.2.5-e6dffd40-95f7-4144-b738-5c29e940d1db.docx',	'2023-12-05 14:40:44',	'2023-12-05 14:40:44'),
(109,	68,	'/1-Information Sheet 2.1.2-f60b191d-f988-43d7-b65f-891daa7cf2c6.docx',	'2023-12-05 14:50:53',	'2023-12-05 14:50:53'),
(110,	68,	'/1-Worksheet 2.2.2-685ad968-3512-424b-9f1b-4b9145b05d0d.docx',	'2023-12-05 14:50:53',	'2023-12-05 14:50:53'),
(111,	69,	'/1-Information Sheet 2.1.3-e53255ba-5e6a-4b69-b31a-e57aa60848b1.docx',	'2023-12-05 14:52:29',	'2023-12-05 14:52:29'),
(112,	69,	'/1-Worksheet 2.2.3-5c671ec7-9430-42f4-abbd-325165147e0f.docx',	'2023-12-05 14:52:29',	'2023-12-05 14:52:29'),
(113,	70,	'/1-Information Sheet 3.1.1-46f01732-4698-482e-b813-0eae3e90abfe.docx',	'2023-12-05 14:58:47',	'2023-12-05 14:58:47'),
(114,	70,	'/1-Worksheet 3.2.1-93578cec-e762-4bb3-9126-7c8cfd1bfa49.docx',	'2023-12-05 14:58:47',	'2023-12-05 14:58:47'),
(115,	71,	'/1-Information Sheet 3.1.2-084eafba-8957-489b-b9d2-c7f15210f61d.docx',	'2023-12-05 15:00:27',	'2023-12-05 15:00:27'),
(116,	71,	'/1-Worksheet 3.2.2-e5dcbf46-328a-4d2c-a5f9-62e7b8d6adcb.docx',	'2023-12-05 15:00:27',	'2023-12-05 15:00:27'),
(117,	72,	'/1-Information Sheet 3.1.3-7ccc393a-210f-480d-87b1-5d499c346116.docx',	'2023-12-05 15:01:37',	'2023-12-05 15:01:37'),
(118,	72,	'/1-Worksheet 3.2.3-18aefe8a-a81a-4d40-bf25-6fdfa12fcbef.docx',	'2023-12-05 15:01:37',	'2023-12-05 15:01:37'),
(119,	73,	'/1.Information Sheet 1.1.1-fbbb128c-c454-4cb2-b433-c1c8e17c2ca4.docx',	'2023-12-05 15:10:47',	'2023-12-05 15:10:47'),
(120,	73,	'/1.Worksheet 1.2.1-119954c0-3b76-4654-ae28-59b158081b9f.docx',	'2023-12-05 15:10:47',	'2023-12-05 15:10:47'),
(121,	74,	'/1.Information Sheet 1.1.2-2f2dbd87-fe80-4f8f-8de7-130aadfa3ec0.docx',	'2023-12-05 15:12:40',	'2023-12-05 15:12:40'),
(122,	74,	'/1.Worksheet 1.2.2-3f75a013-c435-4e81-a18d-04f51a2cc900.docx',	'2023-12-05 15:12:40',	'2023-12-05 15:12:40'),
(123,	75,	'/1.Information Sheet 1.1.3-32a8062a-4250-45dd-ad6b-f42b717435e2.docx',	'2023-12-05 15:13:13',	'2023-12-05 15:13:13'),
(124,	75,	'/1.WorkSheet 1.2.3-481faafe-f9aa-43a6-9ec9-81670f17fb9a.docx',	'2023-12-05 15:13:13',	'2023-12-05 15:13:13'),
(125,	76,	'/1.Information Sheet 1.1.4-c744cd16-f33a-4633-9271-eb71f891aac3.docx',	'2023-12-05 15:14:17',	'2023-12-05 15:14:17'),
(126,	76,	'/1.Worksheet 1.2.4-c7490d51-9ed3-4b7d-bfec-869dddbba9d0.docx',	'2023-12-05 15:14:17',	'2023-12-05 15:14:17'),
(127,	77,	'/2. Information Sheet 2.1.1-1baff585-fd17-4ad4-a928-0f909c2ede7e.docx',	'2023-12-05 15:18:28',	'2023-12-05 15:18:28'),
(128,	77,	'/2.Worksheet 2.2.1-ad05b6b8-756e-45c1-8894-193c79bda046.docx',	'2023-12-05 15:18:28',	'2023-12-05 15:18:28'),
(131,	79,	'/2. Information Sheet 2.1.3-5e8c346a-f347-4f12-9289-79b0bf8296e4.docx',	'2023-12-05 15:26:32',	'2023-12-05 15:26:32'),
(132,	79,	'/2.Worksheet 2.2.3-8a06cd68-4031-48c7-aed9-febec8904081.docx',	'2023-12-05 15:26:32',	'2023-12-05 15:26:32'),
(133,	80,	'/2. Inoformation Sheet 2.1.4-808f752d-5f99-409e-9905-128b66b33c73.docx',	'2023-12-05 15:37:02',	'2023-12-05 15:37:02'),
(134,	80,	'/2.Worksheet 2.2.4-09261681-1114-4c62-932c-47d0db57819b.docx',	'2023-12-05 15:37:02',	'2023-12-05 15:37:02'),
(135,	81,	'/3. Information Sheet 3.1.1-6d0d980f-a4d1-4c1b-9b7d-128f56ae5304.docx',	'2023-12-05 15:40:36',	'2023-12-05 15:40:36'),
(136,	81,	'/3.Worksheet 3.2.1-7fb5c7c3-b38c-4d23-8923-f3f9be4307f2.docx',	'2023-12-05 15:40:36',	'2023-12-05 15:40:36'),
(139,	83,	'/3. Information Sheet 3.1.3-8c6bcc64-a5d0-4000-b1c9-3cc9ca2d58e4.docx',	'2023-12-05 15:44:13',	'2023-12-05 15:44:13'),
(140,	83,	'/3.Worksheet 3.2.3-d4ef51ef-4b41-4720-ba4c-787e1b87c934.docx',	'2023-12-05 15:44:13',	'2023-12-05 15:44:13'),
(141,	84,	'/3. Information Sheet 1.1.1-5e2b8e19-8fad-4ce8-8764-975d9be4a16b.docx',	'2023-12-05 16:16:34',	'2023-12-05 16:16:34'),
(142,	84,	'/3. Work Sheet 1.2.1-6fb3210a-82fd-47c6-aeb9-d277d5fa2130.docx',	'2023-12-05 16:16:34',	'2023-12-05 16:16:34'),
(143,	87,	'/2. Information Sheet 2.1.1-2a346adb-f5db-4522-809b-fa6095485010.docx',	'2023-12-05 16:19:55',	'2023-12-05 16:19:55'),
(144,	87,	'/2.Worksheet 2.2.1-b06e46be-793d-4e38-87b3-1e623e97a136.docx',	'2023-12-05 16:19:55',	'2023-12-05 16:19:55'),
(145,	88,	'/2. Information Sheet 2.1.2-d910d85e-797b-4d0a-a5b4-2d03f4bb1300.docx',	'2023-12-05 16:20:57',	'2023-12-05 16:20:57'),
(146,	88,	'/2.Worksheet 2.2.2-54da5b01-4b57-4f90-9c2a-dedfdaef25ca.docx',	'2023-12-05 16:20:57',	'2023-12-05 16:20:57'),
(147,	89,	'/2. Information Sheet 2.1.3-bec22866-fa92-4892-abd4-f207935244b7.docx',	'2023-12-05 16:21:36',	'2023-12-05 16:21:36'),
(148,	89,	'/2.Worksheet 2.2.3-485d3950-c332-43b2-8cc5-7de6017c85d8.docx',	'2023-12-05 16:21:36',	'2023-12-05 16:21:36'),
(149,	91,	'/3. Information Sheet 3.1.1-5c3a3ab7-e924-424e-a54e-51a6a7a9fc5e.docx',	'2023-12-05 16:24:19',	'2023-12-05 16:24:19'),
(150,	91,	'/3.Worksheet 3.2.1-5610424b-338f-4f70-b44d-fcb0bdce15db.docx',	'2023-12-05 16:24:19',	'2023-12-05 16:24:19'),
(151,	92,	'/3. Information Sheet 3.1.2-57768830-299c-40f7-9dd3-218afce28458.docx',	'2023-12-05 16:25:59',	'2023-12-05 16:25:59'),
(152,	92,	'/3.Worksheet 3.2.2-ea0903c3-b784-4b13-8bcd-26504e17b873.docx',	'2023-12-05 16:25:59',	'2023-12-05 16:25:59'),
(153,	93,	'/3. Information Sheet 3.1.3-24190f01-a3ad-45a5-acfd-25bceed9cb31.docx',	'2023-12-05 16:26:54',	'2023-12-05 16:26:54'),
(154,	93,	'/3.Worksheet 3.2.3-4735189b-5e69-4055-afcc-e3e12f7dfbaf.docx',	'2023-12-05 16:26:54',	'2023-12-05 16:26:54'),
(155,	82,	'/3. Information Sheet 3.1.2-45905929-6e20-4bb9-a7c7-70b8d8ab6adf.docx',	'2023-12-06 08:46:04',	'2023-12-06 08:46:04'),
(156,	82,	'/3.Worksheet 3.2.2-e6bec11f-4cb0-414a-8f2b-e67e3ef4482b.docx',	'2023-12-06 08:46:04',	'2023-12-06 08:46:04'),
(157,	78,	'/2. Information Sheet 2.1.2-3aaf9f3c-d448-4b38-b323-9272f30f8f46.docx',	'2023-12-06 08:46:20',	'2023-12-06 08:46:20'),
(158,	78,	'/2.Worksheet 2.2.2-b170eda3-5c32-49ca-8cbc-eaeed07661fb.docx',	'2023-12-06 08:46:20',	'2023-12-06 08:46:20'),
(159,	94,	'/4-Information Sheet 1.1.1-1b35931e-3877-4f30-9758-6f5b11af0561.docx',	'2023-12-06 13:17:12',	'2023-12-06 13:17:12'),
(160,	94,	'/4-Work Sheet 1.2.1-be356891-6370-4389-a394-61a9eb3f9d75.docx',	'2023-12-06 13:17:12',	'2023-12-06 13:17:12'),
(161,	95,	'/4-Information Sheet 1.1.2-74fd27ec-587b-43d0-b866-aa4914f56bbb.docx',	'2023-12-06 13:17:57',	'2023-12-06 13:17:57'),
(162,	95,	'/4-Work Sheet 1.2.2-729ad266-dfbd-4a3a-a252-6a7cfbaa9ce6.docx',	'2023-12-06 13:17:57',	'2023-12-06 13:17:57'),
(163,	96,	'/4-Information Sheet 1.1.3-fc602639-ade2-4bbf-986c-12ac7b6b32fa.docx',	'2023-12-06 13:18:45',	'2023-12-06 13:18:45'),
(164,	96,	'/4-Work Sheet 1.2.3-7608ce32-d62a-4d58-a716-628f781f7fc5.docx',	'2023-12-06 13:18:45',	'2023-12-06 13:18:45'),
(165,	97,	'/4-Information Sheet 1.1.4-ef05d21b-35af-4e3d-a1bd-cb139e98f88a.docx',	'2023-12-06 13:20:16',	'2023-12-06 13:20:16'),
(166,	97,	'/4-Work Sheet 1.2.4-1bb1823f-79ad-4e33-ba8f-a7f474bdc568.docx',	'2023-12-06 13:20:16',	'2023-12-06 13:20:16'),
(167,	98,	'/4- Information Sheet 2.1.1-ec32ecb6-ef16-441b-842a-1dbea41e9842.docx',	'2023-12-06 13:22:14',	'2023-12-06 13:22:14'),
(168,	98,	'/4- Worksheet 2.2.1-547ba216-011f-4aff-ad74-1828fef8cea4.docx',	'2023-12-06 13:22:14',	'2023-12-06 13:22:14'),
(169,	99,	'/4- Information Sheet 2.1.2-46e697f9-82cb-46dc-9687-b51b7716af66.docx',	'2023-12-06 13:23:03',	'2023-12-06 13:23:03'),
(170,	99,	'/4- Worksheet 2.2.2-7c250664-d033-4fc2-a9d0-4f0483929a1d.docx',	'2023-12-06 13:23:03',	'2023-12-06 13:23:03'),
(171,	100,	'/4- Information Sheet 2.1.3-d0966ea8-07d0-4fa4-9c9e-03d92855aa1f.docx',	'2023-12-06 13:23:50',	'2023-12-06 13:23:50'),
(172,	100,	'/4- Worksheet 2.2.3-a30764a6-f675-4a9e-ab33-228ba9a1eebb.docx',	'2023-12-06 13:23:50',	'2023-12-06 13:23:50'),
(173,	101,	'/4- Information Sheet 2.1.4-ad6c580d-7748-438b-86b6-5aaadf7030c5.docx',	'2023-12-06 13:24:34',	'2023-12-06 13:24:34'),
(174,	101,	'/4- Worksheet 2.2.4-b2286447-1d92-4794-a3a5-5fcc394c5fe1.docx',	'2023-12-06 13:24:34',	'2023-12-06 13:24:34'),
(175,	102,	'/4- Information Sheet 2.1.5-8e4653b6-29e1-4dc6-828d-c92c125db0b2.docx',	'2023-12-06 13:46:45',	'2023-12-06 13:46:45'),
(176,	102,	'/4- Worksheet 2.2.5-8c4d74bd-f748-48dc-9e25-d74e03837c05.docx',	'2023-12-06 13:46:45',	'2023-12-06 13:46:45'),
(177,	103,	'/4- Information Sheet 3.1.1-2567964c-8e2b-4ec3-95db-a2d92cfa9a28.docx',	'2023-12-06 13:54:45',	'2023-12-06 13:54:45'),
(178,	103,	'/4- Worksheet 3.2.1-0680855a-fd68-4881-83b5-40a356ee8bfd.docx',	'2023-12-06 13:54:45',	'2023-12-06 13:54:45'),
(179,	104,	'/4- Information Sheet 3.1.2-6c47768b-a267-4195-ba2d-4ee094b92c90.docx',	'2023-12-06 13:56:03',	'2023-12-06 13:56:03'),
(180,	104,	'/4- Worksheet 3.2.2-9a6b7ae1-30f7-478a-a5f7-fd5f9e3276cd.docx',	'2023-12-06 13:56:03',	'2023-12-06 13:56:03'),
(181,	105,	'/4- Information Sheet 3.1.3-8b878eed-63ba-4d87-8feb-792a17c01ca8.docx',	'2023-12-06 13:57:07',	'2023-12-06 13:57:07'),
(182,	105,	'/4- Worksheet 3.2.3-abc0d0a6-4904-4f79-b97b-73cd2edd52c9.docx',	'2023-12-06 13:57:07',	'2023-12-06 13:57:07'),
(183,	106,	'/5-Information Sheet 1.1.1-08a688c2-605e-4aa1-b885-7e3d9eb2cf87.docx',	'2023-12-06 14:01:58',	'2023-12-06 14:01:58'),
(184,	106,	'/5-Work Sheet From 1.2.1-7ab1a385-f197-40dc-b78b-5f0027ed9647.docx',	'2023-12-06 14:01:58',	'2023-12-06 14:01:58'),
(185,	107,	'/5-Information Sheet 1.1.2-8700a6af-e74c-43c8-b540-998ec7039132.docx',	'2023-12-06 14:06:40',	'2023-12-06 14:06:40'),
(186,	107,	'/5-Work Sheet From 1.2.2-55a41c11-9550-44a4-bb4d-730d2e51aea5.docx',	'2023-12-06 14:06:40',	'2023-12-06 14:06:40'),
(187,	108,	'/5-Information Sheet 1.1.3-070a8e46-802c-49b9-ae9f-97df015a9860.docx',	'2023-12-06 14:13:05',	'2023-12-06 14:13:05'),
(188,	108,	'/5-Work Sheet From 1.2.3-07ff4f08-cd8d-45d8-8303-9ef9d322e1e3.docx',	'2023-12-06 14:13:05',	'2023-12-06 14:13:05'),
(191,	110,	'/5-Information Sheet 2.1.2-975121b3-58fa-4e4e-a5a4-1de16183e5a7.docx',	'2023-12-06 14:17:41',	'2023-12-06 14:17:41'),
(192,	110,	'/5-Work Sheet From 2.2.2-d7688dd3-6ef6-46c3-99fc-608cf82c2cea.docx',	'2023-12-06 14:17:41',	'2023-12-06 14:17:41'),
(193,	111,	'/5-Information Sheet 2.1.3-db46e049-6880-490a-9015-98e42a7e149a.docx',	'2023-12-06 14:20:03',	'2023-12-06 14:20:03'),
(194,	111,	'/5-Work Sheet From 2.2.3-04261040-ed36-4cc5-a1e8-56aa0250a299.docx',	'2023-12-06 14:20:03',	'2023-12-06 14:20:03'),
(195,	109,	'/5-Information Sheet 2.1.1-2707110e-9329-4738-bc75-c8fce6055a16.docx',	'2023-12-06 16:20:21',	'2023-12-06 16:20:21'),
(196,	109,	'/5-Work Sheet From 2.2.1-16cbdb7c-a397-4485-8a30-81f9e1237c81.docx',	'2023-12-06 16:20:21',	'2023-12-06 16:20:21'),
(197,	112,	'/3-Information Sheet 3.1.1-d10da102-e74a-4759-a2cd-d672fc4d751e.docx',	'2023-12-07 09:05:47',	'2023-12-07 09:05:47'),
(198,	112,	'/4-Work Sheet From 3.2.1-ecc33265-10bb-4294-8ade-781483665351.docx',	'2023-12-07 09:05:47',	'2023-12-07 09:05:47'),
(199,	113,	'/3-Information Sheet 3.1.2-608aafd8-e5b5-4aee-96b8-83f1d25c72f2.docx',	'2023-12-07 09:07:28',	'2023-12-07 09:07:28'),
(200,	113,	'/4-Work Sheet From 3.2.2-e7424a02-0d46-4fe3-beee-18d3f778e694.docx',	'2023-12-07 09:07:28',	'2023-12-07 09:07:28'),
(201,	114,	'/3-Information Sheet 3.1.3-90cb06da-00b2-4dc6-bc8a-c244fb44804d.docx',	'2023-12-07 09:08:17',	'2023-12-07 09:08:17'),
(202,	114,	'/4-Work Sheet From 3.2.3-a0a9dd4e-6457-4511-9fab-2b285567e8a8.docx',	'2023-12-07 09:08:17',	'2023-12-07 09:08:17'),
(203,	115,	'/3-Information Sheet 3.1.4-c00614e2-0adf-4efa-afab-fd4017ae7ea0.docx',	'2023-12-07 09:09:56',	'2023-12-07 09:09:56'),
(204,	115,	'/4-Work Sheet From 3.2.4-66795c6e-e00e-4eab-b952-2eaeb8fbbe64.docx',	'2023-12-07 09:09:56',	'2023-12-07 09:09:56'),
(205,	116,	'/4-Work Sheet From 3.2.5-daf9073a-6c00-4245-b19b-71b0be4f1cec.docx',	'2023-12-07 09:11:21',	'2023-12-07 09:11:21'),
(206,	117,	'/3-Information Sheet 4.1.1-b50ff1f4-0df5-449c-927b-8a19759ba158.docx',	'2023-12-07 09:12:10',	'2023-12-07 09:12:10'),
(207,	117,	'/4-Work Sheet From 4.2.1-ea32eac3-07ba-4828-ab98-c55904c31212.docx',	'2023-12-07 09:12:10',	'2023-12-07 09:12:10'),
(208,	118,	'/3-Information Sheet 4.1.2-0ed6dd92-e576-4f91-a3a5-2e8c871957fb.docx',	'2023-12-07 09:13:00',	'2023-12-07 09:13:00'),
(209,	118,	'/4-Work Sheet From 4.2.2-0234a477-b94e-4164-a460-0649237a09e1.docx',	'2023-12-07 09:13:00',	'2023-12-07 09:13:00'),
(210,	119,	'/3-Information Sheet 4.1.3-f3fe637d-d58e-4000-84dd-c091076941e2.docx',	'2023-12-07 09:13:39',	'2023-12-07 09:13:39'),
(211,	119,	'/4-Work Sheet From 4.2.3-fa26325a-4d4c-42e7-b54c-502031bb252c.docx',	'2023-12-07 09:13:39',	'2023-12-07 09:13:39'),
(212,	120,	'/6-Information Sheet 1.1.1-01b3cb25-c926-4e50-bd39-e86608180aab.docx',	'2023-12-07 09:15:06',	'2023-12-07 09:15:06'),
(213,	120,	'/6-Work Sheet 1.2.1-90c21653-98b1-4747-99db-cc6d53d1f589.docx',	'2023-12-07 09:15:06',	'2023-12-07 09:15:06'),
(214,	121,	'/6-Information Sheet 1.1.2-96c66809-b61b-4bb2-8bd7-0861bb359ad9.docx',	'2023-12-07 09:15:46',	'2023-12-07 09:15:46'),
(215,	121,	'/6-Work Sheet 1.2.2-032192ec-091d-45a7-b19f-d75708d61476.docx',	'2023-12-07 09:15:46',	'2023-12-07 09:15:46'),
(216,	122,	'/6-Information Sheet​ 1.1.4-82ef39b7-0d14-48df-b970-78c552d77f58.docx',	'2023-12-07 09:17:04',	'2023-12-07 09:17:04'),
(217,	122,	'/6-Work Sheet 1.2.4-d1499d00-b28a-4e49-af33-2286a56f6bc9.docx',	'2023-12-07 09:17:04',	'2023-12-07 09:17:04'),
(218,	123,	'/6-Information Sheet 2.1.1-f94d8bee-51d5-434f-b198-f72ce80b2937.docx',	'2023-12-07 09:17:56',	'2023-12-07 09:17:56'),
(219,	123,	'/6-Work Sheet 2.2.1-3425d3ec-344e-4375-9d19-92f8d7a274f8.docx',	'2023-12-07 09:17:56',	'2023-12-07 09:17:56'),
(220,	124,	'/6-Information Sheet 1.1.2-96c66809-b61b-4bb2-8bd7-0861bb359ad9.docx',	'2023-12-07 09:19:26',	'2023-12-07 09:19:26'),
(221,	124,	'/6-Work Sheet 1.2.2-032192ec-091d-45a7-b19f-d75708d61476.docx',	'2023-12-07 09:19:26',	'2023-12-07 09:19:26'),
(222,	125,	'/6-Information Sheet 2.1.3-09d39102-6482-4da3-b0eb-b330113148f6.docx',	'2023-12-07 09:20:09',	'2023-12-07 09:20:09'),
(223,	125,	'/6-Work Sheet 2.2.3-27348858-39e5-4e50-8480-a45806d80c23.docx',	'2023-12-07 09:20:09',	'2023-12-07 09:20:09'),
(224,	126,	'/6-Information Sheet 2.1.4-8bac4764-96df-4a88-b8df-8d3f0b33834e.docx',	'2023-12-07 09:20:42',	'2023-12-07 09:20:42'),
(225,	126,	'/6-Work Sheet 2.2.4-bad00347-bc17-4fb4-9631-575388c51f7f.docx',	'2023-12-07 09:20:42',	'2023-12-07 09:20:42'),
(226,	127,	'/6-Information Sheet 2.1.5-b3b932f8-db7f-4c6a-881c-29502b2a6c0f.docx',	'2023-12-07 09:33:01',	'2023-12-07 09:33:01'),
(227,	127,	'/6-Work Sheet 2.2.5-44f2f6fe-50d4-4dee-82c6-77d87bdd1186.docx',	'2023-12-07 09:33:01',	'2023-12-07 09:33:01'),
(228,	128,	'/6-Information Sheet 3.1.1-d006572f-585b-4163-b051-20cd09123bb6.docx',	'2023-12-07 09:34:28',	'2023-12-07 09:34:28'),
(229,	128,	'/6-Work Sheet 3.2.1-bede54f2-f33a-47f1-9c13-ba306d147bc6.docx',	'2023-12-07 09:34:28',	'2023-12-07 09:34:28'),
(230,	129,	'/6-Information Sheet 3.1.2-8c6c2099-bc3b-4603-9fbd-c0e67021c494.docx',	'2023-12-07 09:35:13',	'2023-12-07 09:35:13'),
(231,	129,	'/6-Work Sheet 3.2.2-1cb64049-1730-4586-bcdc-87fb3c78d965.docx',	'2023-12-07 09:35:13',	'2023-12-07 09:35:13'),
(232,	130,	'/6. Information Sheet 4.1.1-eb644772-c440-4378-bb84-f3f03661d914.docx',	'2023-12-07 09:36:32',	'2023-12-07 09:36:32'),
(233,	130,	'/6. WorkSheet 4.2.1-6c1f6f80-b79e-4685-99ce-0624c4585e22.docx',	'2023-12-07 09:36:32',	'2023-12-07 09:36:32'),
(234,	131,	'/6. Information Sheet 4.1.2-3a80dbb5-2ec7-4f56-aa61-7ea789c44d40.docx',	'2023-12-07 09:37:29',	'2023-12-07 09:37:29'),
(235,	131,	'/6. Worksheet 4.2.2-98a1e45e-cc21-4a29-a704-cf02c7b7157d.docx',	'2023-12-07 09:37:29',	'2023-12-07 09:37:29'),
(236,	133,	'/7-Information Sheet 1.1.1-b3c4c4d0-270e-483f-9abf-3fa807529e62.docx',	'2023-12-07 09:39:35',	'2023-12-07 09:39:35'),
(237,	133,	'/7-Work Sheet From 1.2.1-f8a0bedd-5981-4c87-8840-1bcb3f867294.docx',	'2023-12-07 09:39:35',	'2023-12-07 09:39:35'),
(238,	134,	'/7-Information Sheet 1.1.2-02ba6689-758d-4a85-8430-7524c39e0680.docx',	'2023-12-07 09:40:26',	'2023-12-07 09:40:26'),
(239,	134,	'/7-Work Sheet From 1.2.2-da338c83-6c6a-49a4-94d8-2772024a8601.docx',	'2023-12-07 09:40:26',	'2023-12-07 09:40:26'),
(240,	135,	'/7-Information Sheet 1.1.3-b1381e7e-4c24-47c5-b94c-60dcfaf97de8.docx',	'2023-12-07 09:41:01',	'2023-12-07 09:41:01'),
(241,	135,	'/7-Work Sheet From 1.2.3-512abda0-653f-408b-be26-8a951b49ef29.docx',	'2023-12-07 09:41:01',	'2023-12-07 09:41:01'),
(242,	136,	'/7- Information Sheet 2.1.1-e431a3f6-a2bc-4ea2-adc8-801823987d2f.docx',	'2023-12-07 09:41:52',	'2023-12-07 09:41:52'),
(243,	136,	'/7- Worksheet 2.2.1-33c94a1c-cee4-4469-8bb0-3f19ba499a03.docx',	'2023-12-07 09:41:52',	'2023-12-07 09:41:52'),
(244,	137,	'/7- Information Sheet 2.1.2-bd1dd318-f2c4-4154-8cbf-fe3426019945.docx',	'2023-12-07 09:44:46',	'2023-12-07 09:44:46'),
(245,	137,	'/7- Worksheet 2.2.2-7eca889a-037e-4e40-ba22-3125f7fcbaf3.docx',	'2023-12-07 09:44:46',	'2023-12-07 09:44:46'),
(248,	140,	'/7-Information Sheet 3.1.3-ee68c01d-fc44-4127-a9d2-7f58621ef20b.docx',	'2023-12-07 09:49:59',	'2023-12-07 09:49:59'),
(249,	140,	'/7-Work Sheet From 3.2.3-77fe674e-acd2-49ba-ad0e-6043ff5fbeba.docx',	'2023-12-07 09:49:59',	'2023-12-07 09:49:59'),
(250,	141,	'/7-Information Sheet 3.1.3-ee68c01d-fc44-4127-a9d2-7f58621ef20b.docx',	'2023-12-07 09:51:12',	'2023-12-07 09:51:12'),
(251,	141,	'/7-Work Sheet From 3.2.3-77fe674e-acd2-49ba-ad0e-6043ff5fbeba.docx',	'2023-12-07 09:51:12',	'2023-12-07 09:51:12'),
(254,	139,	'/7-Information Sheet 3.1.1-5cf981a8-a214-41a8-8edb-f1c926c3a6aa.docx',	'2023-12-07 10:37:36',	'2023-12-07 10:37:36'),
(255,	139,	'/7-Work Sheet From 3.2.1-09fcbd3b-9aba-4b16-ae5f-d8e1743d25b0.docx',	'2023-12-07 10:37:36',	'2023-12-07 10:37:36'),
(258,	142,	'/7-Information Sheet 3.1.4-7bb336d1-cea7-40fb-8c92-ac6990743ef5.docx',	'2023-12-27 10:01:37',	'2023-12-27 10:01:37'),
(259,	142,	'/7-Work Sheet From 3.2.4-eb574337-2df3-47be-9943-a77a4c3bfa9f.docx',	'2023-12-27 10:01:37',	'2023-12-27 10:01:37');

DROP TABLE IF EXISTS `lesson_occupations`;
CREATE TABLE `lesson_occupations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `lesson_occupations` (`id`, `name`, `status`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1,	'Nial Dressing',	1,	'2022-12-28 07:17:29',	'2022-12-31 02:23:45',	NULL),
(2,	'Hair Dressing',	1,	'2022-12-30 09:09:51',	'2022-12-31 02:23:13',	NULL),
(3,	'Man hiar cut',	1,	'2022-12-31 02:23:53',	'2022-12-31 02:23:53',	NULL),
(4,	'Edit Nial Dressing',	2,	'2023-01-09 14:55:35',	'2023-01-09 14:56:59',	NULL),
(5,	'Occupation for dev',	1,	'2023-01-22 13:58:30',	'2023-05-05 13:54:28',	NULL),
(6,	'Triple coloring smoke edited',	2,	'2023-05-04 19:39:37',	'2023-05-04 19:44:17',	NULL),
(7,	'Hair Color',	1,	'2023-06-27 15:51:10',	'2023-06-27 15:51:10',	NULL),
(8,	'Beauty',	1,	'2023-11-25 09:36:12',	'2023-11-25 09:36:12',	NULL);

DROP TABLE IF EXISTS `migrations`;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
(1,	'2014_10_12_000000_create_users_table',	1),
(2,	'2019_12_14_000001_create_personal_access_tokens_table',	1),
(3,	'2022_02_21_101926_create_permission_tables',	1),
(4,	'2022_02_22_083452_create_module_permissions_table',	1),
(5,	'2022_05_10_134009_create_file_managers_table',	1),
(6,	'2022_05_10_134254_create_folders_table',	1),
(7,	'2022_06_20_135239_create_fcm_tokens_table',	1),
(8,	'2022_12_26_171425_create_pages_table',	1),
(9,	'2022_12_27_091032_create_staffs_table',	1),
(10,	'2022_12_27_091516_create_staff_types_table',	1),
(11,	'2022_12_27_091631_create_students_table',	1),
(12,	'2022_12_27_092451_create_education_levels_table',	1),
(13,	'2022_12_27_092615_create_class_statuses_table',	1),
(14,	'2022_12_27_092722_create_class_levels_table',	1),
(15,	'2022_12_27_092828_create_classes_table',	1),
(16,	'2022_12_27_094928_create_class_types_table',	1),
(17,	'2022_12_27_095113_create_lessons_table',	1),
(18,	'2022_12_27_095603_create_shifts_table',	1),
(19,	'2022_12_27_095705_create_study_scores_table',	1),
(20,	'2022_12_27_095816_create_student_classes_table',	1),
(21,	'2022_12_27_095936_create_class_occupations_table',	1),
(22,	'2022_12_27_100101_create_class_structure_programs_table',	1),
(23,	'2022_12_27_100453_create_class_allow_users_table',	1),
(24,	'2022_12_27_100557_create_lesson_occupations_table',	1),
(25,	'2022_12_27_100726_create_qualified_statuses_table',	1),
(26,	'2022_12_27_101317_create_student_lesson_scores_table',	1),
(27,	'2022_12_27_101431_create_class_images_table',	1),
(28,	'2022_12_27_101635_create_internship_places_table',	1),
(29,	'2022_12_27_102159_create_structure_programs_table',	1),
(30,	'2022_12_27_102421_create_attendance_status_table',	1),
(31,	'2022_12_27_102823_create_student_groups_table',	1),
(32,	'2022_12_27_102921_create_student_scores_table',	1),
(33,	'2022_12_27_103123_create_exam_types_table',	1),
(34,	'2022_12_27_103240_create_attendances_table',	1),
(35,	'2022_12_27_103429_create_groups_table',	1),
(36,	'2022_12_27_103615_create_exam_candidates_table',	1),
(37,	'2022_12_27_103730_create_study_notes_table',	1),
(38,	'2022_12_27_104050_create_student_intern_places_table',	1),
(39,	'2022_12_27_104258_create_exam_controls_table',	1),
(40,	'2022_12_27_104452_create_exam_subjects_table',	1),
(41,	'2022_12_27_104645_create_exam_scores_table',	1),
(42,	'2022_12_27_104805_create_exam_answer_sheets_table',	1),
(43,	'2022_12_27_110043_create_contacts_table',	1),
(44,	'2022_12_27_110101_create_slides_table',	1),
(48,	'2023_04_12_143327_create_contact_table',	5),
(49,	'2023_04_12_161431_create_course_table',	6),
(51,	'2023_04_13_082104_create_question_table',	8),
(55,	'2023_04_13_093231_create_gallery_table',	12),
(57,	'2023_04_17_161759_create_gallery_album',	14),
(59,	'2023_04_17_161941_create_training_video_category',	16),
(61,	'2023_04_17_165558_create_user_table_feedback',	18),
(63,	'2023_04_12_143349_create_about_table',	20),
(64,	'2023_04_12_143412_create_about_child_table',	21),
(65,	'2023_04_12_142543_create_trainer_table',	22),
(66,	'2023_04_12_211549_create_partner_table',	23),
(67,	'2023_04_13_093258_create_video_table',	24),
(68,	'2023_04_13_115046_create_work_day_table',	25),
(69,	'2023_04_17_161833_create_training_video_table',	26),
(70,	'2023_04_17_163957_create_slide_table',	27),
(71,	'2023_04_17_175257_create_qoute_table',	28),
(72,	'2023_04_27_153946_create_cover_table',	29),
(73,	'2023_05_11_095002_create_branch_table',	30),
(74,	'2023_05_11_160713_create_branch_codes_table',	31),
(75,	'2023_10_19_161450_create_lesson_documents_table',	32),
(76,	'2023_12_14_135520_alter_add_column_to_classes_table',	33),
(77,	'2023_12_15_093549_alter_add_column_to_trainers_table',	34),
(78,	'2023_12_15_093829_alter_add_column_to_courses_table',	35),
(79,	'2023_12_15_174850_alter_add_column_to_students_table',	36),
(80,	'2023_12_25_085027_alter_add_column_to_lessons_table',	37),
(81,	'2024_02_12_093407_alter_add_column_to_students_table',	38);

DROP TABLE IF EXISTS `model_has_permissions`;
CREATE TABLE `model_has_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL,
  `model_type` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`) USING BTREE,
  KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`) USING BTREE,
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

INSERT INTO `model_has_permissions` (`permission_id`, `model_type`, `model_id`) VALUES
(1,	'App\\Models\\User',	5),
(1,	'App\\Models\\User',	6),
(1,	'App\\Models\\User',	7),
(1,	'App\\Models\\User',	8),
(1,	'App\\Models\\User',	11),
(1,	'App\\Models\\User',	13),
(1,	'App\\Models\\User',	17),
(1,	'App\\Models\\User',	18),
(2,	'App\\Models\\User',	5),
(2,	'App\\Models\\User',	6),
(2,	'App\\Models\\User',	7),
(2,	'App\\Models\\User',	8),
(2,	'App\\Models\\User',	11),
(2,	'App\\Models\\User',	13),
(2,	'App\\Models\\User',	17),
(2,	'App\\Models\\User',	18),
(3,	'App\\Models\\User',	5),
(3,	'App\\Models\\User',	6),
(3,	'App\\Models\\User',	7),
(3,	'App\\Models\\User',	8),
(3,	'App\\Models\\User',	11),
(3,	'App\\Models\\User',	13),
(3,	'App\\Models\\User',	17),
(3,	'App\\Models\\User',	18),
(4,	'App\\Models\\User',	5),
(4,	'App\\Models\\User',	6),
(4,	'App\\Models\\User',	7),
(4,	'App\\Models\\User',	8),
(4,	'App\\Models\\User',	11),
(4,	'App\\Models\\User',	13),
(4,	'App\\Models\\User',	17),
(4,	'App\\Models\\User',	18),
(5,	'App\\Models\\User',	5),
(5,	'App\\Models\\User',	6),
(5,	'App\\Models\\User',	7),
(5,	'App\\Models\\User',	8),
(5,	'App\\Models\\User',	11),
(5,	'App\\Models\\User',	13),
(5,	'App\\Models\\User',	17),
(5,	'App\\Models\\User',	18),
(6,	'App\\Models\\User',	5),
(6,	'App\\Models\\User',	6),
(6,	'App\\Models\\User',	7),
(6,	'App\\Models\\User',	8),
(6,	'App\\Models\\User',	11),
(6,	'App\\Models\\User',	13),
(6,	'App\\Models\\User',	17),
(6,	'App\\Models\\User',	18),
(7,	'App\\Models\\User',	5),
(7,	'App\\Models\\User',	6),
(7,	'App\\Models\\User',	8),
(7,	'App\\Models\\User',	11),
(7,	'App\\Models\\User',	13),
(7,	'App\\Models\\User',	17),
(8,	'App\\Models\\User',	5),
(8,	'App\\Models\\User',	6),
(8,	'App\\Models\\User',	8),
(8,	'App\\Models\\User',	11),
(8,	'App\\Models\\User',	13),
(8,	'App\\Models\\User',	17),
(9,	'App\\Models\\User',	5),
(9,	'App\\Models\\User',	6),
(9,	'App\\Models\\User',	8),
(9,	'App\\Models\\User',	11),
(9,	'App\\Models\\User',	13),
(9,	'App\\Models\\User',	17),
(10,	'App\\Models\\User',	5),
(10,	'App\\Models\\User',	6),
(10,	'App\\Models\\User',	8),
(10,	'App\\Models\\User',	11),
(10,	'App\\Models\\User',	13),
(10,	'App\\Models\\User',	17),
(11,	'App\\Models\\User',	5),
(11,	'App\\Models\\User',	6),
(11,	'App\\Models\\User',	8),
(11,	'App\\Models\\User',	11),
(11,	'App\\Models\\User',	13),
(11,	'App\\Models\\User',	17),
(12,	'App\\Models\\User',	5),
(12,	'App\\Models\\User',	6),
(12,	'App\\Models\\User',	8),
(12,	'App\\Models\\User',	11),
(12,	'App\\Models\\User',	13),
(12,	'App\\Models\\User',	17),
(13,	'App\\Models\\User',	5),
(13,	'App\\Models\\User',	6),
(13,	'App\\Models\\User',	8),
(13,	'App\\Models\\User',	11),
(13,	'App\\Models\\User',	13),
(13,	'App\\Models\\User',	17),
(14,	'App\\Models\\User',	5),
(14,	'App\\Models\\User',	6),
(14,	'App\\Models\\User',	8),
(14,	'App\\Models\\User',	11),
(14,	'App\\Models\\User',	13),
(14,	'App\\Models\\User',	17),
(15,	'App\\Models\\User',	5),
(15,	'App\\Models\\User',	6),
(15,	'App\\Models\\User',	8),
(15,	'App\\Models\\User',	11),
(15,	'App\\Models\\User',	13),
(15,	'App\\Models\\User',	17),
(16,	'App\\Models\\User',	5),
(16,	'App\\Models\\User',	6),
(16,	'App\\Models\\User',	8),
(16,	'App\\Models\\User',	11),
(16,	'App\\Models\\User',	13),
(16,	'App\\Models\\User',	17),
(17,	'App\\Models\\User',	5),
(17,	'App\\Models\\User',	6),
(17,	'App\\Models\\User',	8),
(17,	'App\\Models\\User',	11),
(17,	'App\\Models\\User',	13),
(17,	'App\\Models\\User',	17),
(18,	'App\\Models\\User',	5),
(18,	'App\\Models\\User',	6),
(18,	'App\\Models\\User',	8),
(18,	'App\\Models\\User',	11),
(18,	'App\\Models\\User',	13),
(18,	'App\\Models\\User',	17),
(19,	'App\\Models\\User',	5),
(19,	'App\\Models\\User',	6),
(19,	'App\\Models\\User',	8),
(19,	'App\\Models\\User',	11),
(19,	'App\\Models\\User',	13),
(19,	'App\\Models\\User',	17),
(20,	'App\\Models\\User',	5),
(20,	'App\\Models\\User',	6),
(20,	'App\\Models\\User',	8),
(20,	'App\\Models\\User',	11),
(20,	'App\\Models\\User',	13),
(20,	'App\\Models\\User',	17),
(20,	'App\\Models\\User',	18),
(21,	'App\\Models\\User',	5),
(21,	'App\\Models\\User',	6),
(21,	'App\\Models\\User',	8),
(21,	'App\\Models\\User',	11),
(21,	'App\\Models\\User',	13),
(21,	'App\\Models\\User',	17),
(21,	'App\\Models\\User',	18),
(22,	'App\\Models\\User',	5),
(22,	'App\\Models\\User',	6),
(22,	'App\\Models\\User',	8),
(22,	'App\\Models\\User',	11),
(22,	'App\\Models\\User',	13),
(22,	'App\\Models\\User',	17),
(22,	'App\\Models\\User',	18),
(23,	'App\\Models\\User',	5),
(23,	'App\\Models\\User',	6),
(23,	'App\\Models\\User',	8),
(23,	'App\\Models\\User',	11),
(23,	'App\\Models\\User',	13),
(23,	'App\\Models\\User',	17),
(24,	'App\\Models\\User',	5),
(24,	'App\\Models\\User',	6),
(24,	'App\\Models\\User',	8),
(24,	'App\\Models\\User',	11),
(24,	'App\\Models\\User',	13),
(24,	'App\\Models\\User',	17),
(25,	'App\\Models\\User',	5),
(25,	'App\\Models\\User',	6),
(25,	'App\\Models\\User',	8),
(25,	'App\\Models\\User',	11),
(25,	'App\\Models\\User',	13),
(25,	'App\\Models\\User',	17),
(26,	'App\\Models\\User',	5),
(26,	'App\\Models\\User',	6),
(26,	'App\\Models\\User',	8),
(26,	'App\\Models\\User',	11),
(26,	'App\\Models\\User',	13),
(26,	'App\\Models\\User',	17),
(27,	'App\\Models\\User',	5),
(27,	'App\\Models\\User',	6),
(27,	'App\\Models\\User',	8),
(27,	'App\\Models\\User',	11),
(27,	'App\\Models\\User',	13),
(27,	'App\\Models\\User',	17),
(28,	'App\\Models\\User',	5),
(28,	'App\\Models\\User',	6),
(28,	'App\\Models\\User',	8),
(28,	'App\\Models\\User',	11),
(28,	'App\\Models\\User',	13),
(28,	'App\\Models\\User',	17),
(29,	'App\\Models\\User',	5),
(29,	'App\\Models\\User',	6),
(29,	'App\\Models\\User',	8),
(29,	'App\\Models\\User',	11),
(29,	'App\\Models\\User',	13),
(29,	'App\\Models\\User',	17),
(30,	'App\\Models\\User',	5),
(30,	'App\\Models\\User',	6),
(30,	'App\\Models\\User',	8),
(30,	'App\\Models\\User',	11),
(30,	'App\\Models\\User',	13),
(30,	'App\\Models\\User',	17),
(31,	'App\\Models\\User',	5),
(31,	'App\\Models\\User',	6),
(31,	'App\\Models\\User',	8),
(31,	'App\\Models\\User',	11),
(31,	'App\\Models\\User',	13),
(31,	'App\\Models\\User',	17),
(32,	'App\\Models\\User',	5),
(32,	'App\\Models\\User',	6),
(32,	'App\\Models\\User',	8),
(32,	'App\\Models\\User',	11),
(32,	'App\\Models\\User',	13),
(32,	'App\\Models\\User',	17),
(33,	'App\\Models\\User',	5),
(33,	'App\\Models\\User',	6),
(33,	'App\\Models\\User',	8),
(33,	'App\\Models\\User',	11),
(33,	'App\\Models\\User',	13),
(33,	'App\\Models\\User',	17),
(34,	'App\\Models\\User',	5),
(34,	'App\\Models\\User',	6),
(34,	'App\\Models\\User',	8),
(34,	'App\\Models\\User',	11),
(34,	'App\\Models\\User',	13),
(34,	'App\\Models\\User',	17),
(35,	'App\\Models\\User',	5),
(35,	'App\\Models\\User',	6),
(35,	'App\\Models\\User',	8),
(35,	'App\\Models\\User',	11),
(35,	'App\\Models\\User',	13),
(35,	'App\\Models\\User',	17),
(35,	'App\\Models\\User',	18),
(36,	'App\\Models\\User',	5),
(36,	'App\\Models\\User',	6),
(36,	'App\\Models\\User',	8),
(36,	'App\\Models\\User',	11),
(36,	'App\\Models\\User',	13),
(36,	'App\\Models\\User',	17),
(36,	'App\\Models\\User',	18),
(37,	'App\\Models\\User',	5),
(37,	'App\\Models\\User',	6),
(37,	'App\\Models\\User',	8),
(37,	'App\\Models\\User',	11),
(37,	'App\\Models\\User',	13),
(37,	'App\\Models\\User',	17),
(37,	'App\\Models\\User',	18),
(38,	'App\\Models\\User',	5),
(38,	'App\\Models\\User',	6),
(38,	'App\\Models\\User',	8),
(38,	'App\\Models\\User',	11),
(38,	'App\\Models\\User',	13),
(38,	'App\\Models\\User',	17),
(38,	'App\\Models\\User',	18),
(39,	'App\\Models\\User',	5),
(39,	'App\\Models\\User',	6),
(39,	'App\\Models\\User',	8),
(39,	'App\\Models\\User',	11),
(39,	'App\\Models\\User',	13),
(39,	'App\\Models\\User',	17),
(39,	'App\\Models\\User',	18),
(40,	'App\\Models\\User',	5),
(40,	'App\\Models\\User',	6),
(40,	'App\\Models\\User',	8),
(40,	'App\\Models\\User',	11),
(40,	'App\\Models\\User',	13),
(40,	'App\\Models\\User',	17),
(40,	'App\\Models\\User',	18),
(41,	'App\\Models\\User',	5),
(41,	'App\\Models\\User',	6),
(41,	'App\\Models\\User',	8),
(41,	'App\\Models\\User',	11),
(41,	'App\\Models\\User',	13),
(41,	'App\\Models\\User',	17),
(41,	'App\\Models\\User',	18),
(42,	'App\\Models\\User',	5),
(42,	'App\\Models\\User',	6),
(42,	'App\\Models\\User',	8),
(42,	'App\\Models\\User',	11),
(42,	'App\\Models\\User',	13),
(42,	'App\\Models\\User',	17),
(42,	'App\\Models\\User',	18),
(43,	'App\\Models\\User',	5),
(43,	'App\\Models\\User',	6),
(43,	'App\\Models\\User',	8),
(43,	'App\\Models\\User',	11),
(43,	'App\\Models\\User',	13),
(43,	'App\\Models\\User',	17),
(43,	'App\\Models\\User',	18),
(44,	'App\\Models\\User',	5),
(44,	'App\\Models\\User',	6),
(44,	'App\\Models\\User',	8),
(44,	'App\\Models\\User',	11),
(44,	'App\\Models\\User',	13),
(44,	'App\\Models\\User',	17),
(44,	'App\\Models\\User',	18),
(45,	'App\\Models\\User',	5),
(45,	'App\\Models\\User',	6),
(45,	'App\\Models\\User',	8),
(45,	'App\\Models\\User',	11),
(45,	'App\\Models\\User',	13),
(45,	'App\\Models\\User',	17),
(45,	'App\\Models\\User',	18),
(46,	'App\\Models\\User',	5),
(46,	'App\\Models\\User',	6),
(46,	'App\\Models\\User',	8),
(46,	'App\\Models\\User',	11),
(46,	'App\\Models\\User',	13),
(46,	'App\\Models\\User',	17),
(46,	'App\\Models\\User',	18),
(47,	'App\\Models\\User',	5),
(47,	'App\\Models\\User',	6),
(47,	'App\\Models\\User',	8),
(47,	'App\\Models\\User',	11),
(47,	'App\\Models\\User',	13),
(47,	'App\\Models\\User',	17),
(47,	'App\\Models\\User',	18),
(48,	'App\\Models\\User',	5),
(48,	'App\\Models\\User',	6),
(48,	'App\\Models\\User',	8),
(48,	'App\\Models\\User',	11),
(48,	'App\\Models\\User',	13),
(48,	'App\\Models\\User',	17),
(48,	'App\\Models\\User',	18),
(49,	'App\\Models\\User',	5),
(49,	'App\\Models\\User',	6),
(49,	'App\\Models\\User',	8),
(49,	'App\\Models\\User',	11),
(49,	'App\\Models\\User',	13),
(49,	'App\\Models\\User',	17),
(49,	'App\\Models\\User',	18),
(50,	'App\\Models\\User',	5),
(50,	'App\\Models\\User',	6),
(50,	'App\\Models\\User',	8),
(50,	'App\\Models\\User',	11),
(50,	'App\\Models\\User',	13),
(50,	'App\\Models\\User',	17),
(50,	'App\\Models\\User',	18),
(51,	'App\\Models\\User',	5),
(51,	'App\\Models\\User',	6),
(51,	'App\\Models\\User',	8),
(51,	'App\\Models\\User',	11),
(51,	'App\\Models\\User',	13),
(51,	'App\\Models\\User',	17),
(52,	'App\\Models\\User',	5),
(52,	'App\\Models\\User',	6),
(52,	'App\\Models\\User',	8),
(52,	'App\\Models\\User',	11),
(52,	'App\\Models\\User',	13),
(52,	'App\\Models\\User',	17),
(53,	'App\\Models\\User',	5),
(53,	'App\\Models\\User',	6),
(53,	'App\\Models\\User',	8),
(53,	'App\\Models\\User',	11),
(53,	'App\\Models\\User',	13),
(53,	'App\\Models\\User',	17),
(54,	'App\\Models\\User',	5),
(54,	'App\\Models\\User',	6),
(54,	'App\\Models\\User',	8),
(54,	'App\\Models\\User',	11),
(54,	'App\\Models\\User',	13),
(54,	'App\\Models\\User',	17),
(54,	'App\\Models\\User',	18),
(55,	'App\\Models\\User',	5),
(55,	'App\\Models\\User',	6),
(55,	'App\\Models\\User',	8),
(55,	'App\\Models\\User',	11),
(55,	'App\\Models\\User',	13),
(55,	'App\\Models\\User',	17),
(55,	'App\\Models\\User',	18),
(56,	'App\\Models\\User',	5),
(56,	'App\\Models\\User',	6),
(56,	'App\\Models\\User',	8),
(56,	'App\\Models\\User',	11),
(56,	'App\\Models\\User',	13),
(56,	'App\\Models\\User',	17),
(56,	'App\\Models\\User',	18),
(57,	'App\\Models\\User',	5),
(57,	'App\\Models\\User',	6),
(57,	'App\\Models\\User',	8),
(57,	'App\\Models\\User',	11),
(57,	'App\\Models\\User',	13),
(57,	'App\\Models\\User',	17),
(58,	'App\\Models\\User',	5),
(58,	'App\\Models\\User',	6),
(58,	'App\\Models\\User',	8),
(58,	'App\\Models\\User',	11),
(58,	'App\\Models\\User',	13),
(58,	'App\\Models\\User',	17),
(59,	'App\\Models\\User',	5),
(59,	'App\\Models\\User',	6),
(59,	'App\\Models\\User',	8),
(59,	'App\\Models\\User',	11),
(59,	'App\\Models\\User',	13),
(59,	'App\\Models\\User',	17),
(60,	'App\\Models\\User',	5),
(60,	'App\\Models\\User',	6),
(60,	'App\\Models\\User',	8),
(60,	'App\\Models\\User',	11),
(60,	'App\\Models\\User',	13),
(60,	'App\\Models\\User',	17),
(61,	'App\\Models\\User',	5),
(61,	'App\\Models\\User',	6),
(61,	'App\\Models\\User',	8),
(61,	'App\\Models\\User',	11),
(61,	'App\\Models\\User',	13),
(61,	'App\\Models\\User',	17),
(62,	'App\\Models\\User',	5),
(62,	'App\\Models\\User',	6),
(62,	'App\\Models\\User',	8),
(62,	'App\\Models\\User',	11),
(62,	'App\\Models\\User',	13),
(62,	'App\\Models\\User',	17),
(63,	'App\\Models\\User',	5),
(63,	'App\\Models\\User',	6),
(63,	'App\\Models\\User',	8),
(63,	'App\\Models\\User',	11),
(63,	'App\\Models\\User',	13),
(63,	'App\\Models\\User',	17),
(64,	'App\\Models\\User',	5),
(64,	'App\\Models\\User',	6),
(64,	'App\\Models\\User',	8),
(64,	'App\\Models\\User',	11),
(64,	'App\\Models\\User',	13),
(64,	'App\\Models\\User',	17),
(65,	'App\\Models\\User',	5),
(65,	'App\\Models\\User',	6),
(65,	'App\\Models\\User',	8),
(65,	'App\\Models\\User',	11),
(65,	'App\\Models\\User',	13),
(65,	'App\\Models\\User',	17),
(66,	'App\\Models\\User',	5),
(66,	'App\\Models\\User',	6),
(66,	'App\\Models\\User',	8),
(66,	'App\\Models\\User',	11),
(66,	'App\\Models\\User',	13),
(66,	'App\\Models\\User',	17),
(67,	'App\\Models\\User',	5),
(67,	'App\\Models\\User',	6),
(67,	'App\\Models\\User',	8),
(67,	'App\\Models\\User',	11),
(67,	'App\\Models\\User',	13),
(67,	'App\\Models\\User',	17),
(68,	'App\\Models\\User',	5),
(68,	'App\\Models\\User',	6),
(68,	'App\\Models\\User',	8),
(68,	'App\\Models\\User',	11),
(68,	'App\\Models\\User',	13),
(68,	'App\\Models\\User',	17),
(69,	'App\\Models\\User',	5),
(69,	'App\\Models\\User',	6),
(69,	'App\\Models\\User',	8),
(69,	'App\\Models\\User',	11),
(69,	'App\\Models\\User',	13),
(69,	'App\\Models\\User',	17),
(70,	'App\\Models\\User',	5),
(70,	'App\\Models\\User',	6),
(70,	'App\\Models\\User',	8),
(70,	'App\\Models\\User',	11),
(70,	'App\\Models\\User',	13),
(70,	'App\\Models\\User',	17),
(71,	'App\\Models\\User',	5),
(71,	'App\\Models\\User',	6),
(71,	'App\\Models\\User',	8),
(71,	'App\\Models\\User',	11),
(71,	'App\\Models\\User',	13),
(71,	'App\\Models\\User',	17),
(72,	'App\\Models\\User',	5),
(72,	'App\\Models\\User',	6),
(72,	'App\\Models\\User',	8),
(72,	'App\\Models\\User',	11),
(72,	'App\\Models\\User',	13),
(72,	'App\\Models\\User',	17),
(73,	'App\\Models\\User',	5),
(73,	'App\\Models\\User',	6),
(73,	'App\\Models\\User',	8),
(73,	'App\\Models\\User',	11),
(73,	'App\\Models\\User',	13),
(73,	'App\\Models\\User',	17),
(74,	'App\\Models\\User',	5),
(74,	'App\\Models\\User',	6),
(74,	'App\\Models\\User',	8),
(74,	'App\\Models\\User',	11),
(74,	'App\\Models\\User',	13),
(74,	'App\\Models\\User',	17),
(75,	'App\\Models\\User',	5),
(75,	'App\\Models\\User',	6),
(75,	'App\\Models\\User',	8),
(75,	'App\\Models\\User',	11),
(75,	'App\\Models\\User',	13),
(75,	'App\\Models\\User',	17),
(76,	'App\\Models\\User',	5),
(76,	'App\\Models\\User',	6),
(76,	'App\\Models\\User',	8),
(76,	'App\\Models\\User',	11),
(76,	'App\\Models\\User',	13),
(76,	'App\\Models\\User',	17),
(77,	'App\\Models\\User',	5),
(77,	'App\\Models\\User',	6),
(77,	'App\\Models\\User',	8),
(77,	'App\\Models\\User',	11),
(77,	'App\\Models\\User',	13),
(77,	'App\\Models\\User',	17),
(78,	'App\\Models\\User',	5),
(78,	'App\\Models\\User',	6),
(78,	'App\\Models\\User',	8),
(78,	'App\\Models\\User',	11),
(78,	'App\\Models\\User',	13),
(78,	'App\\Models\\User',	17),
(79,	'App\\Models\\User',	5),
(79,	'App\\Models\\User',	6),
(79,	'App\\Models\\User',	8),
(79,	'App\\Models\\User',	11),
(79,	'App\\Models\\User',	13),
(79,	'App\\Models\\User',	17),
(80,	'App\\Models\\User',	5),
(80,	'App\\Models\\User',	6),
(80,	'App\\Models\\User',	8),
(80,	'App\\Models\\User',	11),
(80,	'App\\Models\\User',	13),
(80,	'App\\Models\\User',	17),
(81,	'App\\Models\\User',	5),
(81,	'App\\Models\\User',	6),
(81,	'App\\Models\\User',	8),
(81,	'App\\Models\\User',	11),
(81,	'App\\Models\\User',	13),
(81,	'App\\Models\\User',	17),
(82,	'App\\Models\\User',	5),
(82,	'App\\Models\\User',	6),
(82,	'App\\Models\\User',	8),
(82,	'App\\Models\\User',	11),
(82,	'App\\Models\\User',	13),
(82,	'App\\Models\\User',	17),
(83,	'App\\Models\\User',	5),
(83,	'App\\Models\\User',	6),
(83,	'App\\Models\\User',	8),
(83,	'App\\Models\\User',	11),
(83,	'App\\Models\\User',	13),
(83,	'App\\Models\\User',	17),
(84,	'App\\Models\\User',	5),
(84,	'App\\Models\\User',	6),
(84,	'App\\Models\\User',	8),
(84,	'App\\Models\\User',	11),
(84,	'App\\Models\\User',	13),
(84,	'App\\Models\\User',	17),
(85,	'App\\Models\\User',	5),
(85,	'App\\Models\\User',	6),
(85,	'App\\Models\\User',	8),
(85,	'App\\Models\\User',	11),
(85,	'App\\Models\\User',	13),
(85,	'App\\Models\\User',	17),
(86,	'App\\Models\\User',	5),
(86,	'App\\Models\\User',	6),
(86,	'App\\Models\\User',	8),
(86,	'App\\Models\\User',	11),
(86,	'App\\Models\\User',	13),
(86,	'App\\Models\\User',	17),
(87,	'App\\Models\\User',	5),
(87,	'App\\Models\\User',	6),
(87,	'App\\Models\\User',	8),
(87,	'App\\Models\\User',	11),
(87,	'App\\Models\\User',	13),
(87,	'App\\Models\\User',	17),
(88,	'App\\Models\\User',	5),
(88,	'App\\Models\\User',	6),
(88,	'App\\Models\\User',	8),
(88,	'App\\Models\\User',	11),
(88,	'App\\Models\\User',	13),
(88,	'App\\Models\\User',	17),
(89,	'App\\Models\\User',	5),
(89,	'App\\Models\\User',	6),
(89,	'App\\Models\\User',	8),
(89,	'App\\Models\\User',	11),
(89,	'App\\Models\\User',	13),
(89,	'App\\Models\\User',	17),
(90,	'App\\Models\\User',	5),
(90,	'App\\Models\\User',	6),
(90,	'App\\Models\\User',	8),
(90,	'App\\Models\\User',	11),
(90,	'App\\Models\\User',	13),
(90,	'App\\Models\\User',	17),
(91,	'App\\Models\\User',	5),
(91,	'App\\Models\\User',	6),
(91,	'App\\Models\\User',	8),
(91,	'App\\Models\\User',	11),
(91,	'App\\Models\\User',	13),
(91,	'App\\Models\\User',	17),
(92,	'App\\Models\\User',	5),
(92,	'App\\Models\\User',	6),
(92,	'App\\Models\\User',	8),
(92,	'App\\Models\\User',	11),
(92,	'App\\Models\\User',	13),
(92,	'App\\Models\\User',	17),
(93,	'App\\Models\\User',	5),
(93,	'App\\Models\\User',	6),
(93,	'App\\Models\\User',	8),
(93,	'App\\Models\\User',	11),
(93,	'App\\Models\\User',	13),
(93,	'App\\Models\\User',	17),
(94,	'App\\Models\\User',	5),
(94,	'App\\Models\\User',	6),
(94,	'App\\Models\\User',	8),
(94,	'App\\Models\\User',	11),
(94,	'App\\Models\\User',	13),
(94,	'App\\Models\\User',	17),
(95,	'App\\Models\\User',	5),
(95,	'App\\Models\\User',	6),
(95,	'App\\Models\\User',	8),
(95,	'App\\Models\\User',	11),
(95,	'App\\Models\\User',	13),
(95,	'App\\Models\\User',	17),
(96,	'App\\Models\\User',	5),
(96,	'App\\Models\\User',	6),
(96,	'App\\Models\\User',	8),
(96,	'App\\Models\\User',	11),
(96,	'App\\Models\\User',	13),
(96,	'App\\Models\\User',	17),
(97,	'App\\Models\\User',	5),
(97,	'App\\Models\\User',	6),
(97,	'App\\Models\\User',	8),
(97,	'App\\Models\\User',	11),
(97,	'App\\Models\\User',	13),
(97,	'App\\Models\\User',	17),
(98,	'App\\Models\\User',	5),
(98,	'App\\Models\\User',	6),
(98,	'App\\Models\\User',	8),
(98,	'App\\Models\\User',	11),
(98,	'App\\Models\\User',	13),
(98,	'App\\Models\\User',	17),
(99,	'App\\Models\\User',	5),
(99,	'App\\Models\\User',	6),
(99,	'App\\Models\\User',	8),
(99,	'App\\Models\\User',	11),
(99,	'App\\Models\\User',	13),
(99,	'App\\Models\\User',	17),
(100,	'App\\Models\\User',	5),
(100,	'App\\Models\\User',	6),
(100,	'App\\Models\\User',	8),
(100,	'App\\Models\\User',	11),
(100,	'App\\Models\\User',	13),
(100,	'App\\Models\\User',	17),
(101,	'App\\Models\\User',	5),
(101,	'App\\Models\\User',	6),
(101,	'App\\Models\\User',	8),
(101,	'App\\Models\\User',	11),
(101,	'App\\Models\\User',	13),
(101,	'App\\Models\\User',	17),
(102,	'App\\Models\\User',	5),
(102,	'App\\Models\\User',	6),
(102,	'App\\Models\\User',	8),
(102,	'App\\Models\\User',	11),
(102,	'App\\Models\\User',	13),
(102,	'App\\Models\\User',	17),
(103,	'App\\Models\\User',	5),
(103,	'App\\Models\\User',	6),
(103,	'App\\Models\\User',	8),
(103,	'App\\Models\\User',	11),
(103,	'App\\Models\\User',	13),
(103,	'App\\Models\\User',	17),
(103,	'App\\Models\\User',	18),
(104,	'App\\Models\\User',	5),
(104,	'App\\Models\\User',	6),
(104,	'App\\Models\\User',	8),
(104,	'App\\Models\\User',	11),
(104,	'App\\Models\\User',	13),
(104,	'App\\Models\\User',	17),
(104,	'App\\Models\\User',	18),
(105,	'App\\Models\\User',	5),
(105,	'App\\Models\\User',	6),
(105,	'App\\Models\\User',	8),
(105,	'App\\Models\\User',	11),
(105,	'App\\Models\\User',	13),
(105,	'App\\Models\\User',	17),
(105,	'App\\Models\\User',	18),
(106,	'App\\Models\\User',	5),
(106,	'App\\Models\\User',	6),
(106,	'App\\Models\\User',	8),
(106,	'App\\Models\\User',	11),
(106,	'App\\Models\\User',	13),
(106,	'App\\Models\\User',	17),
(106,	'App\\Models\\User',	18),
(107,	'App\\Models\\User',	5),
(107,	'App\\Models\\User',	6),
(107,	'App\\Models\\User',	8),
(107,	'App\\Models\\User',	11),
(107,	'App\\Models\\User',	13),
(107,	'App\\Models\\User',	17),
(107,	'App\\Models\\User',	18),
(108,	'App\\Models\\User',	5),
(108,	'App\\Models\\User',	6),
(108,	'App\\Models\\User',	8),
(108,	'App\\Models\\User',	11),
(108,	'App\\Models\\User',	13),
(108,	'App\\Models\\User',	17),
(108,	'App\\Models\\User',	18),
(109,	'App\\Models\\User',	5),
(109,	'App\\Models\\User',	6),
(109,	'App\\Models\\User',	8),
(109,	'App\\Models\\User',	11),
(109,	'App\\Models\\User',	13),
(109,	'App\\Models\\User',	17),
(109,	'App\\Models\\User',	18),
(110,	'App\\Models\\User',	5),
(110,	'App\\Models\\User',	6),
(110,	'App\\Models\\User',	8),
(110,	'App\\Models\\User',	11),
(110,	'App\\Models\\User',	13),
(110,	'App\\Models\\User',	17),
(110,	'App\\Models\\User',	18),
(111,	'App\\Models\\User',	5),
(111,	'App\\Models\\User',	6),
(111,	'App\\Models\\User',	8),
(111,	'App\\Models\\User',	11),
(111,	'App\\Models\\User',	13),
(111,	'App\\Models\\User',	17),
(111,	'App\\Models\\User',	18),
(112,	'App\\Models\\User',	5),
(112,	'App\\Models\\User',	6),
(112,	'App\\Models\\User',	8),
(112,	'App\\Models\\User',	11),
(112,	'App\\Models\\User',	13),
(112,	'App\\Models\\User',	17),
(112,	'App\\Models\\User',	18),
(113,	'App\\Models\\User',	5),
(113,	'App\\Models\\User',	6),
(113,	'App\\Models\\User',	8),
(113,	'App\\Models\\User',	11),
(113,	'App\\Models\\User',	13),
(113,	'App\\Models\\User',	17),
(113,	'App\\Models\\User',	18),
(114,	'App\\Models\\User',	5),
(114,	'App\\Models\\User',	6),
(114,	'App\\Models\\User',	8),
(114,	'App\\Models\\User',	11),
(114,	'App\\Models\\User',	13),
(114,	'App\\Models\\User',	17),
(114,	'App\\Models\\User',	18),
(115,	'App\\Models\\User',	5),
(115,	'App\\Models\\User',	6),
(115,	'App\\Models\\User',	8),
(115,	'App\\Models\\User',	11),
(115,	'App\\Models\\User',	13),
(115,	'App\\Models\\User',	17),
(115,	'App\\Models\\User',	18),
(116,	'App\\Models\\User',	5),
(116,	'App\\Models\\User',	6),
(116,	'App\\Models\\User',	8),
(116,	'App\\Models\\User',	11),
(116,	'App\\Models\\User',	13),
(116,	'App\\Models\\User',	17),
(117,	'App\\Models\\User',	5),
(117,	'App\\Models\\User',	6),
(117,	'App\\Models\\User',	8),
(117,	'App\\Models\\User',	11),
(117,	'App\\Models\\User',	13),
(117,	'App\\Models\\User',	17),
(118,	'App\\Models\\User',	5),
(118,	'App\\Models\\User',	6),
(118,	'App\\Models\\User',	8),
(118,	'App\\Models\\User',	11),
(118,	'App\\Models\\User',	13),
(118,	'App\\Models\\User',	17),
(119,	'App\\Models\\User',	5),
(119,	'App\\Models\\User',	6),
(119,	'App\\Models\\User',	8),
(119,	'App\\Models\\User',	11),
(119,	'App\\Models\\User',	13),
(119,	'App\\Models\\User',	17),
(120,	'App\\Models\\User',	5),
(120,	'App\\Models\\User',	6),
(120,	'App\\Models\\User',	8),
(120,	'App\\Models\\User',	11),
(120,	'App\\Models\\User',	13),
(120,	'App\\Models\\User',	17),
(121,	'App\\Models\\User',	5),
(121,	'App\\Models\\User',	6),
(121,	'App\\Models\\User',	8),
(121,	'App\\Models\\User',	11),
(121,	'App\\Models\\User',	13),
(121,	'App\\Models\\User',	17),
(122,	'App\\Models\\User',	5),
(122,	'App\\Models\\User',	6),
(122,	'App\\Models\\User',	8),
(122,	'App\\Models\\User',	13),
(122,	'App\\Models\\User',	17),
(122,	'App\\Models\\User',	18),
(123,	'App\\Models\\User',	5),
(123,	'App\\Models\\User',	6),
(123,	'App\\Models\\User',	8),
(123,	'App\\Models\\User',	13),
(123,	'App\\Models\\User',	17),
(123,	'App\\Models\\User',	18),
(124,	'App\\Models\\User',	5),
(124,	'App\\Models\\User',	6),
(124,	'App\\Models\\User',	8),
(124,	'App\\Models\\User',	13),
(124,	'App\\Models\\User',	17),
(125,	'App\\Models\\User',	5),
(125,	'App\\Models\\User',	6),
(125,	'App\\Models\\User',	8),
(125,	'App\\Models\\User',	13),
(125,	'App\\Models\\User',	17),
(126,	'App\\Models\\User',	5),
(126,	'App\\Models\\User',	6),
(126,	'App\\Models\\User',	8),
(126,	'App\\Models\\User',	13),
(126,	'App\\Models\\User',	17),
(127,	'App\\Models\\User',	5),
(127,	'App\\Models\\User',	6),
(127,	'App\\Models\\User',	8),
(127,	'App\\Models\\User',	13),
(127,	'App\\Models\\User',	17),
(128,	'App\\Models\\User',	5),
(128,	'App\\Models\\User',	6),
(128,	'App\\Models\\User',	8),
(128,	'App\\Models\\User',	13),
(128,	'App\\Models\\User',	17),
(129,	'App\\Models\\User',	5),
(129,	'App\\Models\\User',	6),
(129,	'App\\Models\\User',	8),
(129,	'App\\Models\\User',	13),
(129,	'App\\Models\\User',	17),
(130,	'App\\Models\\User',	5),
(130,	'App\\Models\\User',	6),
(130,	'App\\Models\\User',	8),
(130,	'App\\Models\\User',	13),
(130,	'App\\Models\\User',	17),
(130,	'App\\Models\\User',	18),
(131,	'App\\Models\\User',	5),
(131,	'App\\Models\\User',	6),
(131,	'App\\Models\\User',	8),
(131,	'App\\Models\\User',	13),
(131,	'App\\Models\\User',	17),
(131,	'App\\Models\\User',	18),
(132,	'App\\Models\\User',	5),
(132,	'App\\Models\\User',	6),
(132,	'App\\Models\\User',	8),
(132,	'App\\Models\\User',	13),
(132,	'App\\Models\\User',	17),
(132,	'App\\Models\\User',	18),
(133,	'App\\Models\\User',	5),
(133,	'App\\Models\\User',	6),
(133,	'App\\Models\\User',	8),
(133,	'App\\Models\\User',	13),
(133,	'App\\Models\\User',	17),
(134,	'App\\Models\\User',	5),
(134,	'App\\Models\\User',	6),
(134,	'App\\Models\\User',	8),
(134,	'App\\Models\\User',	13),
(134,	'App\\Models\\User',	17),
(135,	'App\\Models\\User',	5),
(135,	'App\\Models\\User',	6),
(135,	'App\\Models\\User',	8),
(135,	'App\\Models\\User',	13),
(135,	'App\\Models\\User',	17),
(136,	'App\\Models\\User',	5),
(136,	'App\\Models\\User',	6),
(136,	'App\\Models\\User',	8),
(136,	'App\\Models\\User',	13),
(136,	'App\\Models\\User',	17),
(136,	'App\\Models\\User',	18),
(137,	'App\\Models\\User',	5),
(137,	'App\\Models\\User',	6),
(137,	'App\\Models\\User',	8),
(137,	'App\\Models\\User',	13),
(137,	'App\\Models\\User',	17),
(137,	'App\\Models\\User',	18),
(138,	'App\\Models\\User',	5),
(138,	'App\\Models\\User',	6),
(138,	'App\\Models\\User',	8),
(138,	'App\\Models\\User',	13),
(138,	'App\\Models\\User',	17),
(138,	'App\\Models\\User',	18),
(139,	'App\\Models\\User',	5),
(139,	'App\\Models\\User',	6),
(139,	'App\\Models\\User',	8),
(139,	'App\\Models\\User',	13),
(139,	'App\\Models\\User',	17),
(139,	'App\\Models\\User',	18),
(140,	'App\\Models\\User',	5),
(140,	'App\\Models\\User',	6),
(140,	'App\\Models\\User',	8),
(140,	'App\\Models\\User',	13),
(140,	'App\\Models\\User',	17),
(140,	'App\\Models\\User',	18),
(141,	'App\\Models\\User',	5),
(141,	'App\\Models\\User',	6),
(141,	'App\\Models\\User',	8),
(141,	'App\\Models\\User',	13),
(141,	'App\\Models\\User',	17),
(141,	'App\\Models\\User',	18),
(142,	'App\\Models\\User',	5),
(142,	'App\\Models\\User',	6),
(142,	'App\\Models\\User',	8),
(142,	'App\\Models\\User',	13),
(142,	'App\\Models\\User',	17),
(142,	'App\\Models\\User',	18),
(143,	'App\\Models\\User',	5),
(143,	'App\\Models\\User',	6),
(143,	'App\\Models\\User',	8),
(143,	'App\\Models\\User',	13),
(143,	'App\\Models\\User',	17),
(143,	'App\\Models\\User',	18),
(144,	'App\\Models\\User',	5),
(144,	'App\\Models\\User',	6),
(144,	'App\\Models\\User',	8),
(144,	'App\\Models\\User',	13),
(144,	'App\\Models\\User',	17),
(144,	'App\\Models\\User',	18),
(145,	'App\\Models\\User',	5),
(145,	'App\\Models\\User',	6),
(145,	'App\\Models\\User',	8),
(145,	'App\\Models\\User',	13),
(145,	'App\\Models\\User',	17),
(145,	'App\\Models\\User',	18),
(146,	'App\\Models\\User',	5),
(146,	'App\\Models\\User',	6),
(146,	'App\\Models\\User',	8),
(146,	'App\\Models\\User',	13),
(146,	'App\\Models\\User',	17),
(146,	'App\\Models\\User',	18),
(147,	'App\\Models\\User',	5),
(147,	'App\\Models\\User',	6),
(147,	'App\\Models\\User',	8),
(147,	'App\\Models\\User',	13),
(147,	'App\\Models\\User',	17),
(147,	'App\\Models\\User',	18),
(148,	'App\\Models\\User',	5),
(148,	'App\\Models\\User',	6),
(148,	'App\\Models\\User',	8),
(148,	'App\\Models\\User',	13),
(148,	'App\\Models\\User',	17),
(149,	'App\\Models\\User',	5),
(149,	'App\\Models\\User',	6),
(149,	'App\\Models\\User',	8),
(149,	'App\\Models\\User',	13),
(149,	'App\\Models\\User',	17),
(149,	'App\\Models\\User',	18),
(150,	'App\\Models\\User',	5),
(150,	'App\\Models\\User',	6),
(150,	'App\\Models\\User',	8),
(150,	'App\\Models\\User',	13),
(150,	'App\\Models\\User',	17),
(150,	'App\\Models\\User',	18),
(151,	'App\\Models\\User',	5),
(151,	'App\\Models\\User',	6),
(151,	'App\\Models\\User',	8),
(151,	'App\\Models\\User',	13),
(151,	'App\\Models\\User',	17),
(151,	'App\\Models\\User',	18),
(152,	'App\\Models\\User',	5),
(152,	'App\\Models\\User',	6),
(152,	'App\\Models\\User',	8),
(152,	'App\\Models\\User',	13),
(152,	'App\\Models\\User',	17),
(153,	'App\\Models\\User',	5),
(153,	'App\\Models\\User',	6),
(153,	'App\\Models\\User',	8),
(153,	'App\\Models\\User',	13),
(153,	'App\\Models\\User',	17),
(154,	'App\\Models\\User',	5),
(154,	'App\\Models\\User',	6),
(154,	'App\\Models\\User',	8),
(154,	'App\\Models\\User',	13),
(154,	'App\\Models\\User',	17),
(155,	'App\\Models\\User',	5),
(155,	'App\\Models\\User',	6),
(155,	'App\\Models\\User',	8),
(155,	'App\\Models\\User',	13),
(155,	'App\\Models\\User',	17),
(155,	'App\\Models\\User',	18),
(156,	'App\\Models\\User',	5),
(156,	'App\\Models\\User',	6),
(156,	'App\\Models\\User',	8),
(156,	'App\\Models\\User',	13),
(156,	'App\\Models\\User',	17),
(156,	'App\\Models\\User',	18),
(157,	'App\\Models\\User',	5),
(157,	'App\\Models\\User',	6),
(157,	'App\\Models\\User',	8),
(157,	'App\\Models\\User',	13),
(157,	'App\\Models\\User',	17),
(157,	'App\\Models\\User',	18),
(158,	'App\\Models\\User',	5),
(158,	'App\\Models\\User',	6),
(158,	'App\\Models\\User',	8),
(158,	'App\\Models\\User',	13),
(158,	'App\\Models\\User',	17),
(158,	'App\\Models\\User',	18),
(159,	'App\\Models\\User',	5),
(159,	'App\\Models\\User',	6),
(159,	'App\\Models\\User',	8),
(159,	'App\\Models\\User',	13),
(159,	'App\\Models\\User',	17),
(159,	'App\\Models\\User',	18),
(160,	'App\\Models\\User',	5),
(160,	'App\\Models\\User',	13),
(160,	'App\\Models\\User',	17),
(160,	'App\\Models\\User',	18),
(161,	'App\\Models\\User',	5),
(161,	'App\\Models\\User',	13),
(161,	'App\\Models\\User',	17),
(161,	'App\\Models\\User',	18),
(162,	'App\\Models\\User',	5),
(162,	'App\\Models\\User',	13),
(162,	'App\\Models\\User',	17),
(162,	'App\\Models\\User',	18),
(163,	'App\\Models\\User',	5),
(163,	'App\\Models\\User',	13),
(163,	'App\\Models\\User',	17),
(163,	'App\\Models\\User',	18),
(164,	'App\\Models\\User',	5),
(164,	'App\\Models\\User',	13),
(164,	'App\\Models\\User',	17),
(164,	'App\\Models\\User',	18),
(165,	'App\\Models\\User',	5),
(165,	'App\\Models\\User',	13),
(165,	'App\\Models\\User',	17),
(165,	'App\\Models\\User',	18),
(166,	'App\\Models\\User',	5),
(166,	'App\\Models\\User',	13),
(166,	'App\\Models\\User',	17),
(166,	'App\\Models\\User',	18),
(167,	'App\\Models\\User',	5),
(167,	'App\\Models\\User',	13),
(167,	'App\\Models\\User',	17),
(167,	'App\\Models\\User',	18),
(168,	'App\\Models\\User',	5),
(168,	'App\\Models\\User',	13),
(168,	'App\\Models\\User',	17),
(168,	'App\\Models\\User',	18),
(169,	'App\\Models\\User',	5),
(169,	'App\\Models\\User',	13),
(169,	'App\\Models\\User',	17),
(169,	'App\\Models\\User',	18);

DROP TABLE IF EXISTS `model_has_roles`;
CREATE TABLE `model_has_roles` (
  `role_id` bigint(20) unsigned NOT NULL,
  `model_type` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `module_permissions`;
CREATE TABLE `module_permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_name` varchar(125) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `name` varchar(125) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sort_no` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

INSERT INTO `module_permissions` (`id`, `parent_name`, `parent_id`, `name`, `sort_no`, `created_at`, `updated_at`) VALUES
(1,	NULL,	1,	'Student',	1,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(2,	NULL,	2,	'Class Program',	2,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(3,	NULL,	3,	'Structure Program',	3,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(4,	NULL,	4,	'Lesson',	4,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(5,	NULL,	11,	'Education',	11,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(6,	NULL,	50,	'User',	50,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(7,	NULL,	12,	'Lesson Occupation',	12,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(8,	NULL,	13,	'Class Occupation',	13,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(9,	NULL,	5,	'Class',	5,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(10,	NULL,	14,	'Class Type',	14,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(11,	NULL,	15,	'Class Status',	15,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(12,	NULL,	16,	'Class Level',	16,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(13,	NULL,	17,	'Shift',	17,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(14,	NULL,	6,	'Exam Type',	6,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(15,	NULL,	7,	'Internship Place',	7,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(16,	NULL,	18,	'Staff Type',	18,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(17,	NULL,	19,	'Staff Position',	19,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(18,	NULL,	20,	'Staff',	20,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(19,	NULL,	21,	'Study Score',	21,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(20,	NULL,	22,	'Study Note',	22,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(21,	NULL,	23,	'Exam Control',	23,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(22,	NULL,	24,	'Exam Answer Sheet',	24,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(23,	NULL,	26,	'Exam Subject',	26,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(24,	NULL,	27,	'Exam Candidate',	27,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(25,	NULL,	28,	'Group',	28,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(26,	NULL,	29,	'Student Intern Place',	29,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(27,	NULL,	30,	'Class Image',	30,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(28,	NULL,	31,	'Attendance',	31,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(29,	NULL,	32,	'Student Score',	32,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(30,	NULL,	33,	'Contact',	33,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(31,	NULL,	34,	'About',	34,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(32,	NULL,	35,	'About Child',	35,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(33,	NULL,	36,	'Trainer',	36,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(34,	NULL,	37,	'Course',	37,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(35,	NULL,	38,	'Partner',	38,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(36,	NULL,	39,	'Question',	39,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(37,	NULL,	40,	'Gallery',	40,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(38,	NULL,	41,	'Video',	41,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(39,	NULL,	42,	'Work Day',	42,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(40,	NULL,	43,	'Exam Score',	43,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(41,	NULL,	44,	'Album',	44,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(42,	NULL,	45,	'Slide',	45,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(43,	NULL,	46,	'Qoute',	46,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(44,	NULL,	47,	'User Feedback',	47,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(45,	NULL,	48,	'Training Video',	48,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(46,	NULL,	49,	'Training Video Category',	49,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40'),
(47,	NULL,	10,	'Branch',	10,	'2023-06-22 01:37:40',	'2023-06-22 01:37:40');

DROP TABLE IF EXISTS `pages`;
CREATE TABLE `pages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`title`)),
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`content`)),
  `type` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `partners`;
CREATE TABLE `partners` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `facebook` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `google_map` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) NOT NULL,
  `international` tinyint(4) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `partners` (`id`, `name`, `image`, `phone`, `facebook`, `address`, `google_map`, `status`, `international`, `created_at`, `updated_at`) VALUES
(1,	'Serge Comtesse Sensory Prestige',	'/8aadh1628845200485Serge Comtesse Sensory Prestige-01-6cbd3b1c-34a9-4700-9258-94bcc6c08fc4.png',	'023966263',	NULL,	'#21, St.136 corner St.49 (Near Phsar Tapang), Phsar Thmey 3, Daun Penh, Phnom Penh',	'https://www.google.com.kh/maps/place/Salon+Serge+Comtesse/@11.569235,104.9214303,17z/data=!3m1!4b1!4m5!3m4!1s0x31095146f26b61ab:0xa45af8420e9937cf!8m2!3d11.5692484!4d104.9236739?hl=en&shorturl=1',	1,	0,	'2023-04-25 07:40:43',	'2023-04-25 07:40:43'),
(2,	'Leekaja Salon Olympia Mall Branch',	'/Leekaja-3077e031-e0ad-40b5-bb18-fd073ab9a873.jpg',	'069666908',	NULL,	'Near Sovanna Mall, Chamkar Mon, Phnom Penh',	'https://maps.google.com?q=11.5470552,104.9013366',	1,	0,	'2023-04-27 02:38:06',	'2023-06-06 19:44:48'),
(3,	'Leekaja Salon TK Branch',	'/Leekaja-3077e031-e0ad-40b5-bb18-fd073ab9a873.jpg',	'095443944',	NULL,	'St 516, Toul Kork, Phnom Penh',	'https://maps.google.com?q=11.5837114,104.9007802',	1,	0,	'2023-04-27 02:38:58',	'2023-06-06 19:45:10'),
(4,	'Por Highlight I (Kirirom)',	'/Por (Hight Light)-d16e8d74-dcad-4407-894f-e8370137d615.jpg',	'012947647| 015535356',	NULL,	'home158,street143, Phnom Penh, Cambodia, 91012',	'https://www.google.com/maps/dir/11.5344235,104.8804897/11.5532826,104.9159976/@11.545593,104.880807,14z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-04-27 02:39:35',	'2023-06-06 19:32:53'),
(5,	'Puy Salon II',	'/ve8djj1630118385679eflp1a1624588843516resize-16245887241407299024Puy-38f5d583-9e38-42e2-8c0a-dc0fe63b8bee.jpg',	'012298997',	NULL,	'Chip Mong 598, Sen Sok, Phnom Penh',	'https://maps.google.com?q=11.5397675,104.9253048',	1,	0,	'2023-04-27 02:40:18',	'2023-04-27 02:40:18'),
(6,	'Neak Beauty Salon',	'/Neak Beauty Salon-5edeccc1-8a84-4ea5-8c0e-98130c9bccc5.jpg',	'093666696',	NULL,	'Sisophon, Bunteay Mean Chey',	'https://maps.google.com?q=13.5833288,102.9749179',	1,	1,	'2023-04-27 02:41:04',	'2023-06-06 19:53:51'),
(7,	'PRO STORE',	'/Pro Store-6cf0fda4-9527-469d-a426-24c00aacf520.jpg',	'089 22 07 01',	NULL,	'#24BE0, St.307, Sangkat Boeung Kok 2, Khan Toul Kork, Phnom Penh',	'https://www.google.com/maps/place/24B+St+307,+Phnom+Penh/@11.57737,104.8938229,17z/data=!3m1!4b1!4m6!3m5!1s0x310951776700a957:0xcef3066ea6f9b0d6!8m2!3d11.57737!4d104.8963978!16s%2Fg%2F11j90p439j?entry=ttu',	1,	0,	'2023-06-06 19:59:13',	'2023-06-06 19:59:13'),
(8,	'Nisay Nget',	NULL,	'010958171',	NULL,	'Kandal Province Takmaov (non b2b)',	NULL,	1,	0,	'2023-06-06 20:01:46',	'2023-06-06 20:01:46'),
(9,	'Seven Boutique Salon & Spa',	'/Seven Boutique-eb46699e-bd77-4446-98f7-de6e78665050.jpg',	'012924686',	NULL,	'Phnom Penh, B-88, St.Northbridge, Sen sok, Tek Thla',	'https://www.google.com/maps/dir/11.5344235,104.8804897/11.560768,104.8707237/@11.5467016,104.8650412,15z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-06-06 20:42:10',	'2023-06-06 20:42:10'),
(10,	'Haru Salon',	NULL,	'081887399/0763333602',	NULL,	'Phnom Penh, Borey Arata #127 , St.Aryam',	NULL,	1,	0,	'2023-06-06 20:46:01',	'2023-06-06 20:46:01'),
(11,	'Rose\'s Style Design Salon',	'/Rose\'s Style Design Salon-a3dbf353-a168-43bc-b0fe-0cc26c35d2d9.jpg',	'+856205698956',	NULL,	'Laos |',	NULL,	1,	0,	'2023-06-06 20:50:24',	'2023-06-06 20:50:24'),
(12,	'Rady salon',	'/Rady salon-1e30a094-d4a8-44ee-a840-ee86a856a8da.jpg',	'012260434/089424253',	NULL,	'Phnom Penh, Beoung Keng Korng Market Near xang Lech',	NULL,	1,	0,	'2023-06-06 20:56:33',	'2023-06-06 20:56:33'),
(13,	'Por Por Salon',	'/Por Por Salon-b46d5965-1743-4bde-b603-0fdb4c9bff66.jpg',	'077993994',	NULL,	'Phnom Penh, Beoung Trabek #4 St.101',	'https://www.google.com/maps/dir/11.5344235,104.8804897/11.5411938,104.9210082/@11.5429067,104.883262,14z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-06-06 20:58:35',	'2023-06-06 20:58:35'),
(14,	'Best Beauty Salon',	'/Best Beauty Salon-5ffd8ab1-f141-41ff-baf5-6961aaf02584.jpg',	'0966569987',	NULL,	'Phnom Penh, chbar ampoy,ST 654',	NULL,	1,	0,	'2023-06-06 21:00:17',	'2023-06-06 21:00:17'),
(15,	'Pingping salon',	NULL,	'0767898888',	NULL,	'Phnom Penh, borey phenghout beong snoav st.22 #02 project6',	NULL,	1,	0,	'2023-06-06 21:06:41',	'2023-06-06 21:06:41'),
(16,	'Hong New York Hair Salon',	'/Hong New York Hair Salon-052c4efd-7ab3-4aaf-8211-a37529e40553.jpg',	'096 46 60 289',	NULL,	'Phnom Penh, #75, St294, BKK1',	'https://www.google.com/maps/dir//New+York+Hair+cut+%26+Salon,+23+St+57,+Phnom+Penh/@11.5536569,104.9222477,17z/data=!4m8!4m7!1m0!1m5!1m1!1s0x3109518e47b49945:0xe92afa8cdd034492!2m2!1d104.9248226!2d11.5536517?entry=ttu',	1,	0,	'2023-06-07 15:05:18',	'2023-06-07 15:05:34'),
(17,	'Famouse Salon',	NULL,	'099319098',	NULL,	'Phnom Penh, Borey Chip Mong 598',	NULL,	1,	0,	'2023-06-07 15:18:53',	'2023-06-07 15:18:53'),
(18,	'Up To You Beauty Sihanoukville',	NULL,	'068217115',	NULL,	'Sihanoukville province / St 1074',	NULL,	1,	0,	'2023-06-07 15:19:57',	'2023-06-07 15:19:57'),
(19,	'Balyna Spa & Salon',	NULL,	'016492207',	NULL,	'Phnom Penh,',	NULL,	1,	0,	'2023-06-07 15:20:47',	'2023-06-07 15:20:47'),
(20,	'Singapore Salon',	'/Singapore Salon-04dee550-51bc-44c8-bb92-6ffbacc07d4b.jpg',	'012845422',	NULL,	'Phnom Penh, BKK near ABA tra sak paem St:63 corner St:274',	'https://www.google.com/maps/dir/11.5344235,104.8804897/11.5430731,104.912636/@11.5429067,104.8790646,14z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-06-07 17:27:51',	'2023-06-07 17:27:51'),
(21,	'Polin Salon Eyelash and Nail',	'/Polin Salon Eyelash and Nail-c2c20c1e-00f9-48d5-8166-a8e9928a1682.jpg',	'086999321',	NULL,	'Phnom Penh, st.294 BKK',	'https://www.google.com/maps/dir/?api=1&destination=11.553182742233%2C104.92436796655&fbclid=IwAR1S5Emwa1Liqbiwd-HIZcbN6JurKhJYgL8pn6mYc8DfmWe30GBQlt1cjyQ',	1,	0,	'2023-06-08 15:06:32',	'2023-06-08 15:06:32'),
(22,	'Sophorn Barber',	NULL,	'081565600',	NULL,	'Kandal Province',	NULL,	1,	0,	'2023-06-08 15:07:57',	'2023-06-08 15:07:57'),
(23,	'A Plus Salon',	'/A Plus Salon-2f4c3a53-95da-46e8-8f32-fc20d996dc17.jpg',	'093680868',	NULL,	'Phnom Penh, Teong laork3 , TK #13B st.253',	'https://www.google.com/maps/dir/?api=1&destination=11.55756819986%2C104.89905685186&fbclid=IwAR3PnYjsfrtxwrXfN1BnO-zn7lqqmJqlmpYKtAuu4VyIa8BcqcplXMJqqNo',	1,	0,	'2023-06-08 15:09:33',	'2023-06-08 15:09:33'),
(24,	'De1 Salon By Vid &PK',	'/De1 Salon By Vid &PK-ef2020bf-09f0-41f9-96cf-5c1c233d8dd9.jpg',	'070767765/077799951',	NULL,	'Phnom Penh,',	'https://www.google.com/maps/dir/11.5344235,104.8804897/11.5582539,104.8873678/@11.5462264,104.8744482,15z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-06-08 15:11:48',	'2023-06-08 15:11:48'),
(25,	'La Boutique Salon',	'/La Boutique Salon-2f3fb873-3e24-4bdd-a512-2d1bcdf476fc.jpg',	'010422245',	NULL,	'Phnom Penh,',	'https://www.google.com/maps/dir/11.5344235,104.8804897/11.5507506,104.9248734/@11.5429051,104.8676493,13z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-06-08 15:13:44',	'2023-06-08 15:13:44'),
(26,	'Moon Light',	'/Moon Light-dc2ebb2d-503b-47bf-80ec-fbdc54bdc034.jpg',	'085776689',	NULL,	'Phnom Penh,',	'https://www.google.com/maps/dir/11.5344235,104.8804897/11.5601677,104.9195083/@11.5474713,104.8830452,14z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-06-08 15:16:02',	'2023-06-08 15:16:02'),
(27,	'Joulie Salon',	NULL,	'0966569987',	NULL,	'PP, Chbar Ampov | st.654',	NULL,	1,	0,	'2023-06-08 15:23:28',	'2023-06-08 15:23:28'),
(28,	'Kanatya Beauty Center',	'/Kanatya Beauty Center-a09c646d-a6d6-4157-a88b-b088431beed3.jpg',	'092 9999 78 / 098 711 111',	NULL,	'PP, Boeung Keng Kang | #11, St.57 corner St.282, BKK 1',	'https://www.google.com/maps/dir/11.5344235,104.8804897/11.5543612,104.9247131/@11.5455915,104.8676353,13z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-06-08 15:27:11',	'2023-06-08 15:27:11'),
(29,	'The Glame Salon',	NULL,	'00',	NULL,	'Phnom Penh, chroychangva',	NULL,	1,	0,	'2023-06-08 15:28:12',	'2023-06-08 15:28:12'),
(30,	'Belyna Spa & Salon',	'/Belyna Spa & Salon-0f7d83cd-6ac3-40e6-a377-9ecd54fc6ef5.jpg',	'016492207',	NULL,	'St310 Near St.143 , Phnom Penh',	'https://www.google.com/maps/dir/11.5344235,104.8804897/11.5508499,104.9160486/@11.5438187,104.8807531,14z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-06-08 15:37:49',	'2023-06-08 15:37:49'),
(31,	'KBS Beauty Salon',	'/KBS Beauty Salon-d754df71-c649-4334-a042-275caab9011a.jpg',	'095 80 54 81 / 096 680 4698',	NULL,	'PP, Sen Sok | #191, St.2011 (Oknha Try Heng)',	'https://www.google.com/maps/dir/11.5344235,104.8804897/11.576313,104.8541647/@11.5544695,104.8492531,14z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-06-08 15:40:24',	'2023-06-08 15:40:24'),
(32,	'Nuon House Of Beauty',	'/Nuon House Of Beauty-62fa8c26-8ca3-4021-9d10-afcc8753bd90.jpg',	'078611191',	NULL,	'Phnom Penh,',	'https://www.google.com/maps/dir/11.5344235,104.8804897/11.5590201,104.92153/@11.5464579,104.8835144,14z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-06-08 15:43:34',	'2023-06-08 15:43:34'),
(33,	'M Salon & Spa  SP',	'/M Salon & Spa  SP-fd7d9b4e-2868-44b5-9b89-66f2b80d11e9.jpg',	'087 633 168',	NULL,	'Phnom Penh,',	'https://www.google.com/maps/dir/11.5344235,104.8804897/11.5315816,104.9579501/@11.5334602,104.884308,13z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-06-08 15:45:35',	'2023-06-08 15:45:35'),
(34,	'Nuy Nuy Salon',	'/Nuy Nuy Salon-8a23ba3e-9836-4329-a4e9-949fac25b04e.jpg',	'093868699',	NULL,	'Kandal Province Takmaov',	'https://www.google.com/maps/dir/11.5344235,104.8804897/11.4818103,104.9495468/@11.4957907,104.8800575,13z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-06-08 15:47:25',	'2023-06-08 15:47:25'),
(35,	'Heja Salon',	'/Heja Salon-1acb1363-dba8-4e1b-8e7e-254f6dc4ab88.jpg',	'077 998 877',	NULL,	'Phnom Penh, st 566, TK',	NULL,	1,	0,	'2023-06-08 15:50:02',	'2023-06-08 15:50:02'),
(36,	'Nessara Beauty Bar',	NULL,	'00',	NULL,	'Phnom Penh, Tk',	NULL,	1,	0,	'2023-06-08 17:38:07',	'2023-06-08 17:38:07'),
(37,	'Malis Salon - TK',	NULL,	'012393678',	NULL,	'Tk',	NULL,	1,	0,	'2023-06-08 17:39:27',	'2023-06-08 17:39:27'),
(38,	'Lovish Salon',	'/Lovish Salon-f2e9d899-1141-4f01-aca9-be041d93254a.jpg',	'016224554',	NULL,	'Phnom Penh, TK',	'https://www.google.com/maps/dir/11.5344235,104.8804897/11.5274098,104.9605753/@11.5334602,104.884646,13z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-06-08 17:45:02',	'2023-06-08 17:45:36'),
(39,	'Vin Phea Hair & Nail Salon',	'/Vin Phea Hair & Nail Salon-6a7bfc71-665f-476b-b341-f8e4e17d036f.jpg',	'081444567',	NULL,	'Battdom bong Province',	'https://www.google.com/maps/dir/11.5344235,104.8804897/13.1014651,103.1965971/@12.3150473,102.9171763,8z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-06-08 17:50:59',	'2023-06-08 17:50:59'),
(40,	'Judy Salon',	'/Judy Salon-7aa83a77-350a-4957-8b46-6f6e45c4d278.jpg',	'068959959',	NULL,	'Phnom Penh, Chak Ang Rea Ler',	'https://www.google.com/maps/dir/11.5344235,104.8804897/11.521688,104.9234759/@11.5268645,104.8658129,13z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-06-08 17:53:30',	'2023-06-08 17:53:30'),
(41,	'Samatha Salon',	'/Samatha Salon-a354356b-36e9-48c1-bab3-d0611e6c716f.jpg',	'0968657321/012333133',	NULL,	'Phnom Penh, St,278 #7cd Bkk1',	'https://www.google.com/maps/dir/11.5344235,104.8804897/11.577632,104.9057436/@11.5560208,104.8769218,14z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-06-08 19:10:15',	'2023-06-08 19:10:15'),
(42,	'Sopois Salon',	NULL,	'092210706',	NULL,	'Kandal Province',	NULL,	1,	0,	'2023-06-08 19:11:22',	'2023-06-08 19:11:22'),
(43,	'Leekaja Salon - Mega Mall 271',	'/Leekaja-3077e031-e0ad-40b5-bb18-fd073ab9a873.jpg',	'077704444',	NULL,	'Phnom Penh, Chip mong St.271',	NULL,	1,	0,	'2023-06-08 19:13:46',	'2023-06-08 19:14:34'),
(44,	'Vivorn New',	'/Vivorn New-17c51094-2c2c-4279-89c6-2fa64fee40a9.jpg',	'016923330',	NULL,	'PP, Russey Keo | #C017, Borey keila',	NULL,	1,	0,	'2023-06-08 19:16:33',	'2023-06-08 19:16:33'),
(45,	'Phuong Salon',	NULL,	'012238839',	NULL,	'Phnom Penh, Phsathmey',	NULL,	1,	0,	'2023-06-08 19:23:24',	'2023-06-08 19:23:24'),
(46,	'P1 salon',	'/P1 salon-cec1c0e6-4df5-4928-9b56-f86da55d10cb.jpg',	'093434003',	NULL,	'PP, Toul Kork | #13, st.156, Depo Market',	'https://www.google.com/maps/dir/11.5344235,104.8804897//@11.5344151,104.8104491,12z/data=!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-06-08 19:25:51',	'2023-06-08 19:25:51'),
(47,	'Meet Salon',	'/Meet Salon-663d28e3-c529-44cd-b8e7-ed7d76448fdd.png',	'077636668',	NULL,	'Phnom Penh,',	'https://www.google.com/maps/dir/11.5344235,104.8804897/11.5933746,104.8714989/@11.5632632,104.8576039,14z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-06-08 19:34:20',	'2023-06-08 19:34:20'),
(48,	'Sonita Salon',	'/Sonita Salon-433c1a42-9b64-47a9-9254-5150f9233eb8.jpg',	'012293049',	NULL,	'Phnom Penh,',	'https://www.google.com/maps/dir/11.5344235,104.8804897/11.5720785,104.927545/@11.5531704,104.8691397,13z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-06-08 19:37:05',	'2023-06-08 19:37:05'),
(49,	'Oh Oh 57 Salon',	'/Oh Oh 57 Salon-0ee5faf9-bead-4a2c-ad21-f4f228cf4b0c.jpg',	'093390990',	NULL,	'Phnom Penh, BKK1, St.57 Corner370',	'https://www.google.com/maps/dir/11.5344235,104.8804897/11.5477029,104.9258796/@11.5429051,104.8681402,13z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-06-08 19:42:57',	'2023-06-08 19:42:57'),
(50,	'chhar kvai Salon',	NULL,	'0962702804',	NULL,	'Phnom Penh, Jomkadong St.9 #349 Komrong1',	NULL,	1,	0,	'2023-06-08 19:58:30',	'2023-06-08 19:58:30'),
(51,	'Vichea Beauty & Salon',	'/Vichea Beauty & Salon-be886c8b-0637-482d-882c-4097a47c3ee5.jpg',	'011858558',	NULL,	'Phnom Penh, Borey Oderm2',	NULL,	1,	0,	'2023-06-08 19:59:57',	'2023-06-08 19:59:57'),
(52,	'Mey Ing Nail & Salon',	NULL,	'098 889 787',	NULL,	'Phnom Penh, Market Kandal',	NULL,	1,	0,	'2023-06-08 20:01:02',	'2023-06-08 20:01:02'),
(53,	'Srey Mov Salon',	NULL,	'087408470',	NULL,	'Phnom Penh, st 310, #132',	NULL,	1,	0,	'2023-06-08 20:02:02',	'2023-06-08 20:02:02'),
(54,	'ReakSmey Veasna salon',	NULL,	'012 52 78 64',	NULL,	'Sream reab',	NULL,	1,	0,	'2023-06-09 13:17:01',	'2023-06-09 13:17:01'),
(55,	'Sok Mong Kul Salon',	NULL,	'012922245',	NULL,	'Kampong Speu',	NULL,	1,	0,	'2023-06-09 13:18:43',	'2023-06-09 13:18:43'),
(56,	'Sa Phong Salon',	NULL,	'011892622',	NULL,	'Phnom Penh,',	NULL,	1,	0,	'2023-06-09 13:19:30',	'2023-06-09 13:19:30'),
(57,	'SKM Hair Beauty',	NULL,	'0966569987',	NULL,	'Phnom Penh, Chbar Am Pov',	NULL,	1,	0,	'2023-06-09 13:21:24',	'2023-06-09 13:21:24'),
(58,	'Hair Maison',	'/Hair Maison-299e6f99-5e9b-4671-8347-c9f4fa939628.jpg',	'086819188',	NULL,	'Phnom Penh BKK 306 Social space',	'https://www.google.com/maps/dir/11.5344235,104.8804897/11.5525756,104.928468/@11.5433689,104.8694442,13z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-06-09 13:28:40',	'2023-06-09 13:28:40'),
(59,	'Famous Salon Koh Pich',	NULL,	'099319098',	NULL,	'PP, Chamkar Mon | Koh Pich',	NULL,	1,	0,	'2023-06-09 13:30:57',	'2023-06-09 13:30:57'),
(60,	'P5 Salon & Barber',	'/P5 Salon & Barber-1df2ac25-8afa-4497-b531-16a8501a7880.jpg',	'098466112',	NULL,	'Phnom Penh, St.156 Cross St.257 Teklaork2, TK',	'#P5 Salon&BarBer 2 សាខា យុគន្ធរ',	1,	0,	'2023-06-09 13:33:56',	'2023-06-09 13:34:21'),
(61,	'Hang Beauty & Collection',	'/Hang Beauty & Collection-c6e7f94b-140f-4bbc-8557-86378ef528f3.jpg',	'015826888',	NULL,	'Phnom Penh, Stong Meanchey St. sony',	'https://www.google.com/maps/dir/11.5344235,104.8804897/11.5472606,104.8861341/@11.5409491,104.8783798,16z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-06-09 13:37:14',	'2023-06-09 13:37:14'),
(62,	'7am Salon',	'/7am Salon-dba3c8ad-fdce-4ed7-96d2-0ab927db192c.jpg',	'070 457 945/015457945',	NULL,	'Stt 261 បឹងសាឡាង, Phnom Penh, Cambodia',	NULL,	1,	0,	'2023-06-21 14:03:54',	'2023-06-21 14:03:54'),
(63,	'98 Studio Salon',	'/98 Studio Salon-d009abef-4106-49ec-ae40-83039c11e1e5.jpg',	'010567886',	NULL,	'Kampong Speu Province',	'https://www.google.com/maps/dir/11.5344235,104.8804897/11.4595265,104.5083421/@11.5091297,104.4141532,10z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-06-21 14:45:55',	'2023-06-21 14:45:55'),
(64,	'Dalin Salon(Olampic)',	NULL,	'010241024',	NULL,	'Phnom Penh, Olampic Market',	NULL,	1,	0,	'2023-06-21 15:32:57',	'2023-06-21 15:32:57'),
(65,	'Bong Toch Salon',	NULL,	'0972456105',	NULL,	'Phnom Penh, Jomkadong, Near Sareorn Market',	NULL,	1,	0,	'2023-06-21 15:35:05',	'2023-06-21 15:35:05'),
(66,	'Kaknika Salon I',	'/Kaknika Salon I-63b9c87f-130a-4378-90e0-81aeaa324ab0.jpg',	'097 622 2259',	NULL,	'Chipmong271 Phnom Penh, Cambodia 12354., Phnom Penh, Cambodia',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5176953,104.9219026/@11.5486109,104.8799549,13z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-06-30 19:32:52',	'2023-06-30 19:32:52'),
(67,	'Vanny Da Beauty Salon',	NULL,	'012 935 466',	NULL,	'ទីតាំងបុរីពិភពថ្មី1ចំការដូង/ផ្ទះលេខ100/ផ្លូវ6A',	NULL,	1,	0,	'2023-06-30 20:02:21',	'2023-06-30 20:02:21'),
(68,	'Sasa Salon',	'/Sasa Salon-a75d4902-bbc0-48f7-8aa1-764aa100f2f5.jpg',	'00',	NULL,	'60M , Phnom Penh, Cambodia',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.4749548,104.8918484/@11.525128,104.8588633,13z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-06-30 20:07:57',	'2023-06-30 20:07:57'),
(69,	'Beautify Salon',	'/Beautify Salon-de3e50f8-eff6-45fe-a180-a98b419f5d23.jpg',	'085 849 656',	NULL,	'street2004, Phnom Penh, Phnom Penh, Cambodia',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5508656,104.8792166/@11.5641726,104.8741546,14z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-06-30 20:13:49',	'2023-06-30 20:13:49'),
(70,	'Srey orm Salon',	'/Srey orm Salon-1e263575-3caf-4f7d-a93e-5d7124b1f4c9.jpg',	'010 363 596',	NULL,	'Phnom Penh, Cambodia',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5118459,104.8813176/@11.5446391,104.8525795,13z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-06-30 21:01:34',	'2023-06-30 21:01:34'),
(71,	'Dalin Salon',	NULL,	'010491112',	NULL,	'Phnom Penh, Toul Pongror Market',	NULL,	1,	0,	'2023-06-30 21:04:25',	'2023-06-30 21:04:25'),
(72,	'Lyly Salon',	NULL,	'012831424',	NULL,	'Kandal Province, takaov Market',	NULL,	1,	0,	'2023-06-30 21:09:05',	'2023-06-30 21:09:05'),
(73,	'NaNa Yon Hair Salon',	'/NaNa Yon Hair Salon-309c873e-5b1e-4e84-b6a7-ebd4ac30d32f.jpg',	'099 868 556',	NULL,	'Toul Kouk, Phnom Penh, Cambodia',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5745056,104.9041796/@11.5760078,104.9028847,18z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-06-30 21:13:08',	'2023-06-30 21:13:08'),
(74,	'MOON SALON',	NULL,	'011 895 557/087446285',	NULL,	'N/A',	NULL,	1,	0,	'2023-07-01 17:33:32',	'2023-07-01 17:33:32'),
(75,	'VICCI Beauty Bar',	NULL,	'010536355/078838889',	NULL,	'Phnom Penh, Sonthormok (stop Tepon 100m)',	NULL,	1,	0,	'2023-07-01 18:17:19',	'2023-07-01 18:17:19'),
(76,	'Daily Salon Co., Ltd.',	NULL,	'078777122/078777113',	NULL,	'PP, Daun Penh | Exchange Square Mall 1st Floor , St.106',	NULL,	1,	0,	'2023-07-01 18:21:03',	'2023-07-01 18:21:03'),
(77,	'Kimla Salon',	NULL,	'0886866886',	NULL,	'Steuong Streng Province',	NULL,	1,	0,	'2023-07-01 19:04:03',	'2023-07-01 19:04:03'),
(78,	'July Salon',	NULL,	'012888890',	NULL,	'Phnom Penh, Dun Penh, St.19',	NULL,	1,	0,	'2023-07-01 19:08:24',	'2023-07-01 19:08:24'),
(79,	'Mickey Salon',	'/Mickey Salon-c30f21bd-5fa8-407f-905d-af4afe465fa8.jpg',	'070/010948694',	NULL,	'Battambong Province',	'https://www.google.com/maps/dir/11.5774458,104.9038456/13.0972989,103.1966369/@12.3351879,102.9292076,8z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-01 19:13:33',	'2023-07-01 19:13:33'),
(80,	'Wow Salon',	'/Wow Salon-5a361a30-1cda-466d-a5f0-6feef8b27316.jpg',	'078735557/016811477',	NULL,	'139, Phnom Penh, Cambodi',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.566553,104.9145737/@11.5730322,104.9017169,15z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-01 19:35:24',	'2023-07-01 19:35:24'),
(81,	'Mo Salon',	'/Mo Salon-4432116f-2daa-4b74-ba4d-95f50fd5848f.jpg',	'093 837 778',	NULL,	'PP, Boeung Keng Kang | #33z, St.167, Phsar Olympic',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5519161,104.9130836/@11.5656269,104.9005493,15z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-01 20:13:14',	'2023-07-01 20:13:14'),
(82,	'Gallery House Salon',	'/Gallery House Salon-e3ae3705-6adc-46b7-abd5-be777fe4ff7f.png',	'093282001/',	NULL,	'Phnom Penh, sen sok #45B, St.18E',	NULL,	1,	0,	'2023-07-01 20:20:25',	'2023-07-01 20:20:25'),
(83,	'Jame Barber',	NULL,	'0888299550',	NULL,	'Phnom Penh, Chamka Mon /Phsa Derm Tkov',	NULL,	1,	0,	'2023-07-03 13:44:31',	'2023-07-03 13:44:31'),
(84,	'The Vine Salon',	NULL,	'086543567',	NULL,	'PP, Daun Penh | #84, St.244, Sangkat Chaktomuk',	NULL,	1,	0,	'2023-07-03 13:45:09',	'2023-07-03 13:45:09'),
(85,	'Ah Mouy Salon',	'/Ah Mouy Salon-297805c3-bcaa-4eb4-8a74-e8dc892bcd0d.jpg',	'010886469/093 975 031',	NULL,	'Phnom Penh, Boeng Keng Korng',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5471037,104.9252956/@11.563255,104.8987953,14z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-03 14:04:49',	'2023-07-03 14:04:49'),
(86,	'The Y Home',	'/The Y Home-161cf438-466b-4929-bf82-c83bde04b7a1.jpg',	'093 733 456',	NULL,	'271, Phnom Penh, Cambodia',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5310139,104.8866248/@11.5542342,104.8794555,14z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-03 14:16:44',	'2023-07-03 14:16:44'),
(87,	'Lakshmi Beauty & Spa',	'/Lakshmi Beauty & Spa-832066a6-6703-4b9e-a681-7378116443d6.jpg',	'089 699 289/071 888 1289/069 696 655',	NULL,	'39B,st 476 កែង430 ខាងជើងរង្វង់មូលនាងមច្ឆា ផ្សារសន្សំកុសល,សង្កាត់ទួលទំពូងទី២ ខណ្ឌចំការមន រាជធានី ភ្នំពេញ',	NULL,	1,	0,	'2023-07-03 14:21:37',	'2023-07-03 14:21:37'),
(88,	'Heng Heng Salon',	NULL,	'096 614 3535/061423333',	NULL,	'PP, Touk Kork |  #211, st.257, Teok laork 2',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5640491,104.8960203/@11.5707368,104.8957713,16z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-03 14:28:04',	'2023-07-03 14:28:04'),
(89,	'Salon 71',	'/Salon 71-34ec6fd2-0cb0-40c1-a7ab-c29129b36b7d.jpg',	'098 987 356/071 711 1171',	NULL,	'Phnom Penh, Chamkar Mon | St.71',	'https://www.google.com/maps/place/SALON+71/@11.5627098,104.8925419,14z/data=!4m20!1m13!4m12!1m4!2m2!1d104.9038456!2d11.5774458!4e1!1m6!1m2!1s0x310951431529d3a5:0x9d8c393bb286bafa!2sSALON+71,+GWWF%2B85X,+St+71,+Phnom+Penh!2m2!1d104.9229984!2d11.5458644!3m5!1s0x310951431529d3a5:0x9d8c393bb286bafa!8m2!3d11.545861!4d104.9229766!16s%2Fg%2F11rv2vkkhj?entry=ttu',	1,	0,	'2023-07-03 14:33:18',	'2023-07-03 14:33:18'),
(90,	'The Den Salon',	'/The Den Salon-eab5386c-c5aa-43fc-9c1d-2067365b3db1.jpg',	'010650505/',	NULL,	'#44Eo,street 113 phum 6 BKK3 Phnom Penh, 12303, Phnom Penh, Cambodia',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5502994,104.9179265/@11.564931,104.9035374,15z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu010 650 505',	1,	0,	'2023-07-03 14:38:28',	'2023-07-03 14:38:28'),
(91,	'O 57 Salon',	'/O 57 Salon-87e3bf74-0b2e-4ffa-82a9-df3a6ba54009.jpg',	'096227003',	NULL,	'Phnom Penh, Boeng Keng Korng',	NULL,	1,	0,	'2023-07-03 14:40:16',	'2023-07-03 14:40:16'),
(92,	'Beauty Room',	'/Beauty Room-cb9ca601-2751-4c0e-be2c-c6e131fd7fa9.jpg',	'088 822 2841',	NULL,	'st 598, Phnom Penh, Cambodia',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.6294232,104.8901975/@11.6039948,104.8777987,14z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-03 14:45:15',	'2023-07-03 14:45:15'),
(93,	'Sister Salon',	NULL,	'015373837',	NULL,	'Phnom Penh, Sen Sok | #79A, St 2004, Borey Phnom Penh Thmey',	NULL,	1,	0,	'2023-07-03 14:47:53',	'2023-07-03 14:47:53'),
(94,	'Salon 27',	'/Salon 27-1f75a411-4190-4df5-a3aa-f8c233c825e3.png',	'017609720',	NULL,	'Phnom Penh, Toul Kork | St.273, #63W',	NULL,	1,	0,	'2023-07-03 14:50:23',	'2023-07-03 14:50:23'),
(95,	'Savada Salon',	'/Savada Salon-042b471e-a960-4e91-b128-ea08b0cf670e.jpg',	'089 650 085',	NULL,	'287E0 Street 182 , Phnom Penh, Cambodia',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5618132,104.8935342/@11.5696222,104.8902833,15z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-03 15:35:13',	'2023-07-03 15:35:13'),
(96,	'N5 Salon',	'/N5 Salon-4fe47ae4-bf44-4828-9dc9-7f7d6b02876a.jpg',	'069286818',	NULL,	'Phnom Penh, Sen Sok | #95, St.1015, Borey Chip Mong, Near Aeon Mall 2',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5943017,104.8733412/@11.5859026,104.8714286,14z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-03 15:48:36',	'2023-07-03 15:48:36'),
(97,	'Manolia Salon',	'/Manolia Salon-520262c3-699b-488a-b046-9137920567ca.jpg',	'012257007',	NULL,	'Phnom Penh, chamka Mon, St.278, BKK1',	NULL,	1,	0,	'2023-07-03 18:03:47',	'2023-07-03 18:03:47'),
(98,	'Emaly Salon',	NULL,	'069488777',	NULL,	'PP, Russey Keo | #8k, St.209, Borey Vimean PP 598',	NULL,	1,	0,	'2023-07-03 19:04:11',	'2023-07-03 19:04:11'),
(99,	'Vandy Singapore Salon',	NULL,	'012727616/017486633',	NULL,	'porchantong',	NULL,	1,	0,	'2023-07-03 19:10:23',	'2023-07-03 19:10:23'),
(100,	'The Face Salon',	NULL,	'010353195',	NULL,	'Preah sihaknouk Province',	NULL,	1,	0,	'2023-07-03 19:12:30',	'2023-07-03 19:12:30'),
(101,	'BM Salon',	'/BM Salon-6a00f8c6-184b-45f6-84ac-ae7a14358b90.jpg',	'088 792 5665/098563451',	NULL,	'ផ្លូវអិលវីចាស់ ជិតសង្កាត់លេខ4, Sihanoukville (city), Cambodi',	'https://www.google.com/maps/dir/11.5774458,104.9038456/10.6171263,103.5339151/@11.0912666,103.6588381,9z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-03 19:59:49',	'2023-07-03 19:59:49'),
(102,	'M&A Beauty Center - Salon',	'/M&A Beauty Center - Salon-46ea061f-19b2-4731-8d0d-8476c5b410bf.jpg',	'086 808 125',	NULL,	'67 Preah Trasak Paem St. (63), Phnom Penh, Cambodia, Phnom Penh, Cambodia',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5591095,104.9224701/@11.5692322,104.9056629,15z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-03 20:07:20',	'2023-07-03 20:07:20'),
(103,	'Jol Mlob Salon',	'/Jol Mlob Salon-073df4c7-d2bd-4ed8-9fa5-f370e8293801.jpg',	'078 350 202/098350202',	NULL,	'Phnom Penh Hanoi Friendship Blvd. (1019), Phnom Penh, Phnom Penh, Cambodia',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5636816,104.8710224/@11.5700855,104.8703265,14z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-03 20:21:34',	'2023-07-03 20:21:34'),
(104,	'Mana Salon',	NULL,	'017989988',	NULL,	'Vimean PP',	NULL,	1,	0,	'2023-07-04 12:56:36',	'2023-07-04 12:56:36'),
(105,	'U2BE Sen Sok',	NULL,	'077 / 070 444 487',	NULL,	'Phnom Penh, Sen Sok | A7, Building C, Green Community Mall',	NULL,	1,	0,	'2023-07-04 12:58:59',	'2023-07-04 12:58:59'),
(106,	'Nail Palace',	'/Nail Palace-cbacd75e-fed6-4748-8603-213bd9c8ea10.jpg',	'0962993333/089 289 222',	NULL,	'Phnom Penh, Toul Kork | #20, St.289\r\n191Eo street 63, Sangkat Boeng Keng kong 1, Phnom Penh, Cambodia',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5522057,104.923543/@11.5658913,104.9049268,15z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-04 13:03:25',	'2023-07-04 13:03:25'),
(107,	'Green Barber7',	'/Green Barber7-53ebef4d-b7e3-4a9c-92b5-39dad6ef7b80.jpg',	'093795579',	NULL,	'Phnom Penh, Tuol Kork | Kampuchea Krom, St.221\r\n09D, Street 221, , Phnom Penh, Cambodia',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5683642,104.9049979/@11.5729158,104.8998001,16z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-04 13:07:03',	'2023-07-04 13:07:03'),
(108,	'Dee\'s Studio Hair Salon',	NULL,	'069431549',	NULL,	'Phnom Penh, Toul Kork | St.160, Sangkat Tek laork\r\n#74 St 160 Khan Toul Kok',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5623555,104.8934511/@11.5698975,104.8902833,15z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-04 13:10:03',	'2023-07-04 13:11:07'),
(109,	'Agas Stro Beauty',	'/Agas Stro Beauty-25158c34-877a-4268-a32a-982fc16ae199.jpg',	'089286478',	NULL,	'Phnom Penh, Meanchey , Bong tompun sonsom kusol Pagoda',	NULL,	1,	0,	'2023-07-04 13:14:40',	'2023-07-04 13:14:40'),
(110,	'PUY Salon 598',	'/PUY Salon 598-950bb4d3-ba9d-45c6-9bc6-3e1b14345ccd.jpg',	'086 597 598',	NULL,	'Puy Salon 598 https://goo.gl/maps/gix9UWP9c7dK8suVA, Phnom Penh, Cambodia',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.6313501,104.8885446/@11.6050263,104.8769007,14z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-04 13:16:39',	'2023-07-04 13:16:39'),
(111,	'Madam C Spa & Salon',	'/Madam C Spa & Salon-00d83c82-0536-4492-8069-75bd6019433f.jpg',	'012 299 656',	NULL,	'Phnom Penh, Chbar Ampov |',	NULL,	1,	0,	'2023-07-04 13:32:04',	'2023-07-04 13:32:04'),
(112,	'Narak Inside Beauty',	'/Narak Inside Beauty-c13e01c8-f9c3-4c94-99dd-9c5058243b9f.jpg',	'069500544/ 093 991 266',	NULL,	'Phnom Penh, Daun Penh | St.19 krouy vang\r\n#203Eo, St19, Cheychumneas, Daun Penh, Phnom Penh, Cambodia., Phnom Penh, Cambodia',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5629799,104.9283707/@11.5705426,104.8987031,14z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-04 14:30:14',	'2023-07-04 14:30:14'),
(113,	'Hair Style Keratin Studio',	NULL,	'086591015/0969142103',	NULL,	'Sihanouk Ville',	NULL,	1,	0,	'2023-07-04 14:31:50',	'2023-07-04 14:31:50'),
(114,	'Q Winnie Nail Salon',	'/Q Winnie Nail Salon-de1f1786-13ed-4918-ad9d-7e084bc56770.jpg',	'012 511 591/092377530',	NULL,	'Phnom Penh, Chamkar Mon | St.430 across St.450, TTP',	NULL,	1,	0,	'2023-07-04 14:40:08',	'2023-07-04 14:40:08'),
(115,	'King Barber',	'/King Barber-58811c46-1101-4cbc-b86f-e7eb3fb03ac3.jpg',	'070 745 410',	NULL,	'Phnom Penh, Boeung Keng Kang | St.143 corner St.288, #162, BKK 2\r\nSt143, Phnom Penh, Cambodia',	NULL,	1,	0,	'2023-07-04 17:41:23',	'2023-07-04 17:41:23'),
(116,	'Reach Salon',	'/Reach Salon-2ce28ff1-c5dc-4143-8487-90158f6f93d2.jpg',	'085776689',	NULL,	'Phnom Penh, 7 Makara | Orussey St. Plus',	NULL,	1,	0,	'2023-07-05 20:24:03',	'2023-07-05 20:24:03'),
(117,	'The Black Salon',	'/The Black Salon-1f6d0f46-7868-4c89-bd3c-81a9ecf4042c.jpg',	'081 888 831',	NULL,	'#120, street 51 inside PTT station first floor., Phnom Penh, Cambodia',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5587377,104.9253318/@11.5691535,104.9057879,15z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-05 20:31:48',	'2023-07-05 20:31:48'),
(118,	'NT Salon',	'/NT Salon-47125b87-0835-41f5-a36b-025a2b4ede9b.jpg',	'012 265 757/',	NULL,	'Toul kork, Phnom Penh, Cambodia',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5749553,104.8954759/@11.5757848,104.8951952,16z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-05 20:35:57',	'2023-07-05 20:35:57'),
(119,	'Sotheany Beauty Salon',	NULL,	'098 919 096/',	NULL,	'St1968, Phnom Penh, Cambodia',	NULL,	1,	0,	'2023-07-05 20:50:23',	'2023-07-05 20:50:23'),
(120,	'The Doll House  Hair Salon',	'/The Doll House  Hair Salon-dede2973-97fa-4403-a0b1-d0ad21309ed7.png',	'086252194/ 010 329 999',	NULL,	'No.39/41 , Street 240 Above The Shop, Phnom Penh, Cambodia\r\nPhnom Penh, Daun Penh | kroy vang St.240',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5599301,104.9282761/@11.5695534,104.8984933,14z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-06 13:50:00',	'2023-07-06 13:50:00'),
(121,	'Kromom Kon 3 Beauty Salon',	NULL,	'078685688',	NULL,	'Siem reap',	NULL,	1,	0,	'2023-07-06 14:31:00',	'2023-07-06 14:31:00'),
(122,	'Serey Morokut Salon',	NULL,	'093814659',	NULL,	'Phnom Penh, Por Senchey | Bek Chan',	NULL,	1,	0,	'2023-07-06 14:32:07',	'2023-07-06 14:32:07'),
(123,	'Socheat Salon',	'/Socheat Salon-14b7ca7b-71dd-45f9-92ff-0ff9f98de0b3.jpg',	'0963333404',	NULL,	'Phnom Penh, Toul Kork | #15, St.528 corner 335',	NULL,	1,	0,	'2023-07-06 14:44:31',	'2023-07-06 14:44:31'),
(124,	'U Salon',	NULL,	'01242799',	NULL,	'vimean Ekareach',	NULL,	1,	0,	'2023-07-06 14:51:06',	'2023-07-06 14:51:06'),
(125,	'Cindy ll & NK Salon - TK',	'/Cindy ll & NK salon-23e734cc-770e-4923-b9b9-ad7f37f1ecaa.jpg',	'017 216 813',	NULL,	'#44, st.310,  Bkk I, Chamkamon, Phnom Penh , Phnom Penh, Cambodia,',	NULL,	1,	0,	'2023-07-06 14:55:45',	'2023-07-06 14:55:45'),
(126,	'King & Queen Salon and Barber',	'/King & Queen Salon and Barber-cbc39cc5-933c-4585-8d74-27d5d55cdb49.jpg',	'086 368 998',	NULL,	'Cambodia, Phnom Penh, Cambodia',	'https://www.google.com/maps/search/King+%26+Queen+Salon+and+Barber/@11.9988449,32.8503254,3z?entry=ttu',	1,	0,	'2023-07-06 15:02:52',	'2023-07-06 15:02:52'),
(127,	'Mom Salon',	NULL,	'087882288',	NULL,	'Phnom Penh, Por Senchey | Bek Chan',	NULL,	1,	0,	'2023-07-06 15:05:44',	'2023-07-06 15:05:44'),
(128,	'La Reine Salon',	'/La Reine Salon-4ebd48ef-01ac-47e4-be96-e21f14cb8428.jpg',	'015 610 111',	NULL,	'#1-2 St.289, S/K Boeungkok I, Khan Toulkok , Phnom Penh, Cambodia',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5831815,104.9000975/@11.580667,104.9000692,17z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-06 15:11:14',	'2023-07-06 15:11:14'),
(129,	'Simple Barber',	NULL,	'069795007',	NULL,	'Phnom Penh, Chamkar Mon | TTP St.155,',	NULL,	1,	0,	'2023-07-06 15:12:27',	'2023-07-06 15:12:27'),
(130,	'PUY Salon 63',	NULL,	'012 298 997/098658422',	NULL,	'63, Phnom Penh, Cambodia, +85512298997  +85516826633',	'https://www.google.com/maps/search/63,+Phnom+Penh,+Cambodia,+%2B85512298997++%2B85516826633/@11.5538504,104.9208026,17z/data=!3m1!4b1?entry=ttu',	1,	0,	'2023-07-06 15:18:08',	'2023-07-06 15:21:31'),
(131,	'Malis Salon',	NULL,	'012/016965555',	NULL,	'Poipet',	NULL,	1,	0,	'2023-07-06 15:22:02',	'2023-07-06 15:22:02'),
(132,	'Lin Hair Style Salon',	'/Lin Hair Style Salon-a3c95564-3abb-4545-962d-e78b889f01b6.jpg',	'093 522 534',	NULL,	'Phnom Penh, Toul Kork | St.11B,Obekkaom\r\nផ្លូវជាតិលេខ៣, Phnom Penh, Cambodia',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5012302,104.8103305/@11.533037,104.7846439,12z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-06 15:25:14',	'2023-07-06 15:25:14'),
(133,	'Chhieng Chhieng Salon - P.H',	NULL,	'089877300',	NULL,	'Phnom Penh, Chbar Ampov | #156, St.Polaris Project 8',	'https://www.google.com/maps/dir//HR+SHOP,+115A+Phnom+Penh,+12007/@11.5510311,104.8868166,13z/data=!4m8!4m7!1m0!1m5!1m1!1s0x31095161f70b2ed1:0x84bc0c41c855641b!2m2!1d104.9280168!2d11.551034?entry=ttu',	1,	0,	'2023-07-06 15:29:44',	'2023-07-06 15:29:44'),
(134,	'90’s Salon',	'/90’s Salon-865802bb-db46-401d-8a96-4a303bfeaaa0.jpg',	'086 686 830',	NULL,	'#24 street287 khan toul kok phnom penh, Phnom Penh, Cambodia',	NULL,	1,	0,	'2023-07-06 15:37:09',	'2023-07-06 15:37:09'),
(135,	'Spiderman Barber Shop',	NULL,	'0715216813',	NULL,	'Phnom Penh, Toul Kork | St. 317 (near Best Star KTV)',	NULL,	1,	0,	'2023-07-06 15:43:39',	'2023-07-06 15:43:39'),
(136,	'V Color Barber&Mss',	'/V Color Barber&Mss-3b76992b-ae6a-40e0-af24-9cfe62ab4b15.jpg',	'098529992',	NULL,	'ផ្លូវ 155 សង្កាត់ផ្សាដើមថ្កូវ ខណ្ឌចំការមន រាជធានីភ្នំពេញ, Phnom Penh, Cambodia',	NULL,	1,	0,	'2023-07-06 15:59:17',	'2023-07-06 15:59:17'),
(137,	'Number15 Salon',	'/Number15 Salon-2b716f82-7983-4f18-b176-febbb6a5277d.jpg',	'015 455 55/0969606580',	NULL,	'#23 street 57 corner 294, Beoung Keng Kang 1, Phnom Penh, Cambodia',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5490998,104.9255981/@11.5638382,104.8987953,14z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-06 19:56:50',	'2023-07-06 19:56:50'),
(138,	'Wendy Singapore',	NULL,	'012727616/017486633',	NULL,	'Phnom Penh, Sen Sok | #2cc, St.111, Pochintong',	NULL,	1,	0,	'2023-07-06 20:00:02',	'2023-07-06 20:00:02'),
(139,	'Daneth Salon',	'/Daneth Salon-16fabc2e-cc03-49da-a19e-b3705de9208a.jpg',	'081 616 898/096 848 25 34 / 097 222 63 43',	NULL,	'Svay Rieng',	NULL,	1,	0,	'2023-07-06 20:04:57',	'2023-07-06 20:04:57'),
(140,	'Dalin Beauty Salon',	'/Dalin Beauty Salon-4c77c5af-01ab-4713-a5fc-2f88a511bee1.jpg',	'095 997 699/012399919',	NULL,	'Wat Bo Rd, Siem Reap, Cambodia',	'https://www.google.com/maps/dir/11.5774458,104.9038456/13.3570881,103.8603026/@12.6346966,103.5403734,8.22z/data=!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-06 20:26:03',	'2023-07-06 20:26:03'),
(141,	'East West Hair Salon',	'/East West Hair Salon-39fe3a3d-613e-4a22-b30f-ab723bc22d28.jpg',	'0887890914',	NULL,	'national rd 63 ( river road) , Siem Reap, Cambodia',	'https://www.google.com/maps/dir/11.5774458,104.9038456/13.3395883,103.851906/@12.4673644,103.9285079,9z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-06 20:39:24',	'2023-07-06 20:39:24'),
(142,	'The Hair Lab',	'/The Hair Lab-df1c3e13-e6c3-4a32-96e3-d2d43cb89c6d.jpg',	'093978519',	NULL,	'Kep Province',	NULL,	1,	0,	'2023-07-07 18:09:01',	'2023-07-07 18:09:01'),
(143,	'July Care',	NULL,	'071 88 71 700',	NULL,	'Phnom Penh, Toul Kork | ផ្លូវកោះដូង',	NULL,	1,	0,	'2023-07-07 18:19:50',	'2023-07-07 18:19:50'),
(144,	'Mai Chhoeung Hair Cut',	NULL,	'086551781',	NULL,	'Banteay Meanchey Province(svay)',	NULL,	1,	0,	'2023-07-07 18:25:14',	'2023-07-07 18:25:14'),
(145,	'PSE (Pour un Sourir d\'Enfant)',	'/PSE (Pour un Sourir d\'Enfant)-e99fb7b8-e84e-4e9c-b215-8b580f455e64.png',	'077 777 175',	NULL,	'n° 402, Groupe 12, Village Trea,  Stung Mean Chey, Phnom Penh, Cambodia, 2107',	NULL,	1,	0,	'2023-07-07 18:59:07',	'2023-07-07 18:59:07'),
(146,	'Leekaja Salon - Olympia Mall',	'/Leekaja-3077e031-e0ad-40b5-bb18-fd073ab9a873.jpg',	'099443944',	NULL,	'Phnom Penh, 7 Makara | Olympia Mall',	NULL,	1,	0,	'2023-07-07 19:01:36',	'2023-07-07 19:01:36'),
(147,	'V Salon',	NULL,	'069900071',	NULL,	'Kampong Speu Province',	NULL,	1,	0,	'2023-07-07 19:03:53',	'2023-07-07 19:03:53'),
(148,	'Robinson Salon',	NULL,	'096 714 0037',	NULL,	'Phnom Penh, Chamkar Mon | Bassace Lane',	NULL,	1,	0,	'2023-07-07 19:19:29',	'2023-07-07 19:19:29'),
(149,	'Silvia Dalvann Image Studios',	'/Silvia Dalvann Image Studios-eece2a8c-32ad-4eb5-8623-a269645f798a.jpg',	'017323545/070537969',	NULL,	'Phnom Penh, Sen Sok | #3, St.72P, Phnom Penh Tmey',	NULL,	1,	0,	'2023-07-07 19:23:01',	'2023-07-07 19:23:01'),
(150,	'D Angel Beauty Salon (Siem Reap)',	NULL,	'012 321 898',	NULL,	'Siem Reap l #57,st.60,Krong Siem Reap',	NULL,	1,	0,	'2023-07-07 19:39:21',	'2023-07-07 19:39:21'),
(151,	'Robinson Salon',	NULL,	'096 714 0037',	NULL,	'Phnom Penh, Chamkar Mon | Bassace Lane',	NULL,	1,	0,	'2023-07-10 10:49:26',	'2023-07-10 10:49:26'),
(152,	'Silvia Dalvann Image Studios',	NULL,	'017323545/070537969',	NULL,	'Phnom Penh, Sen Sok | #3, St.72P, Phnom Penh Tmey',	NULL,	1,	0,	'2023-07-10 10:50:14',	'2023-07-10 10:50:14'),
(153,	'D Angel Beauty Salon (Siem Reap)',	NULL,	'012 321 898',	NULL,	'Siem Reap l #57,st.60,Krong Siem Reap',	NULL,	1,	0,	'2023-07-10 10:51:25',	'2023-07-10 10:51:25'),
(154,	'Everline Salon',	'/Everline Salon-a4ec0318-49ce-4016-9710-7515faa5d62e.jpg',	'070303084',	NULL,	'Phnom Penh, Toul Kork | #906, Kampuchea Krom Blvd',	NULL,	1,	0,	'2023-07-10 10:53:49',	'2023-07-10 10:53:49'),
(155,	'Syna Styling Salon',	'/Syna Styling Salon-dab7cc76-01c7-4e6a-bc2c-8138901b27d0.jpg',	'093677999',	NULL,	'Phnom Penh, Sen Sok | #A93, St.A',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5782018,104.8351493/@11.5838575,104.8348201,13z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-10 11:07:56',	'2023-07-10 11:07:56'),
(156,	'L Salon & Eye Brows',	NULL,	'010 926 800',	NULL,	'Phnom Penh, Russei Keo | St.598, Borey Phnom Penh Thmey',	NULL,	1,	0,	'2023-07-10 11:09:22',	'2023-07-10 11:09:22'),
(157,	'Lin Salon',	NULL,	'086 5555 19',	NULL,	'Battambang Province',	NULL,	1,	0,	'2023-07-10 11:13:37',	'2023-07-10 11:13:37'),
(158,	'Cool Hair Salon',	'/Cool Hair Salon-7ffb85d9-187a-4502-bebb-a4aa19c0f521.jpg',	'098 97 87 98',	NULL,	'Phnom Penh, Toul Kork | #24, St 608',	NULL,	1,	0,	'2023-07-10 11:44:35',	'2023-07-10 11:44:35'),
(159,	'Saov Dy Make Up Salon',	NULL,	'0319485868',	NULL,	'Phnom Penh',	NULL,	1,	0,	'2023-07-10 11:54:07',	'2023-07-10 11:54:07'),
(160,	'Nich Salon',	NULL,	'076/0987220707',	NULL,	'Pailin Province',	NULL,	1,	0,	'2023-07-10 11:59:11',	'2023-07-10 11:59:11'),
(161,	'Orchide Salon',	'/Orchide Salon-665d9fef-711a-4cd5-bfad-246b816387cf.jpg',	'015 89 8007/ 012 903458',	NULL,	'Phnom Penh, Chamkar Mon l St39,Toul Tumpong',	NULL,	1,	0,	'2023-07-12 14:40:50',	'2023-07-12 14:40:50'),
(162,	'Cindy ll & NK Salon - PH',	'/Cindy ll & NK Salon - PH-aa8cf7ae-d7e1-4c69-b834-a78d84022aa8.jpg',	'0965000105',	NULL,	'Phnom Penh, Chbar Ampov | Euro Park, Borey Peng Houth Boeung Snor',	NULL,	1,	0,	'2023-07-12 14:45:07',	'2023-07-12 14:45:07'),
(163,	'Za Jeny Queen Salon',	NULL,	'093555545/098278754',	NULL,	'Phnom Penh, Sen Sok | #A22, Borey Angkor',	NULL,	1,	0,	'2023-07-12 14:46:10',	'2023-07-12 14:46:10'),
(164,	'Ego Salon',	'/Ego Salon-1865cd00-c86d-49dc-bdde-1c91dbbfb079.jpg',	'0977255064',	NULL,	'Phnom Penh, Chamkar Mon | #8, St.63\r\n#2 street 63, between street 422 to mao se toung Blvd, chamkamon (see google map Ego hair map ), Phnom Penh, Cambodia',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5401301,104.92498/@11.5598539,104.896728,14z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-12 14:56:39',	'2023-07-12 14:56:39'),
(165,	'VIP Salon',	'/VIP Salon-8a030121-4ca1-4e80-82bb-c78173c144da.jpg',	'012224844',	NULL,	'Phnom Penh, Sen Sok | #116 E0E1, St.D',	NULL,	1,	0,	'2023-07-12 15:02:23',	'2023-07-12 15:02:23'),
(166,	'Han Kook Beauty Salon',	NULL,	'069 635200',	NULL,	'Phnom Penh, Chamkar Mon | #B33, St.199',	NULL,	1,	0,	'2023-07-12 15:12:07',	'2023-07-12 15:12:07'),
(167,	'Kanha Spa & Salon',	NULL,	'099 24 0003',	NULL,	'Phnom Penh, Chbar Ampov | #1, St.M14, Kamrong 4, Peng Houth Boeng Snor',	NULL,	1,	0,	'2023-07-12 15:13:40',	'2023-07-12 15:13:40'),
(168,	'Por Highlight ll (Kampuchea Krom)',	NULL,	'015535356',	NULL,	'Phnom Penh, Toul Kork | Kampuchea Krom',	NULL,	1,	0,	'2023-07-12 15:49:57',	'2023-07-12 15:49:57'),
(169,	'Srey Pich Salon',	NULL,	'015672019',	NULL,	'Phnom Penh, Toul Kork | No 28E, St 586, Beoung Kok II',	NULL,	1,	0,	'2023-07-12 16:17:39',	'2023-07-12 16:17:39'),
(170,	'Tutu Salon',	'/Tutu Salon-431b4f6b-3413-4f21-9cdd-e08654c3147f.jpg',	'093808680/0973666666',	NULL,	'#5 street 1126 corner Street 598, Phnom Penh, Cambodia',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.583008,104.8868045/@11.5808962,104.8866619,15z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-12 16:21:52',	'2023-07-12 16:21:52'),
(171,	'Reach Salon (Sihanouk Province)',	NULL,	'015559906',	NULL,	'Preah Sihanouk',	NULL,	1,	0,	'2023-07-12 16:26:52',	'2023-07-12 16:26:52'),
(172,	'Happy Chandara',	NULL,	'070 474 277',	NULL,	'Phnom Penh',	NULL,	1,	0,	'2023-07-12 16:27:29',	'2023-07-12 16:27:29'),
(173,	'RT Barber Shop',	'/RT Barber Shop-0f5071de-be53-4d48-9e86-45f702c90576.jpg',	'070743313',	NULL,	'Banteay Meanchey Province',	NULL,	1,	0,	'2023-07-12 16:30:05',	'2023-07-12 16:30:05'),
(174,	'Fae Hair & Beauty Salon',	'/Fae Hair & Beauty Salon-90a90b7b-30f4-417e-b0d9-925fa5754f5d.jpg',	'098348666/087 577 725',	NULL,	'#33 , #35, street 1962, Phum Krang Angkroang , Sangkat Krang Tnong , Khan sen sok ,Phnom Penh , Phnom Penh, Cambodia',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.582275,104.8472721/@11.5836484,104.8406595,13z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-12 16:37:11',	'2023-07-12 16:37:11'),
(175,	'N&R Theany Salon',	NULL,	'07737551/070735551',	NULL,	'Phnom Penh, Mean Chey | Chak Angre Kraom',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5238444,104.9325871/@11.5457763,104.8846767,13z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-12 16:39:29',	'2024-02-16 10:06:38'),
(176,	'Oun Sam Salon',	'/Oun Sam Salon-3e976b96-720a-498c-a4c2-c9bc9e976098.jpg',	'070563333',	NULL,	'Phnom Penh, Sen Sok | #3B, Phum Damnak, Sangkat Kork Kleang',	NULL,	1,	0,	'2023-07-12 16:53:55',	'2023-07-12 16:53:55'),
(177,	'Ah Ry Salon',	NULL,	'098 348 666',	NULL,	'Phnom Penh',	NULL,	1,	0,	'2023-07-12 17:03:20',	'2023-07-12 17:03:20'),
(178,	'Le Boudoir Salon - TTP',	'/Le Boudoir Salon - TTP-1a0af167-d103-4dd4-861b-b98c8558c5d6.png',	'092 654 040',	NULL,	'Phnom Penh, Chamkar mon l #43B, St.432, Toul Tum Pong',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5417572,104.9177599/@11.5595519,104.8933711,14z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-12 17:07:31',	'2023-07-12 17:07:31'),
(179,	'Le Boudoir Salon - TK',	'/Le Boudoir Salon - TTP-1a0af167-d103-4dd4-861b-b98c8558c5d6.png',	'010 654 040',	NULL,	'Phnom Penh, Toul Kork | Block ll',	NULL,	1,	0,	'2023-07-12 17:11:37',	'2023-07-12 17:11:37'),
(180,	'7Barber & Mss',	'/7Barber & Mss-ffb8b2cc-82f2-469a-aa5f-424ac92446ab.jpg',	'096 596 6550/070 909 978 / 069 543 456',	NULL,	'Phnom Penh, Daun Penh l #187, St.19, Chey Chomneas',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5646199,104.9276521/@11.5720515,104.8982246,14z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-12 17:15:09',	'2023-07-12 17:15:09'),
(181,	'Passion Spa & Salon',	NULL,	'012 900 763',	NULL,	'Phnom Penh',	NULL,	2,	0,	'2023-07-12 17:17:55',	'2024-02-16 10:05:06'),
(182,	'Mini Salon',	'/Mini Salon-b2f5b4dd-167c-4b7e-8619-1d91f8f57aeb.jpg',	'070 598 387/096 342 016',	NULL,	'Phnom Penh, Chamkar mon l #246A ,St.488 , Phsar Derm Tkov',	NULL,	1,	0,	'2023-07-12 17:25:33',	'2023-07-12 17:25:33'),
(183,	'CamiYui By Prosol Japan Salon',	'/CamiYui beauty Japan-c38df227-f270-413d-8ca9-205ac4599a76.jpg',	'016668972',	NULL,	'Phnom Penh, Beoung Keng Kang | St.360, BKK 1',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5490944,104.9275982/@11.5642734,104.8987953,14z/data=!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-13 09:55:50',	'2023-07-13 09:55:50'),
(184,	'Naden Salon',	'/Naden salon-3a058ae2-96ee-480a-9ad9-89ab1e7523d0.jpg',	'095 622 223',	NULL,	'#30 street 230(infront of galaxy star) khan toulkork, Phnom Penh, Cambodia',	NULL,	1,	0,	'2023-07-13 10:07:27',	'2023-07-13 10:07:27'),
(185,	'Leekaja Salon - Sovanna',	'/Leekaja Salon - Sovanna-403f43cf-5bb1-4e2a-858a-d47def98bcaa.jpg',	'069666908/095565567',	NULL,	'Phnom Penh, Beoung Keng Kang | Near Sovanna Mall, Tumnob Teuk',	'https://www.google.com/maps/place/Leekaja+Beauty+Salon+Sovanna+Branch/@11.5470678,104.9013495,17z/data=!4m6!3m5!1s0x31095180f8d55a07:0x97f77eabce79d1d7!8m2!3d11.5470678!4d104.9013495!16s%2Fg%2F11g0_tppxr?entry=ttu',	1,	0,	'2023-07-13 10:25:24',	'2023-07-13 10:25:24'),
(186,	'Nature Salon & Brows',	'/Nature salon-2e9a9e6f-cdee-4147-8e74-78e886e9a737.jpg',	'069202290/078818695',	NULL,	'Phnom Penh, Toul Kork | St.261',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5648982,104.8938507/@11.5711148,104.8948855,16z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-13 10:30:38',	'2023-07-13 10:30:38'),
(187,	'The Pink Salon',	NULL,	'017 33 55 33 / 098 210 222',	NULL,	'Phnom Penh, Chbar Ampov l No 345,st Polaris,Penghout Boeung Snor',	NULL,	1,	0,	'2023-07-14 14:51:09',	'2023-07-14 14:51:09'),
(188,	'Beauty Lounge',	'/Beauty Lounge-9aa9d8a4-941f-41bb-944a-f5b34bcd5828.jpg',	'096 76 79 189',	NULL,	'25, St 582 - Tuol Kork Market, Phnom Penh, Cambodia',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5760449,104.8970103/@11.5759919,104.8960599,16z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-14 14:59:07',	'2023-07-14 14:59:07'),
(189,	'Prorneth Neary',	NULL,	'015 666 502 /012 588 388',	NULL,	'Phnom Penh, Toul Kork | Phsar Derm kor',	NULL,	1,	0,	'2023-07-14 15:02:23',	'2023-07-14 15:02:23'),
(190,	'Tulip Salon',	'/Tulip Salon-3a5aa446-6bb4-423b-a7a8-15a3e5fdb447.jpg',	'012 838 /015 200 200',	NULL,	'ÆON Mall 2 , Phnom Penh, Cambodia',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5520167,104.8753381/@11.5645154,104.8700895,14z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-14 15:05:13',	'2023-07-14 15:05:13'),
(191,	'High Lady Salon',	'/High Lady Salon-81ab4306-735f-433e-b0fe-bdfee32bb91c.jpg',	'010 646 403',	NULL,	'Phnom Penh, Toul kork | #44,st.70',	NULL,	1,	0,	'2023-07-14 15:07:41',	'2023-07-14 15:07:41'),
(192,	'M Salon & Spa PH',	'/M Salon & Spa PH-4e87249d-b81c-4d41-b450-1975b6c4de4e.jpg',	'087 896 969',	NULL,	'Phnom Penh, Chbar Ampov l Borey Peng Huot Boeung Snor',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5315816,104.9579501/@11.5547536,104.8957235,13z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-14 15:22:15',	'2023-07-14 15:22:15'),
(193,	'Oum Salon',	NULL,	'016 212 132',	NULL,	'Kampong Speu',	NULL,	1,	0,	'2023-07-14 15:40:56',	'2023-07-14 15:40:56'),
(194,	'Victoria Salon',	NULL,	'096 739 7739',	NULL,	'Kep',	NULL,	1,	0,	'2023-07-14 15:41:59',	'2023-07-14 15:41:59'),
(195,	'Park Salon & Beauty',	NULL,	'081686667',	NULL,	'Phnom Penh, Chamkar Mon | #450, St.360',	NULL,	1,	0,	'2023-07-14 15:58:58',	'2023-07-14 15:58:58'),
(196,	'Chanda Salon',	'/Chanda Salon-eef8fabd-ba97-4030-9416-92f7fdc7fb94.jpg',	'012697957',	NULL,	'Phnom Penh, Mean Chey | Borey Lim Chheang Hak (Jomkadong)',	NULL,	1,	0,	'2023-07-14 16:07:02',	'2023-07-14 16:07:02'),
(197,	'Nature Salon and Brows',	'/Nature Salon and Brows-2138a046-8c3f-46c1-ba13-3b72521b05f7.jpg',	'069202290/078818695',	NULL,	'Phnom Penh, Toul Kork | St.261',	NULL,	1,	0,	'2023-07-14 16:09:57',	'2023-07-14 16:09:57'),
(198,	'Famous Salon Rose Condo',	NULL,	'099319098',	NULL,	'PP, Chamkar Mon | Rose Condo',	NULL,	1,	0,	'2023-07-14 16:32:11',	'2023-07-14 16:32:11'),
(199,	'Naden Salon',	NULL,	'095/069622223',	NULL,	'#30 street 230(infront of galaxy star) khan toulkork, Phnom Penh, Cambodia',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5583393,104.9059153/@11.5678692,104.8969139,15z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-14 16:36:44',	'2023-07-14 16:36:44'),
(200,	'CamiYui By Prosol Japan Salon',	'/CamiYui By Prosol Japan Salon-f884f5d8-61bc-439d-b8b5-381d8bb4588d.jpg',	'016668972',	NULL,	'Phnom Penh, Beoung Keng Kang | St.360, BKK 1\r\nMillennial 360 service apartment #7 St 360 Beoung Keng Kang1 Khan Beoung Keng Kang Phnom Penh, Phnom Penh, Cambodia',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5490734,104.9276197/@11.5642747,104.8987953,14z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-14 16:38:59',	'2023-07-14 16:38:59'),
(201,	'18 Home Salon',	'/18 Home Salon-7031a7c0-75d4-4efa-8925-c714e6543f24.jpg',	'081 627 218',	NULL,	'បង​ផ្លូវ​63កែង392 ផ្ទះ​លេខ​246 ឈ្មោះហាងផ្តូរទៅជា18 home salon , Phnom Penh, Cambodia',	'https://www.google.com/maps/dir/11.5774458,104.9038456/11.5457409,104.9246292/@11.562648,104.8966429,14z/data=!3m1!4b1!4m4!4m3!1m1!4e1!1m0?entry=ttu',	1,	0,	'2023-07-14 16:51:58',	'2023-07-14 16:51:58'),
(202,	'TT Massage Salon',	NULL,	'077277724',	NULL,	'Phnom Penh, Toul Kork | St.590',	NULL,	2,	0,	'2023-07-14 16:53:22',	'2024-02-14 14:18:24'),
(203,	'B2 Hair Salon',	'/B2 Hair Salon-7182d7c6-270c-4642-9b4b-f885c2ad7b37.jpg',	'012 205 454/093808680/087818283',	NULL,	'Phnom Penh, Toul Kork | #66, St.592 (behind Indradevi High School)',	NULL,	1,	0,	'2023-07-14 16:54:53',	'2023-07-14 16:54:53'),
(204,	'Nai Nai',	NULL,	'069 666 908',	NULL,	'Phnom Penh',	NULL,	1,	0,	'2024-02-14 11:43:10',	'2024-02-14 11:43:10'),
(205,	'Mayfair Beauty Bar',	NULL,	'016 59 22 11',	NULL,	'National Highway 6A',	NULL,	1,	0,	'2024-02-14 11:45:54',	'2024-02-14 11:45:54'),
(206,	'Cindy II & NK Salon - TK',	'/Cindy ll-78f214cc-bec8-481a-b2e2-4b8356e0f59f.png',	'071 52 168 13',	NULL,	'#4, Street 544, Khan Toul Kork, Phnom Penh',	'https://maps.app.goo.gl/M55gfx8fUn8zUjfYA',	1,	0,	'2024-02-14 11:55:18',	'2024-02-14 14:18:15'),
(207,	'King & Queen Salon and Barber',	'/King & Queen Salon-84af1cbb-5591-42a9-b7f7-be51c2f12cf6.jpg',	'086 36 89 98',	NULL,	'Prey Sar, Khan Dangkor, Phnom Penh',	'https://maps.app.goo.gl/gDCxpk9Y1AefozgG8',	1,	0,	'2024-02-14 11:57:49',	'2024-02-14 13:35:46'),
(208,	'Puy Salon Street 63',	'/Puy Salon 63-b4b2dfc5-6579-4ab4-be99-242d06a4934f.jpg',	'098 65 84 22',	NULL,	'#94F, St. (63), Preah Trasak Paem, Khan Chamkar Mon, Phnom Penh',	'https://maps.app.goo.gl/MJjoZGEtYEfCfcKe7',	1,	0,	'2024-02-14 13:44:18',	'2024-02-14 13:44:18'),
(209,	'Hair Lounge',	'/Hair lounge-305dba5c-d665-4623-8dc6-10a73ac32603.png',	'010 38 64 31',	NULL,	'St 554 (Behind Toul Kork Primary School), Khan Toul Kork, Phnom Penh',	'https://maps.app.goo.gl/6X5NSMvcX7RH34D96',	1,	0,	'2024-02-14 14:01:15',	'2024-02-14 14:01:15'),
(210,	'The Nail Room',	'/The nail room-82a65c47-8757-4542-a3d0-bcddc7a1e09c.png',	'010 95 81 71',	NULL,	'Street 1952, Khan Sen Sok, Phnom Penh',	'https://maps.app.goo.gl/qaw6dsaozjFALu11A',	1,	0,	'2024-02-14 14:04:20',	'2024-02-14 14:04:20'),
(211,	'អាដ័រ ADORE Salon',	'/ADORE-3c9bdbb9-a1d8-433b-9365-47886e84134b.jpg',	'012 69 86 08',	NULL,	'#10, Street 175, Sangkat Tumnub Tik, Khan Beong Keng Kang, Phnom Penh.',	'https://maps.app.goo.gl/ya2pWtKZpt7sCBzRA',	1,	0,	'2024-02-14 14:13:32',	'2024-02-14 14:13:32'),
(212,	'B1 Hair Salon',	'/B1 salon-8dbc2356-2bc8-44b8-b05c-36d6281263ce.png',	'016 20 30 44',	NULL,	'street 598, Khan Toul kork, Sangkat Boeung kak 2 Phnom Penh,',	'https://maps.app.goo.gl/UZhcu7WZsX5tAA258',	1,	0,	'2024-02-14 14:16:49',	'2024-02-14 14:16:49'),
(213,	'Leekaja Beauty salon TK Branch',	'/Leekaja-76e21717-42d6-47ab-82f4-1ce563096782.jpg',	'097 82 00 331',	NULL,	'Street 516, Khan Toul Kok, Phnom Penh',	'https://maps.app.goo.gl/fuosdsruF8fXhgxd9',	1,	0,	'2024-02-14 14:22:17',	'2024-02-14 14:22:17'),
(214,	'P Salon',	'/P salon-08b7126d-1674-4de7-85ca-5f89d006fe57.png',	'088 216 40 29',	NULL,	'#22 Street 302, Sangkat Boeung Keng Kang I, Khan Boeung Keng Kong Phnom Penh,',	'https://maps.app.goo.gl/sHXmxkD4NBqQuQRW9',	1,	0,	'2024-02-14 14:25:06',	'2024-02-14 14:25:06'),
(215,	'NEAK SALON',	'/NEAK Salon-bb739a8d-5a45-4536-b38c-fd5086cdc3c7.jpg',	'093 6666 96 / 097 5 11111 5',	NULL,	'Sisophon, Banteay Meanchey Provine',	'https://maps.app.goo.gl/xB5CJYdt3pZTQb3E8',	1,	0,	'2024-02-14 14:27:59',	'2024-02-14 14:27:59'),
(216,	'Little Brow & Salons',	'/Little Brow & Salons-99765d3a-7690-4a5c-9ce9-f9c014184a9d.jfif',	'067 968 999',	NULL,	'#168-166, Street 215, Sangkat Veal Vong. Khan 7 Makara, Phnom Penh',	'https://maps.app.goo.gl/73tNBYtJcQR3FDuK9',	1,	0,	'2024-02-14 14:33:26',	'2024-02-14 14:33:26'),
(217,	'Lavender Salon',	'/Lavender Salon-f3241bcd-1ab1-431d-9d20-4f49ec99494e.jpg',	'012 64 88 66 / 010 64 88 66',	NULL,	'#55 Samdach Penn Nouth St. (289), Sangkat Teuk Laak II, Khan Toul Kork, Phnom Penh',	'https://maps.app.goo.gl/fgJjQbJRzxcRHa6A6',	1,	0,	'2024-02-16 09:21:12',	'2024-02-16 09:21:12'),
(218,	'M-C Salon By MICKEY',	'/M-C Salon By MICKEY-fc6eb68e-92a7-491a-b3e7-b57acc21c179.JPG',	'070 94 86 94',	NULL,	'Road 3, Krong Battambang',	'https://maps.app.goo.gl/88ho4bvbQd54Wqkw6',	1,	0,	'2024-02-16 09:26:42',	'2024-02-16 09:26:42'),
(219,	'B2 - Salon',	'/B2 Salon-2859bde9-9770-404c-aea5-3faa6ea60580.JPG',	'093 80 86 80 / 087 81 82 83',	NULL,	'#66, St.592 (behind Indradevi High School), Khan Toul Kork,  Phnom Penh',	'https://maps.app.goo.gl/4T2YKzNF8bK8uBxU6',	1,	0,	'2024-02-16 09:30:58',	'2024-02-16 09:30:58'),
(220,	'T Massage & Beauty Salon',	'/T Massage & Beauty Salon-a947bfaf-075c-41f1-b242-fbd95efd020b.jpg',	'077 277 724',	NULL,	'#95 St 590,Khan Toul Kork, Phnom Penh',	'https://maps.app.goo.gl/ddmZnrRariMx5tRa7',	1,	0,	'2024-02-16 09:34:11',	'2024-02-16 09:34:11'),
(221,	'Home Salon',	'/Home Salon-bb711e91-9160-49f4-a117-050c676a2c08.JPG',	'017 80 18 18',	NULL,	'#246, Street 63,Sangkat Boeung Keng Kang ll, Khan chamkamon, Phnom Penh',	'https://maps.app.goo.gl/WDHLUTaQarpvMyHc6',	1,	0,	'2024-02-16 09:38:25',	'2024-02-16 09:38:25'),
(222,	'Naden Salon',	'/Naden salon-dc29b4ff-bb7e-411c-89ea-ce6ad23df217.JPG',	'095 / 069 6 2222 3',	NULL,	'No.30c St 230, Khan Toul Kork, Phnom Penh',	'https://maps.app.goo.gl/HqKj9D5KZSUChpxYA',	1,	0,	'2024-02-16 09:42:51',	'2024-02-16 09:42:51'),
(223,	'V Famous Salon - Rose Condo',	'/V Famous-d7056f48-2072-4361-8cf6-ba091b97b641.png',	'099319098',	NULL,	'Rose garden block 252 ( shop 6), Khan Chamkarmon Phnom Penh',	'https://maps.app.goo.gl/sQ76Pd4EcfJKFTLQ6',	1,	0,	'2024-02-16 09:50:27',	'2024-02-16 09:50:27'),
(224,	'Leekaja Beauty Salon Sovanna Branch',	'/Leekaja Savana-3e01246c-2e08-43ba-8dce-1fe957002d9f.jpg',	'069 666 908 / 095 56 55 67',	NULL,	'Near Sovanna Mall, Sangkat Tumnob Teuk, Khan Boeung Keng Kang, Phnom Penh',	'https://maps.app.goo.gl/eiHRjYkbT8smo2Vk6',	1,	1,	'2024-02-16 09:52:47',	'2024-02-17 08:58:01'),
(225,	'Nature Salon and Brows',	'/Nature Salon and Brows-c3bb225b-f11d-4ae1-a2ac-f2a5093a376f.png',	'069 20 22 90 / 078 81 86 95',	NULL,	'Kampucheakrom 261corner 138, Khan Toul Kork, Phnom Penh',	'https://maps.app.goo.gl/PGhsSic8ccqMzXve7',	1,	1,	'2024-02-16 09:56:08',	'2024-02-17 08:58:26'),
(226,	'M Salon & Spa',	'/M salon and spa-70eb8a77-2b62-413c-a567-ca95b09652d2.png',	'087 896 969',	NULL,	'Borey Peng Huot Boeung Snor, Khan  Chbar Ampov, Phnom Penh',	'https://maps.app.goo.gl/u1NnHDURUnqn3YWZ6',	1,	1,	'2024-02-16 10:02:58',	'2024-02-17 08:58:43');

DROP TABLE IF EXISTS `permissions`;
CREATE TABLE `permissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `display_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `module_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `permissions_name_guard_name_unique` (`name`,`guard_name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

INSERT INTO `permissions` (`id`, `name`, `guard_name`, `display_name`, `module_id`, `created_at`, `updated_at`) VALUES
(1,	'student-view',	'web',	'View',	1,	NULL,	NULL),
(2,	'student-view-info',	'web',	'View Info',	1,	NULL,	NULL),
(3,	'student-create',	'web',	'Create',	1,	NULL,	NULL),
(4,	'student-update',	'web',	'Edit',	1,	NULL,	NULL),
(5,	'student-assign',	'web',	'Assign',	1,	NULL,	NULL),
(6,	'student-print',	'web',	'Print',	1,	NULL,	NULL),
(7,	'class-program-view',	'web',	'View',	2,	NULL,	NULL),
(8,	'structure-program-view',	'web',	'View',	3,	NULL,	NULL),
(9,	'structure-program-view-info',	'web',	'View Info',	3,	NULL,	NULL),
(10,	'structure-program-create',	'web',	'Create',	3,	NULL,	NULL),
(11,	'structure-program-update',	'web',	'Edit',	3,	NULL,	NULL),
(12,	'structure-program-destroy',	'web',	'Destroy',	3,	NULL,	NULL),
(13,	'structure-program-assign',	'web',	'Assign',	3,	NULL,	NULL),
(14,	'structure-program-unassign',	'web',	'Unassign',	3,	NULL,	NULL),
(15,	'lesson-view',	'web',	'View',	4,	NULL,	NULL),
(16,	'lesson-create',	'web',	'Create',	4,	NULL,	NULL),
(17,	'lesson-update',	'web',	'Edit',	4,	NULL,	NULL),
(18,	'lesson-destroy',	'web',	'Destroy',	4,	NULL,	NULL),
(19,	'lesson-delete',	'web',	'Delete',	4,	NULL,	NULL),
(20,	'education-view',	'web',	'View',	5,	NULL,	NULL),
(21,	'education-create',	'web',	'Create',	5,	NULL,	NULL),
(22,	'education-update',	'web',	'Edit',	5,	NULL,	NULL),
(23,	'user-view',	'web',	'View',	6,	NULL,	NULL),
(24,	'user-create',	'web',	'Create',	6,	NULL,	NULL),
(25,	'user-update',	'web',	'Edit',	6,	NULL,	NULL),
(26,	'user-destroy',	'web',	'Destroy',	6,	NULL,	NULL),
(27,	'user-assign',	'web',	'Assign',	6,	NULL,	NULL),
(28,	'user-unassign',	'web',	'Unassign',	6,	NULL,	NULL),
(29,	'lesson-occupation-view',	'web',	'View',	7,	NULL,	NULL),
(30,	'lesson-occupation-create',	'web',	'Create',	7,	NULL,	NULL),
(31,	'lesson-occupation-update',	'web',	'Edit',	7,	NULL,	NULL),
(32,	'class-occupation-view',	'web',	'View',	8,	NULL,	NULL),
(33,	'class-occupation-create',	'web',	'Create',	8,	NULL,	NULL),
(34,	'class-occupation-update',	'web',	'Edit',	8,	NULL,	NULL),
(35,	'class-view',	'web',	'View',	9,	NULL,	NULL),
(36,	'class-create',	'web',	'Create',	9,	NULL,	NULL),
(37,	'class-view-info',	'web',	'View Info',	9,	NULL,	NULL),
(38,	'class-update',	'web',	'Edit',	9,	NULL,	NULL),
(39,	'class-study-material',	'web',	'Study Material',	9,	NULL,	NULL),
(40,	'class-assign',	'web',	'Assign',	9,	NULL,	NULL),
(41,	'class-assign-user',	'web',	'Assign User',	9,	NULL,	NULL),
(42,	'class-type-view',	'web',	'View',	10,	NULL,	NULL),
(43,	'class-type-create',	'web',	'Create',	10,	NULL,	NULL),
(44,	'class-type-update',	'web',	'Edit',	10,	NULL,	NULL),
(45,	'class-status-view',	'web',	'View',	11,	NULL,	NULL),
(46,	'class-status-create',	'web',	'Create',	11,	NULL,	NULL),
(47,	'class-status-update',	'web',	'Edit',	11,	NULL,	NULL),
(48,	'class-level-view',	'web',	'View',	12,	NULL,	NULL),
(49,	'class-level-create',	'web',	'Create',	12,	NULL,	NULL),
(50,	'class-level-update',	'web',	'Edit',	12,	NULL,	NULL),
(51,	'shift-view',	'web',	'View',	13,	NULL,	NULL),
(52,	'shift-create',	'web',	'Create',	13,	NULL,	NULL),
(53,	'shift-update',	'web',	'Edit',	13,	NULL,	NULL),
(54,	'exam-type-view',	'web',	'View',	14,	NULL,	NULL),
(55,	'exam-type-create',	'web',	'Create',	14,	NULL,	NULL),
(56,	'exam-type-update',	'web',	'Edit',	14,	NULL,	NULL),
(57,	'internship-place-view',	'web',	'View',	15,	NULL,	NULL),
(58,	'internship-place-create',	'web',	'Create',	15,	NULL,	NULL),
(59,	'internship-place-update',	'web',	'Edit',	15,	NULL,	NULL),
(60,	'staff-type-view',	'web',	'View',	16,	NULL,	NULL),
(61,	'staff-type-create',	'web',	'Create',	16,	NULL,	NULL),
(62,	'staff-type-update',	'web',	'Edit',	16,	NULL,	NULL),
(63,	'staff-position-view',	'web',	'View',	17,	NULL,	NULL),
(64,	'staff-position-create',	'web',	'Create',	17,	NULL,	NULL),
(65,	'staff-position-update',	'web',	'Edit',	17,	NULL,	NULL),
(66,	'staff-view',	'web',	'View',	18,	NULL,	NULL),
(67,	'staff-create',	'web',	'Create',	18,	NULL,	NULL),
(68,	'staff-update',	'web',	'Edit',	18,	NULL,	NULL),
(69,	'study-score-view',	'web',	'View',	19,	NULL,	NULL),
(70,	'study-score-create',	'web',	'Create',	19,	NULL,	NULL),
(71,	'study-score-update',	'web',	'Edit',	19,	NULL,	NULL),
(72,	'study-note-view',	'web',	'View',	20,	NULL,	NULL),
(73,	'study-note-view-info',	'web',	'View Info',	20,	NULL,	NULL),
(74,	'study-note-create',	'web',	'Create',	20,	NULL,	NULL),
(75,	'study-note-destroy',	'web',	'Destroy',	20,	NULL,	NULL),
(76,	'exam-control-view',	'web',	'View',	21,	NULL,	NULL),
(77,	'exam-control-create',	'web',	'Create',	21,	NULL,	NULL),
(78,	'exam-control-destroy',	'web',	'Destroy',	21,	NULL,	NULL),
(79,	'exam-control-update',	'web',	'Edit',	21,	NULL,	NULL),
(80,	'exam-control-view-info',	'web',	'View Info',	21,	NULL,	NULL),
(81,	'exam-control-score-table',	'web',	'Score Table',	21,	NULL,	NULL),
(82,	'exam-answer-sheet-view',	'web',	'View',	22,	NULL,	NULL),
(83,	'exam-answer-sheet-create',	'web',	'Create',	22,	NULL,	NULL),
(84,	'exam-answer-sheet-update',	'web',	'Edit',	22,	NULL,	NULL),
(85,	'exam-answer-sheet-destroy',	'web',	'Destroy',	22,	NULL,	NULL),
(86,	'exam-subject-view',	'web',	'View',	23,	NULL,	NULL),
(87,	'exam-subject-view-info',	'web',	'View',	23,	NULL,	NULL),
(88,	'exam-subject-create',	'web',	'Create',	23,	NULL,	NULL),
(89,	'exam-subject-update',	'web',	'Edit',	23,	NULL,	NULL),
(90,	'exam-subject-destroy',	'web',	'Destroy',	23,	NULL,	NULL),
(91,	'exam-subject-to-score',	'web',	'To Score',	23,	NULL,	NULL),
(92,	'exam-candidate-view',	'web',	'View',	24,	NULL,	NULL),
(93,	'exam-candidate-assign',	'web',	'Assign',	24,	NULL,	NULL),
(94,	'exam-candidate-unassign',	'web',	'Unassign',	24,	NULL,	NULL),
(95,	'exam-candidate-print',	'web',	'Print',	24,	NULL,	NULL),
(96,	'group-view',	'web',	'View',	25,	NULL,	NULL),
(97,	'group-create',	'web',	'Create',	25,	NULL,	NULL),
(98,	'group-view-info',	'web',	'View Info',	25,	NULL,	NULL),
(99,	'group-destroy',	'web',	'Destroy',	25,	NULL,	NULL),
(100,	'group-assign',	'web',	'Assign',	25,	NULL,	NULL),
(101,	'group-unassign',	'web',	'Unassign',	25,	NULL,	NULL),
(102,	'group-print',	'web',	'Print',	25,	NULL,	NULL),
(103,	'student-intern-place-view',	'web',	'View',	26,	NULL,	NULL),
(104,	'student-intern-place-update',	'web',	'Edit',	26,	NULL,	NULL),
(105,	'student-intern-place-create',	'web',	'Create',	26,	NULL,	NULL),
(106,	'student-intern-place-destroy',	'web',	'Destroy',	26,	NULL,	NULL),
(107,	'class-image-view',	'web',	'View',	27,	NULL,	NULL),
(108,	'class-image-create',	'web',	'Create',	27,	NULL,	NULL),
(109,	'class-image-destroy',	'web',	'Destroy',	27,	NULL,	NULL),
(110,	'attendance-view',	'web',	'View',	28,	NULL,	NULL),
(111,	'attendance-create',	'web',	'Create',	28,	NULL,	NULL),
(112,	'attendance-destroy',	'web',	'Destroy',	28,	NULL,	NULL),
(113,	'attendance-update',	'web',	'Edit',	28,	NULL,	NULL),
(114,	'attendance-view-info',	'web',	'View Info',	28,	NULL,	NULL),
(115,	'attendance-print',	'web',	'Print',	28,	NULL,	NULL),
(116,	'student-score-view',	'web',	'View',	29,	NULL,	NULL),
(117,	'student-score-create',	'web',	'Create',	29,	NULL,	NULL),
(118,	'student-score-destroy',	'web',	'Destroy',	29,	NULL,	NULL),
(119,	'student-score-update',	'web',	'Edit',	29,	NULL,	NULL),
(120,	'student-score-view-info',	'web',	'View Info',	29,	NULL,	NULL),
(121,	'student-score-print',	'web',	'Print',	29,	NULL,	NULL),
(122,	'contact-view',	'web',	'View',	30,	NULL,	NULL),
(123,	'about-view',	'web',	'View',	31,	NULL,	NULL),
(124,	'about-child-view',	'web',	'View',	32,	NULL,	NULL),
(125,	'about-child-create',	'web',	'Create',	32,	NULL,	NULL),
(126,	'about-child-update',	'web',	'Edit',	32,	NULL,	NULL),
(127,	'trainer-view',	'web',	'View',	33,	NULL,	NULL),
(128,	'trainer-create',	'web',	'Create',	33,	NULL,	NULL),
(129,	'trainer-update',	'web',	'Edit',	33,	NULL,	NULL),
(130,	'course-view',	'web',	'View',	34,	NULL,	NULL),
(131,	'course-create',	'web',	'Create',	34,	NULL,	NULL),
(132,	'course-update',	'web',	'Edit',	34,	NULL,	NULL),
(133,	'partner-view',	'web',	'View',	35,	NULL,	NULL),
(134,	'partner-create',	'web',	'Create',	35,	NULL,	NULL),
(135,	'partner-update',	'web',	'Edit',	35,	NULL,	NULL),
(136,	'question-view',	'web',	'View',	36,	NULL,	NULL),
(137,	'question-create',	'web',	'Create',	36,	NULL,	NULL),
(138,	'question-update',	'web',	'Edit',	36,	NULL,	NULL),
(139,	'gallery-view',	'web',	'View',	37,	NULL,	NULL),
(140,	'gallery-create',	'web',	'Create',	37,	NULL,	NULL),
(141,	'gallery-update',	'web',	'Edit',	37,	NULL,	NULL),
(142,	'video-view',	'web',	'View',	38,	NULL,	NULL),
(143,	'video-create',	'web',	'Create',	38,	NULL,	NULL),
(144,	'video-update',	'web',	'Edit',	38,	NULL,	NULL),
(145,	'work-day-view',	'web',	'View',	39,	NULL,	NULL),
(146,	'work-day-create',	'web',	'Create',	39,	NULL,	NULL),
(147,	'work-day-update',	'web',	'Edit',	39,	NULL,	NULL),
(148,	'exam-score-create',	'web',	'Create',	40,	NULL,	NULL),
(149,	'album-view',	'web',	'View',	41,	NULL,	NULL),
(150,	'album-create',	'web',	'Create',	41,	NULL,	NULL),
(151,	'album-update',	'web',	'Edit',	41,	NULL,	NULL),
(152,	'slide-view',	'web',	'View',	42,	NULL,	NULL),
(153,	'slide-create',	'web',	'Create',	42,	NULL,	NULL),
(154,	'slide-update',	'web',	'Edit',	42,	NULL,	NULL),
(155,	'qoute-view',	'web',	'View',	43,	NULL,	NULL),
(156,	'qoute-create',	'web',	'Create',	43,	NULL,	NULL),
(157,	'qoute-update',	'web',	'Edit',	43,	NULL,	NULL),
(158,	'user-feedback-view',	'web',	'View',	44,	NULL,	NULL),
(159,	'training-video-view',	'web',	'View',	45,	NULL,	NULL),
(160,	'training-video-create',	'web',	'Create',	45,	NULL,	NULL),
(161,	'training-video-update',	'web',	'Edit',	45,	NULL,	NULL),
(162,	'category-view',	'web',	'View',	46,	NULL,	NULL),
(163,	'category-create',	'web',	'Create',	46,	NULL,	NULL),
(164,	'category-update',	'web',	'Edit',	46,	NULL,	NULL),
(165,	'branch-view',	'web',	'View',	47,	NULL,	NULL),
(166,	'branch-create',	'web',	'Create',	47,	NULL,	NULL),
(167,	'branch-update',	'web',	'Edit',	47,	NULL,	NULL),
(168,	'branch-destroy',	'web',	'Destroy',	47,	NULL,	NULL),
(169,	'branch-delete',	'web',	'Delete',	47,	NULL,	NULL);

DROP TABLE IF EXISTS `personal_access_tokens`;
CREATE TABLE `personal_access_tokens` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint(20) unsigned NOT NULL,
  `name` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `qoutes`;
CREATE TABLE `qoutes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `qoutes` (`id`, `name`, `description`, `image`, `status`, `created_at`, `updated_at`) VALUES
(1,	'EDUCATION IS THE ONLY WAY THAT CHANGES THE WAY HAIRDRESSER DOES SALON BUSINESS TODAY.',	NULL,	'/aljdu91624531375115Untitled-1-01-01-010c9db3-056c-4996-9310-0c5a95e4c4b6.png',	1,	'2023-04-27 22:56:32',	'2023-04-27 22:56:32');

DROP TABLE IF EXISTS `qualified_statuses`;
CREATE TABLE `qualified_statuses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `class_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `is_attendance_pass` tinyint(4) NOT NULL DEFAULT 0,
  `is_exam_pass` tinyint(4) NOT NULL DEFAULT 0,
  `is_intern_pass` tinyint(4) NOT NULL DEFAULT 0,
  `is_overall_pass` tinyint(4) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `questions`;
CREATE TABLE `questions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `questions` (`id`, `question`, `answer`, `status`, `created_at`, `updated_at`) VALUES
(1,	'What product do you offer?',	'We offer varieties of Exclusive Salon Products which consists of Hair Products, Nail Products, Salon Tools, and Salon Furniture.',	1,	'2023-04-28 23:37:55',	'2023-04-28 23:37:55'),
(2,	'How to become Salon Member of SC-ABHC Club?',	'There 3 ways to become our member: Attend the training, Product Package, and Membership Card.',	1,	'2023-04-28 23:38:20',	'2023-04-28 23:38:20'),
(3,	'What training course do you offer?',	'We offer trainings of Hairdressing and Nail Styling which are conducted in different levels from Basic, Advance, to Professional level.',	1,	'2023-04-28 23:38:44',	'2023-04-28 23:38:44');

DROP TABLE IF EXISTS `roles`;
CREATE TABLE `roles` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_name_guard_name_unique` (`name`,`guard_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `role_has_permissions`;
CREATE TABLE `role_has_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL,
  `role_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`) USING BTREE,
  KEY `role_has_permissions_role_id_foreign` (`role_id`) USING BTREE,
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;


DROP TABLE IF EXISTS `shifts`;
CREATE TABLE `shifts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `shifts` (`id`, `name`, `status`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1,	'Evening Shift 2PM - 5PM',	1,	'2022-12-28 02:28:52',	'2023-01-23 20:12:24',	NULL),
(2,	'12 am',	2,	'2023-01-09 14:39:00',	'2023-01-09 14:42:13',	NULL),
(3,	'Morning Shift 9AM - 12PM',	1,	'2023-01-09 15:06:59',	'2023-01-23 20:11:53',	NULL),
(4,	'Other Shift',	1,	'2023-01-23 20:12:36',	'2023-01-23 20:12:36',	NULL),
(5,	'Night 7:00PM - 9:00PM edit',	2,	'2023-05-04 18:20:51',	'2023-05-04 18:23:12',	NULL),
(6,	'Night Shift 9:00PM - 11:30PM',	2,	'2023-05-04 18:23:36',	'2023-05-04 18:26:24',	NULL);

DROP TABLE IF EXISTS `slides`;
CREATE TABLE `slides` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `image` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `slides` (`id`, `image`, `type`, `name`, `status`, `created_at`, `updated_at`) VALUES
(1,	'/v48bs81630914665632School Prgoram at ABHC-02-0bf50f76-2cf6-4ccb-8d5b-65a4919d3b6a.jpg',	NULL,	'2',	1,	'2023-04-27 22:51:44',	'2023-10-19 10:50:16'),
(2,	'/c642j1631875223987Why partnership with ABHC-09-23e16c1f-bc70-4881-89fb-fc22c92b466b.jpg',	NULL,	'1',	1,	'2023-04-27 22:52:41',	'2023-10-19 11:15:15'),
(3,	'/4isqg51639389449522Product - All P&S at ABHC_Website-0bd9e252-3e5f-4e5c-82a5-e6ee28ce1ec3.jpg',	NULL,	'3',	1,	'2023-04-27 22:54:29',	'2023-10-20 08:46:05'),
(4,	'/Manolia Salon-520262c3-699b-488a-b046-9137920567ca.jpg',	NULL,	'4',	2,	'2023-10-18 19:41:01',	'2023-10-18 19:41:42'),
(5,	'/Lice-partner-94532f62-45fe-4968-a995-d599abdbc2ca.jpg',	NULL,	'Lice Partner',	1,	'2023-11-14 05:57:08',	'2023-11-14 06:03:54');

DROP TABLE IF EXISTS `staffs`;
CREATE TABLE `staffs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `staff_type_id` int(11) NOT NULL,
  `staff_position_id` int(11) DEFAULT NULL,
  `full_name` longtext CHARACTER SET utf8mb4 NOT NULL COMMENT 'km, en',
  `email` varchar(125) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(125) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gender` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `profile` varchar(125) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) NOT NULL,
  `cv` varchar(125) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `noted` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `staffs_email_unique` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `staffs` (`id`, `staff_type_id`, `staff_position_id`, `full_name`, `email`, `phone`, `gender`, `profile`, `status`, `cv`, `noted`, `user_id`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1,	3,	NULL,	'YEM Sreyleak',	'sreyleakyem@gmailcom',	'086 653 888',	'F',	'/2023-01-23 14.37.15-645d5215-fb39-4720-8435-3873b5707bce.jpg',	2,	NULL,	NULL,	0,	'2022-12-31 05:26:58',	'2023-11-25 09:08:33',	NULL),
(2,	2,	NULL,	'La Vibol',	'vibol.la@gmail.com',	'12 772 775',	'M',	'/2023-01-23 14.24.01-1da98681-d1b9-43a4-9322-e743ce294ca9.jpg',	1,	NULL,	NULL,	0,	'2023-01-02 10:45:10',	'2023-01-23 19:34:25',	NULL),
(3,	1,	NULL,	'user1',	'jj@gmail.com',	'039337493',	'F',	'/photo_2022-09-27_14-03-05-fdfdc157-1fd4-4b0e-a546-618f889c9397.jpg',	2,	NULL,	'yes',	0,	'2023-01-09 14:20:58',	'2023-01-09 14:31:28',	NULL),
(4,	4,	NULL,	'Phung Sovichtra',	NULL,	'092 762 503',	'M',	'/IMG_3918-c7302d1f-e1de-4986-b933-8a3ceafca1b7.PNG',	1,	NULL,	NULL,	0,	'2023-01-23 20:05:28',	'2023-02-02 14:20:58',	NULL),
(5,	4,	NULL,	'Ou Nak',	NULL,	NULL,	'M',	'/photo_2023-02-02_09-03-23-52401c9b-17eb-4ff9-927b-6eb0b11e9af1.jpg',	2,	NULL,	NULL,	0,	'2023-01-23 20:05:54',	'2023-12-12 15:28:19',	NULL),
(6,	3,	NULL,	'Ung Puthy',	NULL,	'011 789 907',	'F',	'/B Puty (4x6)-cc9d17b9-240a-443a-a660-d26fa1515871.jpg',	1,	NULL,	NULL,	1,	'2023-01-23 20:06:15',	'2023-11-25 09:07:24',	NULL),
(7,	2,	2,	'Kim Nim',	NULL,	'087 586 395',	'F',	'/IMG_9375-0b5f88a3-7140-4db8-acd6-bab75bd61970.JPG',	1,	NULL,	NULL,	0,	'2023-01-23 20:06:36',	'2023-02-11 22:32:09',	NULL),
(8,	2,	3,	'Len Nak',	NULL,	'088 48 95 55 25',	'F',	'/4x6-0a1bc69d-8fce-4791-87a4-9f64a2640f6e.jpg',	2,	NULL,	NULL,	1,	'2023-02-02 14:48:09',	'2023-12-12 11:11:47',	NULL),
(9,	2,	1,	'Thet Piseth',	NULL,	'098 756 875',	'F',	'/photo_2022-09-08_09-31-19-52ed8b76-ee09-4bd6-ad6d-b75ae0656307.jpg',	1,	NULL,	NULL,	0,	'2023-02-02 14:56:33',	'2023-02-05 13:25:44',	NULL),
(10,	3,	6,	'Lyhean 01 edited',	NULL,	NULL,	'F',	NULL,	2,	NULL,	NULL,	0,	'2023-05-04 19:14:11',	'2023-05-04 19:20:36',	NULL),
(11,	3,	1,	'Puthy',	NULL,	NULL,	'F',	NULL,	1,	NULL,	NULL,	1,	'2023-12-12 11:13:00',	'2023-12-12 11:13:59',	NULL);

DROP TABLE IF EXISTS `staff_positions`;
CREATE TABLE `staff_positions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `status` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `staff_positions` (`id`, `name`, `status`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1,	'Account',	1,	'2023-02-05 13:20:59',	'2023-02-05 13:20:59',	NULL),
(2,	'Trainner',	1,	'2023-02-11 22:31:15',	'2023-02-11 22:31:15',	NULL),
(3,	'School and study Coordinate',	1,	'2023-04-05 03:50:28',	'2023-04-05 14:50:28',	NULL),
(4,	'Courses Programmer',	1,	'2023-04-05 14:54:20',	'2023-04-05 14:54:20',	NULL),
(5,	'Marketing',	1,	'2023-04-05 15:48:01',	'2023-04-05 15:48:01',	NULL),
(6,	'Sever Maintainer edited',	1,	'2023-05-04 08:03:10',	'2023-05-04 19:03:10',	NULL);

DROP TABLE IF EXISTS `staff_types`;
CREATE TABLE `staff_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `staff_types` (`id`, `name`, `status`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1,	'Edited Testings',	0,	'2022-12-30 10:04:39',	'2023-05-04 20:10:12',	NULL),
(2,	'Trainer',	1,	'2023-01-09 14:23:19',	'2023-01-23 19:18:06',	NULL),
(3,	'Admin',	1,	'2023-01-22 13:47:08',	'2023-01-23 19:17:41',	NULL),
(4,	'Staff',	1,	'2023-01-23 19:18:26',	'2023-01-23 19:18:26',	NULL),
(5,	'Teacher eidted',	1,	'2023-05-04 18:41:08',	'2023-05-04 18:42:57',	NULL);

DROP TABLE IF EXISTS `structure_programs`;
CREATE TABLE `structure_programs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `class_occupation_id` int(11) NOT NULL,
  `lesson_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `structure_programs` (`id`, `class_occupation_id`, `lesson_id`, `description`, `user_id`, `created_at`, `updated_at`) VALUES
(1,	1,	'[\"3\",\"1\",\"2\",\"4\",\"6\",\"7\",\"8\"]',	'For dev testing',	0,	'2023-01-22 13:39:19',	'2023-01-22 14:09:08'),
(2,	1,	'[\"4\",\"5\",\"6\",\"7\",\"8\"]',	'Program Structure for dev testing',	0,	'2023-01-22 14:06:26',	'2023-01-22 14:06:26'),
(3,	2,	'[\"1\",\"4\",\"6\",\"7\"]',	'Program Structure dev testing 2',	0,	'2023-01-22 14:10:01',	'2023-01-22 14:10:01'),
(4,	3,	'[\"5\",\"6\",\"7\"]',	'Testing dev3',	0,	'2023-01-23 13:17:55',	'2023-01-23 13:17:55'),
(5,	1,	'[1,2]',	'C1',	1,	'2023-04-17 20:04:41',	'2023-11-25 09:32:33'),
(6,	4,	'[3]',	'Hair Color',	1,	'2023-06-27 15:46:44',	'2023-12-27 10:21:43');

DROP TABLE IF EXISTS `students`;
CREATE TABLE `students` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `education_level_id` int(11) NOT NULL,
  `name_latin` varchar(255) CHARACTER SET utf8mb4 DEFAULT NULL COMMENT 'km, en',
  `name_khmer` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `email` varchar(125) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` varchar(125) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `id_card` varchar(125) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sid` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone_with_telegram` varchar(125) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gender` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `profile` varchar(125) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_khmer` text COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'km, en',
  `address_latin` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `noted` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `working_experience` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `current_working_place` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) DEFAULT 1,
  `approval_status` varchar(125) COLLATE utf8mb4_unicode_ci DEFAULT 'approved' COMMENT 'pending, approved, rejected',
  `role` varchar(125) COLLATE utf8mb4_unicode_ci DEFAULT 'student',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `students` (`id`, `education_level_id`, `name_latin`, `name_khmer`, `dob`, `email`, `password`, `id_card`, `sid`, `phone`, `phone_with_telegram`, `gender`, `profile`, `address_khmer`, `address_latin`, `noted`, `working_experience`, `current_working_place`, `status`, `approval_status`, `role`, `created_at`, `updated_at`, `deleted_at`, `remember_token`) VALUES
(1,	1,	'Chhorn Chiva',	'ឆន ជីវ៉ា',	'2001-12-07',	'chhornchiva@gmail.com',	NULL,	'91',	'91',	'088 900 4006',	'088 900 4006',	'M',	'/ChhongChiva-4d1306b4-e8fc-451c-9998-3f77e1ff9278.png',	'Phnom Penh',	NULL,	NULL,	NULL,	NULL,	1,	'approved',	'student',	'2023-01-09 15:11:59',	'2023-01-24 15:14:47',	NULL,	NULL),
(2,	1,	'Kheav Lina',	'ខៀវ លីណា',	'1996-04-04',	'kheavlina@gmail.com',	NULL,	'92',	'92',	'087 610635',	'087 610635',	'F',	'/KheavLina-cd35c433-5992-4298-9464-415fd72d9cd1.png',	'Phnom Penh',	NULL,	NULL,	NULL,	NULL,	1,	'approved',	'student',	'2023-01-22 13:53:05',	'2023-01-24 15:11:37',	NULL,	NULL),
(3,	1,	'Chhun Lina',	'ឈុន លីណា',	'1993-09-06',	'chhunlina@gmail.com',	NULL,	'003',	'93',	'070 900 075',	'070 900 075',	'F',	'/chhunLinna-786fff4e-b968-488e-887a-17f3f628021f.png',	'Phnom Penh',	NULL,	NULL,	NULL,	NULL,	1,	'approved',	'student',	'2023-01-22 13:57:50',	'2023-01-24 15:09:17',	NULL,	NULL),
(4,	1,	'Mey Vuthy',	'ម៉ី វិទ្ធី',	'1993-07-01',	NULL,	NULL,	'90',	'023/22H',	'096 969 6076',	'096 969 6076',	'F',	'/MeyYuthy-a8dcd388-53ab-429d-b535-06370db12b82.png',	'Phnom Penh',	NULL,	NULL,	NULL,	NULL,	1,	'approved',	'student',	'2023-01-24 15:17:50',	'2023-02-03 20:32:10',	NULL,	NULL),
(5,	1,	'Pork Dane',	'ប៉ោក ដាណេ',	'1997-04-12',	NULL,	NULL,	'89',	'89',	'093 490 375',	'093 490 375',	'F',	'/PorkDane-e7f58425-aa83-4dde-84ba-cb42aac96d06.png',	'Phnom Penh',	NULL,	NULL,	NULL,	NULL,	1,	'approved',	'student',	'2023-01-24 15:19:41',	'2023-01-24 15:19:41',	NULL,	NULL),
(6,	8,	'Keang Navy',	'កៀង ណាវី',	'1982-01-30',	NULL,	NULL,	NULL,	'001',	'088 252​ 6466',	'088 252​ 6466',	'F',	NULL,	'ភ្នំពេគ',	NULL,	'SDF Round 1',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-02 16:59:01',	'2023-02-02 16:59:01',	NULL,	NULL),
(7,	8,	'Ngin Chariya',	'ងិន ចរិយា',	'1989-05-12',	NULL,	NULL,	NULL,	'002',	'098 722 096/095 722 096',	'098 722 096/095 722 096',	'F',	NULL,	'ភ្នំពេញ',	NULL,	'SDF Round1',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-02 19:12:55',	'2023-02-02 19:12:55',	NULL,	NULL),
(8,	8,	'Tay You I',	'តាយ យូអ៉ី',	'1992-12-02',	NULL,	NULL,	NULL,	'003',	'093 921 288',	'093 921 288',	'F',	NULL,	'St K4B # 18gk  ភូមិទ្រុង​មាន សង្គាត់ អូបែកក្អម ខណ្ឌ សែនសុខ',	NULL,	'SDF Round 1',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-02 19:23:37',	'2023-02-02 19:23:37',	NULL,	NULL),
(9,	8,	'Nun Sreyleap',	'នន់ ស្រីលាភ',	'1995-08-26',	NULL,	NULL,	NULL,	'004',	'086​​ 800 219',	'086​​ 800 219',	'F',	NULL,	'ផ្លូវលេខ 139 ផ្ទះលេខ 17EO សង្គាត់ វាលវង់ ខណ្ឌ 7មករា',	NULL,	'SDF Round 1',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-02 19:28:16',	'2023-02-02 19:28:16',	NULL,	NULL),
(10,	8,	'Nut Sreypich',	'នុត ស្រីពេជ្រ',	'1996-10-03',	NULL,	NULL,	NULL,	'005',	'099 443 030',	'099 443 030',	'F',	NULL,	'សង្គាត់ ទួលគោក ខណ្ឌ ទួលគោក',	NULL,	'SDF Round 1',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-02 19:48:54',	'2023-02-02 19:48:54',	NULL,	NULL),
(11,	8,	'Ben Serynick',	'ប៉ែន ស្រីនិច',	'1995-02-01',	NULL,	NULL,	NULL,	'006',	'077 757 526',	'077 757 526',	'F',	NULL,	'ផ្លះលេខ 59 ភូមិ ត្រពាំងល្វា សង្គាត់​ កាកាបទី1 ខណ្ឌ ពោធីសែនជ័យ',	NULL,	NULL,	NULL,	NULL,	1,	'approved',	'student',	'2023-02-02 19:58:39',	'2023-02-02 19:58:39',	NULL,	NULL),
(12,	8,	'Phan Chakriya',	'ផាត ចរិយា',	'1995-08-22',	NULL,	NULL,	NULL,	'007',	'077 630 052',	'077 630 052',	'F',	NULL,	'ភូមិ រកាកោង សង្គាត់​ រកាកោង1 ខណ្ឌ មុខកំបូល',	NULL,	'SDF Round 1',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-02 20:16:20',	'2023-02-02 20:16:20',	NULL,	NULL),
(13,	8,	'Phan Chakriya',	'ផាន ចរិយា',	'1999-02-13',	NULL,	NULL,	NULL,	'008',	'096 553 3633',	'096 553 3633',	'F',	NULL,	'ភូមិ ទ្រា សង្គាត់​ ស្ទឹងមានជ័យ ខណ្ឌ មានជ័យ',	NULL,	'SDF Round 1',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-02 20:41:43',	'2023-02-02 20:41:43',	NULL,	NULL),
(14,	8,	'Meas Dore',	'មាស ដូរ៉េ',	'1981-01-01',	NULL,	NULL,	NULL,	'009',	'070 696 069',	'070 696 069',	'M',	NULL,	'ភូមិ តាងួន សង្គាត់ កាកាប ខណ្ឌ ដង្កោ',	NULL,	'SDF Round 1',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-02 20:51:19',	'2023-02-02 20:51:19',	NULL,	NULL),
(15,	1,	'Vong  Chanrathanak',	'វង្ស ច័ន្ទរត្ត័នៈ',	'2002-02-11',	NULL,	NULL,	NULL,	'010',	'069 856 233',	'069 856 233',	'F',	'/chanrothnak-036e76ba-e30d-4a5b-b459-5da1ee516390.jpg',	'ភូមិ ព្រែក​ធំ ​សង្កាត់ក្បាលកោះ ខណ្ឌ ច្បារអំពៅ',	NULL,	'SDF Round1',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-02 20:55:31',	'2023-04-04 20:33:19',	NULL,	NULL),
(16,	8,	'Vorn Sreyvith',	'វ៉ន ស្រីវិត',	'2006-02-21',	NULL,	NULL,	NULL,	'011',	'096 957 4711',	'096 957 4711',	'F',	NULL,	'ផ្លូវលេខ​574​ ផ្ទះលេខ 10A ភូមិ5 សង្គាត់​ បឹងកក់2',	NULL,	'SDF Round 1',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-02 21:49:23',	'2023-02-02 21:49:23',	NULL,	NULL),
(17,	1,	'Sang Ravy',	'សាង​ រ៉ាវី',	'1990-03-28',	NULL,	NULL,	NULL,	'012/21H1',	'070​ 859 059',	'070​ 859 059',	'F',	NULL,	'ផ្លូវលេខ 44 ផ្ទះលេខ 500 ភូមិ សង្គាត់ ផ្សារដើមថ្កូវ ខណ្ឌ ចម្ការមន',	NULL,	NULL,	NULL,	NULL,	1,	'approved',	'student',	'2023-02-02 21:56:16',	'2023-02-02 22:01:34',	NULL,	NULL),
(18,	1,	'Sok Sovanrothana',	'សុខ សុវណ្ណរតនា',	'1989-07-14',	NULL,	NULL,	NULL,	'013/21H1',	'098 499 498',	'098 499 498',	'F',	NULL,	'ផ្លូវលេខ 180 ផ្ទះលេខ 53CE ភូមិ ទី7 សង្គាត់បឹងរាំង ខណ្ឌ ដូនពេញ',	NULL,	NULL,	NULL,	NULL,	1,	'approved',	'student',	'2023-02-02 21:59:48',	'2023-02-02 22:00:56',	NULL,	NULL),
(19,	8,	'Kheam Socheata',	'ឃាន សុជាតិ',	'1995-06-07',	NULL,	NULL,	NULL,	'001/21C',	'093 293 992',	'093 293 992',	'M',	NULL,	'ផ្លូវលំ ផ្ទះលេខ 109B ភូមិស្ទឹងមានជ័យ សង្គាត់ស្ទឹងមានជ័យ ខណ្ឌមានជ័យ',	NULL,	'SDF Round 1',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-03 14:46:03',	'2023-02-03 14:46:03',	NULL,	NULL),
(20,	1,	'Chea Chomroeun',	'ជា ចំរើន',	'1994-10-07',	NULL,	NULL,	NULL,	'002/21C',	'081 556 634',	'081 556 634',	'M',	NULL,	'ផ្លូវលេខ 442 ផ្ទះលេខ 129 ភូមិ6 សង្គាត់ ទូលទំពូង ខណ្ឌ ចំការមន',	NULL,	'SDF Round 1',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-03 14:56:03',	'2023-02-03 15:05:03',	NULL,	NULL),
(21,	1,	'Pen Dara',	'ប៉ែន តារ៉ា',	'1995-07-07',	NULL,	NULL,	NULL,	'003/21C',	'089 286 478',	'089 286 478',	'M',	'/តារ៉ា-68627ac9-7e17-4f56-9585-7640e893f1ba.jpg',	'ផ្លះលេខ 211​ភូមិសន្សំកុសល2 សង្គាត់បឹងទំពន់ ខណ្ឌមានជ័យ',	NULL,	'SDF Round 1',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-03 14:59:35',	'2023-04-04 20:32:49',	NULL,	NULL),
(22,	1,	'Phin Chinda',	'ភិន ចិន្ដា',	'1983-08-08',	NULL,	NULL,	NULL,	'004/21C',	'012 978 484',	'012 978 484',	'F',	NULL,	'ផ្ទះ​លេខ 132 ផ្លូវ 51 ភូមិ ប្រាំ សង្គាត់ បឹងកេងកង1 ខណ្ឌ បឹងកេងកង1',	NULL,	'SDF Round 1',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-03 15:11:25',	'2023-02-03 15:11:25',	NULL,	NULL),
(23,	8,	'Sun Vutha',	'សាន់ វុត្ថា',	'1991-10-05',	NULL,	NULL,	NULL,	'005/21C',	'011​ 951 489',	'011​ 951 489',	'F',	NULL,	'ផ្លូវលេខ 46 ផ្លះលេខ 95 ភូមិ​ 9​ សង្គាត់ បី ខណ្ឌ ចំការមន',	NULL,	NULL,	NULL,	NULL,	1,	'approved',	'student',	'2023-02-03 15:38:38',	'2023-02-03 15:38:38',	NULL,	NULL),
(24,	1,	'Seng Toch',	'សេង តូច',	'1987-01-08',	NULL,	NULL,	NULL,	'006/21C',	'016 556 897',	'016 556 897',	'M',	'/សេង តូច-513ede6a-ea2d-4fe0-a583-3b6dacf0254d.jpg',	'ផ្លូវលេខ​ 376 ផ្ទះលេខ 86 ភូមិ 6 សង្គាត់ ទួលស្វាយព្រៃ1 ខណ្ឌ បឹងកេងកង',	NULL,	'SDF Round 1',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-03 15:42:06',	'2023-04-04 20:25:57',	NULL,	NULL),
(25,	8,	'Sao Kimhak',	'សៅ គឹមហាក់',	'2000-03-16',	NULL,	NULL,	NULL,	'007/21C',	'087 979 392',	'087 979 392',	'M',	NULL,	'មិនមានព័ត៌មាន',	NULL,	'SDF Round 1',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-03 15:44:45',	'2023-02-03 15:44:45',	NULL,	NULL),
(26,	1,	'Heng  sreyleak',	'ហេង ស្រីល័ក្ខ',	'1988-01-07',	NULL,	NULL,	NULL,	'008/21C',	'093 821 158',	'093 821 158',	'F',	NULL,	'ផ្លូវលេខ 53 BT ផ្ទះលេខ 290 ភូមិ ត្នោតជ្រុំ សង្គាត់ បឹងទំពន់ទី2 ខណ្ឌ មានជ័យ',	NULL,	'SDF Round 1',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-03 15:48:19',	'2023-02-03 15:48:19',	NULL,	NULL),
(27,	8,	'Im prosleak',	'អ៉ឹម ប្រុសល័ក្ខ',	'1995-11-27',	NULL,	NULL,	NULL,	'009/21C',	'093 213 499',	'093 213 499',	'F',	NULL,	'ផ្ទះលេខ 141C ផ្លូវលំ ភូមិស្ទឹងមានជ័យ ខណ្ឌ មានជ័យ',	NULL,	'SDF Round 1',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-03 15:54:47',	'2023-02-03 15:54:47',	NULL,	NULL),
(28,	8,	'Kong  sreynoch',	'គង់ ស្រីណុច',	'1992-01-04',	NULL,	NULL,	NULL,	'014/22H',	'017 335 533',	'017 335 533',	'F',	NULL,	'បុរីតូយ្យូ 999 ទឹកថ្លា ខណ្ឌសែនសុខ',	NULL,	'SDF Round 2',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-03 16:33:46',	'2023-02-03 16:33:46',	NULL,	NULL),
(29,	1,	'Sem Davy',	'សែម​ ដាវី',	'1989-09-07',	NULL,	NULL,	NULL,	'015/22H',	'088 807 3199',	'088 807 3199',	'F',	'/សែម ដាវី-bb61b1cc-01ea-4070-8651-3d1c653a6149.jpg',	'សំរោងកណ្ដាល សង្គាត់ សំរោង ខណ្ឌ​ ព្រែកព្នៅ',	NULL,	'SDF Round 2',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-03 16:36:50',	'2023-04-04 20:25:24',	NULL,	NULL),
(30,	8,	'Bun Theunsovanthai',	'ប៊ុន ធឿនសុវ៉ាន់ថៃ',	'1999-01-25',	NULL,	NULL,	NULL,	'016/22H',	'017 649 259',	'017 649 259',	'F',	NULL,	'ភូមិ ព្រែកហូរ សង្គាត់ ព្រែកហូរ ខណ្ឌ តាខ្មៅ',	NULL,	'SDF Round 2',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-03 16:59:35',	'2023-02-03 16:59:35',	NULL,	NULL),
(31,	1,	'Chhun Linna',	'ឈុន លីណា',	'1990-01-05',	NULL,	NULL,	NULL,	'017/22H',	'010 97 86 97',	'010 97 86 97',	'F',	NULL,	'សង្គាត់ ទឹកថ្លា ខណ្ឌ សែនសុខ',	NULL,	'SDF Round 2',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-03 17:01:20',	'2023-02-03 18:48:48',	NULL,	NULL),
(32,	1,	'Tuot Sophorn',	'ទួត សុភ័ណ្ឌ',	'1996-07-17',	NULL,	NULL,	NULL,	'019/22H',	'097 671 9019/099 240 003',	'097 671 9019/099 240 003',	'F',	'/សុភ័ណ្ឌ-f536b10c-2bd3-4ed5-aad5-0a9fce56d71b.jpg',	'ផ្ទះលេខ1 ផ្លូវM14 កម្រោង4 ប៉េងហួតបឹងស្នោរ',	NULL,	'SDF Round 2',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-03 18:35:39',	'2023-04-04 20:24:23',	NULL,	NULL),
(33,	8,	'Chhum Choulean',	'ឈុំ ជូលាន',	'2004-01-14',	NULL,	NULL,	NULL,	'018/22H',	'017 701 888',	'017 701 888',	'F',	NULL,	'មិនមានទិន្នន័យ',	NULL,	'SDF Round2',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-03 18:52:35',	'2023-02-03 18:52:35',	NULL,	NULL),
(34,	1,	'Pork Dane',	'ប៉ោក ដាណា',	'1997-04-12',	NULL,	NULL,	NULL,	'020/22H',	'093​ 490 375/088',	NULL,	'F',	NULL,	'ភូមិ កណ្ដាលកោះ ឃុំ កោះអន្កង់ចិន ស្រុក ស្អាង​ ខេត្ត​កណ្ដាល',	NULL,	'SDF Round 2',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-03 19:02:13',	'2023-02-03 19:02:13',	NULL,	NULL),
(35,	8,	'San Sereyroth',	'សាន សេរីរ៍ត',	'1987-05-23',	NULL,	NULL,	NULL,	'021/22H',	'097 487 5533',	'097 487 5533',	'F',	NULL,	'ភូមិតាខ្មៅ២ សង្គាត់ តាខ្មៅ',	NULL,	'SDF Round 2',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-03 19:30:49',	'2023-02-03 19:30:49',	NULL,	NULL),
(36,	8,	'Phin Samnang',	'ភិន សំណាង',	'1990-09-09',	NULL,	NULL,	NULL,	'022/22H',	'089 413 587',	'089 413 587',	'F',	NULL,	'ភ្នំពេញ',	NULL,	'SDF Round 2',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-03 20:26:01',	'2023-02-03 20:26:01',	NULL,	NULL),
(37,	1,	'Chhom Bounnary',	'ឈុំ ប៊ុនណារី',	'1990-05-04',	NULL,	NULL,	NULL,	'024/22H',	'098 348 666',	'098 348 666',	'F',	'/ឈុំ ប៊ុនណារី-b62cb1ea-911f-47b1-b7ec-d625616ece2c.jpg',	'ខណ្ឌ​ ដង្កោ',	NULL,	'SDF Round1',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-03 20:35:16',	'2023-04-04 20:24:59',	NULL,	NULL),
(38,	8,	'Ret Molyka',	'រ៉េត មល្លិការ',	'2000-07-10',	NULL,	NULL,	NULL,	'025/22H',	'086 771 120',	'086 771 120',	'F',	NULL,	'ភ្នំពេញ',	NULL,	'SDF Round 2',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-03 21:45:43',	'2023-02-03 21:45:43',	NULL,	NULL),
(39,	8,	'Lin Sreyneat',	'លីន ស្រីនាត',	'2000-04-01',	NULL,	NULL,	NULL,	'026/22H',	'016 429 599',	'016 429 599',	'F',	NULL,	'ភូមិព្រែកប៉ាន ឃុំ ត្រើយស្លា ខេត្តកណ្ដាល',	NULL,	'SDF Round 2',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-03 21:50:34',	'2023-02-03 21:50:34',	NULL,	NULL),
(40,	8,	'Vong Sakhena',	'វង់ សក្ខិណា',	'1992-11-23',	NULL,	NULL,	NULL,	'027/22H',	'078 334 567',	'078 334 567',	'F',	NULL,	'សង្គាត់ ជ័យជំនៈ ខណ្ឌ ដូនពេញ',	NULL,	'SDF Round 2',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-03 21:54:23',	'2023-02-03 21:54:23',	NULL,	NULL),
(41,	1,	'Heng Sreyleak',	'ហេង ស្រីល័ក្ខ',	'1988-01-07',	NULL,	NULL,	NULL,	'028/22H',	'093 821 158/',	'093 821 158',	'F',	NULL,	'ផ្ទះ 290​ ផ្លូវ​3BT ភូមិ ត្នោតជ្រុំ សង្គាត់ បឹងទំពន់ទី2 ខណ្ឌមានជ័យ',	NULL,	'SDF Round 2',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-03 21:58:57',	'2023-02-03 21:58:57',	NULL,	NULL),
(42,	8,	'Thim Socheata',	'ធឹម សុជាតា',	'1992-08-24',	NULL,	NULL,	NULL,	'029/22H',	'097 729 7040',	'097 729 7040',	'F',	NULL,	'ឃុំកោះដាច់ ជ្រោយចង្វារ ភ្នំពេញ',	NULL,	'SDF Round 2',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-03 22:01:59',	'2023-02-03 22:01:59',	NULL,	NULL),
(43,	8,	'Soung Sreypi',	'សួង ស្រីពី',	'2000-08-08',	NULL,	NULL,	NULL,	'N/A',	'090 690 754',	'090 690 754',	'F',	NULL,	'N/A',	NULL,	'SDF Round 2',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-04 14:19:21',	'2023-02-04 14:19:21',	NULL,	NULL),
(44,	8,	'Kry Bunsathya',	'គ្រី ប៊ុណ្ណាសត្យា',	'1995-01-07',	NULL,	NULL,	NULL,	'010/C',	'086 616 916',	'086 616 916',	'M',	NULL,	'ច្បារអំពៅ',	NULL,	'SDF Round 2',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-04 14:26:32',	'2023-02-04 14:26:32',	NULL,	NULL),
(45,	8,	'Til Ratha',	'ទិល រដ្ឋា',	'1998-06-11',	NULL,	NULL,	NULL,	'011/22C',	'090 709 119',	'090 709 119',	'M',	NULL,	'កំពង់ចាម',	NULL,	'SDF Round',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-04 14:30:23',	'2023-02-04 14:30:23',	NULL,	NULL),
(46,	8,	'Roth Pov',	'រដ្ឋ ពៅ',	'1993-09-10',	NULL,	NULL,	NULL,	'012/22C',	'096 333 3252',	'096 333 3252',	'M',	NULL,	'បឹងកេងកង៣',	NULL,	'SDF Round',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-04 14:33:31',	'2023-02-04 14:33:31',	NULL,	NULL),
(47,	8,	'Phon Phengphallin',	'ភុន ផេងផល្លីន',	'1987-06-23',	NULL,	NULL,	NULL,	'013/22C',	'093 728 168 / 061 279 953',	'093 728 168 / 061 279 953',	'M',	NULL,	'ផ្ទះលេខ​5 ផ្លូវលេខ 608 សង្គាត់ បឹងកក់2​ ខណ្ឌ ទួលគោក',	NULL,	'SDF Round 2',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-04 14:59:38',	'2023-02-04 14:59:38',	NULL,	NULL),
(48,	8,	'Meng Sophors',	'ម៉េង សុភ័ស',	'1996-08-05',	NULL,	NULL,	NULL,	'013/22C',	'069 925 137',	'069 925 137',	'M',	NULL,	'ពោចិនតុង',	NULL,	'SDF Round 2',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-04 15:02:24',	'2023-02-04 15:02:24',	NULL,	NULL),
(49,	8,	'Meas Chanthon',	'មាស ចាន់ថន',	'1993-09-05',	NULL,	NULL,	NULL,	'015/22C',	'070 663 555',	'070 663 555',	'F',	NULL,	'N/A',	NULL,	'SDF Round 2',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-04 15:05:05',	'2023-02-04 15:05:05',	NULL,	NULL),
(50,	8,	'Phon Phengphallay',	'ភុន ផេថផល័យ',	'1990-01-05',	NULL,	NULL,	NULL,	'016/22C',	'069 762 168',	'069 762 168',	'M',	NULL,	'ផ្ទះលេខ 5 ផ្លូវ 608 សង្គាតដូនពេញ',	NULL,	'SDF Round 2',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-04 15:16:51',	'2023-02-04 15:16:51',	NULL,	NULL),
(51,	8,	'Son Ton',	'សុន​ តុន',	'1993-11-11',	NULL,	NULL,	NULL,	'017/22C',	'010 650 505',	'010 650 505',	'M',	NULL,	'បឹងកេងកង៣',	NULL,	'SDF Round 2',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-04 15:23:12',	'2023-02-04 15:23:12',	NULL,	NULL),
(52,	8,	'Arn Sivcheng',	'អាន សៀវចេង',	'2003-10-25',	NULL,	NULL,	NULL,	'018/22C',	'097 278 3852',	'097 278 3852',	'F',	NULL,	'បឹងទំពន់២',	NULL,	'SDF Round 2',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-04 15:26:50',	'2023-02-04 15:26:50',	NULL,	NULL),
(53,	1,	'Ly sopois',	'លី សុពណ៌',	'1984-02-24',	NULL,	NULL,	NULL,	'N/a',	'092210 706',	'092210 706',	'F',	'/សុពណ៌-ed6f378f-7026-4d8e-9050-3ae169e97f7e.jpg',	'ផ្ទះលេខ 458 ភូមិក្រពើហា សង្គាត់ ចាក់អង្រែ ខណ្ឌ មានជ័យ',	NULL,	'SDF Round 3',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-04 19:50:14',	'2023-04-04 20:23:00',	NULL,	NULL),
(54,	1,	'Sem Davy',	'សែម ដាវី',	'1989-09-07',	NULL,	NULL,	NULL,	'N/A',	'088 807 3199/',	'088 807 3199',	'F',	'/សែម ដាវី-bb61b1cc-01ea-4070-8651-3d1c653a6149.jpg',	'ភូមិ សំរោងកណ្ដាល សង្គាត់ សំរោង ខណ្ឌ ព្រែកព្នៅ',	NULL,	NULL,	NULL,	NULL,	1,	'approved',	'student',	'2023-02-04 20:04:07',	'2023-04-04 20:22:24',	NULL,	NULL),
(55,	1,	'Eang Rithy',	'អៀង រិទ្ធី',	'1992-02-26',	NULL,	NULL,	NULL,	'N/A',	'096 411 4169',	'096 411 4169',	'M',	'/អៀង​ រឹទ្ធី-d9779aea-e583-426c-9bb9-3261d12ecf36.jpg',	'ផ្ទះលេខ 81 ផ្លូវលេខ 217 ភូមិ 17 សង្គាត់ បឹងសាលាង ខណ្ឌ ទួលគោក',	NULL,	'SDF Round 3',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-04 20:08:01',	'2023-04-04 20:21:53',	NULL,	NULL),
(56,	1,	'Im Somnang',	'អ៉ីម សំណាង',	'2002-06-05',	NULL,	NULL,	NULL,	'N/A',	'011 286 165',	'011 286 165',	'F',	'/សំណាង-765ede22-22f2-4d9e-bd49-32a20b5a341f.jpg',	'ផ្ទះលេខ 240 ភូមិ ព្រែកហូរកើត សង្គាត់ ព្រែកហូរកើត គ្រុង តាខ្មៅ',	NULL,	'SD Round 3',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-04 20:26:14',	'2023-04-04 19:50:03',	NULL,	NULL),
(57,	1,	'Von Rotha',	'វ៉ន រដ្ឋា',	'2008-03-01',	NULL,	NULL,	NULL,	'N/A',	'096 229 5455',	'096 229 5455',	'F',	'/រដ្ថា-185de661-d4db-47b7-86f4-c639670b6f0b.jpg',	'បឹងកក់២',	NULL,	'SDF Round 3',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-04 20:33:27',	'2023-04-04 15:03:09',	NULL,	NULL),
(58,	1,	'Vong Chanrothnak',	'វង្ស ច័ន្ទរត្ត័នៈ',	'2002-02-11',	NULL,	NULL,	NULL,	'N/A',	'069 856 233/',	'069 856 233',	'F',	'/chanrothnak-036e76ba-e30d-4a5b-b459-5da1ee516390.jpg',	'សង្គាត់ក្បាលកោះ ខណ្ឌ ច្បារអំពៅ',	NULL,	'SDF Round3',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-04 20:45:27',	'2023-04-04 15:02:29',	NULL,	NULL),
(59,	8,	'Ret Molyka',	'រ៉េត មលិ្លកា',	'2000-07-10',	NULL,	NULL,	NULL,	'N/A',	'086 771130/',	'086 771130',	'F',	NULL,	'ផ្ទះលេខ 104 ផ្លូវលេខ 26BT ភូមិ ក្បាលទំណប់ សង្គាត់ បឹងទំពុន 2 ខណ្ឌ មានជ័យ',	NULL,	'SDF Round 3',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-04 20:48:41',	'2023-02-04 20:48:41',	NULL,	NULL),
(60,	8,	'Yeat Sreymom',	'យ៉ាត ស្រីមុំ',	'2001-06-01',	NULL,	NULL,	NULL,	'N/A',	'088 523 7664',	'088 523 7664',	'F',	NULL,	'ផ្លូវលេខ 592 សង្គាត់ បឹងកក់២​ ខណ្ឌ​ ទួលគោក',	NULL,	'SDF Round 3',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-04 20:51:28',	'2023-02-04 20:51:28',	NULL,	NULL),
(61,	8,	'Puth Sotheary',	'ពុធ​ សុ ធារី',	'1991-01-03',	NULL,	NULL,	NULL,	'N/A',	'070 800 657',	'070 800 657',	'F',	NULL,	'សង្គាត់ វាលស្បូវ ខណ្ឌ មានជ័យ',	NULL,	'SDF Round3',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-04 20:58:28',	'2023-02-04 20:58:28',	NULL,	NULL),
(62,	8,	'Korng  Kimorn',	'កង គីមអ៊ន់',	'1992-05-02',	NULL,	NULL,	NULL,	'N/A',	'0964997307',	'0964997307',	'F',	NULL,	'សង្គាត់ ផ្សារដើមថ្គូវ ខណ្ឌ ចំការមន',	NULL,	'SDF Round 3',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-04 21:01:16',	'2023-02-04 21:01:16',	NULL,	NULL),
(63,	1,	'Prom Yen',	'ព្រហ្ម យេន',	'1987-10-12',	NULL,	NULL,	NULL,	'N/A',	'092 666 596',	'092 666 596',	'M',	'/ព្រហ្ម យ៉េន-24f49cce-bfb5-4720-80c2-1d412dff4a0c.jpg',	'សៀមរាប',	NULL,	'SDF Round3',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-04 21:03:53',	'2023-04-04 14:34:20',	NULL,	NULL),
(64,	1,	'Pon Sothea',	'ប៉ុន សុធា',	'1995-07-09',	NULL,	NULL,	NULL,	'N/A',	'096 591 2555',	'096 591 2555',	'M',	'/សុធា-bcc81118-9cba-4868-906f-0410597cfcaf.jpg',	'ផ្ទះលេខ 25 ផ្លូវលំ ភូមិ ចុងខ្សាច់ សង្គាត់​ឬស្សីកែវ',	NULL,	'SDF Round3',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-04 21:07:17',	'2023-04-04 14:32:46',	NULL,	NULL),
(65,	1,	'Phan Henglay',	'ផាន់ ហេងឡាយ',	'2001-03-06',	NULL,	NULL,	NULL,	'N/A',	'096 253 1214',	'096 253 1214',	'M',	'/ហេងឡាយ-2f3d44f2-548a-4919-a935-ac678ec80090.jpg',	'សង្គាត់បឹងកក់2 ខណ្ឌ ទួលគក',	NULL,	'SDF Round 3',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-04 21:09:24',	'2023-04-04 14:32:08',	NULL,	NULL),
(66,	1,	'Pon Teb',	'ប៉ុន ទេព',	'2001-09-05',	NULL,	NULL,	NULL,	'N/A',	'069 733 019',	'069 733 019',	'F',	'/Teb-fbae2ef5-836b-4be5-b596-849650814e02.jpg',	'សង្គាត់ ទឹកថ្លា ខណ្ឌ សែនសុខ',	NULL,	'SDF Round3',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-04 21:12:24',	'2023-04-04 14:31:29',	NULL,	NULL),
(67,	8,	'Laau Rani',	'ឡោ រ៉ានី',	'1992-03-09',	NULL,	NULL,	NULL,	'N/A',	'092 603 008',	'092 603 008',	'F',	NULL,	'ផ្ទះលេខ 182CE1 ផ្លូវ294 ភូមិ 6 សង្គាត់ បឹងកេងកង1 ខណ្ឌចំការមន',	NULL,	'SDF Round3',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-04 21:15:06',	'2023-02-04 21:15:06',	NULL,	NULL),
(68,	1,	'Leng Keo',	'ឡេង កែវ',	'1985-04-23',	NULL,	NULL,	NULL,	'N/A',	'081 291 797',	'081 291 797',	'F',	'/ឡេង កែវ-36ec4992-0def-4de5-9390-728c3b05ee56.jpg',	'ផ្លូវ 52​ ភូមិ ចិនដាំម្លូរ សង្គាត់ វាំងចាស់ ខណ្ឌ ឧដុង្គ',	NULL,	'SDF Round 3',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-04 21:18:00',	'2023-04-04 14:30:14',	NULL,	NULL),
(69,	8,	'Vann Sophors',	'វ៉ាន់ សុភ័ស្ហ',	'1996-02-02',	NULL,	NULL,	NULL,	'N/A',	'093 989 375',	'093 989 375',	'F',	NULL,	'ផ្ទះលេខ​54B ផ្លូវ18B ភូមិ ទ្រុងមា​ន់ សង្គាត់ ទឹកថ្លា ខណ្ឌ សែនសុខ',	NULL,	'SDF Round 3',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-04 21:21:11',	'2023-02-04 21:21:11',	NULL,	NULL),
(70,	1,	'Seng Toch',	'សេង តូច',	'1987-01-08',	NULL,	NULL,	NULL,	'N/A',	'016 556 897/',	'016 556 897',	'F',	'/សេង តូច-513ede6a-ea2d-4fe0-a583-3b6dacf0254d.jpg',	'ផ្ទះលេខ 86​ផ្លូវ 316​សង្គាត់ ទួលស្វាយព្រៃ 1 ខណ្ឌ ចំការមន',	NULL,	'SDF Round3',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-04 21:24:31',	'2023-04-04 14:27:31',	NULL,	NULL),
(71,	1,	'Sann Vutha',	'សាន់ វុត្ថា',	'1981-10-05',	NULL,	NULL,	NULL,	'N/A',	'011 951 489/',	'011 951 489',	'F',	NULL,	'ផ្ទះលេខ 46 ផ្លូវលេខ 95 សង្គាត់​ បឹងកេងកង3 ខណ្ឌ ចំការមន',	NULL,	'SDF Round3',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-04 21:38:49',	'2023-02-04 21:38:49',	NULL,	NULL),
(72,	1,	'Pen Dara',	'ប៉ែន តារ៉ា',	'1995-07-07',	NULL,	NULL,	NULL,	'N/A',	'089 286 478/',	'089 286 478',	'F',	'/តារ៉ា-68627ac9-7e17-4f56-9585-7640e893f1ba.jpg',	'ភូមិ សន្សំកុសក1 សង្គាត់ បឹងទំពុន ខណ្ឌ មានជ័យ',	NULL,	'SDF Round3',	NULL,	NULL,	1,	'approved',	'student',	'2023-02-04 21:43:30',	'2023-04-04 14:26:32',	NULL,	NULL),
(73,	7,	'Sreyet hel',	'ហេល ស្រីអិត',	'1992-06-16',	'sreyeth.hel@gmail.com',	NULL,	NULL,	'dev01',	'078315893',	'0973097060',	'F',	'/2022-03-30 13.04.05-ebc53ef9-d3c6-4946-b5f8-7451c8a09314.jpg',	'បុរីពិភពថ្មី កាកបាទក្រហមកម្ពុជា (ផ្លូវ២៧១) ផ្ទះលេខ០២ ផ្លូវ០២ សង្កាត់ទឹកល្អក់៣ ខណ្ឌទួលគោក។',	'Borey Piphop Thmey, Cambodian Red Cross (Blvd 271) No. 02, Street 02, Toeuk Laak 3, Khan Tuol Kok.',	'For developer Test',	'G-Manager',	'Phsar Tech',	1,	'approved',	'student',	'2023-05-05 11:20:20',	'2023-12-15 17:57:31',	NULL,	NULL),
(74,	1,	'Jayce',	'Jayce',	NULL,	'HjtbDa.qmjbmcc@rightbliss.beauty',	NULL,	NULL,	NULL,	'062-357-73-57',	'062-357-73-57',	'M',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	'approved',	'student',	'2024-02-12 14:31:53',	'2024-02-12 14:31:53',	NULL,	NULL),
(75,	1,	'Dev',	'Dev',	NULL,	'dev@gmail.com',	'$2y$10$VcKuLjIekqgWulARQ4dcneFer1.hNY5.zLctceOJCvG69/p/X72pe',	NULL,	NULL,	'012345678',	'012345678',	'M',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	'rejected',	'student',	'2024-02-12 14:51:39',	'2024-02-12 14:52:03',	NULL,	NULL),
(76,	1,	'Development',	'Development',	NULL,	'development@gmail.com',	'$2y$10$z5qCunoKvAMeV7Pa9Ausu.H4J8S/zORQwo7F9Q95YnwMz7wd1ROmK',	NULL,	NULL,	'012345679',	'012345679',	'M',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	2,	'approved',	'student',	'2024-02-12 14:59:13',	'2024-02-12 15:00:22',	NULL,	NULL),
(77,	1,	'NqKEapDfcs',	'NqKEapDfcs',	NULL,	'rukinapingitz@outlook.com',	'$2y$10$AOXo5pWLhSp4R44zFuloQenqksksLjMRe5OlKLOVXcxsBGwx56lXO',	NULL,	NULL,	'9351970962',	'9351970962',	'M',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	'pending',	'student',	'2024-02-14 21:41:16',	'2024-02-14 21:41:24',	NULL,	NULL),
(78,	1,	'NqKEapDfcs',	'NqKEapDfcs',	NULL,	'rukinapingitz@outlook.com',	'$2y$10$/NcZOqmTHYtpCR5Pcu2MNueJcJi/Sd7uIm26f6C8agT2hmgAMmoFq',	NULL,	NULL,	'9351970962',	'9351970962',	'M',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	'pending',	'student',	'2024-02-14 21:41:17',	'2024-02-14 21:41:17',	NULL,	NULL),
(79,	1,	'Landon',	'Landon',	NULL,	'coFIQh.bbcpthq@rushlight.cfd',	'$2y$10$Nc8VNx/slQKz9YV.4vGRTebndL3RzKV7Dh59w1bZUmmdFmESX4joa',	NULL,	NULL,	'785-025-86-55',	'785-025-86-55',	'M',	NULL,	NULL,	NULL,	NULL,	NULL,	NULL,	1,	'pending',	'student',	'2024-02-16 05:22:57',	'2024-02-16 05:22:57',	NULL,	NULL);

DROP TABLE IF EXISTS `student_classes`;
CREATE TABLE `student_classes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `student_classes` (`id`, `student_id`, `class_id`, `created_at`, `updated_at`) VALUES
(1,	72,	3,	'2023-02-06 15:27:04',	'2023-02-06 15:27:04'),
(2,	71,	3,	'2023-02-06 15:27:11',	'2023-02-06 15:27:11');

DROP TABLE IF EXISTS `student_groups`;
CREATE TABLE `student_groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `student_groups` (`id`, `student_id`, `group_id`, `created_at`, `updated_at`) VALUES
(4,	71,	4,	'2023-05-04 20:29:17',	'2023-05-04 20:29:17');

DROP TABLE IF EXISTS `student_intern_places`;
CREATE TABLE `student_intern_places` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `internship_place_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `start_date` date NOT NULL,
  `is_intern_pass` tinyint(4) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `student_intern_places` (`id`, `student_id`, `internship_place_id`, `class_id`, `start_date`, `is_intern_pass`, `created_at`, `updated_at`) VALUES
(1,	71,	1,	3,	'2023-02-04',	1,	'2023-05-04 20:05:37',	'2023-05-04 20:13:17');

DROP TABLE IF EXISTS `student_lesson_scores`;
CREATE TABLE `student_lesson_scores` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `class_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `lesson_id` int(11) NOT NULL,
  `exam_answer_sheet_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `student_scores`;
CREATE TABLE `student_scores` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `class_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `total_score` double(8,2) DEFAULT NULL,
  `ranking` int(11) DEFAULT NULL,
  `pass_status` tinyint(4) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `student_scores` (`id`, `class_id`, `student_id`, `total_score`, `ranking`, `pass_status`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1,	3,	72,	71.67,	1,	1,	'2023-05-05 12:23:42',	'2023-05-05 12:23:42',	NULL),
(2,	3,	71,	69.33,	2,	1,	'2023-05-05 12:24:24',	'2023-05-05 12:24:24',	NULL);

DROP TABLE IF EXISTS `study_notes`;
CREATE TABLE `study_notes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `class_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `noted_date` date NOT NULL,
  `status` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `study_scores`;
CREATE TABLE `study_scores` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `generic_score` double(8,2) NOT NULL,
  `functional_score` double(8,2) NOT NULL,
  `competency` double DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `study_scores` (`id`, `generic_score`, `functional_score`, `competency`, `status`, `user_id`, `created_at`, `updated_at`) VALUES
(1,	30.00,	50.00,	20,	1,	0,	'2023-01-22 13:47:25',	'2023-01-23 19:44:42');

DROP TABLE IF EXISTS `trainers`;
CREATE TABLE `trainers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `profile` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `experience` double(8,2) NOT NULL,
  `skill` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `work` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) NOT NULL,
  `popular` tinyint(4) NOT NULL DEFAULT 0,
  `certified` tinyint(4) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `trainers` (`id`, `name`, `profile`, `experience`, `skill`, `work`, `position`, `status`, `popular`, `certified`, `created_at`, `updated_at`) VALUES
(1,	'Eang Vannak',	'/5i4yp81625211673889Vannak-01-bb79d3cc-a564-4423-a4e9-8c9fc17d0fe0.jpg',	14.00,	'Hairdressing',	'ASK Cambodia Trainer',	'trainer',	1,	1,	1,	'2023-04-25 07:32:57',	'2024-02-15 11:09:47'),
(2,	'Outh Bunthoeun Stevens',	'/p-3-144e5938-4749-49fa-9223-4952fcc910bd.jpg',	30.00,	'Hair Artist',	'L.I.C.E Trainer',	'professional',	1,	1,	1,	'2023-04-27 01:58:26',	'2024-02-15 10:05:31'),
(3,	'Wiwat Kasemamorn',	'/p-2-090276ea-0b80-447c-b422-294079eb28fb.png',	20.00,	'Artistic Director',	'Henkel Thailand',	'professional',	1,	1,	1,	'2023-04-27 01:59:11',	'2024-02-15 11:09:34'),
(4,	'La Vibol',	'/p-1-e7589077-0f00-49f8-87bd-88c98d72e1dd.jpg',	18.00,	'Management  &  Leadership',	'Co-Founder',	'professional',	1,	1,	1,	'2023-04-27 02:00:01',	'2024-02-15 11:09:25'),
(5,	'Puy (Serey Monita)',	'/t-2-d7293248-b68e-4380-b1f2-bb5ce4c4bcb7.jpg',	10.00,	'Hairdressing',	'ASK Cambodia Trainer',	'trainer',	1,	1,	1,	'2023-04-27 02:01:19',	'2024-02-15 11:09:15'),
(6,	'Ra Punlork (Sinky)',	'/t-3-e2d6e327-7e83-4579-8550-2421e39dbdf5.jpg',	13.00,	'Hairdressing',	'ASK Cambodia Trainer',	'trainer',	1,	1,	1,	'2023-04-27 02:01:51',	'2024-02-15 11:09:05'),
(7,	'Kin Nim',	'/IMG_9375-44731665-6ffe-439b-b455-8e7f530267d7.JPG',	15.00,	'Hair Artist',	'Trainer',	'trainer',	1,	1,	1,	'2023-05-18 20:46:38',	'2024-02-15 11:08:48'),
(8,	'Meas Dore',	'/Meas Dore-902a1dee-b7ea-45a2-a25c-669c074dea32.JPG',	9.00,	'Cold Perm',	'Trainer',	'trainer',	1,	1,	1,	'2023-05-18 20:53:17',	'2024-02-15 11:18:44'),
(9,	'Pen Dara',	'/Pen Dara-be4043a5-5936-4d64-b692-2a4ccc18ebfb.jpg',	10.00,	'Hair Artist',	'Trainer',	'trainer',	2,	0,	0,	'2023-05-18 20:54:46',	'2024-02-15 10:05:15'),
(10,	'Thet Piseth',	'/b Pvo-fbc1cf53-3959-474b-9c94-95c9978fd107.jpg',	12.00,	'Hair Artist',	'Trainer',	'trainer',	2,	0,	0,	'2023-05-18 21:06:29',	'2024-02-15 10:05:09'),
(11,	'Ly Sopois',	NULL,	5.00,	'Hair Artist',	'Trainer',	'trainer',	2,	1,	0,	'2023-05-18 21:13:59',	'2024-02-15 10:05:55'),
(12,	'Chen Thy',	'/IMG_1916-23005709-5f80-4d3e-8a82-41ed404b4686.png',	10.00,	'Hair Cutwomen',	'Trainer',	'trainer',	1,	1,	1,	'2024-02-15 11:17:18',	'2024-02-15 11:17:18');

DROP TABLE IF EXISTS `training_videoes`;
CREATE TABLE `training_videoes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `video` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `video_id` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cover` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category_id` int(10) unsigned NOT NULL,
  `status` tinyint(4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `training_videoes` (`id`, `name`, `video`, `video_id`, `cover`, `description`, `category_id`, `status`, `created_at`, `updated_at`) VALUES
(1,	'HAIR TREATEMENT - TREATMENT WITH FIBERFORCE',	'https://www.youtube.com/embed/moNOf8UvWLE',	'moNOf8UvWLE',	'/h3-862f1872-a196-41dd-8fe8-5eebe7f50f4c.jpg',	NULL,	5,	1,	'2023-04-25 07:44:17',	'2023-04-27 12:44:43'),
(2,	'HAIR COLORING - BASIC COLORING',	'<iframe width=\"560\" height=\"315\" src=\"https://www.youtube.com/embed/WWoQXggVPCQ\" title=\"YouTube video player\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" allowfullscreen></iframe>',	'WWoQXggVPCQ',	'/5rebdp1625717952982Thunmbnail Video 2-1525e475-ba94-498d-8f78-edbe9e2a4aac.png',	NULL,	5,	1,	'2023-04-25 07:45:27',	'2023-04-27 12:44:29'),
(3,	'កម្មវិធីគម្រប់ខួប 3ឆ្នាំ នៃការបង្កើត សាលាបណ្ដុះបណ្ដាលជំនាញសក់ ក្រចក និងសម្ជស្ស លីសេ(LICE)',	'<iframe width=\"560\" height=\"315\" src=\"https://www.youtube.com/embed/gyarB6Zrgpw\" title=\"YouTube video player\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" allowfullscreen></iframe>',	'gyarB6Zrgpw',	'/lwwfqn1625719089193Thunmbnail Video 3-6b9f97a2-4b41-48d9-a37c-7f45b2f3d58b.png',	NULL,	5,	1,	'2023-04-27 03:39:55',	'2023-04-27 12:44:17'),
(4,	'HAIR COLORING - BALAYAGE TECHNIQUE',	'https://youtu.be/qt6NuhBqm5g',	'qt6NuhBqm5g',	'/h1-45c8b28e-0cb2-4b6d-875c-888dda1b4e1c.jpg',	NULL,	5,	1,	'2023-04-27 12:45:57',	'2023-04-27 12:45:57'),
(5,	'យុទ្ធសាស្ត្រ រចនាបទអ៊ុតរួញត្រជាក់',	'file:///D:/2.%20LICE%20-%20School/1.%20INTENSIVE%20TRAINING/2.1.%20ASK%20Academy/2023%20ASK%20Academy/1.Jan-ASK/1.%20Dore%20(11-12)/Video%20Final.mp4',	'file:///D:/2.%20LICE%20-%20School/1.%20INTENSIVE%20TRAINING/2.1.%20ASK%20Academy/2023%20ASK%20Academy/1.Jan-ASK/1.%20Dore%20(11-12)/Video%20Final.mp4',	'/Untitled-1-02-f93ba186-2cef-4ce2-8bca-acfec42745eb.jpg',	NULL,	6,	1,	'2024-02-13 09:35:36',	'2024-02-13 09:35:36'),
(6,	'Essential Color and Styling',	'file:///D:/2.%20LICE%20-%20School/1.%20INTENSIVE%20TRAINING/2.1.%20ASK%20Academy/2023%20ASK%20Academy/2.Feb-ASK/1.%20Kim%20Nin%20(8-9)/2.Video/ASK-Nim.mp4',	'file:///D:/2.%20LICE%20-%20School/1.%20INTENSIVE%20TRAINING/2.1.%20ASK%20Academy/2023%20ASK%20Academy/2.Feb-ASK/1.%20Kim%20Nin%20(8-9)/2.Video/ASK-Nim.mp4',	'/Untitled-1-04-acfd661e-43ac-4e3b-83b7-bc9351b221c3.jpg',	NULL,	7,	1,	'2024-02-15 08:18:27',	'2024-02-15 08:18:27'),
(7,	'វិធីសាស្រ្តកាត់សក់ និង អ៊ុតរួញបែបឌីជីថល',	'file:///D:/2.%20LICE%20-%20School/1.%20INTENSIVE%20TRAINING/2.1.%20ASK%20Academy/2023%20ASK%20Academy/3.March-ASK/1.Neak%20(8-9)/Final.mp4',	'file:///D:/2.%20LICE%20-%20School/1.%20INTENSIVE%20TRAINING/2.1.%20ASK%20Academy/2023%20ASK%20Academy/3.March-ASK/1.Neak%20(8-9)/Final.mp4',	'/ASK-Neak -01-7cd3a121-cb64-429c-b53d-0466cb703055.jpg',	NULL,	6,	1,	'2024-02-15 08:27:49',	'2024-02-15 08:27:49');

DROP TABLE IF EXISTS `training_video_categories`;
CREATE TABLE `training_video_categories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cover` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `training_video_categories` (`id`, `name`, `cover`, `status`, `created_at`, `updated_at`) VALUES
(1,	'HAIR DRESSING',	NULL,	2,	'2023-04-25 07:42:01',	'2023-04-27 02:47:46'),
(2,	'FOR NAILDRESSER',	'/nail2-86ab0240-e2f8-4884-b00b-002b9f3881a9.png',	2,	'2023-04-27 02:47:02',	'2023-04-27 03:27:43'),
(3,	'FOR HAIRDRESSER',	'/hair1-7e162f25-584c-46c0-b305-40d8342a72b4.png',	2,	'2023-04-27 02:47:23',	'2023-04-27 03:27:52'),
(4,	'INTERVIEW WITH TRAINER',	'/interview-e0f5398d-b834-494c-af74-9894791ce76d.png',	2,	'2023-04-27 02:47:55',	'2023-04-27 03:27:56'),
(5,	'HAIR DRESSING',	'/photo_2020-11-20_12-09-09-1060c3ce-803b-4bd4-9895-112bb971eae4.jpg',	1,	'2023-04-27 02:48:14',	'2023-04-27 03:41:41'),
(6,	'អ៊ុតសក់រួញ',	'/DSC04311-bd75e58c-d43e-401e-b7bb-0f70a9a3260d.jpg',	1,	'2024-02-13 09:29:34',	'2024-02-15 08:19:12'),
(7,	'Hair Styling',	'/Untitled-1-04-acfd661e-43ac-4e3b-83b7-bc9351b221c3.jpg',	1,	'2024-02-15 08:17:11',	'2024-02-15 08:17:11');

DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `branch_id` int(11) NOT NULL,
  `username` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(125) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(125) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gender` varchar(125) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `profile` varchar(125) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` int(11) NOT NULL,
  `role` varchar(125) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `noted` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `users` (`id`, `branch_id`, `username`, `email`, `phone`, `gender`, `password`, `profile`, `status`, `role`, `noted`, `type`, `remember_token`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1,	0,	'Super Admin',	'super.admin@gmail.com',	'015232269',	'male',	'$2y$10$tycrBsd2jiZt7TXtJVeaBeXaatvSpzB1SLNgYKeltmgDsiB75SAu6',	NULL,	1,	'super_admin',	NULL,	NULL,	'uAFg3eE0fryTXiy6Qy16IQowefGuePBJSx0TGMllYHxz6swFkV6Hm2ypDbkr',	'2022-12-27 08:41:03',	'2022-12-27 08:41:03',	NULL),
(2,	0,	'Admin',	'admin@gmail.com',	'0123456789',	'male',	'$2y$10$Z2vcuGdJQsCJSrYcmTR8M.3wbXg/IsNDKsrAVxqTT85L.6GhmhR3S',	NULL,	1,	'admin',	NULL,	NULL,	'PvUdrJo5TYLDSi6bJJIi0LtImSgF4jLmmyziiWxX8EYRXADJnOHilIUSBEvE',	'2022-12-27 08:41:03',	'2022-12-27 08:41:03',	NULL),
(3,	2,	'Ly Hean',	'lyhean@gmail.com',	'0978564567',	NULL,	'$2y$10$gQ0OgPaE5ya/eR4GGZiDl.JI8aKjYBxBWCz9mieInNSqeWx9uVmy.',	NULL,	1,	NULL,	NULL,	NULL,	'IEZVjWVoNmidp5J8BkCWAiFwpe9dIiXkXd3AlhLG',	'2023-01-09 15:14:56',	'2023-12-16 10:23:32',	NULL),
(4,	0,	'Chhorn Soktheng',	'myhero2018@gmail.com',	NULL,	NULL,	'$2y$10$D52wpxd0JohBh.n.EZdgw.OqSQyz/vjucIFONu4rPkOSex0l.D5WS',	NULL,	1,	'user',	NULL,	NULL,	NULL,	'2023-04-30 16:06:29',	'2023-04-30 16:06:29',	NULL),
(5,	2,	'Sreyet 1',	'sreyeth.hel@gmail.com',	'078315893',	NULL,	'$2y$10$Mov1rg7hplyuHblJjZax5eQ8SoOAGuAcpbGBjIfuii.9h7wi6xVpm',	'/2022-03-25 08.53.45-297520eb-aa3c-498f-b9ad-9eb357e6e002.jpg',	1,	'teacher',	NULL,	NULL,	'OhlYyq4FukZ2xxNNDLswm3UO6OMU3w3H8z9qH3Vi16PeknkVIRKvfnYi6b64',	'2023-05-04 14:34:28',	'2023-12-16 10:38:47',	NULL),
(6,	2,	'Dev TRAINER PORTA',	'h.sreyet@gmail.com',	'099899927',	NULL,	'$2y$10$0Tu2uF2YJIRKtUidAcTYXORBh/MzWFpuN8dJWSq8rV/kvcma9K806',	'/2022-03-30 13.04.05-76d5745e-4e6c-47f0-8c47-b82ef29e3df6.jpg',	1,	NULL,	NULL,	NULL,	'IEZVjWVoNmidp5J8BkCWAiFwpe9dIiXkXd3AlhLG',	'2023-05-04 14:41:02',	'2023-12-16 10:27:16',	NULL),
(7,	0,	'John Json',	'Johnjson@gmail.com',	'015569812',	NULL,	'$2y$10$9WqZlX8kSCvmLquVGoMnaO5TfKjhCMpvJ99aMGb1XRPGscyTw8ES.',	NULL,	1,	'teacher',	NULL,	NULL,	'z6jTvlOSnqnjxMe2tTqRRYCZUEh8xhPMJznIBBOhGNpJ1BVk9oCBLb8AEzCL',	'2023-05-04 15:09:02',	'2023-05-04 15:15:27',	NULL),
(8,	2,	'Len Nak',	'naklen5525@gmail.com',	'0884895525',	NULL,	'$2y$10$gs3l1Rzz80pWCrzDYAG2teXrXqLoUFe6rmDb79ret5Ka9TX1ugj1a',	NULL,	2,	'admin',	NULL,	NULL,	'gOrgqvx8KozFhggwyPsVvSRV0ZRm9WVShjJLMjNOjePHzFHPPEwuMVdGJppz',	'2023-05-18 21:09:14',	'2023-12-12 11:14:34',	NULL),
(9,	0,	'Heng Chanroth',	'chanroth0709@gmail.com',	NULL,	NULL,	'$2y$10$CyQY2bar3pXe4XhwvaqR8O30QJWKYh1pTKbkF4obSwl0yor7680Ma',	NULL,	1,	'user',	NULL,	NULL,	NULL,	'2023-10-18 15:00:36',	'2023-10-18 15:00:36',	NULL),
(10,	0,	'Deth Chan Kroesna',	'chankroesnadeth4@gmail.com',	NULL,	NULL,	'$2y$10$eBdVC5h.02Dq4nQ/nFBBYe9xFhwSqTELU1KCYgJFIj0b1r1iTBE/G',	NULL,	1,	'user',	NULL,	NULL,	NULL,	'2023-10-31 15:55:36',	'2023-10-31 15:55:36',	NULL),
(11,	3,	'Sovannareach Van',	'reachvan83@gmail.com',	'012345678',	NULL,	'$2y$10$TsB40Ppm.8bZnIuHb1GvLOmpeG0wBjBYMkBAiupYGy14VFkQIoeTq',	NULL,	1,	'admin',	NULL,	NULL,	'yRBiNWef5oRwLCuL3th0BIWUjmUnCDZHACAWiTkn',	'2023-11-13 15:11:14',	'2023-11-20 07:00:59',	NULL),
(12,	2,	'Dev',	'dev123@gmail.com',	'0978564566',	NULL,	'$2y$10$j6Gf3U.iGKzN7emKqLQEaO635XjnevATpc9nTAgJxT8tbWTZVZP12',	NULL,	1,	'admin',	NULL,	NULL,	'KQyDnFbRusfq0eoDLJNeO4rV9oug0TXYo0CWQPAZ',	'2023-12-16 20:24:53',	'2023-12-16 20:24:53',	NULL),
(13,	2,	'Puthy',	'puthyung83@gmail.com',	'011 789 907',	NULL,	'$2y$10$mqOphxqY3vVFCCOdjMTWI..23M/jaHsX3.ID97QM8mldhJhtw5Fj2',	NULL,	1,	'admin',	NULL,	NULL,	'0NS2FaRdFbDwgUThzyiXxt09l8bhcUdCef1acedO',	'2023-12-18 07:09:38',	'2023-12-18 07:09:38',	NULL),
(14,	0,	'Christopher',	'jspaYK.hqthcmj@maxeza.click',	'731-290-63-93',	NULL,	'$2y$10$9RxnUp/XHqZtZw0oHAkj5.vdfa3v9KaF/zTtmDlnZ9j6f5G2IgaVm',	NULL,	1,	'user',	NULL,	NULL,	NULL,	'2023-12-30 18:44:38',	'2023-12-30 18:44:38',	NULL),
(15,	2,	'Puthy',	'uthyung83@gmail.com',	'011789907',	NULL,	'$2y$10$u2Q4n.k/xkFJWqR/dPaikOdFNokNhMQS/BWCOzqntGygoDDPnQJHK',	NULL,	2,	'admin',	NULL,	NULL,	'A8Q4jOp40yRpBSZUUwCobFWxlQSslmQvtZqgJe5v',	'2024-01-02 16:46:14',	'2024-01-02 16:47:13',	NULL),
(16,	0,	'Vibol La',	'vibol012@gmail.com',	'010807000',	NULL,	'$2y$10$bUlkfh5RTuuYQDNI5Tg5eeQNxpOogf37jppJfz3T/1nrs5l4.Cj4y',	NULL,	1,	'user',	NULL,	NULL,	NULL,	'2024-01-06 15:10:53',	'2024-01-06 15:10:53',	NULL),
(17,	2,	'sreyleak.support',	'stockplus.official@gmail.com',	'086 653 888',	NULL,	'$2y$10$K5Ej1qwUbFX3.E0.2U3se.zqbpjZPnIoUyImByEUfLXhVDq.UEaLe',	NULL,	1,	'admin',	NULL,	NULL,	'D54ZJQdu1zz9VBeKGOFOZ4krJSnsLySgbQOz4alC',	'2024-01-15 10:44:16',	'2024-01-15 10:44:16',	NULL),
(18,	2,	'Sinath',	'sumsinath168@gmail.com',	'015871067',	NULL,	'$2y$10$rEOT6iehiDzjhJkA5mqdq.iuCiehJ491LCrMF/NvLL1WI1/gMCYmm',	NULL,	1,	'admin',	NULL,	NULL,	'unPCme3Li3I4ddLmRfJ8mcmBfGVfLGzgEXkUTA3H',	'2024-01-15 11:23:55',	'2024-01-15 11:23:55',	NULL),
(19,	0,	'Marcel',	'dSpAMT.bwhhhjt@kerfuffle.asia',	'372-008-92-76',	NULL,	'$2y$10$7GShRlPwsnGf50vIiIMf7eUOSePOqeN7Tb039smwCFjqVt3U6OZXu',	NULL,	1,	'user',	NULL,	NULL,	NULL,	'2024-01-17 23:04:32',	'2024-01-17 23:04:32',	NULL),
(20,	0,	'Khaza',	'bJMCCd.hpwmhbh@spectrail.world',	'054-952-55-86',	NULL,	'$2y$10$.lhCgl3rM9l8qP1yYJ3mSe9aciYTknEQyWZ8zNYOZnQ1qYthEnjS.',	NULL,	1,	'user',	NULL,	NULL,	NULL,	'2024-01-21 03:30:57',	'2024-01-21 03:30:57',	NULL),
(21,	0,	'Cillian',	'YdTDaP.qqhbtdhj@anaphora.team',	'081-133-35-17',	NULL,	'$2y$10$LFNcMIzirTqwQ40I2DgF2ubK9Iv8IO//TbQG13fXUunUbGKfKlEei',	NULL,	1,	'user',	NULL,	NULL,	NULL,	'2024-01-22 00:45:28',	'2024-01-22 00:45:28',	NULL),
(22,	0,	'Rachel',	'LpNMWo.tqpptww@zetetic.sbs',	'708-970-25-42',	NULL,	'$2y$10$a9UJ1vjPLiTpeNd.Skj.V..tBXkkf8QMJQj3r257ys4OCH5HzYwB6',	NULL,	1,	'user',	NULL,	NULL,	NULL,	'2024-01-23 23:56:22',	'2024-01-23 23:56:22',	NULL),
(23,	0,	'Miley',	'MwMRNd.bjqmqwj@balneary.biz',	'491-551-62-22',	NULL,	'$2y$10$ifEV0TijCbNqVG.GnSvf2OAMGAQq1SlAl.19HzesikU4420HN9i3C',	NULL,	1,	'user',	NULL,	NULL,	NULL,	'2024-01-28 02:48:48',	'2024-01-28 02:48:48',	NULL),
(24,	0,	'Dara',	'Phindara25@gmail.com',	'070456810',	NULL,	'$2y$10$D1cVY31tXya3esWTDeuBHuZXzT.o1WFThW7bZCLgfxC/F8qif6ypm',	NULL,	1,	'user',	NULL,	NULL,	'vfmVomtal9odcGiNi2vXnsPDVcZwh6evEstol7b0SlWkU2g2bdm7K8wWCcoD',	'2024-01-30 11:01:47',	'2024-01-30 11:01:47',	NULL),
(25,	0,	'Phalla Bee',	'phalla@gmail.com',	'093212541',	NULL,	'$2y$10$RIkUFg3KbUyF.6cX2.Lrs.7Cgl1SrmTQEU05EH8PrkutXt5F8/ZB2',	NULL,	1,	'user',	NULL,	NULL,	NULL,	'2024-01-30 18:56:20',	'2024-01-30 18:56:20',	NULL),
(26,	0,	'Sotheavy Kim',	'sotheavy.kim04@gmail.com',	'0712896854',	NULL,	'$2y$10$2qgc4UV8Kduku6GEQUI3g.XGgkcA.zDBoowi8vAZY01UeUpWa5r7W',	NULL,	1,	'user',	NULL,	NULL,	NULL,	'2024-01-31 16:40:30',	'2024-01-31 16:40:30',	NULL),
(27,	0,	'Rylee',	'eAJBwf.hwpjpbq@chilgoza.buzz',	'287-223-53-48',	NULL,	'$2y$10$QrlyJl8WdF2562SndARh5egxw9J8qc00LkTv5K2GKCz.OjFWf4j.S',	NULL,	1,	'user',	NULL,	NULL,	NULL,	'2024-02-05 13:58:19',	'2024-02-08 16:15:54',	NULL),
(28,	0,	'hong',	'hong@gmail.com',	'099237862',	NULL,	'$2y$10$CfBgCF7c7fhneeEqg8TXieA9AJDSlssMwKo9sreuMb42Qt39w7LEG',	NULL,	1,	'user',	NULL,	NULL,	NULL,	'2024-02-08 16:17:56',	'2024-02-08 16:17:56',	NULL);

DROP TABLE IF EXISTS `user_feedbacks`;
CREATE TABLE `user_feedbacks` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `user_feedbacks` (`id`, `name`, `phone`, `message`, `created_at`, `updated_at`) VALUES
(1,	'Monroe',	'0660 225 94 49',	'Good day \r\n\r\nI wanted to reach out and let you know about our new dog harness. It\'s really easy to put on and take off - in just 2 seconds - and it\'s personalized for each dog. \r\nPlus, we offer a lifetime warranty so you can be sure your pet is always safe and stylish.\r\n\r\nWe\'ve had a lot of success with it so far and I think your dog would love it. \r\n\r\nGet yours today with 50% OFF: https://caredogbest.shop\r\n\r\nFREE Shipping - TODAY ONLY! \r\n\r\nThank You, \r\n\r\nMonroe',	'2023-05-31 17:52:37',	'2023-05-31 17:52:37'),
(2,	'Irvin',	'904-555-3296',	'Good day \r\n\r\nLooking to improve your posture and live a healthier life? Our Medico Postura™ Body Posture Corrector is here to help!\r\n\r\nExperience instant posture improvement with Medico Postura™. This easy-to-use device can be worn anywhere, anytime – at home, work, or even while you sleep.\r\n\r\nMade from lightweight, breathable fabric, it ensures comfort all day long.\r\n\r\nGrab it today at a fantastic 60% OFF: https://medicopostura.com\r\n\r\nPlus, enjoy FREE shipping for today only!\r\n\r\nDon\'t miss out on this amazing deal. Get yours now and start transforming your posture!\r\n\r\nEnjoy, \r\n\r\nIrvin',	'2023-06-17 15:27:44',	'2023-06-17 15:27:44'),
(3,	'Halina',	'06-59022840',	'Hi there \r\n \r\nIs your dog\'s nails getting too long? If you\'re tired of going to the vet or groomer to get them trimmed, why not try PawSafer™? \r\nWith PawSafer™, you can trim your dog\'s nails from the comfort of your own home, and it only takes a few minutes!\r\n\r\nPawSafer™ is the safest and most convenient way to trim your dog\'s nails, and it\'s very affordable. \r\n\r\nGet it while it\'s still 50% OFF + FREE Shipping\r\n\r\nBuy here: https://pawsafer.sale\r\n \r\nRegards, \r\n \r\nHalina',	'2023-06-28 10:53:00',	'2023-06-28 10:53:00'),
(4,	'Valentin',	'08404 33 79 35',	'New Multifunction Waterproof Backpack\r\n\r\nThe best ever SUPER Backpack: Drop-proof/Scratch-resistant/USB Charging/Large capacity storage\r\n\r\n50% OFF for the next 24 Hours ONLY + FREE Worldwide Shipping for a LIMITED time\r\n\r\nBuy now: https://thebackpack.co\r\n\r\nThank You, \r\n\r\nValentin',	'2023-07-04 00:43:44',	'2023-07-04 00:43:44'),
(5,	'Allen',	'0365 8634447',	'Hi there \r\n \r\nDefrost frozen foods in minutes safely and naturally with our THAW KING™. \r\n\r\n50% OFF for the next 24 Hours ONLY + FREE Worldwide Shipping for a LIMITED \r\n\r\nBuy now: https://thawking.co\r\n \r\nThank You, \r\n \r\nAllen',	'2023-07-07 05:32:14',	'2023-07-07 05:32:14'),
(6,	'Sherrie',	'01.51.17.10.49',	'Good Morning,\r\n\r\nIf you are one of the sufferers of the common problems nails have, then you are in luck! Our Toenail Clippers is here to help. It has a specially designed clip that can help those with troubles with winding nails, hard nails, two nails, nail cracks, deep nails, and thickened nails.\r\n\r\nWe are confident that our Toenail Clippers will provide you with the results you are looking for.\r\n\r\nGet yours today with 60% OFF: https://podiatristusa.sale\r\n\r\nMany Thanks,\r\n\r\nSherrie',	'2023-07-15 00:41:14',	'2023-07-15 00:41:14'),
(7,	'Robertalusy',	'81387614771',	'Hi, roeddwn i eisiau gwybod eich pris.',	'2023-07-19 20:44:09',	'2023-07-19 20:44:09'),
(8,	'Julissa',	'078 6106 0143',	'Hello \r\n\r\nThe New Powerful LED Flashlight is The Perfect Flashlight For Any Situation!\r\n\r\nThe 3,000 Lumens & Adjustable Zoom gives you the wide field of view and brightness other flashlights don’t have.\r\n\r\n50% OFF + Free Shipping!  Get it Now: https://linterna.cc\r\n\r\nThe Best, \r\n\r\nJulissa',	'2023-07-20 04:46:28',	'2023-07-20 04:46:28'),
(9,	'Tamasa_buKl',	'83411913431',	'Bluehost: It is one of the most popular hosting providers, recommended by WordPress. They offer a user-friendly interface, excellent uptime, and 24/7 customer support. \r\nHostGator: HostGator is known for its affordable plans and reliable performance. They offer unlimited storage and bandwidth, a variety of hosting options, and excellent customer support. [url=http://webward.pw/]http://webward.pw/[/url].',	'2023-07-26 05:37:14',	'2023-07-26 05:37:14'),
(10,	'Winifred',	'078 535 39 95',	'World\'s Best Neck Massager Get it Now 50% OFF + Free Shipping!\r\n\r\nWellness Enthusiasts! There has never been a better time to take care of your neck pain! \r\nOur clinical-grade TENS technology will ensure you have neck relief in as little as 20 minutes.\r\n\r\nGet Yours: https://hineck.co\r\n\r\nThanks and Best Regards,\r\n\r\nWinifred\r\nLICE',	'2023-07-27 14:53:00',	'2023-07-27 14:53:00'),
(11,	'Johnie',	'078 6836 7552',	'Get The Worlds Greatest Magic Sand Free Beach Mat!\r\n\r\nWatch sand, dirt & dust disappear right before your eyes! It\'s perfect for beach, picnic, camping or hiking.\r\n\r\nAct Now And Receive A Special Discount For Our Magic Mat!\r\n\r\nGet Yours Here:  https://magicmats.co\r\n\r\nAll the best, \r\n \r\nJohnie',	'2023-07-31 14:04:41',	'2023-07-31 14:04:41'),
(12,	'Robertalusy',	'88982878378',	'Dia duit, theastaigh uaim do phraghas a fháil.',	'2023-08-07 20:00:08',	'2023-08-07 20:00:08'),
(13,	'Darryl',	'(71) 4888-5667',	'Hello there \r\n\r\nLooking to improve your posture and live a healthier life? Our Medico Postura™ Body Posture Corrector is here to help!\r\n\r\nExperience instant posture improvement with Medico Postura™. This easy-to-use device can be worn anywhere, anytime – at home, work, or even while you sleep.\r\n\r\nMade from lightweight, breathable fabric, it ensures comfort all day long.\r\n\r\nGrab it today at a fantastic 60% OFF: https://medicopostura.com\r\n\r\nPlus, enjoy FREE shipping for today only!\r\n\r\nDon\'t miss out on this amazing deal. Get yours now and start transforming your posture!\r\n\r\nKind Regards, \r\n\r\nDarryl',	'2023-08-09 15:20:44',	'2023-08-09 15:20:44'),
(14,	'Celsa',	'06-29779367',	'Morning, \r\n\r\nI hope this email finds you well. I wanted to let you know about our new BANGE backpacks and sling bags that just released.\r\n\r\nBange is perfect for students, professionals and travelers. The backpacks and sling bags feature a built-in USB charging port, making it easy to charge your devices on the go.  Also they are waterproof and anti-theft design, making it ideal for carrying your valuables.\r\n\r\nBoth bags are made of durable and high-quality materials, and are perfect for everyday use or travel.\r\n\r\nOrder yours now at 50% OFF with FREE Shipping: http://bangeshop.com\r\n\r\nAll the best,\r\n\r\nCelsa',	'2023-08-17 12:29:11',	'2023-08-17 12:29:11'),
(15,	'Raymonddop',	'87313349494',	'Good day! lice.asia \r\n \r\nDid you know that it is possible to send commercial offers totally legitimate way? We make available a new method of sending messages through feedback forms. Such feedback forms can be seen in many locations on the web. \r\nWhen such business proposals are sent, no personal data is used, and messages are securely sent to forms specifically designed to receive them. As Feedback Forms messages are considered important, they will not be marked as spam. \r\nYou can now take advantage of our service free of charge. \r\nWe can forward up to 50,000 messages to you. \r\n \r\nThe cost of sending one million messages is $59. \r\n \r\nThis message was automatically generated. \r\nPlease use the contact details below to get in touch with us. \r\n \r\nContact us. \r\nTelegram - https://t.me/FeedbackFormEU \r\nSkype  live:feedbackform2019 \r\nWhatsApp  +375259112693 \r\nWhatsApp  https://wa.me/+375259112693 \r\n \r\nWe only use chat for communication.',	'2023-08-23 17:52:58',	'2023-08-23 17:52:58'),
(16,	'Rafaeloveri',	'87479354784',	'Mfhfujfehfueh ifwjifjeighufijsdh uidfsjkdokwefuhgedjij idoweweureiurioweiidkjsdj iwjdsksosjfeihfiwskdoakd ijwdiwdowjfihefiwjdiwhfgue lice.asia',	'2023-08-26 00:34:15',	'2023-08-26 00:34:15'),
(17,	'puh',	'82538158529',	'Hi, this is Jenny. I am sending you my intimate photos as I promised. https://tinyurl.com/2ymlb4jc',	'2023-08-27 11:45:33',	'2023-08-27 11:45:33'),
(18,	'Jeromebag',	'85469622667',	'Get 3100 high quality backlinks for free with DA 50+ http://free-backlinks-5421.33115c.com/invite',	'2023-08-31 06:17:12',	'2023-08-31 06:17:12'),
(19,	'EugeneTus',	'81882513955',	'Make Your First $100,000 Forex Trading http://forex-earn-6461.elisou.com/exclusive',	'2023-09-01 03:57:36',	'2023-09-01 03:57:36'),
(20,	'Delia',	'Bxpzeotxc',	'Hey there,\r\n\r\nIf you are one of the sufferers of the common problems nails have, then you are in luck! Our Toenail Clippers is here to help. It has a specially designed clip that can help those with troubles with winding nails, hard nails, two nails, nail cracks, deep nails, and thickened nails.\r\n\r\nWe are confident that our Toenail Clippers will provide you with the results you are looking for.\r\n\r\nGet yours today with 60% OFF: https://podiatristusa.sale\r\n\r\nAll the best,\r\n\r\nDelia',	'2023-09-01 23:33:15',	'2023-09-01 23:33:15'),
(21,	'EugeneTus',	'82778362528',	'EARN $100000 PER WEEK OR MORE WITH FOREX http://earn-forex-4382.linebet9835.com/exclusive',	'2023-09-03 08:30:02',	'2023-09-03 08:30:02'),
(22,	'TimothyLak',	'87638139981',	'Exclusive indecent private unpublished photos of naked Kim Kardashian - 34 photos http://kim-31791.psilocybintech.com/page',	'2023-09-10 07:56:05',	'2023-09-10 07:56:05'),
(23,	'Robertalusy',	'82332177188',	'Sawubona, bengifuna ukwazi intengo yakho.',	'2023-09-13 08:44:54',	'2023-09-13 08:44:54'),
(24,	'Luciana',	'02.02.03.44.57',	'Get The Worlds Greatest Magic Sand Free Beach Mat!\r\n\r\nWatch sand, dirt & dust disappear right before your eyes! It\'s perfect for beach, picnic, camping or hiking.\r\n\r\nAct Now And Receive A Special Discount For Our Magic Mat!\r\n\r\nGet Yours Here:  https://magicmats.co\r\n\r\nBest, \r\n \r\nLuciana',	'2023-09-13 19:52:36',	'2023-09-13 19:52:36'),
(25,	'Wernerevoni',	'88361457111',	'Hello. \r\nYou registered with us exactly 364 days ago, but for some reason you never logged into your account again. \r\nYour account has already accumulated $24,365 - withdraw it urgently. Since tomorrow all inactive accounts will be deleted along with all the money earned. \r\nThere was no way we could contact you, so we had to contact you through the contact form of your website lice.asia the address of which you left when registering in our system. \r\nHere is the link to your account - http://your-payout-91281.sportebet44.com/page',	'2023-09-14 03:49:49',	'2023-09-14 03:49:49'),
(26,	'Philalusy',	'86948673136',	'Hi, ego volo scire vestri pretium.',	'2023-09-15 10:30:08',	'2023-09-15 10:30:08'),
(27,	'Josephrit',	'88224833634',	'Hey! lice.asia \r\n \r\nDid you know that it is possible to send business offer lawfully? We submit a new way of sending appeals through contact forms. You can find these feedback forms on numerous sites. \r\nWhen such appeals are sent, no personal information is utilized, and messages are delivered to forms specifically created to securely receive messages and appeals. As Feedback Forms messages are considered important, they will not be marked as spam. \r\nYou can now test out our service without having to pay. \r\nWe can transmit up to 50,000 messages in your behalf. \r\n \r\nThe cost of sending one million messages is $59. \r\n \r\nThis offer is automatically generated. \r\nPlease use the contact details below to get in touch with us. \r\n \r\nContact us. \r\nTelegram - https://t.me/FeedbackFormEU \r\nSkype  live:feedbackform2019 \r\nWhatsApp  +375259112693 \r\nWhatsApp  https://wa.me/+375259112693 \r\n \r\nWe only use chat for communication.',	'2023-09-20 02:40:04',	'2023-09-20 02:40:04'),
(28,	'Ashton',	'42-69-04-46',	'Morning \r\n\r\nI wanted to reach out and let you know about our new dog harness. It\'s really easy to put on and take off - in just 2 seconds - and it\'s personalized for each dog. \r\nPlus, we offer a lifetime warranty so you can be sure your pet is always safe and stylish.\r\n\r\nWe\'ve had a lot of success with it so far and I think your dog would love it. \r\n\r\nGet yours today with 50% OFF:  https://caredogbest.com\r\n\r\nFREE Shipping - TODAY ONLY! \r\n\r\nThe Best, \r\n\r\nAshton',	'2023-09-22 03:23:09',	'2023-09-22 03:23:09'),
(29,	'Dewey',	'06-25621952',	'Hi there \r\n \r\nIs your dog\'s nails getting too long? If you\'re tired of going to the vet or groomer to get them trimmed, why not try PawSafer™? \r\nWith PawSafer™, you can trim your dog\'s nails from the comfort of your own home, and it only takes a few minutes!\r\n\r\nPawSafer™ is the safest and most convenient way to trim your dog\'s nails, and it\'s very affordable. \r\n\r\nGet it while it\'s still 50% OFF + FREE Shipping\r\n\r\nBuy here: https://pawsafer.net\r\n \r\nThank You, \r\n \r\nDewey',	'2023-09-25 04:19:44',	'2023-09-25 04:19:44'),
(30,	'Mike Eddington',	'85536395466',	'Hello \r\n \r\nI have just checked  lice.asia for its SEO Trend and saw that your website could use an upgrade. \r\n \r\nWe will improve your ranks organically and safely, using only state of the art AI and whitehat methods, while providing monthly reports and outstanding support. \r\n \r\nMore info: \r\nhttps://www.digital-x-press.com/unbeatable-seo/ \r\n \r\n \r\nRegards \r\nMike Eddington\r\nDigital X SEO Experts',	'2023-09-27 17:50:54',	'2023-09-27 17:50:54'),
(31,	'Johan Dawson',	'88882924491',	'We possess a vast network of potential lenders and invite you to reach out if you seek funding for your existing or pre-existing project. Our investment spectrum spans $1M to $3B, featuring favorable mini-interest rates of 2.5% to 4% over a 10-year period, accompanied by a 2-year Grace period. \r\n \r\nFeel free to connect for more information. \r\n \r\nBest Regards \r\n \r\nJohan Dawson \r\nJohan.Dawson@inficza.com \r\nPortfolio Manager \r\nINFICZA \r\nhttp://www.inficza.com/',	'2023-09-30 00:11:11',	'2023-09-30 00:11:11'),
(32,	'RichardDrece',	'87185233629',	'ATTENTION! SEMI-PASSIVE EARNINGS OF EXACTLY $1000 PER DAY IN CRYPTOCURRENCY http://get-815662.apbet998.com/click',	'2023-09-30 03:09:23',	'2023-09-30 03:09:23'),
(33,	'Philalusy',	'84774873825',	'Salam, qiymətinizi bilmək istədim.',	'2023-10-02 16:00:27',	'2023-10-02 16:00:27'),
(34,	'Mike Jenkin',	'85275848449',	'Good Day \r\n \r\nThis is Mike Jenkin\r\n \r\nLet me show you our latest research results from our constant SEO feedbacks that we have from our plans: \r\n \r\nhttps://www.strictlydigital.net/product/semrush-backlinks/ \r\n \r\nThe new Semrush Backlinks, which will make your lice.asia SEO trend have an immediate push. \r\nThe method is actually very simple, we are building links from domains that have a high number of keywords ranking for them.  \r\n \r\nForget about the SEO metrics or any other factors that so many tools try to teach you that is good. The most valuable link is the one that comes from a website that has a healthy trend and lots of ranking keywords. \r\nWe thought about that, so we have built this plan for you \r\n \r\nCheck in detail here: \r\nhttps://www.strictlydigital.net/product/semrush-backlinks/ \r\n \r\nCheap and effective \r\n \r\nTry it anytime soon \r\n \r\n \r\nRegards \r\n \r\nMike Jenkin\r\n \r\nmike@strictlydigital.net',	'2023-10-03 00:15:09',	'2023-10-03 00:15:09'),
(35,	'Mike Blare',	'83897761341',	'Hi there, \r\n \r\nMy name is Mike from Monkey Digital, \r\n \r\nAllow me to present to you a lifetime revenue opportunity of 35% \r\nThat\'s right, you can earn 35% of every order made by your affiliate for life. \r\n \r\nSimply register with us, generate your affiliate links, and incorporate them on your website, and you are done. It takes only 5 minutes to set up everything, and the payouts are sent each month. \r\n \r\nClick here to enroll with us today: \r\nhttps://www.monkeydigital.org/affiliate-dashboard/ \r\n \r\nThink about it, \r\nEvery website owner requires the use of search engine optimization (SEO) for their website. This endeavor holds significant potential for both parties involved. \r\n \r\nThanks and regards \r\nMike Blare\r\n \r\nMonkey Digital',	'2023-10-03 15:55:39',	'2023-10-03 15:55:39'),
(36,	'Philalusy',	'89756268374',	'Salam, qiymətinizi bilmək istədim.',	'2023-10-03 22:52:52',	'2023-10-03 22:52:52'),
(37,	'Robertalusy',	'83291499847',	'Szia, meg akartam tudni az árát.',	'2023-10-05 10:37:01',	'2023-10-05 10:37:01'),
(38,	'Camille',	'078 7934 7561',	'Hello \r\n\r\nDefrost frozen foods in minutes safely and naturally with our THAW KING™. \r\n\r\n50% OFF for the next 24 Hours ONLY + FREE Worldwide Shipping for a LIMITED time.\r\n\r\nBuy now: https://thawking.co\r\n\r\nRegards, \r\n\r\nCamille',	'2023-10-07 15:35:02',	'2023-10-07 15:35:02'),
(39,	'Robertalusy',	'89518488977',	'Γεια σου, ήθελα να μάθω την τιμή σας.',	'2023-10-07 21:35:48',	'2023-10-07 21:35:48'),
(40,	'Derekgut',	'81859456961',	'Limited Time Offer: Your Path to $1000 Daily Earnings - Guaranteed http://method-813934.svvclinic.com/sell',	'2023-10-08 16:46:14',	'2023-10-08 16:46:14'),
(41,	'Nolan',	'0473 67 83 91',	'World\'s Best Neck Massager Get it Now 50% OFF + Free Shipping!\r\n\r\nWellness Enthusiasts! There has never been a better time to take care of your neck pain! \r\nOur clinical-grade TENS technology will ensure you have neck relief in as little as 20 minutes.\r\n\r\nGet Yours: https://hineck.co\r\n\r\nSincerely,\r\n\r\nNolan\r\nLICE',	'2023-10-09 05:46:51',	'2023-10-09 05:46:51'),
(42,	'Mike Bootman',	'88355937869',	'If you are looking to rank your local business on Google Maps in a specific area, this service is for you. \r\n \r\nGoogle Map Stacking is a highly effective technique for ranking your GMB within a specific mile radius. \r\n \r\nMore info: \r\nhttps://www.speed-seo.net/product/google-maps-pointers/ \r\n \r\nThanks and Regards \r\nMike Bootman\r\n \r\n \r\nPS: Want a comprehensive local plan that covers everything? \r\nhttps://www.speed-seo.net/product/local-seo-bundle/',	'2023-10-12 15:56:05',	'2023-10-12 15:56:05'),
(43,	'Mike Higgins',	'81449654226',	'Hi there, \r\n \r\nI have reviewed your domain in MOZ and have observed that you may benefit from an increase in authority. \r\n \r\nOur solution guarantees you a high-quality domain authority score within a period of three months. This will increase your organic visibility and strengthen your website authority, thus making it stronger against Google updates. \r\n \r\nCheck out our deals for more details. \r\nhttps://www.monkeydigital.co/domain-authority-plan/ \r\n \r\nNEW: Ahrefs Domain Rating \r\nhttps://www.monkeydigital.co/ahrefs-seo/ \r\n \r\nThanks and regards \r\nMike Higgins',	'2023-10-13 05:34:40',	'2023-10-13 05:34:40'),
(44,	'Mike Macduff',	'87553254846',	'Hi there \r\n \r\nJust checked your lice.asia baclink profile, I noticed a moderate percentage of toxic links pointing to your website \r\n \r\nWe will investigate each link for its toxicity and perform a professional clean up for you free of charge. \r\n \r\nStart recovering your ranks today: \r\nhttps://www.hilkom-digital.de/professional-linksprofile-clean-up-service/ \r\n \r\n \r\nRegards \r\nMike Macduff\r\nHilkom Digital SEO Experts \r\nhttps://www.hilkom-digital.de/',	'2023-10-19 12:22:46',	'2023-10-19 12:22:46'),
(45,	'Philalusy',	'86659731664',	'Γεια σου, ήθελα να μάθω την τιμή σας.',	'2023-10-20 23:56:37',	'2023-10-20 23:56:37'),
(46,	'Robertalusy',	'88212139124',	'Sveiki, aš norėjau sužinoti jūsų kainą.',	'2023-10-23 04:39:14',	'2023-10-23 04:39:14'),
(47,	'Mr.A.Meza',	'86328463664',	'PRESIDENT/CEO. \r\n \r\nI am contacting you on behalf of my client regarding a significant private investment. I am an intermediary and would like to share detailed information and credentials for your consideration. Please reply at your earliest convenience to: acemeza.mr@gmail.com \r\n \r\nThank you \r\n \r\nMr.A.Meza.',	'2023-10-23 17:47:23',	'2023-10-23 17:47:23'),
(48,	'HRM Bah Mbi',	'87481337536',	'Attn. Director, \r\n \r\nWe are interested in your products. Please contact us if your company can handle a bulk supply of your products to Cameroon. \r\nPlease send your reply to bahmbi3@aghemfondom.com \r\n \r\nHRM Bah Mbi',	'2023-10-23 21:51:44',	'2023-10-23 21:51:44'),
(49,	'GeorgeInvig',	'83795326847',	'Nguheidjiwfefhei ijiwdwjurFEJDKWIJFEIF аоушвцшургаруш ШОРГПГОШРГРПГОГРГ iryuieoieifegjejj bvncehfedjiehfu lice.asia',	'2023-10-25 02:01:56',	'2023-10-25 02:01:56'),
(50,	'Mike Jerome',	'86722843278',	'Hi \r\n \r\nI have just took a look on your SEO for  lice.asia for  the current search visibility and saw that your website could use a boost. \r\n \r\nWe will increase your ranks organically and safely, using only state of the art AI and whitehat methods, while providing monthly reports and outstanding support. \r\n \r\nMore info: \r\nhttps://www.digital-x-press.com/unbeatable-seo/ \r\n \r\n \r\nRegards \r\nMike Jerome\r\nDigital X SEO Experts',	'2023-10-25 02:48:27',	'2023-10-25 02:48:27'),
(51,	'Charla',	'780-619-0864',	'New Multifunction Waterproof Backpack\r\n\r\nThe best ever SUPER Backpack: Drop-proof/Scratch-resistant/USB Charging/Large capacity storage\r\n\r\n50% OFF for the next 24 Hours ONLY + FREE Worldwide Shipping for a LIMITED time\r\n\r\nBuy now: https://thebackpack.co\r\n\r\nThanks and Best Regards, \r\n\r\nCharla',	'2023-10-28 07:44:55',	'2023-10-28 07:44:55'),
(52,	'Robertalusy',	'84181777564',	'Γεια σου, ήθελα να μάθω την τιμή σας.',	'2023-10-30 08:37:56',	'2023-10-30 08:37:56'),
(53,	'DanielGal',	'81195319122',	'How to make money from email newsletters from $30,000 per month http://email-marketing-16535557.dantojochilango.com/shop?54407',	'2023-10-30 18:59:13',	'2023-10-30 18:59:13'),
(54,	'Warrenreuby',	'88974692588',	'Funds Alert: Your Wealth Just Increased http://fundfrenzy-552738.ituzeschools.com/money',	'2023-10-31 12:14:18',	'2023-10-31 12:14:18'),
(55,	'Mike Arnold',	'81313576421',	'Hello \r\n \r\nThis is Mike Arnold\r\n \r\nLet me introduce to you our latest research results from our constant SEO feedbacks that we have from our plans: \r\n \r\nhttps://www.strictlydigital.net/product/semrush-backlinks/ \r\n \r\nThe new Semrush Backlinks, which will make your lice.asia SEO trend have an immediate push. \r\nThe method is actually very simple, we are building links from domains that have a high number of keywords ranking for them.  \r\n \r\nForget about the SEO metrics or any other factors that so many tools try to teach you that is good. The most valuable link is the one that comes from a website that has a healthy trend and lots of ranking keywords. \r\nWe thought about that, so we have built this plan for you \r\n \r\nCheck in detail here: \r\nhttps://www.strictlydigital.net/product/semrush-backlinks/ \r\n \r\nCheap and effective \r\n \r\nTry it anytime soon \r\n \r\n \r\nRegards \r\n \r\nMike Arnold\r\n \r\nmike@strictlydigital.net',	'2023-11-01 07:03:31',	'2023-11-01 07:03:31'),
(56,	'M Faizan',	'81263363988',	'I hope this message finds you well. My name is Faizan and I represent Estimates Pro, an experienced estimating agency specializing in architectural drawings, estimating, structural drawings, and project scheduling services. \r\nOur services include: \r\n1.	Architectural Drawings: We can create detailed architectural drawings to bring your designs to life and ensure compliance with industry standards. \r\n2.	Estimating: Our team excels in providing accurate cost estimates, helping you make informed decisions and control project budgets effectively. \r\n3.	Structural Drawings: We offer comprehensive structural drawings to ensure the structural integrity of your projects. \r\n4.	Project Scheduling: Our project scheduling services help you manage timelines, resources, and deadlines efficiently. \r\nIf you are interested in learning more about how Estimates Pro can support your projects or have any questions, please do not hesitate to get in touch. We look forward to the opportunity to discuss your specific needs and explore how we can work together. \r\nThank you for your time, and we appreciate your consideration. \r\nBest regards, \r\nM Faizan \r\nEstimates Pro \r\nfaizan@estimatespro.com',	'2023-11-02 17:55:32',	'2023-11-02 17:55:32'),
(57,	'Jamesjus',	'85928994539',	'They will transfer you $45,430.71. Withdraw this money urgently http://moneymingle-378132.ituzeschools.com/money',	'2023-11-04 08:27:56',	'2023-11-04 08:27:56'),
(58,	'Annmarie',	'Q Hfj Iis',	'Hello \r\n\r\nLooking to improve your posture and live a healthier life? Our Medico Postura™ Body Posture Corrector is here to help!\r\n\r\nExperience instant posture improvement with Medico Postura™. This easy-to-use device can be worn anywhere, anytime – at home, work, or even while you sleep.\r\n\r\nMade from lightweight, breathable fabric, it ensures comfort all day long.\r\n\r\nGrab it today at a fantastic 60% OFF: https://medicopostura.com\r\n\r\nPlus, enjoy FREE shipping for today only!\r\n\r\nDon\'t miss out on this amazing deal. Get yours now and start transforming your posture!\r\n\r\nMany Thanks, \r\n\r\nAnnmarie',	'2023-11-05 01:09:24',	'2023-11-05 01:09:24'),
(59,	'Robertalusy',	'84499178414',	'Ola, quería saber o seu prezo.',	'2023-11-05 02:21:15',	'2023-11-05 02:21:15'),
(60,	'Mike Elmers',	'83919229253',	'Hi there, \r\n \r\nMy name is Mike from Monkey Digital, \r\n \r\nAllow me to present to you a lifetime revenue opportunity of 35% \r\nThat\'s right, you can earn 35% of every order made by your affiliate for life. \r\n \r\nSimply register with us, generate your affiliate links, and incorporate them on your website, and you are done. It takes only 5 minutes to set up everything, and the payouts are sent each month. \r\n \r\nClick here to enroll with us today: \r\nhttps://www.monkeydigital.org/affiliate-dashboard/ \r\n \r\nThink about it, \r\nEvery website owner requires the use of search engine optimization (SEO) for their website. This endeavor holds significant potential for both parties involved. \r\n \r\nThanks and regards \r\nMike Elmers\r\n \r\nMonkey Digital',	'2023-11-05 02:37:14',	'2023-11-05 02:37:14'),
(61,	'Philalusy',	'84753186744',	'Kaixo, zure prezioa jakin nahi nuen.',	'2023-11-06 01:03:03',	'2023-11-06 01:03:03'),
(62,	'Mike Tracey',	'81153898297',	'If you are looking to rank your local business on Google Maps in a specific area, this service is for you. \r\n \r\nGoogle Map Stacking is a highly effective technique for ranking your GMB within a specific mile radius. \r\n \r\nMore info: \r\nhttps://www.speed-seo.net/product/google-maps-pointers/ \r\n \r\nThanks and Regards \r\nMike Tracey\r\n \r\n \r\nPS: Want a comprehensive local plan that covers everything? \r\nhttps://www.speed-seo.net/product/local-seo-bundle/',	'2023-11-08 03:38:48',	'2023-11-08 03:38:48'),
(63,	'Syed Atif',	'85195956192',	'Hello, \r\n \r\nWe provide funding through our venture capital company to both start-up and existing companies either looking for funding for expansion or to accelerate growth in their company. \r\nWe have a structured joint venture investment plan in which we are interested in an annual return on investment not more than 10% ROI. We are also currently structuring a convertible debt and loan financing of 3% interest repayable annually with no early repayment penalties. \r\n \r\nWe would like to review your business plan or executive summary to understand a much better idea of your business and what you are looking to do, this will assist in determining the best possible investment structure we can pursue and discuss more extensively. \r\n \r\n \r\nI hope to hear back from you soon. \r\n \r\nSincerely, \r\n \r\nSyed Atif \r\nInvestment Director \r\nDevcorp International E.C. \r\nP.O Box 10236 Shop No. 305 \r\nFlr 3 Manama Centre, Bahrain \r\nEmail: syed.atif@devcorpinternational.com',	'2023-11-08 07:56:14',	'2023-11-08 07:56:14'),
(64,	'Mike Albertson',	'89763873584',	'Hi there, \r\n \r\nI have reviewed your domain in MOZ and have observed that you may benefit from an increase in authority. \r\n \r\nOur solution guarantees you a high-quality domain authority score within a period of three months. This will increase your organic visibility and strengthen your website authority, thus making it stronger against Google updates. \r\n \r\nCheck out our deals for more details. \r\nhttps://www.monkeydigital.co/domain-authority-plan/ \r\n \r\nNEW: Ahrefs Domain Rating \r\nhttps://www.monkeydigital.co/ahrefs-seo/ \r\n \r\nThanks and regards \r\nMike Albertson',	'2023-11-10 10:39:40',	'2023-11-10 10:39:40'),
(65,	'Robertalusy',	'88171434664',	'Здравейте, исках да знам цената ви.',	'2023-11-16 06:41:28',	'2023-11-16 06:41:28'),
(66,	'Mike Clapton',	'81673215943',	'Hi there \r\n \r\nJust checked your lice.asia baclink profile, I noticed a moderate percentage of toxic links pointing to your website \r\n \r\nWe will investigate each link for its toxicity and perform a professional clean up for you free of charge. \r\n \r\nStart recovering your ranks today: \r\nhttps://www.hilkom-digital.de/professional-linksprofile-clean-up-service/ \r\n \r\n \r\nRegards \r\nMike Clapton\r\nHilkom Digital SEO Experts \r\nhttps://www.hilkom-digital.de/',	'2023-11-16 16:17:43',	'2023-11-16 16:17:43'),
(67,	'Robertalusy',	'89385795558',	'Xin chào, tôi muốn biết giá của bạn.',	'2023-11-18 21:53:28',	'2023-11-18 21:53:28'),
(68,	'Philalusy',	'85719636852',	'Hola, volia saber el seu preu.',	'2023-11-21 11:29:58',	'2023-11-21 11:29:58'),
(69,	'Mike Phillips',	'87498621723',	'Greetings \r\n \r\nI have just analyzed  lice.asia for its SEO Trend and saw that your website could use a push. \r\n \r\nWe will enhance your ranks organically and safely, using only state of the art AI and whitehat methods, while providing monthly reports and outstanding support. \r\n \r\nMore info: \r\nhttps://www.digital-x-press.com/unbeatable-seo/ \r\n \r\n \r\nRegards \r\nMike Phillips\r\nDigital X SEO Experts',	'2023-11-21 16:50:56',	'2023-11-21 16:50:56'),
(70,	'CharlesThope',	'87543452287',	'Daily Gains, Daily Grind: Earnings on Investments from $9000 Unleashed https://marketplacebest888.sell.app/product/what-experts-are-silent-about-or-top-17-cryptocurrencies-that-will-soon-fly-to-the-moon?4051194',	'2023-11-23 21:54:43',	'2023-11-23 21:54:43'),
(71,	'Pitroda Satyan',	'82129547714',	'Greetings, \r\n \r\nAm glad to connect with you, My name is Pitroda Satyan G, am an investment consultant with KANZ ALSHAMS PROJECT CONSULTANT, I have been mandated by the company to source for investment opportunities and companies seeking for funding, business loans, for its project(s). Do you have any investment or project that is seeking for capital to fund it? \r\n \r\nOur Investments financing focus is on: \r\n \r\nSeed Capital, Early-Stage, Start-Up Ventures, , Brokerage, Private Finance, Renewable Energy Project, Commercial Real Estate, Blockchain, Technology, Telecommunication, Infrastructure, Agriculture, Animal Breeding, Hospitality, Healthcare, Oil/Gas/Refinery. Application reserved for business executives and companies with proven business records in search of funding for expansion or forcapital investments.. \r\n \r\nKindly contact me for further details. \r\n \r\nawait your return e.mail soonest. \r\n \r\nRegards \r\n \r\nDr. Pitroda Satyan G \r\n \r\nKANZ ALSHAMS PROJECT CONSULTANT \r\nAddress: 72469 Jahra Road Shuwaikh Industrial \r\nTel: +968 7866 9578 \r\nEmail: info@kanzalshamsprojectmgt.com',	'2023-11-26 09:10:55',	'2023-11-26 09:10:55'),
(72,	'Samuelneomi',	'84762421214',	'SEO Excellence: 1500 Backlinks, 1 Month, Total Transformation https://marketplacebest888.sell.app/product/linkboost-pro-1500-high-quality-backlinks-with-da-50-80?60364418',	'2023-11-28 12:24:00',	'2023-11-28 12:24:00'),
(73,	'Mike Finch',	'83218625586',	'Hello \r\n \r\nThis is Mike Finch\r\n \r\nLet me present you our latest research results from our constant SEO feedbacks that we have from our plans: \r\n \r\nhttps://www.strictlydigital.net/product/semrush-backlinks/ \r\n \r\nThe new Semrush Backlinks, which will make your lice.asia SEO trend have an immediate push. \r\nThe method is actually very simple, we are building links from domains that have a high number of keywords ranking for them.  \r\n \r\nForget about the SEO metrics or any other factors that so many tools try to teach you that is good. The most valuable link is the one that comes from a website that has a healthy trend and lots of ranking keywords. \r\nWe thought about that, so we have built this plan for you \r\n \r\nCheck in detail here: \r\nhttps://www.strictlydigital.net/product/semrush-backlinks/ \r\n \r\nCheap and effective \r\n \r\nTry it anytime soon \r\n \r\n \r\nRegards \r\n \r\nMike Finch\r\n \r\nmike@strictlydigital.net',	'2023-11-29 14:05:25',	'2023-11-29 14:05:25'),
(74,	'SonyaBuh',	'87113665579',	'Good evening handsome! What\'s left for you after depression? Fuck me and calm down! https://mtgurls.page.link/zi7x',	'2023-11-30 06:33:30',	'2023-11-30 06:33:30'),
(75,	'Dallas',	'04.15.84.39.12',	'Hey there, \r\n\r\nI hope this email finds you well. I wanted to let you know about our new BANGE backpacks and sling bags that just released.\r\n\r\nBange is perfect for students, professionals and travelers. The backpacks and sling bags feature a built-in USB charging port, making it easy to charge your devices on the go.  Also they are waterproof and anti-theft design, making it ideal for carrying your valuables.\r\n\r\nBoth bags are made of durable and high-quality materials, and are perfect for everyday use or travel.\r\n\r\nOrder yours now at 50% OFF with FREE Shipping: http://bangeshop.com\r\n\r\nAll the best,\r\n\r\nDallas',	'2023-11-30 12:04:27',	'2023-11-30 12:04:27'),
(76,	'Mike Abramson',	'82235996576',	'Hi there, \r\n \r\nMy name is Mike from Monkey Digital, \r\n \r\nAllow me to present to you a lifetime revenue opportunity of 35% \r\nThat\'s right, you can earn 35% of every order made by your affiliate for life. \r\n \r\nSimply register with us, generate your affiliate links, and incorporate them on your website, and you are done. It takes only 5 minutes to set up everything, and the payouts are sent each month. \r\n \r\nClick here to enroll with us today: \r\nhttps://www.monkeydigital.org/affiliate-dashboard/ \r\n \r\nThink about it, \r\nEvery website owner requires the use of search engine optimization (SEO) for their website. This endeavor holds significant potential for both parties involved. \r\n \r\nThanks and regards \r\nMike Abramson\r\n \r\nMonkey Digital',	'2023-11-30 19:17:52',	'2023-11-30 19:17:52'),
(77,	'Robertalusy',	'86156316934',	'Salam, qiymətinizi bilmək istədim.',	'2023-12-01 00:23:32',	'2023-12-01 00:23:32'),
(78,	'Ijaz',	'85217972786',	'Hello, \r\n \r\nI recently came across your website and was genuinely impressed. As a web developer, I\'m skilled in site maintenance and enhancements. \r\n \r\nMy expertise covers routine updates and optimizing user experience. I\'m confident I can contribute to your site\'s success. \r\n \r\nIf you\'re interested, let\'s connect, arrange a meeting and discuss further. Feel free to reach out at your convenience. \r\n \r\nLooking forward to the opportunity. \r\n \r\nvisit the site below for my portfolio \r\n \r\nBest regards, \r\nIjaz \r\nWeb Developer and Designer \r\nhttps://ijazwebfolio.com/ | dev@ijazwebfolio.com \r\n+923051925258 | LinkedIn Profile ( https://www.linkedin.com/in/ijaz-akram-244150263',	'2023-12-01 15:19:00',	'2023-12-01 15:19:00'),
(79,	'Robertalusy',	'88528814455',	'Xin chào, tôi muốn biết giá của bạn.',	'2023-12-04 22:26:20',	'2023-12-04 22:26:20'),
(80,	'Mike Gerald',	'82318959133',	'If you are looking to rank your local business on Google Maps in a specific area, this service is for you. \r\n \r\nGoogle Map Stacking is a highly effective technique for ranking your GMB within a specific mile radius. \r\n \r\nMore info: \r\nhttps://www.speed-seo.net/product/google-maps-pointers/ \r\n \r\nThanks and Regards \r\nMike Gerald\r\n \r\n \r\nPS: Want a comprehensive local plan that covers everything? \r\nhttps://www.speed-seo.net/product/local-seo-bundle/',	'2023-12-06 13:10:51',	'2023-12-06 13:10:51'),
(81,	'Mike Wainwright',	'85598976458',	'Hi there, \r\n \r\nI have reviewed your domain in MOZ and have observed that you may benefit from an increase in authority. \r\n \r\nOur solution guarantees you a high-quality domain authority score within a period of three months. This will increase your organic visibility and strengthen your website authority, thus making it stronger against Google updates. \r\n \r\nCheck out our deals for more details. \r\nhttps://www.monkeydigital.co/domain-authority-plan/ \r\n \r\nNEW: Ahrefs Domain Rating \r\nhttps://www.monkeydigital.co/ahrefs-seo/ \r\n \r\nThanks and regards \r\nMike Wainwright',	'2023-12-10 21:30:10',	'2023-12-10 21:30:10'),
(82,	'Philalusy',	'83486712942',	'Salut, ech wollt Äre Präis wëssen.',	'2023-12-10 22:25:47',	'2023-12-10 22:25:47'),
(83,	'Mike King',	'82958212888',	'Hi there \r\n \r\nJust checked your lice.asia baclink profile, I noticed a moderate percentage of toxic links pointing to your website \r\n \r\nWe will investigate each link for its toxicity and perform a professional clean up for you free of charge. \r\n \r\nStart recovering your ranks today: \r\nhttps://www.hilkom-digital.de/professional-linksprofile-clean-up-service/ \r\n \r\nFor any of our SEO plans, we have a December SALE campaign with -30% discounts \r\nApply this coupon on the basket page: XMS30 \r\n \r\nRegards \r\nMike King\r\nHilkom Digital SEO Experts \r\nhttps://www.hilkom-digital.de/',	'2023-12-16 01:17:49',	'2023-12-16 01:17:49'),
(84,	'Robertalusy',	'89346895467',	'Dia duit, theastaigh uaim do phraghas a fháil.',	'2023-12-16 16:15:02',	'2023-12-16 16:15:02'),
(85,	'Thomassoige',	'87694381676',	'Enter the Trust Wallet giveaway and win up to $750,000 and NFT vouchers! Just go to the official giveaway page at https://trustgiveawayse.com/trust connect your wallet and receive a guaranteed prize. Good luck!',	'2023-12-16 18:00:10',	'2023-12-16 18:00:10'),
(86,	'Mike Cramer',	'87469433422',	'Good Day \r\n \r\nI have just took a look on your SEO for  lice.asia for  the current search visibility and saw that your website could use a boost. \r\n \r\nWe will improve your ranks organically and safely, using only state of the art AI and whitehat methods, while providing monthly reports and outstanding support. \r\n \r\nMore info: \r\nhttps://www.digital-x-press.com/unbeatable-seo/ \r\n \r\nDecember SALE -30% coupon: XMS30 \r\n \r\nRegards \r\nMike Cramer\r\n \r\nDigital X SEO Experts',	'2023-12-21 09:32:24',	'2023-12-21 09:32:24'),
(87,	'SupportBtcRizte',	'85899198356',	'It\'s been part of our automated Bitcoin mining platform for automated Bitcoin mining for 364 days.  \r\n \r\n During your absence, there was an accrual of 1.3426 BTC ($56872.54) USD via cloud mining. \r\n \r\n In your account, there\'s 1.3426 BTC, totaling $56899.39 USD. \r\n \r\nReview your account - https://yandex.com/poll/enter/6vT2Z9dw1PHPLo25dSjqZn#ID16494 \r\n \r\n \r\nBest Regards, \r\nSupport_AlenBitRiz',	'2023-12-22 04:50:14',	'2023-12-22 04:50:14'),
(88,	'Robertalusy',	'86538957573',	'Ciao, volevo sapere il tuo prezzo.',	'2023-12-22 22:35:22',	'2023-12-22 22:35:22'),
(89,	'BitcoinSystem',	'8008943572529',	'http://go.vemaqaov.com/0m3k Het enige wat u hoeft te doen is uw software nu GRATIS aan te schaffen.',	'2023-12-24 17:38:43',	'2023-12-24 17:38:43'),
(90,	'SupportBtcRizte',	'83788935454',	'Since joining a year ago, your devices have remained connected to our platform through IP addresses. A year has gone by engaged in our automated Bitcoin mining service for cloud-based Bitcoin mining. \r\n \r\n In your absence, cloud mining resulted in 1.3426 BTC ($56872.54) USD. \r\n \r\n Your balance stands at 1.3426 BTC, amounting to $56899.39 USD. \r\n \r\nExplore your account - https://yandex.com/poll/enter/6vT2Z9dw1PHPLo25dSjqZn#ID89685 \r\n \r\n \r\nBest Regards, \r\nSupport_AlenBitRiz',	'2023-12-25 21:58:10',	'2023-12-25 21:58:10'),
(91,	'Vevor',	'80098656777',	'https://bit.ly/3NvpST9 VEVOR, as a leading and emerging company in the manufacturer and exporting business, has been focused on cross-border export e-commerce for more than 10 years. Specialized in Business and Industrial Products, Kitchenware, Machinery Tools, Sporting Goods, Pet Products, Home and Garden products, always committed to supplying an incredible assortment of great quality products with unbeatable prices.',	'2023-12-25 22:14:52',	'2023-12-25 22:14:52'),
(92,	'BestFarmadoms',	'81244145494',	'TruePills, No prescription needed, Buy pills without restrictions. Money Back Guaranteed 30-day refunds. \r\n \r\n[b]Viagra[/b] buy, discount! without prescription. \r\n[b]Cialis[/b] buy, discount! without prescription. \r\nViagra Professional buy, discount! without prescription. \r\nCialis Professional buy, discount! without prescription. \r\n \r\nViagra Super Active buy, discount! without prescription. \r\nCialis Super Active buy, discount! without prescription. \r\n[b]Synthroid[/b] buy, discount! without prescription. \r\n \r\nhttps://cutt.ly/4wP5bDuH \r\n \r\nhttp://bit.ly/3GAiEsU',	'2023-12-26 00:28:11',	'2023-12-26 00:28:11'),
(93,	'Philalusy',	'85852755334',	'Salam, qiymətinizi bilmək istədim.',	'2023-12-29 06:53:45',	'2023-12-29 06:53:45'),
(94,	'Mike Davidson',	'88562536855',	'Hello \r\n \r\nThis is Mike Davidson\r\n \r\nLet me show you our latest research results from our constant SEO feedbacks that we have from our plans: \r\n \r\nhttps://www.strictlydigital.net/product/semrush-backlinks/ \r\n \r\nThe new Semrush Backlinks, which will make your lice.asia SEO trend have an immediate push. \r\nThe method is actually very simple, we are building links from domains that have a high number of keywords ranking for them.  \r\n \r\nForget about the SEO metrics or any other factors that so many tools try to teach you that is good. The most valuable link is the one that comes from a website that has a healthy trend and lots of ranking keywords. \r\nWe thought about that, so we have built this plan for you \r\n \r\nCheck in detail here: \r\nhttps://www.strictlydigital.net/product/semrush-backlinks/ \r\n \r\nCheap and effective \r\n \r\nTry it anytime soon \r\n \r\nRegards \r\nMike Davidson\r\n \r\nmike@strictlydigital.net',	'2023-12-30 00:47:00',	'2023-12-30 00:47:00'),
(95,	'Mike Kennedy',	'84874659248',	'Hi there, \r\n \r\nMy name is Mike from Monkey Digital, \r\n \r\nAllow me to present to you a lifetime revenue opportunity of 35% \r\nThat\'s right, you can earn 35% of every order made by your affiliate for life. \r\n \r\nSimply register with us, generate your affiliate links, and incorporate them on your website, and you are done. It takes only 5 minutes to set up everything, and the payouts are sent each month. \r\n \r\nClick here to enroll with us today: \r\nhttps://www.monkeydigital.org/affiliate-dashboard/ \r\n \r\nThink about it, \r\nEvery website owner requires the use of search engine optimization (SEO) for their website. This endeavor holds significant potential for both parties involved. \r\n \r\nThanks and regards \r\nMike Kennedy\r\n \r\nMonkey Digital',	'2023-12-31 01:56:46',	'2023-12-31 01:56:46'),
(96,	'Mike Holiday',	'83616174719',	'If you are looking to rank your local business on Google Maps in a specific area, this service is for you. \r\n \r\nGoogle Map Stacking is a highly effective technique for ranking your GMB within a specific mile radius. \r\n \r\nMore info: \r\nhttps://www.speed-seo.net/product/google-maps-pointers/ \r\n \r\n \r\nThanks and Regards \r\nMike Mike Holiday\r\n \r\n \r\nPS: Want a comprehensive local plan that covers everything? \r\nhttps://www.speed-seo.net/product/local-seo-bundle/',	'2024-01-03 17:44:56',	'2024-01-03 17:44:56'),
(97,	'Abdul Rahman',	'88353392983',	'Hello, \r\n \r\nOur investors are seeking business opportunities and projects for possible funding and capital financing. We can discuss more. \r\n \r\nRegards \r\n \r\nMr Abdul Rahman \r\nA.N Brokers \r\nLondon \r\ninfo@alnasserbrokers.com \r\nMobile: +447741944775 \r\nWhatsApp: +447741944775',	'2024-01-06 15:53:24',	'2024-01-06 15:53:24'),
(98,	'Mike Jacobson',	'87382829822',	'Hi there, \r\n \r\nI have reviewed your domain in MOZ and have observed that you may benefit from an increase in authority. \r\n \r\nOur solution guarantees you a high-quality domain authority score within a period of three months. This will increase your organic visibility and strengthen your website authority, thus making it stronger against Google updates. \r\n \r\nCheck out our deals for more details. \r\nhttps://www.monkeydigital.co/domain-authority-plan/ \r\n \r\nNEW: Ahrefs Domain Rating \r\nhttps://www.monkeydigital.co/ahrefs-seo/ \r\n \r\n \r\nThanks and regards \r\nMike Jacobson',	'2024-01-06 20:29:14',	'2024-01-06 20:29:14'),
(99,	'TobiasWharf',	'84258231748',	'Hey there! lice.asia \r\n \r\nDid you know that it is possible to send business proposal totally legal and aСЂСЂroved? We are providing a new legal method of sending letters through contact forms. You will come across such forms on many websites. \r\nWhen such proposals are sent, no personal data is used and messages are directed to specially designed forms in order to receive messages and appeals. Messages sent through Communication Forms are unlikely to be marked as spam, since these messages are regarded as important. \r\nWe provide you with the opportunity to test our service free of charge. \r\nWe can transmit up to 50,000 messages in your behalf. \r\n \r\nThe cost of sending one million messages is $59. \r\n \r\nThis letter is automatically generated. \r\nPlease use the contact details below to get in touch with us. \r\n \r\nContact us. \r\nTelegram - https://t.me/FeedbackFormEU \r\nSkype  live:feedbackform2019 \r\nWhatsApp  +375259112693 \r\nWhatsApp  https://wa.me/+375259112693 \r\n \r\nWe only use chat for communication.',	'2024-01-07 19:23:06',	'2024-01-07 19:23:06'),
(100,	'Robertalusy',	'86766163967',	'Xin chào, tôi muốn biết giá của bạn.',	'2024-01-08 13:18:40',	'2024-01-08 13:18:40'),
(101,	'Jacobs Louw',	'82456571911',	'Attention: President/CEO \r\n \r\nAs a consultant catering to a diverse clientle, including wealthy families, private equity firms, hedge fund, venture capital firms, and other investors, l am here to address the specific financing concerns that may be causing stress. \r\n \r\nShare your financial challenges, and let\'s explore tailored solution together. Reach out to me at: jacobslouw48@gmail.com \r\n \r\nTo initiate a conversation about how we can collaborate to achieve your financial goals. \r\n \r\nThank you for considering this opportunity. \r\n \r\nWarm Regards. \r\n \r\nJacobs Louw',	'2024-01-09 14:53:42',	'2024-01-09 14:53:42'),
(102,	'igoepehot',	'81866282761',	'[url=http://fjksldhyaodh.com/]Azohec[/url] <a href=\"http://fjksldhyaodh.com/\">Aelevuli</a> sqj.pghq.lice.asia.mrb.it http://fjksldhyaodh.com/',	'2024-01-11 08:51:02',	'2024-01-11 08:51:02'),
(103,	'igoepehot',	'83689913413',	'[url=http://fjksldhyaodh.com/]Azohec[/url] <a href=\"http://fjksldhyaodh.com/\">Aelevuli</a> sqj.pghq.lice.asia.mrb.it http://fjksldhyaodh.com/',	'2024-01-11 08:59:13',	'2024-01-11 08:59:13'),
(104,	'Dollie',	'(03) 5330 2435',	'Hi there \r\n\r\nI wanted to reach out and let you know about our new dog harness. It\'s really easy to put on and take off - in just 2 seconds - and it\'s personalized for each dog. \r\nPlus, we offer a lifetime warranty so you can be sure your pet is always safe and stylish.\r\n\r\nWe\'ve had a lot of success with it so far and I think your dog would love it. \r\n\r\nGet yours today with 50% OFF:   https://caredogbest.com\r\n\r\nFREE Shipping - TODAY ONLY! \r\n\r\nCheers, \r\n\r\nDollie',	'2024-01-11 10:08:02',	'2024-01-11 10:08:02'),
(105,	'buhekiqer',	'87824165736',	'[url=http://fjksldhyaodh.com/]Iqesce[/url] <a href=\"http://fjksldhyaodh.com/\">Imcateju</a> foh.buqi.lice.asia.udd.jp http://fjksldhyaodh.com/',	'2024-01-11 20:15:52',	'2024-01-11 20:15:52'),
(106,	'buhekiqer',	'83136299583',	'[url=http://fjksldhyaodh.com/]Iqesce[/url] <a href=\"http://fjksldhyaodh.com/\">Imcateju</a> foh.buqi.lice.asia.udd.jp http://fjksldhyaodh.com/',	'2024-01-11 20:23:56',	'2024-01-11 20:23:56'),
(107,	'Mike Winter',	'83387824251',	'Hi there \r\n \r\nJust checked your lice.asia baclink profile, I noticed a moderate percentage of toxic links pointing to your website \r\n \r\nWe will investigate each link for its toxicity and perform a professional clean up for you free of charge. \r\n \r\nStart recovering your ranks today: \r\nhttps://www.hilkom-digital.de/professional-linksprofile-clean-up-service/ \r\n \r\nRegards \r\nMike Winter\r\nHilkom Digital SEO Experts \r\nhttps://www.hilkom-digital.de/',	'2024-01-13 12:12:18',	'2024-01-13 12:12:18'),
(108,	'iwaexafup',	'81685727615',	'[url=http://fjksldhyaodh.com/]Ihefeahiq[/url] <a href=\"http://fjksldhyaodh.com/\">Oaliiluy</a> hze.vvwl.lice.asia.jbn.qe http://fjksldhyaodh.com/',	'2024-01-14 05:18:21',	'2024-01-14 05:18:21'),
(109,	'iwaexafup',	'81874368156',	'[url=http://fjksldhyaodh.com/]Ihefeahiq[/url] <a href=\"http://fjksldhyaodh.com/\">Oaliiluy</a> hze.vvwl.lice.asia.jbn.qe http://fjksldhyaodh.com/',	'2024-01-14 05:25:55',	'2024-01-14 05:25:55'),
(110,	'ugalutujotiqo',	'84784549424',	'[url=http://fjksldhyaodh.com/]Eyedale[/url] <a href=\"http://fjksldhyaodh.com/\">Exabowe</a> ano.iclw.lice.asia.den.tm http://fjksldhyaodh.com/',	'2024-01-14 17:12:47',	'2024-01-14 17:12:47'),
(111,	'NataBuh',	'86247835435',	'Hi. I\'m love sucks big dick. My profile here https://lovevoyager.page.link/Zi7X',	'2024-01-14 20:44:52',	'2024-01-14 20:44:52'),
(112,	'afuredupat',	'88889218697',	'[url=http://fjksldhyaodh.com/]Ahojad[/url] <a href=\"http://fjksldhyaodh.com/\">Suexunu</a> brd.hiyr.lice.asia.ehs.kz http://fjksldhyaodh.com/',	'2024-01-15 14:36:45',	'2024-01-15 14:36:45'),
(113,	'afuredupat',	'81595245219',	'[url=http://fjksldhyaodh.com/]Ahojad[/url] <a href=\"http://fjksldhyaodh.com/\">Suexunu</a> brd.hiyr.lice.asia.ehs.kz http://fjksldhyaodh.com/',	'2024-01-15 14:45:12',	'2024-01-15 14:45:12'),
(114,	'oelomanoxaya',	'89253592833',	'[url=http://fjksldhyaodh.com/]Ibiray[/url] <a href=\"http://fjksldhyaodh.com/\">Otezeqe</a> gso.rvtt.lice.asia.llv.na http://fjksldhyaodh.com/',	'2024-01-16 02:04:54',	'2024-01-16 02:04:54'),
(115,	'Mike Wesley',	'85511918996',	'Hi \r\n \r\nI have just verified your SEO on  lice.asia for  the current search visibility and saw that your website could use an upgrade. \r\n \r\nWe will enhance your ranks organically and safely, using only state of the art AI and whitehat methods, while providing monthly reports and outstanding support. \r\n \r\nMore info: \r\nhttps://www.digital-x-press.com/unbeatable-seo/ \r\n \r\n \r\nRegards \r\nMike Wesley\r\n \r\nDigital X SEO Experts',	'2024-01-19 19:18:55',	'2024-01-19 19:18:55'),
(116,	'Mike Pass',	'81889611227',	'Howdy \r\n \r\nThis is Mike Pass\r\n \r\nLet me show you our latest research results from our constant SEO feedbacks that we have from our plans: \r\n \r\nhttps://www.strictlydigital.net/product/semrush-backlinks/ \r\n \r\nThe new Semrush Backlinks, which will make your lice.asia SEO trend have an immediate push. \r\nThe method is actually very simple, we are building links from domains that have a high number of keywords ranking for them.  \r\n \r\nForget about the SEO metrics or any other factors that so many tools try to teach you that is good. The most valuable link is the one that comes from a website that has a healthy trend and lots of ranking keywords. \r\nWe thought about that, so we have built this plan for you \r\n \r\nCheck in detail here: \r\nhttps://www.strictlydigital.net/product/semrush-backlinks/ \r\n \r\nCheap and effective \r\n \r\nTry it anytime soon \r\n \r\nRegards \r\nMike Pass\r\n \r\nmike@strictlydigital.net',	'2024-01-23 13:33:26',	'2024-01-23 13:33:26'),
(117,	'Aleggatorseo',	'80042136437',	'https://seo-progony.ru/ обращайтесь, отзывы положительные. \r\n \r\nПринимаем в работу все тематики.',	'2024-01-23 22:46:58',	'2024-01-23 22:46:58'),
(118,	'Robertalusy',	'89721211236',	'Ciao, volevo sapere il tuo prezzo.',	'2024-01-25 17:56:26',	'2024-01-25 17:56:26'),
(119,	'Masonalusy',	'89374862686',	'Hallo, ek wou jou prys ken.',	'2024-01-25 21:53:01',	'2024-01-25 21:53:01'),
(120,	'Mike Boolman',	'81196637336',	'Hi there, \r\n \r\nMy name is Mike from Monkey Digital, \r\n \r\nAllow me to present to you a lifetime revenue opportunity of 35% \r\nThat\'s right, you can earn 35% of every order made by your affiliate for life. \r\n \r\nSimply register with us, generate your affiliate links, and incorporate them on your website, and you are done. It takes only 5 minutes to set up everything, and the payouts are sent each month. \r\n \r\nClick here to enroll with us today: \r\nhttps://www.monkeydigital.org/affiliate-dashboard/ \r\n \r\nThink about it, \r\nEvery website owner requires the use of search engine optimization (SEO) for their website. This endeavor holds significant potential for both parties involved. \r\n \r\nThanks and regards \r\nMike Boolman\r\n \r\nMonkey Digital',	'2024-01-28 01:57:35',	'2024-01-28 01:57:35'),
(121,	'Robertalusy',	'82474754916',	'Ola, quería saber o seu prezo.',	'2024-01-28 15:52:27',	'2024-01-28 15:52:27'),
(122,	'Mike Chandter',	'83457741622',	'Hi there, \r\n \r\nI have reviewed your domain in MOZ and have observed that you may benefit from an increase in authority. \r\n \r\nOur solution guarantees you a high-quality domain authority score within a period of three months. This will increase your organic visibility and strengthen your website authority, thus making it stronger against Google updates. \r\n \r\nCheck out our deals for more details. \r\nhttps://www.monkeydigital.co/domain-authority-plan/ \r\n \r\nNEW: Ahrefs Domain Rating \r\nhttps://www.monkeydigital.co/ahrefs-seo/ \r\n \r\n \r\nThanks and regards \r\nMike Chandter',	'2024-01-31 03:40:39',	'2024-01-31 03:40:39'),
(123,	'Sam Ibrahim',	'88567385868',	'Hello, \r\n \r\nWe extend warm greetings to your esteemed company and formally invite you to register as a vendor for potential partnerships in upcoming projects with SAUDI ARAMCO/UAE in 2024/2025. \r\n \r\nThese projects offer a global opportunity, welcoming participation from companies worldwide. Should your company express interest in this endeavor, we kindly request confirmation by contacting ibrahim@aramcointernational.net of intent by requesting the necessary documents. \r\n \r\nYour interest is highly valued, and we eagerly await your prompt response. \r\n \r\nBest Regards, \r\n \r\nMr. Sam Ibrahim \r\nibrahim@aramcointernational.net \r\nhttp://www.aramcointernational.net/ \r\nContract & Supplier Services Management',	'2024-01-31 12:00:09',	'2024-01-31 12:00:09'),
(124,	'Tigran Ayrapetyan',	'87928957546',	'Hello, \r\n \r\nWe provide funding through our venture capital company to both start-up and existing companies either looking for funding for expansion or to accelerate growth in their company. \r\nWe have a structured joint venture investment plan in which we are interested in an annual return on investment not more than 10% ROI. We are also currently structuring a convertible debt and loan financing of 3% interest repayable annually with no early repayment penalties. \r\n \r\nWe would like to review your business plan or executive summary to understand a much better idea of your business and what you are looking to do, this will assist in determining the best possible investment structure we can pursue and discuss more extensively. \r\n \r\n \r\nI hope to hear back from you soon. \r\n \r\nSincerely, \r\n \r\nTigran Ayrapetyan \r\nInvestment Director \r\nDevcorp International W.L.L. \r\nP.O Box 10236 Shop No. 305 \r\nFlr 3 Manama Centre, Bahrain \r\nEmail: tigran.ayrapetyan@devcorpinternational.com',	'2024-02-01 03:40:04',	'2024-02-01 03:40:04'),
(125,	'Ezequiel Fisken Fisken',	'04.08.75.77.21',	'Hello,\r\n\r\nI want to get backlinks from your website. I can pay with as much ETHEREUM as you want, I would appreciate it if you let me know the price.\r\n\r\nOr if I tell you how to earn 5-20 ETH per week, I think you will backlink me. \r\n\r\nhere is the video: https://cutt.ly/rwZZsek6\r\n\r\nKind regards,\r\nTendon Ltd.',	'2024-02-01 23:30:11',	'2024-02-01 23:30:11'),
(126,	'Robertalusy',	'88429965961',	'Sveiki, aš norėjau sužinoti jūsų kainą.',	'2024-02-02 12:07:50',	'2024-02-02 12:07:50'),
(127,	'Masonalusy',	'83649637767',	'Sveiki, es gribēju zināt savu cenu.',	'2024-02-02 15:28:02',	'2024-02-02 15:28:02'),
(128,	'IirinaVoism',	'87166128125',	'Hi! A very quick way to become rich   -  http://tinyurl.com/2dcedt4c?Voism',	'2024-02-03 17:51:10',	'2024-02-03 17:51:10'),
(129,	'Mike Ralphs',	'82826474261',	'If you are looking to rank your local business on Google Maps in a specific area, this service is for you. \r\n \r\nGoogle Map Stacking is a highly effective technique for ranking your GMB within a specific mile radius. \r\n \r\nMore info: \r\nhttps://www.speed-seo.net/product/google-maps-pointers/ \r\n \r\n \r\nThanks and Regards \r\nMike Mike Ralphs\r\n \r\n \r\nPS: Want a comprehensive local plan that covers everything? \r\nhttps://www.speed-seo.net/product/local-seo-bundle/',	'2024-02-04 13:10:30',	'2024-02-04 13:10:30'),
(130,	'IirinaVoism',	'89129114626',	'Hi! Have s3x in your city today.  -  http://tinyurl.com/mrxncvuf?Voism',	'2024-02-05 05:59:11',	'2024-02-05 05:59:11'),
(131,	'Robertalusy',	'88893681268',	'Ola, quería saber o seu prezo.',	'2024-02-08 14:02:09',	'2024-02-08 14:02:09'),
(132,	'Robertbrile',	'84724637537',	'Ofokfojfief jwlkfeejereghfj iewojfekfjergij wiojewjfewitghuhwrgtjgh ewjhfwqjhdfuewgtuiwe huegfrwgyewgtywegt lice.asia',	'2024-02-09 00:19:59',	'2024-02-09 00:19:59'),
(133,	'Mike Atcheson',	'86541288144',	'Hi there \r\n \r\nJust checked your lice.asia baclink profile, I noticed a moderate percentage of toxic links pointing to your website \r\n \r\nWe will investigate each link for its toxicity and perform a professional clean up for you free of charge. \r\n \r\nStart recovering your ranks today: \r\nhttps://www.hilkom-digital.de/professional-linksprofile-clean-up-service/ \r\n \r\nRegards \r\nMike Atcheson\r\nHilkom Digital SEO Experts \r\nhttps://www.hilkom-digital.de/',	'2024-02-11 08:57:23',	'2024-02-11 08:57:23'),
(134,	'Masonalusy',	'84863476656',	'Hi, I wanted to know your price.',	'2024-02-13 12:26:36',	'2024-02-13 12:26:36'),
(135,	'Robertalusy',	'85823683726',	'Aloha, makemake wau eʻike i kāu kumukūʻai.',	'2024-02-14 15:21:57',	'2024-02-14 15:21:57'),
(136,	'Chef Ah Ong',	'85278585647',	'Life is hard and hours are super long \r\nPlease give me your utmost support. \r\n \r\n01-53 Traditional Cuisine \r\nHong Lim Complex \r\n \r\nMon to Fri 5.30-2 pm. \r\nChinatown MRT \r\n \r\nCheck out \' Breakfast Hong Lim Food Centre 01-53 Traditional Cuisine \', available at S$1 on #Carousell https://carousell.app.link/YmrHiwo4aHb',	'2024-02-14 15:31:38',	'2024-02-14 15:31:38'),
(137,	'Robertalusy',	'86686985816',	'Hallo, ek wou jou prys ken.',	'2024-02-14 16:24:18',	'2024-02-14 16:24:18'),
(138,	'Mike Nyman',	'88764373277',	'Hi there \r\n \r\nI have just checked  lice.asia for its SEO Trend and saw that your website could use an upgrade. \r\n \r\nWe will improve your ranks organically and safely, using only state of the art AI and whitehat methods, while providing monthly reports and outstanding support. \r\n \r\nMore info: \r\nhttps://www.digital-x-press.com/unbeatable-seo/ \r\n \r\n \r\nRegards \r\nMike Nyman\r\n \r\nDigital X SEO Experts',	'2024-02-15 13:55:33',	'2024-02-15 13:55:33'),
(139,	'Changgally',	'84473168995',	'Artificial Intelligence is able to create videos. \r\nWhat you think is the first use of that? \r\nOf course, Porn. Are you curious to check it out? \r\nIs free. https://hentai.movie',	'2024-02-18 00:42:24',	'2024-02-18 00:42:24');

DROP TABLE IF EXISTS `videoes`;
CREATE TABLE `videoes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `video` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `video_id` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cover` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) NOT NULL,
  `album_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `videoes` (`id`, `name`, `video`, `video_id`, `cover`, `description`, `status`, `album_id`, `created_at`, `updated_at`) VALUES
(1,	'NAIL DRESSING - NAIL CUTTING',	'<iframe width=\"560\" height=\"315\" src=\"https://www.youtube.com/embed/WWoQXggVPCQ\" title=\"YouTube video player\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" allowfullscreen></iframe>',	'WWoQXggVPCQ',	'/02-589a8c5f-b8f1-4b9b-9751-d142d0218148.jpg',	NULL,	1,	3,	'2023-04-25 07:51:34',	'2023-04-27 12:42:05'),
(2,	'ទស្សនីយភាពសកម្មភាពពិសេសៗក្នុងការសិក្សាលើ វគ្គ 𝐒𝐚𝐥𝐨𝐧 𝐌𝐚𝐧𝐚𝐠𝐞𝐦𝐞𝐧𝐭',	'https://youtu.be/YFxfybMKD6o',	'YFxfybMKD6o',	'/d9ig571626490656946IMG_0102-0028cc1b-c91d-4ca1-93a9-43b1d1857b55-5f75ec50-c6a5-492a-b057-9f02e86abe94.jpg',	NULL,	1,	5,	'2023-04-27 03:13:21',	'2023-04-27 12:41:46'),
(3,	'How to help prevent scalp irritation with the NEW',	'<iframe width=\"560\" height=\"315\" src=\"https://www.youtube.com/embed/moNOf8UvWLE\" title=\"YouTube video player\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" allowfullscreen></iframe>',	'moNOf8UvWLE',	'/h2-96386b69-c987-47a9-99c0-fb3edbeb04ab.jpg',	NULL,	1,	5,	'2023-04-27 03:15:13',	'2023-04-27 12:41:25'),
(4,	'បទសម្ភាសន៍រវាង លោកស្រី ពុយ គ្រូបង្គោលនៃសាលា LICE ក៏ដូចជាម្ចាស់ PUY Salon ជាមួយ កញ្ញា Ya SoPhan Mai',	'<iframe width=\"560\" height=\"315\" src=\"https://www.youtube.com/embed/6HdCCM_huY4\" title=\"YouTube video player\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" allowfullscreen></iframe>',	'6HdCCM_huY4',	'/h3-862f1872-a196-41dd-8fe8-5eebe7f50f4c.jpg',	NULL,	1,	5,	'2023-04-27 03:16:26',	'2023-04-27 12:40:52'),
(5,	'វីដេអូក្រោយបញ្ចប់វគ្គបណ្តុះបណ្តាល 𝐀𝐒𝐊 by 𝐖𝐈𝐖𝐀𝐓 𝐊𝐀𝐒𝐄𝐌𝐀𝐌𝐎𝐑𝐍',	'https://youtu.be/qt6NuhBqm5g',	'qt6NuhBqm5g',	'/DSC05021-48a01729-590b-42d3-afa0-f46eb8e203df.jpg',	NULL,	1,	6,	'2023-04-27 03:16:52',	'2024-02-14 09:57:28'),
(6,	'វីដេអូ ក្រោយបញ្ចប់វគ្គបណ្តុះបណ្តាល 𝐀𝐒𝐊',	'https://youtu.be/ExRGJAzoWuM',	'ExRGJAzoWuM',	'/DSC06175-4f528e94-9c1a-421e-a1c2-7f431e737a06.jpg',	NULL,	1,	6,	'2023-04-27 03:17:33',	'2024-02-14 09:54:09'),
(7,	'វីដេអូ ក្រោយបញ្ចប់វគ្គបណ្តុះបណ្តាល 𝐀𝐒𝐊 | យុទ្ធសាស្រ្ដរចនាបទអ៊ុតរួញត្រជាក់- Essential Cold Perm',	'https://youtu.be/UgVPai0yOjs',	'UgVPai0yOjs',	'/DSC06175-4f528e94-9c1a-421e-a1c2-7f431e737a06.jpg',	NULL,	1,	3,	'2023-04-27 03:18:02',	'2024-02-14 09:55:14');

DROP TABLE IF EXISTS `work_days`;
CREATE TABLE `work_days` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `day` varchar(125) COLLATE utf8mb4_unicode_ci NOT NULL,
  `from_hour` time NOT NULL,
  `to_hour` time NOT NULL,
  `status` tinyint(4) NOT NULL,
  `order` tinyint(4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `work_days` (`id`, `day`, `from_hour`, `to_hour`, `status`, `order`, `created_at`, `updated_at`) VALUES
(1,	'Tuesday',	'08:00:00',	'18:00:00',	1,	2,	'2023-04-25 04:22:53',	'2023-04-28 12:30:30'),
(2,	'Monday',	'08:00:00',	'18:00:00',	1,	1,	'2023-04-27 04:00:37',	'2023-04-28 12:30:14'),
(3,	'Wednesday',	'08:00:00',	'18:00:00',	1,	3,	'2023-04-27 04:03:14',	'2023-04-27 04:03:14'),
(4,	'Thursday',	'08:00:00',	'18:00:00',	1,	4,	'2023-04-27 04:05:54',	'2023-04-27 04:05:54'),
(5,	'Friday',	'08:00:00',	'18:00:00',	1,	5,	'2023-04-27 04:08:54',	'2023-04-27 04:08:54'),
(6,	'Saturday',	'08:00:00',	'18:00:00',	1,	6,	'2023-04-27 04:09:16',	'2023-04-27 04:09:16'),
(7,	'Sunday',	'08:00:00',	'18:00:00',	1,	7,	'2023-04-27 04:09:32',	'2023-04-27 04:09:32');

-- 2024-02-18 22:17:19
