<?php

namespace App\Services;

use App\Models\About;
use App\Models\AboutChild;
use App\Models\Album;
use App\Models\Contact;
use App\Models\Course;
use App\Models\Cover;
use App\Models\Gallery;
use App\Models\Partner;
use App\Models\Qoute;
use App\Models\Question;
use App\Models\Slide;
use App\Models\Trainer;
use App\Models\TrainingVideo;
use App\Models\TrainingVideoCategory;
use App\Models\Video;
use App\Models\WorkDay;
use Illuminate\Support\Facades\Log;

class WebsiteService
{
    private $service, $active;
    public function __construct()
    {
        $this->service  = new QueryService();
        $this->active   = config('dummy.status.active');
    }

    // get slider with multiple records
    public function querySliderWithMultipleRecords()
    {
        Log::info("Start WebsiteService > querySliderWithMultipleRecords | payload: ");
        try {
            return $this->service->queryCollectionWithMultipleRecords(Slide::query(), $this->active, "id:desc")->get();

        } catch (\Exception $e) {
            Log::error("Error WebsiteService > querySliderWithMultipleRecords | payload: " . $e->getMessage());
        }
    }

    // get testimonial with multiple records
    public function queryTestimonialWithMultipleRecords()
    {
        Log::info("Start WebsiteService > queryTestimonialWithMultipleRecords | payload: ");
        try {
            return $this->service->queryCollectionWithMultipleRecords(Qoute::query(), $this->active, "id:desc")->get();

        } catch (\Exception $e) {
            Log::error("Error WebsiteService > queryTestimonialWithMultipleRecords | payload: " . $e->getMessage());
        }
    }

    // get video with multiple records
    public function queryVideoWithMultipleRecords($notInIds = [], $perPage = null)
    {
        Log::info("Start WebsiteService > queryVideoWithMultipleRecords | payload: ");
        try {
            return $this->service->queryCollectionWithMultipleRecords(Video::query(), $this->active, "id:desc")
                ->when(request()->has('search'), function ($query) {
                    $column = ['name'];
                    $query->where(function ($query) use ($column) {
                        foreach ($column as $item) {
                            $query->orWhere($item, 'like', '%' . request()->search . '%');
                        }
                    });
                })   
                ->when($notInIds, function ($query) use ($notInIds) {
                    $query->whereNotIn('id', $notInIds);
                })
                ->when(!$perPage, function ($query) {
                    return $query->get();
                })
                ->when($perPage, function ($query) use ($perPage) {
                    return $query->paginate($perPage);
                });

        } catch (\Exception $e) {
            Log::error("Error WebsiteService > queryVideoWithMultipleRecords | payload: " . $e->getMessage());
        }
    }

    // get course with multiple records
    public function queryCourseWithMultipleRecords($perPage = null)
    {
        Log::info("Start WebsiteService > queryCourseWithMultipleRecords | payload: ");
        try {
            return $this->service->queryCollectionWithMultipleRecords(Course::with('trainer'), $this->active, "id:desc")
                ->when(request()->has('search'), function ($query) {
                    $column = ['name'];
                    $query->where(function ($query) use ($column) {
                        foreach ($column as $item) {
                            $query->orWhere($item, 'like', '%' . request()->search . '%');
                        }
                    });
                })
                ->when(!$perPage, function ($query) {
                    return $query->get();
                })
                ->when($perPage, function ($query) use ($perPage) {
                    return $query->paginate($perPage);
                });

        } catch (\Exception $e) {
            Log::error("Error WebsiteService > queryCourseWithMultipleRecords | payload: " . $e->getMessage());
        }
    }

    // get partner with multiple records
    public function queryPartnerWithMultipleRecords($perPage = null)
    {
        Log::info("Start WebsiteService > queryPartnerWithMultipleRecords | payload: ");
        try {
            return $this->service->queryCollectionWithMultipleRecords(Partner::query(), $this->active, "id:desc")
                ->when(request()->has('search'), function ($query) {
                    $column = ['name'];
                    $query->where(function ($query) use ($column) {
                        foreach ($column as $item) {
                            $query->orWhere($item, 'like', '%' . request()->search . '%');
                        }
                    });
                })
                ->when(!$perPage, function ($query) {
                    return $query->get();
                })
                ->when($perPage, function ($query) use ($perPage) {
                    return $query->paginate($perPage);
                });

        } catch (\Exception $e) {
            Log::error("Error WebsiteService > queryPartnerWithMultipleRecords | payload: " . $e->getMessage());
        }
    }

    // get FAQ with multiple records
    public function queryFaqWithMultipleRecords()
    {
        Log::info("Start WebsiteService > queryFaqWithMultipleRecords | payload: ");
        try {
            return $this->service->queryCollectionWithMultipleRecords(Question::query(), $this->active, "id:desc")->get();

        } catch (\Exception $e) {
            Log::error("Error WebsiteService > queryFaqWithMultipleRecords | payload: " . $e->getMessage());
        }
    }

    // get trainer with multiple records
    public function queryTrainerWithMultipleRecords($type, $perPage = null)
    {
        Log::info("Start WebsiteService > queryTrainerWithMultipleRecords | payload: ");
        try {
            return $this->service->queryCollectionWithMultipleRecords(Trainer::query(), $this->active, "id:desc")
                        ->when($type, function ($query) use ($type) {
                            return $query->wherePosition($type);
                        })
                        ->when(!$perPage, function ($query) {
                            return $query->get();
                        })
                        ->when($perPage, function ($query) use ($perPage) {
                            return $query->paginate($perPage);
                        });

        } catch (\Exception $e) {
            Log::error("Error WebsiteService > queryTrainerWithMultipleRecords | payload: " . $e->getMessage());
        }
    }

    // get about us with single record
    public function queryAboutUsWithSingleRecord()
    {
        Log::info("Start WebsiteService > queryAboutUsWithSingleRecord | payload: ");
        try {
            return $this->service->queryCollectionWithSingleRecord(About::query(), $this->active, "");

        } catch (\Exception $e) {
            Log::error("Error WebsiteService > queryAboutUsWithSingleRecord | payload: " . $e->getMessage());
        }
    }

    // get about us history with multiple records
    public function queryAboutUsHistoryWithMultipleRecords()
    {
        Log::info("Start WebsiteService > queryAboutUsHistoryWithMultipleRecords | payload: ");
        try {
            return $this->service->queryCollectionWithMultipleRecords(AboutChild::query(), $this->active, "id:desc")->get();

        } catch (\Exception $e) {
            Log::error("Error WebsiteService > queryAboutUsHistoryWithMultipleRecords | payload: " . $e->getMessage());
        }
    }

    // get work day with multiple records
    public function queryWorkDayWithMultipleRecords()
    {
        Log::info("Start WebsiteService > queryWorkDayWithMultipleRecords | payload: ");
        try {
            return $this->service->queryCollectionWithMultipleRecords(WorkDay::query(), $this->active, "id:asc")->get();

        } catch (\Exception $e) {
            Log::error("Error WebsiteService > queryWorkDayWithMultipleRecords | payload: " . $e->getMessage());
        }
    }

    // get contact us with single record
    public function queryContactUsWithSingleRecord()
    {
        Log::info("Start WebsiteService > queryContactUsWithSingleRecord | payload: ");
        try {
            return $this->service->queryCollectionWithSingleRecord(Contact::query(), $this->active, "");

        } catch (\Exception $e) {
            Log::error("Error WebsiteService > queryContactUsWithSingleRecord | payload: " . $e->getMessage());
        }
    }

    // get training video by category with multiple records
    public function queryTrainingVideoByCategoryWithMultipleRecords()
    {
        Log::info("Start WebsiteService > queryTrainingVideoByCategoryWithMultipleRecords | payload: ");
        try {
            $categories = $this->service->queryCollectionWithMultipleRecords(TrainingVideoCategory::query(), $this->active, "id:desc")->get();
            $categories->map(function ($category) {
                $category->videos = $this->service->queryCollectionWithMultipleRecords(TrainingVideo::query(), $this->active, "id:desc")
                    ->whereCategoryId($category->id)
                    ->get();
            });

            return $categories;

        } catch (\Exception $e) {
            Log::error("Error WebsiteService > queryTrainingVideoByCategoryWithMultipleRecords | payload: " . $e->getMessage());
        }
    }

    // get gallery by album with multiple records
    public function queryGalleryByAlbumWithMultipleRecords($type = null, $perPage = null, $notInId = [])
    {
        Log::info("Start WebsiteService > queryGalleryByAlbumWithMultipleRecords | payload: ");
        try {
            return $this->service->queryCollectionWithMultipleRecords(Album::query(), $this->active, "id:desc")
                            ->when($type, function ($query) use ($type) {
                                $query->whereAlbumType($type);
                            })
                            ->when($notInId, function ($query) use ($notInId) {
                                $query->whereNotIn('id', $notInId);
                            })
                            ->when(!$perPage, function ($query) {
                                return $query->get();
                            })
                            ->when($perPage, function ($query) use ($perPage) {
                                return $query->paginate($perPage);
                            });

        } catch (\Exception $e) {
            Log::error("Error WebsiteService > queryGalleryByAlbumWithMultipleRecords | payload: " . $e->getMessage());
        }
    }

    // get gallery detail by id with multiple records
    public function queryGalleryDetailByIdWithMultipleRecords($id)
    {
        Log::info("Start WebsiteService > queryGalleryDetailByIdWithMultipleRecords | payload: ");
        try {
            $album = $this->service->queryCollectionWithSingleRecord(Album::query(), $this->active, "id:$id");
            $galleries = $this->service->queryCollectionWithMultipleRecords(Gallery::query(), $this->active, "id:desc")
                ->whereAlbumId($album->id)
                ->get();

            return [
                'album'     => $album ?? null,
                'galleries' => $galleries ?? null
            ];

        } catch (\Exception $e) {
            Log::error("Error WebsiteService > queryGalleryDetailByIdWithMultipleRecords | payload: " . $e->getMessage());
        }
    }

    // get gallery video detail by id with multiple records
    public function queryGalleryVideoDetailByIdWithMultipleRecords($id)
    {
        Log::info("Start WebsiteService > queryGalleryVideoDetailByIdWithMultipleRecords | payload: ");
        try {
            $album = $this->service->queryCollectionWithSingleRecord(Album::query(), $this->active, "id:$id");
            $videos = $this->service->queryCollectionWithMultipleRecords(Video::query(), $this->active, "id:desc")
                ->whereAlbumId($album->id)
                ->get();

            return [
                'album'  => $album ?? null,
                'videos' => $videos ?? null
            ];

        } catch (\Exception $e) {
            Log::error("Error WebsiteService > queryGalleryVideoDetailByIdWithMultipleRecords | payload: " . $e->getMessage());
        }
    }

    // get home cover with single record
    public function queryCoverWithSingleRecord($type)
    {
        Log::info("Start WebsiteService > queryHomeCoverWithSingleRecord | payload: ");
        try {
            return Cover::query()
                ->when($type, function ($query) use ($type) {
                    return $query->whereType($type);
                })
                ->first();
        } catch (\Exception $e) {
            Log::error("Error WebsiteService > queryHomeCoverWithSingleRecord | payload: " . $e->getMessage());
        }
    }
}