<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Passport\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, HasRoles;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'branch_id',
        'username',
        'profile',
        'gender',
        'email',
        'phone',
        'password',
        'status',
        'role',
        'noted',
        'remember_token'
    ];

    protected $appends = ['image_url'];
    public function getImageUrlAttribute()
    {
        if ($this->profile != null) {
            return url('file_manager' . $this->profile);
        }
        return null;
    }

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
     public function classes()
    {
        return $this->belongsToMany(Classes::class, 'class_allow_users', 'user_id', 'class_id')->withTimestamps();
    }

    public function ModelHasPermission()
    {
        return $this->hasMany(ModelHasPermission::class, "model_id");
    }
    
    public function branch()
    {
        return $this->belongsTo(Branch::class, 'branch_id');
    }
}
