<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StudyScore extends Model
{
    use HasFactory;
    protected $table = 'study_scores';
    protected $fillable = [
        'generic_score',
        'functional_score',
        'competency',
        'status',
        'user_id',
    ];
    
    public function user(){
        return $this->belongsTo(User::class, 'user_id');
    }
}
