<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class StudentLessonScore extends Model
{
    use HasFactory;
    protected $table = 'student_lesson_scores';
    protected $fillable = [
        'class_id',
        'student_id',
        'lesson_id',
        'exam_answer_sheet_id',
    ];
    
    
    public function exam_answer_sheet()
    {
        return $this->belongsTo(ExamAnswerSheet::class, 'exam_answer_sheet_id');
    }
    public function lesson()
    {
        return $this->belongsTo(Lesson::class, 'lesson_id');
    }
}   
