<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StudentInternPlace extends Model
{
    use HasFactory;
    protected $table = 'student_intern_places';
    protected $fillable = [
        'student_id',
        'internship_place_id',
        'start_date',
        'is_intern_pass',
        'class_id',
    ];
    public function student()
    {
        return $this->belongsTo(Student::class, 'student_id');
    }

    public function classes()
    {
        return $this->belongsTo(Classes::class, 'class_id');
    }

    public function internship_place()
    {
        return $this->belongsTo(InternshipPlace::class, 'internship_place_id');
    }
}
