<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StructureProgram extends Model
{
    use HasFactory;

    protected $table = 'structure_programs';
    protected $fillable = [
        'class_occupation_id',
        'lesson_id',
        'description',
        'user_id',
    ];
    protected $casts = [
        'lesson_id' => 'array',
    ];

    public function class_structure_program()
    {
        return $this->hasOne(ClassStructureProgram::class, 'structure_program_id');
    }

    public function class_occupation()
    {
        return $this->belongsTo(ClassOccupation::class, 'class_occupation_id');
    }
    
    public function user(){
        return $this->belongsTo(User::class, 'user_id');
    }

}
