<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class StaffType extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'staff_types';
    protected $fillable = [
        'name',
        'status',
    ];
    public function staffs()
    {
        return $this->hasMany(StaffType::class, 'staff_type_id');
    }
}
