<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Lesson extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'lessons';
    protected $fillable = [
        'lesson_occupation_id',
        'competency_type',
        'name',
        'short_name',
        'practice_hour',
        'practice_duration_type',
        'theory_hour',
        'theory_duration_type',
        'status',
        'document',
        'video',
        'user_id'
    ];
    public function occupation()
    {
        return $this->belongsTo(LessonOccupation::class, 'lesson_occupation_id');
    }

    public function attendance()
    {
        return $this->hasMany(Attendance::class, 'lesson_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function documents()
    {
        return $this->hasMany(LessonDocument::class, 'lesson_id');
    }
}