<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InternshipPlace extends Model
{
    use HasFactory;
    protected $table = 'internship_places';
    protected $fillable = [
        'place_name',
        'location',
        'contact_number',
        'user_id',
    ];
    public function student_intern_places()
    {
        return $this->hasMany(StudentInternPlace::class, 'internship_place_id');
    }
    
    public function user(){
        return $this->belongsTo(User::class, 'user_id');
    }
}
