<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Gallery extends Model
{
    use HasFactory;
    protected $table = 'galleries';
    protected $fillable = [
        'name',
        'image',
        'description',
        'status',
        'album_id',
    ];

    public function album()
    {
        return $this->belongsTo(Album::class, 'album_id');
    }
}
