<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ExamSubject extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'exam_subjects';
    protected $fillable = [
        'class_id',
        'exam_id',
        'sheet_issuer_id',
        'description',
        'google_doc_url',
    ];

    public function staff()
    {
        return $this->belongsTo(Staff::class, 'sheet_issuer_id');
    }
    public function classes()
    {
        return $this->belongsTo(Classes::class, 'class_id');
    }
    public function exam_control()
    {
        return $this->belongsTo(ExamControl::class, 'exam_id');
    }
    public function exam_answer_sheets()
    {
        return $this->hasMany(ExamAnswerSheet::class, 'exam_subject_id');
    }
}
