<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ExamControl extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'exam_controls';
    protected $fillable = [
        'class_id',
        'exam_type_id',
        'exam_date',
        'duration',
        'noted',
    ];

    public function exam_type()
    {
        return $this->belongsTo(ExamType::class, 'exam_type_id');
    }
    public function exam_subjects()
    {
        return $this->hasMany(ExamSubject::class, 'exam_id');
    }
    public function exam_candidates()
    {
        return $this->hasMany(ExamCandidate::class, 'exam_id');
    }
    public function classes()
    {
        return $this->belongsTo(Classes::class, 'class_id');
    }
}
