<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ExamAnswerSheet extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'exam_answer_sheets';
    protected $fillable = [
        'class_id',
        'exam_subject_id',
        'exam_candidate_id',
        'acquired_score',
        'answer_sheet',
    ];
    
     public function exam_candidate()
    {
        return $this->belongsTo(ExamCandidate::class, 'exam_candidate_id');
    }
    public function exam_subject()
    {
        return $this->belongsTo(ExamSubject::class, 'exam_subject_id');
    }
        public function student_lesson_score()
    {
        return $this->hasOne(StudentLessonScore::class, 'exam_answer_sheet_id');
    }
}
