<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ClassStructureProgram extends Model
{
    use HasFactory;
    protected $table = 'class_structure_programs';
    protected $fillable = [
        'class_id',
        'structure_program_id',
        'generic_full_score',
        'functional_full_score',
        'generic_subject',
        'functional_subject',
        'each_generic_score',
        'each_functional_score',
        'user_id',
    ];

    public function classes()
    {
        return $this->belongsTo(Classes::class, 'class_id');
    }

    public function structure_program()
    {
        return $this->belongsTo(StructureProgram::class, 'structure_program_id');
    }
    
    public function user(){
        return $this->belongsTo(User::class, 'user_id');
    }
}
