<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ClassImage extends Model
{
    use HasFactory;
    protected $table = 'class_images';
    protected $fillable = [
        'class_id',
        'image',
        'image_date',
        'image_description',
    ]; 
    public function classes()
    {
        return $this->belongsToMany(Classes::class, 'class_id');
    }
}
