<?php

namespace App\Http\Requests\Website;

use Illuminate\Foundation\Http\FormRequest;

class SignUpRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        $id = auth('web')->user()->id ?? '';        

        return [
            'name'                      => 'required|string|max:125',
            'email'                     => 'required|string|unique:students,email,'. $id,
            'phone'                     => 'required|string|unique:students,phone,'. $id,
            'password'                  => 'required|string|min:6|max:20',
            'confirm_password'          => 'required|string|same:password',
            'profile'                   => $this->profile || $this->tmp_profile ? 'image|mimes:jpeg,png,jpg,gif,svg|max:2048' : 'nullable',
            'checkbox'                  => 'required',
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array<string, string>
     */

    public function messages()
    {
        return [
            'name.required' => 'Please input this field',
            'email.required' => 'Please input this field',
            'email.unique' => 'This email already exists',
            'email.email' => 'Please input a valid email address',
            'phone.required' => 'Please input this field',
            'phone.unique' => 'This phone number already exists',
            'password.required' => 'Please input this field',
            'password.min' => 'Password must be at least 6 characters',
            'password.max' => 'Password must be at most 20 characters',
            'confirm_password.required' => 'Please input this field',
            'confirm_password.same' => 'Password and Confirm Password does not match',
            'checkbox.required' => 'Please accept this policy',
        ];
    }
}