<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class UserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        $acceptedId = $this->id ?? '';
        return [
            'name'              => 'required|max:150|string',
            'phone'             => 'required|unique:users,phone,' . $acceptedId,
            'email'             => 'required|email|unique:users,email,' . $acceptedId,
            'password'          => $acceptedId ? 'nullable': 'required|min:6|max:20',
            'confirm_password'  => $acceptedId ? 'nullable': 'required|min:6|max:20|same:password',
            'branch_id'         => 'required|integer',
        ];
    }
    public function messages()
    {
        return [
            'name.required'             => 'Name is required',
            'name.max'                  => 'Name is too long',
            'name.string'               => 'Name must be string',
            'phone.required'            => 'Phone is required',
            'phone.integer'             => 'Phone must be integer',
            'phone.unique'              => 'Phone is already exists',
            'email.required'            => 'Email is required',
            'email.email'               => 'Email is invalid',
            'email.unique'              => 'Email is already exists',
            'password.required'         => 'Password is required',
            'password.min'              => 'Password is too short',
            'password.max'              => 'Password is too long',
            'password.confirmed'        => 'Password is not match',
            'confirm_password.required' => 'Confirm password is required',
            'confirm_password.min'      => 'Confirm password is too short',
            'confirm_password.max'      => 'Confirm password is too long',
            'confirm_password.same'     => 'Confirm password is not match',
            'branch_id.required'        => 'Branch is required',
            'branch_id.integer'         => 'Branch must be integer',
            'image.required'            => 'Image is required',
        ];
    }
}