<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class WebsiteGuard
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        if (auth('web')->check()) {
            if (auth('web')->user()->role != 'student') {
                auth('web')->logout();
                return redirect()->route('website-auth-sign-in', ['returnUrl' => $request->url()]);
            }

            return $next($request);
        }

        return redirect()->route('website-auth-sign-in', ['returnUrl' => $request->url()]);
    }
}