<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\WebsiteBaseController;

class HomeController extends WebsiteBaseController
{
    protected $layout = 'website::pages.';

    public function onHome()
    {       
        try {
            $data['slider']         = $this->websiteService->querySliderWithMultipleRecords();
            $data['quote']          = $this->websiteService->queryTestimonialWithMultipleRecords();
            $data['intro_video']    = $this->websiteService->queryVideoWithMultipleRecords([],3);
            $data['courses']        = $this->websiteService->queryCourseWithMultipleRecords(3);
            $data['partners']       = $this->websiteService->queryPartnerWithMultipleRecords(4);
            $data['about']          = $this->websiteService->queryAboutUsWithSingleRecord();
            $data['questions']      = $this->websiteService->queryFaqWithMultipleRecords();
            $data['cover']          = $this->websiteService->queryCoverWithSingleRecord('home');
            
            $data['totalPartners']       = $this->websiteService->queryPartnerWithMultipleRecords()->count();
            $data['totalInternational']  = $this->websiteService->queryPartnerWithMultipleRecords()
                                            ->where('international',1)
                                            ->count();
            $data['totalTrainers']       = $this->websiteService->queryTrainerWithMultipleRecords(config('dummy.trainer_type.trainer'))
                                            ->where('certified',1)
                                            ->count();

            return view($this->layout .'home', $data);
            
        } catch (\Exception $e) {
            return abort(403, $this->abort);
        }
    }
}