<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\WebsiteBaseController;
use App\Http\Requests\Website\CourseRegisterRequest;
use App\Models\Course;
use App\Models\User;

class CourseController extends WebsiteBaseController
{
    protected $layout = 'website::pages.course.';

    public function onIndex()
    {
        try{
            $data['slider']         = $this->websiteService->querySliderWithMultipleRecords();
            $data['courses']        = $this->websiteService->queryCourseWithMultipleRecords();
            $data['trainers']       = $this->websiteService->queryTrainerWithMultipleRecords(config('dummy.trainer_type.trainer'));
            $data['professionals']  = $this->websiteService->queryTrainerWithMultipleRecords(config('dummy.trainer_type.professional'));

            return view($this->layout. 'index', $data);

        } catch (\Exception $e) {
            return abort(403, $this->abort);
        }
        
    }

    public function onTrainer()
    {
        try{
            $data['trainers']   = $this->websiteService->queryTrainerWithMultipleRecords(config('dummy.trainer_type.trainer'),9);

            return view($this->layout. 'trainer', $data);
        } catch (\Exception $e) {
            return abort(403, $this->abort);
        }
        
    }

    public function onSearch()
    {
        try{
            $data['courses'] = $this->websiteService->queryCourseWithMultipleRecords(10);

            return view($this->layout. 'search', $data);

        } catch (\Exception $e) {
            return abort(403, $this->abort);
        }
    }

    public function onRegister(CourseRegisterRequest $request)
    {
        try {
            return response()->json([
                'status'   => true,
                'error'    => false,
                'message'  => 'Course register success',
            ]);
            
        } catch (\Exception $e) {
            return response()->json([
                'status'   => false,
                'error'    => true,
                'message'  => $e->getMessage(),
            ]);
        } 
    }
}