<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Support\Facades\Auth;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    public $userBranch, $active, $isRoleSuperAdmin, $isRoleUser, $isRoleAdmin, $isRoleTeacher;
    public function __construct()
    {
        $this->active           = config('dummy.status.active');
        $this->isRoleSuperAdmin = config('dummy.user.role.super_admin');
        $this->isRoleUser       = config('dummy.user.role.user');
        $this->isRoleAdmin      = config('dummy.user.role.admin');
        $this->isRoleTeacher    = config('dummy.user.role.teacher');

        $this->middleware(function ($request, $next) {
            if (Auth::check()) {
                $user = User::with('branch')
                        ->whereId(Auth::user()->id)
                        ->whereStatus($this->active)
                        ->whereNotIn('role', [$this->isRoleSuperAdmin])
                        ->first();

                $this->userBranch = $user?->branch ?? null;
                
            }
            return $next($request);
        });
    }
}
