<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\UserFeedback;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;

class UserFeedbackController extends Controller
{
    protected $layout = 'admin::pages.userFeedback.';
    function __construct()
    {
        $this->middleware('permission:user-feedback-view', ['only' => ['index']]);
    }
    public function index(Request $req)
    {
        if (!$req->id) {
            return redirect()->route('admin-user-feedback-list', 1);
        }
        $data['data'] = UserFeedback::when(filled(request('search')), function ($q) {
            $q->where(function ($q) {
                $q->where('name', 'like', '%' . request('search') . '%');
            });
        })
            ->orderByDesc("id")
            ->paginate(50);
        return view($this->layout . 'index', $data);
    }

    public function onShow(Request $req)
    {
        $data['data'] = UserFeedback::findOrFail($req->id);

        return view($this->layout . 'detail', $data);
    }
}
