<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\TrainingVideo;
use App\Models\TrainingVideoCategory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;

class TrainingVideoController extends Controller
{
    protected $layout = 'admin::pages.trainingVideo.';
    function __construct()
    {
        $this->middleware('permission:training-video-view', ['only' => ['index']]);
        $this->middleware('permission:training-video-create', ['only' => ['onCreate', 'onSave']]);
        $this->middleware('permission:training-video-update', ['only' => ['onSave', 'onUpdateStatus']]);
    }
    public function index(Request $req)
    {
        if (!$req->id) {
            return redirect()->route('admin-training-video-list', 1);
        }
        $data['data'] = TrainingVideo::when(filled(request('search')), function ($q) {
            $q->where(function ($q) {
                $q->where('name', 'like', '%' . request('search') . '%');
                $q->orWhere('description', 'like', '%' . request('search') . '%');
            });
        })
            ->where('status', $req->id)
            ->orderByDesc("id")
            ->paginate(50);
        return view($this->layout . 'index', $data);
    }
    public function onCreate(Request $req)
    {
        $data['categories'] = TrainingVideoCategory::where('status', 1)->get();
        if ($req->id) {
            $data['data'] = TrainingVideo::find($req->id);
            return view($this->layout . 'create', $data);
        } else {
            return view($this->layout . 'create', $data);
        }
    }
    public function onSave(Request $req)
    {
        $id = $req->id;
        $req->validate(
            [
                'video' => 'required',
                'name' => 'required',
                'category_id' => 'required',
            ],
            [
                'video.required' => 'field is require',
                'name.required' => 'field is require',
                'category_id.required' => 'field is require',
            ]
        );
        $items = [
            'video' => $req->video,
            'video_id' => $req->video_id,
            'name' => $req->name,
            'cover' => $req->image ?? $req->tmp_file,
            'description' => $req->description,
            'category_id' => $req->category_id,
            'status' => $req->status ?? 1,
        ];
        DB::beginTransaction();
        try {
            if ($id) {
                TrainingVideo::findOrFail($id)->update($items);
                $status = "Update success.";
            } else {
                TrainingVideo::create($items);
                $status = "Create success";
            }
            DB::commit();
            Session::flash('success', $status);
            return redirect()->route('admin-training-video-list', 1);
        } catch (\Exception $e) {
            dd($e);
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
            return redirect()->back();
        }
    }

    public function onUpdateStatus(Request $req)
    {
        $status = true;
        $item = [
            "status" => $req->status,
        ];
        DB::beginTransaction();
        try {
            $status = $req->status == 2 ? "Disable successful!" : "Enable successful!";
            TrainingVideo::where("id", $req->id)->update($item);
            DB::commit();
            Session::flash("success", $status);
        } catch (\Exception $error) {
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
        }
        return redirect()->back();
    }
}
