<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\StaffType;
use App\Models\StudyScore;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Exception;
use App\Models\Staff;

class StudyScoreController extends Controller
{
    protected $layout = 'admin::pages.studyScore.';
   public function __construct()
    {
        parent::__construct();
        $this->middleware('permission:study-score-view', ['only' => ['index']]);
        $this->middleware('permission:study-score-create', ['only' => ['onCreate', 'onSave']]);
        $this->middleware('permission:study-score-update', ['only' => ['onCreate', 'onSave', 'onUpdateStatus']]);
    }
    public function index(Request $req)
    {

        if (!$req->id) {
            return redirect()->route('admin-study-score-list', 1);
        }
        $data['study_score'] = StudyScore::all();
        $data['data'] = StudyScore::when(filled(request('keyword')), function ($q) {
            $q->where(function ($q) {
                    $q->where('generic_score', 'like', '%' . request('keyword') . '%');
                    $q->orWhere('functional_score', 'like', '%' . request('keyword') . '%');
                });
            })
            ->when($this->userBranch, function ($q) {
                $q->whereHas('user', function ($q) {
                    $q->where('branch_id', $this->userBranch->id);
                });
            })
            ->where("status", $req->id)
            ->orderByDesc("id")
            ->paginate(50);


        return view($this->layout.'index', $data);
    }
    public function onCreate(Request $req)
    {
        $data["data"] = StudyScore::find($req->id);
//        $data['study_score'] = StudyScore::where('status',1)->get();
        return view($this->layout.'create', $data);
    }

    public function onSave(Request $req)
    {
        $id = $req->id;
        $item = [
            "generic_score" => $req->generic_score,
            "functional_score" => $req->functional_score,
            "competency" => $req->competency,
            "user_id" => auth()->user()->id,
        ];

        $status = "Create success.";
        DB::beginTransaction();
        try {
            if (!$id) {
                StudyScore::create($item);
            } else {
                StudyScore::find($id)->update($item);
                $status = "Update success.";
            }
            DB::commit();
            Session::flash("success", $status);
            return redirect()->route("admin-study-score-list", 1);
        } catch (Exception $error) {
            dd($error);
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
            return redirect()->back();

        }
    }
    public function onUpdateStatus(Request $req)
    {
        $status = true;
        $item = [
            "status" => $req->status,
        ];
        DB::beginTransaction();
        try {
            $status = $req->status == 2 ? "Disable successful!" : "Enable successful!";
            StudyScore::where("id", $req->id)->update($item);
            DB::commit();
            Session::flash("success", $status);
        } catch (Exception $error) {
            Session::flash('warning', 'Create unsuccess!');
        }
        return redirect()->back();
    }
}
