<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Classes;
use App\Models\Student;
use App\Models\InternshipPlace;
use App\Models\StudentInternPlace;
use Exception;
use Illuminate\Support\Facades\Session;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class StudentInternPlaceController extends Controller
{
    protected $layout = 'admin::pages.studentInternPlace.';
    public function __construct()
    {
        $this->middleware('permission:student-intern-place-view', ['only' => ['index']]);
        $this->middleware('permission:student-intern-place-create', ['only' => ['assign']]);
        $this->middleware('permission:student-intern-place-destroy', ['only' => ['unassign']]);
        $this->middleware('permission:student-intern-place-update', ['only' => ['onUpdateStatus']]);
    }
    public function index()
    {
        $data['data'] = Classes::findOrFail(request('class_id'))->students()->get();
        $data['class'] = Classes::find(request('class_id'))->first();
        $data['intern_place'] = InternshipPlace::with('student_intern_places')->get();
        $assign = StudentInternPlace::where('class_id', request('class_id'))->get();
        $data['count_assigned'] = count($assign);
        $data['count_unassign'] = count($data['data']) - $data['count_assigned'];

        return view($this->layout . 'index', $data);
    }

    public function assign()
    {
        $data['data'] = Student::findOrFail(request('student_id'));
        $item = [
            'student_id' => request('student_id'),
            'class_id' => request('class_id'),
            'internship_place_id' => request('internship_place_id'),
            'start_date' => (new Carbon(request('start_date')))->format('Y-m-d'),
            'is_intern_pass' => request('is_intern_pass')
        ];
        try {
            StudentInternPlace::create($item);
            DB::commit();
            return response()->json([
                "code" => 20000,
                "message" => "Assigned Success",
            ]);
        } catch (Exception $e) {
            DB::rollback();
            return response()->json([
                "code" => 40005,
                "message" => "Assigned Unsuccess!",
            ]);
        }
    }

    public function unassign()
    {
        $date = (new Carbon(request('start_date')))->format('Y-m-d');
        $data = StudentInternPlace::whereDate('start_date', $date)->where('student_id', request('student_id'))->where('class_id', request('class_id'))->first();
        $status = "Unassigned student intern place success.";
        try {
            $data->delete();
            DB::commit();
            Session::flash("success", $status);
            return redirect()->back();
        } catch (Exception $e) {
            DB::rollback();
            Session::flash("warning", "Unassined student intern place unsuccess!");
            return redirect()->back();
        }
    }

    public function onUpdateStatus(Request $req)
    {
        $status = true;
        $item = [
            "is_intern_pass" => $req->status,
        ];
        DB::beginTransaction();
        try {
            $status = $req->status == 0 ? "Assign failed successful!" : "Assign passed successful!";
            StudentInternPlace::where("id", $req->id)->update($item);
            DB::commit();
            Session::flash("success", $status);
        } catch (Exception $error) {
            Session::flash('warning', 'Assign unsuccess!');
        }
        return redirect()->back();
    }
}
